/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.certificationservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.certificationservice.HRCertificationBillCollection;
import com.kingdee.shr.certificationservice.HRCertificationBillFactory;
import com.kingdee.shr.certificationservice.HRCertificationBillInfo;
import com.kingdee.shr.certificationservice.HRCertificationBillTypeInfo;
import com.kingdee.shr.certificationservice.IHRCertificationBill;
import com.kingdee.shr.certificationservice.app.CertificateStatusEnum;
import com.kingdee.shr.elecontract.util.CloudHubPropertiesUtilsV2;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.util.SSCCloudHubMessageAPPUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.net.URLEncoder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificationUtil {
    private static final Logger logger = LoggerFactory.getLogger(CertificationUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LabContractFirstPartyInfo getLabContractFirstPartyInfo(Context ctx, PersonInfo person) throws BOSException, EASBizException {
        LabContractFirstPartyInfo labContractFirstPartyInfo = null;
        BOSUuid labContractFirstPartyId = null;
        if (person == null) return null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("employee", (Object)person.getId().toString()));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("labContractFirstParty"));
        selector.add(new SelectorItemInfo("state"));
        view.setSelector(selector);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("effectDate");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        EmployeeContractCollection contractColl = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(view);
        if (contractColl.size() <= 0) return null;
        for (int i = 0; i < contractColl.size(); ++i) {
            if (!contractColl.get(i).getNewState().equals((Object)EmployeeContractNewStateEnum.RECORDED)) continue;
            labContractFirstPartyId = contractColl.get(i).getLabContractFirstParty().getId();
            break;
        }
        if (labContractFirstPartyId != null) return LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(labContractFirstPartyId));
        labContractFirstPartyId = contractColl.get(0).getLabContractFirstParty().getId();
        return LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(labContractFirstPartyId));
    }

    public static HttpResultVo sendCertBillCloudHubMessage(Context ctx, HRCertificationBillTypeInfo certificationBillTypeInfo, HRCertificationBillInfo info) throws EASBizException, BOSException {
        String APPLY_SUC = null;
        if (2 == certificationBillTypeInfo.getBillType().getValue()) {
            String label1;
            APPLY_SUC = label1 = SHRServerResource.getString((String)"com.kingdee.shr.certificationservice.ShrCertificationserviceResource", (String)"label1", (Context)ctx);
        }
        if (1 == certificationBillTypeInfo.getBillType().getValue()) {
            String label2;
            APPLY_SUC = label2 = SHRServerResource.getString((String)"com.kingdee.shr.certificationservice.ShrCertificationserviceResource", (String)"label2", (Context)ctx);
        }
        if (3 == certificationBillTypeInfo.getBillType().getValue()) {
            String label3;
            APPLY_SUC = label3 = SHRServerResource.getString((String)"com.kingdee.shr.certificationservice.ShrCertificationserviceResource", (String)"label3", (Context)ctx);
        }
        if (4 == certificationBillTypeInfo.getBillType().getValue()) {
            String label4;
            APPLY_SUC = label4 = SHRServerResource.getString((String)"com.kingdee.shr.certificationservice.ShrCertificationserviceResource", (String)"label4", (Context)ctx);
        }
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        PersonInfo personInfo = info.getPerson();
        String label6 = SHRServerResource.getString((String)"com.kingdee.shr.certificationservice.ShrCertificationserviceResource", (String)"label6", (Context)ctx);
        if (!iUser.exists("where person.id = '" + personInfo.getId().toString() + "'")) {
            throw new EASBizException(new NumericExceptionSubItem("00", label6));
        }
        UserInfo userInfo = iUser.getUserInfo("where person.id = '" + personInfo.getId().toString() + "'");
        String url = "";
        String pubaccName = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"cert.pubaccName");
        String appid = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"cert.appid");
        boolean isPrivate = Boolean.parseBoolean(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"isPrivate"));
        if (2 == certificationBillTypeInfo.getBillType().getValue()) {
            url = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"empcert.lightApp.url");
            url = url + "&billId=" + URLEncoder.encode(info.getId().toString());
            logger.info("\u5728\u804c\u8bc1\u660e\u529e\u7406\u63d0\u4ea4\u6d88\u606f\u63a8\u9001: \u79c1\u6709\u4e91:" + isPrivate + " \u516c\u5171\u53f7:" + pubaccName + "appId:" + appid + " \u5e94\u7528\u5730\u5740:" + url);
        }
        if (1 == certificationBillTypeInfo.getBillType().getValue()) {
            url = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"incomecert.lightApp.url");
            url = url + "&billId=" + URLEncoder.encode(info.getId().toString());
            logger.info("\u6536\u5165\u8bc1\u660e\u529e\u7406\u63d0\u4ea4\u6d88\u606f\u63a8\u9001: \u79c1\u6709\u4e91:" + isPrivate + " \u516c\u5171\u53f7:" + pubaccName + "appId:" + appid + " \u5e94\u7528\u5730\u5740:" + url);
        }
        if (3 == certificationBillTypeInfo.getBillType().getValue()) {
            url = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"resigncert.lightApp.url");
            url = url + "&billId=" + URLEncoder.encode(info.getId().toString());
            logger.info("\u79bb\u804c\u8bc1\u660e\u529e\u7406\u63d0\u4ea4\u6d88\u606f\u63a8\u9001: \u79c1\u6709\u4e91:" + isPrivate + " \u516c\u5171\u53f7:" + pubaccName + "appId:" + appid + " \u5e94\u7528\u5730\u5740:" + url);
        }
        if (4 == certificationBillTypeInfo.getBillType().getValue()) {
            url = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"commoncert.lightApp.url");
            url = url + "&billId=" + URLEncoder.encode(info.getId().toString());
            logger.info("\u901a\u7528\u8bc1\u660e\u529e\u7406\u63d0\u4ea4\u6d88\u606f\u63a8\u9001: \u79c1\u6709\u4e91:" + isPrivate + " \u516c\u5171\u53f7:" + pubaccName + "appId:" + appid + " \u5e94\u7528\u5730\u5740:" + url);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("url", url);
        paramMap.put("pubaccName", pubaccName);
        paramMap.put("appid", appid);
        paramMap.put("isPrivate", isPrivate);
        return SSCCloudHubMessageAPPUtil.sendCloudHubMessage((Context)ctx, (UserInfo)userInfo, (String)APPLY_SUC, (String)"textLink", paramMap);
    }

    public static void ProcessingSucceededOrFailed(BatchMessageTipsBody body, HashMap<String, Integer> hashMap) {
        if (body.isMuitTipsState()) {
            int success = hashMap.get("success");
            hashMap.put("success", ++success);
        } else {
            int failure = hashMap.get("failure");
            hashMap.put("failure", ++failure);
        }
    }

    public static void abandonIssueHRCertificationBill(Context ctx, String billId) throws BOSException, EASBizException {
        IHRCertificationBill ihrCertificationBill = HRCertificationBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("certificationStatus"));
        view.setSelector(selector);
        HRCertificationBillCollection billBaseCollection = ihrCertificationBill.getHRCertificationBillCollection(view);
        if (billBaseCollection != null && billBaseCollection.size() > 0) {
            selector.clear();
            HRCertificationBillInfo billInfo = billBaseCollection.get(0);
            HRBillStateEnum billState = billInfo.getBillState();
            if (billState.equals((Object)HRBillStateEnum.SUBMITED) || billState.equals((Object)HRBillStateEnum.AUDITING)) {
                ihrCertificationBill.abortBizBill(billId);
            }
            if (!billState.equals((Object)HRBillStateEnum.AUDITED)) {
                billInfo.setBillState(HRBillStateEnum.AUDITEND);
                selector.add(new SelectorItemInfo("billState"));
            }
            billInfo.setCertificationStatus(CertificateStatusEnum.AbandCertificated);
            selector.add(new SelectorItemInfo("certificationStatus"));
            ihrCertificationBill.updatePartial(billInfo, selector);
        }
    }
}

