/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeVerificationRuleFactory;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.AbstractCalSchemeControllerBean;
import com.kingdee.shr.compensation.app.calculate.validate.CmpCalResultValidateFacadeFactory;
import com.kingdee.shr.compensation.app.calculate.validate.CmpCalResultValidateParam;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigFactory;
import com.kingdee.shr.compensation.app.formula.SalaryCalculatorProxy;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.exception.SalaryException;
import com.kingdee.shr.compensation.helper.CalSchemeBizHelper;
import com.kingdee.shr.compensation.secret.SecretUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CalSchemeControllerBean
extends AbstractCalSchemeControllerBean {
    @Override
    protected Map _calculateEmpScheme(Context ctx, HashMap mapParam) throws BOSException, EASBizException {
        String cmpschemeid = (String)mapParam.get("cmpschemeid");
        String uid = (String)mapParam.get("uid");
        String curuserid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String creatTableSQL = "If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_HR_SCalSchemeCalRecord') CREATE TABLE T_HR_SCalSchemeCalRecord(FUID nvarchar(128),FCalSchemeID nvarchar(44),FUserID nvarchar(44),FCalTime DateTime  ); ";
        DbUtil.execute((Context)ctx, (String)creatTableSQL);
        String checkExistSQL = "select 1 from T_HR_SCalSchemeCalRecord where FUID = ? ";
        IRowSet isExist = DbUtil.executeQuery((Context)ctx, (String)checkExistSQL, (Object[])new String[]{uid});
        try {
            if (isExist.next()) {
                throw new SalaryException(SalaryException.CALCOM);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String insertSQL = "insert into T_HR_SCalSchemeCalRecord (FUID,FCalSchemeID,FUserID,FCalTime ) values('" + uid + "','" + cmpschemeid + "','" + curuserid + "',now())";
        DbUtil.execute((Context)ctx, (String)insertSQL);
        Map calVal = this.executeCaclute(ctx, mapParam);
        String deleteSQL = "delete from T_HR_SCalSchemeCalRecord where FUID = ? ";
        DbUtil.execute((Context)ctx, (String)deleteSQL, (Object[])new String[]{uid});
        return calVal;
    }

    private Map executeCaclute(Context ctx, HashMap mapParam) throws BOSException, EASBizException {
        String cmpschemeid = (String)mapParam.get("cmpschemeid");
        String cmpcalid = (String)mapParam.get("cmpcalid");
        String uid = (String)mapParam.get("uid");
        String filterSql = (String)mapParam.get("filterSql");
        SalaryCalculatorProxy cal = new SalaryCalculatorProxy(uid, true);
        cal.setMainTableName("T_HR_SCmpCalTable");
        cal.setPrecision(Integer.parseInt("2"));
        cal.setSchemeID(cmpschemeid);
        cal.setCtx(ctx);
        Tools.getInstance().setCtx(ctx);
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, cmpschemeid);
        this.checkNeededCalSchemeInfo(ctx, calSchemeInfo);
        cal.setCalFromDate(Tools.getStringDate(calSchemeInfo.getBeginDate()));
        cal.setCalToDate(Tools.getStringDate(calSchemeInfo.getEndDate()));
        String mainTableRowFilter = "t_hr_scmpcaltable.fid in (" + cmpcalid + ") and t_hr_scmpcaltable.FCalState in (1,2,3,4,5,6,7) ";
        if (mapParam.get("temporaryTableName") != null) {
            cal.setTempTable((String)mapParam.get("temporaryTableName"));
        }
        cal.setMainTableRowFilter(mainTableRowFilter);
        cal.setFilterSql(filterSql);
        try {
            cal.post();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> calVal = new HashMap<String, String>();
        calVal.put("UID", cal.getUID());
        this.executeValidate(ctx, cmpcalid, calSchemeInfo);
        return calVal;
    }

    private void checkNeededCalSchemeInfo(Context ctx, CalSchemeInfo calSchemeInfo) throws BOSException {
        boolean isValidate = CalSchemeBizHelper.checkCalSchemeLegal(calSchemeInfo);
        if (!isValidate) {
            throw new BOSException(CalSchemeBizHelper.getCalValidateMessage(ctx));
        }
        if (null != calSchemeInfo.getExchangeTable()) {
            Date ruleDate = CurrencyUtil.getEffdtByExchangeRule(calSchemeInfo.getExchangeRule(), calSchemeInfo.getBeginDate(), calSchemeInfo.getEndDate());
            ExchangeRateCollection rateColl = CurrencyUtil.getExchangeRate(ctx, calSchemeInfo.getExchangeTable().getId().toString(), calSchemeInfo.getCurrency().getId().toString(), ruleDate);
            if (null == rateColl || rateColl.size() < 1) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            super._canDelete(ctx, pk, cn);
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().remove(ctx, this.getBOSType(), pk);
            }
            this.getDAO(ctx, cn).delete(pk);
            String delOtherFieldOql = "where calScheme = '" + pk.toString() + "'";
            CalSchemeItemFactory.getLocalInstance(ctx).delete(delOtherFieldOql);
            CalFormulaFactory.getLocalInstance(ctx).delete(delOtherFieldOql);
            CalSchemeVerificationRuleFactory.getLocalInstance(ctx).delete(delOtherFieldOql);
            BudgetDeductionConfigFactory.getLocalInstance(ctx).delete(delOtherFieldOql);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected Map _updateCalculateData(Context ctx, HashMap mapParam) throws BOSException, EASBizException {
        this.encodeSecret(ctx, mapParam);
        return null;
    }

    private void encodeSecret(Context ctx, HashMap mapParam) throws BOSException {
        String sql = "select id, fieldSn, dataType where state = 1";
        CmpItemCollection cmpItemColl = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(sql);
        CmpItemInfo cmpItemInfo = null;
        CmpItemDataType dataType = null;
        StringBuffer sb = new StringBuffer();
        StringBuffer sb1 = new StringBuffer();
        ArrayList<String> lists = new ArrayList<String>();
        for (int i = 0; i < cmpItemColl.size(); ++i) {
            cmpItemInfo = cmpItemColl.get(i);
            dataType = cmpItemInfo.getDataType();
            if (CmpItemDataType.NUMBER.getValue() != dataType.getValue()) continue;
            sb.append(",S" + cmpItemInfo.getFieldSn() + " ");
            sb1.append(",S" + cmpItemInfo.getFieldSn() + "=? ");
            lists.add("S" + cmpItemInfo.getFieldSn());
        }
        if (lists.size() == 0) {
            return;
        }
        String sbStr = sb.toString().replaceFirst(",", "");
        String sbStr1 = sb1.toString().replaceFirst(",", "");
        String sql1 = null;
        sql1 = mapParam != null && mapParam.get("condition") != null ? "select fid,FPERSONID," + sbStr + " from T_HR_SCmpCalTable " + mapParam.get("condition") + "" : "select fid,FPERSONID," + sbStr + " from T_HR_SCmpCalTable ";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql1);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" UPDATE T_HR_SCmpCalTable SET " + sbStr1 + " WHERE fid=? ");
        String keyString = "";
        BigDecimal val = null;
        try {
            while (iRowSet.next()) {
                params = new Object[lists.size() + 1];
                keyString = iRowSet.getString("fid");
                int j = lists.size();
                for (int i = 0; i < j; ++i) {
                    val = iRowSet.getBigDecimal(lists.get(i).toString());
                    params[i] = SecretUtil.encode(ctx, val, iRowSet.getString("FPERSONID"));
                }
                params[params.length - 1] = keyString;
                paramList.add(params);
            }
            DbUtil.executeBatch((Context)ctx, (String)sbSql.toString(), paramList);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void _enable(Context ctx, String id) throws BOSException {
        try {
            CalSchemeInfo model = new CalSchemeInfo();
            model.setId(BOSUuid.read((String)id));
            model.setEnableDate(new Timestamp(System.currentTimeMillis()));
            model.setState(StateEnum.ENABLE);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("id");
            selectorItemCollection.add("state");
            selectorItemCollection.add("enableDate");
            this.updatePartial(ctx, model, selectorItemCollection);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected void _disable(Context ctx, String id) throws BOSException {
        try {
            CalSchemeInfo model = new CalSchemeInfo();
            model.setId(BOSUuid.read((String)id));
            model.setDisableDate(new Timestamp(System.currentTimeMillis()));
            model.setState(StateEnum.DISABLE);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("id");
            selectorItemCollection.add("state");
            selectorItemCollection.add("disableDate");
            this.updatePartial(ctx, model, selectorItemCollection);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected Map _executeCacluteJob(Context ctx, String cmpSchemeId, String cmpcalId) throws BOSException, EASBizException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("cmpschemeid", cmpSchemeId);
        paramMap.put("cmpcalid", cmpcalId);
        return this.executeCaclute(ctx, paramMap);
    }

    protected void executeValidate(Context ctx, String filterSql, CalSchemeInfo calSchemeInfo) throws EASBizException, BOSException {
        String condition = "select fid from T_HR_SCmpCalTable where fid in (" + filterSql + ")  and FCalState = " + 4;
        CmpCalResultValidateParam validateParam = new CmpCalResultValidateParam();
        validateParam.setCalCategoryNum("CMP_CAL_RESULT_002");
        validateParam.setFilterSql(condition);
        validateParam.setValidateNodeNum("Compensation-Calculation");
        validateParam.setCalSchemeId(calSchemeInfo.getId().toString());
        validateParam.setCalSchemeInfo(calSchemeInfo);
        CmpCalResultValidateFacadeFactory.getLocalInstance(ctx).validate(validateParam);
    }
}

