/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeCommonException;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemFacadeFactory;
import com.kingdee.shr.compensation.CalState;
import com.kingdee.shr.compensation.CalTableDesTypeEnum;
import com.kingdee.shr.compensation.CmpCalTableCollection;
import com.kingdee.shr.compensation.CmpCalTableFactory;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.ICalSchemeItemFacade;
import com.kingdee.shr.compensation.ICmpCalTable;
import com.kingdee.shr.compensation.ReissueState;
import com.kingdee.shr.compensation.ReverseCheckOut;
import com.kingdee.shr.compensation.SynState;
import com.kingdee.shr.compensation.app.AbstractCmpCheckOutFacadeControllerBean;
import com.kingdee.shr.compensation.app.payPush.PayslipPushUtils;
import com.kingdee.shr.compensation.app.tax.TaxAccumulateFacadeFactory;
import com.kingdee.shr.compensation.currency.repCurrency.RepCurrencyManager;
import com.kingdee.shr.compensation.exception.CmpCheckOutFacadeException;
import com.kingdee.shr.compensation.helper.CalSchemeBizUtil;
import com.kingdee.shr.compensation.sql.wizard.CmpCalSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.ml.util.NumberTransfer;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpCheckOutFacadeControllerBean
extends AbstractCmpCheckOutFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpCheckOutFacadeControllerBean");

    @Override
    protected void _checkOutByPeriod(Context ctx, String cmpSchemeId, String permItemId) throws BOSException, EASBizException {
        CalSchemeInfo calSchemeInfo = CalSchemeBizUtil.getCalSchemeInfo(ctx, cmpSchemeId);
        String calSchemeName = calSchemeInfo.getName();
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        Date endDate = calSchemeInfo.getEndDate();
        CmpPeriodTypeEnum cmpPeriodType = calSchemeInfo.getCmpPeriodType();
        EntityViewInfo view = new EntityViewInfo();
        try {
            view.setFilter("calScheme.id='" + cmpSchemeId + "' and periodYear=" + periodYear + " and periodMonth=" + periodMonth + " and calTime=" + calTime + " and calState in(1,2,3,4,5,6,7,8,9,10,11)");
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        TaxAccumulateFacadeFactory.getLocalInstance(ctx).taxAccumulate(cmpSchemeId, permItemId);
        ICmpCalTable cmpCalTable = CmpCalTableFactory.getLocalInstance(ctx);
        int countNo = cmpCalTable.getCount(view);
        if (countNo > 0) {
            throw new BOSException(new CmpCheckOutFacadeException(CmpCheckOutFacadeException.EXCEPTION1, new Object[]{calSchemeName, NumberTransfer.format((Context)ctx, (int)0, (String)"round", (Object)countNo)}).getMessage());
        }
        String currentUserId = "'" + HRFilterUtils.getCurrentUserId((Context)ctx) + "'";
        String nowSqlDate = CmpDateUtil.toKSqlDate(new Date());
        String checkOutSql = "update T_HR_SCmpCalTable set FCalState = 20, FCREATORID = " + currentUserId + " ,FLASTUPDATEUSERID = " + currentUserId + " ,FLASTUPDATETIME = " + nowSqlDate + " where FCalSchemeID = '" + cmpSchemeId + "'  and FperiodYear=" + periodYear + " and FperiodMonth=" + periodMonth + " and FcalTime=" + calTime + ";";
        DbUtil.execute((Context)ctx, (String)checkOutSql);
        RepCurrencyManager.getInstance().dowithCheckOut(ctx, cmpSchemeId, periodYear, periodMonth, calTime);
        String pushFilter = " calTab.FCalSchemeID = '" + cmpSchemeId + "' and calTab.FperiodYear=" + periodYear + " and calTab.FperiodMonth=" + periodMonth + " and calTab.FcalTime=" + calTime + " and calTab.FCalState = 20";
        PayslipPushUtils.pushForPerson(ctx, CalState.HASCHECKOUT, cmpSchemeId, pushFilter);
        CalSchemeInfo newinfo = this.getLatestInfo(ctx, calSchemeInfo);
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.add(5, 1);
        Date firstDate = cal.getTime();
        Calendar pal = Calendar.getInstance();
        pal.set(1, periodYear);
        pal.set(2, periodMonth - 1);
        pal.set(5, 1);
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            cal.add(2, 1);
            pal.add(2, 1);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            cal.add(2, 3);
            pal.add(2, 3);
        }
        if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            cal.add(2, 6);
            pal.add(2, 6);
        }
        if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            cal.add(2, 12);
            pal.add(2, 12);
        }
        int time = 1;
        int counter = calSchemeInfo.getPeriodTime();
        if (cmpPeriodType == CmpPeriodTypeEnum.halfmonth) {
            time = calSchemeInfo.getCalTime();
            ++time;
            if (++counter > 2) {
                pal.add(2, 1);
                counter = 1;
                time = 1;
            }
            cal.setTime(calSchemeInfo.getBeginDate());
            if (calSchemeInfo.getEndDate().getMonth() >= calSchemeInfo.getBeginDate().getMonth()) {
                cal.add(2, 1);
            } else if (calSchemeInfo.getEndDate().getMonth() < calSchemeInfo.getBeginDate().getMonth()) {
                cal.add(1, 1);
                cal.add(2, -11);
            }
        }
        cal.add(5, -1);
        Date lastDate = cal.getTime();
        int year = pal.get(1);
        int month = pal.get(2) + 1;
        if (month > 12) {
            month -= 12;
        }
        if (calSchemeInfo.getIsReverseCheckOut().getValue() != 1 && calSchemeInfo.getIsReissue().getValue() != 1) {
            newinfo = (CalSchemeInfo)calSchemeInfo.clone();
            newinfo.setPeriodYear(year);
            newinfo.setPeriodMonth(month);
            newinfo.setCalTime(time);
            newinfo.setPeriodTime(counter);
            newinfo.setBeginDate(firstDate);
            newinfo.setEndDate(lastDate);
            newinfo.setCalState(CalState.NOCAL);
            newinfo.setIsReverseCheckOut(ReverseCheckOut.NOTROLLBACK);
            newinfo.setDescription(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label10", (Locale)ctx.getLocale()) + ":" + calSchemeName + "[" + periodYear + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label11", (Locale)ctx.getLocale()) + periodMonth + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label12", (Locale)ctx.getLocale()) + calTime + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label13", (Locale)ctx.getLocale()) + "]" + new Date() + "\n" + calSchemeInfo.getDescription() == null ? "" : calSchemeInfo.getDescription());
            newinfo = this.getCheckOutNewSchemeInfo(ctx, calSchemeInfo, newinfo);
            newinfo.setSynState(SynState.NOTSYN);
        } else {
            String sql = "select top 1 FID,FcurrencyId from T_HR_SCmpCalTable where FCalSchemeID = '" + newinfo.getId().toString() + "' and FPeriodYear = " + newinfo.getPeriodYear() + " and FPeriodMonth = " + newinfo.getPeriodMonth() + " and FCalTime = " + newinfo.getCalTime();
            IRowSet exeQuerySql = DbUtil.executeQuery((Context)ctx, (String)sql);
            String currencyId = null;
            try {
                if (exeQuerySql.next()) {
                    currencyId = exeQuerySql.getString("FcurrencyId");
                    CurrencyInfo item = new CurrencyInfo();
                    item.setId(BOSUuid.read((String)currencyId));
                    newinfo.setCurrency(item);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        CalSchemeFactory.getLocalInstance(ctx).save((CoreBaseInfo)newinfo);
        cmpCalTable.setCalState(cmpSchemeId, permItemId);
    }

    private CalSchemeInfo getLatestInfo(Context ctx, CalSchemeInfo calSchemeInfo) throws EASBizException, BOSException {
        CmpCalTableInfo cmpCalTableInfo = null;
        CalSchemeInfo newInfo = (CalSchemeInfo)calSchemeInfo.clone();
        BOSUuid calSchemeId = calSchemeInfo.getId();
        StringBuffer oql = new StringBuffer();
        oql.append("select periodYear,periodMonth,calTime,beginDate,endDate ");
        oql.append("where calScheme.id = '").append(calSchemeId).append("'");
        oql.append("order by periodYear desc,periodMonth desc,calTime desc");
        EntityViewInfo view = new EntityViewInfo();
        try {
            view = new EntityViewInfo(oql.toString());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        view.setTopCount(1);
        CmpCalTableCollection cmpCalTableCollection = CmpCalTableFactory.getLocalInstance(ctx).getCmpCalTableCollection(view);
        if (cmpCalTableCollection.size() == 0) {
            throw new CalSchemeCommonException(CalSchemeCommonException.EXCEPTION7);
        }
        cmpCalTableInfo = cmpCalTableCollection.get(0);
        int year = cmpCalTableInfo.getPeriodYear();
        int month = cmpCalTableInfo.getPeriodMonth();
        int time = cmpCalTableInfo.getCalTime();
        Date firstDate = cmpCalTableInfo.getBeginDate();
        Date lastDate = cmpCalTableInfo.getEndDate();
        newInfo.setBeginDate(firstDate);
        newInfo.setEndDate(lastDate);
        newInfo.setPeriodYear(year);
        newInfo.setPeriodMonth(month);
        newInfo.setCalTime(time);
        newInfo.setCalState(CalState.NOCAL);
        newInfo.setIsReverseCheckOut(ReverseCheckOut.NOTROLLBACK);
        newInfo.setIsReissue(ReissueState.NOTREISSUE);
        return newInfo;
    }

    private CalSchemeInfo getCheckOutNewSchemeInfo(Context ctx, CalSchemeInfo calSchemeInfo, CalSchemeInfo newinfo) throws EASBizException, BOSException {
        String cmpSchemeId = calSchemeInfo.getId().toString();
        int newYear = newinfo.getPeriodYear();
        int newMonth = newinfo.getPeriodMonth();
        int newTime = newinfo.getCalTime();
        CmpCalTableInfo cmpCalTableInfo = null;
        CmpCalTableCollection cmpCalTableCollection = null;
        String oql = "";
        oql = "select id where calScheme.id='" + cmpSchemeId + "' and periodYear=" + newYear + " and periodMonth=" + newMonth + " and calTime=" + newTime;
        EntityViewInfo view = null;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            logger.error((Object)e);
        }
        int count = CmpCalTableFactory.getLocalInstance(ctx).getCount(view);
        if (count > 0) {
            oql = "select periodYear,periodMonth,calTime,beginDate,endDate where calScheme.id = '" + cmpSchemeId + "' order by periodYear desc,periodMonth desc,calTime desc";
            try {
                view = new EntityViewInfo(oql);
            }
            catch (ParserException e) {
                logger.error((Object)e);
            }
            if (null != view) {
                view.setTopCount(1);
            }
        } else {
            this.doCheckOutGenerate(ctx, calSchemeInfo, newinfo);
            newinfo.setIsReissue(ReissueState.NOTREISSUE);
            return newinfo;
        }
        cmpCalTableCollection = CmpCalTableFactory.getLocalInstance(ctx).getCmpCalTableCollection(view);
        if (cmpCalTableCollection.size() > 0) {
            cmpCalTableInfo = cmpCalTableCollection.get(0);
            int year = cmpCalTableInfo.getPeriodYear();
            int month = cmpCalTableInfo.getPeriodMonth();
            int time = cmpCalTableInfo.getCalTime();
            Date firstDate = cmpCalTableInfo.getBeginDate();
            Date lastDate = cmpCalTableInfo.getEndDate();
            newinfo.setBeginDate(firstDate);
            newinfo.setEndDate(lastDate);
            newinfo.setPeriodYear(year);
            newinfo.setPeriodMonth(month);
            newinfo.setCalTime(time);
            newinfo.setIsReissue(ReissueState.NOTREISSUE);
        }
        return newinfo;
    }

    private String doCheckOutGenerate(Context ctx, CalSchemeInfo calSchemeInfo, CalSchemeInfo newinfo) throws EASBizException, BOSException {
        String nowSqlDate = CmpDateUtil.toKSqlDate(new Date());
        String cmpSchemeId = calSchemeInfo.getId().toString();
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        int year = newinfo.getPeriodYear();
        int month = newinfo.getPeriodMonth();
        int time = newinfo.getCalTime();
        Date firstDate = newinfo.getBeginDate();
        Date lastDate = newinfo.getEndDate();
        ICalSchemeItemFacade calSchemeItemFacade = CalSchemeItemFacadeFactory.getLocalInstance(ctx);
        Set generateItems = calSchemeItemFacade.getGenerateItems(cmpSchemeId);
        StringBuffer sns = new StringBuffer();
        Iterator it = generateItems.iterator();
        while (it.hasNext()) {
            String item = ((String)it.next()).toLowerCase(Locale.ENGLISH);
            sns.append("," + item);
        }
        StringBuffer tql = new StringBuffer();
        String firstDateStr = CmpDateUtil.toKSqlDate(firstDate);
        String lastDateStr = CmpDateUtil.toKSqlDate(lastDate);
        tql.append("Insert into T_HR_SCmpCalTable(");
        tql.append("fid, FCmpPeriodID , FCalSchemeID, Fiscal, FisAudit , FisGive, FCalTime, FLongNumber, ");
        tql.append("FPersonID, FAdminOrgUnitID, FCmpEmpORelationID, FHrOrgUnitID, FPositionID, FJobID, FCostBearOrgID, FCmpCalOrgID, FTaxUnitID, ");
        tql.append("FPeriodYear, FPeriodMonth, FCalState, FBeginDate, FEndDate, FRealEndDate, FCmpPeriodType, ");
        tql.append("FCalUpdateType,FIsLockOtherSysData,");
        tql.append("FoldEasId, FEmpPosOrgRelationID,FEmployeeTypeID, FNumber, FName_l1, FName_l2, FName_l3, ");
        tql.append("FDescription_l1, FDescription_l2, FDescription_l3, FSimpleName, FCreatorID, ");
        tql.append("FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID,FCurrencyID,FExchangeTableID,FExchangeRule ");
        tql.append(sns);
        tql.append(") select ");
        tql.append("newbosid('269E3024'), null, '" + cmpSchemeId + "', 'N', 'N', 'N', " + time + ", FLongNumber, ");
        tql.append("FPersonID,FAdminOrgUnitID, FCmpEmpORelationID, FHrOrgUnitID, FPositionID,FJobID,FCostBearOrgID,FCmpCalOrgID,FTaxUnitID, ");
        tql.append("" + year + "," + month + ",1, " + firstDateStr + ", " + lastDateStr + ", " + lastDateStr + ", FCmpPeriodType, ");
        tql.append("FCalUpdateType,0,");
        tql.append("FoldEasId, FEmpPosOrgRelationID,FEmployeeTypeID, FNumber, FName_l1, FName_l2, FName_l3, ");
        tql.append("'" + CalTableDesTypeEnum.AUTOIN.getAlias(LocaleUtils.locale_en_US) + "',");
        tql.append("'" + CalTableDesTypeEnum.AUTOIN.getAlias(LocaleUtils.locale_zh_CN) + "',");
        tql.append("'" + CalTableDesTypeEnum.AUTOIN.getAlias(LocaleUtils.locale_zh_TW) + "',");
        tql.append("FSimpleName, '" + HRFilterUtils.getCurrentUserId((Context)ctx) + "', ");
        tql.append(nowSqlDate + ", FLastUpdateUserID, " + nowSqlDate + ", FControlUnitID,FCurrencyID,FExchangeTableID,FExchangeRule ");
        tql.append(sns);
        tql.append(" from T_HR_SCmpCalTable  ");
        tql.append(" where T_HR_SCmpCalTable.FCalSchemeId = '" + cmpSchemeId + "' ");
        tql.append(" and T_HR_SCmpCalTable.FCalTime = " + calTime + "");
        tql.append(" and T_HR_SCmpCalTable.FPeriodYear = " + periodYear + "");
        tql.append(" and T_HR_SCmpCalTable.FPeriodMonth = " + periodMonth + "");
        tql.append(";");
        DbUtil.execute((Context)ctx, (String)tql.toString());
        String updateSql = CmpCalSQL.synchRealEndDateSql(newinfo);
        DbUtil.execute((Context)ctx, (String)updateSql);
        return null;
    }

    @Override
    protected void _checkOutByTime(Context ctx, String cmpSchemeId, String permItemId) throws BOSException, EASBizException {
        CalSchemeInfo calSchemeInfo = CalSchemeBizUtil.getCalSchemeInfo(ctx, cmpSchemeId);
        String calSchemeName = calSchemeInfo.getName();
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        EntityViewInfo view = new EntityViewInfo();
        try {
            view.setFilter("calScheme.id='" + cmpSchemeId + "' and periodYear=" + periodYear + " and periodMonth=" + periodMonth + " and calTime=" + calTime + " and calState in(1,2,3,4,5,6,7,8,9,10,11)");
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        TaxAccumulateFacadeFactory.getLocalInstance(ctx).taxAccumulate(cmpSchemeId, permItemId);
        ICmpCalTable cmpCalTable = CmpCalTableFactory.getLocalInstance(ctx);
        int countNo = cmpCalTable.getCount(view);
        if (countNo > 0) {
            throw new BOSException(new CmpCheckOutFacadeException(CmpCheckOutFacadeException.EXCEPTION1, new Object[]{calSchemeName, NumberTransfer.format((Context)ctx, (int)0, (String)"round", (Object)countNo)}).getMessage());
        }
        String currentUserId = "'" + HRFilterUtils.getCurrentUserId((Context)ctx) + "'";
        String nowSqlDate = CmpDateUtil.toKSqlDate(new Date());
        String checkOutSql = "update T_HR_SCmpCalTable set FCalState = 20, FCREATORID = " + currentUserId + " ,FLASTUPDATEUSERID = " + currentUserId + " ,FLASTUPDATETIME = " + nowSqlDate + " where FCalSchemeID = '" + cmpSchemeId + "'  and FperiodYear=" + periodYear + " and FperiodMonth=" + periodMonth + " and FcalTime=" + calTime + ";";
        DbUtil.execute((Context)ctx, (String)checkOutSql);
        RepCurrencyManager.getInstance().dowithCheckOut(ctx, cmpSchemeId, periodYear, periodMonth, calTime);
        String pushFilter = " calTab.FCalSchemeID = '" + cmpSchemeId + "' and calTab.FperiodYear=" + periodYear + " and calTab.FperiodMonth=" + periodMonth + " and calTab.FcalTime=" + calTime + " and calTab.FCalState = 20";
        PayslipPushUtils.pushForPerson(ctx, CalState.HASCHECKOUT, cmpSchemeId, pushFilter);
        CalSchemeInfo newinfo = this.getLatestInfo(ctx, calSchemeInfo);
        if (newinfo.getPeriodYear() == calSchemeInfo.getPeriodYear() && newinfo.getPeriodMonth() == calSchemeInfo.getPeriodMonth() && newinfo.getCalTime() == calSchemeInfo.getCalTime()) {
            int time = calTime + 1;
            newinfo.setCalTime(time);
            newinfo.setCalState(CalState.NOCAL);
            newinfo.setIsReverseCheckOut(ReverseCheckOut.NOTROLLBACK);
            newinfo.setIsReissue(ReissueState.NOTREISSUE);
            newinfo.setDescription(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label10", (Locale)ctx.getLocale()) + ":" + calSchemeName + "[" + periodYear + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label11", (Locale)ctx.getLocale()) + periodMonth + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label12", (Locale)ctx.getLocale()) + calTime + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label13", (Locale)ctx.getLocale()) + "]" + new Date() + "\n" + calSchemeInfo.getDescription() == null ? "" : calSchemeInfo.getDescription());
            newinfo = this.getCheckOutNewSchemeInfo(ctx, calSchemeInfo, newinfo);
            newinfo.setSynState(SynState.NOTSYN);
        } else {
            String sql = "select top 1 FID,FcurrencyId from T_HR_SCmpCalTable where FCalSchemeID = '" + newinfo.getId().toString() + "' and FPeriodYear = " + newinfo.getPeriodYear() + " and FPeriodMonth = " + newinfo.getPeriodMonth() + " and FCalTime = " + newinfo.getCalTime();
            IRowSet exeQuerySql = DbUtil.executeQuery((Context)ctx, (String)sql);
            String currencyId = null;
            try {
                if (exeQuerySql.next()) {
                    currencyId = exeQuerySql.getString("FcurrencyId");
                    CurrencyInfo item = new CurrencyInfo();
                    item.setId(BOSUuid.read((String)currencyId));
                    newinfo.setCurrency(item);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        CalSchemeFactory.getLocalInstance(ctx).save((CoreBaseInfo)newinfo);
        cmpCalTable.setCalState(cmpSchemeId, permItemId);
    }
}

