/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.AbstractEASCmpHROrgFacadeControllerBean;
import com.kingdee.shr.compensation.util.CmpEASDbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EASCmpHROrgFacadeControllerBean
extends AbstractEASCmpHROrgFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.EASCmpHROrgFacadeControllerBean");
    private DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _getEASHROrgData(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        IRowSet rs = null;
        String delSql = "delete T_HR_SEASCmpHROrgUnit";
        DbUtil.execute((Context)ctx, (String)delSql);
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuilder querySb = new StringBuilder();
        querySb.append(" select fid id, FParentID parentId, fnumber number, fname_" + l + " name from T_ORG_HRO ");
        StringBuilder insertSb = new StringBuilder();
        insertSb.append(" insert into T_HR_SEASCmpHROrgUnit(fid, FParentID, fnumber, fname_" + l + ") values(?, ?, ?, ?) ");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<String> params = null;
        String id = "";
        String parentId = "";
        String number = "";
        String name = "";
        try {
            conn = CmpEASDbUtil.getOuterConnection(ctx, "EasSysDB");
            rs = CmpEASDbUtil.executeQuery(ctx, querySb.toString(), conn, true);
            while (rs.next()) {
                params = new ArrayList<String>();
                id = rs.getString("id");
                parentId = rs.getString("parentId");
                number = rs.getString("number");
                name = rs.getString("name");
                params.add(id);
                params.add(parentId);
                params.add(number);
                params.add(name);
                paramList.add(params.toArray());
            }
            DbUtil.executeBatch((Context)ctx, (String)insertSb.toString(), paramList);
            SQLUtils.cleanup((ResultSet)rs, null, (Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(rs, null, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getEASAdjData(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        int periodYear = 0;
        try {
            periodYear = Integer.valueOf((String)param.get("periodYear"));
        }
        catch (Exception e) {
            periodYear = 0;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String querySql = "select p.fnumber personNumber, p.fname_" + l + " personName, admin.fname_" + l + " orgName, position.fname_" + l + " positionName, cmpItem.fname_" + l + " cmpItemName, adjs.fnewValue value, adjs.feffectdate effectdate from t_hr_adjschitem adjs inner join t_bd_person p on adjs.fadjempid = p.fid inner join t_hr_cmpItem cmpItem on adjs.fadjcmpitemid = cmpItem.fid left join t_org_admin admin on adjs.fnewAdminOrgId = admin.fid left join t_org_position position on adjs.fnewPositionId = position.fid ";
        if (periodYear != 0) {
            querySql = querySql + "where year(adjs.feffectdate) = ? ";
        }
        querySql = querySql + "order by p.fnumber, adjs.feffectdate ";
        try {
            conn = CmpEASDbUtil.getOuterConnection(ctx, "EasSysDB");
            statement = conn.prepareStatement(querySql);
            if (periodYear != 0) {
                statement.setInt(1, periodYear);
            }
            rs = statement.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                String personNumber = rs.getString("personNumber");
                String personName = rs.getString("personName");
                String orgName = rs.getString("orgName");
                String positionName = rs.getString("positionName");
                String cmpItemName = rs.getString("cmpItemName");
                double value = rs.getDouble("value");
                String effectdate = rs.getString("effectdate");
                dataMap.put("personNumber", personNumber);
                dataMap.put("personName", personName);
                dataMap.put("adminOrgName", orgName);
                dataMap.put("positionName", positionName);
                dataMap.put("cmpItemName", cmpItemName);
                dataMap.put("money", value);
                dataMap.put("effectDay", this.sdf.format(this.sdf.parse(effectdate)));
                dataMap.put("isHistory", EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label24", (Locale)ctx.getLocale()));
                list.add(dataMap);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                SQLUtils.cleanup((Connection)conn);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return list;
    }

    private Map<String, Map<String, String>> getPersonMap(Context ctx, Connection conn, String hisTable) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select person.fid, person.fnumber, person.fname_" + l + " personName  from t_bd_person person inner join " + hisTable + " hisTab on person.fid=hisTab.fpersonId";
        String personId = "";
        String personNum = "";
        String personName = "";
        try {
            IRowSet rs = CmpEASDbUtil.executeQuery(ctx, sql, conn, false);
            while (rs.next()) {
                personId = rs.getString("fid");
                personNum = rs.getString("fnumber");
                personName = rs.getString("personName");
                map = new HashMap();
                map.put("personNumber", personNum);
                map.put("personName", personName);
                resultMap.put(personId, map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            SQLUtils.cleanup((Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }

    private Map<String, String> getSHRAdminOrgMap(Context ctx) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select fnumber, fname_" + l + " from t_org_admin";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String number = "";
            String name = "";
            while (rs.next()) {
                number = rs.getString("fnumber");
                name = rs.getString("fname_" + l + "");
                map.put(number, name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, String> getSHRPositionMap(Context ctx) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select fnumber, fname_" + l + " from t_org_position";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String number = "";
            String name = "";
            while (rs.next()) {
                number = rs.getString("fnumber");
                name = rs.getString("fname_" + l + "");
                map.put(number, name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, Map<String, String>> getEASAdminOrgMap(Context ctx, Connection conn, String hisTable) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select org.fid orgId, org.fnumber orgNumber, org.fname_" + l + " orgName  from t_org_admin org inner join " + hisTable + " hisTab on org.fid=hisTab.fadminorgUnitId";
        String orgId = "";
        String orgNumber = "";
        String orgName = "";
        try {
            IRowSet rs = CmpEASDbUtil.executeQuery(ctx, sql, conn, false);
            while (rs.next()) {
                orgId = rs.getString("orgId");
                orgNumber = rs.getString("orgNumber");
                orgName = rs.getString("orgName");
                map = new HashMap();
                map.put("adminOrgNumber", orgNumber);
                map.put("adminOrgName", orgName);
                resultMap.put(orgId, map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            SQLUtils.cleanup((Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }

    private Map<String, Map<String, String>> getEASPositionMap(Context ctx, Connection conn, String hisTable) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select position.fid, position.fnumber positionNum, position.fname_" + l + " positionName  from t_org_position position inner join " + hisTable + " hisTab on position.fid=hisTab.fpositionid";
        String positionId = "";
        String positionNum = "";
        String positionName = "";
        try {
            IRowSet rs = CmpEASDbUtil.executeQuery(ctx, sql, conn, false);
            while (rs.next()) {
                positionId = rs.getString("fid");
                positionNum = rs.getString("positionNum");
                positionName = rs.getString("positionName");
                map = new HashMap();
                map.put("positionNumber", positionNum);
                map.put("positionName", positionName);
                resultMap.put(positionId, map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            SQLUtils.cleanup((Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }
}

