/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.AbstractBudgetTemplateControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTempVeriRuleFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemFactory;
import com.kingdee.shr.compensation.exception.BudgetEASBizException;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BusinessRelationConfigFactory;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class BudgetTemplateControllerBean
extends AbstractBudgetTemplateControllerBean {
    private static final Logger logger = Logger.getLogger(BudgetTemplateControllerBean.class);

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BudgetTemplateInfo templateInfo = (BudgetTemplateInfo)model;
        this.checkBillBeforeUpdateBudgetPeriod(ctx, templateInfo);
        super._update(ctx, pk, model);
        String templateId = pk.toString();
        if (templateInfo.getBudgetPeriod() == BudgetPeriodEnum.YEAR) {
            String delSql = "delete FROM T_HR_SBudgetSchemeRatio where FBudgetSchemeID in ( SELECT FID FROM T_HR_SCmpBudgetScheme where FTemplateID = ? )";
            DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{templateId});
            String updateSql = "UPDATE T_HR_SBudgetTemplateItem SET FIsSubBudgetAssign = 0 WHERE FTemplateID = ? ";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{templateId});
        } else {
            String updateSql = "UPDATE T_HR_SBudgetTemplateItem SET FIsSubBudgetAssign = 1 WHERE FBudgetItemID in (select FCmpBudgetItemId from T_HR_SBudgetTemplateSTBItem where FTemplateID = ?) and FTemplateID = ?";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{templateId, templateId});
        }
        if (templateInfo.getBudgetPeriod() != null) {
            String updateBudgetSchemeSql = "UPDATE T_HR_SCmpBudgetScheme SET FBudgetPeriod=? where FTemplateID=?";
            DbUtil.execute((Context)ctx, (String)updateBudgetSchemeSql, (Object[])new Object[]{templateInfo.getBudgetPeriod().getValue(), templateInfo.getId().toString()});
        }
    }

    public void checkBillBeforeUpdateBudgetPeriod(Context ctx, BudgetTemplateInfo templateInfo) throws EASBizException, BOSException {
        BudgetTemplateInfo oldTemplateInfo = BudgetTemplateFactory.getLocalInstance(ctx).getBudgetTemplateInfo("select budgetPeriod where id='" + templateInfo.getId().toString() + "'");
        if (oldTemplateInfo.getBudgetPeriod() != templateInfo.getBudgetPeriod()) {
            String checkBillSql = "select bill.fid from T_HR_SBudgetAdjustBill bill where bill.FBudgetSchemeID in (select fid from T_HR_SCmpBudgetScheme where FTemplateID=?)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkBillSql, (Object[])new Object[]{templateInfo.getId().toString()});
            if (rs.size() > 0) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION37);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String templateId = pk.toString();
        String oql = "where template.id = '" + templateId + "'";
        BudgetTemplateItemFactory.getLocalInstance(ctx).delete(oql);
        BudgetTemplateSTBItemFactory.getLocalInstance(ctx).delete(oql);
        oql = "where businessRelationConfig.id in (select fid from T_HR_SBusinessRelationConfig where FBusinessId = '" + templateId + "')";
        BaseFormulaFactory.getLocalInstance((Context)ctx).delete(oql);
        oql = "where businessId = '" + templateId + "'";
        BusinessRelationConfigFactory.getLocalInstance((Context)ctx).delete(oql);
        oql = "where budgetTemplate.id = '" + templateId + "'";
        BudgetTempVeriRuleFactory.getLocalInstance(ctx).delete(oql);
        super._delete(ctx, pk);
    }

    protected void _disable(Context ctx, String id) throws BOSException {
        super._disable(ctx, id);
        String oql = "where id= '" + id + "'";
        BudgetTemplateCollection templateCollection = this.getBudgetTemplateCollection(ctx, oql);
        if (!templateCollection.isEmpty()) {
            BudgetTemplateInfo templateInfo = templateCollection.get(0);
            templateInfo.setDisableDate(new Timestamp(System.currentTimeMillis()));
            try {
                this.update(ctx, (IObjectPK)new ObjectUuidPK(id), templateInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void _enable(Context ctx, String id) throws BOSException {
        super._enable(ctx, id);
        String oql = "where id= '" + id + "'";
        BudgetTemplateCollection templateCollection = this.getBudgetTemplateCollection(ctx, oql);
        if (!templateCollection.isEmpty()) {
            BudgetTemplateInfo templateInfo = templateCollection.get(0);
            templateInfo.setEnableDate(new Timestamp(System.currentTimeMillis()));
            try {
                this.update(ctx, (IObjectPK)new ObjectUuidPK(id), templateInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

