/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.incomeTax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.BankCardStatusEnum;
import com.kingdee.shr.compensation.IdentityStatusEnume;
import com.kingdee.shr.compensation.SubmitStatusEnum;
import com.kingdee.shr.compensation.app.entity.TaxPersonEntity;
import com.kingdee.shr.compensation.app.entity.Triple;
import com.kingdee.shr.compensation.app.incomeTax.AbstractTaxPersonReportFacadeControllerBean;
import com.kingdee.shr.compensation.app.incomeTax.ITaxPersonRecordEntry;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryInfo;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.ITaxServiceTaskFacade;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.TaxReportUtil;
import com.kingdee.shr.compensation.util.filter.CmpTaxUnitPermFilter;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxPersonReportFacadeControllerBean
extends AbstractTaxPersonReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger(TaxPersonReportFacadeControllerBean.class);

    @Override
    protected List<IObjectPK> _report(Context ctx, String entryIDs, String taxPeriodDate, String filter) throws BOSException {
        String curPersonPermTaxUnitSql = CmpTaxUnitPermFilter.getCurPersonPermTaxUnitSql(ctx);
        String oql = "select *,bill.*,bill.person.*,bill.nationality.*,bill.position.*,bill.birthPlace.*,bill.eduLevel.*,bill.bank.name,bill.hrBank.name,taxUnit.id,taxUnit.taxNumber,taxUnit.areaCode,taxUnit.regNumber,taxUnit.declPassword,taxUnit.realPassword where (submitStatus=0 or submitStatus=3) ";
        if (!StringUtils.isEmpty((String)entryIDs)) {
            oql = oql + " and taxUnit.id in (" + curPersonPermTaxUnitSql + ")";
            oql = oql + " and id in (" + entryIDs + ")";
        } else if (!StringUtils.isEmpty((String)filter)) {
            oql = oql + " and " + filter;
        } else {
            return null;
        }
        ArrayList<IObjectPK> arrayList = new ArrayList<IObjectPK>();
        try {
            ITaxPersonRecordEntry iTaxPersonRecordEntry = TaxPersonRecordEntryFactory.getLocalInstance(ctx);
            TaxPersonRecordEntryCollection taxRecordEntryCollection = iTaxPersonRecordEntry.getTaxPersonRecordEntryCollection(oql);
            if (taxRecordEntryCollection.size() == 0) {
                return null;
            }
            Map<TaxUnitInfo, Triple<List<TaxPersonEntity>, CoreBaseCollection, CoreBaseCollection>> tripleMap = this.getTripleMap(taxRecordEntryCollection, taxPeriodDate);
            ITaxServiceTaskFacade iTaxServiceTaskFacade = TaxServiceTaskFacadeFactory.getLocalInstance(ctx);
            for (Map.Entry<TaxUnitInfo, Triple<List<TaxPersonEntity>, CoreBaseCollection, CoreBaseCollection>> entry : tripleMap.entrySet()) {
                TaxUnitInfo taxUnitInfo = entry.getKey();
                Triple<List<TaxPersonEntity>, CoreBaseCollection, CoreBaseCollection> value = entry.getValue();
                List<TaxPersonEntity> taxPersonEntitys = value.getFirst();
                CoreBaseCollection entryBaseCollection = value.getSecond();
                CoreBaseCollection billBaseCollection = value.getThree();
                HashMap<String, Object> reMap = new HashMap<String, Object>();
                reMap.put("nsrsbh", taxUnitInfo.getTaxNumber());
                reMap.put("areaid", taxUnitInfo.getAreaCode());
                reMap.put("djxhid", taxUnitInfo.getRegNumber());
                reMap.put("ver", "V2.0.000");
                reMap.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
                String realPassword = taxUnitInfo.getRealPassword();
                if (!StringUtils.isEmpty((String)realPassword)) {
                    reMap.put("smmm", Base64Utils.decode(realPassword));
                }
                reMap.put("zrs", taxPersonEntitys.size());
                String sdyf = TaxReportUtil.getCurrentYearMonth(taxPeriodDate);
                reMap.put("sdyf", sdyf);
                reMap.put("bmbh", "");
                reMap.put("nsrlb", taxPersonEntitys);
                reMap.put("TAXUNITID", taxUnitInfo.getId().toString());
                Set<String> persons = this.getPersonsSet(taxPersonEntitys, sdyf);
                reMap.put("persons", persons);
                IObjectPK addTask = iTaxServiceTaskFacade.addTask(TaxCalTaskCatalogEnum.PersonReport, reMap);
                arrayList.add(addTask);
                List<Object[]> recordEntryParamsList = this.getParamsList(entryBaseCollection, addTask.toString());
                String recordEntrySql = "update T_HR_STaxPersonRecordEntry set FSubmitStatus= ?, FIdentityStatus=?, FTaxCalTaskId=?, FLastReportMonth=?,FEndDate=? where fid =?";
                DbUtil.executeBatch((Context)ctx, (String)recordEntrySql, recordEntryParamsList);
                logger.info((Object)("--------->>>>>\u66f4\u65b0\u62a5\u9001\u72b6\u6001\u3001\u9a8c\u8bc1\u72b6\u6001\uff1arecordEntrySql:" + recordEntrySql + "------>>>>recordEntryParamsList:" + recordEntryParamsList + "---------->>>addTask:" + addTask));
                List<Object[]> recordParamsList = this.getParamsList(billBaseCollection, null);
                String recordSql = "update T_HR_STaxPersonRecord set FBankCardStatus=? where fid =?";
                DbUtil.executeBatch((Context)ctx, (String)recordSql, recordParamsList);
                logger.info((Object)("--------->>>>>\u66f4\u65b0\u94f6\u884c\u5361\u53f7\u72b6\u6001\uff1arecordSql:" + recordSql + "------>>>>recordParamsList:" + recordParamsList));
            }
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("------------>>>>\u6355\u83b7\u5f02\u5e38\uff1a" + e.getMessage()));
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private Set<String> getPersonsSet(List<TaxPersonEntity> taxPersonEntitys, String sdyf) {
        HashSet<String> result = new HashSet<String>();
        if (null == taxPersonEntitys || taxPersonEntitys.size() < 1) {
            return result;
        }
        for (TaxPersonEntity taxPersonEntity : taxPersonEntitys) {
            result.add(taxPersonEntity.getXm() + "_" + taxPersonEntity.getZzhm() + "_" + taxPersonEntity.getZzlx() + "_" + sdyf);
        }
        return result;
    }

    private List<Object[]> getParamsList(CoreBaseCollection coreBaseCollection, String taskId) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < coreBaseCollection.size(); ++i) {
            Object[] object;
            CoreBaseInfo coreBaseInfo = coreBaseCollection.get(i);
            if (coreBaseInfo instanceof TaxPersonRecordEntryInfo) {
                object = new Object[6];
                TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = (TaxPersonRecordEntryInfo)coreBaseInfo;
                String submitStatus = taxPersonRecordEntryInfo.getSubmitStatus().getValue();
                String identityStatus = taxPersonRecordEntryInfo.getIdentityStatus().getValue();
                String lastReportMonth = taxPersonRecordEntryInfo.getLastReportMonth();
                String id = taxPersonRecordEntryInfo.getId().toString();
                object[0] = submitStatus;
                object[1] = identityStatus;
                object[2] = taskId != null ? taskId : "-1";
                object[3] = lastReportMonth;
                object[4] = CmpDateUtil.toSqlDate(lastReportMonth + "-01");
                object[5] = id;
                paramsList.add(object);
            }
            if (!(coreBaseInfo instanceof TaxPersonRecordInfo)) continue;
            object = new Object[2];
            TaxPersonRecordInfo taxPersonRecordInfo = (TaxPersonRecordInfo)coreBaseInfo;
            String bankCardStatus = taxPersonRecordInfo.getBankCardStatus().getValue();
            String id = taxPersonRecordInfo.getId().toString();
            object[0] = bankCardStatus;
            object[1] = id;
            paramsList.add(object);
        }
        return paramsList;
    }

    private Map<TaxUnitInfo, List<TaxPersonRecordEntryInfo>> getEntryMap(TaxPersonRecordEntryCollection taxRecordEntryCollection) {
        HashMap<TaxUnitInfo, List<TaxPersonRecordEntryInfo>> entryMap = new HashMap<TaxUnitInfo, List<TaxPersonRecordEntryInfo>>();
        HashMap stringEntryMap = new HashMap();
        HashMap<String, TaxUnitInfo> taxUnitMap = new HashMap<String, TaxUnitInfo>();
        for (int i = 0; i < taxRecordEntryCollection.size(); ++i) {
            List<TaxPersonRecordEntryInfo> taxPersonRecordEntryInfos;
            TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = taxRecordEntryCollection.get(i);
            TaxUnitInfo taxUnit = taxPersonRecordEntryInfo.getTaxUnit();
            if (!taxUnitMap.containsKey(taxUnit.getId().toString())) {
                taxUnitMap.put(taxUnit.getId().toString(), taxUnit);
            }
            if (stringEntryMap.containsKey(taxUnit.getId().toString())) {
                taxPersonRecordEntryInfos = (List)stringEntryMap.get(taxUnit.getId().toString());
                taxPersonRecordEntryInfos.add(taxPersonRecordEntryInfo);
                continue;
            }
            taxPersonRecordEntryInfos = new ArrayList<TaxPersonRecordEntryInfo>();
            taxPersonRecordEntryInfos.add(taxPersonRecordEntryInfo);
            stringEntryMap.put(taxUnit.getId().toString(), taxPersonRecordEntryInfos);
        }
        for (Map.Entry entry : stringEntryMap.entrySet()) {
            entryMap.put((TaxUnitInfo)taxUnitMap.get(entry.getKey()), (List<TaxPersonRecordEntryInfo>)entry.getValue());
        }
        return entryMap;
    }

    private Map<TaxUnitInfo, Triple<List<TaxPersonEntity>, CoreBaseCollection, CoreBaseCollection>> getTripleMap(TaxPersonRecordEntryCollection taxRecordEntryCollection, String taxPeriodDate) {
        HashMap<TaxUnitInfo, Triple<List<TaxPersonEntity>, CoreBaseCollection, CoreBaseCollection>> tripleMap = new HashMap<TaxUnitInfo, Triple<List<TaxPersonEntity>, CoreBaseCollection, CoreBaseCollection>>();
        Map<TaxUnitInfo, List<TaxPersonRecordEntryInfo>> entryMap = this.getEntryMap(taxRecordEntryCollection);
        HashSet<String> billIdSet = new HashSet<String>();
        for (Map.Entry<TaxUnitInfo, List<TaxPersonRecordEntryInfo>> entry : entryMap.entrySet()) {
            Triple triple = new Triple();
            TaxUnitInfo key = entry.getKey();
            List<TaxPersonRecordEntryInfo> value = entry.getValue();
            ArrayList<TaxPersonEntity> taxPersonEntitys = new ArrayList<TaxPersonEntity>();
            CoreBaseCollection entryBaseCollection = new CoreBaseCollection();
            CoreBaseCollection billBaseCollection = new CoreBaseCollection();
            for (TaxPersonRecordEntryInfo taxPersonRecordEntryInfo : value) {
                TaxPersonEntity taxPersonEntity = TaxReportUtil.taxPersonRecordEntryInfo2TaxPersonEntity(taxPersonRecordEntryInfo);
                taxPersonEntitys.add(taxPersonEntity);
                taxPersonRecordEntryInfo.setSubmitStatus(SubmitStatusEnum.Submiting);
                taxPersonRecordEntryInfo.setIdentityStatus(IdentityStatusEnume.VerifyING);
                taxPersonRecordEntryInfo.setLastReportMonth(taxPeriodDate);
                entryBaseCollection.add((CoreBaseInfo)taxPersonRecordEntryInfo);
                TaxPersonRecordInfo bill = taxPersonRecordEntryInfo.getBill();
                if (billIdSet.contains(bill.getId().toString())) continue;
                bill.setBankCardStatus(BankCardStatusEnum.VerifyING);
                billBaseCollection.add((CoreBaseInfo)bill);
                billIdSet.add(bill.getId().toString());
            }
            triple.setFirst(taxPersonEntitys);
            triple.setSecond(entryBaseCollection);
            triple.setThree(billBaseCollection);
            tripleMap.put(key, triple);
        }
        return tripleMap;
    }
}

