/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.NationalityInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.DeductFeesEnum;
import com.kingdee.shr.compensation.EmployedTypeEnum;
import com.kingdee.shr.compensation.IdentityStatusEnume;
import com.kingdee.shr.compensation.IsOverseaEnum;
import com.kingdee.shr.compensation.PayerTypeEnum;
import com.kingdee.shr.compensation.PersonStatusEnum;
import com.kingdee.shr.compensation.SubmitStatusEnum;
import com.kingdee.shr.compensation.TaxReasonEnum;
import com.kingdee.shr.compensation.app.incomeTax.EmploymentSituationEnum;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryInfo;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractPersonChangeFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.DifferenceEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitDetailFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitDetailInfo;
import com.kingdee.shr.compensation.taxCal.VO.GenPersonDeclaration;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.TaxReportUtil;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import com.kingdee.shr.compensation.util.filter.CmpTaxUnitPermFilter;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonChangeFacadeControllerBean
extends AbstractPersonChangeFacadeControllerBean {
    private static Logger logger = Logger.getLogger(PersonChangeFacadeControllerBean.class);

    @Override
    protected void _updateDifference(Context ctx, Date periodBegin, String permItemId) throws BOSException, EASBizException {
        boolean isCal = true;
        try {
            isCal = HRParamUtil.getParamOfHR((Context)ctx, (String)"shr_cmp_026", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(periodBegin);
        calendar.add(2, -1);
        String taxPermSql = CmpTaxUnitPermFilter.getAllPermTaxUnitByPersonId(ctx);
        String schemePermSql = CmpSchemeFilter.getPersonCalSchemePerm(ctx, permItemId, false);
        StringBuilder str = new StringBuilder();
        str.append(" UPDATE T_HR_STAXCALINITDETAIL DETAIL ");
        str.append(" SET FDifference = ").append(30);
        str.append(" WHERE FTAXUNITID IN (").append(taxPermSql).append(") ");
        if (isCal) {
            str.append(this.getCalSchemeCondition(schemePermSql));
        }
        str.append(" AND DETAIL.FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND EXISTS (");
        str.append(" SELECT 1 FROM T_HR_STAXPERSONRECORDENTRY ENTRY ");
        str.append(" WHERE ENTRY.FPERSONID = DETAIL.FPERSONID ");
        str.append(" AND ENTRY.FTAXUNITID = DETAIL.FTAXUNITID AND ENTRY.FPERSONSTATUS = '0') ");
        DbUtil.execute((Context)ctx, (String)str.toString());
        str = new StringBuilder();
        str.append(" UPDATE T_HR_STAXCALINITDETAIL DETAIL ");
        str.append(" SET FDifference = ").append(20);
        str.append(" WHERE FTAXUNITID IN (").append(taxPermSql).append(") ");
        if (isCal) {
            str.append(this.getCalSchemeCondition(schemePermSql));
        }
        str.append(" AND DETAIL.FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND NOT EXISTS (");
        str.append(" SELECT 1 FROM T_HR_STAXPERSONRECORDENTRY ENTRY ");
        str.append(" WHERE ENTRY.FPERSONID = DETAIL.FPERSONID ");
        str.append(" AND ENTRY.FTAXUNITID = DETAIL.FTAXUNITID ) ");
        DbUtil.execute((Context)ctx, (String)str.toString());
        str = new StringBuilder();
        str.append(" UPDATE T_HR_STAXCALINITDETAIL DETAIL ");
        str.append(" SET FDifference = ").append(10);
        str.append(" WHERE FTAXUNITID IN (").append(taxPermSql).append(") ");
        if (isCal) {
            str.append(this.getCalSchemeCondition(schemePermSql));
        }
        str.append(" AND DETAIL.FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND EXISTS (");
        str.append(" SELECT 1 FROM T_HR_STAXPERSONRECORDENTRY ENTRY ");
        str.append(" WHERE ENTRY.FPERSONID = DETAIL.FPERSONID ");
        str.append(" AND ENTRY.FTAXUNITID = DETAIL.FTAXUNITID AND ENTRY.FPERSONSTATUS = '1') ");
        str.append(" AND FDIFFERENCE IN (20,30)");
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private String getCalSchemeCondition(String schemePermSql) {
        return " and (FCalSchemeId in (" + schemePermSql + ") or FCalSchemeId is null) ";
    }

    @Override
    protected BatchMessageTipsHeader _genPersonDeclaration(Context ctx, GenPersonDeclaration param) throws BOSException {
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        String selectIds = param.getSelectedIds();
        String condition = CmpStrUtil.buildInSql(selectIds);
        ArrayList<String> personIds = new ArrayList<String>();
        StringBuilder personIdStr = new StringBuilder();
        String taxCalInitOql = "select id, difference, person.id, taxUnit.id, cmpCalTable.cmpEmpORelation.effectDate where id in " + condition;
        DataBaseCollection collection = TaxCalInitDetailFactory.getLocalInstance(ctx).getDataBaseCollection(taxCalInitOql);
        CoreBaseCollection entryCollection = new CoreBaseCollection();
        TaxPersonRecordCollection allPersonRecords = new TaxPersonRecordCollection();
        HashMap<String, String> initCal2Person = new HashMap<String, String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TaxCalInitDetailInfo taxCalInitDetail = (TaxCalInitDetailInfo)iterator.next();
            initCal2Person.put(taxCalInitDetail.getId().toString(), taxCalInitDetail.getPerson().getId().toString());
            if (taxCalInitDetail.getDifference() != DifferenceEnum.STATE_ABNORMAL) {
                iterator.remove();
                continue;
            }
            TaxPersonRecordEntryInfo entryInfo = this.initPersonRecordEntry(param, taxCalInitDetail.getPerson());
            boolean flag = this.setEmployDateAndTaxUnit(entryInfo, taxCalInitDetail);
            if (!flag) continue;
            this.addTaxPersonRecordEntry(entryCollection, entryInfo);
            if (personIdStr.length() > 0) {
                personIdStr.append(",");
            }
            String personId = taxCalInitDetail.getPerson().getId().toString();
            personIdStr.append(personId);
            personIds.add(personId);
        }
        Map<String, String> errMsgMap = new HashMap<String, String>();
        try {
            String personOql = "select id, person.id, person.name, person.number where person.id in " + CmpStrUtil.buildInSql(personIdStr.toString());
            TaxPersonRecordCollection existedPersonRecords = TaxPersonRecordFactory.getLocalInstance(ctx).getTaxPersonRecordCollection(personOql);
            ArrayList<String> existedPersonIdList = new ArrayList<String>();
            if (null != existedPersonRecords && existedPersonRecords.size() > 0) {
                allPersonRecords.addCollection(existedPersonRecords);
                for (int i = 0; i < existedPersonRecords.size(); ++i) {
                    existedPersonIdList.add(existedPersonRecords.get(i).getPerson().getId().toString());
                }
            }
            if (!existedPersonIdList.isEmpty()) {
                personIds.removeAll(existedPersonIdList);
            }
            if (!personIds.isEmpty()) {
                String personSQL = "select p.fid fid,p.fGender gender,p.fBirthday birthday,p.fEmail email,p.fCell phone,p.fIdCardNO idCardNo,p.fPassportNO passportNo,p.FNationalityId nationalityId,p.fName_l2 name,p.fNumber number,p.FHighestDegreeID highestDegreeId, ct.fName_l2 otherCardType  from t_bd_person p left join T_HR_PersonOtherInfo po on p.fid = po.fPersonId  left join T_HR_CredentialsType ct on po.fCredentialsTypeId = ct.fid  where p.fid in " + CmpStrUtil.buildInSql(this.combineByComma(personIds));
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)personSQL);
                CoreBaseCollection newPersonCollection = new CoreBaseCollection();
                errMsgMap = this.dealWithNewPersonRecord(rowSet, newPersonCollection, allPersonRecords, param);
                if (newPersonCollection.size() > 0) {
                    TaxPersonRecordFactory.getLocalInstance(ctx).addnewBatchData(newPersonCollection);
                }
            }
            ArrayList<String> personIdList = new ArrayList<String>();
            this.setBillId(ctx, entryCollection, allPersonRecords, errMsgMap, personIdList);
            int success = this.getPersonCount(entryCollection, personIdList);
            if (entryCollection.size() > 0) {
                String taxCalInitDetailIds = this.getTaxCalInitDetailIds4Update(initCal2Person, personIdList);
                TaxPersonRecordEntryFactory.getLocalInstance(ctx).addnewBatchData(entryCollection);
                this.updateDifference(ctx, taxCalInitDetailIds);
            }
            String billId = this.addMessageBody(batchMessageTipsHeader, allPersonRecords, errMsgMap);
            batchMessageTipsHeader.setBillId(billId);
            batchMessageTipsHeader.setSuccessCount(success);
            batchMessageTipsHeader.setFailureCount(errMsgMap == null ? 0 : errMsgMap.size());
            return batchMessageTipsHeader;
        }
        catch (Exception e) {
            logger.error((Object)"_genPersonDeclaration error: ", (Throwable)e);
            throw new BOSException("Failed to generate person declaration, caused by: " + e.getMessage());
        }
    }

    private void updateDifference(Context ctx, String taxCalInitDetailIds) throws BOSException {
        String updateSQL = "update t_hr_sTaxCalInitDetail set fDifference = 10 where fid in (SELECT t2.fid FROM T_HR_STaxCalInitDetail t1, T_HR_STaxCalInitDetail t2  where t1.fPersonId = t2.fPersonId and t1.fTaxUnitId = t2.fTaxUnitId   and t1.fid in " + taxCalInitDetailIds + ") ";
        DbUtil.execute((Context)ctx, (String)updateSQL);
    }

    private void addTaxPersonRecordEntry(CoreBaseCollection entryCollection, TaxPersonRecordEntryInfo entryInfo) {
        if (entryCollection.isEmpty()) {
            entryCollection.add((CoreBaseInfo)entryInfo);
            return;
        }
        for (int i = 0; i < entryCollection.size(); ++i) {
            TaxPersonRecordEntryInfo info = (TaxPersonRecordEntryInfo)entryCollection.get(i);
            if (!info.getTaxUnit().getId().toString().equals(entryInfo.getTaxUnit().getId().toString()) || !info.getPerson().getId().toString().equals(entryInfo.getPerson().getId().toString())) continue;
            return;
        }
        entryCollection.add((CoreBaseInfo)entryInfo);
    }

    private String getTaxCalInitDetailIds4Update(Map<String, String> initCal2Person, List<String> personIdList) {
        StringBuilder inCondition = new StringBuilder();
        for (Map.Entry<String, String> entry : initCal2Person.entrySet()) {
            if (!personIdList.contains(entry.getValue())) continue;
            if (inCondition.length() > 0) {
                inCondition.append(",");
            }
            inCondition.append(entry.getKey());
        }
        return CmpStrUtil.buildInSql(inCondition.toString());
    }

    private int getPersonCount(CoreBaseCollection entryCollection, List<String> personIdList) {
        HashSet<String> persons = new HashSet<String>();
        for (int i = 0; i < entryCollection.size(); ++i) {
            TaxPersonRecordEntryInfo entry = (TaxPersonRecordEntryInfo)entryCollection.get(i);
            if (null != entry.getBill() && null != entry.getBill().getId()) {
                persons.add(entry.getBill().getId().toString());
            }
            personIdList.add(entry.getPerson().getId().toString());
        }
        return persons.size();
    }

    private boolean isTheSameTaxPersonRecordEntry(TaxPersonRecordEntryInfo existed, TaxPersonRecordEntryInfo entry) {
        return existed.getPerson().getId().equals((Object)entry.getPerson().getId()) && existed.getTaxUnit().getId().equals((Object)entry.getTaxUnit().getId());
    }

    private String addMessageBody(BatchMessageTipsHeader batchMessageTipsHeader, TaxPersonRecordCollection allPersonRecords, Map<String, String> errMsgMap) {
        StringBuilder billId = new StringBuilder();
        for (int i = 0; i < allPersonRecords.size(); ++i) {
            TaxPersonRecordInfo t = allPersonRecords.get(i);
            String id = t.getId().toString();
            if (i > 0) {
                billId.append(",");
            }
            billId.append(id);
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(id);
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            String prefix = t.getPerson().getNumber() + "#" + t.getPerson().getName() + "#";
            body.setMuitTipsMessage(prefix + "\u751f\u6210\u4eba\u5458\u62a5\u7a0e\u4fe1\u606f\u6210\u529f\uff01");
            if (null != errMsgMap) {
                for (Map.Entry<String, String> entry : errMsgMap.entrySet()) {
                    if (!entry.getKey().equals(id)) continue;
                    body.setMuitTipsState(Boolean.FALSE.booleanValue());
                    body.setMuitTipsMessage(prefix + entry.getValue());
                }
            }
            batchMessageTipsHeader.addResult(body);
        }
        return billId.toString();
    }

    private void setBillId(Context ctx, CoreBaseCollection entryCollection, TaxPersonRecordCollection allPersonRecords, Map<String, String> errMsgMap, List<String> personIdList) throws BOSException {
        int i;
        Iterator iterator = entryCollection.iterator();
        block0: while (iterator.hasNext()) {
            TaxPersonRecordEntryInfo entry = (TaxPersonRecordEntryInfo)iterator.next();
            for (i = 0; i < allPersonRecords.size(); ++i) {
                TaxPersonRecordInfo bill = allPersonRecords.get(i);
                if (!entry.getPerson().getId().equals((Object)bill.getPerson().getId())) continue;
                if (null != errMsgMap && errMsgMap.containsKey(bill.getId().toString())) {
                    iterator.remove();
                    continue block0;
                }
                entry.setBill(bill);
                continue block0;
            }
        }
        ArrayList<String> persons = new ArrayList<String>();
        for (i = 0; i < entryCollection.size(); ++i) {
            TaxPersonRecordEntryInfo entry = (TaxPersonRecordEntryInfo)entryCollection.get(i);
            persons.add(entry.getPerson().getId().toString());
        }
        String oql = "select taxUnit.id, person.id where person.id in (" + CmpStrUtil.converCollectionToSql(persons) + ")";
        TaxPersonRecordEntryCollection existedData = TaxPersonRecordEntryFactory.getLocalInstance(ctx).getTaxPersonRecordEntryCollection(oql);
        for (int i2 = 0; i2 < existedData.size(); ++i2) {
            TaxPersonRecordEntryInfo existed = existedData.get(i2);
            Iterator it = entryCollection.iterator();
            while (it.hasNext()) {
                TaxPersonRecordEntryInfo entry = (TaxPersonRecordEntryInfo)it.next();
                if (!this.isTheSameTaxPersonRecordEntry(existed, entry)) continue;
                errMsgMap.put(entry.getBill().getId().toString(), "\u4eba\u5458\u62a5\u7a0e\u4fe1\u606f\u5df2\u5b58\u5728");
                personIdList.add(entry.getPerson().getId().toString());
                it.remove();
            }
        }
    }

    protected Map<String, String> dealWithNewPersonRecord(IRowSet rowSet, CoreBaseCollection taxPersonRecordCollection, TaxPersonRecordCollection allPersonRecords, GenPersonDeclaration param) throws SQLException, ParseException {
        HashMap<String, String> result = new HashMap<String, String>();
        while (rowSet.next()) {
            String errMsg;
            boolean isOversea;
            TaxPersonRecordInfo personRecord = new TaxPersonRecordInfo();
            personRecord.setGender(Genders.getEnum((int)rowSet.getInt("gender")));
            PersonInfo personInfo = new PersonInfo();
            String personId = rowSet.getString("fid");
            personInfo.setId(BOSUuid.read((String)personId));
            personInfo.setName(rowSet.getString("name"));
            personInfo.setNumber(rowSet.getString("number"));
            personRecord.setPerson(personInfo);
            personRecord.setIsOversea(IsOverseaEnum.getEnum(param.getIsOversea()));
            personRecord.setId(BOSUuid.create((BOSObjectType)personRecord.getBOSType()));
            allPersonRecords.add(personRecord);
            boolean bl = isOversea = IsOverseaEnum.IsOversea == personRecord.getIsOversea();
            if (isOversea) {
                personRecord.setEntryDate(CmpDateUtil.parseDate(param.getEntryDate()));
                personRecord.setLeaveDate(CmpDateUtil.parseDate(param.getLeaveDate()));
                personRecord.setTaxReason(TaxReasonEnum.getEnum(param.getTaxReason()));
                NationalityInfo birthPlace = new NationalityInfo();
                birthPlace.setId(BOSUuid.read((String)param.getBirthPlaceId()));
                personRecord.setBirthPlace(birthPlace);
                String cardNo = rowSet.getString("passportNo");
                if (StringUtils.isEmpty((String)cardNo)) {
                    result.put(personRecord.getId().toString(), "\u5883\u5916\u4eba\u5458\u9700\u8981\u5b8c\u5584\u62a4\u7167\u4fe1\u606f");
                    continue;
                }
                String otherCardType = rowSet.getString("otherCardType");
                String errMsg2 = this.setCardType(otherCardType, personRecord);
                personRecord.setCardNumber(cardNo);
            } else {
                String cardNo = rowSet.getString("idCardNo");
                if (StringUtils.isEmpty((String)cardNo)) {
                    result.put(personRecord.getId().toString(), "\u975e\u5883\u5916\u4eba\u5458\u8bf7\u5b8c\u5584\u8eab\u4efd\u8bc1\u53f7");
                    continue;
                }
                personRecord.setCardType(CardTypeEnum.IdCard);
                personRecord.setTaxNumber(cardNo);
                personRecord.setCardNumber(cardNo);
            }
            personRecord.setReportName(rowSet.getString("name"));
            personRecord.setNumber(rowSet.getString("number"));
            personRecord.setName(rowSet.getString("name"));
            personRecord.setBirthday(rowSet.getDate("birthday"));
            String nationalityId = rowSet.getString("nationalityId");
            if (!StringUtils.isEmpty((String)nationalityId)) {
                NationalityInfo nationalityInfo = new NationalityInfo();
                nationalityInfo.setId(BOSUuid.read((String)nationalityId));
                personRecord.setNationality(nationalityInfo);
            }
            personRecord.setPhoneNumber(rowSet.getString("phone"));
            personRecord.setEmail(rowSet.getString("email"));
            personRecord.setIsDisability(false);
            personRecord.setIsHero(false);
            personRecord.setIsOld(false);
            String highestDegreeId = rowSet.getString("highestDegreeId");
            if (!StringUtils.isEmpty((String)highestDegreeId)) {
                DiplomaInfo diplomaInfo = new DiplomaInfo();
                diplomaInfo.setId(BOSUuid.read((String)highestDegreeId));
                personRecord.setEduLevel(diplomaInfo);
            }
            if ((errMsg = this.isComplete(personRecord)).length() > 0) {
                result.put(personRecord.getId().toString(), errMsg);
                continue;
            }
            taxPersonRecordCollection.add((CoreBaseInfo)personRecord);
        }
        return result;
    }

    protected String setCardType(String otherCardType, TaxPersonRecordInfo personRecord) {
        if (null == otherCardType) {
            return "\u672a\u77e5\u7684\u8bc1\u4ef6\u7c7b\u578b";
        }
        personRecord.setCardType(TaxReportUtil.convertCardType(otherCardType));
        return null;
    }

    protected boolean setEmployDateAndTaxUnit(TaxPersonRecordEntryInfo entryInfo, TaxCalInitDetailInfo taxCalInitDetail) {
        if (null == taxCalInitDetail.getCmpCalTable().getCmpEmpORelation()) {
            return false;
        }
        if (null == taxCalInitDetail.getCmpCalTable().getCmpEmpORelation().getEffectDate()) {
            return false;
        }
        entryInfo.setEmployedDate(taxCalInitDetail.getCmpCalTable().getCmpEmpORelation().getEffectDate());
        entryInfo.setTaxUnit(taxCalInitDetail.getTaxUnit());
        return true;
    }

    protected TaxPersonRecordEntryInfo initPersonRecordEntry(GenPersonDeclaration param, PersonInfo personInfo) {
        TaxPersonRecordEntryInfo entryInfo = new TaxPersonRecordEntryInfo();
        entryInfo.setDeductFees(DeductFeesEnum.getEnum(param.getDeductFees()));
        entryInfo.setEmployedType(EmployedTypeEnum.getEnum(param.getEmployedType()));
        entryInfo.setPayerType(PayerTypeEnum.getEnum(param.getPayerType()));
        if (null != param.getSituation()) {
            entryInfo.setSituation(EmploymentSituationEnum.getEnum(param.getSituation()));
        }
        entryInfo.setPersonStatus(PersonStatusEnum.Normal);
        entryInfo.setSubmitStatus(SubmitStatusEnum.NotSubmit);
        entryInfo.setIdentityStatus(IdentityStatusEnume.WaitVerify);
        entryInfo.setPerson(personInfo);
        entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        return entryInfo;
    }

    protected String isComplete(TaxPersonRecordInfo personRecord) {
        ArrayList<String> fields = new ArrayList<String>();
        if (StringUtils.isEmpty((String)personRecord.getCardNumber())) {
            fields.add("[\u8bc1\u4ef6\u53f7\u7801]");
        }
        if (StringUtils.isEmpty((String)personRecord.getPhoneNumber())) {
            fields.add("[\u624b\u673a\u53f7\u7801]");
        }
        if (null == personRecord.getBirthday()) {
            fields.add("[\u51fa\u751f\u65e5\u671f]");
        }
        if (null == personRecord.getNationality()) {
            fields.add("[\u56fd\u7c4d]");
        }
        if (null == personRecord.getGender()) {
            fields.add("[\u6027\u522b]");
        }
        if (fields.size() > 0) {
            return this.combineByComma(fields) + "\u4e3a\u7a7a\uff01";
        }
        return "";
    }

    public String combineByComma(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String o : list) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(o);
        }
        return sb.toString();
    }
}

