/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigEntryCollection;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigEntryInfo;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigFactory;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigInfo;
import com.kingdee.shr.compensation.app.timepiece.scheme.AbstractSchemeOutDataConfigControllerBean;
import com.kingdee.shr.compensation.app.timepiece.scheme.OutDataAccValtype;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeOutDataConfigCollection;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeOutDataConfigDimensionCollection;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeOutDataConfigDimensionInfo;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeOutDataConfigEntryCollection;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeOutDataConfigEntryInfo;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeOutDataConfigFactory;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeOutDataConfigInfo;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeFactory;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.BusinessRelationConfigCollection;
import com.kingdee.shr.validaterule.BusinessRelationConfigFactory;
import com.kingdee.shr.validaterule.BusinessRelationConfigInfo;
import com.kingdee.shr.validaterule.BusinessSchemeType;
import com.kingdee.shr.validaterule.CalFlag;
import com.kingdee.shr.validaterule.FormulaType;
import com.kingdee.shr.validaterule.IBaseFormula;
import com.kingdee.shr.validaterule.IBusinessRelationConfig;
import com.kingdee.shr.validaterule.IsCalFormula;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;

public class SchemeOutDataConfigControllerBean
extends AbstractSchemeOutDataConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.timepiece.scheme.SchemeOutDataConfigControllerBean");

    @Override
    protected String _saveOutDataConfig(Context ctx, Map param) throws BOSException, EASBizException {
        String deleteRowId = MapUtils.getString((Map)param, (Object)"deleteRowId");
        String timepieceSchemeId = MapUtils.getString((Map)param, (Object)"timepieceSchemeId");
        String config = MapUtils.getString((Map)param, (Object)"config");
        CoreBaseCollection outDataConfigCollection = this.buildOutDataConfigCollection(ctx, timepieceSchemeId, config);
        Map<String, String> formulaRel = this.getEntryId2FormulaIdRel(ctx, timepieceSchemeId);
        if (!outDataConfigCollection.isEmpty()) {
            SchemeOutDataConfigFactory.getLocalInstance(ctx).saveBatchData(outDataConfigCollection);
        }
        this.deleteRowByConfigId(ctx, deleteRowId);
        this.generateFormulaByEntryConfig(ctx, timepieceSchemeId, formulaRel);
        this.afterSave(ctx, timepieceSchemeId);
        return null;
    }

    protected void afterSave(Context ctx, String timepieceSchemeId) throws BOSException {
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)"select fid    from T_HR_SchemeOutDataConfig where FtimepieceSchemeid = ? ", (Object[])new Object[]{timepieceSchemeId});
        if (iRowSet.size() > 0) {
            DbUtil.execute((Context)ctx, (String)"update T_HR_STimepieceScheme set fishasOutdata=1 where fid  = ? ", (Object[])new Object[]{timepieceSchemeId});
        } else {
            DbUtil.execute((Context)ctx, (String)"update T_HR_STimepieceScheme set fishasOutdata=0 where fid  = ? ", (Object[])new Object[]{timepieceSchemeId});
        }
    }

    protected void generateFormulaByEntryConfig(Context ctx, String timepieceSchemeId, Map<String, String> formulaRel) throws BOSException, EASBizException {
        TimepieceSchemeInfo timepieceSchemeInfo = TimepieceSchemeFactory.getLocalInstance(ctx).getTimepieceSchemeInfo((IObjectPK)new ObjectUuidPK(timepieceSchemeId));
        String submitSchemeId = timepieceSchemeInfo.getSubmitScheme().getId().toString();
        this.deleteCardRelFormula(ctx, timepieceSchemeId, submitSchemeId, formulaRel);
        String oql = "select id, index,externalDataConfig.id,externalDataConfig.name,externalDataConfig.number,entry.id,  entry.formula , entry.accValType, entry.calSubmitItem.id, entry.calSubmitItem.dataType, entry.calSubmitItem.fieldSn, entry.calSubmitItem.name,entry.externalDataConfigEntry.id,  entry.externalDataConfigEntry.simpleName,entry.seq where timepieceScheme.id = '" + timepieceSchemeId + "' order by index,entry.seq";
        SchemeOutDataConfigCollection outDataConfigCollection = SchemeOutDataConfigFactory.getLocalInstance(ctx).getSchemeOutDataConfigCollection(oql);
        if (outDataConfigCollection.isEmpty()) {
            return;
        }
        HashMap updateEntryFormulaMap = Maps.newHashMap();
        for (int index = 0; index < outDataConfigCollection.size(); ++index) {
            SchemeOutDataConfigInfo outDataConfigInfo = outDataConfigCollection.get(index);
            SchemeOutDataConfigEntryCollection outDataConfigInfoEntry = outDataConfigInfo.getEntry();
            String externalDataNumber = outDataConfigInfo.getExternalDataConfig().getNumber();
            for (int i = 0; i < outDataConfigInfoEntry.size(); ++i) {
                SchemeOutDataConfigEntryInfo entryInfo = outDataConfigInfoEntry.get(i);
                String formulaId = entryInfo.getFormula();
                String simpleName = entryInfo.getExternalDataConfigEntry().getSimpleName();
                String submitItem = entryInfo.getCalSubmitItem().getName();
                String value = entryInfo.getAccValType().getValue();
                CalSubmitItemDataType dataType = entryInfo.getCalSubmitItem().getDataType();
                int fieldSn = entryInfo.getCalSubmitItem().getFieldSn();
                FormulaConfig formulaConfig = new FormulaConfig(ctx, dataType, submitItem, externalDataNumber, simpleName, fieldSn, Integer.valueOf(value));
                BaseFormulaInfo baseFormulaInfo = this.buildBaseFormulaInfo(ctx, submitSchemeId, submitItem, formulaConfig, formulaId);
                this.saveBusinessRelationConfig(ctx, baseFormulaInfo);
                IBaseFormula iBaseFormula = BaseFormulaFactory.getLocalInstance((Context)ctx);
                formulaId = String.valueOf(iBaseFormula.save((CoreBaseInfo)baseFormulaInfo));
                updateEntryFormulaMap.put(entryInfo.getId().toString(), formulaId);
            }
        }
        this.updateCardRelFormula(ctx, updateEntryFormulaMap);
    }

    protected void updateCardRelFormula(Context ctx, Map<String, String> updateEntryFormulaMap) throws BOSException {
        String updateSql = "update T_HR_SchemeOutDataConfigEntry set FFormulaID = ? where FID = ?";
        ArrayList param = Lists.newArrayList();
        for (Map.Entry<String, String> entry : updateEntryFormulaMap.entrySet()) {
            param.add(new Object[]{entry.getValue(), entry.getKey()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, (List)param);
    }

    private void saveBusinessRelationConfig(Context ctx, BaseFormulaInfo baseFormulaInfo) throws BOSException, EASBizException {
        String oql = "select id where businessId = '" + baseFormulaInfo.getBusinessRelationConfig().getBusinessId().toString() + "'";
        IBusinessRelationConfig iBusinessRelationConfig = BusinessRelationConfigFactory.getLocalInstance((Context)ctx);
        BusinessRelationConfigCollection businessRelationConfigCollection = iBusinessRelationConfig.getBusinessRelationConfigCollection(oql);
        if (businessRelationConfigCollection.size() == 0) {
            IObjectPK businessRelId = iBusinessRelationConfig.save((CoreBaseInfo)baseFormulaInfo.getBusinessRelationConfig());
            baseFormulaInfo.getBusinessRelationConfig().setId(BOSUuid.read((String)businessRelId.toString()));
        } else {
            baseFormulaInfo.setBusinessRelationConfig(businessRelationConfigCollection.get(0));
        }
    }

    protected BaseFormulaInfo buildBaseFormulaInfo(Context ctx, String submitSchemeId, String submitItem, FormulaConfig formulaConfig, String formulaId) {
        BaseFormulaInfo baseFormulaInfo = new BaseFormulaInfo();
        if (!StringUtils.isEmpty((String)formulaId)) {
            baseFormulaInfo.setId(BOSUuid.read((String)formulaId));
        } else {
            baseFormulaInfo.setIsCal(IsCalFormula.YES);
        }
        BusinessRelationConfigInfo businessRelationConfigInfo = new BusinessRelationConfigInfo();
        businessRelationConfigInfo.setBusinessId(BOSUuid.read((String)submitSchemeId));
        businessRelationConfigInfo.setType(BusinessSchemeType.SubmitSchemePlan);
        baseFormulaInfo.setBusinessRelationConfig(businessRelationConfigInfo);
        String name = EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.TimepieceSchemeResource", (String)"label0", (Locale)ctx.getLocale());
        baseFormulaInfo.setName(submitItem + name);
        baseFormulaInfo.setContent(formulaConfig.content);
        baseFormulaInfo.setHtmlContent(formulaConfig.htmlContent);
        baseFormulaInfo.setSortSn(-2);
        baseFormulaInfo.setIsPreset(false);
        baseFormulaInfo.setFormulaType(FormulaType.Auto);
        baseFormulaInfo.setIsEditable(CalFlag.NO);
        baseFormulaInfo.setDescription("");
        baseFormulaInfo.setExpress(formulaConfig.express);
        baseFormulaInfo.setListItem(formulaConfig.listItem);
        baseFormulaInfo.setListFunc(formulaConfig.listFunc);
        baseFormulaInfo.setCalItem(formulaConfig.calItem);
        baseFormulaInfo.setBigExpress(formulaConfig.bigExpress);
        return baseFormulaInfo;
    }

    protected void deleteCardRelFormula(Context ctx, String timepieceSchemeId, String submitSchemeId, Map<String, String> formulaRel) throws BOSException {
        Map<String, String> checkFormulaRel = this.getEntryId2FormulaIdRel(ctx, timepieceSchemeId);
        String deleteSql = "delete from T_HR_SBaseFormula where FID = ?";
        ArrayList needDelIds = Lists.newArrayList();
        for (Map.Entry<String, String> entry : formulaRel.entrySet()) {
            if (checkFormulaRel.containsKey(entry.getKey())) continue;
            needDelIds.add(new Object[]{entry.getValue()});
        }
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, (List)needDelIds);
        String delBusSql = "delete from T_HR_SBusinessRelationConfig bu where bu.FBusinessId = '" + submitSchemeId + "' and not exists (select 1 from T_HR_SBaseFormula where bu.fid =FBusinessRelationConfigID)";
        DbUtil.execute((Context)ctx, (String)delBusSql);
    }

    protected Map<String, String> getEntryId2FormulaIdRel(Context ctx, String timepieceSchemeId) throws BOSException {
        String oql = "select entry.id, entry.formula where timepieceScheme.id = '" + timepieceSchemeId + "'";
        SchemeOutDataConfigCollection collection = SchemeOutDataConfigFactory.getLocalInstance(ctx).getSchemeOutDataConfigCollection(oql);
        HashMap formulaRel = Maps.newHashMap();
        for (int i = 0; i < collection.size(); ++i) {
            SchemeOutDataConfigEntryCollection entries = collection.get(i).getEntry();
            for (int j = 0; j < entries.size(); ++j) {
                SchemeOutDataConfigEntryInfo info = entries.get(j);
                formulaRel.put(info.getId().toString(), info.getFormula());
            }
        }
        return formulaRel;
    }

    protected CoreBaseCollection buildOutDataConfigCollection(Context ctx, String timepieceSchemeId, String config) throws BOSException, EASBizException {
        CoreBaseCollection outDataConfigCollection = new CoreBaseCollection();
        if (StringUtils.isEmpty((String)config)) {
            logger.info((Object)"method : buildSumItemConfigCollection ,config is empty!");
            return outDataConfigCollection;
        }
        JSONArray elementJSONArray = JSONArray.parseArray((String)config);
        for (int index = 0; index < elementJSONArray.size(); ++index) {
            JSONObject elementJSON = elementJSONArray.getJSONObject(index);
            outDataConfigCollection.add((CoreBaseInfo)this.assembleOutDataConfigInfo(ctx, timepieceSchemeId, elementJSON, index));
        }
        return outDataConfigCollection;
    }

    protected SchemeOutDataConfigInfo assembleOutDataConfigInfo(Context ctx, String timepieceSchemeId, JSONObject elementJSON, int index) throws BOSException, EASBizException {
        String configId = elementJSON.getString("configId");
        JSONObject externalDataConfig = elementJSON.getJSONObject("externalDataConfig");
        String externalDataConfigId = externalDataConfig.getString("id");
        SchemeOutDataConfigInfo outDataConfigInfo = new SchemeOutDataConfigInfo();
        BOSObjectType bosType = outDataConfigInfo.getBOSType();
        if (!StringUtils.isEmpty((String)configId)) {
            outDataConfigInfo.setId(BOSUuid.read((String)configId));
        } else {
            outDataConfigInfo.setId(BOSUuid.create((BOSObjectType)bosType));
        }
        outDataConfigInfo.setIndex(index);
        TimepieceSchemeInfo timepieceSchemeInfo = new TimepieceSchemeInfo();
        timepieceSchemeInfo.setId(BOSUuid.read((String)timepieceSchemeId));
        ExternalDataConfigInfo externalDataConfigInfo = new ExternalDataConfigInfo();
        externalDataConfigInfo.setId(BOSUuid.read((String)externalDataConfigId));
        outDataConfigInfo.setTimepieceScheme(timepieceSchemeInfo);
        outDataConfigInfo.setExternalDataConfig(externalDataConfigInfo);
        this.assembleRelationAttr(ctx, elementJSON, outDataConfigInfo);
        return outDataConfigInfo;
    }

    protected void beforeSave(Context ctx, CoreBaseCollection outDataConfigCollection) throws BOSException, EASBizException {
        for (int i = 0; i < outDataConfigCollection.size(); ++i) {
            SchemeOutDataConfigInfo schemeOutDataConfigInfo = (SchemeOutDataConfigInfo)outDataConfigCollection.get(i);
        }
    }

    protected void deleteRowByConfigId(Context ctx, String deleteRowId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)deleteRowId)) {
            return;
        }
        String[] ids = deleteRowId.split(",");
        CmpInSql<String> instance = CmpInSqlFactory.getInstance();
        String createInSqlBaseOnFId = instance.createInSqlBaseOnFId(ctx, Arrays.asList(ids));
        SchemeOutDataConfigFactory.getLocalInstance(ctx).delete("where id in " + createInSqlBaseOnFId);
        instance.release(ctx);
    }

    protected void assembleRelationAttr(Context ctx, JSONObject elementJSON, SchemeOutDataConfigInfo outDataConfigInfo) throws BOSException, EASBizException {
        JSONObject externalDataConfig = elementJSON.getJSONObject("externalDataConfig");
        String externalDataConfigId = externalDataConfig.getString("id");
        ExternalDataConfigInfo externalDataConfigInfo = ExternalDataConfigFactory.getLocalInstance(ctx).getExternalDataConfigInfo("where id ='" + externalDataConfigId + "'");
        ExternalDataConfigEntryCollection externalDataConfigEntryColl = externalDataConfigInfo.getEntry();
        ArrayList<String> externalDataConfigEntryIds = new ArrayList<String>();
        for (int i = 0; i < externalDataConfigEntryColl.size(); ++i) {
            ExternalDataConfigEntryInfo externalDataConfigEntryInfo = externalDataConfigEntryColl.get(i);
            externalDataConfigEntryIds.add(externalDataConfigEntryInfo.getString("id"));
        }
        JSONArray schemeOutDataConfigDimension = elementJSON.getJSONArray("schemeOutDataConfigDimension");
        JSONArray entry = elementJSON.getJSONArray("entry");
        SchemeOutDataConfigDimensionCollection dimension = new SchemeOutDataConfigDimensionCollection();
        for (int i = 0; i < schemeOutDataConfigDimension.size(); ++i) {
            JSONObject jsonObject = schemeOutDataConfigDimension.getJSONObject(i);
            SchemeOutDataConfigDimensionInfo dimensionInfo = new SchemeOutDataConfigDimensionInfo();
            ExternalDataConfigEntryInfo externalDataConfigEntryInfo = new ExternalDataConfigEntryInfo();
            String id = jsonObject.getString("id");
            externalDataConfigEntryInfo.setId(BOSUuid.read((String)id));
            dimensionInfo.setDimension(externalDataConfigEntryInfo);
            dimension.add(dimensionInfo);
        }
        outDataConfigInfo.put("schemeOutDataConfigDimension", (Object)dimension);
        SchemeOutDataConfigEntryCollection outDataConfigEntryCollection = new SchemeOutDataConfigEntryCollection();
        for (int i = 0; i < entry.size(); ++i) {
            JSONObject jsonObject = entry.getJSONObject(i);
            SchemeOutDataConfigEntryInfo outDataConfigEntryInfo = new SchemeOutDataConfigEntryInfo();
            CalSubmitItemInfo calSubmitItem = new CalSubmitItemInfo();
            calSubmitItem.setId(BOSUuid.read((String)jsonObject.getJSONObject("calSubmitItem").getString("id")));
            ExternalDataConfigEntryInfo externalDataConfigEntry = new ExternalDataConfigEntryInfo();
            String id = jsonObject.getJSONObject("externalDataConfigEntry").getString("id");
            if (!StringUtils.isEmpty((String)jsonObject.getString("id"))) {
                outDataConfigEntryInfo.setId(BOSUuid.read((String)jsonObject.getString("id")));
            }
            externalDataConfigEntry.setId(BOSUuid.read((String)id));
            outDataConfigEntryInfo.setSchemeOutDataConfig(outDataConfigInfo);
            outDataConfigEntryInfo.setCalSubmitItem(calSubmitItem);
            outDataConfigEntryInfo.setExternalDataConfigEntry(externalDataConfigEntry);
            outDataConfigEntryInfo.setSeq(i);
            outDataConfigEntryInfo.setAccValType(OutDataAccValtype.getEnum(jsonObject.getString("accValType")));
            outDataConfigEntryCollection.add(outDataConfigEntryInfo);
        }
        outDataConfigInfo.put("entry", (Object)outDataConfigEntryCollection);
    }

    private void verifyExternalDataConfigIsMatch(String externalDataConfigName, String externalDataConfigEntryName, List<String> externalDataConfigEntryIds, String id) throws BOSException, EASBizException {
        if (!externalDataConfigEntryIds.contains(id)) {
            // empty if block
        }
    }

    static class FormulaConfig {
        String content;
        String htmlContent;
        String express;
        String listFunc;
        String bigExpress;
        String calItem;
        String listItem;

        public FormulaConfig(Context ctx, CalSubmitItemDataType dataType, String submitItem, String externalDataNumber, String simpleName, int fieldSn, int valueType) {
            String formulaName1 = EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.TimepieceSchemeResource", (String)"label1", (Locale)ctx.getLocale());
            String formulaName2 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TimepieceResource", (String)"label2", (Locale)ctx.getLocale());
            if (CalSubmitItemDataType.number == dataType) {
                this.content = submitItem + " = " + formulaName1 + "(" + formulaName2 + "(\"" + externalDataNumber + "\" ,\"" + simpleName + "\"," + valueType + "))";
                this.htmlContent = "<p><span style=\"color: red;\">" + submitItem + "</span><span style=\"color: black;\">&nbsp;=&nbsp;</span><span style=\"color: #04B4AE;\">" + formulaName1 + "(<span style=\"color: #04B4AE;\">" + formulaName2 + "(&quot;" + externalDataNumber + "&quot; ,&quot;" + simpleName + "&quot;)</span>)</span></span></p>";
                this.express = "T_HR_TimepieceBillEntry_S" + fieldSn + "=FunStrToNum(FunGetExternalData(\"" + externalDataNumber + "\",\"" + simpleName + "\"," + Double.valueOf(valueType) + "));";
                this.listFunc = "0~MtydD9s3S46FKGyjpfIeUSQBOWg=~FunStrToNum;1~HVgoPqCvSweVlCI/h27gNiQBOWg=~FunGetExternalData";
                this.bigExpress = "T_HR_TimepieceBillEntry_S" + fieldSn + "=getBigVal(FunStrToNum(FunGetExternalData(\"" + externalDataNumber + "\",\"" + simpleName + "\"," + Double.valueOf(valueType) + ")));";
                this.listItem = "double~T_HR_TimepieceBillEntry~S" + fieldSn;
            } else {
                this.content = submitItem + " = " + formulaName2 + "(\"" + externalDataNumber + "\" ,\"" + simpleName + "\"," + valueType + ")";
                this.htmlContent = "<p><span style=\"color: red;\">" + submitItem + "</span><span style=\"color: black;\">&nbsp;=&nbsp;</span><span style=\"color: #04B4AE;\">" + formulaName2 + "(&quot;" + externalDataNumber + "&quot; ,&quot;" + simpleName + "&quot;," + valueType + ")</span></p>";
                this.express = "T_HR_TimepieceBillEntry_S" + fieldSn + "=FunGetExternalData(\"" + externalDataNumber + "\",\"" + simpleName + "\"," + Double.valueOf(valueType) + ");";
                this.listFunc = "1~HVgoPqCvSweVlCI/h27gNiQBOWg=~FunGetExternalData";
                this.bigExpress = "T_HR_TimepieceBillEntry_S" + fieldSn + "=FunGetExternalData(\"" + externalDataNumber + "\",\"" + simpleName + "\"," + Double.valueOf(valueType) + ");";
                this.listItem = "String~T_HR_TimepieceBillEntry~S" + fieldSn;
            }
            this.calItem = "S" + fieldSn;
        }
    }
}

