/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cmpBudget.validatecal;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.budget.BudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetValidateResultFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetValidateResultInfo;
import com.kingdee.shr.compensation.app.budget.CmpStandingBookInfo;
import com.kingdee.shr.compensation.app.budget.SubCmpStandingBookInfo;
import com.kingdee.shr.compensation.app.calculate.validate.CmpCalResultValidateParam;
import com.kingdee.shr.validaterule.ValidateState;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.base.impl.SaveCalResultImplCommon;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.formula.base.vo.VRCell;
import com.kingdee.shr.validaterule.formula.base.vo.VRRow;
import com.kingdee.shr.validaterule.util.EntityUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpBudgetSaveCalResultImplCommon
extends SaveCalResultImplCommon {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.budget.budgetadjust.cal.BudgetAdjustSaveCalResultImplCommon");

    public void saveCalResult(InitCalData initCalData, Sheet result) throws SalaryException {
        String errMsg = result.getErrMsg();
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            throw new RuntimeException(errMsg);
        }
        Map outerData = (Map)initCalData.getOuterData();
        CmpCalResultValidateParam param = (CmpCalResultValidateParam)outerData.get("param");
        this.handleResult(initCalData.getCtx(), param, result);
    }

    protected void handleResult(Context ctx, CmpCalResultValidateParam param, Sheet result) {
        if (null == result || result.getChangeDataList().isEmpty()) {
            return;
        }
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        UserInfo currentUser = (UserInfo)EntityUtil.getNewObjectInfoWithId((Object)new UserInfo(), (String)currentUserId);
        CtrlUnitInfo cu = HRFilterUtils.getCurrentCU((Context)ctx);
        CalSchemeInfo calSchemeInfo = param.getCalSchemeInfo();
        String calSchemeId = calSchemeInfo.getId().toString();
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        String period = param.getPeriod();
        boolean isSubCmpBudget = !StringUtils.isEmpty((CharSequence)period);
        List vrResultList = result.getVrResultList();
        List changeDataList = result.getChangeDataList();
        Map changeDataIndexMap = result.getChangeDataIndexMap();
        CoreBaseCollection validateResultCollection = new CoreBaseCollection();
        ArrayList delParams = Lists.newArrayList();
        int standingBookIdInx = 0;
        int subStBIdInx = 0;
        Row row0 = (Row)changeDataList.get(0);
        List cells0 = row0.getCells();
        int size = cells0.size();
        for (int i = 0; i < size; ++i) {
            String column = ((Cell)cells0.get(i)).getColumn();
            if ("STANDINGBOOK.FID".equalsIgnoreCase(column)) {
                standingBookIdInx = i;
                continue;
            }
            if (!"SUBCMPSTANDINGBOOK.FID".equalsIgnoreCase(column)) continue;
            subStBIdInx = i;
        }
        for (VRRow vrRow : vrResultList) {
            String manageId = vrRow.getId();
            Integer index = (Integer)changeDataIndexMap.get(manageId);
            Row row = (Row)changeDataList.get(index);
            List cells = row.getCells();
            String stbId = ((Cell)cells.get(standingBookIdInx)).getValue();
            String subStbId = ((Cell)cells.get(subStBIdInx)).getValue();
            BudgetManageInfo bmInfo = (BudgetManageInfo)EntityUtil.getNewObjectInfoWithId((Object)new BudgetManageInfo(), (String)manageId);
            CmpStandingBookInfo ctbInfo = (CmpStandingBookInfo)EntityUtil.getNewObjectInfoWithId((Object)new CmpStandingBookInfo(), (String)stbId);
            SubCmpStandingBookInfo sctbInfo = StringUtils.isEmpty((CharSequence)subStbId) ? null : (SubCmpStandingBookInfo)EntityUtil.getNewObjectInfoWithId((Object)new SubCmpStandingBookInfo(), (String)subStbId);
            CmpBudgetValidateResultInfo resultInfo = this.assembleResultInfo(bmInfo, calSchemeInfo, ctbInfo, sctbInfo, vrRow.getVrCells());
            this.setUserAndCu(currentUser, cu, resultInfo);
            validateResultCollection.add((CoreBaseInfo)resultInfo);
            Object[] delParam = new Object[]{manageId, stbId, calSchemeId, periodYear, periodMonth, calTime};
            if (isSubCmpBudget) {
                delParam = new Object[]{manageId, stbId, calSchemeId, periodYear, periodMonth, calTime, subStbId};
            }
            delParams.add(delParam);
        }
        this.deleteBeforeData(ctx, isSubCmpBudget, delParams);
        this.saveResult(ctx, validateResultCollection);
    }

    protected void setUserAndCu(UserInfo currentUser, CtrlUnitInfo cu, CmpBudgetValidateResultInfo resultInfo) {
        resultInfo.setCreator(currentUser);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        resultInfo.setCreateTime(timestamp);
        resultInfo.setLastUpdateUser(currentUser);
        resultInfo.setLastUpdateTime(timestamp);
        resultInfo.setCU(cu);
    }

    protected CmpBudgetValidateResultInfo assembleResultInfo(BudgetManageInfo bmInfo, CalSchemeInfo calSchemeInfo, CmpStandingBookInfo ctbInfo, SubCmpStandingBookInfo sctbInfo, List<VRCell> vrCells) {
        CmpBudgetValidateResultInfo item = new CmpBudgetValidateResultInfo();
        item.setBudgetManage(bmInfo);
        item.setCmpStandingBook(ctbInfo);
        item.setSubCmpStandingBook(sctbInfo);
        item.setCalScheme(calSchemeInfo);
        item.setPeriodYear(calSchemeInfo.getPeriodYear());
        item.setPeriodMonth(calSchemeInfo.getPeriodMonth());
        item.setCalTime(calSchemeInfo.getCalTime());
        StringBuilder warnFormula = new StringBuilder();
        ValidateState rowState = ValidateState.PASS;
        boolean isError = false;
        boolean isAppendResult = false;
        for (VRCell vrCell : vrCells) {
            if (isError) continue;
            ValidateState vrState = this.assembleState(vrCell.getWarnType(), vrCell.getResult());
            if (ValidateState.ERROR.equals((Object)vrState)) {
                isError = true;
            }
            if (vrState.getValue() <= rowState.getValue()) {
                rowState = vrState;
            }
            if (StringUtils.isEmpty((CharSequence)vrCell.getResult())) continue;
            warnFormula.append(";").append(vrCell.getResult());
            isAppendResult = true;
        }
        item.setValidateResult(rowState);
        item.setWarnFormula(isAppendResult ? warnFormula.substring(1) : warnFormula.toString());
        return item;
    }

    protected ValidateState assembleState(String warnType, String cellResult) {
        if (StringUtils.isEmpty((CharSequence)cellResult)) {
            return ValidateState.PASS;
        }
        switch (warnType) {
            case "01": {
                return ValidateState.FAILURE_FORCE;
            }
            case "02": {
                return ValidateState.FAILURE_TIPS;
            }
            case "40": {
                return ValidateState.ERROR;
            }
        }
        return ValidateState.NOT_VALIDATE;
    }

    protected void deleteBeforeData(Context ctx, boolean isSubCmpBudget, List<Object[]> delParams) {
        String delSql = "delete from T_HR_SCmpBudgetValidateResult where  FBudgetManageID = ?  and FCmpStandingBookID = ?  and FcalSchemeid = ?  and FPeriodYear = ?  and FPeriodMonth = ?  and FCalTime = ?";
        if (isSubCmpBudget) {
            delSql = delSql + " and FSubCmpStandingBookID = ?";
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)delSql, delParams);
        }
        catch (BOSException e) {
            logger.error((Object)"delete validate result error", (Throwable)e);
        }
    }

    protected void saveResult(Context ctx, CoreBaseCollection collection) {
        try {
            CmpBudgetValidateResultFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)"Save CmpBudget ValidateResult error", e);
        }
    }
}

