/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetServiceParam;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory.BaseBudgetDataServiceProcessor;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory.IBudgetDataServiceProcessor;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory.SalaryBudgetDataServiceProcessor;

public class BudgetItemConfigStrategyFactory {
    private static volatile BudgetItemConfigStrategyFactory instance = null;

    private BudgetItemConfigStrategyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BudgetItemConfigStrategyFactory getInstance() {
        if (instance != null) return instance;
        Class<BudgetItemConfigStrategyFactory> clazz = BudgetItemConfigStrategyFactory.class;
        synchronized (BudgetItemConfigStrategyFactory.class) {
            if (instance != null) return instance;
            instance = new BudgetItemConfigStrategyFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public IBudgetDataServiceProcessor getProcessor(Context ctx, BudgetServiceParam budgetServiceParam) throws BOSException {
        BudgetTemplateTypeEnum templateType = budgetServiceParam.getTemplateInfo().getTemplateType();
        BaseBudgetDataServiceProcessor processor = null;
        if (BudgetTemplateTypeEnum.SUBMIT_TYPE == templateType || BudgetTemplateTypeEnum.SPIRE_TYPE == templateType) {
            processor = new BaseBudgetDataServiceProcessor(ctx, budgetServiceParam);
        } else if (BudgetTemplateTypeEnum.SALARY_TYPE == templateType) {
            processor = new SalaryBudgetDataServiceProcessor(ctx, budgetServiceParam);
        }
        return processor;
    }
}

