/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpSummaryReportFacadeControllerBean;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCmpSummaryReportFacadeControllerBean
extends AbstractHRCmpSummaryReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpSummaryReportFacadeControllerBean");

    @Override
    protected Map _getCmpSummaryReport(Context ctx, String orgId, String period) throws BOSException, EASBizException {
        HashMap<String, Map<String, Object>> cmpReportData = new HashMap<String, Map<String, Object>>();
        Map<String, Object> mainIndexData = this.getCmpMainIndexData(ctx, orgId, period);
        cmpReportData.put("mainIndex", mainIndexData);
        return cmpReportData;
    }

    private Map<String, Object> getCmpMainIndexData(Context ctx, String orgId, String period) throws BOSException {
        HashMap<String, Object> mainIndexData = new HashMap<String, Object>();
        int year = HRCmpReportUtil.getYearViaPeriod(period);
        int month = HRCmpReportUtil.getMonthViaPeriod(period);
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, null, true);
        this.handleLaborTotal(ctx, cmpItems, orgId, year, month, mainIndexData);
        this.handlePersonTotal(ctx, cmpItems, orgId, year, month, mainIndexData);
        this.handleIndexTotal(ctx, orgId, year, month, mainIndexData);
        this.handleLaborAverage(mainIndexData);
        return mainIndexData;
    }

    private void handleLaborAverage(Map<String, Object> mainIndexData) {
        HashMap<String, Object[]> monthAverageLaborTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> quarterAverageLaborTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> yearAverageLaborTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> monthAverageIndexTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> quarterAverageIndexTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> yearAverageIndexTrend = new HashMap<String, Object[]>();
        ArrayList currAverageLaborMonthDataPoints = new ArrayList();
        ArrayList lastAverageLaborMonthDataPoints = new ArrayList();
        ArrayList currAverageLaborQuarterDataPoints = new ArrayList();
        ArrayList lastAverageLaborQuarterDataPoints = new ArrayList();
        ArrayList currAverageLaborYearDataPoints = new ArrayList();
        ArrayList currAverageIndexMonthDataPoints = new ArrayList();
        ArrayList lastAverageIndexMonthDataPoints = new ArrayList();
        ArrayList currAverageIndexQuarterDataPoints = new ArrayList();
        ArrayList lastAverageIndexQuarterDataPoints = new ArrayList();
        ArrayList currAverageIndexYearDataPoints = new ArrayList();
        double averageLabor = 0.0;
        double lastAverageLabor = 0.0;
        double averageIndex = 0.0;
        double lastAverageIndex = 0.0;
        Map monthLaborTrend = (Map)mainIndexData.get("monthLaborTrend");
        Map monthIndexTrend = (Map)mainIndexData.get("monthIndexTrend");
        Map monthPersonTrend = (Map)mainIndexData.get("monthPersonTrend");
        if (monthLaborTrend != null && monthIndexTrend != null && monthPersonTrend != null) {
            Object[] currLaborMonthDataPoints = (Object[])monthLaborTrend.get("currDataPoints");
            Object[] lastLaborMonthDataPoints = (Object[])monthLaborTrend.get("lastDataPoints");
            Object[] currIndexMonthDataPoints = (Object[])monthIndexTrend.get("currDataPoints");
            Object[] lastIndexMonthDataPoints = (Object[])monthIndexTrend.get("lastDataPoints");
            Object[] currPersonMonthDataPoints = (Object[])monthPersonTrend.get("currDataPoints");
            Object[] lastPersonMonthDataPoints = (Object[])monthPersonTrend.get("lastDataPoints");
            if (currLaborMonthDataPoints != null && lastLaborMonthDataPoints != null && currIndexMonthDataPoints != null && lastIndexMonthDataPoints != null && currPersonMonthDataPoints != null && lastPersonMonthDataPoints != null) {
                for (int i = 0; i < currLaborMonthDataPoints.length; ++i) {
                    HashMap<String, Object> currAverLaborMonthDataPoints = new HashMap<String, Object>();
                    HashMap<String, Object> lastAverLaborMonthDataPoints = new HashMap<String, Object>();
                    HashMap<String, Object> currAverIndexMonthDataPoints = new HashMap<String, Object>();
                    HashMap<String, Object> lastAverIndexMonthDataPoints = new HashMap<String, Object>();
                    String currLabel = (String)((Map)currLaborMonthDataPoints[i]).get("x");
                    double currLaborTotal = Double.valueOf(((Map)currLaborMonthDataPoints[i]).get("y").toString());
                    double currIndexTotal = Double.valueOf(((Map)currIndexMonthDataPoints[i]).get("y").toString());
                    int currPersonTotal = Integer.valueOf(((Map)currPersonMonthDataPoints[i]).get("y").toString());
                    double currAverageLabor = 0.0;
                    double currAverageIndex = 0.0;
                    if (currPersonTotal != 0) {
                        currAverageLabor = currLaborTotal / (double)currPersonTotal;
                        currAverageIndex = currIndexTotal / (double)currPersonTotal;
                    }
                    currAverLaborMonthDataPoints.put("x", currLabel);
                    currAverLaborMonthDataPoints.put("y", HRCmpReportUtil.formatDouble(currAverageLabor));
                    currAverageLaborMonthDataPoints.add(currAverLaborMonthDataPoints);
                    currAverIndexMonthDataPoints.put("x", currLabel);
                    currAverIndexMonthDataPoints.put("y", HRCmpReportUtil.formatDouble(currAverageIndex));
                    currAverageIndexMonthDataPoints.add(currAverIndexMonthDataPoints);
                    String lastLabel = (String)((Map)lastLaborMonthDataPoints[i]).get("x");
                    double lastLaborTotal = Double.valueOf(((Map)lastLaborMonthDataPoints[i]).get("y").toString());
                    double lastIndexTotal = Double.valueOf(((Map)lastIndexMonthDataPoints[i]).get("y").toString());
                    int lastPersonTotal = Integer.valueOf(((Map)lastPersonMonthDataPoints[i]).get("y").toString());
                    double lastAverLabor = 0.0;
                    double lastAverIndex = 0.0;
                    if (lastPersonTotal != 0) {
                        lastAverLabor = lastLaborTotal / (double)lastPersonTotal;
                        lastAverIndex = lastIndexTotal / (double)lastPersonTotal;
                    }
                    lastAverLaborMonthDataPoints.put("x", lastLabel);
                    lastAverLaborMonthDataPoints.put("y", HRCmpReportUtil.formatDouble(lastAverLabor));
                    lastAverageLaborMonthDataPoints.add(lastAverLaborMonthDataPoints);
                    lastAverIndexMonthDataPoints.put("x", lastLabel);
                    lastAverIndexMonthDataPoints.put("y", HRCmpReportUtil.formatDouble(lastAverIndex));
                    lastAverageIndexMonthDataPoints.add(lastAverIndexMonthDataPoints);
                }
            }
        }
        monthAverageLaborTrend.put("currDataPoints", currAverageLaborMonthDataPoints.toArray());
        monthAverageLaborTrend.put("lastDataPoints", lastAverageLaborMonthDataPoints.toArray());
        mainIndexData.put("monthAverageLaborTrend", monthAverageLaborTrend);
        monthAverageIndexTrend.put("currDataPoints", currAverageIndexMonthDataPoints.toArray());
        monthAverageIndexTrend.put("lastDataPoints", lastAverageIndexMonthDataPoints.toArray());
        mainIndexData.put("monthAverageIndexTrend", monthAverageIndexTrend);
        Map quarterLaborTrend = (Map)mainIndexData.get("quarterLaborTrend");
        Map quarterIndexTrend = (Map)mainIndexData.get("quarterIndexTrend");
        Map quarterPersonTrend = (Map)mainIndexData.get("quarterPersonTrend");
        if (quarterLaborTrend != null && quarterPersonTrend != null) {
            Object[] currLaborQuarterDataPoints = (Object[])quarterLaborTrend.get("currDataPoints");
            Object[] lastLaborQuarterDataPoints = (Object[])quarterLaborTrend.get("lastDataPoints");
            Object[] currIndexQuarterDataPoints = (Object[])quarterIndexTrend.get("currDataPoints");
            Object[] lastIndexQuarterDataPoints = (Object[])quarterIndexTrend.get("lastDataPoints");
            Object[] currPersonQuarterDataPoints = (Object[])quarterPersonTrend.get("currDataPoints");
            Object[] lastPersonQuarterDataPoints = (Object[])quarterPersonTrend.get("lastDataPoints");
            if (currLaborQuarterDataPoints != null && lastLaborQuarterDataPoints != null && currIndexQuarterDataPoints != null && lastIndexQuarterDataPoints != null && currPersonQuarterDataPoints != null && lastPersonQuarterDataPoints != null) {
                for (int i = 0; i < currLaborQuarterDataPoints.length; ++i) {
                    HashMap<String, Object> currAverLaborQuarterDataPoints = new HashMap<String, Object>();
                    HashMap<String, Object> lastAverLaborQuarterDataPoints = new HashMap<String, Object>();
                    HashMap<String, Object> currAverIndexQuarterDataPoints = new HashMap<String, Object>();
                    HashMap<String, Object> lastAverIndexQuarterDataPoints = new HashMap<String, Object>();
                    String currLabel = (String)((Map)currLaborQuarterDataPoints[i]).get("x");
                    double currLaborTotal = Double.valueOf(((Map)currLaborQuarterDataPoints[i]).get("y").toString());
                    double currIndexTotal = Double.valueOf(((Map)currIndexQuarterDataPoints[i]).get("y").toString());
                    int currPersonTotal = Integer.valueOf(((Map)currPersonQuarterDataPoints[i]).get("y").toString());
                    double currAverageLabor = 0.0;
                    double currAverageIndex = 0.0;
                    if (currPersonTotal != 0) {
                        currAverageLabor = currLaborTotal / (double)currPersonTotal;
                        currAverageIndex = currIndexTotal / (double)currPersonTotal;
                    }
                    currAverLaborQuarterDataPoints.put("x", currLabel);
                    currAverLaborQuarterDataPoints.put("y", HRCmpReportUtil.formatDouble(currAverageLabor));
                    currAverageLaborQuarterDataPoints.add(currAverLaborQuarterDataPoints);
                    currAverIndexQuarterDataPoints.put("x", currLabel);
                    currAverIndexQuarterDataPoints.put("y", HRCmpReportUtil.formatDouble(currAverageIndex));
                    currAverageIndexQuarterDataPoints.add(currAverIndexQuarterDataPoints);
                    String lastLabel = (String)((Map)lastLaborQuarterDataPoints[i]).get("x");
                    double lastLaborTotal = Double.valueOf(((Map)lastLaborQuarterDataPoints[i]).get("y").toString());
                    double lastIndexTotal = Double.valueOf(((Map)lastIndexQuarterDataPoints[i]).get("y").toString());
                    int lastPersonTotal = Integer.valueOf(((Map)lastPersonQuarterDataPoints[i]).get("y").toString());
                    double lastAverLabor = 0.0;
                    double lastAverIndex = 0.0;
                    if (lastPersonTotal != 0) {
                        lastAverLabor = lastLaborTotal / (double)lastPersonTotal;
                        lastAverIndex = lastIndexTotal / (double)lastPersonTotal;
                    }
                    lastAverLaborQuarterDataPoints.put("x", lastLabel);
                    lastAverLaborQuarterDataPoints.put("y", HRCmpReportUtil.formatDouble(lastAverLabor));
                    lastAverageLaborQuarterDataPoints.add(lastAverLaborQuarterDataPoints);
                    lastAverIndexQuarterDataPoints.put("x", lastLabel);
                    lastAverIndexQuarterDataPoints.put("y", HRCmpReportUtil.formatDouble(lastAverIndex));
                    lastAverageIndexQuarterDataPoints.add(lastAverIndexQuarterDataPoints);
                }
            }
        }
        quarterAverageLaborTrend.put("currDataPoints", currAverageLaborQuarterDataPoints.toArray());
        quarterAverageLaborTrend.put("lastDataPoints", lastAverageLaborQuarterDataPoints.toArray());
        mainIndexData.put("quarterAverageLaborTrend", quarterAverageLaborTrend);
        quarterAverageIndexTrend.put("currDataPoints", currAverageIndexQuarterDataPoints.toArray());
        quarterAverageIndexTrend.put("lastDataPoints", lastAverageIndexQuarterDataPoints.toArray());
        mainIndexData.put("quarterAverageIndexTrend", quarterAverageIndexTrend);
        Map yearLaborTrend = (Map)mainIndexData.get("yearLaborTrend");
        Map yearIndexTrend = (Map)mainIndexData.get("yearIndexTrend");
        Map yearPersonTrend = (Map)mainIndexData.get("yearPersonTrend");
        if (yearLaborTrend != null && yearPersonTrend != null) {
            Object[] currLaborYearDataPoints = (Object[])yearLaborTrend.get("currDataPoints");
            Object[] currIndexYearDataPoints = (Object[])yearIndexTrend.get("currDataPoints");
            Object[] currPersonYearDataPoints = (Object[])yearPersonTrend.get("currDataPoints");
            if (currLaborYearDataPoints != null && currIndexYearDataPoints != null && currPersonYearDataPoints != null) {
                for (int i = 0; i < currLaborYearDataPoints.length; ++i) {
                    HashMap<String, Object> currAverLaborYearDataPoints = new HashMap<String, Object>();
                    HashMap<String, Object> currAverIndexYearDataPoints = new HashMap<String, Object>();
                    String currLabel = (String)((Map)currLaborYearDataPoints[i]).get("x");
                    double currLaborTotal = Double.valueOf(((Map)currLaborYearDataPoints[i]).get("y").toString());
                    double currIndexTotal = 0.0;
                    if (i <= currIndexYearDataPoints.length - 1) {
                        currIndexTotal = Double.valueOf(((Map)currIndexYearDataPoints[i]).get("y").toString());
                    }
                    int currPersonTotal = Integer.valueOf(((Map)currPersonYearDataPoints[i]).get("y").toString());
                    double currAverageLabor = 0.0;
                    double currAverageIndex = 0.0;
                    if (currPersonTotal != 0) {
                        currAverageLabor = currLaborTotal / (double)currPersonTotal;
                        currAverageIndex = currIndexTotal / (double)currPersonTotal;
                    }
                    currAverLaborYearDataPoints.put("x", currLabel);
                    currAverLaborYearDataPoints.put("y", HRCmpReportUtil.formatDouble(currAverageLabor));
                    currAverageLaborYearDataPoints.add(currAverLaborYearDataPoints);
                    currAverIndexYearDataPoints.put("x", currLabel);
                    currAverIndexYearDataPoints.put("y", HRCmpReportUtil.formatDouble(currAverageIndex));
                    currAverageIndexYearDataPoints.add(currAverIndexYearDataPoints);
                }
            }
        }
        yearAverageLaborTrend.put("currDataPoints", currAverageLaborYearDataPoints.toArray());
        mainIndexData.put("yearAverageLaborTrend", yearAverageLaborTrend);
        yearAverageIndexTrend.put("currDataPoints", currAverageIndexYearDataPoints.toArray());
        mainIndexData.put("yearAverageIndexTrend", yearAverageIndexTrend);
        Double laborTotal = (Double)mainIndexData.get("laborTotal");
        Double indexTotal = (Double)mainIndexData.get("indexTotal");
        Integer personTotal = (Integer)mainIndexData.get("personTotal");
        if (laborTotal != null && indexTotal != null && personTotal != null) {
            averageLabor = personTotal == 0 ? 0.0 : HRCmpReportUtil.formatDouble(laborTotal / (double)personTotal.intValue());
            averageIndex = personTotal == 0 ? 0.0 : HRCmpReportUtil.formatDouble(indexTotal / (double)personTotal.intValue());
        }
        mainIndexData.put("averageLabor", averageLabor);
        mainIndexData.put("averageIndex", averageIndex);
        Double lastLaborTotal = (Double)mainIndexData.get("lastLaborTotal");
        Double lastIndexTotal = (Double)mainIndexData.get("lastIndexTotal");
        Integer lastPersonTotal = (Integer)mainIndexData.get("lastPersonTotal");
        if (lastLaborTotal != null && lastIndexTotal != null && lastPersonTotal != null) {
            lastAverageLabor = lastPersonTotal == 0 ? 0.0 : HRCmpReportUtil.formatDouble(lastLaborTotal / (double)lastPersonTotal.intValue());
            lastAverageIndex = lastPersonTotal == 0 ? 0.0 : HRCmpReportUtil.formatDouble(lastIndexTotal / (double)lastPersonTotal.intValue());
        }
        mainIndexData.put("lastAverageLabor", lastAverageLabor);
        mainIndexData.put("lastAverageIndex", lastAverageIndex);
        String averageDiscrepancyRate = "";
        averageDiscrepancyRate = lastAverageLabor != 0.0 ? HRCmpReportUtil.formatDouble((averageLabor - lastAverageLabor) * 100.0 / lastAverageLabor) + "%" : "0%";
        mainIndexData.put("averageDiscrepancyRate", averageDiscrepancyRate);
    }

    private void handleIndexTotal(Context ctx, String orgId, int year, int month, Map<String, Object> mainIndexData) throws BOSException {
        HashMap<String, Object[]> monthIndexTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> quarterIndexTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> yearIndexTrend = new HashMap<String, Object[]>();
        double index = 0.0;
        double lastIndex = 0.0;
        ArrayList currIndexMonthDataPoints = new ArrayList();
        ArrayList lastIndexMonthDataPoints = new ArrayList();
        ArrayList currIndexQuarterDataPoints = new ArrayList();
        ArrayList lastIndexQuarterDataPoints = new ArrayList();
        ArrayList currIndexYearDataPoints = new ArrayList();
        TreeMap<String, Object> monthMap = new TreeMap<String, Object>();
        TreeMap<String, Object> quarterMap = new TreeMap<String, Object>();
        TreeMap<String, Object> yearMap = new TreeMap<String, Object>();
        String sumIndexSql = HRCmpReportUtil.getSumIndexByPeriodYearAndMonth(ctx, orgId, year, month);
        try {
            Double lastValue;
            Double currValue;
            int i;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sumIndexSql.toString());
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("periodYear");
                int rsMonth = rowSet.getInt("periodMonth");
                double total = rowSet.getDouble("total");
                if (rsYear == year || rsYear == year - 1) {
                    String monthLabel = rsYear + "-" + rsMonth;
                    this.addTotalToCollection(total, monthLabel, monthMap);
                    String quarterLabel = rsYear + "-1";
                    if (1 <= rsMonth && rsMonth <= 3) {
                        quarterLabel = rsYear + "-1";
                    }
                    if (4 <= rsMonth && rsMonth <= 6) {
                        quarterLabel = rsYear + "-2";
                    }
                    if (7 <= rsMonth && rsMonth <= 9) {
                        quarterLabel = rsYear + "-3";
                    }
                    if (10 <= rsMonth && rsMonth <= 12) {
                        quarterLabel = rsYear + "-4";
                    }
                    this.addTotalToCollection(total, quarterLabel, quarterMap);
                }
                String yearLabel = rsYear + "";
                this.addTotalToCollection(total, yearLabel, yearMap);
            }
            for (i = 1; i <= 12; ++i) {
                String lastMonthLabel;
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                HashMap<String, Object> lastDataPointsMap = new HashMap<String, Object>();
                currDataPointsMap.put("x", String.valueOf(i));
                String currMonthLabel = year + "-" + i;
                currValue = (Double)monthMap.get(currMonthLabel);
                if (currValue != null) {
                    currDataPointsMap.put("y", currValue);
                    if (month == i) {
                        index = currValue;
                    } else if (month == i + 1 && month != 1) {
                        lastMonthLabel = year + "-" + i;
                        lastValue = (Double)monthMap.get(lastMonthLabel);
                        if (lastValue != null) {
                            lastIndex = lastValue;
                        }
                    } else if (month == 1 && (lastValue = (Double)monthMap.get(lastMonthLabel = year - 1 + "-12")) != null) {
                        lastIndex = lastValue;
                    }
                } else {
                    currDataPointsMap.put("y", 0);
                    if (month == i) {
                        index = 0.0;
                    }
                }
                currIndexMonthDataPoints.add(currDataPointsMap);
                lastDataPointsMap.put("x", String.valueOf(i));
                lastMonthLabel = year - 1 + "-" + i;
                lastValue = (Double)monthMap.get(lastMonthLabel);
                if (lastValue != null) {
                    lastDataPointsMap.put("y", lastValue);
                } else {
                    lastDataPointsMap.put("y", 0);
                }
                lastIndexMonthDataPoints.add(lastDataPointsMap);
            }
            for (i = 1; i <= 4; ++i) {
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                HashMap<String, Object> lastDataPointsMap = new HashMap<String, Object>();
                currDataPointsMap.put("x", String.valueOf(i));
                String currQuarterLabel = year + "-" + i;
                currValue = (Double)quarterMap.get(currQuarterLabel);
                if (currValue != null) {
                    currDataPointsMap.put("y", currValue);
                } else {
                    currDataPointsMap.put("y", 0);
                }
                currIndexQuarterDataPoints.add(currDataPointsMap);
                lastDataPointsMap.put("x", String.valueOf(i));
                String lastQuarterLabel = year - 1 + "-" + i;
                lastValue = (Double)quarterMap.get(lastQuarterLabel);
                if (lastValue != null) {
                    lastDataPointsMap.put("y", lastValue);
                } else {
                    lastDataPointsMap.put("y", 0);
                }
                lastIndexQuarterDataPoints.add(lastDataPointsMap);
            }
            Iterator yearIte = yearMap.keySet().iterator();
            while (yearIte.hasNext()) {
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                String yearLabel = (String)yearIte.next();
                currDataPointsMap.put("x", yearLabel);
                Double value = (Double)yearMap.get(yearLabel);
                currDataPointsMap.put("y", value);
                currIndexYearDataPoints.add(currDataPointsMap);
            }
            if (currIndexYearDataPoints.size() == 0) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                    String yearLabel = year - 1 + i2 + "";
                    currDataPointsMap.put("x", yearLabel);
                    currDataPointsMap.put("y", 0);
                    currIndexYearDataPoints.add(currDataPointsMap);
                }
            }
            logger.info("~~~~~~IndexAverage: " + index + "~~~~~~");
            mainIndexData.put("indexTotal", index);
            mainIndexData.put("lastIndexTotal", lastIndex);
            monthIndexTrend.put("currDataPoints", currIndexMonthDataPoints.toArray());
            monthIndexTrend.put("lastDataPoints", lastIndexMonthDataPoints.toArray());
            mainIndexData.put("monthIndexTrend", monthIndexTrend);
            quarterIndexTrend.put("currDataPoints", currIndexQuarterDataPoints.toArray());
            quarterIndexTrend.put("lastDataPoints", lastIndexQuarterDataPoints.toArray());
            mainIndexData.put("quarterIndexTrend", quarterIndexTrend);
            yearIndexTrend.put("currDataPoints", currIndexYearDataPoints.toArray());
            mainIndexData.put("yearIndexTrend", yearIndexTrend);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void handlePersonTotal(Context ctx, String cmpItems, String orgId, int year, int month, Map<String, Object> mainIndexData) throws BOSException {
        HashMap<String, Object[]> monthPersonTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> quarterPersonTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> yearPersonTrend = new HashMap<String, Object[]>();
        int personTotal = 0;
        int lastPersonTotal = 0;
        ArrayList currPersonMonthDataPoints = new ArrayList();
        ArrayList lastPersonMonthDataPoints = new ArrayList();
        ArrayList currPersonQuarterDataPoints = new ArrayList();
        ArrayList lastPersonQuarterDataPoints = new ArrayList();
        ArrayList currPersonYearDataPoints = new ArrayList();
        TreeMap<String, Object> monthMap = new TreeMap<String, Object>();
        TreeMap<String, Object> quarterMap = new TreeMap<String, Object>();
        TreeMap<String, Object> yearMap = new TreeMap<String, Object>();
        String detailPersonSql = HRCmpReportUtil.getDetailPersonByPeriodYearAndMonth(ctx, cmpItems, orgId, year, month);
        try {
            HashMap<String, Object> lastDataPointsMap;
            int i;
            String yearLabel;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)detailPersonSql.toString());
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("periodYear");
                int rsMonth = rowSet.getInt("periodMonth");
                String personId = rowSet.getString("personId");
                if (rsYear == year || rsYear == year - 1) {
                    String monthLabel = rsYear + "-" + rsMonth;
                    this.addPersonIdToCollection(personId, monthLabel, monthMap);
                    String quarterLabel = rsYear + "-1";
                    if (1 <= rsMonth && rsMonth <= 3) {
                        quarterLabel = rsYear + "-1";
                    }
                    if (4 <= rsMonth && rsMonth <= 6) {
                        quarterLabel = rsYear + "-2";
                    }
                    if (7 <= rsMonth && rsMonth <= 9) {
                        quarterLabel = rsYear + "-3";
                    }
                    if (10 <= rsMonth && rsMonth <= 12) {
                        quarterLabel = rsYear + "-4";
                    }
                    this.addPersonIdToCollection(personId, quarterLabel, quarterMap);
                }
                yearLabel = rsYear + "";
                this.addPersonIdToCollection(personId, yearLabel, yearMap);
            }
            for (i = 1; i <= 12; ++i) {
                HashSet lastMonthSet;
                String lastMonthLabel;
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                lastDataPointsMap = new HashMap<String, Object>();
                currDataPointsMap.put("x", String.valueOf(i));
                String currMonthLabel = year + "-" + i;
                HashSet currMonthSet = (HashSet)monthMap.get(currMonthLabel);
                if (currMonthSet != null) {
                    currDataPointsMap.put("y", currMonthSet.size());
                    if (month == i) {
                        personTotal = currMonthSet.size();
                    } else if (month == i + 1 && month != 1) {
                        lastMonthLabel = year + "-" + i;
                        lastMonthSet = (HashSet)monthMap.get(lastMonthLabel);
                        if (lastMonthSet != null) {
                            lastPersonTotal = lastMonthSet.size();
                        }
                    } else if (month == 1 && (lastMonthSet = (HashSet)monthMap.get(lastMonthLabel = year - 1 + "-12")) != null) {
                        lastPersonTotal = lastMonthSet.size();
                    }
                } else {
                    currDataPointsMap.put("y", 0);
                    if (month == i) {
                        personTotal = 0;
                    }
                }
                currPersonMonthDataPoints.add(currDataPointsMap);
                lastDataPointsMap.put("x", String.valueOf(i));
                lastMonthLabel = year - 1 + "-" + i;
                lastMonthSet = (HashSet)monthMap.get(lastMonthLabel);
                if (lastMonthSet != null) {
                    lastDataPointsMap.put("y", lastMonthSet.size());
                } else {
                    lastDataPointsMap.put("y", 0);
                }
                lastPersonMonthDataPoints.add(lastDataPointsMap);
            }
            for (i = 1; i <= 4; ++i) {
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                lastDataPointsMap = new HashMap();
                currDataPointsMap.put("x", String.valueOf(i));
                String currQuarterLabel = year + "-" + i;
                HashSet currQuarterSet = (HashSet)quarterMap.get(currQuarterLabel);
                if (currQuarterSet != null) {
                    currDataPointsMap.put("y", currQuarterSet.size());
                } else {
                    currDataPointsMap.put("y", 0);
                }
                currPersonQuarterDataPoints.add(currDataPointsMap);
                lastDataPointsMap.put("x", String.valueOf(i));
                String lastQuarterLabel = year - 1 + "-" + i;
                HashSet lastQuarterSet = (HashSet)quarterMap.get(lastQuarterLabel);
                if (lastQuarterSet != null) {
                    lastDataPointsMap.put("y", lastQuarterSet.size());
                } else {
                    lastDataPointsMap.put("y", 0);
                }
                lastPersonQuarterDataPoints.add(lastDataPointsMap);
            }
            Iterator yearIte = yearMap.keySet().iterator();
            while (yearIte.hasNext()) {
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                String yearLabel2 = (String)yearIte.next();
                currDataPointsMap.put("x", yearLabel2);
                Set personIdSet = (Set)yearMap.get(yearLabel2);
                currDataPointsMap.put("y", personIdSet.size());
                currPersonYearDataPoints.add(currDataPointsMap);
            }
            if (currPersonYearDataPoints.size() == 0) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                    yearLabel = year - 1 + i2 + "";
                    currDataPointsMap.put("x", yearLabel);
                    currDataPointsMap.put("y", 0);
                    currPersonYearDataPoints.add(currDataPointsMap);
                }
            }
            logger.info("~~~~~~personTotal: " + personTotal + "~~~~~~");
            mainIndexData.put("personTotal", personTotal);
            mainIndexData.put("lastPersonTotal", lastPersonTotal);
            monthPersonTrend.put("currDataPoints", currPersonMonthDataPoints.toArray());
            monthPersonTrend.put("lastDataPoints", lastPersonMonthDataPoints.toArray());
            mainIndexData.put("monthPersonTrend", monthPersonTrend);
            quarterPersonTrend.put("currDataPoints", currPersonQuarterDataPoints.toArray());
            quarterPersonTrend.put("lastDataPoints", lastPersonQuarterDataPoints.toArray());
            mainIndexData.put("quarterPersonTrend", quarterPersonTrend);
            yearPersonTrend.put("currDataPoints", currPersonYearDataPoints.toArray());
            mainIndexData.put("yearPersonTrend", yearPersonTrend);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void handleLaborTotal(Context ctx, String cmpItems, String orgId, int year, int month, Map<String, Object> mainIndexData) throws BOSException {
        HashMap<String, Object[]> monthLaborTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> quarterLaborTrend = new HashMap<String, Object[]>();
        HashMap<String, Object[]> yearLaborTrend = new HashMap<String, Object[]>();
        double laborTotal = 0.0;
        double lastlaborTotal = 0.0;
        double currLaborQuarter1Total = 0.0;
        double currLaborQuarter2Total = 0.0;
        double currLaborQuarter3Total = 0.0;
        double currLaborQuarter4Total = 0.0;
        double lastLaborQuarter1Total = 0.0;
        double lastLaborQuarter2Total = 0.0;
        double lastLaborQuarter3Total = 0.0;
        double lastLaborQuarter4Total = 0.0;
        double laborYearTotal = 0.0;
        ArrayList<String> currLaborMonthLabel = new ArrayList<String>();
        ArrayList<Double> currLaborMonthData = new ArrayList<Double>();
        ArrayList<String> lastLaborMonthLabel = new ArrayList<String>();
        ArrayList<Double> lastLaborMonthData = new ArrayList<Double>();
        ArrayList<String> currLaborQuarterLabel = new ArrayList<String>();
        ArrayList<Double> currLaborQuarterData = new ArrayList<Double>();
        ArrayList<String> lastLaborQuarterLabel = new ArrayList<String>();
        ArrayList<Double> lastLaborQuarterData = new ArrayList<Double>();
        ArrayList<String> laborYearLabel = new ArrayList<String>();
        ArrayList<Double> laborYearData = new ArrayList<Double>();
        ArrayList currLaborMonthDataPoints = new ArrayList();
        ArrayList lastLaborMonthDataPoints = new ArrayList();
        ArrayList currLaborQuarterDataPoints = new ArrayList();
        ArrayList lastLaborQuarterDataPoints = new ArrayList();
        ArrayList currLaborYearDataPoints = new ArrayList();
        String manageOrgIdsSql = HRCmpReportUtil.getManageOrgIdsSql(ctx, orgId, year, month);
        try {
            int i;
            IRowSet orgQuery = DbUtil.executeQuery((Context)ctx, (String)manageOrgIdsSql);
            ArrayList<String> manageOrgIdList = new ArrayList<String>();
            while (orgQuery.next()) {
                manageOrgIdList.add(orgQuery.getString("adminOrgId"));
            }
            boolean isCreateTemp = manageOrgIdList.size() > 500;
            String newManageOrgIdSql = "";
            String tempTable = "";
            if (isCreateTemp) {
                tempTable = SQLHandleUtil.createTempTableName(ctx);
                String creatTable = "select fid into " + tempTable + " from T_ORG_Admin where 1<>1";
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                Object[] params = null;
                for (String id : manageOrgIdList) {
                    params = new Object[]{id};
                    paramList.add(params);
                }
                DbUtil.execute((Context)ctx, (String)creatTable);
                String insertSql = "insert into " + tempTable + "(fid) values(?)";
                CmpSQLUtil.executeBatchAndReturn(ctx, insertSql, paramList);
                newManageOrgIdSql = " select fid from " + tempTable + " ";
            } else {
                newManageOrgIdSql = CmpStrUtil.convertListToString(manageOrgIdList);
            }
            String sumLaborSql = HRCmpReportUtil.getCostBearSumDataSql(ctx, cmpItems, newManageOrgIdSql);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sumLaborSql.toString());
            if (isCreateTemp) {
                CmpSQLUtil.releaseTemptTable(ctx, tempTable);
            }
            int referYear = 0;
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("periodYear");
                if (referYear == 0) {
                    referYear = rsYear;
                }
                if (referYear != rsYear) {
                    laborYearLabel.add(referYear + "");
                    laborYearData.add(laborYearTotal);
                    laborYearTotal = 0.0;
                    referYear = rsYear;
                }
                int rsMonth = rowSet.getInt("periodMonth");
                double total = rowSet.getDouble("total");
                laborYearTotal += total;
                if (rsYear == year) {
                    currLaborMonthLabel.add(rsMonth + "");
                    currLaborMonthData.add(total);
                    if (rsMonth == month) {
                        laborTotal = total;
                    } else if (rsMonth == month - 1 && month != 1) {
                        lastlaborTotal = total;
                    }
                    if (1 <= rsMonth && rsMonth <= 3) {
                        currLaborQuarter1Total += total;
                    }
                    if (4 <= rsMonth && rsMonth <= 6) {
                        currLaborQuarter2Total += total;
                    }
                    if (7 <= rsMonth && rsMonth <= 9) {
                        currLaborQuarter3Total += total;
                    }
                    if (10 <= rsMonth && rsMonth <= 12) {
                        currLaborQuarter4Total += total;
                    }
                }
                if (rsYear != year - 1) continue;
                lastLaborMonthLabel.add(rsMonth + "");
                lastLaborMonthData.add(total);
                if (month == 1 && rsMonth == 12) {
                    lastlaborTotal = total;
                }
                if (1 <= rsMonth && rsMonth <= 3) {
                    lastLaborQuarter1Total += total;
                }
                if (4 <= rsMonth && rsMonth <= 6) {
                    lastLaborQuarter2Total += total;
                }
                if (7 <= rsMonth && rsMonth <= 9) {
                    lastLaborQuarter3Total += total;
                }
                if (10 > rsMonth || rsMonth > 12) continue;
                lastLaborQuarter4Total += total;
            }
            laborYearLabel.add(referYear + "");
            laborYearData.add(laborYearTotal);
            currLaborQuarterLabel.add("1");
            currLaborQuarterData.add(currLaborQuarter1Total);
            currLaborQuarterLabel.add("2");
            currLaborQuarterData.add(currLaborQuarter2Total);
            currLaborQuarterLabel.add("3");
            currLaborQuarterData.add(currLaborQuarter3Total);
            currLaborQuarterLabel.add("4");
            currLaborQuarterData.add(currLaborQuarter4Total);
            lastLaborQuarterLabel.add("1");
            lastLaborQuarterData.add(lastLaborQuarter1Total);
            lastLaborQuarterLabel.add("2");
            lastLaborQuarterData.add(lastLaborQuarter2Total);
            lastLaborQuarterLabel.add("3");
            lastLaborQuarterData.add(lastLaborQuarter3Total);
            lastLaborQuarterLabel.add("4");
            lastLaborQuarterData.add(lastLaborQuarter4Total);
            for (i = 0; i < 12; ++i) {
                int index;
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                HashMap<String, Object> lastDataPointsMap = new HashMap<String, Object>();
                currDataPointsMap.put("x", String.valueOf(i + 1));
                if (currLaborMonthLabel.contains(String.valueOf(i + 1))) {
                    index = currLaborMonthLabel.indexOf(String.valueOf(i + 1));
                    currDataPointsMap.put("y", HRCmpReportUtil.formatDouble((Double)currLaborMonthData.get(index)));
                } else {
                    currDataPointsMap.put("y", 0);
                }
                currLaborMonthDataPoints.add(currDataPointsMap);
                lastDataPointsMap.put("x", String.valueOf(i + 1));
                if (lastLaborMonthLabel.contains(String.valueOf(i + 1))) {
                    index = lastLaborMonthLabel.indexOf(String.valueOf(i + 1));
                    lastDataPointsMap.put("y", HRCmpReportUtil.formatDouble((Double)lastLaborMonthData.get(index)));
                } else {
                    lastDataPointsMap.put("y", 0);
                }
                lastLaborMonthDataPoints.add(lastDataPointsMap);
            }
            for (i = 0; i < 4; ++i) {
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                HashMap<String, Object> lastDataPointsMap = new HashMap<String, Object>();
                currDataPointsMap.put("x", currLaborQuarterLabel.get(i));
                currDataPointsMap.put("y", HRCmpReportUtil.formatDouble((Double)currLaborQuarterData.get(i)));
                currLaborQuarterDataPoints.add(currDataPointsMap);
                lastDataPointsMap.put("x", lastLaborQuarterLabel.get(i));
                lastDataPointsMap.put("y", HRCmpReportUtil.formatDouble((Double)lastLaborQuarterData.get(i)));
                lastLaborQuarterDataPoints.add(lastDataPointsMap);
            }
            for (i = 0; i < laborYearLabel.size(); ++i) {
                HashMap<String, Object> currDataPointsMap = new HashMap<String, Object>();
                currDataPointsMap.put("x", String.valueOf(laborYearLabel.get(i)));
                currDataPointsMap.put("y", HRCmpReportUtil.formatDouble((Double)laborYearData.get(i)));
                currLaborYearDataPoints.add(currDataPointsMap);
            }
            logger.info("~~~~~~laborTotal: " + laborTotal + "~~~~~~");
            mainIndexData.put("laborTotal", laborTotal);
            mainIndexData.put("lastLaborTotal", lastlaborTotal);
            String laborDiscrepancyRate = "";
            laborDiscrepancyRate = lastlaborTotal != 0.0 ? HRCmpReportUtil.formatDouble((laborTotal - lastlaborTotal) * 100.0 / lastlaborTotal) + "%" : "0%";
            mainIndexData.put("laborDiscrepancyRate", laborDiscrepancyRate);
            monthLaborTrend.put("currDataPoints", currLaborMonthDataPoints.toArray());
            monthLaborTrend.put("lastDataPoints", lastLaborMonthDataPoints.toArray());
            mainIndexData.put("monthLaborTrend", monthLaborTrend);
            quarterLaborTrend.put("currDataPoints", currLaborQuarterDataPoints.toArray());
            quarterLaborTrend.put("lastDataPoints", lastLaborQuarterDataPoints.toArray());
            mainIndexData.put("quarterLaborTrend", quarterLaborTrend);
            laborYearLabel.add(referYear + "");
            laborYearData.add(laborYearTotal);
            yearLaborTrend.put("currDataPoints", currLaborYearDataPoints.toArray());
            mainIndexData.put("yearLaborTrend", yearLaborTrend);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void addTotalToCollection(double total, String label, Map<String, Object> map) {
        Double value = (Double)map.get(label);
        value = value == null ? Double.valueOf(total) : Double.valueOf(value + total);
        map.put(label, value);
    }

    private void addPersonIdToCollection(String personId, String label, Map<String, Object> map) {
        HashSet<String> set = (HashSet<String>)map.get(label);
        if (set == null) {
            set = new HashSet<String>();
        }
        set.add(personId);
        map.put(label, set);
    }
}

