/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.common.CommonMethod;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.app.formula.data.DAFactory;
import com.kingdee.shr.compensation.app.formula.data.DataAccess;
import com.kingdee.shr.compensation.app.formula.data.DataRow;
import com.kingdee.shr.compensation.app.formula.data.DataSet;
import com.kingdee.shr.compensation.app.formula.data.DataTable;
import com.kingdee.shr.compensation.app.formula.data.SQLGenerate;
import com.kingdee.shr.compensation.app.formula.tax.Salary2TaxCalExecutor;
import com.kingdee.shr.compensation.app.formula.tax.Salary2TaxCalFunMgr;
import com.kingdee.shr.compensation.app.formula.tax.Salary2TaxCalFunction;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitFacadeFactory;
import com.kingdee.shr.compensation.helper.CalSchemeBizHelper;
import com.kingdee.shr.compensation.taxCal.analysis.VerifyData4SubmitInitCal;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.shr.validaterule.formula.ISalaryCalculator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Salary2TaxCalculator
implements ISalaryCalculator {
    private static final Logger LOG = Logger.getLogger(Salary2TaxCalculator.class);
    private int precision = 2;
    private String mainTableName = "T_HR_SCmpCalTable";
    private final String uid;
    private Context ctx;
    private String schemeID;
    private String tempTable;
    private String condition;
    private String calFromDate;
    private String calToDate;
    private String month;
    private int status = 0;
    private double finishedPer = 0.0;
    private String calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label122", (Locale)new Context().getLocale());
    private Set<String> failedSet;
    private String filterSql;
    private TaxItemPlanInfo taxItemPlan;
    private List<String> zeroIncomeList;
    private String hrOrgUnitID;
    private String taxPeriodBegin;
    private String taxPeriodEnd;
    private double curStep;
    private double maxStep;
    private Map<String, String> verifyResult;
    private Set<String> calTableSet = new HashSet<String>();

    public Salary2TaxCalculator() {
        this.uid = CommonMethod.getRandomGUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int curStep, int maxStep) {
        String info = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label127", (Locale)this.ctx.getLocale());
        if (0 == maxStep) {
            this.setStatus(3);
            this.finishedPer = 100.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label128", (Locale)this.ctx.getLocale());
            return;
        }
        this.setCurStep(curStep);
        this.setMaxStep(maxStep);
        try {
            CalSchemeInfo calScheme = CalSchemeBizHelper.getCalSchemeInfo(this.ctx, this.schemeID);
            this.setStatus(1);
            IRowSet da = this.searchSchemeFormulas("cal2Tax");
            Map<String, String> assTable = this.combineTableItems(da);
            Salary2TaxCalFunction calObj = this.initCalInstance(da);
            calObj.setType("cal2Tax");
            DataSet dataSet = this.initCalData(da, assTable);
            Set secColSet = this.initSecureCol();
            Map<String, Object> editedItems = this.initEditedItems();
            Map<String, Object> changeIndex = this.execCalculate(calScheme, calObj, dataSet, secColSet, editedItems);
            this.saveCalResult(changeIndex);
            this.finishedPer = 100.0 / this.getMaxStep() * this.getCurStep() + 99.0;
            this.setStatus(2);
            info = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label127", (Locale)this.ctx.getLocale());
        }
        catch (Exception e) {
            LOG.error((Object)"Salary2TaxCalculator error: ", (Throwable)e);
            if (e instanceof NullPointerException) {
                info = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label129", (Locale)this.ctx.getLocale());
            }
            info = e.getMessage();
        }
        finally {
            this.calMessage = info;
            this.destroyed();
        }
    }

    private Map<String, String> combineTableItems(IRowSet da) throws Exception {
        double percent = 100.0 / this.getMaxStep() * this.getCurStep() + 10.0;
        if (this.finishedPer < percent) {
            this.finishedPer = percent;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label130", (Locale)this.ctx.getLocale());
        }
        HashMap<String, String> assTable = new HashMap<String, String>();
        while (da.next()) {
            String[] items;
            String listItems = da.getString("FListItem");
            if (listItems == null || "".equals(listItems)) continue;
            for (String s : items = listItems.split(";")) {
                String columns;
                String[] item = s.split("~");
                if (item[1].startsWith("TEMP")) continue;
                if (item.length > 3) {
                    String columns2;
                    String tableKey = item[1] + "~" + item[3];
                    if (assTable.containsKey(tableKey)) {
                        String clm;
                        columns2 = (String)assTable.get(tableKey) + ",";
                        if (columns2.contains(clm = item[1] + "." + item[2] + ",")) continue;
                        columns2 = columns2.substring(0, columns2.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                        assTable.put(tableKey, columns2);
                        continue;
                    }
                    columns2 = item[1] + "." + item[2];
                    assTable.put(tableKey, columns2);
                    continue;
                }
                if (assTable.containsKey(item[1])) {
                    String clm;
                    columns = (String)assTable.get(item[1]) + ",";
                    if (columns.contains(clm = item[1] + "." + item[2] + ",")) continue;
                    columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                    assTable.put(item[1], columns);
                    continue;
                }
                columns = item[1] + "." + item[2];
                assTable.put(item[1], columns);
            }
        }
        if (assTable.keySet().isEmpty()) {
            this.status = 4;
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label131", (Locale)this.ctx.getLocale()));
        }
        return assTable;
    }

    public void destroyed() {
        if (this.getTempTable() != null) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(this.getTempTable());
        }
    }

    public Map<String, Object> execCalculate(CalSchemeInfo calScheme, Salary2TaxCalFunction calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems) {
        double percent = 100.0 / this.getMaxStep() * this.getCurStep() + 40.0;
        if (this.finishedPer < percent) {
            this.finishedPer = percent;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label132", (Locale)this.ctx.getLocale());
        }
        calObj.setCalDate(this.month);
        calObj.setSchemeID(this.schemeID);
        calObj.setPrecision(this.precision);
        calObj.setCalScheme(calScheme);
        calObj.setMainTableRowFilter(this.condition);
        calObj.setTaxPeriodBegin(this.taxPeriodBegin);
        calObj.setTaxPeriodEnd(this.taxPeriodEnd);
        return this.calSalaryBySubThread(calScheme, calObj, dataSet, secColSet, editedItems);
    }

    public Map<String, Object> calSalaryBySubThread(CalSchemeInfo calScheme, Salary2TaxCalFunction calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems) {
        Map<String, Object> changeSqlMap = new HashMap<String, Object>();
        Salary2TaxCalExecutor mainSc = this.doExecute(calScheme, calObj, dataSet, secColSet, editedItems);
        do {
            double percent;
            this.finishedPer = percent = 100.0 / this.getMaxStep() * this.getCurStep() + (40.0 + mainSc.getExt_finishedPer());
        } while (!mainSc.isExecuteFinished());
        String name = mainSc.getName();
        if (mainSc.getChangeSqlList() != null) {
            System.out.println("---------------" + mainSc.getName() + ":" + mainSc.getChangeSqlList().size());
            changeSqlMap = mainSc.getChangeSqlList();
        }
        System.out.println("Thread name : " + name + " isExecuteFinished");
        return changeSqlMap;
    }

    private Salary2TaxCalExecutor doExecute(CalSchemeInfo calScheme, Salary2TaxCalFunction calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems) {
        Salary2TaxCalExecutor sc = new Salary2TaxCalExecutor(this.mainTableName, this.ctx, this.taxItemPlan, false, calScheme, calObj, dataSet, secColSet, editedItems);
        sc.setName("Salary2TaxCalExecutorThread");
        sc.run();
        return sc;
    }

    public String getCalMessage() {
        return this.calMessage;
    }

    public double getFinishedPer() {
        if (this.finishedPer >= 99.0) {
            this.finishedPer = 99.0;
        }
        return this.finishedPer;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTempTable() {
        return this.tempTable;
    }

    public String getUID() {
        return this.uid;
    }

    public DataSet initCalData(IRowSet da, Map<String, String> assTable) throws Exception {
        DataTable dt;
        double percent = 100.0 / this.getMaxStep() * this.getCurStep() + 20.0;
        if (this.finishedPer < percent) {
            this.finishedPer = percent;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label133", (Locale)this.ctx.getLocale());
        }
        DataSet dataSet = new DataSet();
        DataAccess DAC = DAFactory.getDataAccess();
        SQLGenerate sqlgen = new SQLGenerate();
        sqlgen.fromTime = this.calFromDate;
        sqlgen.toTime = this.calToDate;
        sqlgen.isShowCodeText = false;
        String sq = null;
        int pre = assTable.size() / 5 + 1;
        int index = 0;
        String tempSql = this.buildDataSetSql(assTable);
        try {
            DataTable baseDt = DAC.getDataForDataTable(tempSql);
            for (Map.Entry<String, String> entry : assTable.entrySet()) {
                String tableName = entry.getKey();
                if (index % pre == 0) {
                    this.finishedPer += 1.0;
                    this.calMessage = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label134"), tableName);
                }
                ++index;
                dt = new DataTable();
                dt.tablename = tableName;
                dt.columns = baseDt.columns;
                dt.datas = baseDt.datas;
                dt.datasIndexMap = baseDt.datasIndexMap;
                dt.emptyrow = baseDt.emptyrow;
                dataSet.addTable(dt);
            }
            dt = new DataTable();
            dt.tablename = this.mainTableName;
            dt.columns = baseDt.columns;
            dt.datas = baseDt.datas;
            dt.datasIndexMap = baseDt.datasIndexMap;
            dt.emptyrow = baseDt.emptyrow;
            dataSet.addTable(dt);
        }
        catch (Exception e) {
            this.status = 4;
            throw new RuntimeException(MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label135"), sq) + "<br>" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label153", (Locale)this.ctx.getLocale()) + e.getMessage());
        }
        assTable.clear();
        da.beforeFirst();
        StringBuilder sb = new StringBuilder();
        percent = 100.0 / this.getMaxStep() * this.getCurStep() + 25.0;
        if (this.finishedPer < percent) {
            this.finishedPer = percent;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label136", (Locale)this.ctx.getLocale());
        }
        while (da.next()) {
            String listItems = da.getString("FListTable");
            if (listItems == null || "".equals(listItems)) continue;
            String[] items = listItems.split(";");
            for (int loop = 0; loop < items.length; ++loop) {
                String[] item = items[loop].split("~");
                String id = "'" + item[1] + "'";
                if (sb.indexOf(id) != -1) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
        }
        percent = 100.0 / this.getMaxStep() * this.getCurStep() + 26.0;
        if (this.finishedPer < percent) {
            this.finishedPer = percent;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label137", (Locale)this.ctx.getLocale());
        }
        if (sb.length() > 0) {
            sb.insert(0, "SELECT FDefine, FSqls, FPeriodFrom, FPeriodTo FROM T_HR_SFormulaTmpTable WHERE fid IN (");
            sb.append(")");
            dt = DAC.getDataTable(sb.toString(), "T_HR_SFormulaTmpTable");
            DataRow[] rows = dt.getAllRows();
            for (index = 0; index < rows.length; ++index) {
                sb.delete(0, sb.length());
                sb.append(rows[index].getString("FSqls"));
                if (!sb.toString().toUpperCase(Locale.ENGLISH).contains("WHERE")) {
                    int insertIndex = sb.indexOf("GROUP BY") > -1 ? sb.indexOf("GROUP BY") : (sb.indexOf("ORDER BY") > -1 ? sb.indexOf("ORDER BY") : sb.length());
                    sb.insert(insertIndex, " WHERE 1 = 1 ");
                }
                sb.insert(sb.toString().toUpperCase(Locale.ENGLISH).indexOf("WHERE") + 6, " (" + this.condition + ") AND ");
                sq = sb.toString().replaceAll("@YEARFROM", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodFrom"), "@YEARFROM")).replaceAll("@MONTHFROM", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodFrom"), "@MONTHFROM")).replaceAll("@YEARTO", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodTo"), "@YEARTO")).replaceAll("@MONTHTO", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodTo"), "@MONTHTO"));
                sb.delete(0, sb.length());
                try {
                    String tempTableName = rows[index].getString("FDefine");
                    DataTable dt1 = DAC.getDataTable(sq, tempTableName);
                    if (dt1 == null) continue;
                    dataSet.addTable(dt1);
                    continue;
                }
                catch (Exception e) {
                    this.status = 4;
                    throw new RuntimeException(MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label138"), sq) + "<br>" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label153", (Locale)this.ctx.getLocale()) + e.getMessage());
                }
            }
        }
        if (dataSet.tableCount() == 0 || !dataSet.isExistedTable(this.mainTableName)) {
            this.status = 4;
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label139", (Locale)this.ctx.getLocale()));
        }
        return dataSet;
    }

    private String buildDataSetSql(Map<String, String> assTable) throws Exception {
        String filterStr = this.condition.replace("t_hr_scmpcaltable.fid", "cmp_CTB.id");
        FilterInfo filter = new FilterInfo(filterStr);
        SqlParam sqlParam = new SqlParam();
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(this.ctx, this.schemeID);
        Date endDate = calSchemeInfo.getEndDate();
        Map<String, String> selectMapping = this.buildSelector(assTable);
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setScheme("002");
        sqlParam.setFilterDate(endDate);
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        return FilterUtil.getSql((Context)this.ctx, (SqlParam)sqlParam);
    }

    private Map<String, String> buildSelector(Map<String, String> assTable) throws BOSException {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        selectMapping.put("cmp_CTB.id", "fid");
        selectMapping.put("cmp_CTB.person", "FPERSONID");
        selectMapping.put("cmp_CTB.taxUnit", "FTAXUNITID");
        Set<Map.Entry<String, String>> entrySet = assTable.entrySet();
        Iterator<Map.Entry<String, String>> it = entrySet.iterator();
        Map<String, StructureConfigInfo> structMap = FunUtils.getCmp002StructureMap(this.ctx);
        while (it.hasNext()) {
            String strucNum;
            StructureConfigInfo structureInfo;
            Map.Entry<String, String> next = it.next();
            String[] tableArr = next.getKey().split("~");
            String tableName = tableArr[0];
            if ("T_HR_SCmpCalTable".equals(tableName)) {
                String columns = assTable.get(tableName);
                String[] columnArr = columns.split(",");
                for (int i = 0; i < columnArr.length; ++i) {
                    String column = columnArr[i].split("\\.")[1];
                    selectMapping.put(column, column);
                }
                continue;
            }
            if ("T_HR_STaxCalInitDetail".equalsIgnoreCase(tableName) || (structureInfo = structMap.get(strucNum = tableArr[1])) == null) continue;
            String entityName = structureInfo.getEntityName();
            Map<String, PropertyInfo> properties = FunUtils.getProperties(this.ctx, entityName);
            String field = next.getValue();
            String[] singleField = field.split(",");
            for (int i = 0; i < singleField.length; ++i) {
                field = singleField[i];
                String tableField = field.split("\\.")[1];
                field = properties.get(tableField).getName();
                if (selectMapping.containsKey(strucNum + "." + field)) continue;
                selectMapping.put(strucNum + "." + field, strucNum + "." + tableField);
            }
        }
        return selectMapping;
    }

    public Salary2TaxCalFunction initCalInstance(IRowSet da) {
        Salary2TaxCalFunction calObj;
        double percent = 100.0 / this.getMaxStep() * this.getCurStep() + 15.0;
        if (this.finishedPer < percent) {
            this.finishedPer = percent;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label140", (Locale)this.ctx.getLocale());
        }
        try {
            calObj = Salary2TaxCalFunMgr.getInstance(da);
        }
        catch (Exception e) {
            this.status = 4;
            throw new RuntimeException(e.getMessage());
        }
        if (calObj == null) {
            this.status = 4;
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label141", (Locale)this.ctx.getLocale()));
        }
        return calObj;
    }

    public Set initSecureCol() {
        return new HashSet();
    }

    private Map<String, Object> initEditedItems() {
        double percent = 100.0 / this.getMaxStep() * this.getCurStep() + 35.0;
        if (this.finishedPer < percent) {
            this.finishedPer = percent;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label142", (Locale)this.ctx.getLocale());
        }
        HashMap<String, Object> EditedItems = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from t_hr_scalresultedited");
        sql.append(" where fcmpcaltableid in(");
        sql.append(this.filterSql);
        sql.append(")");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, Object> EditedItem = new HashMap<String, Object>();
                String cmpCalTableId = null;
                IRowSetMetaData metaData = rowSet.getRowSetMetaData();
                for (int i = 1; i < metaData.getColumnCount() + 1; ++i) {
                    Object value;
                    String columnName = metaData.getColumnName(i);
                    if (columnName.equalsIgnoreCase("fcmpcaltableid")) {
                        cmpCalTableId = (String)rowSet.getObject(columnName);
                        continue;
                    }
                    if (!columnName.matches("[sS]\\d{1,}") || (value = rowSet.getObject(columnName)) == null || value.toString().trim().length() <= 0) continue;
                    EditedItem.put(columnName.toUpperCase(Locale.ENGLISH) + "_edited", value);
                }
                EditedItems.put(cmpCalTableId, EditedItem);
            }
        }
        catch (Exception e) {
            this.status = 4;
            throw new RuntimeException(e.getMessage());
        }
        return EditedItems;
    }

    public void saveCalResult(Map<String, Object> changeSqlMap) {
        int changeSize;
        String errMsg;
        String string = errMsg = changeSqlMap.get("errMsg") == null ? "" : changeSqlMap.get("errMsg").toString();
        if (!"".equals(errMsg)) {
            this.status = 4;
            throw new RuntimeException(errMsg);
        }
        ArrayList submitDataMapList = (ArrayList)changeSqlMap.get("submitDataMapList");
        if (null != submitDataMapList && !submitDataMapList.isEmpty()) {
            this.filterData(submitDataMapList, this.failedSet);
        }
        ArrayList itemList = (ArrayList)changeSqlMap.get("itemList");
        int n = changeSize = null == submitDataMapList ? 0 : submitDataMapList.size();
        if (changeSize == 0) {
            this.status = 3;
            this.verifyResult = new HashMap<String, String>();
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label143", (Locale)this.ctx.getLocale()));
        }
        VerifyData4SubmitInitCal verifier = new VerifyData4SubmitInitCal();
        this.verifyResult = verifier.verify(this.ctx, submitDataMapList, itemList, this.taxItemPlan, this.zeroIncomeList);
        double percent = 100.0 / this.getMaxStep() * this.getCurStep() + 90.0;
        if (this.finishedPer <= percent) {
            this.finishedPer = percent;
            this.calMessage = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label144"), changeSize);
        }
        try {
            if (submitDataMapList.size() > 0) {
                Set set = TaxCalInitFacadeFactory.getLocalInstance(this.ctx).submitCalData(submitDataMapList, itemList);
                this.calTableSet.addAll(set);
            }
            if (this.finishedPer < (percent = 100.0 / this.getMaxStep() * this.getCurStep() + 98.0)) {
                this.finishedPer = percent;
                this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label145", (Locale)this.ctx.getLocale());
            }
        }
        catch (Exception e) {
            this.status = 3;
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label146", (Locale)this.ctx.getLocale()) + "<br>" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label153", (Locale)this.ctx.getLocale()) + e.getMessage());
        }
    }

    private void filterData(List<Map<String, Object>> submitDataMapList, Set<String> failedSet) {
        if (failedSet.isEmpty()) {
            return;
        }
        Iterator<Map<String, Object>> it = submitDataMapList.iterator();
        while (it.hasNext()) {
            Map<String, Object> row = it.next();
            String calTableId = (String)row.get("FCMPCALTABLEID");
            String incomeItemId = (String)row.get("FINCOMEITEMID");
            if (!failedSet.contains(calTableId + "_" + incomeItemId)) continue;
            it.remove();
        }
    }

    public IRowSet searchSchemeFormulas(String type) throws Exception {
        String SQL;
        IRowSet da;
        double percent = 100.0 / this.getMaxStep() * this.getCurStep() + 5.0;
        if (this.finishedPer < percent) {
            this.finishedPer = percent;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label147", (Locale)this.ctx.getLocale());
        }
        if ((da = DbUtil.executeQuery((Context)this.ctx, (String)(SQL = "SELECT formula.FID, formula.FName_l2,formula.FCalItem, formula.FExpress, formula.FListItem, formula.FListFunc, formula.FListVar, formula.FListTable, formula.FSortSn FROM T_HR_STaxItemPlan taxItemPlan INNER JOIN T_HR_SBusinessRelationConfig config on taxItemPlan.FID = config.FBusinessId INNER JOIN T_HR_SBaseformula formula on config.FID = formula.FBusinessRelationConfigID where taxItemPlan.FID = '" + this.taxItemPlan.getId().toString() + "' and formula.FCalType in (0,2) and formula.FISCAL = 1  ORDER BY formula.FSortSn"))).size() == 0) {
            this.status = 3;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("name");
            String name = this.taxItemPlan.getName();
            throw new RuntimeException(MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label148"), name));
        }
        return da;
    }

    public void setCalFormulas(String calFormulas) {
    }

    public void setCalFromDate(String calFromDate) {
        this.calFromDate = calFromDate;
    }

    public void setCalMessage(String calMessage) {
        this.calMessage = calMessage;
    }

    public void setCalToDate(String calToDate) {
        this.calToDate = calToDate;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }

    public void setMainTableRowFilter(String condition) {
        this.condition = condition;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public void setPrecision(int v) {
        this.precision = v;
    }

    public void setSchemeID(String schemeID) {
        this.schemeID = schemeID;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTempTable(String tempTable) {
        this.tempTable = tempTable;
    }

    public String getFilterSql() {
        return this.filterSql;
    }

    public void setFilterSql(String filterSql) {
        this.filterSql = filterSql;
    }

    public String getHrOrgUnitID() {
        return this.hrOrgUnitID;
    }

    public void setHrOrgUnitID(String hrOrgUnitID) {
        this.hrOrgUnitID = hrOrgUnitID;
    }

    public void setTaxPeriodBegin(String taxPeriodBegin) {
        this.taxPeriodBegin = taxPeriodBegin;
    }

    public String getTaxPeriodBegin() {
        return this.taxPeriodBegin;
    }

    public void setTaxPeriodEnd(String taxPeriodEnd) {
        this.taxPeriodEnd = taxPeriodEnd;
    }

    public String getTaxPeriodEnd() {
        return this.taxPeriodEnd;
    }

    public void setCurStep(double curStep) {
        this.curStep = curStep;
    }

    public double getCurStep() {
        return this.curStep;
    }

    public void setMaxStep(double maxStep) {
        this.maxStep = maxStep;
    }

    public double getMaxStep() {
        return this.maxStep;
    }

    public void setVerifyResult(Map<String, String> verifyResult) {
        this.verifyResult = verifyResult;
    }

    public Map<String, String> getVerifyResult() {
        return this.verifyResult;
    }

    public void setTaxItemPlan(TaxItemPlanInfo taxItemPlan) {
        this.taxItemPlan = taxItemPlan;
    }

    public Set<String> getCalTableSet() {
        return this.calTableSet;
    }

    public void setZeroIncomeList(List<String> zeroIncomeList) {
        this.zeroIncomeList = zeroIncomeList;
    }

    public void setFailedSet(Set<String> failedSet) {
        this.failedSet = failedSet;
    }
}

