/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.tax;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.shr.compensation.app.formula.tax.Salary2TaxCalculator;
import com.kingdee.shr.compensation.app.formula.tax.TaskInfo;
import com.kingdee.shr.validaterule.formula.ISalaryCalculator;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Locale;

public class Salary2TaxCalculatorMgr
extends Thread {
    private static int taskCount = 0;
    public static int maxTasks = 1;
    public static int waitTime = 10;
    private static Salary2TaxCalculatorMgr instance = null;
    private static ArrayList<Salary2TaxCalculator> taskList = new ArrayList();
    private static ArrayList<TaskInfo> taskInfo = new ArrayList();

    public static synchronized void addTask(Salary2TaxCalculator calculator) {
        taskList.add(calculator);
    }

    public static synchronized Salary2TaxCalculator findTask(String uid) {
        int index;
        if (uid == null || "".equals(uid)) {
            return null;
        }
        for (index = 0; index < taskList.size(); ++index) {
            Salary2TaxCalculator calculator = taskList.get(index);
            if (!uid.equals(calculator.getUID())) continue;
            return calculator;
        }
        for (index = 0; index < taskInfo.size(); ++index) {
            TaskInfo task = taskInfo.get(index);
            if (task.getUid().equals(uid)) {
                String info = task.getInfo();
                if (StringUtils.isEmpty((String)info)) {
                    info = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label126", (Locale)new Context().getLocale());
                }
                taskInfo.remove(index);
                throw new RuntimeException(info);
            }
            if (System.currentTimeMillis() - task.getEndTime() <= 6000000L) continue;
            taskInfo.remove(index);
            --index;
        }
        return null;
    }

    public static synchronized Salary2TaxCalculator getTask() {
        Salary2TaxCalculator calculator = null;
        for (int index = 0; index < taskList.size(); ++index) {
            calculator = taskList.get(index);
            if (calculator.getStatus() != 0) continue;
            calculator.setStatus(1);
            return calculator;
        }
        return null;
    }

    public static synchronized void removeTask(String uid, String cause) {
        int index;
        if (uid == null || "".equals(uid)) {
            return;
        }
        for (index = 0; index < taskList.size(); ++index) {
            ISalaryCalculator calculator = taskList.get(index);
            if (!uid.equals(calculator.getUID())) continue;
            taskList.remove(index);
            --taskCount;
        }
        for (index = 0; index < taskInfo.size(); ++index) {
            TaskInfo task = taskInfo.get(index);
            if (!task.getUid().equals(uid)) continue;
            task.setEndTime(System.currentTimeMillis());
            task.setInfo(cause);
            return;
        }
    }

    private boolean haveNewTask() {
        ISalaryCalculator calculator = null;
        for (int index = 0; index < taskList.size(); ++index) {
            calculator = taskList.get(index);
            if (calculator.getStatus() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        while (true) {
            System.out.println("==========taskCount is " + taskCount + "===========");
            while (taskCount >= maxTasks || !this.haveNewTask()) {
                try {
                    Salary2TaxCalculatorMgr.sleep(waitTime * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                Salary2TaxCalculator calculator = Salary2TaxCalculatorMgr.getTask();
                if (calculator == null) continue;
                ++taskCount;
                taskInfo.add(new TaskInfo(calculator.getUID()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public synchronized void wakeup() {
        this.notifyAll();
    }
}

