/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.AbstractExternalToSubmitDataFacadeControllerBean;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExternalToSubmitDataFacadeControllerBean
extends AbstractExternalToSubmitDataFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ExternalToSubmitDataFacadeControllerBean.class);
    protected Map<String, TempBatchSubmitEntry> entryInfoMap = new HashMap<String, TempBatchSubmitEntry>();
    protected Map<String, CalSubmitItemInfo> calSubmitItemMap = new HashMap<String, CalSubmitItemInfo>();
    protected List<CalSubmitItemInfo> calSubmitItemList = new ArrayList<CalSubmitItemInfo>();
    private String schemeNumber;
    private String schemeId;
    private String entryTable;
    boolean isEnableSubmitElement = false;
    Map<String, String> submitElementMap = new HashMap<String, String>();
    Set<String> billNumberSet = new HashSet<String>();
    protected Map<String, String> currenctMap = new HashMap<String, String>();
    private static final String CNY = "CNY";
    private static final String RMB = "RMB";
    private Map<String, Object> returnMap;
    private List<Map<String, String>> rerurnDataList;

    @Override
    protected Map _submitData(Context ctx, Map param) throws BOSException, EASBizException {
        List dataList;
        this.initReturnData();
        if (!param.containsKey("data") || !(param.get("data") instanceof List)) {
            String label27 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label27", (Locale)ctx.getLocale());
            this.changeReturnValue("0050", label27);
        }
        if ((dataList = (List)param.get("data")).size() < 1) {
            String label28 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label28", (Locale)ctx.getLocale());
            this.changeReturnValue("0050", label28);
        }
        this.validRequiredAttr(dataList, ctx);
        if (this.returnMap.get("code").equals("0050") || dataList.size() < 1) {
            return this.returnMap;
        }
        this.initSubmitData(ctx, dataList);
        if (this.returnMap.get("code").equals("0050") || dataList.size() < 1) {
            return this.returnMap;
        }
        this.validData(ctx, dataList);
        if (this.returnMap.get("code").equals("0050") || dataList.size() < 1) {
            return this.returnMap;
        }
        this.saveData(ctx, dataList);
        return this.returnMap;
    }

    private void changeReturnValue(String code, String msg) {
        if (!StringUtils.isEmpty((String)code)) {
            this.returnMap.put("code", code);
        }
        if (!StringUtils.isEmpty((String)msg)) {
            this.returnMap.put("msg", msg);
        }
    }

    private void initReturnData() {
        this.returnMap = new HashMap<String, Object>();
        this.rerurnDataList = new ArrayList<Map<String, String>>();
        this.returnMap.put("code", "0000");
        this.returnMap.put("msg", null);
        this.returnMap.put("month", null);
        this.returnMap.put("data", this.rerurnDataList);
    }

    private void validRequiredAttr(List<Map<String, Object>> dataList, Context ctx) {
        boolean isValid = true;
        String reger = "[1-9][0-9]{3}[-](0[1-9]|1[0-2])";
        HashMap<String, String> map = new HashMap<String, String>();
        String label29 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label29", (Locale)ctx.getLocale());
        String label30 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label30", (Locale)ctx.getLocale());
        String label31 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label31", (Locale)ctx.getLocale());
        String label32 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label32", (Locale)ctx.getLocale());
        String label33 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label33", (Locale)ctx.getLocale());
        map.put("bill", label29);
        map.put("scheme", label30);
        map.put("person", label31);
        map.put("submitter", label32);
        map.put("month", label33);
        block0: for (int i = dataList.size() - 1; i >= 0; --i) {
            String format;
            Map<String, Object> tempMap = dataList.get(i);
            String billNumber = null == tempMap.get("bill") ? null : tempMap.get("bill").toString();
            for (Map.Entry entry : map.entrySet()) {
                isValid = true;
                if (!CmpStrUtil.isNullOrEmpty(tempMap.get(entry.getKey()))) continue;
                String label34 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label33", (Locale)ctx.getLocale());
                String format2 = MessageFormat.format(label34, billNumber, entry.getKey(), entry.getValue());
                this.assembleUnvalidData(billNumber, format2, ctx);
                isValid = false;
                break;
            }
            if (!isValid) {
                dataList.remove(i);
                continue;
            }
            if (CmpStrUtil.isNullOrEmpty(tempMap.get("month"))) {
                String label37 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label37", (Locale)ctx.getLocale());
                format = MessageFormat.format(label37, billNumber);
                this.assembleUnvalidData(billNumber, format, ctx);
                dataList.remove(i);
                continue;
            }
            if (!tempMap.get("month").toString().matches(reger)) {
                String label38 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label38", (Locale)ctx.getLocale());
                format = MessageFormat.format(label38, billNumber);
                this.assembleUnvalidData(billNumber, format, ctx);
                dataList.remove(i);
                continue;
            }
            if (null == tempMap.get("item") || !(tempMap.get("item") instanceof List)) {
                String label39 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label39", (Locale)ctx.getLocale());
                format = MessageFormat.format(label39, billNumber);
                this.assembleUnvalidData(billNumber, format, ctx);
                dataList.remove(i);
                continue;
            }
            if (tempMap.containsKey("description") && !(tempMap.get("description") instanceof Map)) {
                String label40 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label40", (Locale)ctx.getLocale());
                format = MessageFormat.format(label40, billNumber);
                this.assembleUnvalidData(billNumber, format, ctx);
                dataList.remove(i);
                continue;
            }
            List itemList = (List)tempMap.get("item");
            for (Map stringObjectMap : itemList) {
                if (!CmpStrUtil.isNullOrEmpty(stringObjectMap.get("number"))) continue;
                String label41 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label41", (Locale)ctx.getLocale());
                String format3 = MessageFormat.format(label41, billNumber);
                this.assembleUnvalidData(billNumber, format3, ctx);
                dataList.remove(i);
                continue block0;
            }
        }
    }

    private String getBillInsertSql() {
        return " INSERT INTO T_HR_SBATCHSUBMITSHEMEBILL( FSUBMITSCHEMEID, FAPPLYDATE, FPROPOSERID, FDATASOURCE, FISINNER,  FADMINORGUNITID, FHRORGUNITID, FBILLSTATE, FAPPROVETYPE, FNUMBER,  FDESCRIPTION, FCREATORID, FCREATETIME, FID, FIsSsc) values(?, ?, ?, ?, ?,  ?, ?, ?, ?, ?,  ?, ?, ?, ?, 0)";
    }

    private Map<String, Object> saveBill(Context ctx, List<Map<String, Object>> dataList) throws BOSException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Date createTime = new Date(new java.util.Date().getTime());
        HashMap<String, String> hrOrgMap = new HashMap<String, String>();
        StringBuilder billStr = new StringBuilder();
        String billSql = this.getBillInsertSql();
        for (Map<String, Object> tempMap : dataList) {
            HROrgUnitCollection hrOrgColl;
            String submitterNum = tempMap.get("submitter").toString();
            TempBatchSubmitEntry submitEntry = this.entryInfoMap.get(submitterNum);
            String submitterId = submitEntry.getPersonId();
            String bill = tempMap.get("bill").toString();
            String remark = null == tempMap.get("remark") ? null : tempMap.get("remark").toString();
            String hrOrgUnitNumber = null == tempMap.get("hrOrgUnit") ? null : tempMap.get("hrOrgUnit").toString();
            String hrOrgId = (String)hrOrgMap.get(bill);
            if (!StringUtils.isEmpty((String)hrOrgUnitNumber) && null == hrOrgId && null != (hrOrgColl = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select id where number = '" + hrOrgUnitNumber + "'")) && hrOrgColl.size() > 0) {
                hrOrgMap.put(bill, hrOrgColl.get(0).getId().toString());
            }
            Object[] param = new Object[]{this.schemeId, createTime, submitterId, 2, 0, submitEntry.getAdminOrgId(), null == hrOrgId ? submitEntry.getHrOrgUnitId() : hrOrgId, 3, 0, bill, remark, submitterId, createTime, BOSUuid.create((String)"B11DBA5C").toString()};
            paramsList.add(param);
            billStr.append("'").append(bill).append("',");
        }
        String billNumbers = billStr.substring(0, billStr.length() - 1);
        DbUtil.executeBatch((Context)ctx, (String)billSql, paramsList);
        returnMap.put("BILLNUMBERS", billNumbers);
        returnMap.put("HRORGMAP", hrOrgMap);
        return returnMap;
    }

    private String getBillEntryInsertSql() {
        StringBuilder str = new StringBuilder();
        str.append(" INSERT INTO ").append(this.entryTable).append("(");
        str.append(" FBILLID, FEFFECTDATE, FADMINORGUNITID, FPOSITIONID, FCMPEMPORELATIONID, ");
        str.append(" FCURRENCYID, FSUBMITELEMENTID, FHRORGUNITID, FCALSTATE, FISCAL, ");
        str.append(" FBILLSTATE, FPERSONID, FID");
        for (CalSubmitItemInfo calSubmitItemInfo : this.calSubmitItemList) {
            str.append(",").append("S").append(calSubmitItemInfo.getFieldSn());
        }
        str.append(" , fdescription_l1, fdescription_l2, fdescription_l3 ");
        str.append(")");
        str.append(" values(?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ? ");
        for (int i = 0; i < this.calSubmitItemList.size(); ++i) {
            str.append(",?");
        }
        str.append(" , ?, ?, ? ");
        str.append(")");
        return str.toString();
    }

    private void saveBillEntry(Context ctx, List<Map<String, Object>> dataList, Map<String, String> hrOrgMap, String billNumberIds) throws BOSException {
        HashMap<String, String> billMap = new HashMap<String, String>();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        HashMap<String, ItemAttr> itemAttrMap = new HashMap<String, ItemAttr>();
        Calendar calendar = Calendar.getInstance();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID, FNUMBER FROM T_HR_SBATCHSUBMITSHEMEBILL WHERE FNUMBER IN (" + billNumberIds + ")"));
        try {
            while (rowSet.next()) {
                billMap.put(rowSet.getString(2), rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        String itemSql = this.getBillEntryInsertSql();
        for (Map<String, Object> stringObjectMap : dataList) {
            String person = stringObjectMap.get("person").toString();
            String bill = stringObjectMap.get("bill").toString();
            String hrOrgId = hrOrgMap.get(bill);
            TempBatchSubmitEntry tempBatchSubmitEntry = this.entryInfoMap.get(person);
            String month = stringObjectMap.get("month").toString();
            String submitElementNumber = null == stringObjectMap.get("submitElement") ? null : stringObjectMap.get("submitElement").toString();
            calendar.set(Integer.valueOf(month.substring(0, 4)), Integer.valueOf(month.substring(5, 7)) - 1, 1, 0, 0, 0);
            if (!billMap.containsKey(bill)) continue;
            List itemList = (List)stringObjectMap.get("item");
            for (Map objectMap : itemList) {
                ItemAttr itemAttr = new ItemAttr(objectMap.get("value"), null == objectMap.get("currency") ? "" : objectMap.get("currency").toString());
                itemAttrMap.put(objectMap.get("number").toString(), itemAttr);
            }
            Object[] param = new Object[13 + this.calSubmitItemList.size() + 3];
            param[0] = billMap.get(bill);
            param[1] = CmpDateUtil.toSqlDate(calendar.getTime());
            param[2] = tempBatchSubmitEntry.getAdminOrgId();
            param[3] = tempBatchSubmitEntry.getPositionId();
            param[4] = tempBatchSubmitEntry.getCmpEmpId();
            String currencyISO = stringObjectMap.containsKey("currency") ? stringObjectMap.get("currency").toString() : RMB;
            String currencyId = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
            param[5] = this.currenctMap.containsKey(currencyISO) ? (null == this.currenctMap.get(currencyISO) ? currencyId : this.currenctMap.get(currencyISO)) : currencyId;
            param[6] = null == submitElementNumber ? null : this.submitElementMap.get(submitElementNumber).toString();
            param[7] = null == hrOrgId ? tempBatchSubmitEntry.getHrOrgUnitId() : hrOrgId;
            param[8] = "01";
            param[9] = 10;
            param[10] = 3;
            param[11] = tempBatchSubmitEntry.getPersonId();
            param[12] = BOSUuid.create((String)"7F647776").toString();
            for (int k = 0; k < this.calSubmitItemList.size(); ++k) {
                CalSubmitItemInfo calSubmitItemInfo = this.calSubmitItemList.get(k);
                CalSubmitItemDataType dataType = calSubmitItemInfo.getDataType();
                param[13 + k] = dataType.equals("0") && itemAttrMap.containsKey(calSubmitItemInfo.getNumber()) ? new BigDecimal(((ItemAttr)itemAttrMap.get(calSubmitItemInfo.getNumber())).getValue().toString()) : (itemAttrMap.containsKey(calSubmitItemInfo.getNumber()) ? ((ItemAttr)itemAttrMap.get(calSubmitItemInfo.getNumber())).getValue().toString() : null);
            }
            if (stringObjectMap.containsKey("description")) {
                Map descMap = (Map)stringObjectMap.get("description");
                String desc_l1 = descMap.containsKey("L1") ? (String)descMap.get("L1") : null;
                String desc_l2 = descMap.containsKey("L2") ? (String)descMap.get("L2") : null;
                String desc_l3 = descMap.containsKey("L3") ? (String)descMap.get("L3") : null;
                param[13 + this.calSubmitItemList.size()] = desc_l1;
                param[13 + this.calSubmitItemList.size() + 1] = desc_l2;
                param[13 + this.calSubmitItemList.size() + 2] = desc_l3;
            } else {
                param[13 + this.calSubmitItemList.size()] = null;
                param[13 + this.calSubmitItemList.size() + 1] = null;
                param[13 + this.calSubmitItemList.size() + 2] = null;
            }
            paramsList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)itemSql, paramsList);
    }

    public void saveData(Context ctx, List<Map<String, Object>> dataList) throws EASBizException, BOSException {
        Map<String, Object> dataMap = this.saveBill(ctx, dataList);
        String billNumberIds = dataMap.get("BILLNUMBERS").toString();
        Map hrOrgMap = (Map)dataMap.get("HRORGMAP");
        this.saveBillEntry(ctx, dataList, hrOrgMap, billNumberIds);
    }

    protected void initSubmitData(Context ctx, List<Map<String, Object>> dataList) throws EASBizException, BOSException {
        HashSet<String> tempPersonSet = new HashSet<String>();
        HashSet<String> tempSchemeSet = new HashSet<String>();
        HashSet<String> tempBillSet = new HashSet<String>();
        String currencyISO = "";
        for (Map<String, Object> dataMap : dataList) {
            tempPersonSet.add(dataMap.get("person").toString());
            tempPersonSet.add(dataMap.get("submitter").toString());
            tempSchemeSet.add(dataMap.get("scheme").toString());
            tempBillSet.add(dataMap.get("bill").toString());
            this.schemeNumber = dataMap.get("scheme").toString();
            currencyISO = dataMap.containsKey("currency") ? dataMap.get("currency").toString() : RMB;
            this.currenctMap.put(currencyISO, null);
        }
        if (tempSchemeSet.size() > 1) {
            String label371 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label37_1", (Locale)ctx.getLocale());
            this.changeReturnValue("0050", label371);
            return;
        }
        StringBuilder str = new StringBuilder();
        str.append(" SELECT SCHEME.FID SCHEMEID,SCHEME.FNUMBER SCHEMENUMBER, REL.FBILLENTRYTABLENAME TABLENAME, ITEM.FID ITEMID, ITEM.FNUMBER ITEMNUMBER, ITEM.FDATATYPE ITEMDATATYPE, ITEM.FIELDSN,FISENABLESUBMITELEMENT ");
        str.append(" FROM T_HR_SCALSUBMITSCHEME SCHEME ");
        str.append(" INNER JOIN T_HR_SCALSHEMETABLERELATION REL ON SCHEME.FID = REL.FSUBMITSCHEMEID ");
        str.append(" INNER JOIN T_HR_SCALSUBMITSCHEMEITEM SCHEMEITEM ON SCHEMEITEM.FCALSUBMITSCHEMEID = SCHEME.FID ");
        str.append(" INNER JOIN T_HR_SCALSUBMITITEM ITEM ON ITEM.FID = SCHEMEITEM.FCALSUBMITITEMID ");
        str.append(" WHERE SCHEME.FNUMBER = '");
        str.append(this.schemeNumber);
        str.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        if (rowSet.size() < 1) {
            String label381 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label38_1", (Locale)ctx.getLocale());
            String format = MessageFormat.format(label381, this.schemeNumber);
            this.changeReturnValue("0050", format);
            return;
        }
        try {
            while (rowSet.next()) {
                CalSubmitItemInfo itemInfo = new CalSubmitItemInfo();
                itemInfo.setId(BOSUuid.read((String)rowSet.getString("ITEMID")));
                itemInfo.setNumber(rowSet.getString("ITEMNUMBER"));
                itemInfo.setDataType(CalSubmitItemDataType.getEnum(rowSet.getString("ITEMDATATYPE")));
                itemInfo.setFieldSn(rowSet.getInt("FIELDSN"));
                this.calSubmitItemMap.put(rowSet.getString("ITEMNUMBER"), itemInfo);
                this.calSubmitItemList.add(itemInfo);
                this.entryTable = rowSet.getString("TABLENAME");
                this.schemeId = rowSet.getString("SCHEMEID");
                this.isEnableSubmitElement = rowSet.getBoolean("FISENABLESUBMITELEMENT");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        str = new StringBuilder();
        str.append(" SELECT PER.FNUMBER PERNUMBER, PER.FID PERSONID, CMPEMP.FID CMPEMPID, EMP.FADMINORGID ADMINORGID, FPOSITIONID POSITIONID,CMP.FHRORGUNITID");
        str.append(" FROM T_BD_PERSON PER ");
        str.append(" INNER JOIN T_HR_SCMPEMPORELATION CMPEMP ON PER.FID = CMPEMP.FPERSONID ");
        str.append(" INNER JOIN T_HR_SPERSONCMP CMP ON CMPEMP.FPERSONCMPID = CMP.FID ");
        str.append(" INNER JOIN T_HR_EMPORGRELATION EMP ON EMP.FID = CMPEMP.FEMPORGRELATIONID ");
        str.append(" WHERE PER.FNUMBER IN (");
        str.append(CmpStrUtil.convertSetToSqlString(tempPersonSet));
        str.append(")");
        str.append(" and emp.FAssignType = 1 and cmp.FISSENDSALARY = 1");
        str.append(" order by EMP.FEFFDT desc, EMP.FCreateTime desc ");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                if (this.entryInfoMap.containsKey(rowSet.getString("PERNUMBER"))) continue;
                TempBatchSubmitEntry entryInfo = new TempBatchSubmitEntry();
                entryInfo.setPersonId(rowSet.getString("PERSONID"));
                entryInfo.setCmpEmpId(rowSet.getString("CMPEMPID"));
                entryInfo.setAdminOrgId(rowSet.getString("ADMINORGID"));
                entryInfo.setPositionId(rowSet.getString("POSITIONID"));
                entryInfo.setHrOrgUnitId(rowSet.getString("FHRORGUNITID"));
                this.entryInfoMap.put(rowSet.getString("PERNUMBER"), entryInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        str = new StringBuilder();
        str.append(" SELECT FNUMBER FROM T_HR_SBATCHSUBMITSHEMEBILL ");
        str.append(" WHERE FNUMBER IN (");
        str.append(CmpStrUtil.convertSetToSqlString(tempBillSet));
        str.append(")");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                this.billNumberSet.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        if (this.isEnableSubmitElement) {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID, FNUMBER FROM T_HR_SSUBMITELEMENT");
            try {
                while (rowSet.next()) {
                    this.submitElementMap.put(rowSet.getString(2), rowSet.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        if (this.currenctMap.size() > 0) {
            str = new StringBuilder();
            str.append(" SELECT FISOCODE,FID FROM T_BD_CURRENCY ");
            str.append(" WHERE FISOCODE IN (");
            str.append(CmpStrUtil.convertSetToSqlString(this.currenctMap.keySet()));
            str.append(")");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            try {
                while (rowSet.next()) {
                    this.currenctMap.put(rowSet.getString("FISOCODE"), rowSet.getString("FID"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
    }

    private void validData(Context ctx, List<Map<String, Object>> dataList) {
        block0: for (int i = dataList.size() - 1; i >= 0; --i) {
            String format;
            String submitElement;
            Map<String, Object> dataMap = dataList.get(i);
            String billNumber = dataMap.get("bill").toString();
            this.schemeNumber = dataMap.get("scheme").toString();
            String personNumber = dataMap.get("person").toString();
            String string = submitElement = null == dataMap.get("submitElement") ? null : dataMap.get("submitElement").toString();
            if (this.billNumberSet.contains(billNumber)) {
                String label391 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label39_1", (Locale)ctx.getLocale());
                format = MessageFormat.format(label391, billNumber);
                this.assembleUnvalidData(billNumber, format, ctx);
                dataList.remove(i);
                continue;
            }
            if (!this.entryInfoMap.containsKey(personNumber)) {
                String label401 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label40_1", (Locale)ctx.getLocale());
                format = MessageFormat.format(label401, billNumber, personNumber);
                this.assembleUnvalidData(personNumber, format, ctx);
                dataList.remove(i);
                continue;
            }
            if (this.isEnableSubmitElement) {
                if (StringUtils.isEmpty((String)submitElement)) {
                    String label411 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label41_1", (Locale)ctx.getLocale());
                    format = MessageFormat.format(label411, billNumber, this.schemeNumber);
                    this.assembleUnvalidData(personNumber, format, ctx);
                    dataList.remove(i);
                    continue;
                }
                if (!this.submitElementMap.containsKey(submitElement)) {
                    String label42 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label42", (Locale)ctx.getLocale());
                    format = MessageFormat.format(label42, billNumber, submitElement);
                    this.assembleUnvalidData(personNumber, format, ctx);
                    dataList.remove(i);
                    continue;
                }
            }
            List itemList = (List)dataMap.get("item");
            for (Map stringObjectMap : itemList) {
                String itemNumber = stringObjectMap.get("number").toString();
                if (this.calSubmitItemMap.containsKey(itemNumber)) continue;
                String label43 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label43", (Locale)ctx.getLocale());
                String format2 = MessageFormat.format(label43, billNumber, itemNumber, this.schemeNumber);
                this.assembleUnvalidData(billNumber, format2, ctx);
                dataList.remove(i);
                continue block0;
            }
        }
    }

    private void assembleUnvalidData(String billNumber, String msg, Context ctx) {
        String label44 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label44", (Locale)ctx.getLocale());
        this.changeReturnValue("0010", label44);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("number", billNumber);
        map.put("msg", msg);
        this.rerurnDataList.add(map);
    }

    class TempBatchSubmitEntry {
        private String personId;
        private String cmpEmpId;
        private String adminOrgId;
        private String positionId;
        private String currencyId;
        private String hrOrgUnitId;
        private Date effdt;

        TempBatchSubmitEntry() {
        }

        public String getPersonId() {
            return this.personId;
        }

        public void setPersonId(String personId) {
            this.personId = personId;
        }

        public String getCmpEmpId() {
            return this.cmpEmpId;
        }

        public void setCmpEmpId(String cmpEmpId) {
            this.cmpEmpId = cmpEmpId;
        }

        public String getAdminOrgId() {
            return this.adminOrgId;
        }

        public void setAdminOrgId(String adminOrgId) {
            this.adminOrgId = adminOrgId;
        }

        public String getPositionId() {
            return this.positionId;
        }

        public void setPositionId(String positionId) {
            this.positionId = positionId;
        }

        public String getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(String currencyId) {
            this.currencyId = currencyId;
        }

        public String getHrOrgUnitId() {
            return this.hrOrgUnitId;
        }

        public void setHrOrgUnitId(String hrOrgUnitId) {
            this.hrOrgUnitId = hrOrgUnitId;
        }

        public Date getEffdt() {
            return this.effdt;
        }

        public void setEffdt(Date effdt) {
            this.effdt = effdt;
        }
    }

    class ItemAttr {
        Object value;
        String currencyName;

        ItemAttr(Object value, String currencyName) {
            this.value = value;
            this.currencyName = currencyName;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getCurrencyName() {
            return this.currencyName;
        }

        public void setCurrencyName(String currencyName) {
            this.currencyName = currencyName;
        }
    }
}

