/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.AbstractSubmitCycleFacadeControllerBean;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.integrate.SubmitCycleHelper;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SubmitCycleFacadeControllerBean
extends AbstractSubmitCycleFacadeControllerBean {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _antiApproval(Context ctx, String submitSchemeId, String calShemeTableName, String billId) throws BOSException, EASBizException {
        String entranceName = "SubmitCycleFacadeControllerBean_antiApproval";
        CmpDistributedLockUtils.tryLockIfSuccess(ctx, entranceName, billId);
        try {
            this.handlerCycleLeffectDateForMiddleOfThree(ctx, calShemeTableName, billId);
            this.handlerCycleLeffectDateForTailOfTwo(ctx, calShemeTableName, billId);
            this.handlerCycleLeffectDateForHeadOfTwo(ctx, calShemeTableName, billId);
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, entranceName, billId);
        }
    }

    protected void handlerCycleLeffectDateForMiddleOfThree(Context ctx, String calShemeTableName, String billId) throws BOSException {
        String beforeCycleSql = "SELECT currentEntryExt.FTargetEntryId targetEntryId,currentEntryExt.FExpireDate currentExpireDate,beforeEntryExt.FID id, afterEntry.FEffectDate afterEffectDate, beforeEntry.FLEffectDate beforeLeffectDate FROM T_HR_SubmitEntryCycleExtend currentEntryExt LEFT JOIN T_HR_SubmitEntryCycleExtend beforeEntryExt ON currentEntryExt.FEntryID = beforeEntryExt.FTargetEntryId LEFT JOIN " + calShemeTableName + " beforeEntry ON beforeEntryExt.FEntryID = beforeEntry.FID LEFT JOIN " + calShemeTableName + " afterEntry ON currentEntryExt.FTargetEntryId = afterEntry.FID WHERE EXISTS ( SELECT 1 FROM " + calShemeTableName + " entry WHERE currentEntryExt.FEntryId = entry.FId AND entry.FBillId = '" + billId + "') AND beforeEntryExt.FID IS NOT NULL AND currentEntryExt.FTargetEntryId IS NOT NULL";
        ArrayList paramList = Lists.newArrayList();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)beforeCycleSql);
        try {
            while (rs.next()) {
                Date afterEntryEffectDate;
                Object[] param = new Object[3];
                Date beforeLeffectDate = rs.getDate("beforeLeffectDate");
                Date expireDate = CmpDateUtil.compare(beforeLeffectDate, afterEntryEffectDate = rs.getDate("afterEffectDate")) >= 0 ? CmpDateUtil.toSqlDate(CmpDateUtil.getAddDate(afterEntryEffectDate, -1)) : null;
                param[0] = expireDate;
                param[1] = rs.getString("targetEntryId");
                param[2] = rs.getString("id");
                paramList.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String updateBeforeCycleSql = "UPDATE T_HR_SubmitEntryCycleExtend SET FExpireDate=?,FTargetEntryId=? WHERE FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)updateBeforeCycleSql, (List)paramList);
    }

    protected void handlerCycleLeffectDateForTailOfTwo(Context ctx, String calShemeTableName, String billId) throws BOSException {
        String deleteSelfCycleSql = "DELETE FROM T_HR_SubmitEntryCycleExtend entryExt WHERE EXISTS( SELECT 1 FROM %s entry WHERE entryExt.FEntryId = entry.FId AND entry.FBillId = '%s')";
        DbUtil.execute((Context)ctx, (String)String.format(deleteSelfCycleSql, calShemeTableName, billId));
        String updateBeforeCycleSql = "UPDATE T_HR_SubmitEntryCycleExtend entryExt set FTargetEntryId = null, FExpireDate = null WHERE EXISTS( SELECT 1 FROM %s entry WHERE entryExt.FTargetEntryId = entry.FId AND entry.FBillId = '%s')";
        DbUtil.execute((Context)ctx, (String)String.format(updateBeforeCycleSql, calShemeTableName, billId));
    }

    protected void handlerCycleLeffectDateForHeadOfTwo(Context ctx, String calShemeTableName, String billId) throws BOSException {
        String deleteBeforeCycleSql = "DELETE FROM T_HR_SubmitEntryCycleExtend entryExt WHERE EXISTS( SELECT 1 FROM %s entry WHERE entryExt.FTargetEntryId = entry.FId AND entry.FBillId = '%s')";
        DbUtil.execute((Context)ctx, (String)String.format(deleteBeforeCycleSql, calShemeTableName, billId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _cancelHandleSalaryExpirePeriod(Context ctx, String dynamicEntryTable, String queryRange) throws BOSException, EASBizException {
        String entranceName = "SubmitCycleFacadeControllerBean_cancelHandleSalaryExpirePeriod";
        CmpDistributedLockUtils.tryLockIfSuccess(ctx, entranceName, dynamicEntryTable);
        try {
            this.handlerTransferSalaryExpirePeriodForMiddleOfThree(ctx, dynamicEntryTable, queryRange);
            this.handlerTransferSalaryExpirePeriodForTailOfTwo(ctx, dynamicEntryTable, queryRange);
            this.handlerTransferSalaryExpirePeriodForHeadOfTwo(ctx, dynamicEntryTable, queryRange);
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, entranceName, dynamicEntryTable);
        }
    }

    protected void handlerTransferSalaryExpirePeriodForMiddleOfThree(Context ctx, String calShemeTableName, String queryRange) throws BOSException {
        String beforeCycleSql = "SELECT currentCycle.FSalaryTargetEntryId currentSalaryTargetEntryId,currentCycle.FSalaryExpirePeriod currentSalaryExpirePeriod,beforeCycle.FSalaryEndPeriod beforeSalaryEndPeriod,beforeCycle.FID beforeCycleId, afterCycle.FSalaryStartPeriod afterSalaryStartPeriod FROM T_HR_SubmitEntryCycleExtend currentCycle LEFT JOIN T_HR_SubmitEntryCycleExtend beforeCycle ON currentCycle.FEntryID = beforeCycle.FSalaryTargetEntryId LEFT JOIN T_HR_SubmitEntryCycleExtend afterCycle on afterCycle.FEntryId = currentCycle.FSalaryTargetEntryId WHERE EXISTS (SELECT 1 FROM %s entry WHERE currentCycle.FEntryId = entry.FId AND entry.%s) AND beforeCycle.FID IS NOT NULL AND currentCycle.FSalaryTargetEntryId IS NOT NULL";
        beforeCycleSql = String.format(beforeCycleSql, calShemeTableName, queryRange);
        ArrayList paramList = Lists.newArrayList();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)beforeCycleSql);
            while (rs.next()) {
                String afterSalaryStartPeriod;
                String beforeSalaryEndPeriod = rs.getString("beforeSalaryEndPeriod");
                Object[] param = new Object[]{beforeSalaryEndPeriod.compareTo(afterSalaryStartPeriod = rs.getString("afterSalaryStartPeriod")) < 0 ? beforeSalaryEndPeriod : SubmitCycleHelper.getBeforeTransferSalaryFormatDateStr(afterSalaryStartPeriod), rs.getString("currentSalaryTargetEntryId"), rs.getString("beforeCycleId")};
                paramList.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!paramList.isEmpty()) {
            String updateBeforeCycleSql = "UPDATE T_HR_SubmitEntryCycleExtend set FSalaryExpirePeriod=?,FSalaryTargetEntryId=? WHERE FID = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateBeforeCycleSql, (List)paramList);
        }
    }

    protected void handlerTransferSalaryExpirePeriodForTailOfTwo(Context ctx, String calShemeTableName, String queryRange) throws BOSException {
        String updateBeforeCycleSql = "UPDATE T_HR_SubmitEntryCycleExtend entryExt set FSalaryTargetEntryId=null,FSalaryExpirePeriod=FSalaryEndPeriod WHERE EXISTS( SELECT 1 FROM %s entry WHERE entryExt.FSalaryTargetEntryId = entry.FId AND entry.%s)";
        DbUtil.execute((Context)ctx, (String)String.format(updateBeforeCycleSql, calShemeTableName, queryRange));
    }

    protected void handlerTransferSalaryExpirePeriodForHeadOfTwo(Context ctx, String calShemeTableName, String queryRange) throws BOSException {
        String updateBeforeCycleSql = "UPDATE T_HR_SubmitEntryCycleExtend entryExt set FSalaryStartPeriod=null,FSalaryEndPeriod=null,FSalaryTargetEntryId=null,FSalaryExpirePeriod=null  WHERE EXISTS( SELECT 1 FROM %s entry WHERE entryExt.FEntryId = entry.FId AND entry.%s)";
        DbUtil.execute((Context)ctx, (String)String.format(updateBeforeCycleSql, calShemeTableName, queryRange));
    }
}

