/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.TaxDeclareStatusEnum;
import com.kingdee.shr.compensation.TbTypeEnum;
import com.kingdee.shr.compensation.app.entity.Pair;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarCollection;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarInfo;
import com.kingdee.shr.compensation.app.tax.TaxDeclareTypeEnum;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractTaxPaymentServiceFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.DownloadWszmFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.IDownloadWszmFacade;
import com.kingdee.shr.compensation.app.taxCal.IPaymentBatchTable;
import com.kingdee.shr.compensation.app.taxCal.ITaxPaymentService;
import com.kingdee.shr.compensation.app.taxCal.ITaxServiceTaskFacade;
import com.kingdee.shr.compensation.app.taxCal.IThirdAgreement;
import com.kingdee.shr.compensation.app.taxCal.PaymentBatchTableFactory;
import com.kingdee.shr.compensation.app.taxCal.PaymentBatchTableInfo;
import com.kingdee.shr.compensation.app.taxCal.PaymentStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxPaymentServiceCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxPaymentServiceFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxPaymentServiceInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxPaymentTypeEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.ThirdAgreementCollection;
import com.kingdee.shr.compensation.app.taxCal.ThirdAgreementFactory;
import com.kingdee.shr.compensation.app.taxCal.ThirdAgreementInfo;
import com.kingdee.shr.compensation.tax.task.impl.GetTriAgreementService;
import com.kingdee.shr.compensation.tax.task.impl.TaxPaymentService;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TaxPaymentServiceFacadeControllerBean
extends AbstractTaxPaymentServiceFacadeControllerBean {
    private static final Logger LOG = Logger.getLogger(TaxPaymentServiceFacadeControllerBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _initPaymentData(Context ctx, String taxDeclareTaskID) throws BOSException {
        String incomeTaxDeclareSQL = "select id,taxUnit.id,yearMonth,yearMonthDate,totalPerson,totalMoney,taxRebate,declareStatus,tbType,taxRebackTask.id,declareType, batchNo where taxRebackTask = '" + taxDeclareTaskID + "'";
        IncomeTaxDeclarCollection incomeTaxDeclarCollection = IncomeTaxDeclarFactory.getLocalInstance(ctx).getIncomeTaxDeclarCollection(incomeTaxDeclareSQL);
        if (null == incomeTaxDeclarCollection || incomeTaxDeclarCollection.isEmpty()) {
            return;
        }
        String prefix = "incomeTax.payment";
        IncomeTaxDeclarInfo incomeTaxDeclarInfo = incomeTaxDeclarCollection.get(0);
        String resource = incomeTaxDeclarInfo.getId().toString();
        boolean flag = CmpDistributedLockUtils.tryLock(ctx, prefix, resource);
        if (!flag) {
            return;
        }
        try {
            String paymentSQL = "select id,totalPerson,totalMoney,taxRebate,paymentState where taxUnit.id = '" + incomeTaxDeclarInfo.getTaxUnit().getId() + "' and period = '" + incomeTaxDeclarInfo.getYearMonth() + "' and tbType = '" + incomeTaxDeclarInfo.getTbType().getValue() + "'";
            TaxPaymentServiceCollection collection = TaxPaymentServiceFactory.getLocalInstance(ctx).getTaxPaymentServiceCollection(paymentSQL);
            if (TaxDeclareTypeEnum.CORRECTION == incomeTaxDeclarInfo.getDeclareType() && null != collection && collection.size() > 0) {
                this.addPaymentInfoAfterUpdatingDeclare(ctx, incomeTaxDeclarInfo, collection);
                return;
            }
            TaxUnitInfo taxUnit = incomeTaxDeclarInfo.getTaxUnit();
            String period = incomeTaxDeclarInfo.getYearMonth();
            Date periodDate = incomeTaxDeclarInfo.getYearMonthDate();
            long totalPerson = incomeTaxDeclarInfo.getTotalPerson();
            BigDecimal totalMoney = incomeTaxDeclarInfo.getTotalMoney();
            BigDecimal taxRebate = incomeTaxDeclarInfo.getTaxRebate();
            TaxDeclareStatusEnum declareStatus = incomeTaxDeclarInfo.getDeclareStatus();
            TbTypeEnum tbType = incomeTaxDeclarInfo.getTbType();
            if ("2".equals(declareStatus.getValue())) {
                TaxPaymentServiceInfo taxPaymentServiceInfo;
                if (null == collection || collection.isEmpty()) {
                    taxPaymentServiceInfo = new TaxPaymentServiceInfo();
                    taxPaymentServiceInfo.setId(BOSUuid.create((BOSObjectType)taxPaymentServiceInfo.getBOSType()));
                    taxPaymentServiceInfo.setPaymentState(PaymentStateEnum.STANDBY);
                } else {
                    taxPaymentServiceInfo = collection.get(0);
                }
                taxPaymentServiceInfo.setTaxUnit(taxUnit);
                taxPaymentServiceInfo.setPeriod(period);
                taxPaymentServiceInfo.setPeriodDate(periodDate);
                taxPaymentServiceInfo.setTotalPerson(Integer.parseInt(String.valueOf(totalPerson)));
                taxPaymentServiceInfo.setTotalMoney(totalMoney);
                taxPaymentServiceInfo.setTaxRebate(taxRebate);
                taxPaymentServiceInfo.setTbType(tbType);
                this.setTaxPaymentType(taxPaymentServiceInfo);
                taxPaymentServiceInfo.setIncomeTaxDeclare(incomeTaxDeclarInfo);
                try {
                    TaxPaymentServiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)taxPaymentServiceInfo);
                }
                catch (EASBizException e) {
                    LOG.error((Object)"\u521d\u59cb\u5316\u7a0e\u6b3e\u7f34\u7eb3\u6570\u636e\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, prefix, resource);
        }
    }

    private void addPaymentInfoAfterUpdatingDeclare(Context ctx, IncomeTaxDeclarInfo declareInfo, TaxPaymentServiceCollection collection) throws BOSException {
        BigDecimal payedAmount = BigDecimal.ZERO;
        TaxPaymentServiceInfo paymentInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            TaxPaymentServiceInfo info = collection.get(i);
            PaymentStateEnum paymentState = info.getPaymentState();
            if (this.isPayedState(paymentState)) {
                payedAmount = payedAmount.add(info.getTaxRebate());
                continue;
            }
            paymentInfo = info;
        }
        if (null == paymentInfo) {
            paymentInfo = new TaxPaymentServiceInfo();
            paymentInfo.setId(BOSUuid.create((BOSObjectType)paymentInfo.getBOSType()));
            paymentInfo.setTaxUnit(declareInfo.getTaxUnit());
            paymentInfo.setPeriod(declareInfo.getYearMonth());
            paymentInfo.setPeriodDate(declareInfo.getYearMonthDate());
            paymentInfo.setTbType(declareInfo.getTbType());
            paymentInfo.setTotalPerson((int)declareInfo.getTotalPerson());
            paymentInfo.setTotalMoney(declareInfo.getTotalMoney());
            paymentInfo.setIncomeTaxDeclare(declareInfo);
            paymentInfo.setPaymentState(PaymentStateEnum.STANDBY);
        }
        if (payedAmount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal payment = declareInfo.getTaxRebate().subtract(payedAmount);
            paymentInfo.setTaxRebate(payment);
            double absValue = Math.abs(payment.doubleValue());
            if (absValue <= 1.0) {
                paymentInfo.setTaxPaymentType(TaxPaymentTypeEnum.NOPAYMENT);
            } else if (payment.compareTo(BigDecimal.ONE) > 0) {
                paymentInfo.setTaxPaymentType(TaxPaymentTypeEnum.SUPPLEMENTARY);
            } else {
                paymentInfo.setTaxPaymentType(TaxPaymentTypeEnum.REFUND);
            }
        } else {
            paymentInfo.setTaxRebate(declareInfo.getTaxRebate());
            this.setTaxPaymentType(paymentInfo);
        }
        paymentInfo.setTotalPerson((int)declareInfo.getTotalPerson());
        paymentInfo.setTotalMoney(declareInfo.getTotalMoney());
        paymentInfo.setPaymentState(PaymentStateEnum.STANDBY);
        try {
            TaxPaymentServiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)paymentInfo);
        }
        catch (Exception e) {
            LOG.error((Object)"modifyPaymentData error: ", (Throwable)e);
            throw new BOSException("\u521d\u59cb\u5316\u7a0e\u6b3e\u7f34\u7eb3\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean isPayedState(PaymentStateEnum paymentState) {
        return PaymentStateEnum.SUCCESS == paymentState || PaymentStateEnum.RUNNING == paymentState || PaymentStateEnum.CONFIRMSFXY == paymentState;
    }

    private void setTaxPaymentType(TaxPaymentServiceInfo taxPaymentServiceInfo) {
        if (taxPaymentServiceInfo.getTaxRebate().compareTo(BigDecimal.ONE) <= 0) {
            taxPaymentServiceInfo.setTaxPaymentType(TaxPaymentTypeEnum.NOPAYMENT);
        } else {
            taxPaymentServiceInfo.setTaxPaymentType(TaxPaymentTypeEnum.NORMAL);
        }
    }

    @Override
    protected List _sendPayCommand(Context ctx, String paymentRecordIDs) throws BOSException {
        List<TaxPaymentServiceInfo> taxPaymentServiceList;
        Pair taxUnitTaxPaymentServiceListPair;
        String buffer;
        ITaxServiceTaskFacade taxServiceTaskFacade = TaxServiceTaskFacadeFactory.getLocalInstance(ctx);
        ITaxPaymentService taxPaymentService = TaxPaymentServiceFactory.getLocalInstance(ctx);
        TaxPaymentServiceCollection taxPaymentServiceCollection = taxPaymentService.getTaxPaymentServiceCollection(buffer = " select id,taxUnit.id,taxUnit.name,taxUnit.number,taxUnit.taxNumber,  taxUnit.areaCode,taxUnit.regNumber,taxUnit.declPassword, taxUnit.realPassword, period,tbType,paymentState where id in (" + CmpStrUtil.converStringToSqlString(paymentRecordIDs, ",") + ") and paymentState in (" + 10 + "," + 40 + ")");
        if (null == taxPaymentServiceCollection || taxPaymentServiceCollection.size() == 0) {
            return null;
        }
        HashMap taxPaymentServiceMap = new HashMap();
        int size = taxPaymentServiceCollection.size();
        for (int i = 0; i < size; ++i) {
            TaxPaymentServiceInfo taxPaymentServiceInfo = taxPaymentServiceCollection.get(i);
            TaxUnitInfo taxUnitInfo = taxPaymentServiceInfo.getTaxUnit();
            String taxUnitID = taxUnitInfo.getId().toString();
            String period = taxPaymentServiceInfo.getPeriod();
            period = period.contains("-") ? period.replace("-", "") : period;
            period = period.substring(0, 6);
            String taxUnitIDPeriodKey = (String)taxUnitID + "_" + period;
            if (taxPaymentServiceMap.containsKey(taxUnitIDPeriodKey)) {
                taxUnitTaxPaymentServiceListPair = (Pair)taxPaymentServiceMap.get(taxUnitIDPeriodKey);
                taxPaymentServiceList = (List)taxUnitTaxPaymentServiceListPair.getSecond();
                taxPaymentServiceList.add(taxPaymentServiceInfo);
                taxUnitTaxPaymentServiceListPair.setSecond(taxPaymentServiceList);
            } else {
                taxPaymentServiceList = new ArrayList<TaxPaymentServiceInfo>();
                taxPaymentServiceList.add(taxPaymentServiceInfo);
                taxUnitTaxPaymentServiceListPair = new Pair(taxUnitInfo, taxPaymentServiceList);
            }
            taxPaymentServiceMap.put(taxUnitIDPeriodKey, taxUnitTaxPaymentServiceListPair);
        }
        Set taxUnitIDPeriodSet = taxPaymentServiceMap.keySet();
        String updateGetAgreementTaskID = "update T_HR_STaxPaymentService set FGetAgreementTaskID = ? where fid = ?";
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
        HashMap<String, String> getAgreementTaskMap = new HashMap<String, String>();
        for (String taxUnitIDPeriodTemp : taxUnitIDPeriodSet) {
            taxUnitTaxPaymentServiceListPair = (Pair)taxPaymentServiceMap.get(taxUnitIDPeriodTemp);
            TaxUnitInfo taxUnitInfo = (TaxUnitInfo)taxUnitTaxPaymentServiceListPair.getFirst();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("nsrsbh", taxUnitInfo.getTaxNumber());
            paramMap.put("areaid", taxUnitInfo.getAreaCode());
            paramMap.put("ver", "V2.0.000");
            paramMap.put("sdyf", taxUnitIDPeriodTemp.split("_")[1]);
            paramMap.put("djxhid", taxUnitInfo.getRegNumber());
            paramMap.put("smmm", Base64Utils.decode(taxUnitInfo.getRealPassword()));
            paramMap.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
            paramMap.put("TAXUNITID", taxUnitInfo.getId().toString());
            IObjectPK getAgreementTaskID = taxServiceTaskFacade.addTask(TaxCalTaskCatalogEnum.GetTriAgreement, paramMap);
            if (null == getAgreementTaskID) {
                throw new BOSException("\u521b\u5efa\u83b7\u53d6\u4e09\u65b9\u534f\u8bae\u7684\u4efb\u52a1\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            taxPaymentServiceList = taxUnitTaxPaymentServiceListPair.getSecond();
            int size2 = taxPaymentServiceList.size();
            for (int i = 0; i < size2; ++i) {
                String taxPaymentServiceID = ((TaxPaymentServiceInfo)taxPaymentServiceList.get(i)).getId().toString();
                Object[] updateParam = new Object[]{getAgreementTaskID.toString(), taxPaymentServiceID};
                updateParamList.add(updateParam);
            }
            getAgreementTaskMap.put(taxUnitIDPeriodTemp, getAgreementTaskID.toString());
        }
        if (updateParamList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateGetAgreementTaskID, updateParamList);
        }
        updateParamList = new ArrayList();
        Set taxPaymentTaskSet = taxPaymentServiceMap.keySet();
        String tbTypeStr = "";
        for (String taxUnitIDPeriodKeyTemp : taxPaymentTaskSet) {
            taxUnitTaxPaymentServiceListPair = (Pair)taxPaymentServiceMap.get(taxUnitIDPeriodKeyTemp);
            TaxUnitInfo taxUnitInfo = (TaxUnitInfo)taxUnitTaxPaymentServiceListPair.getFirst();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("nsrsbh", taxUnitInfo.getTaxNumber());
            paramMap.put("areaid", taxUnitInfo.getAreaCode());
            paramMap.put("ver", "V2.0.000");
            paramMap.put("djxhid", taxUnitInfo.getRegNumber());
            paramMap.put("smmm", Base64Utils.decode(taxUnitInfo.getRealPassword()));
            paramMap.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
            taxPaymentServiceList = taxUnitTaxPaymentServiceListPair.getSecond();
            String period = taxUnitIDPeriodKeyTemp.split("_")[1];
            paramMap.put("sdyfq", period);
            paramMap.put("sdyfz", period);
            paramMap.put("sdyf", period);
            HashSet<String> tbTypeSet = new HashSet<String>();
            int size3 = taxPaymentServiceList.size();
            for (int i = 0; i < size3; ++i) {
                TaxPaymentServiceInfo taxPaymentServiceInfo = (TaxPaymentServiceInfo)taxPaymentServiceList.get(0);
                tbTypeStr = taxPaymentServiceInfo.getTbType().getName();
                tbTypeSet.add(tbTypeStr);
            }
            paramMap.put("bblb", tbTypeSet.toArray());
            paramMap.put("RELAYTASK", getAgreementTaskMap.get(taxUnitIDPeriodKeyTemp));
            paramMap.put("TAXUNITID", taxUnitInfo.getId().toString());
            IObjectPK paymentServiceTaskID = taxServiceTaskFacade.addTask(TaxCalTaskCatalogEnum.TaxPayment, paramMap);
            int size4 = taxPaymentServiceList.size();
            for (int i = 0; i < size4; ++i) {
                String taxPaymentServiceID = ((TaxPaymentServiceInfo)taxPaymentServiceList.get(i)).getId().toString();
                Object[] updateParam = new Object[]{paymentServiceTaskID.toString(), taxPaymentServiceID};
                updateParamList.add(updateParam);
            }
        }
        if (updateParamList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)("update T_HR_STaxPaymentService set FPaymentServiceTaskID = ?,FPaymentState = 20,FLastUpdateUserID= '" + HRFilterUtils.getCurrentUserId((Context)ctx) + "',FLastUpdateTime = " + CmpDateUtil.toKSqlDate(new Date()) + " where fid = ?"), updateParamList);
        }
        return updateParamList;
    }

    @Override
    protected void _handleAfterGetAgreement(Context ctx, String taskID, String result) throws BOSException {
        Map bodyMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)result, Map.class);
        Map dataMap1 = (Map)bodyMap.get("data");
        List dataMap = (List)dataMap1.get("data");
        String code = (String)bodyMap.get("code");
        if ("0000".equals(code)) {
            IThirdAgreement thirdAgreement = ThirdAgreementFactory.getLocalInstance(ctx);
            Set<String> fields = this.initThirdAgreementTableField();
            ArrayList<Object[]> deleteParamList = new ArrayList<Object[]>();
            String deleteThirdAgreementSQL = "delete from T_HR_SThirdAgreement where FSfxyh = ?";
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            int agreementSize = dataMap.size();
            if (agreementSize == 0) {
                throw new BOSException("\u672a\u83b7\u53d6\u5230\u4e09\u65b9\u534f\u8bae");
            }
            try {
                String usedSfxyh = "";
                TaxCalTaskCollection taxCalTaskCollection = TaxCalTaskFactory.getLocalInstance(ctx).getTaxCalTaskCollection("select id,taxUnit.id,taxUnit.sfxyh where id = '" + taskID + "'");
                TaxUnitInfo taxUnitInfo = null;
                if (null != taxCalTaskCollection && taxCalTaskCollection.size() > 0) {
                    taxUnitInfo = taxCalTaskCollection.get(0).getTaxUnit();
                    usedSfxyh = taxUnitInfo.getSfxyh();
                }
                boolean isContinueTask = true;
                if (StringUtils.isEmpty((CharSequence)usedSfxyh)) {
                    isContinueTask = false;
                }
                if (agreementSize > 1) {
                    isContinueTask = false;
                }
                for (int i = 0; i < agreementSize; ++i) {
                    Map thirdAgreementRow = (Map)dataMap.get(i);
                    Object[] deleteParam = new Object[1];
                    String tempSfxyh = null == thirdAgreementRow.get("sfxyh") ? null : thirdAgreementRow.get("sfxyh").toString();
                    String tempSfyx = thirdAgreementRow.get("sfyx").toString();
                    deleteParam[0] = tempSfxyh;
                    deleteParamList.add(deleteParam);
                    if (StringUtils.isEmpty((CharSequence)tempSfxyh)) {
                        throw new BOSException("\u83b7\u53d6\u5230\u7684\u4e09\u65b9\u534f\u8bae\u53f7\u4e3a\u7a7a");
                    }
                    if (tempSfxyh.equals(usedSfxyh) && "\u662f".equals(tempSfyx)) {
                        isContinueTask = true;
                    }
                    if (agreementSize == 1) {
                        isContinueTask = true;
                        usedSfxyh = tempSfxyh;
                    }
                    ThirdAgreementInfo thirdAgreementInfo = new ThirdAgreementInfo();
                    for (String field : fields) {
                        thirdAgreementInfo.put(field, null == thirdAgreementRow.get(field) ? null : thirdAgreementRow.get(field).toString());
                    }
                    thirdAgreementInfo.setTaxUnit(taxUnitInfo);
                    thirdAgreementInfo.setId(BOSUuid.create((String)"24E03C6C"));
                    coreBaseCollection.add((CoreBaseInfo)thirdAgreementInfo);
                }
                if (deleteParamList.size() > 0) {
                    DbUtil.executeBatch((Context)ctx, (String)deleteThirdAgreementSQL, deleteParamList);
                }
                thirdAgreement.addnewBatchData(coreBaseCollection);
                if (isContinueTask) {
                    String updatePaymentServiceState = "update T_HR_STaxPaymentService Set FSfxyh = '" + usedSfxyh + "' where FGetAgreementTaskID = '" + taskID + "'";
                    DbUtil.execute((Context)ctx, (String)updatePaymentServiceState);
                    String updateNextTaskStateSQL = "update T_HR_STaxCalTask set FSTATE = 10 where FRelayTaskID = '" + taskID + "'";
                    DbUtil.execute((Context)ctx, (String)updateNextTaskStateSQL);
                } else {
                    String updatePaymentServiceState = "update T_HR_STaxPaymentService Set FPaymentState = 50 where FGetAgreementTaskID = '" + taskID + "'";
                    DbUtil.execute((Context)ctx, (String)updatePaymentServiceState);
                    GetTriAgreementService service = new GetTriAgreementService();
                    TaxCalTaskInfo taskInfo = TaxCalTaskFactory.getLocalInstance(ctx).getTaskById(taskID);
                    service.sendMsg2Commander(ctx, taskInfo);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"\u5728\u83b7\u53d6\u4e09\u65b9\u534f\u8bae\u540e\u5904\u7406\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u65e5\u5fd7\u8fdb\u884c\u5206\u6790", (Throwable)e);
                throw new BOSException("\u5728\u83b7\u53d6\u4e09\u65b9\u534f\u8bae\u540e\u5904\u7406\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u65e5\u5fd7\u8fdb\u884c\u5206\u6790", (Throwable)e);
            }
        }
    }

    private Set<String> initThirdAgreementTableField() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("sfxydjuuid");
        fields.add("djxh");
        fields.add("skssswjgdm");
        fields.add("sfxyh");
        fields.add("yhhbdm");
        fields.add("yhhbmc");
        fields.add("yhyywddm");
        fields.add("xzqhszdm");
        fields.add("qsyhhh");
        fields.add("khyhhh");
        fields.add("jkzh");
        fields.add("jkzhmc");
        fields.add("sfxyztdm");
        fields.add("sfxyyzxx");
        fields.add("sfxyyztgrq");
        fields.add("pkbz");
        fields.add("sjtbsj");
        fields.add("gxsj");
        fields.add("sfyx");
        fields.add("skssswjgmc");
        return fields;
    }

    @Override
    protected void _handleAfterPayment(Context ctx, String taskID, String result) throws BOSException {
        Map bodyMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)result, Map.class);
        Map payments = (Map)bodyMap.get("data");
        List rowList = (List)payments.get("data");
        try {
            IPaymentBatchTable paymentBatchTable = PaymentBatchTableFactory.getLocalInstance(ctx);
            Set<String> fields = this.initPaymentBatchTableField();
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            ArrayList<Object[]> paymentParams = new ArrayList<Object[]>();
            for (Map paymentBatchTableRow : rowList) {
                PaymentBatchTableInfo paymentBatchTableInfo = new PaymentBatchTableInfo();
                for (String field : fields) {
                    paymentBatchTableInfo.put(field, null == paymentBatchTableRow.get(field) ? null : paymentBatchTableRow.get(field).toString());
                }
                paymentBatchTableInfo.setId(BOSUuid.create((BOSObjectType)paymentBatchTableInfo.getBOSType()));
                coreBaseCollection.add((CoreBaseInfo)paymentBatchTableInfo);
                Object[] paymentParam = new Object[]{this.convertPaymentState((Double)paymentBatchTableRow.get("jkzt")), taskID, this.getTbType((String)paymentBatchTableRow.get("bblb"))};
                paymentParams.add(paymentParam);
            }
            paymentBatchTable.addnewBatchData(coreBaseCollection);
            String updateTaxPaymentState = "update T_HR_STaxPaymentService set FPaymentState = ? where FPaymentServiceTaskID = ? and fTbType = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateTaxPaymentState, paymentParams);
            TaxPaymentService taxReportService = new TaxPaymentService();
            TaxCalTaskInfo taskInfo = TaxCalTaskFactory.getLocalInstance(ctx).getTaskById(taskID);
            taxReportService.sendMsg2Commander(ctx, taskInfo);
            String oql = "select id, tbType, period, periodDate, paymentState, wszmFileId,getWszmTask.state, taxUnit.id, taxUnit.areaCode, taxUnit.taxNumber, taxUnit.regNumber, taxUnit.declPassword, taxUnit.realPassword, lastUpdateUser.person.id where paymentServiceTask.id = '" + taskID + "'";
            TaxPaymentServiceCollection taxPaymentServiceCollection = TaxPaymentServiceFactory.getLocalInstance(ctx).getTaxPaymentServiceCollection(oql);
            boolean isTaxPaymentServiceCollectionEmpty = null == taxPaymentServiceCollection || taxPaymentServiceCollection.isEmpty();
            LOG.info((Object)("sendGetWszmTask, isTaxPaymentServiceCollectionEmpty = " + isTaxPaymentServiceCollectionEmpty + "for taskID: " + taskID));
            if (!isTaxPaymentServiceCollectionEmpty) {
                IDownloadWszmFacade downloadWszmFacade = DownloadWszmFacadeFactory.getLocalInstance(ctx);
                downloadWszmFacade.sendGetWszmTask(taxPaymentServiceCollection);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"\u5728\u7f34\u6b3e\u67e5\u8be2\u670d\u52a1\u540e\u5904\u7406\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u65e5\u5fd7\u8fdb\u884c\u5206\u6790", (Throwable)e);
            throw new BOSException("\u5728\u7f34\u6b3e\u67e5\u8be2\u670d\u52a1\u540e\u5904\u7406\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u65e5\u5fd7\u8fdb\u884c\u5206\u6790", (Throwable)e);
        }
    }

    private Object getTbType(String bblb) {
        List list = TbTypeEnum.getEnumList();
        for (TbTypeEnum typeEnum : list) {
            if (!typeEnum.getName().equals(bblb)) continue;
            return typeEnum.getValue();
        }
        return "";
    }

    private int convertPaymentState(Double jkzt) {
        if (1.0 == jkzt || 3.0 == jkzt) {
            return 30;
        }
        return 40;
    }

    private Set<String> initPaymentBatchTableField() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("yzpzxh");
        fields.add("wysbh");
        fields.add("dzsphm");
        fields.add("kkfhdm");
        fields.add("kkfhmc");
        fields.add("sdyf");
        fields.add("bblb");
        fields.add("skssq_q");
        fields.add("skssq_z");
        fields.add("sjse");
        fields.add("sjsehz");
        fields.add("ybtse");
        fields.add("ybtsehz");
        fields.add("jkqx");
        fields.add("jkrq");
        fields.add("jkzt");
        fields.add("jkxx");
        fields.add("kkfktbbz");
        fields.add("sfxyh");
        fields.add("yblsh");
        return fields;
    }

    @Override
    protected void _confirmSfxy(Context ctx, String taxUnitID, String sfxyhID) throws BOSException {
        String sfxyh = "";
        ThirdAgreementCollection thirdAgreementCollection = ThirdAgreementFactory.getLocalInstance(ctx).getThirdAgreementCollection("select id,sfxyh where id = '" + sfxyhID + "'");
        if (null == thirdAgreementCollection || thirdAgreementCollection.size() == 0) {
            throw new BOSException("\u83b7\u53d6\u4e09\u65b9\u534f\u8bae\u5931\u8d25\uff0c\u534f\u8baeid\uff1a" + sfxyhID);
        }
        sfxyh = thirdAgreementCollection.get(0).getSfxyh();
        String updateSql = "update T_HR_TaxUnit Set FSfxyh = '" + sfxyh + "' where FID = '" + taxUnitID + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
        updateSql = "update T_HR_STaxPaymentService set FPaymentState = 20,FSfxyh = '" + sfxyh + "' where FTaxUnitID = '" + taxUnitID + "' and FPaymentState = " + 50;
        DbUtil.execute((Context)ctx, (String)updateSql);
        updateSql = "update T_HR_STaxCalTask set FSTATE = 10 where FTaxUnitID = '" + taxUnitID + "' and FState = " + 5 + " and FCatalog = " + 70;
        DbUtil.execute((Context)ctx, (String)updateSql);
    }
}

