/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.cal;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.budget.calculate.BudgetCalculateBusinessDataCommon;
import com.kingdee.shr.compensation.budget.dto.BudgetCalculateOuterData;
import com.kingdee.shr.compensation.budget.dto.BudgetDataTreeNodeInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataAccess;
import com.kingdee.shr.validaterule.formula.base.data.DataRow;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetAdjustCalculatorBusinessDataCommon
extends BudgetCalculateBusinessDataCommon {
    private static final Logger logger = LoggerFactory.getLogger(BudgetAdjustCalculatorBusinessDataCommon.class);
    public static Pattern numStartPattern = Pattern.compile("\\d+$");

    @Override
    public DataSet initCalData(InitCalData initCalData) throws EASBizException {
        String mainTableName = initCalData.getMainTableName();
        Map assTable = initCalData.getAssTable();
        assTable.put("T_ORG_Admin~adminOrgUnit", (assTable.containsKey("T_ORG_Admin~adminOrgUnit") ? (String)assTable.get("T_ORG_Admin~adminOrgUnit") + "," : "") + "T_ORG_Admin.FID");
        assTable.put("T_HR_CostType~costType", (assTable.containsKey("T_HR_CostType~costType") ? (String)assTable.get("T_HR_CostType~costType") + "," : "") + "T_HR_CostType.FID");
        DataSet dataSet = super.getSuperData(initCalData);
        Object data = initCalData.getOuterData();
        if (null == data || !(data instanceof BudgetCalculateOuterData)) {
            return dataSet;
        }
        HashMap<String, BudgetDataTreeNodeInfo> budgetDataTree = new HashMap<String, BudgetDataTreeNodeInfo>();
        Context ctx = initCalData.getCtx();
        BudgetCalculateOuterData outData = (BudgetCalculateOuterData)data;
        DataTable mainTable = dataSet.getTables(mainTableName);
        ArrayList columns = mainTable.columns;
        HashMap existDatasIndexMap = mainTable.datasIndexMap;
        ArrayList existDatas = mainTable.datas;
        List<String> adminOrgUnitIds = outData.getAdminOrgUnitIds();
        String adminInSql = CmpInSql.createInSqlWithoutTmpTable(ctx, adminOrgUnitIds);
        Map<String, String> orgParentMapper = this.initOrgParentMapper(ctx, adminInSql);
        this.initSubOrgData(initCalData, budgetDataTree, orgParentMapper);
        String queryBaseData4AddNew = "ADMINORGUNIT.id in " + adminInSql;
        String sql = "";
        try {
            sql = this.buildDataSetSql(initCalData, queryBaseData4AddNew, true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        DataAccess dac = new DataAccess();
        DataTable addNewDt = dac.getDataForDataTable(initCalData.getCtx(), sql);
        List addNewDatas = addNewDt.datas;
        Map addNewDatasIndexMap = addNewDt.datasIndexMap;
        ArrayList addNewColumn = addNewDt.columns;
        HashMap<String, Integer> addNewColumnIndex = new HashMap<String, Integer>();
        int size = addNewColumn.size();
        for (int i = 0; i < size; ++i) {
            String colName = ((ColumnAttributes)addNewColumn.get(i)).getName();
            colName = "FID".equals(colName) ? "ADMINORGUNIT.FID" : colName;
            addNewColumnIndex.put(colName, i);
        }
        if (null == existDatasIndexMap) {
            existDatas = new ArrayList();
            existDatasIndexMap = new HashMap();
        }
        Map<String, Map<String, Object>> outerData = outData.getData();
        Set<Map.Entry<String, Map<String, Object>>> entrySet = outerData.entrySet();
        for (Map.Entry<String, Map<String, Object>> perRow : entrySet) {
            DataRow dataRow;
            String rowId = perRow.getKey();
            Map<String, Object> rowValue = perRow.getValue();
            boolean isExist = existDatasIndexMap.containsKey(rowId);
            if (isExist) {
                dataRow = (DataRow)existDatas.get((Integer)existDatasIndexMap.get(rowId));
            } else {
                dataRow = new DataRow();
                dataRow.columns = columns;
                mainTable.addRow(dataRow, rowId);
            }
            String adminId = (String)rowValue.get("ADMINORGUNIT.FID");
            String parentId = orgParentMapper.get(adminId);
            for (ColumnAttributes attributes : columns) {
                String colname = attributes.getName();
                if (null == colname) continue;
                if ("FID".equalsIgnoreCase(colname)) {
                    dataRow.add((Object)rowId);
                    continue;
                }
                String valueCol = colname.toUpperCase(Locale.ENGLISH).startsWith("BUDGETADJENTRY.M") ? colname.split("\\.")[1] : colname;
                valueCol = valueCol.toUpperCase(Locale.ENGLISH);
                Object value = null;
                if (addNewColumnIndex.containsKey(colname) || "ADMINORGUNIT.ID".equals(colname)) {
                    value = ((DataRow)addNewDatas.get((Integer)addNewDatasIndexMap.get(rowValue.get("ADMINORGUNIT.FID")))).getValue(((Integer)addNewColumnIndex.get(colname)).intValue());
                } else if (rowValue.containsKey(valueCol) || "COSTTYPE.FID".equals(colname)) {
                    value = rowValue.get(valueCol);
                }
                if (isExist) {
                    dataRow.setValue(colname, value);
                } else {
                    dataRow.add(value);
                }
                dataRow.setModify(true);
            }
            BudgetDataTreeNodeInfo treeNodeInfo = budgetDataTree.containsKey(adminId) ? (BudgetDataTreeNodeInfo)budgetDataTree.get(adminId) : new BudgetDataTreeNodeInfo(adminId, parentId);
            Set<Map.Entry<String, Object>> rowValueEntrySet = rowValue.entrySet();
            Iterator<Map.Entry<String, Object>> rowValueIt = rowValueEntrySet.iterator();
            if (treeNodeInfo.getProcessData() == null || treeNodeInfo.getProcessData().isEmpty()) {
                while (rowValueIt.hasNext()) {
                    Map.Entry<String, Object> columnentry = rowValueIt.next();
                    String colname = columnentry.getKey();
                    Object value = columnentry.getValue();
                    Matcher matcher = numStartPattern.matcher(colname);
                    if (!matcher.find()) continue;
                    String TN = rowValue.get("COSTTYPE.FID") + "_" + colname.replace("M", "T");
                    treeNodeInfo.setCurData(TN, value);
                }
            }
            budgetDataTree.put(adminId, treeNodeInfo);
            if (StringUtils.isEmpty((CharSequence)parentId)) continue;
            BudgetDataTreeNodeInfo parentTreeNodeInfo = (BudgetDataTreeNodeInfo)budgetDataTree.get(parentId);
            if (null != parentTreeNodeInfo) {
                parentTreeNodeInfo.addChild(treeNodeInfo);
                continue;
            }
            parentTreeNodeInfo = new BudgetDataTreeNodeInfo(parentId, orgParentMapper.get(parentId));
            parentTreeNodeInfo.addChild(treeNodeInfo);
            budgetDataTree.put(parentId, parentTreeNodeInfo);
        }
        String uid = initCalData.getUid();
        String cacheKey = MD5Util.getMD5String((String)(uid + ctx));
        CacheService cacheService = CacheService.getInstance();
        cacheService.hset("shr.validateruleCache", cacheKey, "BUDGET_MANAGE_TREEDATA_CACHE_KEY", budgetDataTree);
        int tableCount = dataSet.tableCount();
        for (int i = 0; i < tableCount; ++i) {
            DataTable table = dataSet.getTables(i);
            table.datas = mainTable.datas;
            table.columns = mainTable.columns;
            table.datasIndexMap = mainTable.datasIndexMap;
            table.emptyrow = mainTable.emptyrow;
        }
        return dataSet;
    }

    @Override
    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        String language = ctx.getLocale().getLanguage();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT  b.fid ITEMID, b.FieldSn FIELDSN,b.fname_" + language + " ITEMNAME ");
        builder.append(" ,b.FDATADOT,b.FDATATYPE,b.FIELDSN,b.FDATALENGTH ");
        builder.append(" FROM T_HR_SCmpBudgetScheme scheme ");
        builder.append(" inner join T_HR_SBudgetTemplateItem a  on scheme.FTemplateID = a.FTemplateID ");
        builder.append(" inner join T_HR_SCmpBudgetItem b on a.FBudgetItemID = b.fid ");
        builder.append(" where scheme.fId = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{schemeID});
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        HashMap<String, Integer> strItemLenMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum((int)rs.getInt("FDATADOT"));
                Integer dataType = rs.getInt("FDATATYPE");
                String name = rs.getString("ITEMNAME");
                String fieldSn = rs.getString("FIELDSN");
                sn.add("m" + fieldSn);
                cn.add(name);
                dataDotMap.put("m" + fieldSn, dataDot);
                dataTypeMap.put("m" + fieldSn, dataType);
                if (dataType == 1) {
                    strItemLenMap.put("m" + fieldSn, rs.getInt("FDATALENGTH"));
                }
                idItemMap.put(("m" + fieldSn).toUpperCase(Locale.ENGLISH), rs.getString("ITEMID"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        sn.add("forwarncontent");
        cn.add(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryApplyResource", (String)"label24", (Locale)ctx.getLocale()));
        dataTypeMap.put("forwarncontent", 1);
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        return res;
    }

    @Override
    protected void initSubOrgData(InitCalData initCalData, Map<String, BudgetDataTreeNodeInfo> budgetDataTree, Map<String, String> orgParentMapper) {
        try {
            BudgetCalculateOuterData outData = (BudgetCalculateOuterData)initCalData.getOuterData();
            HashSet adminOrgUnitIds = Sets.newHashSet();
            for (Map.Entry<String, String> entry : orgParentMapper.entrySet()) {
                adminOrgUnitIds.add(entry.getKey());
                String value = entry.getValue();
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                adminOrgUnitIds.add(value);
            }
            Set<String> selectedFields = this.getSelectedFields(initCalData);
            if (selectedFields == null || selectedFields.isEmpty()) {
                return;
            }
            IRowSet rowSet = this.initManageOrgDataRowSet(initCalData, selectedFields, outData, adminOrgUnitIds);
            this.convertRowSetData(budgetDataTree, orgParentMapper, rowSet, selectedFields, true);
            rowSet = this.initProcessOrgDataRowSet(initCalData, selectedFields, outData, adminOrgUnitIds);
            this.convertRowSetData(budgetDataTree, orgParentMapper, rowSet, selectedFields, false);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected IRowSet initCurrentBillDataRowSet(InitCalData initCalData, Set<String> selectedFields, BudgetCalculateOuterData outData) throws BOSException {
        StringBuilder getCurrentDataSql = new StringBuilder();
        String mainTableAlias = "entry";
        Context ctx = initCalData.getCtx();
        initCalData.getCondition();
        String selectedFieldsStr = selectedFields.toString().replace("T", "M").replace("[", "").replace("]", ",");
        getCurrentDataSql.append(" select ").append(selectedFieldsStr);
        getCurrentDataSql.append(mainTableAlias).append(".FCostTypeID ,").append(mainTableAlias).append(".FAdminOrgUnitID ");
        getCurrentDataSql.append("  from T_HR_SBudgetAdjustEntry ").append(mainTableAlias);
        getCurrentDataSql.append("  where   ");
        getCurrentDataSql.append(mainTableAlias + ".fid in (" + initCalData.getCondition() + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getCurrentDataSql.toString());
        return rowSet;
    }

    protected void convertRowSetDataCurrentBill(Map<String, BudgetDataTreeNodeInfo> budgetDataTree, Map<String, String> orgParentMapper, IRowSet rowSet, Set<String> selectedFields, boolean isCurData) throws SQLException {
        while (rowSet.next()) {
            String costType = rowSet.getString("FCostTypeID");
            String adminId = rowSet.getString("FAdminOrgUnitID");
            String parentId = orgParentMapper.get(adminId);
            BudgetDataTreeNodeInfo treeNodeInfo = budgetDataTree.containsKey(adminId) ? budgetDataTree.get(adminId) : new BudgetDataTreeNodeInfo(adminId, parentId);
            if (treeNodeInfo.getProcessData() == null || treeNodeInfo.getProcessData().isEmpty()) {
                for (String field : selectedFields) {
                    Object object = rowSet.getObject(field.replace("T", "M"));
                    if (null == object) continue;
                    if (isCurData) {
                        treeNodeInfo.setCurData(costType + "_" + field, object);
                        continue;
                    }
                    treeNodeInfo.setProcessData(costType + "_" + field, object);
                }
            }
            budgetDataTree.put(adminId, treeNodeInfo);
            if (StringUtils.isEmpty((CharSequence)parentId)) continue;
            BudgetDataTreeNodeInfo parentTreeNodeInfo = budgetDataTree.get(parentId);
            if (null != parentTreeNodeInfo) {
                parentTreeNodeInfo.addChild(treeNodeInfo);
            } else {
                parentTreeNodeInfo = new BudgetDataTreeNodeInfo(parentId, orgParentMapper.get(parentId));
                parentTreeNodeInfo.addChild(treeNodeInfo);
            }
            budgetDataTree.put(parentId, parentTreeNodeInfo);
        }
    }

    protected IRowSet initManageOrgDataRowSet(InitCalData initCalData, Set<String> selectedFields, BudgetCalculateOuterData outData, Set<String> adminOrgUnitIds) throws BOSException {
        StringBuilder getexistDataSql = new StringBuilder();
        String mainTableAlias = "MANAGE";
        String mainTable = "T_HR_SBudgetManage";
        Context ctx = initCalData.getCtx();
        List<String> costTypes = outData.getCostTypes();
        getexistDataSql.append(" select ").append(selectedFields.toString().replace("[", "").replace("]", ","));
        getexistDataSql.append(mainTableAlias).append(".FCostTypeID ,").append(mainTableAlias).append(".FAdminOrgUnitID ");
        getexistDataSql.append("  from ").append(mainTable).append(" ").append(mainTableAlias).append(" ");
        getexistDataSql.append("  inner join T_ORG_Admin orgAdmin on ").append(mainTableAlias).append(".FAdminOrgUnitID = orgAdmin.fid ");
        getexistDataSql.append("  where ");
        getexistDataSql.append("  (orgAdmin.fparentid in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, adminOrgUnitIds));
        getexistDataSql.append("  or orgAdmin.fid in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, adminOrgUnitIds));
        getexistDataSql.append("  or orgAdmin.fparentid is null) ");
        getexistDataSql.append("  and " + mainTableAlias + ".FCostTypeID in ").append(CmpInSql.createInSqlWithoutTmpTable(ctx, costTypes));
        getexistDataSql.append("  and " + mainTableAlias + ".FBudgetYear = ").append(outData.getBudgetYear());
        getexistDataSql.append("  and " + mainTableAlias + ".FBudgetSchemeID = ? ");
        getexistDataSql.append("  order by orgAdmin.flongnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getexistDataSql.toString(), (Object[])new Object[]{outData.getBudgetSchemeId()});
        return rowSet;
    }

    @Override
    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        return this.buildDataSetSql(initCalData, "budgetAdjEntry.id in (" + initCalData.getCondition() + ")", false);
    }

    @Override
    protected void removeMainTableItem(Map<String, String> selectMapping) {
        Set<Map.Entry<String, String>> entrySet = selectMapping.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> selector = iterator.next();
            String columnName = selector.getKey();
            if (!columnName.toUpperCase().startsWith("BUDGETADJENTRY.")) continue;
            iterator.remove();
        }
        selectMapping.remove("costType.id");
        selectMapping.put("ADMINORGUNIT.id", "FID");
    }
}

