/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budget.bashboard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.NumericalUnit;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.BudgetTools;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.DashBoardInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.DashBoardManager;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.util.BudgetAmountUtil;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetDashboardForPeriod
extends AbstractJavaDataQueryService {
    private static final Logger logger = Logger.getLogger(BudgetDashboardForPeriod.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        Object adminOrgUnitObj = this.getParamValue(ctx, "adminOrgUnitId", param);
        Object templateObj = this.getParamValue(ctx, "templateId", param);
        Object periodObj = this.getParamValue(ctx, "period", param);
        if (null == adminOrgUnitObj || null == templateObj || null == periodObj) {
            return result;
        }
        boolean finished = BudgetAmountUtil.budgetInit(ctx);
        if (!finished) {
            return result;
        }
        Object numericalUnit = this.getParamValue(ctx, "numericalUnit", param);
        NumericalUnit unit = null == numericalUnit ? null : NumericalUnit.getEnum(Integer.valueOf(numericalUnit.toString()));
        String templateId = templateObj.toString().replaceAll("'", "");
        String adminOrgUnitId = adminOrgUnitObj.toString().replaceAll("'", "");
        Date currentDate = Date.valueOf(periodObj.toString());
        int year = BudgetTools.getCurrentYear(ctx, templateId, currentDate);
        DashBoardInfo info = DashBoardManager.getPeriodInfo(ctx, param.getPermItemId(), templateId, adminOrgUnitId, year, currentDate);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        dataList.add(DashBoardManager.combineResult(ctx, info, unit));
        result.setRows(dataList);
        return result;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        return this.getAllData(ctx, param);
    }
}

