/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.ICalFormula;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class CalFormulaBizUtil {
    private static Logger logger = Logger.getLogger(CalFormulaBizUtil.class);

    private CalFormulaBizUtil() {
    }

    public static CalFormulaInfo getCalFormulaInfoBySchemeID(Context ctx, String schemeId) {
        String oql = CalFormulaBizUtil.assembleOql(null, schemeId);
        return CalFormulaBizUtil._getCalFormulaInfo(ctx, oql);
    }

    public static CalFormulaInfo getCalFormulaInfoByIdAndSchemeID(Context ctx, String calFormulaId, String schemeId) {
        String oql = CalFormulaBizUtil.assembleOql(calFormulaId, schemeId);
        return CalFormulaBizUtil._getCalFormulaInfo(ctx, oql);
    }

    private static CalFormulaInfo _getCalFormulaInfo(Context ctx, String oql) {
        CalFormulaInfo calFormulaInfo = null;
        try {
            calFormulaInfo = CalFormulaBizUtil.getBizInterface(ctx).getCalFormulaInfo(oql);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)"CalFormulaBizUtil.getCalFormulaInfoByIdAndSchemeID error");
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)"CalFormulaBizUtil.getCalFormulaInfoByIdAndSchemeID  error");
        }
        return calFormulaInfo;
    }

    private static ICalFormula getBizInterface(Context ctx) {
        ICalFormula bizInterface = null;
        try {
            bizInterface = CalFormulaFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return bizInterface;
    }

    private static String assembleOql(String calFormulaId, String schemeId) {
        StringBuffer oql = new StringBuffer();
        oql.append(" select  id,name, express,listItem,listFunc,listVar,listTable,sortSn,isCal where ");
        oql.append(" calScheme.id ='").append(schemeId).append("'");
        if (!StringUtils.isEmpty((String)calFormulaId)) {
            oql.append(" AND id ='").append(calFormulaId).append("'");
        }
        oql.append(" AND isCal=1 ");
        oql.append(" ORDER BY sortSn ASC ");
        return oql.toString();
    }
}

