/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.common.CommonMethod;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import java.security.SecureRandom;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CalFunctionService_extend {
    public double getExtremumOfItem(HashMap tempMap, CalSchemeInfo calScheme, String itemName, double dataType) throws Exception {
        double num = 0.0;
        String calSchemeId = calScheme.getId().toString();
        Context ctx = Tools.getInstance().getCtx();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        int calTime = calScheme.getCalTime();
        String lanType = calScheme.getLanType().getValue();
        String temp = "FunGetExtremumOfItem_" + calSchemeId + periodYear + periodMonth + calTime;
        if (tempMap.containsKey(temp)) {
            return (Double)tempMap.get(temp);
        }
        String fieldSn = "";
        String sql = "select FieldSn from T_HR_SCmpItem where FName_" + lanType + " = '" + itemName + "'";
        IRowSet itemRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (null == itemRowSet || itemRowSet.size() < 1) {
            return num;
        }
        while (itemRowSet.next()) {
            fieldSn = itemRowSet.getString("FieldSn");
        }
        StringBuffer str = new StringBuffer();
        str.append("select ");
        if (0.0 == dataType) {
            str.append("min(S" + fieldSn);
        } else {
            str.append("max(S" + fieldSn);
        }
        str.append(") as extremum from T_HR_SCmpCalTable ");
        str.append("where FCalSchemeId = '" + calSchemeId);
        str.append("' and FPeriodYear = " + periodYear);
        str.append(" and FPeriodMonth = " + periodMonth);
        str.append(" and FCalTime = " + calTime);
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        if (set.next()) {
            num = set.getDouble("extremum");
            tempMap.put(temp, num);
        }
        return num;
    }

    public String getFirstWorkDayOfMonth(HashMap tempMap, CalSchemeInfo calScheme) throws Exception {
        String date;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Context ctx = Tools.getInstance().getCtx();
        HashSet<String> holidaySet = new HashSet<String>();
        String calSchemeId = calScheme.getId().toString();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String temp = "getFirstWorkDayOfMonth" + calSchemeId + periodYear + periodMonth;
        if (tempMap.containsKey(temp)) {
            return (String)tempMap.get(temp);
        }
        Calendar calendar = Calendar.getInstance();
        Calendar holidayCal = Calendar.getInstance();
        calendar.set(periodYear, periodMonth - 1, 1, 0, 0, 0);
        StringBuffer str = new StringBuffer();
        str.append(" select FStartDate, FEndDate from");
        str.append(" T_HR_ATS_LegalHolidayItem where");
        str.append(" YEAR(FStartDate) = " + periodYear);
        str.append(" and (MONTH(FStartDate) = " + periodMonth);
        str.append(" or MONTH(FStartDate) = " + (periodMonth - 1));
        str.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        while (rowSet.next()) {
            String beginDate = rowSet.getDate("FStartDate").toString();
            holidayCal.setTime(sdf.parse(beginDate));
            String endDate = rowSet.getDate("FEndDate").toString();
            while (sdf.parse(beginDate).compareTo(sdf.parse(endDate)) <= 0) {
                holidaySet.add(beginDate);
                holidayCal.add(5, 1);
                beginDate = sdf.format(holidayCal.getTime());
            }
        }
        while (true) {
            date = sdf.format(calendar.getTime());
            int weekDay = calendar.get(7);
            if (holidaySet.contains(date)) {
                calendar.add(5, 1);
                continue;
            }
            if (1 != weekDay) break;
            Calendar satCalendar = Calendar.getInstance();
            satCalendar = (Calendar)calendar.clone();
            satCalendar.add(5, -1);
            String satDate = sdf.format(satCalendar.getTime());
            if (holidaySet.contains(satDate)) break;
            calendar.add(5, 1);
        }
        tempMap.put(temp, date);
        return date;
    }

    public double getPayOfHourByAge(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, double pay, double compValue, double minVal, double maxVal) throws Exception {
        Map boolMap;
        double randomNum = 0.0;
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String temp = "FunGetPayOfHourByAge" + calScheme.getId().toString() + calScheme.getPeriodYear() + calScheme.getPeriodMonth() + calScheme.getCalTime();
        String temp1 = temp + personid + minVal + maxVal + "_randomNum";
        String temp2 = temp + "_personMap";
        if (tempMap.containsKey(temp2)) {
            boolMap = (Map)tempMap.get(temp2);
        } else {
            boolMap = this.getPayOfHourByAge(calScheme);
            tempMap.put(temp2, boolMap);
        }
        if (boolMap.containsKey(personid) && !((Boolean)boolMap.get(personid)).booleanValue()) {
            if (tempMap.containsKey(temp1)) {
                randomNum = (Double)tempMap.get(temp1);
            } else {
                randomNum = this.getRandomNumByCalScheme(calScheme, personid, minVal, maxVal);
                tempMap.put(temp1, randomNum);
            }
        }
        if (!boolMap.containsKey(personid)) {
            return pay;
        }
        if (!((Boolean)boolMap.get(personid)).booleanValue() && pay > compValue) {
            return randomNum;
        }
        return pay;
    }

    private double getRandomNumByCalScheme(CalSchemeInfo calScheme, String FPersonId, double minVal, double maxVal) throws Exception {
        double randomNum = 0.0;
        Context ctx = Tools.getInstance().getCtx();
        String calSchemeId = calScheme.getId().toString();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        int calTime = calScheme.getCalTime();
        StringBuffer str = new StringBuffer();
        str.append(" select FRoundPay from T_XHR_CmpRoundPay");
        str.append(" where FCalSchemeID = '" + calSchemeId);
        str.append("' and FPersonId = '" + FPersonId);
        str.append("' and FPeriodYear = " + periodYear);
        str.append(" and FPeriodMonth = " + periodMonth);
        str.append(" and FCalTime = " + calTime);
        str.append(" and FMinVal = " + minVal);
        str.append(" and FMaxVal = " + maxVal);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        if (null != rowSet && rowSet.size() > 0) {
            while (rowSet.next()) {
                randomNum = rowSet.getDouble("FRoundPay");
            }
        } else {
            SecureRandom random = CommonMethod.getRandom();
            randomNum = minVal + random.nextDouble() * (maxVal - minVal);
            randomNum = Double.valueOf(FunctionTools.getRound(4, randomNum));
            str = new StringBuffer();
            str.append("insert into T_XHR_CmpRoundPay(FCalSchemeID,FPersonId,FPeriodYear,FPeriodMonth,FCalTime,FRoundPay,FMinVal,FMaxVal) ");
            str.append("values('" + calSchemeId + "'");
            str.append(",'" + FPersonId + "'");
            str.append("," + periodYear);
            str.append("," + periodMonth);
            str.append("," + calTime);
            str.append("," + randomNum);
            str.append("," + minVal);
            str.append("," + maxVal);
            str.append(")");
            DbUtil.execute((Context)ctx, (String)str.toString());
        }
        return randomNum;
    }

    private Map<String, Boolean> getPayOfHourByAge(CalSchemeInfo calScheme) throws Exception {
        int standMonth = 216;
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(calScheme.getBeginDate());
        int year = calendar1.get(1);
        int month = calendar1.get(2);
        int day = calendar1.get(5);
        Calendar calendar = Calendar.getInstance();
        HashMap<String, Boolean> boolMap = new HashMap<String, Boolean>();
        StringBuffer str = new StringBuffer();
        str.append("select FPersonId from T_HR_SCmpCalTable where FCalSchemeId = '" + calScheme.getId().toString());
        str.append("' and FPeriodYear = " + calScheme.getPeriodYear());
        str.append(" and FPeriodMonth = " + calScheme.getPeriodMonth());
        str.append(" and FCalTime = " + calScheme.getCalTime());
        Context ctx = Tools.getInstance().getCtx();
        PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select birthday, id where id in (" + str.toString() + ")");
        int size = personCollection.size();
        for (int i = 0; i < size; ++i) {
            int perMonth;
            PersonInfo personInfo = personCollection.get(i);
            java.util.Date birthday = personInfo.getBirthday();
            if (null == birthday) {
                perMonth = 0;
            } else {
                calendar.setTime(birthday);
                perMonth = (year - calendar.get(1)) * 12 + (month - calendar.get(2));
            }
            if (perMonth > standMonth) {
                boolMap.put(personInfo.getId().toString(), true);
                continue;
            }
            if (perMonth == standMonth && day >= calendar.get(5)) {
                boolMap.put(personInfo.getId().toString(), true);
                continue;
            }
            boolMap.put(personInfo.getId().toString(), false);
        }
        return boolMap;
    }

    public double getHolidaysByEnterDate(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme) throws Exception {
        double holidays = 0.0;
        Map<String, Double> personMap = new HashMap();
        Calendar holidayCal = Calendar.getInstance();
        Calendar holidayEnd = Calendar.getInstance();
        ArrayList<java.util.Date> holidayList = new ArrayList<java.util.Date>();
        String calSchemeId = calScheme.getId().toString();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        int calTime = calScheme.getCalTime();
        Context ctx = Tools.getInstance().getCtx();
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String temp = "FunGetHolidaysByEnterDate" + calSchemeId + periodYear + periodMonth + calTime;
        if (tempMap.containsKey(temp)) {
            personMap = (Map)tempMap.get(temp);
            holidays = personMap.get(personid) == null ? 0.0 : (Double)personMap.get(personid);
        } else {
            StringBuffer str = new StringBuffer();
            str.append(" select FStartDate, FEndDate from");
            str.append(" T_HR_ATS_LegalHolidayItem where");
            str.append(" YEAR(FStartDate) = " + periodYear);
            str.append(" and MONTH(FStartDate) = " + periodMonth);
            str.append(" order by FStartDate");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    Date beginDate = rowSet.getDate("FStartDate");
                    Date endDate = rowSet.getDate("FEndDate");
                    holidayCal.setTime(beginDate);
                    holidayCal.set(10, 0);
                    holidayCal.set(12, 0);
                    holidayCal.set(13, 0);
                    holidayEnd.setTime(endDate);
                    holidayEnd.set(10, 0);
                    holidayEnd.set(12, 0);
                    holidayEnd.set(13, 0);
                    while (holidayCal.getTime().compareTo(holidayEnd.getTime()) <= 0) {
                        holidayList.add(holidayCal.getTime());
                        holidayCal.add(5, 1);
                    }
                }
                str = new StringBuffer();
                str.append("select FPersonId from T_HR_SCmpCalTable where FCalSchemeId = '" + calScheme.getId().toString());
                str.append("' and FPeriodYear = " + calScheme.getPeriodYear());
                str.append(" and FPeriodMonth = " + calScheme.getPeriodMonth());
                str.append(" and FCalTime = " + calScheme.getCalTime());
                PersonPositionCollection personPositionCollection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection("select person.id, enterDate, leftDate where person.id in (" + str.toString() + ")");
                int size = personPositionCollection.size();
                for (int i = 0; i < size; ++i) {
                    double count = 0.0;
                    PersonPositionInfo personPositionInfo = personPositionCollection.get(i);
                    java.util.Date enterDate = personPositionInfo.getEnterDate();
                    java.util.Date leftDate = personPositionInfo.getLeftDate();
                    String perosnId = personPositionInfo.getPerson().getId().toString();
                    int size1 = holidayList.size();
                    for (int j = 0; j < size1; ++j) {
                        if (null == leftDate) {
                            if (!enterDate.before((java.util.Date)holidayList.get(j))) continue;
                            count += 1.0;
                            continue;
                        }
                        if (enterDate.after(leftDate) && enterDate.before((java.util.Date)holidayList.get(j))) {
                            count += 1.0;
                        }
                        if (!enterDate.before(leftDate) || !enterDate.before((java.util.Date)holidayList.get(j)) || !leftDate.after((java.util.Date)holidayList.get(j))) continue;
                        count += 1.0;
                    }
                    personMap.put(perosnId, count);
                }
                tempMap.put(temp, personMap);
                holidays = personMap.get(personid) == null ? 0.0 : (Double)personMap.get(personid);
            } else {
                tempMap.put(temp, personMap);
                return holidays;
            }
        }
        return holidays;
    }
}

