/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.app.tax.TaxConfigCollection;
import com.kingdee.shr.compensation.app.tax.TaxConfigFactory;
import com.kingdee.shr.compensation.app.tax.TaxPersonBaseCollection;
import com.kingdee.shr.compensation.app.tax.TaxPersonBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxPersonBaseInfo;
import com.kingdee.shr.compensation.tax.TaxBizException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class TaxUtil {
    public static final String CODE_KEY = "code";
    public static final String MSG_KEY = "msg";
    public static final String DATA_KEY = "data";
    public static final String HOUSING_ENTITY_NAME = "com.kingdee.shr.compensation.app.tax.Housing";
    public static final String TENEMENT_ENTITY_NAME = "com.kingdee.shr.compensation.app.tax.Tenement";
    public static final String EDUCATION_ENTITY_NAME = "com.kingdee.shr.compensation.app.tax.Education";
    public static final String ADULT_ENTITY_NAME = "com.kingdee.shr.compensation.app.tax.AdultEdu";
    public static final String SUPPORT_ENTITY_NAME = "com.kingdee.shr.compensation.app.tax.Support";
    public static final String SUPPORT_ENTRY_ENTITY_NAME = "com.kingdee.shr.compensation.app.tax.SupportEntry";
    public static final String TAX_PERSON_BASE = "com.kingdee.shr.compensation.app.tax.TaxPersonBase";

    public static String success(Context ctx, Object data) {
        if (null == data || "".equals(data)) {
            data = new HashMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CODE_KEY, 2000);
        map.put(MSG_KEY, "success");
        map.put(DATA_KEY, data);
        return JSONUtils.convertObjectToJson((Context)ctx, map);
    }

    public static String error(Context ctx, Integer code, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CODE_KEY, code);
        map.put(MSG_KEY, msg);
        map.put(DATA_KEY, "");
        return JSONUtils.convertObjectToJson((Context)ctx, map);
    }

    public static String getMapString(Map<String, Object> map, String key) {
        return null == map.get(key) ? null : map.get(key).toString();
    }

    public static boolean getMapBoolean(Map<String, Object> map, String key) {
        int value = TaxUtil.getMapInt(map, key);
        return value > 0;
    }

    public static int getMapInt(Map<String, Object> map, String key) {
        if (null == map.get(key)) {
            return 0;
        }
        String value = map.get(key).toString();
        if (value.contains(".")) {
            value = value.substring(0, value.indexOf("."));
        }
        return Integer.valueOf(value);
    }

    public static boolean isValid(TaxBizException e) {
        return null == e;
    }

    public static Map<String, Object> getMapDataFromCoreInfo(Context ctx, CoreBaseInfo info, String entityName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> objMap = null;
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection properties = entityInfo.getPropertiesRuntime();
        block0: for (int k = 0; k < properties.size(); ++k) {
            PropertyInfo propertyInfo = properties.get(k);
            IStateManager stateManager = propertyInfo.getStateManager();
            if (null != stateManager.getStateValue("relationship")) {
                objMap = new HashMap<String, Object>();
                if (!(info.get(propertyInfo.getName()) instanceof DataBaseInfo)) continue;
                DataBaseInfo dataBaseInfo = (DataBaseInfo)info.get(propertyInfo.getName());
                objMap.put("value", dataBaseInfo.getId().toString());
                objMap.put("text", dataBaseInfo.getName());
                map.put(propertyInfo.getName(), objMap);
                continue;
            }
            if (null == stateManager.getStateValue("dataType")) continue;
            String dataType = stateManager.getStateValue("dataType").toString();
            if ("Enum".equalsIgnoreCase(dataType)) {
                if (null == info.get(propertyInfo.getName()) || 0 == Integer.valueOf(info.get(propertyInfo.getName()).toString())) {
                    map.put(propertyInfo.getName(), null);
                    continue;
                }
                int enumValue = info.getInt(propertyInfo.getName());
                String dataRef = stateManager.getStateValue("metadataRef").toString();
                BizEnumInfo enumInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)dataRef));
                BizEnumValueCollection enumValueColl = enumInfo.getEnumValue();
                for (int j = 0; j < enumValueColl.size(); ++j) {
                    BizEnumValueInfo bizEnumValueInfo = enumValueColl.get(j);
                    if (enumValue != bizEnumValueInfo.getInt()) continue;
                    objMap = new HashMap();
                    objMap.put("value", bizEnumValueInfo.getValue());
                    objMap.put("text", bizEnumValueInfo.getAlias());
                    map.put(propertyInfo.getName(), objMap);
                    continue block0;
                }
                continue;
            }
            if ("Date".equalsIgnoreCase(dataType)) {
                map.put(propertyInfo.getName(), null == info.get(propertyInfo.getName()) ? "" : info.get(propertyInfo.getName()).toString());
                continue;
            }
            if ("boolean".equalsIgnoreCase(dataType)) {
                map.put(propertyInfo.getName(), null == info.get(propertyInfo.getName()) ? 0 : ("true".equals(info.get(propertyInfo.getName()).toString()) ? 1 : 0));
                continue;
            }
            map.put(propertyInfo.getName(), info.get(propertyInfo.getName()));
        }
        return map;
    }

    public static CoreBaseInfo convertMapToInfo(Context ctx, Map<String, Object> map, String entityName, Class<?> class1) throws Exception {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)class1.newInstance();
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection properties = entityInfo.getPropertiesRuntime();
        for (int k = 0; k < properties.size(); ++k) {
            IStateManager stateManager;
            PropertyInfo propertyInfo = properties.get(k);
            String proName = propertyInfo.getName();
            if (!map.containsKey(proName) || null != (stateManager = propertyInfo.getStateManager()).getStateValue("relationship") || null == stateManager.getStateValue("dataType")) continue;
            String dataType = stateManager.getStateValue("dataType").toString();
            if ("Enum".equalsIgnoreCase(dataType)) {
                if (null == map.get(propertyInfo.getName())) continue;
                int enumValue = TaxUtil.getMapInt(map, propertyInfo.getName());
                String dataRef = stateManager.getStateValue("metadataRef").toString();
                Class<?> enumClass = Class.forName(dataRef);
                Method method = enumClass.getMethod("getEnum", Integer.TYPE);
                Object enumInfo = method.invoke(null, enumValue);
                coreBaseInfo.put(proName, enumInfo);
                continue;
            }
            if (null == map.get(proName) || "".equals(map.get(proName))) continue;
            coreBaseInfo.put(proName, map.get(propertyInfo.getName()));
        }
        return coreBaseInfo;
    }

    public static String getValidDateSql(int year, int month) {
        StringBuilder str = new StringBuilder();
        str.append(" where dataState = 1 ");
        str.append(" and (effdtYear = ").append(year).append(" and effdtMonth <= ").append(month);
        str.append(" or effdtYear < ").append(year).append(") ");
        str.append(" and (leffdtYear = ").append(year).append(" and leffdtMonth >= ").append(month);
        str.append(" or leffdtYear > ").append(year).append(")");
        return str.toString();
    }

    public static PersonInfo getPersonInfo(Context ctx) throws Exception {
        PersonInfo person;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (null == userInfo) {
            String userId = (String)ctx.get((Object)"userID");
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)));
        }
        if ((person = userInfo.getPerson()) == null) {
            return null;
        }
        return person;
    }

    public static String getPersonId(Context ctx) throws Exception {
        PersonInfo info = TaxUtil.getPersonInfo(ctx);
        return null == info ? null : info.getId().toString();
    }

    public static TaxPersonBaseInfo getTaxPersonBaseByPersonId(Context ctx, String personId) throws Exception {
        TaxPersonBaseCollection coll = TaxPersonBaseFactory.getLocalInstance(ctx).getTaxPersonBaseCollection(" where person.id = '" + personId + "' ");
        if (null == coll || coll.size() < 1) {
            return new TaxPersonBaseInfo();
        }
        return coll.get(0);
    }

    public static int getEffdtMonth(Context ctx) throws BOSException {
        TaxConfigCollection configColl = TaxConfigFactory.getLocalInstance(ctx).getTaxConfigCollection();
        int addMonth = 0;
        int effdtEnumValue = configColl.get(0).getEffdtMonth().getValue();
        switch (effdtEnumValue) {
            case 10: {
                addMonth = -1;
                break;
            }
            case 20: {
                addMonth = 0;
                break;
            }
            case 30: {
                addMonth = 1;
            }
        }
        return addMonth;
    }

    public static String getTableByTaxType(int type) {
        String table = "";
        switch (type) {
            case 10: {
                table = "T_HR_SHousing";
                break;
            }
            case 20: {
                table = "T_HR_STenement";
                break;
            }
            case 30: {
                table = "T_HR_SEducation";
                break;
            }
            case 40: {
                table = "T_HR_SAdultEdu";
                break;
            }
            case 50: {
                table = "T_HR_SSupport";
            }
        }
        return table;
    }
}

