/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.pdf;

import com.kingdee.shr.compensation.util.pdf.TextStyle;
import com.kingdee.util.StringUtils;
import com.lowagie.text.Font;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StyleExtractor {
    public static final String styleReg = "style=\"([\\s\\S]*?)\"";
    public static final Pattern stylePattern = Pattern.compile("style=\"([\\s\\S]*?)\"");
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final Map<String, Color> COLOR_MAP = new HashMap<String, Color>();

    public TextStyle extractStyles(String tagStart) {
        TextStyle textStyle = new TextStyle();
        Matcher styleMatcher = stylePattern.matcher(tagStart);
        if (styleMatcher.find()) {
            String[] styles;
            String styleAttr = styleMatcher.group();
            String styleContent = styleAttr.split("=")[1].replaceAll("\"", "");
            for (String style : styles = styleContent.split(";")) {
                if (!style.contains(":")) continue;
                String[] entry = style.split(":");
                String key = entry[0].trim();
                String value = entry[1].trim();
                if ("text-align".equalsIgnoreCase(key)) {
                    textStyle.setTextAlign(value);
                    continue;
                }
                if ("line-height".equalsIgnoreCase(key)) {
                    if (value.contains("em")) {
                        textStyle.setLineHeight(Float.parseFloat(value.replace("em", "")));
                        continue;
                    }
                    if (value.contains("px")) {
                        float px = Float.parseFloat(value.replace("px", ""));
                        textStyle.setLineHeightPt(px * this.getRatioBetweenPtAndPx());
                        continue;
                    }
                    if (value.contains("pt")) {
                        float pt = Float.parseFloat(value.replace("pt", ""));
                        textStyle.setLineHeightPt(pt);
                        continue;
                    }
                    textStyle.setLineHeight(Float.parseFloat(value));
                    continue;
                }
                if ("font-family".equalsIgnoreCase(key)) {
                    textStyle.setFontFamily(value.split(",")[0].trim());
                    continue;
                }
                if ("font-size".equalsIgnoreCase(key)) {
                    textStyle.setFontSize(Float.parseFloat(value.replace("px", "").replace("pt", "")));
                    continue;
                }
                if ("color".equalsIgnoreCase(key)) {
                    if (value.contains("rgb")) {
                        String[] arr = StyleExtractor.getRGBArr(value);
                        textStyle.setR(Integer.parseInt(arr[0].trim()));
                        textStyle.setG(Integer.parseInt(arr[1].trim()));
                        textStyle.setB(Integer.parseInt(arr[2].trim()));
                        continue;
                    }
                    textStyle.setColor(value);
                    continue;
                }
                if ("text-decoration".equalsIgnoreCase(key)) {
                    if ("underline".equalsIgnoreCase(value)) {
                        textStyle.setUnderline(true);
                        continue;
                    }
                    if (!"line-through".equalsIgnoreCase(value)) continue;
                    textStyle.setLineThrough(true);
                    continue;
                }
                if ("text-indent".equalsIgnoreCase(key)) {
                    if (value.contains("pt")) {
                        textStyle.setTextIndent(Float.parseFloat(value.replace("pt", "")));
                        continue;
                    }
                    if (!value.contains("px")) continue;
                    float px = Float.parseFloat(value.replace("px", ""));
                    float pt = px * this.getRatioBetweenPtAndPx();
                    textStyle.setTextIndent(pt);
                    continue;
                }
                if ("text-decoration-line".equalsIgnoreCase(key)) {
                    if ("underline".equalsIgnoreCase(value)) {
                        textStyle.setUnderline(true);
                        continue;
                    }
                    if (!"line-through".equalsIgnoreCase(value)) continue;
                    textStyle.setLineThrough(true);
                    continue;
                }
                if (!"background-color".equalsIgnoreCase(key) || !value.contains("rgb")) continue;
                if (value.contains("rgb")) {
                    String[] arr = StyleExtractor.getRGBArr(value);
                    textStyle.setR1(Integer.parseInt(arr[0].trim()));
                    textStyle.setG1(Integer.parseInt(arr[1].trim()));
                    textStyle.setB1(Integer.parseInt(arr[2].trim()));
                    continue;
                }
                textStyle.setBackgroundColor(value);
            }
        }
        if (tagStart.contains("<em")) {
            textStyle.setItalic(true);
        } else if (tagStart.contains("<strong")) {
            textStyle.setBold(true);
        } else if (tagStart.contains("<u>")) {
            textStyle.setUnderline(true);
        }
        return textStyle;
    }

    public float getRatioBetweenPtAndPx() {
        return 0.5f;
    }

    public static String[] getRGBArr(String value) {
        int start = value.indexOf("(");
        int end = value.indexOf(")");
        String rgbValue = value.substring(start + 1, end);
        return rgbValue.split(",");
    }

    public String rgb2Hex(int r, int g, int b) {
        return String.format("%02X%02X%02X", r, g, b);
    }

    public void mergerStyle(TextStyle outer, TextStyle inner) {
        if (null == outer || null == inner) {
            return;
        }
        if (null == inner.getFontFamily()) {
            inner.setFontFamily(outer.getFontFamily());
        }
        if (inner.getFontSize() < 0.0f) {
            inner.setFontSize(outer.getFontSize());
        }
        if (!inner.isBold()) {
            inner.setBold(outer.isBold());
        }
        if (!inner.isLineThrough()) {
            inner.setLineThrough(outer.isLineThrough());
        }
        if (!inner.isItalic()) {
            inner.setItalic(outer.isItalic());
        }
        if (!inner.isUnderline()) {
            inner.setUnderline(outer.isUnderline());
        }
        if (inner.getColor() == null) {
            inner.setColor(outer.getColor());
        }
        if (null == inner.getTextAlign()) {
            inner.setTextAlign(outer.getTextAlign());
        }
        if (inner.getTextIndent() < 0.0f) {
            inner.setTextIndent(outer.getTextIndent());
        }
        if (inner.getR() < 0) {
            inner.setR(outer.getR());
            inner.setG(outer.getG());
            inner.setB(outer.getB());
        }
        if (inner.getR1() < 0) {
            inner.setR1(outer.getR1());
            inner.setG1(outer.getG1());
            inner.setB1(outer.getB1());
        }
    }

    public void setFontStyle(TextStyle textStyle, Font font) {
        if (textStyle.isBold() && textStyle.isItalic()) {
            font.setStyle(3);
        } else if (textStyle.isBold()) {
            font.setStyle(1);
        } else if (textStyle.isItalic()) {
            font.setStyle(2);
        }
        if (textStyle.getR() >= 0) {
            font.setColor(textStyle.getR(), textStyle.getG(), textStyle.getB());
        } else if (!StringUtils.isEmpty((String)textStyle.getColor())) {
            font.setColor(COLOR_MAP.get(textStyle.getColor()));
        }
        if (textStyle.getFontSize() > 0.0f) {
            font.setSize(textStyle.getFontSize());
        } else {
            font.setSize(12.0f);
        }
    }

    public static int[] hex2RGB(String hexStr) {
        if (hexStr != null && hexStr.startsWith("#")) {
            int[] rgb = new int[]{Integer.valueOf(hexStr.substring(1, 3), 16), Integer.valueOf(hexStr.substring(3, 5), 16), Integer.valueOf(hexStr.substring(5, 7), 16)};
            return rgb;
        }
        return null;
    }

    static {
        COLOR_MAP.put("red", Color.RED);
        COLOR_MAP.put("green", Color.GREEN);
        COLOR_MAP.put("blue", Color.BLUE);
        COLOR_MAP.put("white", Color.WHITE);
        COLOR_MAP.put("orange", Color.ORANGE);
        COLOR_MAP.put("yellow", Color.YELLOW);
        COLOR_MAP.put("gray", Color.GRAY);
        COLOR_MAP.put("pink", Color.PINK);
    }
}

