/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CmpItemCommonException;
import com.kingdee.shr.compensation.CmpItemDataPermFactory;
import com.kingdee.shr.compensation.CmpItemDataPermInfo;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.CmpSalaryDataPermFactory;
import com.kingdee.shr.compensation.CmpSalaryDataPermInfo;
import com.kingdee.shr.compensation.app.AbstractCmpItemDataPermFacadeControllerBean;
import com.kingdee.shr.compensation.exception.CmpItemDataPermFacadeException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class CmpItemDataPermFacadeControllerBean
extends AbstractCmpItemDataPermFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpItemDataPermFacadeControllerBean");

    @Override
    protected void _saveCmpItemPermRange(Context ctx, String personIds, String cmpItemDes, String hrOrgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIds)) {
            throw new BOSException(new CmpItemDataPermFacadeException(CmpItemDataPermFacadeException.NOCHOOSE).getMessage());
        }
        try {
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            hrOrgUnitInfo.setId(BOSUuid.read((String)hrOrgId));
            String[] persons = personIds.split(",");
            CoreBaseCollection coll = new CoreBaseCollection();
            CoreBaseCollection salaryPermColl = new CoreBaseCollection();
            for (int k = 0; k < persons.length; ++k) {
                String personid = persons[k].trim();
                if (StringUtils.isEmpty((String)personid)) continue;
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personid));
                CmpItemDataPermFactory.getLocalInstance(ctx).delete(" where person.id='" + personid + "' and hrOrgUnit.id='" + hrOrgId + "' ");
                CmpItemDataPermInfo item = null;
                JSONArray items = new JSONArray(cmpItemDes);
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject t = items.getJSONObject(i);
                    String itemId = t.getString("itemId");
                    String isEdit = t.getString("isEdit");
                    item = new CmpItemDataPermInfo();
                    CmpItemInfo cmpItem = CmpItemFactory.getLocalInstance(ctx).getCmpItemInfo((IObjectPK)new ObjectUuidPK(itemId));
                    item.setPerson(personInfo);
                    item.setCmpItem(cmpItem);
                    item.setHrOrgUnit(hrOrgUnitInfo);
                    if ("true".equals(isEdit)) {
                        item.setIsEdit(1);
                    } else {
                        item.setIsEdit(0);
                    }
                    coll.add((CoreBaseInfo)item);
                }
                boolean bExist = CmpSalaryDataPermFactory.getLocalInstance(ctx).exists("where person.id='" + personid + "' and hrOrgUnit.id='" + hrOrgId + "' ");
                CmpSalaryDataPermInfo cmpSalaryPermInfo = null;
                if (bExist) {
                    cmpSalaryPermInfo = CmpSalaryDataPermFactory.getLocalInstance(ctx).getCmpSalaryDataPermInfo("where person.id='" + personid + "' and hrOrgUnit.id='" + hrOrgId + "' ");
                } else {
                    cmpSalaryPermInfo = new CmpSalaryDataPermInfo();
                    cmpSalaryPermInfo.setPerson(personInfo);
                    cmpSalaryPermInfo.setHrOrgUnit(hrOrgUnitInfo);
                }
                cmpSalaryPermInfo.setIsCmpItemPerm(true);
                salaryPermColl.add((CoreBaseInfo)cmpSalaryPermInfo);
                CmpItemDataPermFactory.getLocalInstance(ctx).saveBatchData(coll);
                this.clearUpDynamicListSetting(ctx, personid, coll);
                coll.clear();
            }
            CmpSalaryDataPermFactory.getLocalInstance(ctx).saveBatchData(salaryPermColl);
            salaryPermColl.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CmpItemCommonException(CmpItemCommonException.SAVE_DATAPERM_ERROR);
        }
    }

    private void clearUpDynamicListSetting(Context ctx, String personId, CoreBaseCollection coll) throws BOSException, EASBizException {
        if (coll.size() < 1) {
            return;
        }
        HashSet<String> itemWithPerm = new HashSet<String>();
        for (CmpItemDataPermInfo cmpItemDataPermInfo : coll) {
            itemWithPerm.add(cmpItemDataPermInfo.getCmpItem().getName());
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select setting.fid, fconfig");
        sql.append(" from t_bd_dynamiclistsetting setting");
        sql.append(" inner join s_bs_uiview ui");
        sql.append(" on setting.fuiviewid = ui.fid");
        sql.append(" where setting.fownerid in(select fid from t_pm_user where fpersonid ='" + personId + "')");
        sql.append(" and setting.ftype = 2");
        sql.append(" and ui.ftype = 'dynamicList'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                Object[] param = new Object[2];
                boolean isNeedUpdate = false;
                String id = (String)rowSet.getObject("fid");
                HashMap config = JSONUtils.convertJsonToObject((Context)ctx, (String)rowSet.getObject("fconfig").toString());
                List columnsList = (List)config.get("columns");
                for (int j = 0; j < columnsList.size(); ++j) {
                    String itemName;
                    Map column = (Map)columnsList.get(j);
                    String field = (String)column.get("name");
                    if (field.indexOf(".") == -1 || !field.split("\\.")[1].matches("s\\d{1,}") || itemWithPerm.contains(itemName = (String)column.get("label"))) continue;
                    columnsList.remove(j);
                    isNeedUpdate = true;
                    --j;
                }
                if (!isNeedUpdate) continue;
                config.put("columns", columnsList);
                param[0] = JSONUtils.convertObjectToJson((Context)ctx, (Object)config);
                param[1] = id;
                paramsList.add(param);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update t_bd_dynamiclistsetting");
        updateSql.append(" set fconfig = ?");
        updateSql.append(" where fid = ?");
        DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
    }

    @Override
    protected List _getAssignedItem(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList<Map<Object, Object>> result = new ArrayList<Map<Object, Object>>();
        String personId = (String)param.get("personId");
        String hrOrgId = (String)param.get("hrOrgId");
        String personIds = "('" + personId.replace(",", "','") + "')";
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        StringBuilder sb = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sb.append(" select perm.fid id, FIsEdit isEdit, item.fnumber number, item.fname_" + l + " itemName, perm.fcmpitemid from T_HR_SCmpItemDataPerm perm ");
        sb.append(" left join t_hr_scmpitem item on perm.fcmpitemid = item.fid ");
        sb.append("  inner join T_HR_SCmpItemCatalog itemCatalog on item.fcmpitemcatalogid = itemCatalog.fid ");
        sb.append(" where perm.FHrOrgUnitId='" + hrOrgId + "' and perm.fpersonid in " + personIds);
        sb.append(" order by itemCatalog.fnumber, item.findex, item.fnumber ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Map<String, Object> editSameMap = this.isEditSame(ctx, personIds);
        int count = 0;
        LinkedHashMap map = new LinkedHashMap();
        ArrayList<Object> list = null;
        try {
            while (rs.next()) {
                String id = rs.getString("id");
                boolean isEdit = rs.getBoolean("isEdit");
                String number = rs.getString("number");
                String cmpItemId = rs.getString("fcmpitemid");
                String itemName = rs.getString("itemName");
                list = new ArrayList<Object>();
                list.add(isEdit);
                list.add(cmpItemId);
                list.add(number);
                list.add(itemName);
                map.put(id, list);
                if (countMap.get(cmpItemId) == null) {
                    count = 1;
                } else {
                    count = (Integer)countMap.get(cmpItemId);
                    ++count;
                }
                countMap.put(cmpItemId, count);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new CmpItemCommonException(CmpItemCommonException.ASSIGNED_ITEM_ERROR);
        }
        result.add(map);
        result.add(countMap);
        result.add(editSameMap);
        return result;
    }

    private Map<String, Object> isEditSame(Context ctx, String personIds) throws BOSException, CmpItemCommonException {
        HashMap<String, Object> editMap = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        sb.append(" select fcmpitemid, count(distinct fisedit) num from T_HR_SCmpItemDataPerm ");
        sb.append(" where fpersonid in " + personIds);
        sb.append(" group by fcmpitemid ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String cmpItemId = rs.getString("fcmpitemid");
                int num = rs.getInt("num");
                editMap.put(cmpItemId, num == 1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new CmpItemCommonException(CmpItemCommonException.ASSIGNED_ITEM_ERROR);
        }
        return editMap;
    }
}

