/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpSummarySendMessageFacadeControllerBean;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class HRCmpSummarySendMessageFacadeControllerBean
extends AbstractHRCmpSummarySendMessageFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpSummarySendMessageFacadeControllerBean");

    @Override
    protected Map _getCmpReportSummaryMsg(Context ctx, String userId) throws BOSException, EASBizException {
        Map<String, Object> map = this.generateCmpReportSummaryMsg(ctx, userId);
        return map;
    }

    private Map<String, Object> generateCmpReportSummaryMsg(Context ctx, String userId) {
        HashMap<String, Object> msgData = new HashMap<String, Object>();
        HashMap<String, HashMap<String, Object>> resultMap = new HashMap<String, HashMap<String, Object>>();
        int year = HRCmpReportUtil.getCurrYear();
        int month = HRCmpReportUtil.getCurrMonth() - 1;
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, null);
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            String[] userIdItems = userId.split(",");
            for (int i = 0; i < userIdItems.length; ++i) {
                String uId = userIdItems[i];
                HashMap<String, Object> data = new HashMap<String, Object>();
                this.handleMsgData(ctx, cmpItems, uId, data, year, month);
                resultMap.put(uId, data);
            }
        }
        msgData.put("resultMap", resultMap);
        return msgData;
    }

    private void handleMsgData(Context ctx, String cmpItems, String uId, Map<String, Object> data, int year, int month) {
        this.handleSalaryTotal(ctx, cmpItems, uId, data, year, month);
        this.handlePersonCount(ctx, cmpItems, uId, data, year, month);
    }

    private void handleSalaryTotal(Context ctx, String cmpItems, String uId, Map<String, Object> data, int year, int month) {
        double currTotal = 0.0;
        double lastTotal = 0.0;
        String discrepancyRate = "0%";
        data.put("currTotal", currTotal);
        data.put("lastTotal", lastTotal);
        data.put("discrepancyRate", discrepancyRate);
        try {
            String sendMsgLaborInfoSql = HRCmpReportUtil.sendMsgLaborInfoSql(ctx, cmpItems, uId, year, month);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sendMsgLaborInfoSql);
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("periodYear");
                int rsMonth = rowSet.getInt("periodMonth");
                double total = rowSet.getDouble("total");
                if (rsYear == year && rsMonth == month) {
                    currTotal = total;
                    data.put("currTotal", currTotal);
                    continue;
                }
                if (rsYear != year - 1 || rsMonth != month) continue;
                lastTotal = total;
                data.put("lastTotal", lastTotal);
                break;
            }
            discrepancyRate = lastTotal == 0.0 && currTotal != 0.0 ? "100%" : (lastTotal == 0.0 && currTotal == 0.0 ? "0%" : HRCmpReportUtil.formatDouble((currTotal - lastTotal) / lastTotal) + "%");
            data.put("discrepancyRate", discrepancyRate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handlePersonCount(Context ctx, String cmpItems, String uId, Map<String, Object> data, int year, int month) {
        double currPersonCount = 0.0;
        double lastPersonCount = 0.0;
        data.put("currPersonCount", currPersonCount);
        data.put("lastPersonCount", lastPersonCount);
        try {
            String sendMsgLaborInfoSql = HRCmpReportUtil.sendMsgPersonInfoSql(ctx, cmpItems, uId, year, month);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sendMsgLaborInfoSql);
            while (rowSet.next()) {
                int rsYear = rowSet.getInt("periodYear");
                int rsMonth = rowSet.getInt("periodMonth");
                double personCount = rowSet.getDouble("personCount");
                if (rsYear == year && rsMonth == month) {
                    currPersonCount = personCount;
                    data.put("currPersonCount", currPersonCount);
                    continue;
                }
                if (rsYear != year - 1 || rsMonth != month) continue;
                lastPersonCount = personCount;
                data.put("lastPersonCount", lastPersonCount);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

