/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.TaxDeclareStatusEnum;
import com.kingdee.shr.compensation.TbTypeEnum;
import com.kingdee.shr.compensation.app.AbstractIncomeTaxDeclareFacadeControllerBean;
import com.kingdee.shr.compensation.app.entity.taxdeclar.TaxDeclarParamDTO;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarCollection;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitCollection;
import com.kingdee.shr.compensation.app.tax.TaxUnitFactory;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.ITaxServiceTaskFacade;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.taxCal.util.TaxCalcFileUtils;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SHRStringUtil;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class IncomeTaxDeclareFacadeControllerBean
extends AbstractIncomeTaxDeclareFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.IncomeTaxDeclareFacadeControllerBean");
    private static final List<String> TAX_DECLARE_RECORD_COLUMNS = Lists.newArrayList((Object[])new String[]{"fid", "FDeclareStatus", "FPersonID", "FTaxUnitID", "FPeriodBegin", "FPeriodEnd", "FIncomeItemId", "FPeriodYear", "FPeriodMonth", "FIdType", "FIdNO", "FTaxPayerNum", "FIsPersonal", "FProceedItem", "FItemDefine", "FCREATETIME", "FLASTUPDATETIME", "FCREATORID ", "FLASTUPDATEUSERID"});

    private Map<String, Object> checkISHasData(Context ctx, String yearMonth, String taxUnitInSql) throws BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean hasData = false;
        HashSet<String> existDataTaxUnitIdSet = new HashSet<String>();
        String sqlBuffer = " SELECT distinct FTAXUNITID  FROM T_HR_STAXCALCONFIGDETAIL  WHERE FtaxUnitId in " + taxUnitInSql + " AND FSTATE=" + 20 + " AND " + CmpSQLUtil.generateSqlDateFilter("FPeriodBegin", "FPeriodEnd", yearMonth);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer);
        try {
            while (rowSet.next()) {
                String taxUnitId = rowSet.getString("FTAXUNITID");
                if (!SHRStringUtil.isNotBlank(taxUnitId)) continue;
                existDataTaxUnitIdSet.add(taxUnitId);
                hasData = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        resultMap.put("hasData", hasData);
        resultMap.put("existDataTaxUnitIdSet", existDataTaxUnitIdSet);
        return resultMap;
    }

    @Override
    protected Map _generateTaxDeclareData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String taxUnitIdInData;
        Map failInfoMap;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean isAllFail = false;
        StringBuilder taxNameTypeBuffer = new StringBuilder();
        String taxUnitIds = (String)paramMap.get("taxUnitIds");
        String yearMonth = (String)paramMap.get("yearMonth");
        String[] dateArr = yearMonth.split("-");
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(dateArr[0]), Integer.parseInt(dateArr[1]) - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        String taxUnitIdInSql = CmpStrUtil.buildInSql(taxUnitIds);
        HashSet<String> fullTaxUnitIdSet = new HashSet<String>();
        String[] taxUnitIdArr = taxUnitIds.split(",");
        HashSet<String> taxUnitIdSetForCheck = new HashSet<String>();
        for (String s : taxUnitIdArr) {
            for (int j = 1; j <= 3; ++j) {
                fullTaxUnitIdSet.add(s + "_" + j);
            }
            taxUnitIdSetForCheck.add(s);
        }
        String taxDeclareOql = this.getIncomeTaxDeclarCollecOql(yearMonth, taxUnitIdInSql);
        IncomeTaxDeclarCollection collection = IncomeTaxDeclarFactory.getLocalInstance(ctx).getIncomeTaxDeclarCollection(taxDeclareOql);
        Map<String, Object> handleDataMap = this.handleCollectionData(collection);
        int oldSize = taxUnitIdSetForCheck.size();
        if (oldSize * 2 == (failInfoMap = (Map)handleDataMap.get("failInfoMap")).size()) {
            isAllFail = true;
        }
        this.generateTaxNameType(taxNameTypeBuffer, failInfoMap);
        Map<String, Object> checkISHasDataMap = this.checkISHasData(ctx, yearMonth, taxUnitIdInSql);
        Boolean hasDataGenerate = (Boolean)checkISHasDataMap.get("hasData");
        Set existDataTaxUnitIdSet = (Set)checkISHasDataMap.get("existDataTaxUnitIdSet");
        taxUnitIdSetForCheck.removeAll(existDataTaxUnitIdSet);
        int noDataTaxUnitCount = taxUnitIdSetForCheck.size();
        Set taxFailIdSet = (Set)handleDataMap.get("taxFailIdSet");
        int failTaxUnitCount = taxFailIdSet.size();
        Set existSet = (Set)handleDataMap.get("existSet");
        Map needToUpdate = (Map)handleDataMap.get("needToUpdate");
        Set ykyjUpdateTaxIdSet = (Set)handleDataMap.get("ykyjUpdateTaxIdSet");
        Set fjmsdUpdateTaxIdSet = (Set)handleDataMap.get("fjmsdUpdateTaxIdSet");
        fullTaxUnitIdSet.removeAll(existSet);
        HashSet<String> ykyjNewTaxIdSet = new HashSet<String>();
        HashSet<String> fjmsdNewTaxIdSet = new HashSet<String>();
        HashSet<String> allTaxUnitSet = new HashSet<String>();
        if (fullTaxUnitIdSet.size() > 0) {
            for (String taxUnitAndTbType : fullTaxUnitIdSet) {
                String[] taxUnitAndTbTypeArr = taxUnitAndTbType.split("_");
                String taxUnitId = taxUnitAndTbTypeArr[0];
                String tbType = taxUnitAndTbTypeArr[1];
                if ("1".equals(tbType)) {
                    ykyjNewTaxIdSet.add(taxUnitId);
                } else if ("3".equals(tbType)) {
                    fjmsdNewTaxIdSet.add(taxUnitId);
                }
                allTaxUnitSet.add(taxUnitId);
            }
        }
        if ((taxUnitIdInData = CmpSQLUtil.createInSql(ctx, allTaxUnitSet, "T_HR_TaxUnit", "Fid")).trim().length() == 0) {
            taxUnitIdInData = "('')";
        }
        Map<String, TaxUnitInfo> taxUnitInfoMap = this.getTaxUnitInfoByIdSet(ctx, taxUnitIdInData);
        HashSet<String> ykyjTaxIdSet = new HashSet<String>();
        HashSet<String> fjmsdTaxIdSet = new HashSet<String>();
        CoreBaseCollection updateCollection = new CoreBaseCollection();
        CoreBaseCollection newCollections = new CoreBaseCollection();
        ykyjTaxIdSet.addAll(ykyjUpdateTaxIdSet);
        ykyjTaxIdSet.addAll(ykyjNewTaxIdSet);
        String inSqlWithCh = CmpSQLUtil.createInSql(ctx, ykyjTaxIdSet, "T_HR_STaxCalConfigDetail", "FtaxUnitId");
        HashMap<String, List<String>> zhsdTaxCalConfigDetailIds = new HashMap<String, List<String>>();
        List<TaxDeclarParamDTO> ykyjDataList = this.generateData(ctx, yearMonth, "1", inSqlWithCh, zhsdTaxCalConfigDetailIds);
        ArrayList<String> insertRecordSqlList = new ArrayList<String>();
        insertRecordSqlList.add(this.genInsertRecordTbSql(ctx, yearMonth, inSqlWithCh, "1"));
        ArrayList<String> delRecordSqlList = new ArrayList<String>();
        delRecordSqlList.add(this.updateConfigDetailGenState(false, yearMonth, inSqlWithCh, "1"));
        Map<String, List<String>> zhsdBatchNoMap = this.handleCollection(needToUpdate, updateCollection, newCollections, taxUnitInfoMap, ykyjDataList, yearMonth, calendar, zhsdTaxCalConfigDetailIds);
        fjmsdTaxIdSet.addAll(fjmsdNewTaxIdSet);
        fjmsdTaxIdSet.addAll(fjmsdUpdateTaxIdSet);
        inSqlWithCh = CmpSQLUtil.createInSql(ctx, fjmsdTaxIdSet, "T_HR_STaxCalConfigDetail", "FtaxUnitId");
        HashMap<String, List<String>> fjmTaxCalConfigDetailIds = new HashMap<String, List<String>>();
        List<TaxDeclarParamDTO> fjmsdDataList = this.generateData(ctx, yearMonth, "3", inSqlWithCh, fjmTaxCalConfigDetailIds);
        insertRecordSqlList.add(this.genInsertRecordTbSql(ctx, yearMonth, inSqlWithCh, "3"));
        delRecordSqlList.add(this.updateConfigDetailGenState(false, yearMonth, inSqlWithCh, "3"));
        Map<String, List<String>> fjmBatchNoMap = this.handleCollection(needToUpdate, updateCollection, newCollections, taxUnitInfoMap, fjmsdDataList, yearMonth, calendar, fjmTaxCalConfigDetailIds);
        this.updateBatchNo(zhsdBatchNoMap, fjmBatchNoMap, ctx);
        IncomeTaxDeclarFactory.getLocalInstance(ctx).updateBatchData(updateCollection);
        IncomeTaxDeclarFactory.getLocalInstance(ctx).saveBatchData(newCollections);
        this.recordData(ctx, insertRecordSqlList, delRecordSqlList);
        int successCount = updateCollection.size() + newCollections.size();
        resultMap.put("successCount", successCount);
        resultMap.put("noDataTaxUnitCount", noDataTaxUnitCount);
        resultMap.put("failTaxUnitCount", failTaxUnitCount);
        resultMap.put("hasDataGenerate", hasDataGenerate);
        resultMap.put("isAllFail", isAllFail);
        resultMap.put("taxNameTypeInfo", taxNameTypeBuffer.toString());
        return resultMap;
    }

    private void updateBatchNo(Map<String, List<String>> zhsdBatchNoMap, Map<String, List<String>> fjmBatchNoMap, Context ctx) throws BOSException {
        this.updateBatchNo(ctx, zhsdBatchNoMap);
        this.updateBatchNo(ctx, fjmBatchNoMap);
    }

    private void updateBatchNo(Context ctx, Map<String, List<String>> batchNoMap) throws BOSException {
        if (batchNoMap.size() == 0) {
            return;
        }
        String updateSQL = "update t_hr_sTaxCalConfigDetail set fBatchNo = ? where fid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map.Entry<String, List<String>> entry : batchNoMap.entrySet()) {
            String batchNo = entry.getKey();
            List<String> idList = entry.getValue();
            for (String id : idList) {
                Object[] param = new Object[]{batchNo, id};
                params.add(param);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
    }

    private void generateTaxNameType(StringBuilder taxNameTypeBuffer, Map<String, String> failInfoMap) {
        Iterator<Map.Entry<String, String>> iterator = failInfoMap.entrySet().iterator();
        int count = 1;
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            if (count >= 2) {
                taxNameTypeBuffer.append("\u3001");
            }
            if (count > 10) {
                taxNameTypeBuffer.append("......");
                break;
            }
            taxNameTypeBuffer.append(next.getValue());
            ++count;
        }
    }

    private synchronized void recordData(Context ctx, List<String> insertRecordSqlList, List<String> delRecordSqlList) throws BOSException {
        if (delRecordSqlList != null && !delRecordSqlList.isEmpty()) {
            for (String sql : delRecordSqlList) {
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        if (insertRecordSqlList != null && insertRecordSqlList.size() > 0) {
            for (String sql : insertRecordSqlList) {
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
    }

    private Map<String, TaxUnitInfo> getTaxUnitInfoByIdSet(Context ctx, String taxUnitIdInData) throws BOSException {
        HashMap<String, TaxUnitInfo> taxUnitInfoMap = new HashMap<String, TaxUnitInfo>();
        TaxUnitCollection taxUnitCollection = TaxUnitFactory.getLocalInstance(ctx).getTaxUnitCollection("where id in " + taxUnitIdInData);
        if (taxUnitCollection != null && taxUnitCollection.size() > 0) {
            for (int i = 0; i < taxUnitCollection.size(); ++i) {
                TaxUnitInfo taxUnitInfo = taxUnitCollection.get(i);
                taxUnitInfoMap.put(taxUnitInfo.getId().toString(), taxUnitInfo);
            }
        }
        return taxUnitInfoMap;
    }

    private Map<String, List<String>> handleCollection(Map<String, IncomeTaxDeclarInfo> needToUpdate, CoreBaseCollection updateCollection, CoreBaseCollection newCollections, Map<String, TaxUnitInfo> taxUnitInfoMap, List<TaxDeclarParamDTO> ykyjDataList, String yearMonth, Calendar calendar, Map<String, List<String>> taxCalConfigDetailIds) {
        HashMap<String, List<String>> batchNo2TaxCalConfigDetailId = new HashMap<String, List<String>>();
        if (ykyjDataList != null && ykyjDataList.size() > 0) {
            Set<String> updateKeySet = needToUpdate.keySet();
            for (TaxDeclarParamDTO taxDeclarParamDTO : ykyjDataList) {
                IncomeTaxDeclarInfo taxDeclarInfo;
                String taxUnitId = taxDeclarParamDTO.getTaxUnitId();
                String tbType = taxDeclarParamDTO.getTbType();
                String key = taxUnitId + "_" + tbType;
                if (updateKeySet.contains(key)) {
                    taxDeclarInfo = needToUpdate.get(key);
                    taxDeclarInfo.setDeclareStatus(TaxDeclareStatusEnum.getEnum("0"));
                    taxDeclarInfo.setAcceptId(null);
                    taxDeclarInfo.setTaxCalTask(null);
                    taxDeclarInfo.setTotalMoney(taxDeclarParamDTO.getTotalMoney());
                    taxDeclarInfo.setTotalPerson(taxDeclarParamDTO.getTotalPerson());
                    taxDeclarInfo.setTaxRebate(taxDeclarParamDTO.getTaxRebate());
                    if (StringUtils.isEmpty((CharSequence)taxDeclarInfo.getBatchNo())) {
                        taxDeclarInfo.setBatchNo(TaxCalcFileUtils.getUUID());
                    }
                    updateCollection.add((CoreBaseInfo)taxDeclarInfo);
                } else {
                    taxDeclarInfo = new IncomeTaxDeclarInfo();
                    TaxUnitInfo taxUnitInfo = taxUnitInfoMap.get(taxUnitId);
                    taxDeclarInfo.setTaxUnit(taxUnitInfo);
                    taxDeclarInfo.setVersionCode("V2.0.000");
                    taxDeclarInfo.setYearMonth(yearMonth);
                    taxDeclarInfo.setYearMonthDate(calendar.getTime());
                    taxDeclarInfo.setTbType(TbTypeEnum.getEnum(tbType));
                    taxDeclarInfo.setDeclareStatus(TaxDeclareStatusEnum.DECLARE_NO);
                    taxDeclarInfo.setTotalMoney(taxDeclarParamDTO.getTotalMoney());
                    taxDeclarInfo.setTotalPerson(taxDeclarParamDTO.getTotalPerson());
                    taxDeclarInfo.setTaxRebate(taxDeclarParamDTO.getTaxRebate());
                    taxDeclarInfo.setBatchNo(TaxCalcFileUtils.getUUID());
                    newCollections.add((CoreBaseInfo)taxDeclarInfo);
                }
                this.setBatchNo(taxCalConfigDetailIds, taxDeclarInfo, batchNo2TaxCalConfigDetailId);
            }
        }
        return batchNo2TaxCalConfigDetailId;
    }

    private void setBatchNo(Map<String, List<String>> taxCalConfigDetailIds, IncomeTaxDeclarInfo taxDeclareInfo, Map<String, List<String>> batchNo2TaxCalConfigDetailId) {
        List<String> idList = taxCalConfigDetailIds.get(taxDeclareInfo.getTaxUnit().getId().toString());
        if (null != idList) {
            batchNo2TaxCalConfigDetailId.put(taxDeclareInfo.getBatchNo(), idList);
        }
    }

    private Map<String, Object> handleCollectionData(IncomeTaxDeclarCollection collection) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashSet<String> existSet = new HashSet<String>();
        HashMap<String, IncomeTaxDeclarInfo> needToUpdate = new HashMap<String, IncomeTaxDeclarInfo>();
        HashMap<String, String> notToUpdate = new HashMap<String, String>();
        ArrayList<String> notToUpdateTaxName = new ArrayList<String>();
        ArrayList<String> notToUpdateTypeName = new ArrayList<String>();
        HashSet<String> ykyjUpdateTaxIdSet = new HashSet<String>();
        HashSet<String> flsdUpdateTaxIdSet = new HashSet<String>();
        HashSet<String> fjmsdUpdateTaxIdSet = new HashSet<String>();
        HashSet<String> taxUnitIdSetFromDb = new HashSet<String>();
        HashSet<String> taxSuceessIdSet = new HashSet<String>();
        HashSet<String> taxFailIdSet = new HashSet<String>();
        HashMap<String, String> failInfoMap = new HashMap<String, String>();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                IncomeTaxDeclarInfo taxDeclarInfo = collection.get(i);
                String taxUnitId = taxDeclarInfo.getTaxUnit().getId().toString();
                String tbType = taxDeclarInfo.getTbType().getValue();
                String declaStatus = taxDeclarInfo.getDeclareStatus().getValue();
                String fid = taxDeclarInfo.getId().toString();
                String taxName = taxDeclarInfo.getTaxUnit().getName();
                String key = taxUnitId + "_" + tbType;
                existSet.add(key);
                taxUnitIdSetFromDb.add(taxUnitId);
                if ("0".equals(declaStatus) || "3".equals(declaStatus)) {
                    needToUpdate.put(key, taxDeclarInfo);
                    taxSuceessIdSet.add(taxUnitId);
                    if ("1".equals(tbType)) {
                        ykyjUpdateTaxIdSet.add(taxUnitId);
                    } else if ("2".equals(tbType)) {
                        flsdUpdateTaxIdSet.add(taxUnitId);
                    } else if ("3".equals(tbType)) {
                        fjmsdUpdateTaxIdSet.add(taxUnitId);
                    }
                }
                if (!"1".equals(declaStatus) && !"2".equals(declaStatus)) continue;
                taxFailIdSet.add(taxUnitId);
                String tbTypeName = "1".equals(tbType) ? TbTypeEnum.SB0701.getAlias() : ("2".equals(tbType) ? TbTypeEnum.SB0702.getAlias() : ("3".equals(tbType) ? TbTypeEnum.SB0703.getAlias() : ""));
                notToUpdate.put(fid, tbType);
                notToUpdateTaxName.add(taxName);
                notToUpdateTypeName.add(tbTypeName);
                failInfoMap.put(key, taxName + "-" + tbTypeName);
            }
        }
        resultMap.put("taxUnitIdSetFromDb", taxUnitIdSetFromDb);
        resultMap.put("taxSuceessIdSet", taxSuceessIdSet);
        resultMap.put("taxFailIdSet", taxFailIdSet);
        resultMap.put("failInfoMap", failInfoMap);
        resultMap.put("existSet", existSet);
        resultMap.put("needToUpdate", needToUpdate);
        resultMap.put("notToUpdate", notToUpdate);
        resultMap.put("notToUpdateTaxName", notToUpdateTaxName);
        resultMap.put("notToUpdateTypeName", notToUpdateTypeName);
        resultMap.put("ykyjUpdateTaxIdSet", ykyjUpdateTaxIdSet);
        resultMap.put("flsdUpdateTaxIdSet", flsdUpdateTaxIdSet);
        resultMap.put("fjmsdUpdateTaxIdSet", fjmsdUpdateTaxIdSet);
        return resultMap;
    }

    private String getIncomeTaxDeclarCollecOql(String yearMonth, String buildInSql) {
        return "select id,batchNo,taxUnit.id,taxUnit.name,taxUnit.taxNumber,yearMonth,totalPerson,totalMoney,taxRebate,declareStatus,versionCode,yearMonthDate, tbType where taxUnit.id in  " + buildInSql + " and yearMonth='" + yearMonth + "'";
    }

    private List<TaxDeclarParamDTO> generateData(Context ctx, String yearMonth, String tbTypeEnumVal, String inTaxUnitIdSqlField, Map<String, List<String>> taxCalConfigDetails) throws BOSException {
        Set<String> perTaxUnitPersonSet;
        Map perTaxUnitMap;
        String generateDataSql = this.generateDataSql(yearMonth, inTaxUnitIdSqlField, tbTypeEnumVal);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)generateDataSql);
        String perTaxUnitTOTALPerson = "perTaxUnitTOTALPerson";
        String perTaxUnitT1 = "perTaxUnitT1";
        String perTaxUnitT19 = "perTaxUnitT19";
        String perTaxUnitT38 = "perTaxUnitT38";
        HashMap<String, Map<String, BigDecimal>> resultMap = new HashMap<String, Map<String, BigDecimal>>();
        HashSet<String> addT19Persons = new HashSet<String>();
        try {
            while (rs.next()) {
                BigDecimal t1Total;
                String taxUnitId = rs.getString("FTAXUNITID");
                List idList = taxCalConfigDetails.computeIfAbsent(taxUnitId, k -> new ArrayList());
                idList.add(rs.getString("fid"));
                String cardNumber = rs.getString("CARDNUMBER");
                BigDecimal t1 = rs.getBigDecimal("T1") == null ? BigDecimal.ZERO : rs.getBigDecimal("T1");
                BigDecimal t19 = rs.getBigDecimal("T19") == null ? BigDecimal.ZERO : rs.getBigDecimal("T19");
                BigDecimal t38 = rs.getBigDecimal("T38") == null ? BigDecimal.ZERO : rs.getBigDecimal("T38");
                BigDecimal t39 = rs.getBigDecimal("T39") == null ? BigDecimal.ZERO : rs.getBigDecimal("T39");
                String incomeCode = rs.getString("FINCOMECODE") == null ? "" : rs.getString("FINCOMECODE");
                perTaxUnitMap = resultMap.containsKey(taxUnitId) ? (Map)resultMap.get(taxUnitId) : new HashMap();
                if (perTaxUnitMap.containsKey(perTaxUnitTOTALPerson)) {
                    perTaxUnitPersonSet = (Set)perTaxUnitMap.get(perTaxUnitTOTALPerson);
                } else {
                    perTaxUnitPersonSet = new HashSet();
                    perTaxUnitMap.put(perTaxUnitTOTALPerson, perTaxUnitPersonSet);
                }
                BigDecimal bigDecimal = t1Total = perTaxUnitMap.containsKey(perTaxUnitT1) ? (BigDecimal)perTaxUnitMap.get(perTaxUnitT1) : BigDecimal.ZERO;
                if ("0108".equals(incomeCode)) {
                    perTaxUnitMap.put(perTaxUnitT1, t1Total.add(t39));
                } else {
                    perTaxUnitMap.put(perTaxUnitT1, t1Total.add(t1));
                }
                String key = cardNumber + "_" + incomeCode;
                if (!addT19Persons.contains(key)) {
                    BigDecimal t19Total;
                    BigDecimal bigDecimal2 = t19Total = perTaxUnitMap.containsKey(perTaxUnitT19) ? (BigDecimal)perTaxUnitMap.get(perTaxUnitT19) : BigDecimal.ZERO;
                    if (!("0403".equals(incomeCode) || "0402".equals(incomeCode) || "0489".equals(incomeCode))) {
                        perTaxUnitMap.put(perTaxUnitT19, t19Total.add(t19));
                    }
                    addT19Persons.add(key);
                }
                perTaxUnitPersonSet.add(cardNumber);
                BigDecimal t38Total = perTaxUnitMap.containsKey(perTaxUnitT38) ? (BigDecimal)perTaxUnitMap.get(perTaxUnitT38) : BigDecimal.ZERO;
                perTaxUnitMap.put(perTaxUnitT38, t38Total.add(t38));
                resultMap.put(taxUnitId, perTaxUnitMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        ArrayList<TaxDeclarParamDTO> dataList = new ArrayList<TaxDeclarParamDTO>();
        for (Map.Entry entry : resultMap.entrySet()) {
            perTaxUnitMap = (HashMap)entry.getValue();
            BigDecimal t1Total = perTaxUnitMap.containsKey(perTaxUnitT1) ? (BigDecimal)perTaxUnitMap.get(perTaxUnitT1) : BigDecimal.ZERO;
            BigDecimal t19Total = perTaxUnitMap.containsKey(perTaxUnitT19) ? (BigDecimal)perTaxUnitMap.get(perTaxUnitT19) : BigDecimal.ZERO;
            BigDecimal t38Total = perTaxUnitMap.containsKey(perTaxUnitT38) ? (BigDecimal)perTaxUnitMap.get(perTaxUnitT38) : BigDecimal.ZERO;
            perTaxUnitPersonSet = perTaxUnitMap.containsKey(perTaxUnitTOTALPerson) ? (Set)perTaxUnitMap.get(perTaxUnitTOTALPerson) : new HashSet();
            BigDecimal totalMoney = t1Total.add(t19Total);
            long totalPerson = perTaxUnitPersonSet.size();
            TaxDeclarParamDTO taxDeclarParamDTO = new TaxDeclarParamDTO();
            taxDeclarParamDTO.setTaxUnitId((String)entry.getKey());
            taxDeclarParamDTO.setYearMonth(yearMonth);
            taxDeclarParamDTO.setTbType(tbTypeEnumVal);
            taxDeclarParamDTO.setTotalMoney(totalMoney);
            taxDeclarParamDTO.setTotalPerson(totalPerson);
            taxDeclarParamDTO.setTaxRebate(t38Total);
            dataList.add(taxDeclarParamDTO);
        }
        return dataList;
    }

    private String generateDataSql(String yearMonth, String inTaxUnitIdSqlField, String tbTypeEnumVal) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(" SELECT res.fid, res.FTAXUNITID as FTAXUNITID,");
        sqlBuffer.append(" res.T1 as T1,");
        sqlBuffer.append(" res.T19 as T19,");
        sqlBuffer.append(" res.T38 as T38,");
        sqlBuffer.append(" res.T39 as T39,");
        sqlBuffer.append(" itm.FincomeCode as FINCOMECODE,");
        if (SHRStringUtil.isBlank(inTaxUnitIdSqlField)) {
            inTaxUnitIdSqlField = "('')";
        }
        sqlBuffer.append(" pr.FcardNumber as CARDNUMBER ");
        sqlBuffer.append(" FROM T_HR_STaxCalConfigDetail as  res");
        sqlBuffer.append(" left join T_HR_STaxIncomeItem as itm on itm.FID= res.FIncomeItemId ");
        sqlBuffer.append(" left join T_HR_STaxPersonRecord as pr on pr.FpersonId=res.FpersonId ");
        sqlBuffer.append(" left join T_HR_STaxPersonRecordEntry pre on pre.FPersonID=res.FpersonId and  pre.FTaxUnitID=res.FTaxUnitID ");
        sqlBuffer.append(" WHERE res.FtaxUnitId in ");
        sqlBuffer.append(inTaxUnitIdSqlField);
        sqlBuffer.append(" and res.FSTATE=20");
        if (tbTypeEnumVal.equals("1")) {
            sqlBuffer.append(" and pre.FPAYERTYPE ='0' ");
        } else if (tbTypeEnumVal.equals("3")) {
            sqlBuffer.append(" and pre.FPAYERTYPE ='1' ");
        } else {
            sqlBuffer.append(" and pre.FPAYERTYPE ='0' ");
        }
        sqlBuffer.append(" and ");
        sqlBuffer.append(CmpSQLUtil.generateSqlDateFilter("res.FPeriodBegin", "res.FPeriodEnd", yearMonth));
        return sqlBuffer.toString();
    }

    @Override
    protected Map _taxDeclare(Context ctx, Map paramMap) throws BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        resultMap.put("msg", "");
        List waitToDeclareList = (List)paramMap.get("declaData");
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        if (waitToDeclareList != null && waitToDeclareList.size() > 0) {
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("declareStatus"));
            for (IncomeTaxDeclarInfo taxDeclarInfo : waitToDeclareList) {
                TaxUnitInfo taxUnit = taxDeclarInfo.getTaxUnit();
                String regNum = SHRStringUtil.getStr(taxUnit.getRegNumber());
                String taxNum = SHRStringUtil.getStr(taxUnit.getTaxNumber());
                String areaCode = SHRStringUtil.getStr(taxUnit.getAreaCode());
                String yearMonth = SHRStringUtil.getStr(taxDeclarInfo.getYearMonth());
                String sbmm = SHRStringUtil.getStr(taxUnit.getDeclPassword());
                BigDecimal totalMoney = taxDeclarInfo.getTotalMoney();
                BigDecimal taxRebate = taxDeclarInfo.getTaxRebate();
                long totalPerson = taxDeclarInfo.getTotalPerson();
                String tbTble = taxDeclarInfo.getTbType().getValue();
                String taxUnitId = SHRStringUtil.getStr(taxUnit.getId());
                HashMap<String, Number> tbTypeMap = new HashMap<String, Number>();
                if (totalMoney.compareTo(BigDecimal.ZERO) == 0) {
                    tbTypeMap.put("zje", 0.0);
                } else {
                    tbTypeMap.put("zje", totalMoney);
                }
                if (taxRebate.compareTo(BigDecimal.ZERO) == 0) {
                    tbTypeMap.put("ynse", 0.0);
                } else {
                    tbTypeMap.put("ynse", taxRebate);
                }
                tbTypeMap.put("zrs", totalPerson);
                HashMap<String, HashMap<String, Number>> dataMap = new HashMap<String, HashMap<String, Number>>();
                if ("1".equals(tbTble)) {
                    dataMap.put("ykyj", tbTypeMap);
                } else if ("2".equals(tbTble)) {
                    dataMap.put("flsd", tbTypeMap);
                } else if ("3".equals(tbTble)) {
                    dataMap.put("fjm", tbTypeMap);
                }
                requestParamMap.put("data", dataMap);
                requestParamMap.put("djxhid", regNum == null ? "" : regNum);
                requestParamMap.put("nsrsbh", taxNum);
                requestParamMap.put("areaid", areaCode);
                requestParamMap.put("TAXUNITID", taxUnitId);
                if (yearMonth.contains("-")) {
                    yearMonth = yearMonth.replace("-", "");
                }
                requestParamMap.put("sdyf", yearMonth.substring(0, 6));
                requestParamMap.put("ver", "V2.0.000");
                requestParamMap.put("sbmm", Base64Utils.decode(sbmm));
                requestParamMap.put("bmbh", "");
                String realPassword = taxUnit.getRealPassword();
                if (!SHRStringUtil.isEmpty(realPassword)) {
                    requestParamMap.put("smmm", Base64Utils.decode(realPassword));
                }
                ITaxServiceTaskFacade iTaxServiceTaskFacade = TaxServiceTaskFacadeFactory.getLocalInstance(ctx);
                IObjectPK taskId = iTaxServiceTaskFacade.addTask(TaxCalTaskCatalogEnum.TaxReport, requestParamMap);
                Object[] params = new Object[]{SHRStringUtil.getStr(taskId), "1", SHRStringUtil.getStr(taxDeclarInfo.getId())};
                paramList.add(params);
            }
        }
        if (paramList.size() > 0) {
            String updateSql = "UPDATE T_HR_SIncomeTaxDeclar SET  FTAXCALTASKID=? , FDECLARESTATUS=?  WHERE  fid=?";
            CmpSQLUtil.executeBatchAndReturn(ctx, updateSql, paramList);
        }
        return resultMap;
    }

    private String genInsertRecordTbSql(Context ctx, String yearMonth, String inTaxUnitIdSqlField, String tbTypeEnumVal) throws BOSException {
        String[] arr = yearMonth.split("-");
        int isPersonal = "1".equals(tbTypeEnumVal) ? 0 : 1;
        String delSql = " DELETE FROM T_HR_STaxDeclareRecord  WHERE FTaxUnitId in  " + inTaxUnitIdSqlField + " and FPeriodYear = " + Integer.parseInt(arr[0]) + " and FPeriodMonth = " + Integer.parseInt(arr[1]) + " and FIsPersonal = " + isPersonal;
        DbUtil.execute((Context)ctx, (String)delSql);
        Map<String, Object> dynamicSqlFileMap = this.genDynamicSqlField(ctx);
        String allFields = (String)dynamicSqlFileMap.get("allFields");
        String allFieldsForSelect = (String)dynamicSqlFileMap.get("allFieldsForSelect");
        String sumAndMaxFields = (String)dynamicSqlFileMap.get("sumAndMaxFields");
        String numFieldStr = (String)dynamicSqlFileMap.get("numFieldStr");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        StringBuilder insertSQL = new StringBuilder();
        int fieldCount = this.getTaxDeclareRecordInsertSQL(insertSQL);
        if (SHRStringUtil.isNotBlank(numFieldStr)) {
            insertSQL.append(numFieldStr);
            int len = numFieldStr.split(",").length - 1;
            fieldCount += len;
        }
        this.addValueStatement(insertSQL, fieldCount);
        StringBuilder selectSQL = new StringBuilder();
        selectSQL.append(" select newbosid('9A8D51F5') FID,'0' declareStatus,tcd.FPersonID,tcd.FTaxUnitID,tcd.FPeriodBegin,tcd.FPeriodEnd,tcd.FIncomeItemId, ");
        String[] dateArr = yearMonth.split("-");
        String periodDate = dateArr[0] + " periodYear, " + dateArr[1] + " periodMonth,";
        selectSQL.append(periodDate);
        selectSQL.append("pr.FCardType idType,");
        selectSQL.append(" pr.FCardNumber idNO,pr.FTaxNumber taxPayerNum, ");
        selectSQL.append(" case when prt.FPayerType='0' then 0 ");
        selectSQL.append(" when prt.FPayerType='1' then 1 ");
        selectSQL.append(" else 0 end as isPersonal, ");
        selectSQL.append(" ite.FName_l2 proceedItem, ");
        selectSQL.append(" ite.FIncomeCode FItemDefine, ");
        Date nowDate = new Date();
        String kSqlDate = CmpDateUtil.toKSqlDate(nowDate);
        selectSQL.append(kSqlDate).append(" FCREATETIME, ");
        selectSQL.append(kSqlDate).append(" FLASTUPDATETIME, ");
        selectSQL.append("'").append(userId).append("'").append(" FCREATORID, ");
        selectSQL.append("'").append(userId).append("'").append(" FLASTUPDATEUSERID ");
        if (SHRStringUtil.isNotBlank(sumAndMaxFields)) {
            selectSQL.append(sumAndMaxFields);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("yearMonth", yearMonth);
        paramMap.put("inTaxUnitIdSqlField", inTaxUnitIdSqlField);
        paramMap.put("isSumOrDetaiCond", " and ite.FTaxCalMethod = 10");
        paramMap.put("tbTypeEnumVal", tbTypeEnumVal);
        this.commonRecordSqlPart(paramMap, selectSQL);
        selectSQL.append(" group by tcd.FPersonID,tcd.FTaxUnitID,tcd.FPeriodBegin,tcd.FPeriodEnd,tcd.FIncomeItemId,pr.FCardType,");
        selectSQL.append(" pr.FCardNumber,pr.FTaxNumber,prt.FPayerType,ite.FName_l2,ite.FIncomeCode ");
        this.insertQueryData(ctx, insertSQL.toString(), fieldCount, selectSQL.toString());
        StringBuilder detailInsertSQL = new StringBuilder();
        fieldCount = this.getTaxDeclareRecordInsertSQL(detailInsertSQL);
        if (SHRStringUtil.isNotBlank(allFields)) {
            detailInsertSQL.append(allFields);
            fieldCount += allFields.split(",").length - 1;
        }
        this.addValueStatement(detailInsertSQL, fieldCount);
        StringBuilder detailQuerySQL = new StringBuilder();
        detailQuerySQL.append(" select newbosid('9A8D51F5') FID,'0' declareStatus,tcd.FPersonID,tcd.FTaxUnitID,tcd.FPeriodBegin,tcd.FPeriodEnd,tcd.FIncomeItemId, ");
        detailQuerySQL.append(periodDate);
        detailQuerySQL.append("pr.FCardType idType,");
        detailQuerySQL.append(" pr.FCardNumber idNO,pr.FTaxNumber taxPayerNum, ");
        detailQuerySQL.append(" case when prt.FPayerType='0' then 0 ");
        detailQuerySQL.append(" when prt.FPayerType='1' then 1 ");
        detailQuerySQL.append(" else 0 end as isPersonal, ");
        detailQuerySQL.append(" ite.FName_l2 proceedItem, ");
        detailQuerySQL.append(" ite.FIncomeCode FItemDefine, ");
        detailQuerySQL.append(kSqlDate).append(" FCREATETIME, ");
        detailQuerySQL.append(kSqlDate).append(" FLASTUPDATETIME, ");
        detailQuerySQL.append("'").append(userId).append("'").append(" FCREATORID, ");
        detailQuerySQL.append("'").append(userId).append("'").append(" FLASTUPDATEUSERID ");
        if (SHRStringUtil.isNotBlank(allFieldsForSelect)) {
            detailQuerySQL.append(allFieldsForSelect);
        }
        paramMap = new HashMap();
        paramMap.put("yearMonth", yearMonth);
        paramMap.put("inTaxUnitIdSqlField", inTaxUnitIdSqlField);
        paramMap.put("isSumOrDetaiCond", " and ite.FTaxCalMethod = 20");
        paramMap.put("tbTypeEnumVal", tbTypeEnumVal);
        this.commonRecordSqlPart(paramMap, detailQuerySQL);
        this.insertQueryData(ctx, detailInsertSQL.toString(), fieldCount, detailQuerySQL.toString());
        return this.updateConfigDetailGenState(true, yearMonth, inTaxUnitIdSqlField, tbTypeEnumVal);
    }

    private void insertQueryData(Context ctx, String insertSQL, int fieldCount, String selectSQL) throws BOSException {
        logger.debug((Object)("------insertSQL------> " + insertSQL));
        logger.debug((Object)("------selectSQL------> " + selectSQL));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            ArrayList<Object[]> insertParam = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] param = new Object[fieldCount];
                for (int i = 1; i <= fieldCount; ++i) {
                    param[i - 1] = rs.getObject(i);
                }
                String idType = rs.getString("idType");
                StringEnum cardType = EnumUtils.getEnumByValue(CardTypeEnum.class, (String)idType);
                if (null != cardType) {
                    int idTypeIndex = TAX_DECLARE_RECORD_COLUMNS.indexOf("FIdType");
                    param[idTypeIndex] = cardType.getAlias();
                }
                insertParam.add(param);
            }
            DbUtil.executeBatch((Context)ctx, (String)insertSQL, insertParam);
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
    }

    private void addValueStatement(StringBuilder insertSQL, int fieldCount) {
        insertSQL.append(" ) values (");
        for (int i = 0; i < fieldCount; ++i) {
            if (i > 0) {
                insertSQL.append(",");
            }
            insertSQL.append("?");
        }
        insertSQL.append(")");
    }

    protected int getTaxDeclareRecordInsertSQL(StringBuilder insertSQL) {
        insertSQL.append(" insert into T_HR_STaxDeclareRecord ( ");
        int size = TAX_DECLARE_RECORD_COLUMNS.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                insertSQL.append(",");
            }
            insertSQL.append(TAX_DECLARE_RECORD_COLUMNS.get(i));
        }
        return size;
    }

    private String updateConfigDetailGenState(boolean isGenerateTaxDeclare, String yearMonth, String inTaxUnitIdSqlField, String tbTypeEnumVal) {
        int isGenerateTax = 0;
        if (isGenerateTaxDeclare) {
            isGenerateTax = 1;
        }
        StringBuilder selectToUpdateBuf = new StringBuilder();
        selectToUpdateBuf.append(" SELECT aa.Fid FROM T_HR_STaxCalConfigDetail aa  ");
        selectToUpdateBuf.append(" left join T_HR_STaxPersonRecordEntry bb on bb.FTaxUnitID=aa.FTaxUnitId and aa.FPersonID=bb.FPersonID ");
        selectToUpdateBuf.append("  where aa.FTaxUnitId in  ");
        selectToUpdateBuf.append(inTaxUnitIdSqlField);
        selectToUpdateBuf.append(" and aa.FState = 20");
        selectToUpdateBuf.append(" and ");
        selectToUpdateBuf.append(CmpSQLUtil.generateSqlDateFilter("aa.FPeriodBegin", "aa.FPeriodEnd", yearMonth));
        if (tbTypeEnumVal.equals("1")) {
            selectToUpdateBuf.append(" and bb.FPAYERTYPE ='0' ");
        } else if (tbTypeEnumVal.equals("3")) {
            selectToUpdateBuf.append(" and bb.FPAYERTYPE ='1' ");
        } else {
            selectToUpdateBuf.append(" and bb.FPAYERTYPE ='0' ");
        }
        return " UPDATE T_HR_STaxCalConfigDetail SET FIsGenerateTaxDeclare=" + isGenerateTax + " WHERE Fid in ( " + selectToUpdateBuf.toString() + " )";
    }

    private void commonRecordSqlPart(Map<String, Object> paramMap, StringBuilder stringBuffer) {
        String yearMonth = (String)paramMap.get("yearMonth");
        String inTaxUnitIdSqlField = (String)paramMap.get("inTaxUnitIdSqlField");
        String isSumOrDetaiCond = (String)paramMap.get("isSumOrDetaiCond");
        String tbTypeEnumVal = (String)paramMap.get("tbTypeEnumVal");
        stringBuffer.append(" FROM T_HR_STaxCalConfigDetail tcd ");
        stringBuffer.append(" left join T_HR_STaxPersonRecord pr on pr.FPersonID=tcd.FPersonID ");
        stringBuffer.append(" left join T_HR_STaxPersonRecordEntry prt on prt.FBillID=pr.Fid and prt.FTaxUnitID=tcd.FTaxUnitId and tcd.FPersonID=prt.FPersonID ");
        stringBuffer.append(" left join T_HR_STaxIncomeItem ite on ite.fid=tcd.FIncomeItemId ");
        stringBuffer.append(" WHERE tcd.FtaxUnitId in  ");
        stringBuffer.append(inTaxUnitIdSqlField);
        stringBuffer.append(" and tcd.FSTATE=20");
        if (tbTypeEnumVal.equals("1")) {
            stringBuffer.append(" and prt.FPAYERTYPE ='0' ");
        } else if (tbTypeEnumVal.equals("3")) {
            stringBuffer.append(" and prt.FPAYERTYPE ='1' ");
        } else {
            stringBuffer.append(" and prt.FPAYERTYPE ='0' ");
        }
        stringBuffer.append(isSumOrDetaiCond);
        stringBuffer.append(" and ");
        stringBuffer.append(CmpSQLUtil.generateSqlDateFilter("tcd.FPeriodBegin", "tcd.FPeriodEnd", yearMonth));
    }

    private Map<String, Object> genDynamicSqlField(Context ctx) throws BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String sql = " SELECT FIELDSN,FDATATYPE,FISSUM FROM T_HR_StaxItem where FISSYSPRESET=1  and FDataType = 0 and FieldSn != 43";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuilder sumAndMaxFields = new StringBuilder();
        StringBuilder allFields = new StringBuilder();
        StringBuilder allFieldsForSelect = new StringBuilder();
        StringBuilder numFieldStr = new StringBuilder();
        try {
            while (rs.next()) {
                String fieldSn = rs.getString("FIELDSN");
                int dataType = rs.getInt("FDATATYPE");
                int isSum = rs.getInt("FISSUM");
                if (!SHRStringUtil.isNotBlank(fieldSn)) continue;
                if (dataType == 0) {
                    numFieldStr.append(" ,T").append(fieldSn);
                    if (isSum == 1) {
                        sumAndMaxFields.append(" ,sum(tcd.T").append(fieldSn).append(") as T").append(fieldSn);
                    } else {
                        sumAndMaxFields.append(" ,max(tcd.T").append(fieldSn).append(") as T").append(fieldSn);
                    }
                }
                allFields.append(" ,T").append(fieldSn);
                allFieldsForSelect.append(" ,tcd.T").append(fieldSn).append(" as T").append(fieldSn);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        resultMap.put("sumAndMaxFields", sumAndMaxFields.toString());
        resultMap.put("allFields", allFields.toString());
        resultMap.put("allFieldsForSelect", allFieldsForSelect.toString());
        resultMap.put("numFieldStr", numFieldStr.toString());
        return resultMap;
    }

    @Override
    protected Map _updateDeclare(Context ctx, IncomeTaxDeclarInfo taxDeclare) throws BOSException {
        return this.updateOrCancel(ctx, taxDeclare, TaxCalTaskCatalogEnum.TaxDeclareUpdate);
    }

    @Override
    protected Map _cancelUpdate(Context ctx, IncomeTaxDeclarInfo taxDeclare) throws BOSException {
        try {
            String sql = "select t.fAccept_id as acceptId from t_hr_sIncomeTaxDeclar d left join t_hr_sTaskIncomeTaxRelation r on d.fid = r.fBizId left join t_hr_sTaxCalTask t on r.fTaskId = t.fid where d.fid = '" + taxDeclare.getId().toString() + "' and t.fCatalog = " + 120;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0) {
                throw new BOSException("\u627e\u4e0d\u5230\u66f4\u6b63\u7533\u62a5\u4efb\u52a1\u53d7\u7406id");
            }
            while (rowSet.next()) {
                taxDeclare.setAcceptId(rowSet.getString("acceptId"));
            }
            return this.updateOrCancel(ctx, taxDeclare, TaxCalTaskCatalogEnum.CancelTaxUpdate);
        }
        catch (SQLException e) {
            logger.error((Object)"_cancelUpdate error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected Map _cancelDeclare(Context ctx, IncomeTaxDeclarInfo taxDeclare) throws BOSException {
        return this.updateOrCancel(ctx, taxDeclare, TaxCalTaskCatalogEnum.CancelTaxDeclare);
    }

    private Map updateOrCancel(Context ctx, IncomeTaxDeclarInfo taxDeclare, TaxCalTaskCatalogEnum catalog) throws BOSException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        TaxUnitInfo taxUnit = taxDeclare.getTaxUnit();
        paramMap.put("nsrsbh", taxUnit.getTaxNumber());
        paramMap.put("areaid", taxUnit.getAreaCode());
        paramMap.put("djxhid", taxUnit.getRegNumber() == null ? "" : taxUnit.getRegNumber());
        paramMap.put("acceptId", taxDeclare.getAcceptId());
        if (StringUtils.isNotEmpty((CharSequence)taxUnit.getDeclPassword())) {
            paramMap.put("sbmm", Base64Utils.decode(taxUnit.getDeclPassword()));
        }
        if (StringUtils.isNotEmpty((CharSequence)taxUnit.getRealPassword())) {
            paramMap.put("smmm", Base64Utils.decode(taxUnit.getRealPassword()));
        }
        paramMap.put("ver", "V2.0.000");
        paramMap.put("yzsmzh", false);
        String period = taxDeclare.getYearMonth();
        period = period.contains("-") ? period.replace("-", "") : period;
        period = period.substring(0, 6);
        paramMap.put("sdyf", period);
        paramMap.put("TAXUNITID", taxUnit.getId().toString());
        ArrayList<String> tbTypes = new ArrayList<String>();
        ArrayList<String> taxDeclareIds = new ArrayList<String>();
        tbTypes.add(taxDeclare.getTbType().getName());
        taxDeclareIds.add(taxDeclare.getId().toString());
        paramMap.put("bblb", tbTypes.toArray());
        try {
            ITaxServiceTaskFacade taxServiceTaskFacade = TaxServiceTaskFacadeFactory.getLocalInstance(ctx);
            IObjectPK taskId = taxServiceTaskFacade.addTask(catalog, paramMap);
            if (null == taskId) {
                logger.error((Object)"taxServiceTaskFacade add task failed, taskId is null");
                return null;
            }
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            String taskIdStr = taskId.toString();
            for (String taxDeclareId : taxDeclareIds) {
                Object[] param = new Object[]{taskIdStr, taxDeclareId, BOSUuid.create((String)"46E337F4").toString()};
                updateParamList.add(param);
            }
            String sqlString = "insert into T_HR_STaskIncomeTaxRelation (FTaskId,FBizId,Fid) values (?, ?, ?)";
            DbUtil.executeBatch((Context)ctx, (String)sqlString, updateParamList);
        }
        catch (Exception e) {
            logger.error((Object)"send update declare task error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return null;
    }
}

