/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.cmpBudget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.cmpBudget.AbstractBudgetDeductionFacadeControllerBean;
import com.kingdee.shr.compensation.app.cmpBudget.CmpBudgetCommonException;
import com.kingdee.shr.compensation.cmpBudget.CmpBudgetFacadeService;
import com.kingdee.shr.compensation.service.budget.DeductionResult;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.SalaryCalculatorProxy2;
import com.kingdee.shr.validaterule.formula.SalayCalculatorMgr2;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetDeductionFacadeControllerBean
extends AbstractBudgetDeductionFacadeControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionFacadeControllerBean");

    @Override
    protected Map _calculate(Context ctx, Map params) throws BOSException, EASBizException {
        String calSchemeID = (String)params.get("calSchemeID");
        String condition = (String)params.get("condition");
        String mainTable = (String)params.get("mainTable");
        int deduNode = Integer.parseInt((String)params.get("deduNode"));
        Date endDate = new Date();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionFacadeControllerBean -> condition: " + condition));
            }
            return this.cycleCalculateByCostType(ctx, mainTable, calSchemeID, condition, endDate, deduNode);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected Map cycleCalculateByCostType(Context ctx, String mainTable, String calSchemeID, String condition, Date endDate, int deduNode) throws Exception {
        CalSchemeInfo calSchemeInfo = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo("select costType where id = '" + calSchemeID + "'");
        String defaultCostTypeId = calSchemeInfo.getCostType().getId().toString();
        String deduSql = "select fid, fCostTypeId from T_HR_SBudgetDeductionConfig where FCalSchemeID = ? and FDeduNode = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)deduSql, (Object[])new Object[]{calSchemeID, deduNode});
        HashMap deduConfigGroupByCostTypeMap = Maps.newHashMap();
        while (rs.next()) {
            String id = rs.getString("fid");
            String costTypeId = rs.getString("fCostTypeId") != null ? rs.getString("fCostTypeId") : defaultCostTypeId;
            deduConfigGroupByCostTypeMap.putIfAbsent(costTypeId, Lists.newArrayList());
            ((List)deduConfigGroupByCostTypeMap.get(costTypeId)).add(id);
        }
        if (deduConfigGroupByCostTypeMap.isEmpty()) {
            return null;
        }
        String oql = " select id,name,calItem,express,listItem,listFunc,listVar,listTable,sortSn,bigExpress  where isCal = 1 and businessRelationConfig.businessId in {0} order by sortSn";
        CmpInSql inSql = CmpInSqlFactory.getInstance();
        HashMap calculateResultMap = Maps.newHashMap();
        for (Map.Entry entry : deduConfigGroupByCostTypeMap.entrySet()) {
            String innerSql = inSql.createInSqlBaseOnFId(ctx, (Collection)entry.getValue());
            BaseFormulaCollection formulaCollection = BaseFormulaFactory.getLocalInstance((Context)ctx).getBaseFormulaCollection(MessageFormat.format(oql, innerSql));
            calculateResultMap.put(entry.getKey(), this.post(ctx, mainTable, calSchemeID, formulaCollection, condition, endDate, deduNode));
        }
        CmpBudgetFacadeService service = new CmpBudgetFacadeService();
        DeductionResult deductionResult = service.budgetDeduction(ctx, deduNode, calSchemeID, calculateResultMap);
        HashMap resMap = Maps.newHashMap();
        resMap.put("deductionResult", deductionResult);
        return resMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Sheet post(Context ctx, String mainTable, String calSchemeId, BaseFormulaCollection formulaCollection, String condition, Date endDate, int deduNode) throws Exception {
        SalaryCalculator2 cal = new SalaryCalculator2();
        SalayCalculatorMgr2.addTask((SalaryCalculator2)cal);
        String uid = cal.getUID();
        try {
            SalaryCalculatorProxy2 cal2 = new SalaryCalculatorProxy2(uid, true);
            cal2.setMainTableName(mainTable);
            cal2.setMainTableAlias("CMP_CTB");
            cal2.setCalCategoryNum("CMP_Budget_002");
            cal2.setSchemeID(calSchemeId);
            cal2.setCtx(ctx);
            cal2.setEndDate(endDate);
            cal2.setCalFormulaColl(formulaCollection);
            cal2.setMainTableRowFilter(condition);
            cal2.setContainsVerification(true);
            cal2.setOuterData((Object)deduNode);
            cal2.post();
            if (cal.getCalMessage() != null && cal.getStatus() == 4) {
                logger.error((Object)cal.getCalMessage());
                throw new CmpBudgetCommonException(CmpBudgetCommonException.EXCEPTION1);
            }
            if (cal.getCalResult().getChangeDataList().isEmpty()) {
                throw new CmpBudgetCommonException(CmpBudgetCommonException.EXCEPTION0);
            }
            Sheet sheet = cal2.getCalResult();
            return sheet;
        }
        finally {
            SalayCalculatorMgr2.removeTask((String)uid, (String)"");
        }
    }
}

