/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.tax.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.compensation.CmpItemDataDot;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.app.tax.base.AbstractTaxItemControllerBean;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCatalogInfo;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCollection;
import com.kingdee.shr.compensation.app.tax.base.TaxItemFactory;
import com.kingdee.shr.compensation.app.tax.base.TaxItemInfo;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.TaxItemTypeEnum;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxItemControllerBean
extends AbstractTaxItemControllerBean {
    private static Logger logger = Logger.getLogger(TaxItemControllerBean.class);

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.saveOrUpdate(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteTaxItem(ctx, pk);
    }

    private IObjectPK saveOrUpdate(Context ctx, IObjectValue model) throws EASBizException {
        try {
            String[] arr;
            FunUtils.clearSessionMap();
            TaxItemInfo item = (TaxItemInfo)model;
            if (StringUtils.isEmpty((String)item.getName()) || StringUtils.isEmpty((String)item.getNumber())) {
                throw new EASBizException(new NumericExceptionSubItem("021", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label64", (Locale)ctx.getLocale())));
            }
            String reg = "^[\u4e00-\u9fa5a-zA-Z_]+[\u4e00-\u9fa5a-zA-Z_0-9\uff08\uff09]*$";
            if (!item.getName().matches(reg) || !item.getNumber().matches(reg)) {
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label65", (Locale)ctx.getLocale())));
            }
            for (String s : arr = new String[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label66", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label67", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label68", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label69", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label70", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label71", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label72", (Locale)ctx.getLocale())}) {
                if (!item.getName().contains(s) && !item.getNumber().contains(s)) continue;
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label65", (Locale)ctx.getLocale())));
            }
            int fieldSn = 60;
            int findex = 60;
            String sql = "select max(FieldSn),max(FINDEX) from T_HR_STaxItem";
            IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (list.next()) {
                if (list.getInt(1) > fieldSn) {
                    fieldSn = list.getInt(1);
                }
                if (list.getInt(2) <= findex) continue;
                findex = list.getInt(2);
            }
            boolean isNewOp = false;
            int orgFieldSn = item.getFieldSn();
            if (orgFieldSn == -1 || orgFieldSn == 0) {
                isNewOp = true;
            }
            if (item.getId() != null && !StringUtils.isEmpty((String)item.getId().toString())) {
                isNewOp = false;
            }
            if (isNewOp) {
                return this.addNewItemAndColumns(ctx, item, fieldSn, findex);
            }
            return this.updateItem(ctx, item);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private IObjectPK updateItem(Context ctx, TaxItemInfo item) throws BOSException, EASBizException {
        String name = item.getName();
        String number = item.getNumber();
        String itemid = item.getId().toString();
        String description = item.getDescription();
        CmpItemDataDot dataDot = item.getDataDot();
        int dataLength = item.getDataLength();
        int index = item.getIndex();
        BaseItemStateEnum state = item.getState();
        TaxItemCatalogInfo catalog = item.getCatalog();
        CountryInfo country = item.getCountry();
        UsePolicy usePolicy = item.getUsePolicy();
        HROrgUnitInfo hrOrgUnit = item.getHrOrgUnit();
        boolean isSysPreset = item.isIsSysPreset();
        CmpItemDataType dataType = item.getDataType();
        TaxItemTypeEnum type = item.getType();
        boolean isSum = item.isIsSum();
        boolean isSplit = item.isIsSplit();
        boolean isMerge = item.isIsMerge();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        String oql = "select * where (name = '" + name + "' or number = '" + number + "') and id <> '" + itemid + "'";
        try {
            boolean exists = TaxItemFactory.getLocalInstance(ctx).exists(oql);
            if (exists) {
                throw new EASBizException(new NumericExceptionSubItem("022", MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label73", (Locale)ctx.getLocale()), number, name)));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        this.syncBaseFormula(ctx, item);
        SHRBasicItemInfo shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
        TaxItemInfo taxItemInfo = new TaxItemInfo();
        taxItemInfo.setId(item.getId());
        taxItemInfo.setName(name);
        taxItemInfo.setNumber(number);
        taxItemInfo.setDescription(description);
        taxItemInfo.setDataDot(dataDot);
        taxItemInfo.setDataLength(dataLength);
        taxItemInfo.setCatalog(catalog);
        taxItemInfo.setHrOrgUnit(hrOrgUnit);
        taxItemInfo.setCountry(country);
        taxItemInfo.setUsePolicy(usePolicy);
        taxItemInfo.setState(state);
        taxItemInfo.setIndex(index);
        taxItemInfo.setIsSysPreset(isSysPreset);
        taxItemInfo.setLastUpdateUser(userInfo);
        taxItemInfo.setLastUpdateTime(this.getTime());
        taxItemInfo.setShrBasicItem(shrBasicItemInfo);
        taxItemInfo.setDataType(dataType);
        taxItemInfo.setType(type);
        taxItemInfo.setIsSum(isSum);
        taxItemInfo.setIsSplit(isSplit);
        taxItemInfo.setIsMerge(isMerge);
        if (CmpItemDataType.NUMBER.equals((Object)taxItemInfo.getDataType()) && item.getDataDot() == CmpItemDataDot.DOT_NONE) {
            taxItemInfo.setDataLength(12);
            taxItemInfo.setDataDot(CmpItemDataDot.DOT_TWO);
        }
        if (CmpItemDataType.STRING.equals((Object)taxItemInfo.getDataType()) && item.getDataLength() == 0) {
            taxItemInfo.setDataLength(255);
            taxItemInfo.setDataDot(CmpItemDataDot.DOT_NONE);
        }
        if (item.getFieldSn() <= 0) {
            String sql = "select FieldSn from T_HR_STaxItem where fid='" + item.getId().toString() + "'";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowset.next()) {
                    int fieldSn = rowset.getInt(1);
                    taxItemInfo.setFieldSn(fieldSn);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            taxItemInfo.setFieldSn(item.getFieldSn());
        }
        ObjectUuidPK idPk = new ObjectUuidPK(itemid);
        IObjectPK baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
        TaxItemCollection taxItemCollection = TaxItemFactory.getLocalInstance(ctx).getTaxItemCollection("select id,type where id ='" + item.getId().toString() + "'");
        if (type.getValue() != taxItemCollection.get(0).getType().getValue()) {
            String sql = "update T_HR_SBaseFormula set FCalType = " + type.getValue() + "  where FCalItem='T" + taxItemInfo.getFieldSn() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        super.innerUpdate(ctx, (IObjectPK)idPk, (IObjectValue)taxItemInfo);
        if (null != baseInfoChangePK) {
            this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
        } else {
            baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            }
        }
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, (IObjectPK)idPk));
        return idPk;
    }

    private void syncBaseFormula(Context ctx, TaxItemInfo item) throws BOSException {
        String newName;
        String oldName = newName = item.getName();
        boolean isSync = false;
        try {
            TaxItemInfo taxItemInfo = TaxItemFactory.getLocalInstance(ctx).getTaxItemInfo((IObjectPK)new ObjectUuidPK(item.getId().toString()));
            oldName = taxItemInfo.getName();
            if (!newName.equals(oldName)) {
                isSync = true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        if (!isSync) {
            return;
        }
        String oqlStr = "select * where id in (select FBaseFormulaId from T_HR_STaxItemBFormulaRel where FTaxItemId = '" + item.getId().toString() + "')";
        BaseFormulaCollection baseFormulaCollection = BaseFormulaFactory.getLocalInstance((Context)ctx).getBaseFormulaCollection(oqlStr);
        if (null == baseFormulaCollection || baseFormulaCollection.size() < 1) {
            return;
        }
        CoreBaseCollection updateBaseFormulaCol = new CoreBaseCollection();
        int size = baseFormulaCollection.size();
        for (int i = 0; i < size; ++i) {
            boolean isUpdate = false;
            BaseFormulaInfo baseFormulaInfo = baseFormulaCollection.get(i);
            String htmlContent = baseFormulaInfo.getHtmlContent();
            String express = baseFormulaInfo.getExpress();
            String name = baseFormulaInfo.getName();
            if (htmlContent.contains(oldName)) {
                htmlContent = htmlContent.replaceAll(">" + oldName + "<", ">" + newName + "<");
                htmlContent = htmlContent.replaceAll("&quot;" + oldName + "&quot;", "&quot;" + newName + "&quot;");
                isUpdate = true;
            }
            if (express.contains(oldName)) {
                express = express.replaceAll("\"" + oldName + "\"", "\"" + newName + "\"");
                isUpdate = true;
            }
            if (name.equals(oldName)) {
                name = newName;
                isUpdate = true;
            }
            if (!isUpdate) continue;
            baseFormulaInfo.setHtmlContent(htmlContent);
            baseFormulaInfo.setExpress(express);
            baseFormulaInfo.setName(name);
            updateBaseFormulaCol.add((CoreBaseInfo)baseFormulaInfo);
        }
        if (updateBaseFormulaCol.size() > 0) {
            try {
                BaseFormulaFactory.getLocalInstance((Context)ctx).update(updateBaseFormulaCol);
            }
            catch (EASBizException e) {
                logger.error((Object)("updateBaseFormula:" + e.getMessage()));
            }
        }
    }

    private IObjectPK addNewItemAndColumns(Context ctx, TaxItemInfo item, int fieldSn, int findex) throws BOSException, EASBizException {
        IObjectPK idPk;
        SHRBasicItemInfo shrBasicItemInfo;
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        String name = item.getName();
        String number = item.getNumber();
        String oql = "select * where (name = '" + name + "' or number = '" + number + "')";
        try {
            shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
            boolean exists = TaxItemFactory.getLocalInstance(ctx).exists(oql);
            if (exists) {
                throw new EASBizException(new NumericExceptionSubItem("022", MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label73", (Locale)ctx.getLocale()), number, name)));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        item.setFieldSn(fieldSn + 1);
        item.setIndex(findex + 1);
        if (CmpItemDataType.NUMBER.equals((Object)item.getDataType())) {
            item.setDataLength(12);
            item.setDataDot(CmpItemDataDot.DOT_TWO);
        } else {
            item.setDataLength(255);
            item.setDataDot(CmpItemDataDot.DOT_NONE);
        }
        item.setIsSysPreset(false);
        item.setShrBasicItem(shrBasicItemInfo);
        if (item.getCU() == null) {
            item.setCU(this.getCU(ctx, (ObjectBaseInfo)item));
        }
        if (item.getCreator() == null) {
            item.setCreator(userInfo);
        }
        Timestamp createtime = this.getTime();
        if (item.getCreateTime() == null) {
            item.setCreateTime(createtime);
        }
        item.setLastUpdateUser(userInfo);
        item.setLastUpdateTime(createtime);
        item.setState(BaseItemStateEnum.NEW);
        if (!BaseItemStateEnum.NEW.equals((Object)item.getState())) {
            IObjectPK baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            } else {
                baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
                if (null != baseInfoChangePK) {
                    this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                }
            }
        } else {
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
        }
        this.addColumn(ctx, item, "T_HR_STaxCalInitDetail");
        this.addColumn(ctx, item, "T_HR_STaxCalInitSum");
        this.addColumn(ctx, item, "T_HR_STaxCalConfigDetail");
        this.addColumn(ctx, item, "T_HR_STaxCalConfigResult");
        this.addColumn(ctx, item, "T_HR_STaxCalTaskDetail");
        this.addColumn(ctx, item, "T_HR_STaxCalConfigSum");
        this.addColumn(ctx, item, "T_HR_STaxDeclareRecord");
        this.addColumn(ctx, item, "T_HR_STaxCalInitDetailHis");
        this.addColumn(ctx, item, "T_HR_STaxCalConfigDetailHis");
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, idPk));
        return idPk;
    }

    private void addColumn(Context ctx, TaxItemInfo item, String addTableName) throws BOSException {
        StringBuilder ddl = new StringBuilder();
        ddl.append("alter table ").append(addTableName);
        ddl.append(" add T").append(item.getFieldSn());
        if (item.getDataType() == CmpItemDataType.NUMBER) {
            ddl.append(" numeric(20,10)");
        } else {
            int length = item.getDataLength();
            int n = length = length < 1 ? 255 : length;
            if (length > 1000) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label74", (Locale)ctx.getLocale()));
            }
            ddl.append(" nvarchar(").append(length).append(")");
        }
        DbUtil.execute((Context)ctx, (String)ddl.toString());
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        return new Timestamp(d.getTime().getTime());
    }

    private SHRBasicItemInfo getShrBasicItemInfo(Context ctx) throws BOSException, EASBizException {
        String entityName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType()).getFullName();
        ISHRBasicItem shrBasicItem = SHRBasicItemFactory.getLocalInstance((Context)ctx);
        String oql = "where entityName='" + entityName + "'";
        return shrBasicItem.getSHRBasicItemInfo(oql);
    }

    private void deleteTaxItem(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String column = "";
        try {
            String colSql = "select max('T'||to_char(FieldSn)) as field from T_HR_STaxItem where fid = '" + pk.toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)colSql);
            while (rowSet.next()) {
                column = rowSet.getString("field");
            }
            super._delete(ctx, pk);
            this.deleteTaxCalTable(ctx, column);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void deleteTaxCalTable(Context ctx, String column) throws BOSException {
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxCalInitDetail");
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxCalInitSum");
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxCalConfigDetail");
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxCalConfigResult");
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxCalTaskDetail");
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxCalConfigSum");
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxDeclareRecord");
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxCalInitDetailHis");
        this.doDeletecTaxCalTable(ctx, column, "T_HR_STaxCalConfigDetailHis");
    }

    private void doDeletecTaxCalTable(Context ctx, String column, String tableName) throws BOSException {
        String ddl = "alter table " + tableName + " drop column " + column;
        DbUtil.execute((Context)ctx, (String)ddl);
    }
}

