/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.schemeconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.timepiece.TimepieceException;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeType;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeFactory;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.AbstractStandardTableConfigControllerBean;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.StandardTableConfigCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.StandardTableConfigEntryCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.StandardTableConfigEntryInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.StandardTableConfigFactory;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.StandardTableConfigInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.BusinessRelationConfigCollection;
import com.kingdee.shr.validaterule.BusinessRelationConfigFactory;
import com.kingdee.shr.validaterule.BusinessRelationConfigInfo;
import com.kingdee.shr.validaterule.BusinessSchemeType;
import com.kingdee.shr.validaterule.CalFlag;
import com.kingdee.shr.validaterule.FormulaType;
import com.kingdee.shr.validaterule.IBaseFormula;
import com.kingdee.shr.validaterule.IBusinessRelationConfig;
import com.kingdee.shr.validaterule.IsCalFormula;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableInfo;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableResultCollection;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableResultFactory;
import com.kingdee.shr.validaterule.app.datatable.DataStagTableResultInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;

public class StandardTableConfigControllerBean
extends AbstractStandardTableConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.timepiece.schemeconfig.StandardTableConfigControllerBean");

    @Override
    protected String _saveStandardTableConfig(Context ctx, Map param) throws BOSException, EASBizException {
        String deleteRowId = MapUtils.getString((Map)param, (Object)"deleteRowId");
        String timepieceSchemeId = MapUtils.getString((Map)param, (Object)"timepieceSchemeId");
        String config = MapUtils.getString((Map)param, (Object)"config");
        Map<String, String> formulaRel = this.getEntryId2FormulaIdRel(ctx, timepieceSchemeId);
        CoreBaseCollection standardTableConfigCollection = this.buildStandardTableConfigCollection(timepieceSchemeId, config);
        if (!standardTableConfigCollection.isEmpty()) {
            this.beforeSave(ctx, standardTableConfigCollection);
            StandardTableConfigFactory.getLocalInstance(ctx).saveBatchData(standardTableConfigCollection);
        }
        this.deleteRowByConfigId(ctx, deleteRowId);
        this.generateFormulaByEntryConfig(ctx, timepieceSchemeId, formulaRel);
        return null;
    }

    protected Map<String, String> getEntryId2FormulaIdRel(Context ctx, String timepieceSchemeId) throws BOSException {
        String oql = "select entry.id, entry.formula where timepieceScheme.id = '" + timepieceSchemeId + "'";
        StandardTableConfigCollection collection = StandardTableConfigFactory.getLocalInstance(ctx).getStandardTableConfigCollection(oql);
        HashMap formulaRel = Maps.newHashMap();
        for (int i = 0; i < collection.size(); ++i) {
            StandardTableConfigEntryCollection entries = collection.get(i).getEntry();
            for (int j = 0; j < entries.size(); ++j) {
                StandardTableConfigEntryInfo info = entries.get(j);
                formulaRel.put(info.getId().toString(), info.getFormula());
            }
        }
        return formulaRel;
    }

    protected CoreBaseCollection buildStandardTableConfigCollection(String timepieceSchemeId, String config) {
        CoreBaseCollection standardTableConfigCollection = new CoreBaseCollection();
        if (StringUtils.isEmpty((String)config)) {
            logger.info((Object)"method : buildStandardTableConfigCollection ,config is empty!");
            return standardTableConfigCollection;
        }
        JSONArray elementJSONArray = JSONArray.parseArray((String)config);
        for (int index = 0; index < elementJSONArray.size(); ++index) {
            JSONObject elementJSON = elementJSONArray.getJSONObject(index);
            if (!this.validateJSON(elementJSON)) continue;
            standardTableConfigCollection.add((CoreBaseInfo)this.assembleStandardTableConfigInfo(timepieceSchemeId, elementJSON, index));
        }
        return standardTableConfigCollection;
    }

    protected boolean validateJSON(JSONObject elementJSON) {
        if (!elementJSON.containsKey((Object)"dataStagTable") || elementJSON.getJSONObject("dataStagTable") == null) {
            logger.error((Object)("elementJSON : " + elementJSON.toJSONString() + " dataStagTable is empty!"));
            return false;
        }
        if (!elementJSON.containsKey((Object)"entry") || elementJSON.getJSONArray("entry").isEmpty()) {
            logger.error((Object)("elementJSON : " + elementJSON.toJSONString() + " entry is empty!"));
            return false;
        }
        return true;
    }

    protected StandardTableConfigInfo assembleStandardTableConfigInfo(String timepieceSchemeId, JSONObject elementJSON, int index) {
        String configId = elementJSON.getString("configId");
        StandardTableConfigInfo standardTableConfigInfo = new StandardTableConfigInfo();
        BOSObjectType bosType = standardTableConfigInfo.getBOSType();
        if (!StringUtils.isEmpty((String)configId)) {
            standardTableConfigInfo.setId(BOSUuid.read((String)configId));
        } else {
            standardTableConfigInfo.setId(BOSUuid.create((BOSObjectType)bosType));
        }
        standardTableConfigInfo.setIndex(index);
        TimepieceSchemeInfo timepieceSchemeInfo = new TimepieceSchemeInfo();
        timepieceSchemeInfo.setId(BOSUuid.read((String)timepieceSchemeId));
        standardTableConfigInfo.setTimepieceScheme(timepieceSchemeInfo);
        this.assembleRelationAttr(elementJSON, standardTableConfigInfo);
        return standardTableConfigInfo;
    }

    protected void assembleRelationAttr(JSONObject elementJSON, StandardTableConfigInfo standardTableConfigInfo) {
        JSONObject dataStagTable = elementJSON.getJSONObject("dataStagTable");
        JSONArray entry = elementJSON.getJSONArray("entry");
        DataStagTableInfo dataStagTableInfo = new DataStagTableInfo();
        dataStagTableInfo.setId(BOSUuid.read((String)dataStagTable.getString("id")));
        standardTableConfigInfo.setDataStagTable(dataStagTableInfo);
        StandardTableConfigEntryCollection standardTableConfigEntryCollection = new StandardTableConfigEntryCollection();
        for (int i = 0; i < entry.size(); ++i) {
            JSONObject jsonObject = entry.getJSONObject(i);
            StandardTableConfigEntryInfo standardTableConfigEntryInfo = new StandardTableConfigEntryInfo();
            CalSubmitItemInfo submitItem = new CalSubmitItemInfo();
            submitItem.setId(BOSUuid.read((String)jsonObject.getJSONObject("submitItem").getString("id")));
            DataStagTableResultInfo dataStagTableResult = new DataStagTableResultInfo();
            dataStagTableResult.setId(BOSUuid.read((String)jsonObject.getJSONObject("dataStagTableRes").getString("id")));
            standardTableConfigEntryInfo.setStandardTableConfig(standardTableConfigInfo);
            standardTableConfigEntryInfo.setSubmitItem(submitItem);
            standardTableConfigEntryInfo.setDataStagTableRes(dataStagTableResult);
            if (!StringUtils.isEmpty((String)jsonObject.getString("id"))) {
                standardTableConfigEntryInfo.setId(BOSUuid.read((String)jsonObject.getString("id")));
            }
            standardTableConfigEntryCollection.add(standardTableConfigEntryInfo);
        }
        standardTableConfigInfo.put("entry", (Object)standardTableConfigEntryCollection);
    }

    protected void beforeSave(Context ctx, CoreBaseCollection standardTableConfigCollection) throws BOSException, EASBizException {
        for (int i = 0; i < standardTableConfigCollection.size(); ++i) {
            StandardTableConfigInfo standardTableConfigInfo = (StandardTableConfigInfo)standardTableConfigCollection.get(i);
            List<String> dsTableResult = this.queryDsTableResult(ctx, standardTableConfigInfo.getDataStagTable());
            this.beforeVerify(ctx, dsTableResult, standardTableConfigInfo);
        }
    }

    protected List<String> queryDsTableResult(Context ctx, DataStagTableInfo dataStagTableInfo) throws BOSException {
        ArrayList dsTableResult = Lists.newArrayList();
        try {
            String queryItemSql = "select distinct FID from T_HR_SDSTableResult where FDataTableID = '" + dataStagTableInfo.getId().toString() + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryItemSql);
            while (rs.next()) {
                dsTableResult.add(rs.getString("FID"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return dsTableResult;
    }

    protected void beforeVerify(Context ctx, List<String> dsTableResult, StandardTableConfigInfo standardTableConfigInfo) throws EASBizException, BOSException {
        this.verifyDataStagTableRes(ctx, dsTableResult, standardTableConfigInfo.getEntry());
    }

    protected void verifyDataStagTableRes(Context ctx, List<String> dsTableResult, StandardTableConfigEntryCollection entryCollection) throws EASBizException, BOSException {
        Set<Object> errData = Sets.newHashSet();
        for (int i = 0; i < entryCollection.size(); ++i) {
            StandardTableConfigEntryInfo standardTableConfigEntryInfo = entryCollection.get(i);
            String dataStagTableResId = standardTableConfigEntryInfo.getDataStagTableRes().getId().toString();
            if (dsTableResult.contains(dataStagTableResId)) continue;
            errData.add(dataStagTableResId);
        }
        if (!errData.isEmpty()) {
            Map<String, String> itemId2NameMap = this.queryDataStagResName(ctx, errData);
            errData = errData.stream().map(itemId2NameMap::get).collect(Collectors.toSet());
            throw new TimepieceException(TimepieceException.EXCEPTION6, new String[]{CmpStrUtil.join(errData, ",", null)});
        }
    }

    protected Map<String, String> queryDataStagResName(Context ctx, Set<String> errData) throws BOSException {
        HashMap id2NameMap = Maps.newHashMap();
        DataStagTableResultCollection dataStagTableResultCollection = DataStagTableResultFactory.getLocalInstance((Context)ctx).getDataStagTableResultCollection("select id, number where id in (" + CmpStrUtil.convertSetToSqlString(errData) + ")");
        for (int i = 0; i < dataStagTableResultCollection.size(); ++i) {
            DataStagTableResultInfo dataStagTableResultInfo = dataStagTableResultCollection.get(i);
            id2NameMap.put(dataStagTableResultInfo.getId().toString(), dataStagTableResultInfo.getNumber());
        }
        return id2NameMap;
    }

    protected void deleteRowByConfigId(Context ctx, String deleteRowId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)deleteRowId)) {
            return;
        }
        String[] ids = deleteRowId.split(",");
        CmpInSql<String> instance = CmpInSqlFactory.getInstance();
        String createInSqlBaseOnFId = instance.createInSqlBaseOnFId(ctx, Arrays.asList(ids));
        StandardTableConfigFactory.getLocalInstance(ctx).delete("where id in " + createInSqlBaseOnFId);
        instance.release(ctx);
    }

    protected void generateFormulaByEntryConfig(Context ctx, String timepieceSchemeId, Map<String, String> formulaRel) throws BOSException, EASBizException {
        TimepieceSchemeInfo timepieceSchemeInfo = TimepieceSchemeFactory.getLocalInstance(ctx).getTimepieceSchemeInfo((IObjectPK)new ObjectUuidPK(timepieceSchemeId));
        String submitSchemeId = timepieceSchemeInfo.getSubmitScheme().getId().toString();
        this.deleteCardRelFormula(ctx, timepieceSchemeId, submitSchemeId, formulaRel);
        String oql = "select dataStagTable.number, entry.dataStagTableRes.number, entry.submitItem.name, entry.submitItem.fieldSn, entry.submitItem.dataType, entry.id, entry.formula where timepieceScheme.id = '" + timepieceSchemeId + "'";
        StandardTableConfigCollection standardTableConfigColl = StandardTableConfigFactory.getLocalInstance(ctx).getStandardTableConfigCollection(oql);
        if (standardTableConfigColl.isEmpty()) {
            return;
        }
        HashMap updateEntryFormulaMap = Maps.newHashMap();
        SchemeType schemeType = timepieceSchemeInfo.getSchemeType();
        String entryTableName = SchemeType.DAILY_SUM == schemeType ? "T_HR_TimepieceSumBillEntry" : "T_HR_TimepieceBillEntry";
        for (int index = 0; index < standardTableConfigColl.size(); ++index) {
            StandardTableConfigInfo standardTableConfigInfo = standardTableConfigColl.get(index);
            StandardTableConfigEntryCollection standardTableConfigInfoEntry = standardTableConfigInfo.getEntry();
            String stagTableNumber = standardTableConfigInfo.getDataStagTable().getNumber();
            for (int i = 0; i < standardTableConfigInfoEntry.size(); ++i) {
                StandardTableConfigEntryInfo entryInfo = standardTableConfigInfoEntry.get(i);
                String formulaId = entryInfo.getFormula();
                String stagTableResItemNumber = entryInfo.getDataStagTableRes().getNumber();
                String submitItem = entryInfo.getSubmitItem().getName();
                CalSubmitItemDataType dataType = entryInfo.getSubmitItem().getDataType();
                int fieldSn = entryInfo.getSubmitItem().getFieldSn();
                FormulaConfig formulaConfig = new FormulaConfig(ctx, entryTableName, dataType, submitItem, stagTableNumber, stagTableResItemNumber, fieldSn);
                BaseFormulaInfo baseFormulaInfo = this.buildBaseFormulaInfo(ctx, submitSchemeId, submitItem, formulaConfig, formulaId);
                this.saveBusinessRelationConfig(ctx, baseFormulaInfo);
                IBaseFormula iBaseFormula = BaseFormulaFactory.getLocalInstance((Context)ctx);
                formulaId = String.valueOf(iBaseFormula.save((CoreBaseInfo)baseFormulaInfo));
                updateEntryFormulaMap.put(entryInfo.getId().toString(), formulaId);
            }
        }
        this.updateCardRelFormula(ctx, updateEntryFormulaMap);
    }

    protected void deleteCardRelFormula(Context ctx, String timepieceSchemeId, String submitSchemeId, Map<String, String> formulaRel) throws BOSException {
        Map<String, String> checkFormulaRel = this.getEntryId2FormulaIdRel(ctx, timepieceSchemeId);
        String deleteSql = "delete from T_HR_SBaseFormula where FID = ?";
        ArrayList needDelIds = Lists.newArrayList();
        for (Map.Entry<String, String> entry : formulaRel.entrySet()) {
            if (checkFormulaRel.containsKey(entry.getKey())) continue;
            needDelIds.add(new Object[]{entry.getValue()});
        }
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, (List)needDelIds);
        String delBusSql = "delete from T_HR_SBusinessRelationConfig bu where bu.FBusinessId = '" + submitSchemeId + "' and not exists (select 1 from T_HR_SBaseFormula where bu.fid =FBusinessRelationConfigID)";
        DbUtil.execute((Context)ctx, (String)delBusSql);
    }

    protected void updateCardRelFormula(Context ctx, Map<String, String> updateEntryFormulaMap) throws BOSException {
        String updateSql = "update T_HR_StandardTableConfigEntry set FFormulaID = ? where FID = ?";
        ArrayList param = Lists.newArrayList();
        for (Map.Entry<String, String> entry : updateEntryFormulaMap.entrySet()) {
            param.add(new Object[]{entry.getValue(), entry.getKey()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, (List)param);
    }

    protected BaseFormulaInfo buildBaseFormulaInfo(Context ctx, String submitSchemeId, String submitItem, FormulaConfig formulaConfig, String formulaId) {
        BaseFormulaInfo baseFormulaInfo = new BaseFormulaInfo();
        if (!StringUtils.isEmpty((String)formulaId)) {
            baseFormulaInfo.setId(BOSUuid.read((String)formulaId));
        } else {
            baseFormulaInfo.setIsCal(IsCalFormula.YES);
        }
        BusinessRelationConfigInfo businessRelationConfigInfo = new BusinessRelationConfigInfo();
        businessRelationConfigInfo.setBusinessId(BOSUuid.read((String)submitSchemeId));
        businessRelationConfigInfo.setType(BusinessSchemeType.SubmitSchemePlan);
        baseFormulaInfo.setBusinessRelationConfig(businessRelationConfigInfo);
        String name = EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.TimepieceSchemeResource", (String)"label0", (Locale)ctx.getLocale());
        baseFormulaInfo.setName(submitItem + name);
        baseFormulaInfo.setContent(formulaConfig.content);
        baseFormulaInfo.setHtmlContent(formulaConfig.htmlContent);
        baseFormulaInfo.setSortSn(-1);
        baseFormulaInfo.setIsPreset(false);
        baseFormulaInfo.setFormulaType(FormulaType.Auto);
        baseFormulaInfo.setIsEditable(CalFlag.NO);
        baseFormulaInfo.setDescription("");
        baseFormulaInfo.setExpress(formulaConfig.express);
        baseFormulaInfo.setListItem(formulaConfig.listItem);
        baseFormulaInfo.setListFunc(formulaConfig.listFunc);
        baseFormulaInfo.setCalItem(formulaConfig.calItem);
        baseFormulaInfo.setBigExpress(formulaConfig.bigExpress);
        return baseFormulaInfo;
    }

    private void saveBusinessRelationConfig(Context ctx, BaseFormulaInfo baseFormulaInfo) throws BOSException, EASBizException {
        String oql = "select id where businessId = '" + baseFormulaInfo.getBusinessRelationConfig().getBusinessId().toString() + "'";
        IBusinessRelationConfig iBusinessRelationConfig = BusinessRelationConfigFactory.getLocalInstance((Context)ctx);
        BusinessRelationConfigCollection businessRelationConfigCollection = iBusinessRelationConfig.getBusinessRelationConfigCollection(oql);
        if (businessRelationConfigCollection.size() == 0) {
            IObjectPK businessRelId = iBusinessRelationConfig.save((CoreBaseInfo)baseFormulaInfo.getBusinessRelationConfig());
            baseFormulaInfo.getBusinessRelationConfig().setId(BOSUuid.read((String)businessRelId.toString()));
        } else {
            baseFormulaInfo.setBusinessRelationConfig(businessRelationConfigCollection.get(0));
        }
    }

    static class FormulaConfig {
        String content;
        String htmlContent;
        String express;
        String listFunc;
        String bigExpress;
        String calItem;
        String listItem;

        public FormulaConfig(Context ctx, String entryTableName, CalSubmitItemDataType dataType, String submitItem, String stagTableNumber, String stagTableResItemNumber, int fieldSn) {
            String formulaName1 = EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.TimepieceSchemeResource", (String)"label1", (Locale)ctx.getLocale());
            String formulaName2 = EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.TimepieceSchemeResource", (String)"label2", (Locale)ctx.getLocale());
            if (CalSubmitItemDataType.number == dataType) {
                this.content = submitItem + " = " + formulaName1 + "(" + formulaName2 + "(\"" + stagTableNumber + "\" ,\"" + stagTableResItemNumber + "\"))";
                this.htmlContent = "<p><span style=\"color: red;\">" + submitItem + "</span><span style=\"color: black;\">&nbsp;=&nbsp;</span><span style=\"color: #04B4AE;\">" + formulaName1 + "(<span style=\"color: #04B4AE;\">" + formulaName2 + "(&quot;" + stagTableNumber + "&quot; ,&quot;" + stagTableResItemNumber + "&quot;)</span>)</span></span></p>";
                this.express = entryTableName + "_S" + fieldSn + "=FunStrToNum(FunGetDataStagTableData(\"" + stagTableNumber + "\",\"" + stagTableResItemNumber + "\"));";
                this.listFunc = "0~MtydD9s3S46FKGyjpfIeUSQBOWg=~FunStrToNum;1~d74XZ9oHQC6tob4QLQViziQBOWg=~FunGetDataStagTableData";
                this.bigExpress = entryTableName + "_S" + fieldSn + "=getBigVal(FunStrToNum(FunGetDataStagTableData(\"" + stagTableNumber + "\",\"" + stagTableResItemNumber + "\")));";
                this.listItem = "double~" + entryTableName + "~S" + fieldSn;
            } else {
                this.content = submitItem + " = " + formulaName2 + "(\"" + stagTableNumber + "\" ,\"" + stagTableResItemNumber + "\")";
                this.htmlContent = "<p><span style=\"color: red;\">" + submitItem + "</span><span style=\"color: black;\">&nbsp;=&nbsp;</span>" + formulaName2 + "(&quot;" + stagTableNumber + "&quot; ,&quot;" + stagTableResItemNumber + "&quot;)</p>";
                this.express = entryTableName + "_S" + fieldSn + "=FunGetDataStagTableData(\"" + stagTableNumber + "\",\"" + stagTableResItemNumber + "\");";
                this.listFunc = "1~d74XZ9oHQC6tob4QLQViziQBOWg=~FunGetDataStagTableData";
                this.bigExpress = entryTableName + "_S" + fieldSn + "=FunGetDataStagTableData(\"" + stagTableNumber + "\",\"" + stagTableResItemNumber + "\");";
                this.listItem = "String~" + entryTableName + "~S" + fieldSn;
            }
            this.calItem = "S" + fieldSn;
        }
    }
}

