/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.exception.BudgetEASBizException;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BudgetTemplateCheckService {
    private Map<String, Integer> dataDotMap;

    public void checkBeforeBatchHandle(Context ctx, String id, String methodName) throws BOSException, EASBizException {
        Map<String, Object> map = this.getStateVal(ctx, id);
        if ("enable".equals(methodName)) {
            Integer stateVal = (Integer)map.get("stateVal");
            if (1 == stateVal) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION0);
            }
            Integer budgetPeriod = (Integer)map.get("budgetPeriod");
            this.checkHasBudgetItem(ctx, id, budgetPeriod);
            this.checkStandingBookItem(ctx, id);
            this.checkSchemeDeductConfig(ctx, id, budgetPeriod);
        } else if ("disable".equals(methodName)) {
            Integer stateVal = (Integer)map.get("stateVal");
            if (2 == stateVal) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION2);
            }
            this.checkTemplateScheme(ctx, id);
        }
    }

    protected void checkSchemeDeductConfig(Context ctx, String id, Integer budgetPeriod) throws BOSException, EASBizException {
        if (1 == budgetPeriod || 2 == budgetPeriod || 3 == budgetPeriod) {
            Iterator iterator;
            String l = LocaleUtils.getShortCode((Locale)ctx.getLocale());
            String sqlBuilder = " SELECT  b.Fname_" + l + " as itemName,  s.Fname_" + l + " as schemeName  FROM T_HR_SSchemeDeduConfig d  inner join T_HR_SCalSubmitScheme s on s.fid= d.FCalSubmitSchemeID  left join T_HR_SBudgetTemplateItem ti on ti.FBudgetItemID = d.FCmpBudgetItemID and ti.FTemplateID = s.FBudgetTemplateID  left join T_HR_SCmpBudgetItem b on b.FID = d.FCmpBudgetItemID  where s.FBudgetTemplateID = ? and  ti.FTemplateID = ? and ( ti.FIsSubBudgetAssign = 0 or ti.FIsSubBudgetAssign  is null ) ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder, (Object[])new Object[]{id, id});
            HashMap<String, HashSet<String>> itemMap = new HashMap<String, HashSet<String>>();
            try {
                while (rowSet.next()) {
                    String itemName = rowSet.getString("itemName");
                    String schemeName = rowSet.getString("schemeName");
                    HashSet<String> submitNameSet = (HashSet<String>)itemMap.get(itemName);
                    if (submitNameSet == null) {
                        submitNameSet = new HashSet<String>();
                    }
                    submitNameSet.add(schemeName);
                    itemMap.put(itemName, submitNameSet);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            if (!itemMap.isEmpty() && (iterator = itemMap.entrySet().iterator()).hasNext()) {
                Map.Entry next = iterator.next();
                String key = (String)next.getKey();
                Set value = (Set)next.getValue();
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION1, new Object[]{key, value.toString(), key});
            }
        }
    }

    protected void checkTemplateScheme(Context ctx, String id) throws BOSException, EASBizException {
        Date nowDate = new Date();
        String kSqlDate = CmpDateUtil.toKSqlDate(nowDate);
        String sqlBuilder = " select top 1 FState from T_HR_SCmpBudgetScheme t where FTemplateID = ? and not exists (select top 1 FID from T_HR_SCmpBudgetScheme s where s.FID = t.FID and s.Fstate =2 and s.FExpiryDate < " + kSqlDate + ") order by FState asc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder, (Object[])new Object[]{id});
        try {
            if (rowSet.next()) {
                if (1 == rowSet.getInt("FState")) {
                    throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION5);
                }
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION4);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void checkStandingBookItem(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "SELECT FStandingBookItemID,FBalanceLedgerItemID FROM T_HR_SBudgetTemplateSTBItem where FTemplateID = ? ";
        boolean hasData = false;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        try {
            while (rowSet.next()) {
                hasData = true;
                String standingBookItemID = rowSet.getString("FStandingBookItemID");
                String balanceLedgerItemID = rowSet.getString("FBalanceLedgerItemID");
                if (!StringUtils.isEmpty((String)standingBookItemID) && !StringUtils.isEmpty((String)balanceLedgerItemID)) continue;
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION6);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!hasData) {
            throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION38);
        }
    }

    protected void checkHasBudgetItem(Context ctx, String id, Integer budgetPeriod) throws BOSException, EASBizException {
        String msgInfo = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label0", (Locale)ctx.getLocale());
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" SELECT top 1 t.FID  ");
        sqlBuilder.append(" FROM T_HR_SBudgetTemplateItem t ");
        sqlBuilder.append(" inner join T_HR_SCmpBudgetItem b on b.FID = t.FBudgetItemID ");
        sqlBuilder.append(" where t.FTemplateID = ? and b.FDataType = 0 ");
        if (1 == budgetPeriod || 2 == budgetPeriod || 3 == budgetPeriod) {
            sqlBuilder.append(" and t.FIsSubBudgetAssign = ").append(1);
            msgInfo = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label1", (Locale)ctx.getLocale());
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{id});
        boolean hasNext = false;
        try {
            while (rowSet.next()) {
                hasNext = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!hasNext) {
            throw new EASBizException(new NumericExceptionSubItem("CMP_COMMON_INFO", msgInfo));
        }
    }

    protected Map<String, Object> getStateVal(Context ctx, String id) throws BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String getStateSql = "SELECT Fid,FSTATE,FBUDGETPERIOD FROM T_HR_SBudgetTemplate where FID = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getStateSql, (Object[])new Object[]{id});
        try {
            while (rowSet.next()) {
                resultMap.put("stateVal", rowSet.getInt("FSTATE"));
                resultMap.put("budgetPeriod", rowSet.getInt("FBUDGETPERIOD"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    public Map<String, BigDecimal> getBalanceMap4Year(Context ctx, String queryFields, Map<String, String> itemMap, Object[] param) throws BOSException {
        String querySQL = this.getBalanceSQL4Year(queryFields);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL, (Object[])param);
            while (rs.next()) {
                for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                    String field = entry.getValue();
                    BigDecimal balance = rs.getBigDecimal(field);
                    balance = balance == null ? BigDecimal.ZERO : balance;
                    map.put(entry.getKey(), balance.setScale((int)this.dataDotMap.get(field), RoundingMode.HALF_UP));
                }
            }
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
        return map;
    }

    protected String getBalanceSQL4Year(String queryFields) {
        return "select " + queryFields + " from T_HR_SCalSubmitScheme css left join T_HR_SBudgetTemplate budgetTemp on css.FBudgetTemplateID = budgetTemp.fid left join T_HR_SCmpBudgetScheme cbs on budgetTemp.fid = cbs.FTemplateID left join T_BD_Currency crrc on cbs.FCurrencyID = crrc.FID left join T_HR_SBudgetManage bm on cbs.fid = bm.FBudgetSchemeID left join T_ORG_Admin AS adminOrg ON adminOrg.FID = bm.fAdminOrgUnitId left join T_HR_SCmpStandingBook csb on bm.fid = csb.FBudgetManageID where css.fid = ? and bm.FAdminOrgUnitID = ? and bm.FCostTypeID = ? and bm.FBudgetYear = ? and adminOrg.FIsSealUp = 0 ";
    }

    public Map<String, BigDecimal> getBalanceMap4YearTotal(Context ctx, String queryFields, Map<String, String> itemMap, Object[] param) throws BOSException {
        String querySQL = this.getBalanceSQL4YearTotal(queryFields);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL, (Object[])param);
            while (rs.next()) {
                for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                    String key = entry.getKey();
                    String field = entry.getValue();
                    BigDecimal val = map.computeIfAbsent(key, k -> BigDecimal.ZERO);
                    BigDecimal balance = rs.getBigDecimal(field);
                    balance = balance == null ? BigDecimal.ZERO : balance;
                    val = val.add(balance);
                    map.put(key, val.setScale((int)this.dataDotMap.get(field), RoundingMode.HALF_UP));
                }
            }
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
        return map;
    }

    protected String getBalanceSQL4YearTotal(String queryFields) {
        return "select " + queryFields + " from T_HR_SCalSubmitScheme css left join T_HR_SBudgetTemplate budgetTemp on css.FBudgetTemplateID = budgetTemp.fid left join T_HR_SCmpBudgetScheme cbs on budgetTemp.fid = cbs.FTemplateID left join T_BD_Currency crrc on cbs.FCurrencyID = crrc.FID left join T_HR_SBudgetManage bm on cbs.fid = bm.FBudgetSchemeID left join T_ORG_Admin AS adminOrg ON adminOrg.FID = bm.fAdminOrgUnitId left join T_HR_SSubBudgetQuery sbdq on bm.fid = sbdq.FBudgetManageID left join T_HR_SubCmpStandingBook scsb on sbdq.fid = scsb.FSubBudgetQueryID where css.fid = ? and bm.FAdminOrgUnitID = ? and bm.FCostTypeID = ? and bm.FBudgetYear = ? and adminOrg.FIsSealUp = 0 ";
    }

    public Map<String, BigDecimal> getBalanceMap4SubNone(Context ctx, String queryFields, Map<String, String> itemMap, Object[] param) throws BOSException {
        String querySQL = this.getBalanceSQL4SubNone(queryFields);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL, (Object[])param);
            while (rs.next()) {
                for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                    String field = entry.getValue();
                    BigDecimal balance = rs.getBigDecimal(field);
                    balance = balance == null ? BigDecimal.ZERO : balance;
                    map.put(entry.getKey(), balance.setScale((int)this.dataDotMap.get(field), RoundingMode.HALF_UP));
                }
            }
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
        return map;
    }

    protected String getBalanceSQL4SubNone(String queryFields) {
        String now = CmpDateUtil.toKSqlDate(new Date());
        return "select " + queryFields + " from T_HR_SCalSubmitScheme css left join T_HR_SBudgetTemplate budgetTemp on css.FBudgetTemplateID = budgetTemp.fid left join T_HR_SCmpBudgetScheme cbs on budgetTemp.fid = cbs.FTemplateID left join T_BD_Currency crrc on cbs.FCurrencyID = crrc.FID left join T_HR_SBudgetManage bm on cbs.fid = bm.FBudgetSchemeID left join T_ORG_Admin AS adminOrg ON adminOrg.FID = bm.fAdminOrgUnitId left join T_HR_SSubBudgetQuery sbdq on bm.fid = sbdq.FBudgetManageID left join T_HR_SubCmpStandingBook scsb on sbdq.fid = scsb.FSubBudgetQueryID where css.fid = ? and bm.FAdminOrgUnitID = ? and bm.FCostTypeID = ? and bm.FBudgetYear = ? and adminOrg.FIsSealUp = 0  and sbdq.FEffectDate <= " + now + " and sbdq.FExpiryDate >= " + now;
    }

    public Map<String, BigDecimal> getBalanceMap4SubCumulative(Context ctx, String queryFields, Map<String, String> itemMap, Object[] param) throws BOSException {
        String querySQL = this.getBalanceSQL4Sub(queryFields);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        Date now = new Date();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL, (Object[])param);
            while (rs.next()) {
                for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                    String key = entry.getKey();
                    String field = entry.getValue();
                    BigDecimal val = map.computeIfAbsent(key, k -> BigDecimal.ZERO);
                    if (now.compareTo(rs.getDate("FEffectDate")) >= 0) {
                        BigDecimal balance = rs.getBigDecimal(field);
                        balance = balance == null ? BigDecimal.ZERO : balance;
                        val = val.add(balance);
                    }
                    map.put(key, val.setScale((int)this.dataDotMap.get(field), RoundingMode.HALF_UP));
                }
            }
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
        return map;
    }

    protected String getBalanceSQL4Sub(String queryFields) {
        return "select " + queryFields + ", sbdq.FEffectDate, sbdq.FExpiryDate from T_HR_SCalSubmitScheme css left join T_HR_SBudgetTemplate budgetTemp on css.FBudgetTemplateID = budgetTemp.fid left join T_HR_SCmpBudgetScheme cbs on budgetTemp.fid = cbs.FTemplateID left join T_BD_Currency crrc on cbs.FCurrencyID = crrc.FID left join T_HR_SBudgetManage bm on cbs.fid = bm.FBudgetSchemeID left join T_ORG_Admin AS adminOrg ON adminOrg.FID = bm.fAdminOrgUnitId left join T_HR_SSubBudgetQuery sbdq on bm.fid = sbdq.FBudgetManageID left join T_HR_SubCmpStandingBook scsb on sbdq.fid = scsb.FSubBudgetQueryID where css.fid = ? and bm.FAdminOrgUnitID = ? and bm.FCostTypeID = ? and bm.FBudgetYear = ? and adminOrg.FIsSealUp = 0 order by sbdq.FEffectDate";
    }

    public Map<String, Integer> getDataDotMap() {
        return this.dataDotMap;
    }

    public void setDataDotMap(Map<String, Integer> dataDotMap) {
        this.dataDotMap = dataDotMap;
    }
}

