/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.TaxDeclareStatusEnum;
import com.kingdee.shr.compensation.app.entity.taxdeclar.TaxDeclarResultDataVO;
import com.kingdee.shr.compensation.app.entity.taxdeclar.TaxDeclarResultVO;
import com.kingdee.shr.compensation.app.entity.taxdeclar.TaxDeclarTbTypeDataVO;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarCollection;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarInfo;
import com.kingdee.shr.compensation.app.taxCal.ITaxServiceTaskFacade;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpTaxUtil;
import com.kingdee.shr.compensation.util.SHRStringUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxReportService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(TaxReportService.class);
    private static final String SPECIAL_ERROR_INFO = "\u7533\u62a5\u8868\u4e0d\u662f[\u672a\u7533\u62a5][\u5f85\u7533\u62a5][\u7533\u62a5\u5931\u8d25]\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u7533\u62a5\u3002";

    @Override
    public boolean isData4Resolving(String code) {
        return true;
    }

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        String message;
        String taskId = taskInfo.getId().toString();
        IncomeTaxDeclarInfo declareInfo = this.getDeclareInfo(ctx, taskId);
        if (null == declareInfo) {
            logger.error((Object)("cannot find IncomeTaxDeclareInfo by taskId: " + taskId));
            return;
        }
        this.updateTaxDeclareOtherId(ctx, taskId, declareInfo, null);
        TaxDeclarResultVO taxDeclarResultVO = (TaxDeclarResultVO)JSON.parseObject((String)response, TaxDeclarResultVO.class);
        TaxDeclarResultDataVO data = taxDeclarResultVO.getData();
        TaxDeclarTbTypeDataVO ykyjsbjg = data.getYkyjsbjg();
        TaxDeclarTbTypeDataVO flsdsbjg = data.getFlsdsbjg();
        TaxDeclarTbTypeDataVO fjmsbjg = data.getFjmsbjg();
        String ykyjsbErrinfo = ykyjsbjg.getErrorinfo();
        String flsdsbErrinfo = flsdsbjg.getErrorinfo();
        String fjmsbErrorinfo = fjmsbjg.getErrorinfo();
        String code = taxDeclarResultVO.getCode();
        boolean success = true;
        if ("0000".equals(code)) {
            message = "\u4e2a\u7a0e\u7533\u62a5\u5b8c\u6210";
        } else {
            success = false;
            message = this.constructErrorInfo(taxDeclarResultVO, ykyjsbErrinfo, flsdsbErrinfo, fjmsbErrorinfo);
            if (!this.isHasSpecialErrorInfo(flsdsbErrinfo, ykyjsbErrinfo, flsdsbErrinfo)) {
                this.handleFailedTaxDeclare(ctx, taskId, message, declareInfo);
                try {
                    this.sendMsgForTaxReport(ctx, taskId, declareInfo, TaxDeclareStatusEnum.DECLARE_FAIL);
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        TaxCalTaskFactory.getLocalInstance(ctx).updateStateMsgById(taskId, success ? TaxCalTaskStateEnum.FINISHED : TaxCalTaskStateEnum.FAIDED, message);
        this.createFeedbackTask(ctx, taskInfo, declareInfo, declareInfo.getYearMonth(), message, success);
    }

    private void createFeedbackTask(Context ctx, TaxCalTaskInfo taskInfo, IncomeTaxDeclarInfo declarInfo, String yearMonth, String message, boolean success) throws BOSException {
        HashMap<String, Object> pramaMap = new HashMap<String, Object>();
        pramaMap.put("acceptId", taskInfo.getAccept_id());
        pramaMap.put("taskInfo", taskInfo);
        pramaMap.put("declarInfo", declarInfo);
        pramaMap.put("taxUnitId", declarInfo.getTaxUnit().getId().toString());
        pramaMap.put("yearMonth", yearMonth);
        pramaMap.put("message", message);
        this.handleSuccessScene(ctx, pramaMap, success);
    }

    private void handleFailedTaxDeclare(Context ctx, String taskId, String message, IncomeTaxDeclarInfo declarInfo) throws BOSException {
        try {
            TaxCalTaskFactory.getLocalInstance(ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FAIDED, message);
            declarInfo.setDeclareStatus(TaxDeclareStatusEnum.getEnum("3"));
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("declareStatus"));
            IncomeTaxDeclarFactory.getLocalInstance(ctx).updatePartial(declarInfo, selectorItemCollection);
            String tbTypeVal = declarInfo.getTbType().getValue();
            String incomeItemInId = CmpTaxUtil.genIncomeItemId(ctx, tbTypeVal);
            this.updateTaxDeclareRecordStatus(ctx, tbTypeVal, declarInfo.getTaxUnit().getId().toString(), incomeItemInId, declarInfo.getYearMonth(), "3");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void updateTaxDeclareRecordStatus(Context ctx, String tbTypeVal, String taxUnitId, String incomeItemInId, String yearMonth, String decalreStatusVal) throws BOSException {
        StringBuilder updateBuffer = new StringBuilder();
        updateBuffer.append(" UPDATE T_HR_STaxDeclareRecord SET FdeclareStatus='").append(decalreStatusVal).append("'");
        updateBuffer.append(" WHERE FtaxUnitId = '").append(taxUnitId).append("' ");
        if ("1".equals(tbTypeVal)) {
            updateBuffer.append(" and FIsPersonal=0 ");
        } else if ("3".equals(tbTypeVal)) {
            updateBuffer.append(" and FIsPersonal=1 ");
        }
        updateBuffer.append(" and FINCOMEITEMID in  ");
        updateBuffer.append(incomeItemInId);
        updateBuffer.append(" and ");
        updateBuffer.append(CmpSQLUtil.generateSqlDateFilter("FPeriodBegin", "FPeriodEnd", yearMonth));
        DbUtil.execute((Context)ctx, (String)updateBuffer.toString());
    }

    protected void handleSuccessScene(Context ctx, Map<String, Object> pramaMap, boolean success) throws BOSException {
        String acceptId = (String)pramaMap.get("acceptId");
        TaxCalTaskInfo taskInfo = (TaxCalTaskInfo)pramaMap.get("taskInfo");
        IncomeTaxDeclarInfo declarInfo = (IncomeTaxDeclarInfo)pramaMap.get("declarInfo");
        String taxUnitId = (String)pramaMap.get("taxUnitId");
        String yearMonth = (String)pramaMap.get("yearMonth");
        String message = (String)pramaMap.get("message");
        ITaxServiceTaskFacade iTaxServiceTaskFacade = TaxServiceTaskFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String> requestParamMap = new HashMap<String, String>();
        requestParamMap.put("accept_id", acceptId);
        requestParamMap.put("TAXUNITID", taxUnitId);
        String yearMonthForParam = yearMonth;
        if (yearMonthForParam.contains("-")) {
            yearMonthForParam = yearMonthForParam.replace("-", "");
        }
        requestParamMap.put("sdyf", yearMonthForParam);
        requestParamMap.put("creator", taskInfo.getCreator().getId().toString());
        IObjectPK rebackTaskId = iTaxServiceTaskFacade.addTask(TaxCalTaskCatalogEnum.TaxReportFeedBack, requestParamMap);
        this.updateTaxDeclareOtherId(ctx, acceptId, declarInfo, rebackTaskId);
        TaxCalTaskStateEnum state = success ? TaxCalTaskStateEnum.FINISHED : TaxCalTaskStateEnum.FAIDED;
        TaxCalTaskFactory.getLocalInstance(ctx).updateStateMsgById(taskInfo.getId().toString(), state, message);
    }

    private IncomeTaxDeclarInfo getDeclareInfo(Context ctx, String taskId) throws BOSException {
        String oql = "select id,taxUnit.id,taxUnit.name,yearMonth,declareStatus,tbType,taxRebackTask.id where taxCalTask.id='" + taskId + "'";
        IncomeTaxDeclarCollection declareInfos = IncomeTaxDeclarFactory.getLocalInstance(ctx).getIncomeTaxDeclarCollection(oql);
        if (null == declareInfos || declareInfos.isEmpty()) {
            throw new BOSException("cannot find IncomeTaxDeclareInfo by taskId: " + taskId);
        }
        return declareInfos.get(0);
    }

    private String constructErrorInfo(TaxDeclarResultVO taxDeclarResultVO, String ykyjErrinfo, String flsdErrinfo, String fjmErrinfo) {
        StringBuilder errorMsgBuf = new StringBuilder();
        if (!this.isHasSpecialErrorInfo(ykyjErrinfo, flsdErrinfo, fjmErrinfo)) {
            errorMsgBuf.append(SHRStringUtil.getStr(taxDeclarResultVO.getMsg()));
        }
        if (SHRStringUtil.isNotBlank(ykyjErrinfo)) {
            errorMsgBuf.append(ykyjErrinfo);
        }
        if (SHRStringUtil.isNotBlank(flsdErrinfo)) {
            errorMsgBuf.append(flsdErrinfo);
        }
        if (SHRStringUtil.isNotBlank(fjmErrinfo)) {
            errorMsgBuf.append(fjmErrinfo);
        }
        return errorMsgBuf.toString();
    }

    public boolean isHasSpecialErrorInfo(String ykyjErrinfo, String flsdErrinfo, String fjmErrinfo) {
        return SPECIAL_ERROR_INFO.equalsIgnoreCase(ykyjErrinfo) || SPECIAL_ERROR_INFO.equalsIgnoreCase(flsdErrinfo) || SPECIAL_ERROR_INFO.equalsIgnoreCase(fjmErrinfo);
    }

    private void updateTaxDeclareOtherId(Context ctx, String acceptId, IncomeTaxDeclarInfo declarInfo, IObjectPK rebackTaskId) throws BOSException {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("UPDATE T_HR_SIncomeTaxDeclar SET FAcceptId='");
        sqlBuffer.append(acceptId);
        sqlBuffer.append("'");
        if (rebackTaskId != null && SHRStringUtil.isNotBlank(rebackTaskId.toString())) {
            sqlBuffer.append(" , FTaxRebackTaskID='");
            sqlBuffer.append(rebackTaskId.toString());
            sqlBuffer.append("'");
        }
        sqlBuffer.append(" WHERE FID = '").append(SHRStringUtil.getStr(declarInfo.getId())).append("'");
        CmpSQLUtil.execute(ctx, sqlBuffer.toString());
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String taskId = taskInfo.getId().toString();
        IncomeTaxDeclarInfo declareInfo = this.getDeclareInfo(ctx, taskId);
        declareInfo.setDeclareStatus(TaxDeclareStatusEnum.getEnum("3"));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("declareStatus"));
        String tbTypeVal = declareInfo.getTbType().getValue();
        String incomeItemInId = CmpTaxUtil.genIncomeItemId(ctx, tbTypeVal);
        String yearMonth = declareInfo.getYearMonth();
        String taxUnitId = declareInfo.getTaxUnit().getId().toString();
        try {
            IncomeTaxDeclarFactory.getLocalInstance(ctx).updatePartial(declareInfo, selectorItemCollection);
            this.updateTaxDeclareRecordStatus(ctx, tbTypeVal, taxUnitId, incomeItemInId, yearMonth, "3");
            this.sendMsgForTaxReport(ctx, taskId, declareInfo, TaxDeclareStatusEnum.DECLARE_FAIL);
        }
        catch (EASBizException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        this.createFeedbackTask(ctx, taskInfo, declareInfo, yearMonth, errMsg, false);
    }

    protected void execute(Context ctx, String taskID, String errorMsg) throws BOSException, EASBizException, SQLException {
        IncomeTaxDeclarInfo declarInfo = IncomeTaxDeclarFactory.getLocalInstance(ctx).getIncomeTaxDeclarInfo("select id,taxUnit.id,taxUnit.name,yearMonth,declareStatus,tbType where taxCalTask.id='" + taskID + "'");
        if (declarInfo != null) {
            CmpTaxUtil.handleFailTaxDeclar(ctx, declarInfo);
            this.sendMsgForTaxReport(ctx, taskID, declarInfo, TaxDeclareStatusEnum.DECLARE_FAIL);
        } else {
            logger.error((Object)("cannot find IncomeTaxDeclarInfo by taskId:" + taskID));
        }
    }

    protected void sendMsgForTaxReport(Context ctx, String taskID, IncomeTaxDeclarInfo declarInfo, TaxDeclareStatusEnum taxDeclareStatusEnum) throws BOSException, SQLException {
        String title = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label105", (Locale)ctx.getLocale());
        String msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label106", (Locale)ctx.getLocale());
        String category = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label107", (Locale)ctx.getLocale());
        String sql = "SELECT FCREATORID,FNUMBER FROM T_HR_STaxCalTask where Fid='" + taskID + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String taskCreaterId = "";
        String taskNum = "";
        while (rowSet.next()) {
            taskCreaterId = rowSet.getString("FCREATORID");
            taskNum = rowSet.getString("FNUMBER");
        }
        if (SHRStringUtil.isNotBlank(taskCreaterId) && SHRStringUtil.isNotBlank(taskNum)) {
            title = String.format(title, taskNum);
            msgTemplate = String.format(msgTemplate, declarInfo.getTaxUnit().getName(ctx.getLocale()), declarInfo.getYearMonth(), declarInfo.getTbType().getAlias(ctx.getLocale()), taxDeclareStatusEnum.getAlias(ctx.getLocale()));
            if (TaxDeclareStatusEnum.DECLARE_SUCCESS == taxDeclareStatusEnum) {
                msgTemplate = msgTemplate + "\uff0c\u8bf7\u8fdb\u5165[\u4e2a\u7a0e\u670d\u52a1-\u7a0e\u6b3e\u7f34\u7eb3-\u53d1\u8d77\u7f34\u6b3e]\u64cd\u4f5c";
            }
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, taskCreaterId, title, msgTemplate, category);
        }
    }
}

