/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class CmpDateUtil {
    public static final String TIMESTAMP_FORMAT = "yyyyMMddHHmmss";
    public static final String COMMON_DATE = "yyyy-MM-dd";

    public static Timestamp genCreateTime4Entry() {
        long oneSecond = 1000000L;
        return new Timestamp(System.currentTimeMillis() + oneSecond);
    }

    public static Date str2Date(String str, String format) throws BOSException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            throw new BOSException("Illegal Date format: " + str);
        }
    }

    public static String toKSqlDate(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return "{ts '" + sdf.format(date) + "'}";
        }
        catch (Exception e5) {
            return null;
        }
    }

    public static String toKSqlDate(Date date) {
        return CmpDateUtil.toKSqlDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String toSimpleKSqlData(Date date) {
        return CmpDateUtil.toKSqlDate(date, COMMON_DATE);
    }

    public static Date getAddDate(Date date, int span) {
        if (date == null) {
            return new Date();
        }
        if (span == 0) {
            return date;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, span);
        return cal.getTime();
    }

    public static java.sql.Date toSqlDate(Date date) {
        return new java.sql.Date(date.getTime());
    }

    public static Date getMaxEndDate() {
        try {
            return DateTimeUtils.parseDate((String)"2199-12-31");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getMinBeginDate() {
        try {
            return DateTimeUtils.parseDate((String)"1900-01-01");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getMaxKsqlDate() {
        Date maxEndDate = CmpDateUtil.getMaxEndDate();
        return CmpDateUtil.toKSqlDate(maxEndDate);
    }

    public static Date toDate(Object obj) {
        SimpleDateFormat sdf;
        String[] formatArr;
        Date res = null;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (CmpStrUtil.isEmpty(str)) {
            return null;
        }
        if (str.contains("{ts'") && str.lastIndexOf("'}") != -1) {
            str = str.substring(str.indexOf("ts{'") + 5, str.lastIndexOf("'}"));
        }
        if (!(str.matches("\\d{4}[-|/|.]{1}\\d{1,2}[-|/|.]{1}\\d{1,2}(.*)") || str.matches("(.*)\\d{1,2}:\\d{1,2}:\\d{1,2}(.*)") || obj instanceof Date)) {
            return null;
        }
        for (String s : formatArr = new String[]{COMMON_DATE, "yyyy-M-d", "yyyy/MM/dd", "yyyy/M/d", "yyyy.MM.dd", "yyyy.M.d", "EEE MMM d H:m:s z y"}) {
            sdf = new SimpleDateFormat(s);
            try {
                res = sdf.parse(str);
                break;
            }
            catch (ParseException e) {
            }
        }
        if (null == res) {
            sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyy", Locale.US);
            try {
                res = sdf.parse(str);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return res;
    }

    public static Date getCurrentMonthEndDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getCurrentMonthFirstDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getLastMonthEndDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getMonthEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int lastDay = calendar.getActualMaximum(5);
        calendar.set(5, lastDay);
        return calendar.getTime();
    }

    public static Date getMonthBeginDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static String getDateStr(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(COMMON_DATE);
        return sdf.format(date);
    }

    public static String getDateStr(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static Date parseDate(String dateStr) throws ParseException {
        if (StringUtils.isEmpty((String)dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(COMMON_DATE);
        return sdf.parse(dateStr);
    }

    public static Date parseDate(String dateStr, DateFormat df) {
        if (StringUtils.isEmpty((String)dateStr)) {
            return null;
        }
        try {
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getActualMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        return month + 1;
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static boolean verifyDate(String dateStr) {
        if (StringUtils.isEmpty((String)dateStr)) {
            return false;
        }
        String[] strArr = null;
        if (dateStr.contains("-")) {
            strArr = dateStr.split("-");
        }
        if (dateStr.contains("/")) {
            strArr = dateStr.split("/");
        }
        if (dateStr.contains(".")) {
            strArr = dateStr.split(".");
        }
        if (strArr == null || strArr.length != 3) {
            return false;
        }
        int year = CmpStrUtil.toInt(strArr[0]);
        int month = CmpStrUtil.toInt(strArr[1]);
        int day = CmpStrUtil.toInt(strArr[2]);
        if (month < 1 || month > 12 || day < 1 || day > 31) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        int maxDay = calendar.getActualMaximum(5);
        return day <= maxDay;
    }

    public static Date getAddMonth(Date date, int span) {
        if (date == null) {
            return new Date();
        }
        if (span == 0) {
            return date;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, span);
        return cal.getTime();
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        return nowTime.after(startTime) && nowTime.before(endTime);
    }

    public static List<String> getDatesBetweenTwoDate(String beginDate, String endDate) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(COMMON_DATE);
        Date tempBeginDate = format.parse(beginDate);
        Date tempEndDate = format.parse(endDate);
        ArrayList<String> dateList = new ArrayList<String>();
        dateList.add(beginDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(tempBeginDate);
        if (cal.getTime().after(tempEndDate)) {
            return dateList;
        }
        while (true) {
            cal.add(2, 1);
            if (!tempEndDate.after(cal.getTime())) break;
            dateList.add(format.format(cal.getTime()));
        }
        dateList.add(endDate);
        return dateList;
    }

    public static List<String> changeDateToEnForMat(List<String> list) {
        String[] dateMonth = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        String[] dateENMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        ArrayList<String> dateList = new ArrayList<String>();
        for (String str : list) {
            String[] arr = str.split("-");
            if (arr.length != 2) continue;
            for (int i = 0; i < dateMonth.length; ++i) {
                if (!dateMonth[i].equals(arr[1])) continue;
                str = dateENMonth[i] + " " + arr[0];
                dateList.add(str);
            }
        }
        return dateList;
    }

    public static String changeMonthToEnMonth(String month) {
        String enMonth = "";
        String[] dateMonth = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "01", "02", "03", "04", "05", "06", "07", "08", "09"};
        String[] dateENMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep"};
        for (int i = 0; i < dateMonth.length; ++i) {
            if (!dateMonth[i].equals(month)) continue;
            enMonth = dateENMonth[i];
            break;
        }
        return enMonth;
    }

    public static String changeToMulLanguageMonth(String month, Locale locale) {
        boolean isEnLanTrue = "l1".equalsIgnoreCase(locale.getLanguage());
        if (isEnLanTrue) {
            return CmpDateUtil.changeMonthToEnMonth(month);
        }
        return month;
    }

    public static int getDays(Date start, Date end) throws ParseException {
        if (start == null || end == null) {
            return 0;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(COMMON_DATE);
        start = sdf.parse(sdf.format(start));
        end = sdf.parse(sdf.format(end));
        long span = (start.getTime() - end.getTime()) / 86400000L;
        return (int)span;
    }

    public static java.sql.Date toSqlDate(Object strDate) {
        Date date = CmpDateUtil.toDate(strDate);
        java.sql.Date sqlDate = null;
        if (date != null) {
            sqlDate = new java.sql.Date(date.getTime());
        }
        return sqlDate;
    }

    public static int compareMonth(Date date1, Date date2) {
        Calendar calder = Calendar.getInstance();
        calder.setTime(date1);
        int dateOneMonth = calder.get(1) * 100 + calder.get(2);
        calder.setTime(date2);
        int dateTwoMonth = calder.get(1) * 100 + calder.get(2);
        return Integer.compare(dateOneMonth, dateTwoMonth);
    }

    public static int compare(Date date1, Date date2) throws BOSException {
        if (date1 == null || date2 == null) {
            throw new BOSException("Date can not be null");
        }
        return date1.compareTo(date2);
    }

    public static Integer getDifMonth(Date startDate, Date endDate) {
        Calendar startMonth = Calendar.getInstance();
        Calendar endMonth = Calendar.getInstance();
        startMonth.setTime(startDate);
        endMonth.setTime(endDate);
        int result = endMonth.get(2) - startMonth.get(2);
        int month = (endMonth.get(1) - startMonth.get(1)) * 12;
        return Math.abs(month + result);
    }

    public static Date getPureDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndOfMonth(Date period) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(period);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static boolean isEqualYearAndMonth(Date d1, Date d2) {
        if (d1 != null && d2 != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(d1);
            int year1 = c.get(1);
            int month1 = c.get(2);
            c.setTime(d2);
            int year2 = c.get(1);
            int month2 = c.get(2);
            return year1 == year2 && month1 == month2;
        }
        return false;
    }

    public static boolean isLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5) == calendar.getActualMaximum(5);
    }

    public static int getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static Date setDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, day);
        return calendar.getTime();
    }

    public static boolean isDateCross(long startDate1, long endDate1, long startDate2, long endDate2, boolean isStrict) throws BOSException {
        if (endDate1 < startDate1) {
            throw new BOSException("endDate1 can not less startDate1");
        }
        if (endDate2 < startDate2) {
            throw new BOSException("endDate2 can not less startDate2");
        }
        return isStrict ? endDate1 >= startDate2 && startDate1 <= endDate2 : endDate1 > startDate2 && startDate1 < endDate2;
    }

    public static boolean isDateCross(Date startDate1, Date endDate1, Date startDate2, Date endDate2, boolean isStrict) throws BOSException {
        if (startDate1 == null || endDate1 == null || startDate2 == null || endDate2 == null) {
            throw new BOSException("Date param object can not be null");
        }
        return CmpDateUtil.isDateCross(startDate1.getTime(), endDate1.getTime(), startDate2.getTime(), endDate2.getTime(), isStrict);
    }

    public static Date getUtilDateFromSqlDateWithoutYMS(java.sql.Date sqlDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(sqlDate.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date nowWithoutTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.sql.Date getSqlDate(String date) {
        try {
            return new java.sql.Date(CmpDateUtil.parseDate(date).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

