/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpResignAnalysisReportFacadeControllerBean;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCmpResignAnalysisReportFacadeControllerBean
extends AbstractHRCmpResignAnalysisReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpResignAnalysisReportFacadeControllerBean");

    @Override
    protected Map _getCmpResignAnalysisReport(Context ctx, String paramStr) throws BOSException, EASBizException {
        String[] paramArr = paramStr.split("-");
        String tempTable = paramArr[0];
        String orgId = paramArr[1];
        Map<String, Object> CmpResignReport = this.getCmpResign(ctx, tempTable, orgId);
        return CmpResignReport;
    }

    private Map<String, Object> getCmpResign(Context ctx, String tempTable, String orgId) {
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, null);
        logger.info("~~~~~~ Compensation cmpItem : " + cmpItems);
        Map<String, Object> cmpResignReportMap = this.getCmpResignReport(ctx, cmpItems, tempTable, orgId);
        return cmpResignReportMap;
    }

    private Map<String, Object> getCmpResignReport(Context ctx, String cmpItems, String tempTable, String orgId) {
        HashMap<String, Object> cmpResignMap = new HashMap<String, Object>();
        this.getCmpResignTrendReport(ctx, cmpResignMap, cmpItems, tempTable, orgId);
        return cmpResignMap;
    }

    private void getCmpResignTrendReport(Context ctx, Map<String, Object> cmpResignMap, String cmpItems, String tempTable, String orgId) {
        ArrayList<String> salSecLabels = new ArrayList<String>();
        HashMap salSecMap = new HashMap();
        ArrayList reasonSecList = new ArrayList();
        HashSet<Integer> containSet = new HashSet<Integer>();
        int flag = 0;
        ArrayList<Integer> salaryList = new ArrayList<Integer>();
        ArrayList<Map<String, Object>> reasonList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> reasonsMap = new HashMap<String, String>();
        HashMap reasonGroupMap = new HashMap();
        String len = ctx.getLocale().getLanguage();
        String cmpSectionSql = HRCmpReportUtil.getCmpSection(orgId, ctx.getLocale().getLanguage());
        try {
            HashMap<String, Object> map;
            double maxValue;
            double minValue;
            String label;
            IRowSet rowSet = SqlUtil.executeQuery(ctx, cmpSectionSql);
            while (rowSet.next()) {
                ++flag;
                label = rowSet.getString("flabel_" + len);
                minValue = rowSet.getDouble("fminValue");
                maxValue = rowSet.getDouble("fmaxValue");
                salSecLabels.add(label);
                map = new HashMap<String, Object>();
                map.put("minValue", minValue);
                map.put("maxValue", maxValue);
                salSecMap.put(label, map);
                salaryList.add(0);
            }
            if (flag == 0) {
                cmpSectionSql = HRCmpReportUtil.getCmpSection("00000000-0000-0000-0000-000000000000CCE7AED4", ctx.getLocale().getLanguage());
                rowSet = SqlUtil.executeQuery(ctx, cmpSectionSql);
                while (rowSet.next()) {
                    label = rowSet.getString("flabel_" + len);
                    minValue = rowSet.getDouble("fminValue");
                    maxValue = rowSet.getDouble("fmaxValue");
                    salSecLabels.add(label);
                    map = new HashMap();
                    map.put("minValue", minValue);
                    map.put("maxValue", maxValue);
                    salSecMap.put(label, map);
                    salaryList.add(0);
                }
            }
            String cmpResignSumSql = HRCmpReportUtil.getCmpResignSum(ctx, cmpItems, tempTable);
            rowSet = SqlUtil.executeQuery(ctx, cmpResignSumSql);
            while (rowSet.next()) {
                String reasonname = rowSet.getString("reasonname");
                String reasonnumber = rowSet.getString("reasonnumber");
                String personid = rowSet.getString("personid");
                Double total = rowSet.getDouble("total");
                map = new HashMap();
                map.put("reasonname", reasonname);
                map.put("reasonnumber", reasonnumber);
                map.put("personid", personid);
                map.put("total", total == null ? 0.0 : total);
                reasonsMap.put(reasonname, reasonnumber);
                reasonSecList.add(map);
            }
            for (int i = 0; i < salSecLabels.size(); ++i) {
                String salSecLabel = (String)salSecLabels.get(i);
                Map salMap = (Map)salSecMap.get(salSecLabel);
                double minValue2 = (Double)salMap.get("minValue");
                double maxValue2 = (Double)salMap.get("maxValue");
                for (int j = 0; j < reasonSecList.size(); ++j) {
                    if (containSet.contains(j)) continue;
                    Map itemMap = (Map)reasonSecList.get(j);
                    String reasonName = (String)itemMap.get("reasonname");
                    String personId = (String)itemMap.get("personid");
                    Double total = (Double)itemMap.get("total");
                    ArrayList<Integer> personCountList = (ArrayList<Integer>)reasonGroupMap.get(reasonName);
                    if (personCountList == null) {
                        personCountList = new ArrayList<Integer>(salaryList);
                    }
                    if (total != null && total >= minValue2 && total < maxValue2) {
                        containSet.add(j);
                        if (!StringUtils.isEmpty((CharSequence)personId)) {
                            personCountList.set(i, (Integer)personCountList.get(i) + 1);
                        }
                    }
                    reasonGroupMap.put(reasonName, personCountList);
                }
            }
            for (Map.Entry it : reasonGroupMap.entrySet()) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                itemMap.put("name", it.getKey());
                itemMap.put("number", reasonsMap.get(it.getKey()));
                itemMap.put("data", it.getValue());
                reasonList.add(itemMap);
            }
            this.sortByReasonNumber(reasonList);
            cmpResignMap.put("labelList", salSecLabels);
            cmpResignMap.put("series", reasonList);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void sortByReasonNumber(List<Map<String, Object>> reasonList) {
        Collections.sort(reasonList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                String num1 = (String)o1.get("number");
                String num2 = (String)o2.get("number");
                return num1.compareTo(num2);
            }
        });
    }
}

