/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.jsoup.helper.StringUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpAccountBillState;
import com.kingdee.shr.compensation.CmpItemAccountBillEntryCollection;
import com.kingdee.shr.compensation.CmpItemAccountBillEntryInfo;
import com.kingdee.shr.compensation.CmpItemAccountBillFactory;
import com.kingdee.shr.compensation.CmpItemAccountBillInfo;
import com.kingdee.shr.compensation.CmpItemAccountBillRecordFactory;
import com.kingdee.shr.compensation.CmpItemAccountBillRecordInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.CostBearBillType;
import com.kingdee.shr.compensation.CostBearCalSchemeFactory;
import com.kingdee.shr.compensation.CostBearCalSchemeInfo;
import com.kingdee.shr.compensation.CostBearCalSchemeRecordCollection;
import com.kingdee.shr.compensation.CostBearCalSchemeRecordFactory;
import com.kingdee.shr.compensation.CostBearCalSchemeRecordInfo;
import com.kingdee.shr.compensation.CostBearStateEnum;
import com.kingdee.shr.compensation.app.AbstractXKQJCmpItemAccountBillFacadeControllerBean;
import com.kingdee.shr.compensation.app.XKQJPushBillState;
import com.kingdee.shr.compensation.app.api.xkqjresovler.XKQJBillParam;
import com.kingdee.shr.compensation.app.api.xkqjresovler.XKQJPaymentOrg;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class XKQJCmpItemAccountBillFacadeControllerBean
extends AbstractXKQJCmpItemAccountBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.XKQJCmpItemAccountBillFacadeControllerBean");

    @Override
    protected Map _createCmpItemAccountBill(Context ctx, Map param) throws BOSException, EASBizException {
        XKQJBillParam xkqjBillParam = (XKQJBillParam)param.get("param");
        this.buildAccountBill(ctx, xkqjBillParam);
        this.buildAccountDetail(ctx, xkqjBillParam);
        this.markDistributeState(ctx, xkqjBillParam);
        this.saveCostBearCalScheme(ctx, xkqjBillParam);
        this.addCostBearCalSchemeRecord(ctx, xkqjBillParam);
        return null;
    }

    private void markDistributeState(Context ctx, XKQJBillParam holder) throws BOSException {
        String updateSql = "update T_HR_SCmpSegmCost set FIsDistribute=1 where FID in (select distinct csc.FID from T_HR_SCmpSegmCost csc inner join T_HR_SCBXKQJRec xre on csc.FCMPCALTABLEID = xre.FCmpCalTableId and csc.FCostBearOrgID = xre.FCostBearOrgUnitID inner join " + holder.getPaymentOrgRange() + " range on range.billid = xre.FAccountBillID )";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void addCostBearCalSchemeRecord(Context ctx, XKQJBillParam holder) throws BOSException, EASBizException {
        String billIds;
        CalSchemeInfo calSchemeInfo = holder.getCalSchemeInfo();
        Map<String, XKQJPaymentOrg> billOrgMapping = holder.getBillOrgMapping();
        StringBuffer numbers = new StringBuffer();
        billOrgMapping.forEach((key, value) -> numbers.append(",").append(value.getBillNumber()));
        String oql = "select id, calScheme.id, periodYear, periodMonth, calTime, costBearState, costBearBillType, cmpItemAccoutBills  where calScheme = '" + calSchemeInfo.getId().toString() + "' and periodYear = " + calSchemeInfo.getPeriodYear() + "  and periodMonth = " + calSchemeInfo.getPeriodMonth() + "  and calTime = " + calSchemeInfo.getCalTime();
        CostBearCalSchemeRecordCollection recordCollection = CostBearCalSchemeRecordFactory.getLocalInstance(ctx).getCostBearCalSchemeRecordCollection(oql);
        CostBearCalSchemeRecordInfo recordInfo = null;
        if (recordCollection != null && !recordCollection.isEmpty()) {
            recordInfo = recordCollection.get(0);
        } else {
            recordInfo = new CostBearCalSchemeRecordInfo();
            recordInfo.setId(BOSUuid.create((String)"04806D01"));
            recordInfo.setCalScheme(calSchemeInfo);
            recordInfo.setPeriodYear(calSchemeInfo.getPeriodYear());
            recordInfo.setPeriodMonth(calSchemeInfo.getPeriodMonth());
            recordInfo.setCalTime(calSchemeInfo.getCalTime());
        }
        recordInfo.setCostBearBillType(CostBearBillType.XKQJ);
        String string = billIds = CmpStrUtil.isEmpty(recordInfo.getCmpItemAccoutBills()) ? numbers.substring(1) : recordInfo.getCmpItemAccoutBills() + numbers;
        if (billIds.length() > 4000) {
            billIds = billIds.substring(0, 3999);
        }
        recordInfo.setCmpItemAccoutBills(billIds);
        recordInfo.setCostBearState(CostBearStateEnum.ALL);
        CostBearCalSchemeRecordFactory.getLocalInstance(ctx).save(recordInfo);
    }

    private void saveCostBearCalScheme(Context ctx, XKQJBillParam holder) throws BOSException, EASBizException {
        Map<String, XKQJPaymentOrg> billOrgMapping = holder.getBillOrgMapping();
        CalSchemeInfo calSchemeInfo = holder.getCalSchemeInfo();
        CoreBaseCollection coll = new CoreBaseCollection();
        billOrgMapping.forEach((billId, paymentOrg) -> {
            CostBearCalSchemeInfo costBearCalSchemeInfo = new CostBearCalSchemeInfo();
            costBearCalSchemeInfo.setCalScheme(calSchemeInfo);
            costBearCalSchemeInfo.setPeriodYear(calSchemeInfo.getPeriodYear());
            costBearCalSchemeInfo.setPeriodMonth(calSchemeInfo.getPeriodMonth());
            costBearCalSchemeInfo.setCalTime(calSchemeInfo.getCalTime());
            costBearCalSchemeInfo.setCostBearBillType(CostBearBillType.XKQJ);
            costBearCalSchemeInfo.setXkqjPushBillState(XKQJPushBillState.WAITING);
            CmpItemAccountBillInfo bill = new CmpItemAccountBillInfo();
            bill.setId(BOSUuid.read((String)billId));
            costBearCalSchemeInfo.setCaltableItemAmount(paymentOrg.getAmount());
            costBearCalSchemeInfo.setCmpItemAccountBill(bill);
            coll.add((CoreBaseInfo)costBearCalSchemeInfo);
        });
        CostBearCalSchemeFactory.getLocalInstance(ctx).save(coll);
    }

    private void buildAccountDetail(Context ctx, XKQJBillParam holder) throws BOSException {
        String paymentOrgRange = holder.getPaymentOrgRange();
        CalSchemeInfo calSchemeInfo = holder.getCalSchemeInfo();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sql = "insert into T_HR_SCBXKQJRec(fid,FCurrencyID,FCostbearID,FCostBearOrgUnitID,FHrOrgUnitID,FAdminOrgID,FCalSchemeID,FCmpItemID,FPersonID,FCostBearPerc,FBearMoney,FCostMoney,FCalTime,FPeriodYear,FPeriodMonth,FCostValue,FBearValue,FCmpCalTableId,FAccountBillID,FCREATORID ,FCREATETIME ,FLASTUPDATEUSERID ,FLASTUPDATETIME ,FCONTROLUNITID ) select newbosid('C3BB7D81'),'" + calSchemeInfo.getCurrency().getId() + "',costbear.fid,costbear.FCostBearOrgUnitID,costbear.FHrOrgUnitID,costbear.FAdminOrgID,costbear.FCalSchemeID,costbear.FCmpItemID,costbear.FPersonID,costbear.FCostBearPerc,costbear.FBearMoney,costbear.FCostMoney,costbear.FCalTime,costbear.FPeriodYear,costbear.FPeriodMonth,costbear.FCostValue,costbear.FBearValue,costbear.FCmpCalTableId,range.billid,'" + currentUserInfo.getId() + "',now(),'" + currentUserInfo.getId() + "',now(),costbear.FCONTROLUNITID  from t_hr_scostbear costbear  inner join T_HR_SCmpItem citem on costbear.fcmpitemid = citem.fid and citem.fdataType = 0 inner join " + paymentOrgRange + " range on costbear.FCostBearOrgUnitID = range.orgId  where costbear.fcalschemeid = '" + calSchemeInfo.getId() + "' and costbear.fperiodyear = " + calSchemeInfo.getPeriodYear() + " and costbear.fperiodmonth = " + calSchemeInfo.getPeriodMonth() + " and costbear.fcaltime = " + calSchemeInfo.getCalTime();
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private CoreBaseCollection buildAccountBill(Context ctx, XKQJBillParam holder) throws BOSException, EASBizException {
        String paymentOrgRange = holder.getPaymentOrgRange();
        CalSchemeInfo calSchemeInfo = holder.getCalSchemeInfo();
        Map<String, XKQJPaymentOrg> billOrgMapping = holder.getBillOrgMapping();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sql = "select range.billId,range.orgId,costbear.fcmpitemid,case when sum(costbear.fbearMoney) is null then 0 else sum(costbear.fbearMoney) end as bearMoney  from t_hr_scalscheme scheme inner join t_hr_scostbear costbear on scheme.fid = costbear.fcalschemeid and scheme.FPERIODYEAR = costbear.FPERIODYEAR  and scheme.FPERIODMONTH = costbear.FPERIODMONTH and scheme.FCALTIME = costbear.FCALTIME inner join " + paymentOrgRange + " range on costbear.FCostBearOrgUnitID = range.orgId inner join t_org_admin adminorg on range.orgId = adminorg.FID inner join t_hr_scmpitem citem on costbear.FCMPITEMID = citem.FID and citem.fdataType = 0 inner join t_hr_scalschemeitem schemeitem on scheme.FID = schemeitem.FCALSCHEMEID and schemeitem.FCMPITEMID = citem.FID where scheme.fid = '" + calSchemeInfo.getId() + "'group by range.billId,range.orgId,costbear.fcmpitemid,schemeitem.FSORTSN,citem.FINDEX ,citem.FNUMBER ,adminorg.FSORTCODE ,adminorg.FNUMBER order by range.billId,schemeitem.FSORTSN,citem.FINDEX ,citem.FNUMBER ,adminorg.FSORTCODE ,adminorg.FNUMBER ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        CoreBaseCollection billColl = new CoreBaseCollection();
        TempStats billTempStats = new TempStats();
        CmpItemAccountBillInfo billInfo = null;
        CmpItemAccountBillEntryCollection billEntrys = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection brColl = new CoreBaseCollection();
        try {
            while (rs.next()) {
                XKQJPaymentOrg paymentOrg;
                String billId = rs.getString("billId");
                String orgId = rs.getString("orgId");
                String cmpitemid = rs.getString("fcmpitemid");
                BigDecimal bearMoney = rs.getBigDecimal("bearMoney").setScale(2, RoundingMode.HALF_UP);
                if (billTempStats.tempEqual(billId)) {
                    billTempStats.add(bearMoney);
                    CmpItemAccountBillEntryInfo entryInfo = new CmpItemAccountBillEntryInfo();
                    entryInfo.setId(BOSUuid.create((String)"1167DFB5"));
                    entryInfo.setCmpItemAccountBill(billInfo);
                    AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                    adminOrgUnitInfo.setId(BOSUuid.read((String)orgId));
                    entryInfo.setAdminOrg(adminOrgUnitInfo);
                    CmpItemAccountBillRecordInfo brInfo = new CmpItemAccountBillRecordInfo();
                    brInfo.setCmpItemAccountBillEntry(entryInfo);
                    CmpItemInfo itemInfo = new CmpItemInfo();
                    itemInfo.setId(BOSUuid.read((String)cmpitemid));
                    brInfo.setCmpItem(itemInfo);
                    brInfo.setCmpItemAccountBillEntry(entryInfo);
                    entryInfo.put("cmpItemRecords", brInfo);
                    brColl.add((CoreBaseInfo)brInfo);
                    entryInfo.setAmount(bearMoney);
                    billEntrys.add(entryInfo);
                    continue;
                }
                if (!billTempStats.getCompareString().isEmpty()) {
                    paymentOrg = billOrgMapping.get(billTempStats.getCompareString());
                    paymentOrg.setAmount(billTempStats.getValue());
                    billColl.add((CoreBaseInfo)billInfo);
                }
                billInfo = new CmpItemAccountBillInfo();
                billInfo.setId(BOSUuid.read((String)billId));
                billInfo.setNumber(this.createAccountBillNumber(ctx, billInfo));
                billInfo.setCalScheme(calSchemeInfo);
                billInfo.setPeriodYear(calSchemeInfo.getPeriodYear());
                billInfo.setPeriodMonth(calSchemeInfo.getPeriodMonth());
                billInfo.setCalTime(calSchemeInfo.getCalTime());
                billInfo.setAccountBillState(CmpAccountBillState.SAVED);
                billInfo.setCurrency(calSchemeInfo.getCurrency());
                billInfo.setHrOrgUnit(calSchemeInfo.getHrOrgUnit());
                paymentOrg = billOrgMapping.get(billId);
                billInfo.setPaymentOrgNumber(paymentOrg.getPaymentOrgNumber());
                billInfo.setPaymentOrgName(paymentOrg.getPaymentOrgName());
                billInfo.setSettementOrgNumber(paymentOrg.getSettlementOrgNumber());
                billInfo.setSettementOrgName(paymentOrg.getSettlementOrgName());
                paymentOrg.setBillNumber(billInfo.getNumber());
                billEntrys = new CmpItemAccountBillEntryCollection();
                billInfo.put("entries", (Object)billEntrys);
                billInfo.setCreator(currentUserInfo);
                billInfo.setCreateTime(timestamp);
                billInfo.setLastUpdateUser(currentUserInfo);
                billInfo.setLastUpdateTime(timestamp);
                CmpItemAccountBillEntryInfo entryInfo = new CmpItemAccountBillEntryInfo();
                entryInfo.setId(BOSUuid.create((String)"1167DFB5"));
                entryInfo.setCmpItemAccountBill(billInfo);
                AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                adminOrgUnitInfo.setId(BOSUuid.read((String)orgId));
                entryInfo.setAdminOrg(adminOrgUnitInfo);
                CmpItemAccountBillRecordInfo brInfo = new CmpItemAccountBillRecordInfo();
                brInfo.setCmpItemAccountBillEntry(entryInfo);
                CmpItemInfo itemInfo = new CmpItemInfo();
                itemInfo.setId(BOSUuid.read((String)cmpitemid));
                brInfo.setCmpItem(itemInfo);
                brInfo.setCmpItemAccountBillEntry(entryInfo);
                entryInfo.put("cmpItemRecords", brInfo);
                entryInfo.setAmount(bearMoney);
                brColl.add((CoreBaseInfo)brInfo);
                billEntrys.add(entryInfo);
                billTempStats.setCompareString(billId);
                billTempStats.clear();
                billTempStats.add(bearMoney);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        XKQJPaymentOrg paymentOrg = billOrgMapping.get(billTempStats.getCompareString());
        paymentOrg.setAmount(billTempStats.getValue());
        billColl.add(billInfo);
        CmpItemAccountBillFactory.getLocalInstance(ctx).saveBatchData(billColl);
        CmpItemAccountBillRecordFactory.getLocalInstance(ctx).saveBatchData(brColl);
        return billColl;
    }

    private String createAccountBillNumber(Context ctx, CmpItemAccountBillInfo billInfo) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return iCodingRuleManager.getNumber((IObjectValue)billInfo, HRFilterUtils.getCurrentCUID((Context)ctx));
    }

    @Override
    protected Map _deleteCmpItemAccountBill(Context ctx, Map param) throws BOSException, EASBizException {
        try {
            String ids = (String)param.get("billIds");
            String calSchemePeriodRangeTable = this.scanCalSchemeConfig(ctx, ids);
            this.deleteCostBearCalScheme(ctx, ids);
            this.updateDistributeState(ctx, ids);
            this.deleteAccountDetail(ctx, ids);
            this.deleteAccountBill(ctx, ids);
            this.updateCostBearCalSchemeRecord(ctx, calSchemePeriodRangeTable);
            this.release(ctx, calSchemePeriodRangeTable);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void updateDistributeState(Context ctx, String ids) throws BOSException {
        String updateSql = "update T_HR_SCmpSegmCost set FIsDistribute = 0 where FID in (select distinct csc.FID from T_HR_SCmpSegmCost csc inner join T_HR_SCBXKQJRec xre on csc.FCMPCALTABLEID = xre.FCmpCalTableId and csc.FCostBearOrgID = xre.FCostBearOrgUnitID where xre.FAccountBillID in (" + ids + "))";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void release(Context ctx, String calSchemePeriodRangeTable) {
        TempTablePool.getInstance((Context)ctx).releaseTable(calSchemePeriodRangeTable);
    }

    private String scanCalSchemeConfig(Context ctx, String ids) throws Exception {
        String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        String sql = "select temp.* into " + tempTableName + " from (select distinct FCalSchemeID,FPeriodYear,FPeriodMonth,FCalTime from T_HR_SCmpItemAccountBill where fid in (" + ids + ")) temp";
        DbUtil.execute((Context)ctx, (String)sql);
        return tempTableName;
    }

    private void updateCostBearCalSchemeRecord(Context ctx, String calSchemePeriodRangeTable) throws SQLException, BOSException {
        String sql = "select schemePeriod.FCalSchemeID,schemePeriod.FPeriodYear,schemePeriod.FPeriodMonth,schemePeriod.FCalTime,accountBill.fnumber from " + calSchemePeriodRangeTable + " schemePeriod left join T_HR_SCmpItemAccountBill accountBill on schemePeriod.FCalSchemeID = accountBill.FCalSchemeID and schemePeriod.FPeriodYear = accountBill.FPeriodYear and schemePeriod.FPeriodMonth = accountBill.FPeriodMonth and schemePeriod.FCalTime = accountBill.FCalTime order by schemePeriod.FCalSchemeID,schemePeriod.FPeriodYear,schemePeriod.FPeriodMonth,schemePeriod.FCalTime";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, Set> map = new HashMap<String, Set>();
        while (rs.next()) {
            String calSchemeID = rs.getString("FCalSchemeID");
            int year = rs.getInt("FPeriodYear");
            int month = rs.getInt("FPeriodMonth");
            int calTime = rs.getInt("FCalTime");
            String number = rs.getString("fnumber");
            String tempKey = calSchemeID + "_" + year + "_" + month + "_" + calTime;
            Set numbers = map.computeIfAbsent(tempKey, k -> new HashSet());
            if (!CmpStrUtil.isNotEmpty(number)) continue;
            numbers.add(number);
        }
        LinkedList params = new LinkedList();
        map.forEach((key, value) -> {
            Object[] param = new Object[6];
            if (value.size() == 0) {
                param[0] = "0";
                param[1] = null;
            } else {
                param[0] = "1";
                param[1] = StringUtil.join((Collection)value, (String)",");
            }
            String[] scheme = key.split("_");
            param[2] = scheme[0];
            param[3] = scheme[1];
            param[4] = scheme[2];
            param[5] = scheme[3];
            params.add(param);
        });
        DbUtil.executeBatch((Context)ctx, (String)"update T_HR_CostBearCalSchemeRecord set FCostBearState = ?,FCmpItemAccoutBills = ? where FCalSchemeID = ? and FPeriodYear = ? and FPeriodMonth = ? and FCalTime = ? ", params);
    }

    private void deleteCostBearCalScheme(Context ctx, String ids) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_CostBearCalScheme where FCmpItemAccountBillID in (" + ids + ")"));
    }

    private void deleteAccountDetail(Context ctx, String ids) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_SCBXKQJRec where FAccountBillID in (" + ids + ")"));
    }

    private void deleteAccountBill(Context ctx, String ids) throws BOSException {
        String deleteRelateItem = "delete from T_HR_SCmpItemAccountBillRecord where FCmpItemAccountBillEntryID in (select fid from T_HR_SCmpItemAccountBillentry where FCmpItemAccountBillID in (" + ids + "))";
        String deleteBillEntry = "delete from T_HR_SCmpItemAccountBillentry where FCmpItemAccountBillID in (" + ids + ")";
        String deleteBill = "delete from T_HR_SCmpItemAccountBill where fid in (" + ids + ")";
        DbUtil.execute((Context)ctx, (String)deleteRelateItem);
        DbUtil.execute((Context)ctx, (String)deleteBillEntry);
        DbUtil.execute((Context)ctx, (String)deleteBill);
    }

    private class TempStats {
        String compareString = "";
        BigDecimal value = BigDecimal.ZERO;

        private TempStats() {
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public void setCompareString(String compareString) {
            this.compareString = compareString;
        }

        public String getCompareString() {
            return this.compareString;
        }

        public void add(BigDecimal val) {
            if (val != null) {
                this.value = this.value.add(val);
            }
        }

        public boolean tempEqual(String tempStr) {
            return this.compareString.equals(tempStr);
        }

        public void clear() {
            this.value = BigDecimal.ZERO;
        }
    }
}

