/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.ServiceFactory;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.budget.AbstractMiaBudgetDataUpgradeFacadeControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetManageLogInfo;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.CmpStandingBookLogInfo;
import com.kingdee.shr.compensation.app.budget.CmpUsedAmountInfo;
import com.kingdee.shr.compensation.app.budget.ICmpBudgetScheme;
import com.kingdee.shr.compensation.app.updateData.DataUpgradeState;
import com.kingdee.shr.compensation.exception.BaseUtilsBizException;
import com.kingdee.shr.compensation.util.budget.MiaBudgetUpgradeUtil;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MiaBudgetDataUpgradeFacadeControllerBean
extends AbstractMiaBudgetDataUpgradeFacadeControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.budget.MiaBudgetDataUpgradeFacadeControllerBean");
    private static final String SYS_MIA_BUDGET_TEMPLATE_ID = "8r0AAAAgwroStwOG";
    private static final String CURRENCY_RMB_ID = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
    private static final String SYS_MIA_SCHEME_ID = "jJ0AAAAA1thRn/us";
    private static final String MIA_CMP_BUDGET_ITEM_DEPITEM_ID = "u4w/Ae+oR7mnZ8OJPz/XTpVoCFc=";
    private static final String MIA_CMP_SUBMIT_ITEM_SUBMITAMOUNT_ID = "viEAAAPGBM5rKBba";
    private static final String SYS_MIA_BUDGET_TEMPLATE_TABLE = "T_HR_SBudgetManage";
    private static final String SYS_MIA_STANDING_BOOK_TABLE = "T_HR_SCmpStandingBook";
    private static final String MIA_TEMPLATE_STB_ITEM_ID_PRE = "NejPFQHARyC10Bxb+oHvO36OYm4=";
    private static final String MIA_TEMPLATE_STB_ITEM_ID_ACT = "VinD2lvgQaig9+EEAeaa+X6OYm4=";
    private static final String MIA_STB_ITEM_PREDEDUCTEDAMOUNT_ID = "gGqtGZYBTzKzO5986WZ5JqoszO8=";
    private static final String MIA_STB_ITEM_BALANCEOFPREDEDUCTION_ID = "xlPDisvaQuCEuQUkLku0PKoszO8=";
    private static final String MIA_STB_ITEM_ACTUALAMOUNTDEDUCTED_ID = "3MNPM1kPT7iMjQ+N7Llv1aoszO8=";
    private static final String MIA_STB_ITEM_BALANCEOFACTUALDEDUCTION_ID = "st5IqiWBSlmP552TFgvK4qoszO8=";
    private static final String BR = "<br/>";
    private List<Object[]> insertBudgetParams = Lists.newArrayList();
    private List<Object[]> insertStbParams = Lists.newArrayList();
    private List<Object[]> insertBudgetLogParams = Lists.newArrayList();
    private List<Object[]> insertStbLogParams = Lists.newArrayList();
    private List<Object[]> insertStbUsedAmountParams = Lists.newArrayList();
    private Map<Integer, CmpBudgetSchemeInfo> budgetSchemeMap = Maps.newHashMap();
    private Map<String, String> budgetTable = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _upgrade(Context ctx) throws BOSException, EASBizException {
        CmpDistributedLockUtils.tryLockIfSuccess(ctx, MiaBudgetUpgradeUtil.getLockEntranceName(), MiaBudgetUpgradeUtil.getLockResource());
        try {
            if (this.checkIsUprade(ctx)) {
                throw new BaseUtilsBizException(BaseUtilsBizException.UPGRADE_COMPLETE);
            }
            String message = this.doUpgrade(ctx);
            this.updateFlag(ctx);
            HashMap result = Maps.newHashMap();
            result.put("message", message);
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, MiaBudgetUpgradeUtil.getLockEntranceName(), MiaBudgetUpgradeUtil.getLockResource());
        }
    }

    protected boolean checkIsUprade(Context ctx) {
        DataUpgradeState state = MiaBudgetUpgradeUtil.isMiaBudgetUpgradeComplete(ctx);
        return DataUpgradeState.FINISHED == state;
    }

    protected void updateFlag(Context ctx) {
        String updateSql = "update T_HR_SCommonDataUpgrade set flag = ? where FBusinessType = ?";
        try {
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{true, 10});
        }
        catch (BOSException e) {
            logger.error((Object)"update upgrade flag error!", (Throwable)e);
        }
        try {
            ServiceFactory.getLocalInstance((Context)ctx).disable("jJ0AAAAAcUzyPSkQ");
            ServiceFactory.getLocalInstance((Context)ctx).disable("jJ0AAAABLM7yPSkQ");
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)"disable service menu error!", e);
        }
        try {
            DbUtil.execute((Context)ctx, (String)"update T_HR_SCalSubmitScheme set FBudgetTemplateID = ? where fid = ?", (Object[])new Object[]{SYS_MIA_BUDGET_TEMPLATE_ID, SYS_MIA_SCHEME_ID});
        }
        catch (BOSException e) {
            logger.error((Object)"update upgrade flag error!", (Throwable)e);
        }
    }

    protected String doUpgrade(Context ctx) throws BOSException, EASBizException {
        this.generateBudgetScheme(ctx);
        StringBuilder msgBuilder = new StringBuilder(MiaBudgetUpgradeUtil.getMulRes(ctx, "left_bracket_ch", null));
        String completeMsg = MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_complete", null);
        msgBuilder.append(completeMsg).append(BR);
        String schemeMsg = MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_budgetScheme", null);
        StringBuilder nameBuilder = new StringBuilder();
        this.budgetSchemeMap.forEach((key, value) -> nameBuilder.append(",").append(value.getName()));
        msgBuilder.append(MessageFormat.format(schemeMsg, nameBuilder.toString().replaceFirst(",", ""))).append(BR);
        this.generateData(ctx);
        this.generateImportRecord(ctx);
        String budgetDataMsg = MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_budgetData_new", null);
        int budgetDataCount = this.insertBudgetParams.size();
        msgBuilder.append(MessageFormat.format(budgetDataMsg, budgetDataCount)).append(BR);
        String budgetDataImportLogMsg = MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_budgetData_importLog", null);
        int budgetDataImportLogCount = this.insertBudgetLogParams.size();
        msgBuilder.append(MessageFormat.format(budgetDataImportLogMsg, budgetDataImportLogCount)).append(BR);
        String stbDataMsg = MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_stbData_new", null);
        int stbDataCount = this.insertStbParams.size();
        msgBuilder.append(MessageFormat.format(stbDataMsg, stbDataCount)).append(BR);
        String usedAmoutMsg = MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_stbData_importLog", null);
        int usedAmoutCount = this.insertStbLogParams.size();
        msgBuilder.append(MessageFormat.format(usedAmoutMsg, usedAmoutCount)).append(BR);
        String snapShotDataMsg = MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_snapshotData_new", null);
        int snapshotDataCount = this.generateSnapshotData(ctx);
        msgBuilder.append(MessageFormat.format(snapShotDataMsg, snapshotDataCount));
        msgBuilder.append(MiaBudgetUpgradeUtil.getMulRes(ctx, "right_bracket_ch", null));
        return msgBuilder.toString();
    }

    protected void generateImportRecord(Context ctx) {
        String insertSql;
        List<FieldMapper> budgetImportField = this.getBudgetImportField(ctx);
        List<FieldMapper> stbImportField = this.getStbImportField(ctx);
        String queryBudgetDataSql = this.assembleQuerySql(ctx, budgetImportField, " FROM T_HR_SLimitManagementLog", this.queryLimitDataCondition(ctx));
        String queryStbDataLogSql = this.assembleQuerySql(ctx, stbImportField, this.queryStbDataLogFromTable(ctx), this.queryLimitDataCondition(ctx) + " and FVIRTUALNODE = 0 order by L.FCREATETIME DESC ");
        String stbLogBosType = new CmpStandingBookLogInfo().getBOSType().toString();
        String budgetDataBOSType = new BudgetManageLogInfo().getBOSType().toString();
        String usedAmounyBosType = new CmpUsedAmountInfo().getBOSType().toString();
        this.budgetSchemeMap.forEach((budgetYear, cmpBudgetSchemeInfo) -> {
            IRowSet rowSet;
            String realSql;
            try {
                realSql = this.beforeQueryLimitDataLog(ctx, queryBudgetDataSql);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)realSql, (Object[])this.queryLimitDataParam(ctx, (Integer)budgetYear, (CmpBudgetSchemeInfo)cmpBudgetSchemeInfo));
                while (rowSet.next()) {
                    String recordId = BOSUuid.create((String)budgetDataBOSType).toString();
                    Object[] newBudgetDataParam = this.getNewDataParam(ctx, rowSet, budgetImportField, 1);
                    this.afterAssembleParam(ctx, newBudgetDataParam, (Integer)budgetYear, (CmpBudgetSchemeInfo)cmpBudgetSchemeInfo, new Object[]{recordId});
                    newBudgetDataParam[0] = cmpBudgetSchemeInfo.getId().toString();
                    this.insertBudgetLogParams.add(newBudgetDataParam);
                }
            }
            catch (BOSException | SQLException e) {
                logger.error((Object)"query budget data import record error!", e);
            }
            try {
                realSql = this.beforeQueryStbDataLog(ctx, queryStbDataLogSql);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)realSql, (Object[])this.queryLimitDataParam(ctx, (Integer)budgetYear, (CmpBudgetSchemeInfo)cmpBudgetSchemeInfo));
                HashMap usedAmoutParamMap = Maps.newHashMap();
                while (rowSet.next()) {
                    String recordId = BOSUuid.create((String)stbLogBosType).toString();
                    Object[] newBudgetDataParam = this.getNewDataParam(ctx, rowSet, stbImportField, 4);
                    String adminId_costTypeId = rowSet.getString("FADMINORGUNITID") + "_" + rowSet.getString("FCOSTTYPEID");
                    String budgetIdsMapper = this.budgetTable.get(adminId_costTypeId + "_" + budgetYear);
                    String budgetManageId = StringUtils.isEmpty((String)budgetIdsMapper) ? null : budgetIdsMapper.split("_")[0];
                    this.afterAssembleParam(ctx, newBudgetDataParam, (Integer)budgetYear, (CmpBudgetSchemeInfo)cmpBudgetSchemeInfo, new Object[]{budgetManageId, MIA_CMP_BUDGET_ITEM_DEPITEM_ID, SYS_MIA_BUDGET_TEMPLATE_ID, recordId});
                    this.insertStbLogParams.add(newBudgetDataParam);
                    Object[] usedAmountParam = new Object[stbImportField.size() + 4];
                    System.arraycopy(newBudgetDataParam, 0, usedAmountParam, 0, newBudgetDataParam.length);
                    if (usedAmoutParamMap.containsKey(adminId_costTypeId)) {
                        usedAmountParam = (Object[])usedAmoutParamMap.get(adminId_costTypeId);
                        usedAmountParam[4] = rowSet.getObject("FLastUpdateUserID");
                        usedAmountParam[5] = rowSet.getObject("FLastUpdateTime");
                    }
                    usedAmoutParamMap.put(budgetManageId, usedAmountParam);
                }
                usedAmoutParamMap.forEach((id, param) -> {
                    String usedAmountId = BOSUuid.create((String)usedAmounyBosType).toString();
                    this.afterAssembleParam(ctx, (Object[])param, (Integer)budgetYear, (CmpBudgetSchemeInfo)cmpBudgetSchemeInfo, new Object[]{id, MIA_CMP_BUDGET_ITEM_DEPITEM_ID, SYS_MIA_BUDGET_TEMPLATE_ID, usedAmountId});
                    this.insertStbUsedAmountParams.add((Object[])param);
                });
            }
            catch (BOSException | SQLException e) {
                logger.error((Object)"query standingbook data import record error!", e);
            }
        });
        if (!this.insertBudgetLogParams.isEmpty()) {
            insertSql = this.getInsertSql(ctx, budgetImportField, "T_HR_SBudgetManageLog", new Object[0]);
            try {
                DbUtil.executeBatch((Context)ctx, (String)insertSql, this.insertBudgetLogParams);
            }
            catch (BOSException e) {
                logger.error((Object)"insert budgetData error!", (Throwable)e);
            }
        }
        if (!this.insertStbLogParams.isEmpty()) {
            insertSql = this.getInsertSql(ctx, stbImportField, "T_HR_SCmpStandingBookLog", new Object[]{"FBUDGETMANAGEID", "FCMPBUDGETITEMID", "FTEMPLATEID"});
            try {
                DbUtil.executeBatch((Context)ctx, (String)insertSql, this.insertStbLogParams);
            }
            catch (BOSException e) {
                logger.error((Object)"insert budgetData error!", (Throwable)e);
            }
        }
        if (!this.insertStbUsedAmountParams.isEmpty()) {
            insertSql = this.getInsertSql(ctx, stbImportField, "T_HR_SCmpUsedAmount", new Object[]{"FBUDGETMANAGEID", "FCMPBUDGETITEMID", "FTEMPLATEID"});
            try {
                DbUtil.executeBatch((Context)ctx, (String)insertSql, this.insertStbUsedAmountParams);
            }
            catch (BOSException e) {
                logger.error((Object)"insert budgetData error!", (Throwable)e);
            }
        }
    }

    protected String beforeQueryLimitDataLog(Context ctx, String querySql) {
        return querySql;
    }

    protected String beforeQueryStbDataLog(Context ctx, String querySql) {
        return querySql;
    }

    protected String queryStbDataLogFromTable(Context ctx) {
        return "FROM  T_HR_SStandingBookLog L inner JOIN T_HR_SLimitManagement D ON L.FLIMITMANAGEMENTID = D.FID";
    }

    protected List<FieldMapper> getBudgetImportField(Context ctx) {
        LinkedList fields = Lists.newLinkedList();
        fields.add(new FieldMapper("FBUDGETYEAR", "FBUDGETYEAR", "FBudgetSchemeID"));
        fields.add(new FieldMapper("FOPERATETYPE", "FOPERATETYPE", "FOPERATETYPE"));
        fields.add(new FieldMapper("FADMINORGUNITID", "FADMINORGUNITID", "FADMINORGUNITID"));
        fields.add(new FieldMapper("FCOSTTYPEID", "FCOSTTYPEID", "FCOSTTYPEID"));
        fields.add(new FieldMapper("FMAXLIMIT", "FMAXLIMIT", "T1"));
        fields.add(new FieldMapper("FBUDGETLIMIT", "FBUDGETLIMIT", "T2"));
        fields.add(new FieldMapper("FRESERVELIMIT", "FRESERVELIMIT", "T3"));
        fields.add(new FieldMapper("FDEPARTMENTLIMIT", "FDEPARTMENTLIMIT", "T4"));
        fields.add(new FieldMapper("FSTATE", "FSTATE", "FSTATE"));
        fields.add(new FieldMapper("FCreatorID", "FCreatorID", "FCreatorID"));
        fields.add(new FieldMapper("FCreateTime", "FCreateTime", "FCreateTime"));
        fields.add(new FieldMapper("FLastUpdateUserID", "FLastUpdateUserID", "FLastUpdateUserID"));
        fields.add(new FieldMapper("FLastUpdateTime", "FLastUpdateTime", "FLastUpdateTime"));
        fields.add(new FieldMapper("FControlUnitID", "FControlUnitID", "FControlUnitID"));
        return fields;
    }

    protected List<FieldMapper> getStbImportField(Context ctx) {
        LinkedList fields = Lists.newLinkedList();
        fields.add(new FieldMapper("L.FUSEDAMOUNT", "FUSEDAMOUNT", "FUSEDAMOUNT"));
        fields.add(new FieldMapper("D.FADMINORGUNITID", "FADMINORGUNITID", "FADMINORGUNITID"));
        fields.add(new FieldMapper("D.FCOSTTYPEID", "FCOSTTYPEID", "FCOSTTYPEID"));
        fields.add(new FieldMapper("D.FBUDGETYEAR", "FBUDGETYEAR", "FBUDGETYEAR"));
        fields.add(new FieldMapper("L.FCREATORID", "FCREATORID", "FCREATORID"));
        fields.add(new FieldMapper("L.FCREATETIME", "FCREATETIME", "FCREATETIME"));
        fields.add(new FieldMapper("L.FLASTUPDATEUSERID", "FLASTUPDATEUSERID", "FLASTUPDATEUSERID"));
        fields.add(new FieldMapper("L.FLASTUPDATETIME", "FLASTUPDATETIME", "FLASTUPDATETIME"));
        fields.add(new FieldMapper("L.FCONTROLUNITID", "FCONTROLUNITID", "FCONTROLUNITID"));
        return fields;
    }

    protected Map<Integer, CmpBudgetSchemeInfo> generateBudgetScheme(Context ctx) throws BOSException {
        String queryYearSql = "SELECT distinct FBudgetYear FROM T_HR_SLimitManagement where FVIRTUALNODE = 0 order by FBudgetYear";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryYearSql);
        try {
            while (rowSet.next()) {
                int budgetYear = rowSet.getInt("FBudgetYear");
                this.budgetSchemeMap.put(budgetYear, null);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query budgetYear error!", (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        try {
            Set<Map.Entry<Integer, CmpBudgetSchemeInfo>> entrySet = this.budgetSchemeMap.entrySet();
            for (Map.Entry<Integer, CmpBudgetSchemeInfo> entry : entrySet) {
                Integer budgetYear = entry.getKey();
                entry.setValue(this.assembleSchemeInfo(ctx, budgetYear));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"query budgetYear error!", (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return this.budgetSchemeMap;
    }

    protected void generateData(Context ctx) {
        String insertSql;
        List<FieldMapper> budgetFields = this.queryLimitDataField(ctx);
        List<FieldMapper> stbFields = this.queryStbDataField(ctx);
        String queryLimitManageDataSql = this.getQueryLimitDataSql(ctx, budgetFields, stbFields);
        this.budgetSchemeMap.forEach((budgetYear, cmpBudgetSchemeInfo) -> {
            try {
                String realSql = this.beforeQueryLimitData(ctx, queryLimitManageDataSql);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)realSql, (Object[])this.queryLimitDataParam(ctx, (Integer)budgetYear, (CmpBudgetSchemeInfo)cmpBudgetSchemeInfo));
                while (rowSet.next()) {
                    String budgetId = BOSUuid.create((String)"84812771").toString();
                    String stbId = BOSUuid.create((String)"8B07DDF4").toString();
                    Object[] newBudgetDataParam = this.getNewDataParam(ctx, rowSet, budgetFields, 2);
                    this.afterAssembleParam(ctx, newBudgetDataParam, (Integer)budgetYear, (CmpBudgetSchemeInfo)cmpBudgetSchemeInfo, new Object[]{stbId, budgetId});
                    newBudgetDataParam[newBudgetDataParam.length - 3] = cmpBudgetSchemeInfo.getId().toString();
                    String tempAC = rowSet.getString("FAdminOrgUnitID") + "_" + rowSet.getString("FCostTypeID");
                    this.budgetTable.put(tempAC + "_" + budgetYear, budgetId + "_" + stbId);
                    this.insertBudgetParams.add(newBudgetDataParam);
                    Object[] newStbDataParam = this.getNewDataParam(ctx, rowSet, stbFields, 2);
                    this.afterAssembleParam(ctx, newStbDataParam, (Integer)budgetYear, (CmpBudgetSchemeInfo)cmpBudgetSchemeInfo, new Object[]{budgetId, stbId});
                    this.insertStbParams.add(newStbDataParam);
                }
            }
            catch (BOSException | SQLException e) {
                logger.error((Object)"query budget data error!", e);
            }
        });
        if (!this.insertBudgetParams.isEmpty()) {
            insertSql = this.getInsertSql(ctx, budgetFields, SYS_MIA_BUDGET_TEMPLATE_TABLE, new Object[]{"FStandingBookID"});
            try {
                DbUtil.executeBatch((Context)ctx, (String)insertSql, this.insertBudgetParams);
            }
            catch (BOSException e) {
                logger.error((Object)"insert budgetData error!", (Throwable)e);
            }
        }
        if (!this.insertStbParams.isEmpty()) {
            insertSql = this.getInsertSql(ctx, stbFields, SYS_MIA_STANDING_BOOK_TABLE, new Object[]{"FBudgetManageID"});
            try {
                DbUtil.executeBatch((Context)ctx, (String)insertSql, this.insertStbParams);
            }
            catch (BOSException e) {
                logger.error((Object)"insert standing book data error!", (Throwable)e);
            }
        }
    }

    protected Object[] afterAssembleParam(Context ctx, Object[] newDataParam, Integer budgetYear, CmpBudgetSchemeInfo cmpBudgetSchemeInfo, Object[] otherField) {
        int otherFieldLenth;
        int length = newDataParam.length;
        for (int i = otherFieldLenth = otherField.length; i > 0; --i) {
            newDataParam[length - i] = otherField[otherFieldLenth - i];
        }
        return newDataParam;
    }

    protected String getInsertSql(Context ctx, List<FieldMapper> fileds, String table, Object[] otherField) {
        StringBuilder fieldSql = new StringBuilder();
        StringBuilder valueSql = new StringBuilder();
        fileds.forEach(fieldMapper -> {
            fieldSql.append(fieldMapper.getTargetField()).append(", ");
            valueSql.append("?, ");
        });
        int length = otherField.length;
        for (int i = 0; i < length; ++i) {
            fieldSql.append(otherField[i]).append(", ");
            valueSql.append("?, ");
        }
        return "insert into " + table + " (" + fieldSql + "FID) values (" + valueSql + " ?)";
    }

    protected Object[] getNewDataParam(Context ctx, IRowSet rowSet, List<FieldMapper> fileds, int addSize) {
        Object[] param = new Object[fileds.size() + addSize];
        int[] index = new int[]{0};
        fileds.forEach(fieldMapper -> {
            try {
                int n = index[0];
                index[0] = n + 1;
                param[n] = rowSet.getObject(fieldMapper.getQueryField());
            }
            catch (SQLException e) {
                logger.error((Object)"assemble param error!", (Throwable)e);
            }
        });
        return param;
    }

    protected String beforeQueryLimitData(Context ctx, String querySql) {
        return querySql;
    }

    protected String getQueryLimitDataSql(Context ctx, List<FieldMapper> budgeFieds, List<FieldMapper> stbFieds) {
        LinkedList fields = Lists.newLinkedList();
        fields.addAll(budgeFieds);
        fields.addAll(stbFieds);
        return this.assembleQuerySql(ctx, fields, this.queryLimitDataFromTable(ctx), this.queryLimitDataCondition(ctx) + " and FVIRTUALNODE = 0");
    }

    protected String assembleQuerySql(Context ctx, List<FieldMapper> queryFields, String fromTable, String queryCondition) {
        StringBuilder sql = new StringBuilder();
        queryFields.forEach(fieldMapper -> sql.append(", ").append(fieldMapper.getSourceField()).append(" AS ").append(fieldMapper.getQueryField()));
        sql.replace(0, 1, "select ");
        sql.append(" ").append(fromTable);
        sql.append(" ").append(queryCondition);
        return sql.toString();
    }

    protected List<FieldMapper> queryLimitDataField(Context ctx) {
        LinkedList fields = Lists.newLinkedList();
        fields.add(new FieldMapper("MANAGE.FAdminOrgUnitID", "FAdminOrgUnitID", "FAdminOrgUnitID"));
        fields.add(new FieldMapper("MANAGE.FCostTypeID", "FCostTypeID", "FCostTypeID"));
        fields.add(new FieldMapper("MANAGE.FState", "FState", "FState"));
        fields.add(new FieldMapper("MANAGE.FCurrencyID", "FCurrencyID", "FCurrencyID"));
        fields.add(new FieldMapper("MANAGE.FVirtualNode", "FVirtualNode", "FVirtualNode"));
        fields.add(new FieldMapper("MANAGE.FMaxLimit", "FMaxLimit", "T1"));
        fields.add(new FieldMapper("MANAGE.FBudgetLimit", "FBudgetLimit", "T2"));
        fields.add(new FieldMapper("MANAGE.FReserveLimit", "FReserveLimit", "T3"));
        fields.add(new FieldMapper("MANAGE.FDepartmentLimit", "FDepartmentLimit", "T4"));
        fields.add(new FieldMapper("MANAGE.FBudgetYear", "FBudgetYear", "FBudgetYear"));
        fields.add(new FieldMapper("MANAGE.FCreatorID", "MFCreatorID", "FCreatorID"));
        fields.add(new FieldMapper("MANAGE.FCreateTime", "MFCreateTime", "FCreateTime"));
        fields.add(new FieldMapper("MANAGE.FLastUpdateUserID", "MFLastUpdateUserID", "FLastUpdateUserID"));
        fields.add(new FieldMapper("MANAGE.FLastUpdateTime", "MFLastUpdateTime", "FLastUpdateTime"));
        fields.add(new FieldMapper("MANAGE.FControlUnitID", "MFControlUnitID", "FControlUnitID"));
        fields.add(new FieldMapper("null", "CMPBUDGETSCHEMEID", "FBudgetSchemeID"));
        return fields;
    }

    protected List<FieldMapper> queryStbDataField(Context ctx) {
        LinkedList fields = Lists.newLinkedList();
        fields.add(new FieldMapper("STB.FWITHHOLDAMOUNT", "FWITHHOLDAMOUNT", "S1"));
        fields.add(new FieldMapper("STB.FREALDEDUCTAMOUNT", "FREALDEDUCTAMOUNT", "S3"));
        fields.add(new FieldMapper("STB.FWITHHOLEBALANCE", "FWITHHOLEBALANCE", "S2"));
        fields.add(new FieldMapper("STB.FREALDEDUCTBALANCE", "FREALDEDUCTBALANCE", "S4"));
        fields.add(new FieldMapper("MANAGE.FCreatorID", "SFCreatorID", "FCreatorID"));
        fields.add(new FieldMapper("MANAGE.FCreateTime", "SFCreateTime", "FCreateTime"));
        fields.add(new FieldMapper("MANAGE.FLastUpdateUserID", "SFLastUpdateUserID", "FLastUpdateUserID"));
        fields.add(new FieldMapper("MANAGE.FLastUpdateTime", "SFLastUpdateTime", "FLastUpdateTime"));
        fields.add(new FieldMapper("MANAGE.FControlUnitID", "SFControlUnitID", "FControlUnitID"));
        return fields;
    }

    protected String queryLimitDataFromTable(Context ctx) {
        return "FROM  T_HR_SLIMITMANAGEMENT MANAGE LEFT JOIN T_HR_SSTANDINGBOOK STB ON MANAGE.FSTANDINGBOOK = STB.FID";
    }

    protected String queryLimitDataCondition(Context ctx) {
        return "WHERE fbudgetYear = ? ";
    }

    protected Object[] queryLimitDataParam(Context ctx, Integer budgetYear, CmpBudgetSchemeInfo cmpBudgetSchemeInfo) {
        return new Object[]{budgetYear};
    }

    protected int generateSnapshotData(Context ctx) {
        List<FieldMapper> snapShotFields = this.getSnapShotFields(ctx);
        String querySnapShotDataSql = this.querySnapShotDataSql(ctx);
        ArrayList params = Lists.newArrayList();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySnapShotDataSql);
            while (rowSet.next()) {
                List<Object[]> param = this.assembleSnapShotParam(ctx, rowSet, snapShotFields);
                params.addAll(param);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"query snapshot data error!", e);
        }
        String insertSnapShotSql = this.getInsertSnapShotSql(ctx, snapShotFields);
        try {
            DbUtil.executeBatch((Context)ctx, (String)insertSnapShotSql, (List)params);
        }
        catch (BOSException e) {
            logger.error((Object)"insert snapshot data error!", (Throwable)e);
        }
        return params.size();
    }

    protected String querySnapShotDataSql(Context ctx) {
        return "SELECT \nBILL.FBILLSTATE BILLSTATE,\nBILL.FID BILLID,\nENTRY.FID ENTRYID,\nBILL.FBUDGETYEAR BUDGETYEAR,\nENTRY.S1 MONEY,\nBILL.FPROPOSERID,\nBILL.FAPPLYDATE,\nBILL.FCONTROLUNITID,\nBILL.FHRORGUNITID,\nENTRY.FADMINORGUNITID,\nBILL.FCOSTBEARORGID ,\nBILL.FCOSTTYPEID,\nENTRY.FPERSONID,\nENTRY.FCURRENCYID\nFROM T_HR_SBATCHSUBMITSHEMEBILL BILL\nINNER JOIN T_HR_SCHEMEBILLENTRY014SYS ENTRY ON BILL.FID = ENTRY.FBILLID\nWHERE BILL.FBILLSTATE > 2\nORDER BY BILL.FNUMBER \n";
    }

    protected List<Object[]> assembleSnapShotParam(Context ctx, IRowSet rowSet, List<FieldMapper> snapShotFields) throws SQLException {
        ArrayList params = Lists.newArrayList();
        int size = snapShotFields.size();
        Object[] paramPre = new Object[size];
        Object[] paramOffSet = new Object[size];
        Object[] paramAct = new Object[size];
        Object[] paramRollBack = new Object[size];
        int billState = rowSet.getInt("BILLSTATE");
        for (int i = 0; i < size; ++i) {
            FieldMapper fieldMapper = snapShotFields.get(i);
            paramPre[i] = this.getSnapShotFieldValue(ctx, rowSet, fieldMapper, 10);
            if (billState == 3) {
                paramOffSet[i] = this.getSnapShotFieldValue(ctx, rowSet, fieldMapper, 20);
                paramAct[i] = this.getSnapShotFieldValue(ctx, rowSet, fieldMapper, 30);
                continue;
            }
            if (billState != 4) continue;
            paramRollBack[i] = this.getSnapShotFieldValue(ctx, rowSet, fieldMapper, 40);
        }
        params.add(paramPre);
        if (billState == 3) {
            params.add(paramOffSet);
            params.add(paramAct);
        } else if (billState == 4) {
            params.add(paramRollBack);
        }
        return params;
    }

    protected Object getSnapShotFieldValue(Context ctx, IRowSet rowSet, FieldMapper fieldMapper, int type) throws SQLException {
        String targetField = fieldMapper.getTargetField();
        String queryField = fieldMapper.getQueryField();
        String sourceField = fieldMapper.getSourceField();
        Object value = null;
        int budgetyear = rowSet.getInt("BUDGETYEAR");
        switch (sourceField) {
            case "FTemplateStbItemID": {
                if (10 == type || 20 == type || 40 == type) {
                    value = MIA_TEMPLATE_STB_ITEM_ID_PRE;
                    break;
                }
                value = MIA_TEMPLATE_STB_ITEM_ID_ACT;
                break;
            }
            case "FStandingBookItemID": {
                if (10 == type || 20 == type || 40 == type) {
                    value = MIA_STB_ITEM_PREDEDUCTEDAMOUNT_ID;
                    break;
                }
                value = MIA_STB_ITEM_ACTUALAMOUNTDEDUCTED_ID;
                break;
            }
            case "FBalanceLedgerItemID": {
                if (10 == type || 20 == type || 40 == type) {
                    value = MIA_STB_ITEM_BALANCEOFPREDEDUCTION_ID;
                    break;
                }
                value = MIA_STB_ITEM_BALANCEOFACTUALDEDUCTION_ID;
                break;
            }
            case "FUpdateNode": {
                if (10 == type) {
                    value = 200;
                    break;
                }
                if (20 == type) {
                    value = 320;
                    break;
                }
                if (30 == type) {
                    value = 320;
                    break;
                }
                if (40 != type) break;
                value = 380;
                break;
            }
            case "FDataState": {
                if (10 == type) {
                    value = 10;
                    break;
                }
                if (20 == type) {
                    value = 30;
                    break;
                }
                if (30 == type) {
                    value = 10;
                    break;
                }
                if (40 != type) break;
                value = 20;
                break;
            }
            case "FBookTableId": 
            case "FSubBookTableId": {
                String fadminorgunitid = rowSet.getString("FCOSTBEARORGID");
                String fcosttypeid = rowSet.getString("FCOSTTYPEID");
                String ids = this.budgetTable.get(fadminorgunitid + "_" + fcosttypeid + "_" + budgetyear);
                value = null != ids ? ids.split("_")[1] : null;
                break;
            }
            case "FRate": {
                value = BigDecimal.ONE;
                break;
            }
            case "FIsRollback": {
                if (40 == type) {
                    value = 1;
                    break;
                }
                value = 0;
                break;
            }
            case "FIsOffset": {
                if (20 == type) {
                    value = 1;
                    break;
                }
                value = 0;
                break;
            }
            case "FID": {
                value = MiaBudgetUpgradeUtil.createSnapShotId(ctx);
                break;
            }
            case "FUpdateDirection": {
                if (10 == type) {
                    value = 2;
                    break;
                }
                if (20 == type) {
                    value = 1;
                    break;
                }
                if (30 == type) {
                    value = 2;
                    break;
                }
                if (40 != type) break;
                value = 1;
                break;
            }
            case "FBusinessType": {
                value = 2;
                break;
            }
            case "FBudgetSchemeID": {
                value = this.budgetSchemeMap.get(budgetyear).getId().toString();
                break;
            }
            default: {
                value = null != targetField ? targetField : (null != queryField ? rowSet.getObject(queryField) : null);
            }
        }
        return value;
    }

    protected String getInsertSnapShotSql(Context ctx, List<FieldMapper> snapShotFields) {
        String insertSql = "insert into T_HR_SBudgetSnapShot (";
        StringBuilder fieldsBuilder = new StringBuilder();
        StringBuilder valuesBuilder = new StringBuilder();
        for (FieldMapper snapShotField : snapShotFields) {
            fieldsBuilder.append(", ").append(snapShotField.getSourceField());
            valuesBuilder.append(", ?");
        }
        insertSql = insertSql + fieldsBuilder.toString().replaceFirst(",", "") + ") values(" + valuesBuilder.toString().replaceFirst(",", "") + ")";
        return insertSql;
    }

    protected List<FieldMapper> getSnapShotFields(Context ctx) {
        ArrayList fields = Lists.newArrayList();
        fields.add(new FieldMapper("FCalSubmitSchemeID", null, SYS_MIA_SCHEME_ID));
        fields.add(new FieldMapper("FSubmitShemeBillID", "BILLID", null));
        fields.add(new FieldMapper("FSubmitShemeBillEntryID", "ENTRYID", null));
        fields.add(new FieldMapper("FCmpBudgetItemID", null, MIA_CMP_BUDGET_ITEM_DEPITEM_ID));
        fields.add(new FieldMapper("FTemplateStbItemID", null, null));
        fields.add(new FieldMapper("FStandingBookItemID", null, null));
        fields.add(new FieldMapper("FBalanceLedgerItemID", null, null));
        fields.add(new FieldMapper("FCalSubmitItemID", null, MIA_CMP_SUBMIT_ITEM_SUBMITAMOUNT_ID));
        fields.add(new FieldMapper("FBudgetMangeTb", null, SYS_MIA_BUDGET_TEMPLATE_TABLE));
        fields.add(new FieldMapper("FBudgetYear", "BUDGETYEAR", null));
        fields.add(new FieldMapper("FPeriod", null, null));
        fields.add(new FieldMapper("FUpdateNode", null, null));
        fields.add(new FieldMapper("FDataState", null, null));
        fields.add(new FieldMapper("FValue", "MONEY", null));
        fields.add(new FieldMapper("FBookTable", null, SYS_MIA_STANDING_BOOK_TABLE));
        fields.add(new FieldMapper("FBookTableId", null, null));
        fields.add(new FieldMapper("FSubBookTable", null, SYS_MIA_STANDING_BOOK_TABLE));
        fields.add(new FieldMapper("FSubBookTableId", null, null));
        fields.add(new FieldMapper("FOffsetSnapshotId", null, null));
        fields.add(new FieldMapper("FRate", null, null));
        fields.add(new FieldMapper("FIsRollback", null, null));
        fields.add(new FieldMapper("FIsOffset", null, null));
        fields.add(new FieldMapper("FCreatorID", "FPROPOSERID", null));
        fields.add(new FieldMapper("FCreateTime", "FAPPLYDATE", null));
        fields.add(new FieldMapper("FLastUpdateUserID", "FPROPOSERID", null));
        fields.add(new FieldMapper("FLastUpdateTime", "FAPPLYDATE", null));
        fields.add(new FieldMapper("FControlUnitID", "FCONTROLUNITID", null));
        fields.add(new FieldMapper("FID", null, null));
        fields.add(new FieldMapper("FBillID", "BILLID", null));
        fields.add(new FieldMapper("FBillEntryID", "ENTRYID", null));
        fields.add(new FieldMapper("FSchemeID", null, SYS_MIA_SCHEME_ID));
        fields.add(new FieldMapper("FItemID", null, MIA_CMP_SUBMIT_ITEM_SUBMITAMOUNT_ID));
        fields.add(new FieldMapper("FBusinessType", null, null));
        fields.add(new FieldMapper("FUpdateDirection", null, null));
        fields.add(new FieldMapper("FCurrencyID", "FCURRENCYID", null));
        fields.add(new FieldMapper("FAdminOrgUnitID", "FADMINORGUNITID", null));
        fields.add(new FieldMapper("FHrOrgUnitID", "FHRORGUNITID", null));
        fields.add(new FieldMapper("FCostBearOrgID", "FCOSTBEARORGID", null));
        fields.add(new FieldMapper("FCostTypeID", "FCOSTTYPEID", null));
        fields.add(new FieldMapper("FPersonID", "FPERSONID", null));
        fields.add(new FieldMapper("FBudgetSchemeID", null, null));
        fields.add(new FieldMapper("FBudgetTemplateID", null, SYS_MIA_BUDGET_TEMPLATE_ID));
        fields.add(new FieldMapper("FBUDGETCURRENCYID", null, CURRENCY_RMB_ID));
        return fields;
    }

    protected CmpBudgetSchemeInfo assembleSchemeInfo(Context ctx, Integer budgetYear) throws BOSException, EASBizException {
        ICmpBudgetScheme cmpBudgetSchemeFactory = CmpBudgetSchemeFactory.getLocalInstance(ctx);
        CmpBudgetSchemeCollection cmpBudgetSchemeCollection = cmpBudgetSchemeFactory.getCmpBudgetSchemeCollection("where budgetYear = " + budgetYear + " and template = '" + SYS_MIA_BUDGET_TEMPLATE_ID + "'");
        if (!cmpBudgetSchemeCollection.isEmpty()) {
            return cmpBudgetSchemeCollection.get(0);
        }
        CmpBudgetSchemeInfo schemeInfo = new CmpBudgetSchemeInfo();
        BudgetTemplateInfo budgetTemplateInfo = new BudgetTemplateInfo();
        budgetTemplateInfo.setId(BOSUuid.read((String)SYS_MIA_BUDGET_TEMPLATE_ID));
        schemeInfo.setTemplate(budgetTemplateInfo);
        schemeInfo.setBudgetPeriod(BudgetPeriodEnum.YEAR);
        schemeInfo.setBudgetYear(budgetYear);
        schemeInfo.setNumber("MIABudgetTemplate_" + budgetYear);
        schemeInfo.setName(MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_schemeName", LocaleUtils.locale_l1) + budgetYear, LocaleUtils.locale_l1);
        schemeInfo.setName(MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_schemeName", LocaleUtils.locale_l2) + budgetYear, LocaleUtils.locale_l2);
        schemeInfo.setName(MiaBudgetUpgradeUtil.getMulRes(ctx, "upgrade_schemeName", LocaleUtils.locale_l3) + budgetYear, LocaleUtils.locale_l3);
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setId(BOSUuid.read((String)CURRENCY_RMB_ID));
        schemeInfo.setCurrency(currencyInfo);
        Calendar calendar = Calendar.getInstance();
        calendar.set(budgetYear, 0, 1, 0, 0, 0);
        schemeInfo.setEffectDate(calendar.getTime());
        calendar.set(budgetYear, 11, 31);
        schemeInfo.setExpiryDate(calendar.getTime());
        schemeInfo.setState(StateEnum.ENABLE);
        cmpBudgetSchemeFactory.addnew(schemeInfo);
        return schemeInfo;
    }

    public class FieldMapper {
        String sourceField;
        String targetField;
        String queryField;

        public String getSourceField() {
            return this.sourceField;
        }

        public void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public String getTargetField() {
            return this.targetField;
        }

        public void setTargetField(String targetField) {
            this.targetField = targetField;
        }

        public String getQueryField() {
            return this.queryField;
        }

        public void setQueryField(String queryField) {
            this.queryField = queryField;
        }

        public FieldMapper(String sourceField, String queryField, String targetField) {
            this.sourceField = sourceField;
            this.targetField = targetField;
            this.queryField = queryField;
        }

        public FieldMapper() {
        }

        public String toString() {
            return "FieldMapper{sourceField='" + this.sourceField + '\'' + ", targetField='" + this.targetField + '\'' + ", queryField='" + this.queryField + '\'' + '}';
        }
    }
}

