/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.budget.AbstractSubBudgetManageFacadeControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetManageFacadeFactory;
import com.kingdee.shr.compensation.app.budget.BudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetSchemeRatioCollection;
import com.kingdee.shr.compensation.app.budget.BudgetSchemeRatioFactory;
import com.kingdee.shr.compensation.app.budget.BudgetSchemeRatioInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.CmpStandingBookInfo;
import com.kingdee.shr.compensation.app.budget.CmpUsedAmountFacadeFactory;
import com.kingdee.shr.compensation.app.budget.SubBudgetAssignTypeEnum;
import com.kingdee.shr.compensation.app.budget.SubBudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.SubBudgetQueryInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import com.kingdee.shr.compensation.budget.dto.BudgetStandingBookColumnRel;
import com.kingdee.shr.compensation.budget.dto.PeriodUsedAmount;
import com.kingdee.shr.compensation.budget.dto.SubBudgetStandingBookColumnRel;
import com.kingdee.shr.compensation.budget.dto.SubStandingBookItemRel;
import com.kingdee.shr.compensation.pojo.budget.BudgetImportData;
import com.kingdee.shr.compensation.pojo.budget.ImportItem;
import com.kingdee.shr.compensation.pojo.budget.PeriodQueryData;
import com.kingdee.shr.compensation.pojo.budget.PeriodTypeData;
import com.kingdee.shr.compensation.service.budget.DeductionParamUsedAmount;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.budget.BudgetUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class SubBudgetManageFacadeControllerBean
extends AbstractSubBudgetManageFacadeControllerBean {
    private static final String HALFYEAR = "halfYear";
    private static final String QUARTER = "quarter";
    private static final String MONTH = "month";
    private static final String FIRST_HALFYEAR = "firstHalfYear";
    private static final String LAST_HALFYEAR = "lastHalfYear";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.budget.SubBudgetManageFacadeControllerBean");
    private List<SubBudgetStandingBookColumnRel> subStandingBookExpenseList;
    private List<PeriodUsedAmount> periodUsedAmountList;
    private CmpBudgetSchemeInfo schemeInfo;
    private PeriodTypeData periodTypeData;
    private Map<String, PeriodQueryData> periodQueryMap;
    private Map<String, Map<String, SubBudgetManageInfo>> subBudgetManageMap;
    private boolean isInnerCalling = false;
    private DeductionParamUsedAmount refreshBalanceParam;

    @Override
    protected void _updateBudgetManage(Context ctx, String schemeId, List param) throws BOSException, EASBizException {
        if (null == param || param.isEmpty()) {
            return;
        }
        ArrayList<BudgetImportData> dataList = new ArrayList<BudgetImportData>();
        param.forEach(e -> {
            BudgetImportData data = (BudgetImportData)e;
            dataList.add(data);
        });
        this.initData(ctx, schemeId);
        ArrayList addNewManageParam = Lists.newArrayList();
        ArrayList updateManageParam = Lists.newArrayList();
        ArrayList manageLogParam = Lists.newArrayList();
        ArrayList standingBookSql = Lists.newArrayList();
        Map<String, Map<String, Object>> itemInfo = null;
        ArrayList idsList = Lists.newArrayList();
        ArrayList manageIds = Lists.newArrayList();
        for (BudgetImportData importData : dataList) {
            boolean isNew;
            if (itemInfo == null) {
                itemInfo = this.initManageItemInfo(ctx, importData);
            }
            if (isNew = importData.isIdNew()) {
                this.buildManageParam(ctx, importData, addNewManageParam, manageLogParam, true);
                if (this.schemeInfo.getBudgetPeriod() == BudgetPeriodEnum.YEAR) {
                    this.buildStandingBookParam(ctx, standingBookSql, importData);
                }
            } else {
                this.buildManageParam(ctx, importData, updateManageParam, manageLogParam, false);
            }
            if (!StringUtils.isEmpty((String)importData.getId())) {
                manageIds.add(importData.getId());
            }
            if (importData.getState() != 2) continue;
            idsList.add(importData.getId());
        }
        boolean notAssign = ((BudgetImportData)dataList.get(0)).isNotAssign();
        if (this.schemeInfo.getBudgetPeriod() != BudgetPeriodEnum.YEAR && !notAssign) {
            Map<String, Map<String, Object>> itemNumberMap = this.initManageItemInfo(itemInfo);
            this.buildSubManageParam(ctx, dataList, itemNumberMap);
        }
        if (!addNewManageParam.isEmpty()) {
            this.addNewBudgetManage(ctx, itemInfo, addNewManageParam);
        }
        if (!updateManageParam.isEmpty()) {
            this.updateBudgetManage(ctx, itemInfo, (List<Object[]>)updateManageParam);
        }
        boolean versionPositive = ((BudgetImportData)dataList.get(0)).isVersionPositive();
        BudgetAdjustService service = new BudgetAdjustService();
        service.updateManageVersion(ctx, manageIds, versionPositive);
        if (!manageLogParam.isEmpty()) {
            this.saveManageLogParam(ctx, itemInfo, manageLogParam);
        }
        if (!standingBookSql.isEmpty()) {
            CmpSQLUtil.executeBatchSql(ctx, standingBookSql.toArray());
        }
        if (!idsList.isEmpty()) {
            BudgetManageFacadeFactory.getLocalInstance(ctx).updateManageState(2, true, idsList, this.schemeInfo.getId().toString());
        }
        manageIds.forEach(e -> {
            BudgetManageInfo budgetManageInfo = new BudgetManageInfo();
            budgetManageInfo.setId(BOSUuid.read((String)e));
            this.refreshBalanceParam.getBudgetManageList().add(budgetManageInfo);
        });
        CmpUsedAmountFacadeFactory.getLocalInstance(ctx).refreshBalance(this.refreshBalanceParam);
    }

    private void initData(Context ctx, String schemeId) throws BOSException {
        this.refreshBalanceParam = new DeductionParamUsedAmount();
        this.schemeInfo = this.getBudgetSchemeInfo(ctx, schemeId);
        this.refreshBalanceParam.setBudgetTemplate(this.schemeInfo.getTemplate());
        this.periodTypeData = this.getBudgetSubItemPeriodType();
        this.periodQueryMap = this.initBudgetSubQueryDataByPeriodType();
        if (this.schemeInfo.getTemplate().getBudgetPeriod() != BudgetPeriodEnum.YEAR) {
            this.initSubBudgetManage(ctx);
        }
        this.subStandingBookExpenseList = BudgetUtil.initSubBudgetBookItemSumData(ctx, this.schemeInfo);
        this.periodUsedAmountList = BudgetUtil.initPeriodUsedAmountList(ctx, this.schemeInfo.getTemplate().getId().toString(), this.schemeInfo.getBudgetYear());
    }

    protected CmpBudgetSchemeInfo getBudgetSchemeInfo(Context ctx, String budgetSchemeId) throws BOSException {
        String oql = "select *, template.id, template.budgetPeriod, template.templateType where id = '" + budgetSchemeId + "'";
        return CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeCollection(oql).get(0);
    }

    private void buildStandingBookParam(Context ctx, List<String> standingBookSql, BudgetImportData importData) {
        StringBuilder standingParam = new StringBuilder();
        StringBuilder standingValue = new StringBuilder();
        this.initStandingParam(ctx, importData, standingParam, standingValue);
        standingParam.append(")");
        standingValue.append(")");
        standingBookSql.add(standingParam.append((CharSequence)standingValue).toString());
    }

    protected Map<String, Map<String, Object>> initManageItemInfo(Map<String, Map<String, Object>> itemInfo) {
        LinkedHashMap<String, Map<String, Object>> itemNumberMap = new LinkedHashMap<String, Map<String, Object>>();
        int index = 0;
        for (Map.Entry<String, Map<String, Object>> entry : itemInfo.entrySet()) {
            Map<String, Object> map = entry.getValue();
            int dataType = (Integer)map.get("dataType");
            int assignType = (Integer)map.get("assignType");
            if (1 == dataType || 0 == assignType) continue;
            map.put("itemIndex", index);
            itemNumberMap.put(entry.getKey(), map);
            ++index;
        }
        return itemNumberMap;
    }

    protected void saveManageLogParam(Context ctx, Map<String, Map<String, Object>> itemInfo, List<Object[]> manageLogParam) {
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = itemInfo.entrySet().iterator();
        StringBuilder strBuilder = new StringBuilder("insert into T_HR_SBudgetManageLog");
        StringBuilder filedBuilder = new StringBuilder("(");
        StringBuilder valueBuilder = new StringBuilder(" values(");
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, Object>> entry = iterator.next();
            filedBuilder.append(entry.getKey()).append(",");
            valueBuilder.append("?").append(",");
        }
        filedBuilder.append("FAdminOrgUnitID, FCostTypeID, FState, FOperateType, FBudgetSchemeId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime,fid)");
        valueBuilder.append("?,?,?,?,?,?,?,?,?, newbosid('B1CE0213'))");
        strBuilder.append((CharSequence)filedBuilder).append((CharSequence)valueBuilder);
        this.doExecuteBatch(ctx, strBuilder.toString(), manageLogParam);
    }

    private void updateBudgetManage(Context ctx, Map<String, Map<String, Object>> itemInfo, List<Object[]> updateManageParam) {
        StringBuilder strBuilder = new StringBuilder(" update T_HR_SBudgetManage set ");
        for (Map.Entry<String, Map<String, Object>> entry : itemInfo.entrySet()) {
            strBuilder.append(entry.getKey()).append("=?,");
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        strBuilder.append("FAdminOrgUnitID=?, FCostTypeID=?, FState=?, FRemark_l2 = ?, FForwarnContent=?, FBudgetYear=?, FBudgetSchemeID=?, FCurrencyID=?, FLastUpdateUserID=?, FLastUpdateTime=?");
        strBuilder.append(", FRemark_l1 = ?, FRemark_l3 = ? where fid = ?");
        this.doExecuteBatch(ctx, strBuilder.toString(), updateManageParam);
    }

    protected void addNewBudgetManage(Context ctx, Map<String, Map<String, Object>> itemInfo, List<Object[]> addNewManageParam) {
        StringBuilder strBuilder = new StringBuilder("insert into T_HR_SBudgetManage");
        StringBuilder filedBuilder = new StringBuilder("(");
        StringBuilder valueBuilder = new StringBuilder(" values(");
        for (Map.Entry<String, Map<String, Object>> entry : itemInfo.entrySet()) {
            filedBuilder.append(entry.getKey()).append(",");
            valueBuilder.append("?").append(",");
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        filedBuilder.append("FAdminOrgUnitID, FCostTypeID, FState, FRemark_l2, FForwarnContent, FBudgetYear, FBudgetSchemeID, FCurrencyID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, fid, FRemark_l1, FRemark_l3").append(")");
        valueBuilder.append("?,?,?,?,?,?,?,?,?,?,?,?,?,?,?").append(")");
        strBuilder.append((CharSequence)filedBuilder).append((CharSequence)valueBuilder);
        this.doExecuteBatch(ctx, strBuilder.toString(), addNewManageParam);
    }

    protected void doExecuteBatch(Context ctx, String sql, List<Object[]> paramList) {
        try {
            CmpSQLUtil.executeBatch(ctx, sql, paramList);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void buildSubManageParam(Context ctx, List<BudgetImportData> param, Map<String, Map<String, Object>> itemInfo) throws BOSException {
        SubBudgetAssignTypeEnum assignTypeEnum = this.schemeInfo.getSubBudgetAssignType();
        if (SubBudgetAssignTypeEnum.AVERAGE == assignTypeEnum) {
            this.initBudgetSubItemValueByAverage(ctx, param, itemInfo);
        } else if (SubBudgetAssignTypeEnum.PERCENT == assignTypeEnum) {
            BudgetSchemeRatioInfo budgetSchemeRatioInfo = this.initBudgetSchemeRatioInfo(ctx);
            this.initBudgetSubItemValueByPercent(ctx, param, itemInfo, budgetSchemeRatioInfo);
        } else if (SubBudgetAssignTypeEnum.MANUAL == assignTypeEnum) {
            BudgetSchemeRatioInfo budgetSchemeRatioInfo = this.initBudgetSchemeRatioInfo(ctx);
            this.initBudgetSubItemValueByManual(ctx, param, itemInfo, budgetSchemeRatioInfo);
        }
    }

    private void updateSubBudgetManage(Context ctx, String schemeId, Map<String, SubBudgetManageInfo> updateSubMap) throws BOSException {
        ArrayList<SubBudgetManageInfo> list = new ArrayList<SubBudgetManageInfo>(updateSubMap.values());
        try {
            this.isInnerCalling = true;
            this._updateSubBudgetManage(ctx, schemeId, list);
        }
        catch (BOSException | EASBizException e) {
            e.printStackTrace();
            throw new BOSException(e);
        }
    }

    public void initSubBudgetManage(Context ctx) {
        Set<String> filedSet = this.initSubType();
        String sql = "select distinct manage.fid manageId, budgetItem.FieldSn budgetSn, budgetItem.fid itemId, subManage.* from T_HR_SSubBudgetManage subManage  left join T_HR_SBudgetManage manage on manage.fid = subManage.FBudgetMangeID left join T_HR_SCmpBudgetItem budgetItem on budgetItem.fid = subManage.FCmpBudgetItemID where manage.FBudgetSchemeID = '" + this.schemeInfo.getId().toString() + "' and manage.FBudgetYear = " + this.schemeInfo.getBudgetYear();
        this.subBudgetManageMap = new HashMap<String, Map<String, SubBudgetManageInfo>>();
        try {
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
            while (rs.next()) {
                SubBudgetManageInfo subBudgetManageInfo;
                String manageId = rs.getString("manageId");
                String budgetCol = "T" + rs.getInt("budgetSn");
                Map<String, SubBudgetManageInfo> infoMap = this.subBudgetManageMap.get(manageId);
                if (null != infoMap) {
                    subBudgetManageInfo = infoMap.get(budgetCol);
                    if (null == subBudgetManageInfo) {
                        subBudgetManageInfo = new SubBudgetManageInfo();
                        infoMap.put(budgetCol, subBudgetManageInfo);
                    }
                } else {
                    infoMap = new HashMap<String, SubBudgetManageInfo>();
                    subBudgetManageInfo = new SubBudgetManageInfo();
                    infoMap.put(budgetCol, subBudgetManageInfo);
                    this.subBudgetManageMap.put(manageId, infoMap);
                }
                for (String str : filedSet) {
                    if (str.equals(FIRST_HALFYEAR)) {
                        subBudgetManageInfo.put(str, rs.getBigDecimal(FIRST_HALFYEAR));
                        continue;
                    }
                    subBudgetManageInfo.put(str.substring(1), rs.getBigDecimal(str));
                }
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
    }

    public Set<String> initSubType() {
        int division;
        HashSet<String> filedSet = new HashSet<String>();
        BudgetPeriodEnum periodType = this.schemeInfo.getTemplate().getBudgetPeriod();
        String dataName = null;
        if (1 == periodType.getValue()) {
            division = 2;
        } else if (2 == periodType.getValue()) {
            division = 4;
            dataName = "fquarter";
        } else {
            division = 12;
            dataName = "fmonth";
        }
        if (division == 2) {
            filedSet.add(FIRST_HALFYEAR);
            filedSet.add("fLastHalfYear");
        } else {
            for (int i = 1; i <= division; ++i) {
                filedSet.add(dataName + i);
            }
        }
        return filedSet;
    }

    protected void buildSubBudgetManageParam(Context ctx, Map<String, Map<String, Object>> itemInfo, BudgetPeriodEnum budgetPeriod, Map<String, Object[]> addSubMap, Map<String, Object[]> addSubQueryMap) {
        List<Object[]> addNewSubManageParam = this.convertSubManageParam(addSubMap);
        List<Object[]> addNewSubManageQueryParam = this.convertSubManageParam(addSubQueryMap);
        this.saveSubBudgetManage(ctx, itemInfo, budgetPeriod, addNewSubManageParam, addNewSubManageQueryParam);
    }

    protected List<Object[]> convertSubManageParam(Map<String, Object[]> map) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, Object[]> entrySub : map.entrySet()) {
            list.add(entrySub.getValue());
        }
        return list;
    }

    protected void saveSubBudgetManage(Context ctx, Map<String, Map<String, Object>> itemInfo, BudgetPeriodEnum budgetPeriod, List<Object[]> addNewSubManageParam, List<Object[]> addNewSubManageQueryParam) {
        this.saveCommonSubManageItem(ctx, budgetPeriod, addNewSubManageParam, null);
        if (addNewSubManageQueryParam.size() > 0) {
            this.addNewSubManageQueryParam(ctx, itemInfo, addNewSubManageQueryParam);
        }
    }

    private void saveCommonSubManageItem(Context ctx, BudgetPeriodEnum budgetPeriod, List<Object[]> addNewSubManageParam, List<Object[]> updateSubManageParam) {
        if (budgetPeriod == BudgetPeriodEnum.YEAR_HALFYEAR) {
            this.saveHalfYearParam(ctx, addNewSubManageParam, updateSubManageParam);
        } else if (budgetPeriod == BudgetPeriodEnum.YEAR_QUARTER) {
            this.saveQuarterParam(ctx, addNewSubManageParam, updateSubManageParam);
        } else {
            this.saveMonthParam(ctx, addNewSubManageParam, updateSubManageParam);
        }
    }

    protected void addNewSubManageQueryParam(Context ctx, Map<String, Map<String, Object>> itemInfo, List<Object[]> addNewSubManageQueryParam) {
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = itemInfo.entrySet().iterator();
        StringBuilder strBuilder = new StringBuilder("insert into T_HR_SSubBudgetQuery");
        StringBuilder filedBuilder = new StringBuilder("(");
        StringBuilder valueBuilder = new StringBuilder(" values(");
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, Object>> entry = iterator.next();
            filedBuilder.append(entry.getKey()).append(",");
            valueBuilder.append("?").append(",");
        }
        filedBuilder.append("FBudgetManageID, FPeriod, FEffectDate, FExpiryDate, fid").append(")");
        valueBuilder.append("?,?,?,?,?").append(")");
        strBuilder.append((CharSequence)filedBuilder).append((CharSequence)valueBuilder);
        this.doExecuteBatch(ctx, strBuilder.toString(), addNewSubManageQueryParam);
    }

    protected void saveMonthParam(Context ctx, List<Object[]> addNewSubManageParam, List<Object[]> updateSubManageParam) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String dateStr = "{ts '" + HRCmpReportUtil.dateFmt_yyyy_MM_dd.format(new java.util.Date()) + "'}";
        StringBuilder sql = new StringBuilder();
        if (!CmpStrUtil.isNullOrEmpty(addNewSubManageParam) && addNewSubManageParam.size() > 0) {
            sql.append("insert into T_HR_SSubBudgetManage").append("(FMonth1, FMonth2, FMonth3, FMonth4, FMonth5, FMonth6,").append(" FMonth7, FMonth8, FMonth9, FMonth10, FMonth11, FMonth12,").append(" FBudgetMangeID, FCmpBudgetItemID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, fid)").append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?").append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("newbosid('82CD7FA3'))");
            this.doExecuteBatch(ctx, sql.toString(), addNewSubManageParam);
        }
        if (!CmpStrUtil.isNullOrEmpty(updateSubManageParam) && updateSubManageParam.size() > 0) {
            sql.setLength(0);
            sql.append("update T_HR_SSubBudgetManage").append(" set FMonth1 = ?, FMonth2 = ?, FMonth3 = ?, FMonth4 = ?, FMonth5 = ?, FMonth6 = ?,").append(" FMonth7 = ?, FMonth8 = ?, FMonth9 = ?, FMonth10 = ?, FMonth11 = ?, FMonth12 = ?").append(",FLastUpdateUserID = ").append("'").append(userId).append("'").append(",FLastUpdateTime = ").append(dateStr).append(" where FBudgetMangeID = ? and FCmpBudgetItemID = ?");
            this.doExecuteBatch(ctx, sql.toString(), updateSubManageParam);
        }
    }

    protected void saveQuarterParam(Context ctx, List<Object[]> addNewSubManageParam, List<Object[]> updateSubManageParam) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String dateStr = "{ts '" + HRCmpReportUtil.dateFmt_yyyy_MM_dd.format(new java.util.Date()) + "'}";
        StringBuilder sql = new StringBuilder();
        if (!CmpStrUtil.isNullOrEmpty(addNewSubManageParam) && addNewSubManageParam.size() > 0) {
            sql.append("insert into T_HR_SSubBudgetManage").append("(FQuarter1, FQuarter2, FQuarter3, FQuarter4, FBudgetMangeID, FCmpBudgetItemID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime,fid)").append(" values(?,?,?,?,?,?").append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("newbosid('82CD7FA3'))");
            this.doExecuteBatch(ctx, sql.toString(), addNewSubManageParam);
        }
        if (!CmpStrUtil.isNullOrEmpty(updateSubManageParam) && updateSubManageParam.size() > 0) {
            sql.setLength(0);
            sql.append("update T_HR_SSubBudgetManage").append(" set FQuarter1 = ?, FQuarter2 = ?, FQuarter3 = ?, FQuarter4 = ?").append(",FLastUpdateUserID = ").append("'").append(userId).append("'").append(",FLastUpdateTime = ").append(dateStr).append(" where FBudgetMangeID = ? and FCmpBudgetItemID = ?");
            this.doExecuteBatch(ctx, sql.toString(), updateSubManageParam);
        }
    }

    protected void saveHalfYearParam(Context ctx, List<Object[]> addNewSubManageParam, List<Object[]> updateSubManageParam) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String dateStr = "{ts '" + HRCmpReportUtil.dateFmt_yyyy_MM_dd.format(new java.util.Date()) + "'}";
        StringBuilder sql = new StringBuilder();
        if (!CmpStrUtil.isNullOrEmpty(addNewSubManageParam) && addNewSubManageParam.size() > 0) {
            sql.append("insert into T_HR_SSubBudgetManage").append("(FirstHalfYear, FLastHalfYear, FBudgetMangeID, FCmpBudgetItemID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, fid)").append(" values(?,?,?,?").append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("newbosid('82CD7FA3'))");
            this.doExecuteBatch(ctx, sql.toString(), addNewSubManageParam);
        }
        if (!CmpStrUtil.isNullOrEmpty(updateSubManageParam) && updateSubManageParam.size() > 0) {
            sql.setLength(0);
            sql.append("update T_HR_SSubBudgetManage").append(" set FirstHalfYear = ?, FLastHalfYear = ?").append(",FLastUpdateUserID = ").append("'").append(userId).append("'").append(",FLastUpdateTime = ").append(dateStr).append(" where FBudgetMangeID = ? and FCmpBudgetItemID = ?");
            this.doExecuteBatch(ctx, sql.toString(), updateSubManageParam);
        }
    }

    protected Map<String, PeriodQueryData> initBudgetSubQueryDataByPeriodType() {
        int month;
        String period;
        HashMap periodQueryMap = Maps.newHashMap();
        int division = this.periodTypeData.getDivision();
        if (division == 2) {
            period = this.schemeInfo.getBudgetYear() + "H";
            month = 6;
        } else if (division == 4) {
            period = this.schemeInfo.getBudgetYear() + "Q";
            month = 3;
        } else {
            period = this.schemeInfo.getBudgetYear() + "M";
            month = 1;
        }
        Calendar calendar = Calendar.getInstance();
        java.util.Date effectDate = this.schemeInfo.getEffectDate();
        java.util.Date expiryDate = this.schemeInfo.getExpiryDate();
        for (int i = 1; i <= division; ++i) {
            calendar.setTime(effectDate);
            calendar.add(2, month);
            calendar.add(5, -1);
            PeriodQueryData periodQueryData = new PeriodQueryData();
            periodQueryData.setEffectDate(effectDate);
            if (i == division) {
                periodQueryData.setExpiryDate(expiryDate);
            } else {
                periodQueryData.setExpiryDate(calendar.getTime());
            }
            String key = i < 10 ? period + "0" + i : period + i;
            periodQueryData.setPeriod(key);
            periodQueryMap.put(key, periodQueryData);
            calendar.add(5, 1);
            effectDate = calendar.getTime();
        }
        return periodQueryMap;
    }

    protected void initBudgetSubItemValueByAverage(Context ctx, List<BudgetImportData> param, Map<String, Map<String, Object>> itemInfo) throws BOSException {
        List<BudgetImportData> newList = param.stream().filter(BudgetImportData::isIdNew).collect(Collectors.toList());
        List<BudgetImportData> updateList = param.stream().filter(e -> !e.isIdNew()).collect(Collectors.toList());
        if (!newList.isEmpty()) {
            HashMap<String, Object[]> addSubMap = new HashMap<String, Object[]>();
            HashMap<String, Object[]> subQueryMap = new HashMap<String, Object[]>();
            List<String> batchSQL = this.buildSubManageItemParamByAverage(ctx, itemInfo, newList, addSubMap, subQueryMap);
            if (!batchSQL.isEmpty()) {
                CmpSQLUtil.executeBatchSql(ctx, batchSQL.toArray());
            }
            this.buildSubBudgetManageParam(ctx, itemInfo, this.schemeInfo.getBudgetPeriod(), addSubMap, subQueryMap);
        }
        if (!updateList.isEmpty()) {
            Map<String, SubBudgetManageInfo> updateSubMap = this.buildCommonSubManageItemParam(itemInfo, updateList);
            this.updateSubBudgetManage(ctx, this.schemeInfo.getId().toString(), updateSubMap);
        }
    }

    protected Map<String, SubBudgetManageInfo> buildCommonSubManageItemParam(Map<String, Map<String, Object>> itemInfo, List<BudgetImportData> updateList) {
        HashMap<String, SubBudgetManageInfo> updateSubMap = new HashMap<String, SubBudgetManageInfo>();
        for (BudgetImportData importData : updateList) {
            Map<String, SubBudgetManageInfo> subManageMap = this.subBudgetManageMap.get(importData.getId());
            if (null == subManageMap) {
                subManageMap = new HashMap<String, SubBudgetManageInfo>();
            }
            List<ImportItem> importItemList = importData.getImportItemList();
            for (ImportItem importItem : importItemList) {
                String budgetColumn = importItem.getColumn();
                if (!itemInfo.containsKey(budgetColumn)) continue;
                Map<String, Object> map = itemInfo.get(budgetColumn);
                String budgetItemId = (String)map.get("itemId");
                String subKey = importData.getId() + "_" + budgetItemId;
                SubBudgetManageInfo newInfo = (SubBudgetManageInfo)updateSubMap.get(subKey);
                if (null == newInfo) {
                    newInfo = new SubBudgetManageInfo();
                    CmpBudgetItemInfo cmpBudgetItemInfo = new CmpBudgetItemInfo();
                    cmpBudgetItemInfo.setId(BOSUuid.read((String)budgetItemId));
                    newInfo.setCmpBudgetItem(cmpBudgetItemInfo);
                    BudgetManageInfo manageInfo = new BudgetManageInfo();
                    manageInfo.setId(BOSUuid.read((String)importData.getId()));
                    newInfo.setBudgetMange(manageInfo);
                    updateSubMap.put(subKey, newInfo);
                }
                BigDecimal itemValue = CmpStrUtil.isEmpty(importItem.getValue()) ? null : new BigDecimal(importItem.getValue());
                SubBudgetManageInfo oldInfo = subManageMap.get(budgetColumn);
                BigDecimal oldValue = BigDecimal.ZERO;
                String subBudgetItemColumn = null;
                int division = this.periodTypeData.getDivision();
                String periodType = this.periodTypeData.getPeriodType();
                for (int i = 0; i < division; ++i) {
                    subBudgetItemColumn = this.getSubFieldName(periodType, i);
                    if (itemValue == null) {
                        newInfo.put(subBudgetItemColumn, null);
                        continue;
                    }
                    BigDecimal oldBigValue = BigDecimal.ZERO;
                    if (oldInfo != null && oldInfo.get(subBudgetItemColumn) != null) {
                        oldBigValue = (BigDecimal)oldInfo.get(subBudgetItemColumn);
                    }
                    newInfo.put(subBudgetItemColumn, oldBigValue);
                    oldValue = oldValue.add(oldBigValue);
                }
                if (itemValue == null) continue;
                Optional<SubBudgetStandingBookColumnRel> manageOptional = this.subStandingBookExpenseList.stream().filter(e -> e.getManageId().equals(importData.getId())).findAny();
                List<SubStandingBookItemRel> subStandingBookItemRelList = null;
                if (manageOptional.isPresent()) {
                    SubBudgetStandingBookColumnRel subRel = manageOptional.get();
                    subStandingBookItemRelList = subRel.getSubStandingBookItemRelList();
                }
                if (itemValue.compareTo(oldValue) >= 0) {
                    newInfo.put(subBudgetItemColumn, itemValue.subtract(oldValue).add(newInfo.get(subBudgetItemColumn) == null ? BigDecimal.ZERO : (BigDecimal)newInfo.get(subBudgetItemColumn)));
                    continue;
                }
                if (null != subStandingBookItemRelList && !subStandingBookItemRelList.isEmpty()) {
                    BigDecimal periodSumBudget = BigDecimal.ZERO;
                    for (int i = 0; i < division; ++i) {
                        SubStandingBookItemRel stdItem = subStandingBookItemRelList.get(i);
                        BigDecimal totalExpense = this.getSubExpenseByBudget(stdItem, budgetColumn);
                        subBudgetItemColumn = this.getSubFieldName(periodType, i);
                        BigDecimal usedAmount = BigDecimal.ZERO;
                        Optional<PeriodUsedAmount> optional = this.periodUsedAmountList.stream().filter(e -> e.getSubStandingBookId().equals(stdItem.getSubBookTableId())).findAny();
                        if (optional.isPresent()) {
                            usedAmount = optional.get().getBudgetAmount().get(budgetColumn);
                            usedAmount = usedAmount == null ? BigDecimal.ZERO : usedAmount;
                        }
                        BigDecimal periodBudget = totalExpense.add(usedAmount);
                        newInfo.put(subBudgetItemColumn, periodBudget);
                        periodSumBudget = periodSumBudget.add(periodBudget);
                    }
                    BigDecimal remaining = itemValue.subtract(periodSumBudget).add((BigDecimal)newInfo.get(subBudgetItemColumn));
                    newInfo.put(subBudgetItemColumn, remaining);
                    continue;
                }
                for (int i = 0; i < division; ++i) {
                    subBudgetItemColumn = this.getSubFieldName(periodType, i);
                    if (i == division - 1) {
                        newInfo.put(subBudgetItemColumn, itemValue);
                        continue;
                    }
                    newInfo.put(subBudgetItemColumn, null);
                }
            }
        }
        return updateSubMap;
    }

    protected BigDecimal getSubExpenseByBudget(SubStandingBookItemRel stdItem, String budgetColumn) {
        Optional<BudgetStandingBookColumnRel> optional = stdItem.getBudgetStandingBookColumnRelList().stream().filter(e -> e.getBudgetColumn().equals(budgetColumn)).findAny();
        if (!optional.isPresent()) {
            return BigDecimal.ZERO;
        }
        BudgetStandingBookColumnRel rel = optional.get();
        return rel.getTotalExpense() == null ? BigDecimal.ZERO : rel.getTotalExpense();
    }

    protected String getSubFieldName(String periodType, int i) {
        String type = HALFYEAR.equals(periodType) ? (i == 0 ? FIRST_HALFYEAR : LAST_HALFYEAR) : periodType + (i + 1);
        return type;
    }

    protected List<String> buildSubManageItemParamByAverage(Context ctx, Map<String, Map<String, Object>> itemInfo, List<BudgetImportData> newList, Map<String, Object[]> addSubMap, Map<String, Object[]> subQueryMap) {
        int division = this.periodTypeData.getDivision();
        BigDecimal decDivision = new BigDecimal(division);
        int itemSize = itemInfo.size();
        String periodType = this.periodTypeData.getPeriodType();
        String tag = this.getTagByPeriodType(this.schemeInfo, periodType);
        ArrayList batchSQL = Lists.newArrayList();
        for (BudgetImportData importData : newList) {
            StringBuilder standingParam = new StringBuilder();
            StringBuilder standingValue = new StringBuilder();
            this.initStandingParam(ctx, importData, standingParam, standingValue);
            HashMap<String, StringBuilder> subStandingBookSqlMap = new HashMap<String, StringBuilder>();
            List<ImportItem> importItemList = importData.getImportItemList();
            for (ImportItem importItem : importItemList) {
                String subQueryKey;
                Object[] param;
                String budgetCol = importItem.getColumn();
                if (!itemInfo.containsKey(budgetCol)) continue;
                BigDecimal itemValue = CmpStrUtil.isEmpty(importItem.getValue()) ? BigDecimal.ZERO : new BigDecimal(importItem.getValue());
                Map<String, Object> map = itemInfo.get(budgetCol);
                String itemId = (String)map.get("itemId");
                int itemIndex = (Integer)map.get("itemIndex");
                String subKey = importData.getId() + "_" + itemId;
                if (addSubMap.containsKey(subKey)) {
                    param = addSubMap.get(subKey);
                } else {
                    param = new Object[division + 2];
                    addSubMap.put(subKey, param);
                }
                BigDecimal remainder = itemValue.remainder(decDivision);
                BigDecimal divValue = itemValue.subtract(remainder).divide(decDivision);
                for (int i = 0; i < division - 1; ++i) {
                    param[i] = divValue;
                    subQueryKey = importData.getId() + "_" + periodType + (i + 1);
                    this.initQueryAndStandingBookParam(ctx, subQueryMap, importData, itemSize, tag, subStandingBookSqlMap, itemIndex, divValue, subQueryKey, i);
                }
                BigDecimal lastValue = itemValue.subtract(divValue.multiply(new BigDecimal(division - 1)));
                param[division - 1] = lastValue;
                param[division] = importData.getId();
                param[division + 1] = itemId;
                subQueryKey = importData.getId() + "_" + periodType + division;
                this.initQueryAndStandingBookParam(ctx, subQueryMap, importData, itemSize, tag, subStandingBookSqlMap, itemIndex, lastValue, subQueryKey, division - 1);
            }
            this.addSubAndStandingBookSql(batchSQL, standingParam, standingValue, division, subStandingBookSqlMap);
        }
        return batchSQL;
    }

    private void addSubAndStandingBookSql(List<String> batchSQL, StringBuilder standingParam, StringBuilder standingValue, int division, Map<String, StringBuilder> subStandingBookSqlMap) {
        standingParam.append(")");
        standingValue.append(")");
        batchSQL.add(standingParam.append((CharSequence)standingValue).toString());
        for (int i = 0; i < division; ++i) {
            StringBuilder subStandingParam = subStandingBookSqlMap.get(i + "param");
            StringBuilder subStandingValue = subStandingBookSqlMap.get(i + "value");
            subStandingParam.append(")");
            subStandingValue.append(")");
            batchSQL.add(subStandingParam.append((CharSequence)subStandingValue).toString());
        }
    }

    private void initSubStandingParam(Context ctx, String standingBookId, String queryId, StringBuilder subStandingParam, StringBuilder subStandingValue) {
        subStandingParam.append("insert into T_HR_SubCmpStandingBook").append("(FCmpStandingBookID, FSubBudgetQueryID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FID");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String dateStr = "{ts '" + HRCmpReportUtil.dateFmt_yyyy_MM_dd.format(new java.util.Date()) + "'}";
        subStandingValue.append(" values(").append("'").append(standingBookId).append("'").append(",").append("'").append(queryId).append("'").append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("newBosId('81534082')");
    }

    private void initStandingParam(Context ctx, BudgetImportData importData, StringBuilder standingParam, StringBuilder standingValue) {
        standingParam.append("insert into T_HR_SCmpStandingBook").append("(FBudgetManageID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FID");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String dateStr = "{ts '" + HRCmpReportUtil.dateFmt_yyyy_MM_dd.format(new java.util.Date()) + "'}";
        String standingBookId = BOSUuid.create((BOSObjectType)new CmpStandingBookInfo().getBOSType()).toString();
        standingValue.append(" values(").append("'").append(importData.getId()).append("'").append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("'").append(userId).append("'").append(",").append(dateStr).append(",").append("'").append(standingBookId).append("'");
        importData.setStandingBookId(standingBookId);
    }

    protected String initSubQueryOtherParam(BudgetImportData importData, Object[] queryParam, int itemSize, String tag, int i) {
        int j = i + 1;
        String periodTag = i < 9 ? tag + "0" + j : tag + j;
        PeriodQueryData periodQueryData = this.periodQueryMap.get(periodTag);
        queryParam[itemSize] = importData.getId();
        queryParam[itemSize + 1] = periodQueryData.getPeriod();
        queryParam[itemSize + 2] = new Date(periodQueryData.getEffectDate().getTime());
        queryParam[itemSize + 3] = new Date(periodQueryData.getExpiryDate().getTime());
        String queryId = BOSUuid.create((BOSObjectType)new SubBudgetQueryInfo().getBOSType()).toString();
        queryParam[itemSize + 4] = queryId;
        return queryId;
    }

    protected BudgetSchemeRatioInfo initBudgetSchemeRatioInfo(Context ctx) {
        BudgetSchemeRatioInfo budgetSchemeRatioInfo = new BudgetSchemeRatioInfo();
        try {
            BudgetSchemeRatioCollection budgetSchemeRatioCollection = BudgetSchemeRatioFactory.getLocalInstance(ctx).getBudgetSchemeRatioCollection("select * where budgetScheme = '" + this.schemeInfo.getId().toString() + "'");
            if (budgetSchemeRatioCollection.size() > 0) {
                budgetSchemeRatioInfo = budgetSchemeRatioCollection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return budgetSchemeRatioInfo;
    }

    protected PeriodTypeData getBudgetSubItemPeriodType() {
        PeriodTypeData periodTypeData = new PeriodTypeData();
        if (this.schemeInfo.getBudgetPeriod() == BudgetPeriodEnum.YEAR_HALFYEAR) {
            periodTypeData.setDivision(2);
            periodTypeData.setPeriodType(HALFYEAR);
        } else if (this.schemeInfo.getBudgetPeriod() == BudgetPeriodEnum.YEAR_QUARTER) {
            periodTypeData.setDivision(4);
            periodTypeData.setPeriodType(QUARTER);
        } else {
            periodTypeData.setDivision(12);
            periodTypeData.setPeriodType(MONTH);
        }
        return periodTypeData;
    }

    protected void initBudgetSubItemValueByPercent(Context ctx, List<BudgetImportData> param, Map<String, Map<String, Object>> itemInfo, BudgetSchemeRatioInfo budgetSchemeRatioInfo) throws BOSException {
        List<BudgetImportData> newList = param.stream().filter(BudgetImportData::isIdNew).collect(Collectors.toList());
        List<BudgetImportData> updateList = param.stream().filter(e -> !e.isIdNew()).collect(Collectors.toList());
        if (!newList.isEmpty()) {
            HashMap<String, Object[]> addSubMap = new HashMap<String, Object[]>();
            HashMap<String, Object[]> subQueryMap = new HashMap<String, Object[]>();
            List<String> batchSQL = this.buildSubManageItemParamByPercent(ctx, itemInfo, budgetSchemeRatioInfo, newList, addSubMap, subQueryMap);
            if (!batchSQL.isEmpty()) {
                CmpSQLUtil.executeBatchSql(ctx, batchSQL.toArray());
            }
            this.buildSubBudgetManageParam(ctx, itemInfo, this.schemeInfo.getBudgetPeriod(), addSubMap, subQueryMap);
        }
        if (!updateList.isEmpty()) {
            Map<String, SubBudgetManageInfo> updateSubMap = this.buildCommonSubManageItemParam(itemInfo, updateList);
            this.updateSubBudgetManage(ctx, this.schemeInfo.getId().toString(), updateSubMap);
        }
    }

    protected List<String> buildSubManageItemParamByPercent(Context ctx, Map<String, Map<String, Object>> itemInfo, BudgetSchemeRatioInfo budgetSchemeRatioInfo, List<BudgetImportData> newList, Map<String, Object[]> addSubMap, Map<String, Object[]> subQueryMap) {
        int division = this.periodTypeData.getDivision();
        String periodType = this.periodTypeData.getPeriodType();
        int itemSize = itemInfo.size();
        String tag = this.getTagByPeriodType(this.schemeInfo, periodType);
        BigDecimal base = new BigDecimal(100);
        ArrayList batchSQL = Lists.newArrayList();
        for (BudgetImportData importData : newList) {
            StringBuilder standingParam = new StringBuilder();
            StringBuilder standingValue = new StringBuilder();
            this.initStandingParam(ctx, importData, standingParam, standingValue);
            HashMap<String, StringBuilder> subStandingBookSqlMap = new HashMap<String, StringBuilder>();
            List<ImportItem> importItemList = importData.getImportItemList();
            for (ImportItem importItem : importItemList) {
                String subQueryKey;
                Object[] param;
                String budgetCol = importItem.getColumn();
                if (!itemInfo.containsKey(budgetCol)) continue;
                BigDecimal itemValue = CmpStrUtil.isEmpty(importItem.getValue()) ? BigDecimal.ZERO : new BigDecimal(importItem.getValue());
                Map<String, Object> map = itemInfo.get(budgetCol);
                String itemId = (String)map.get("itemId");
                int itemIndex = (Integer)map.get("itemIndex");
                String subKey = importData.getId() + "_" + itemId;
                if (addSubMap.containsKey(subKey)) {
                    param = addSubMap.get(subKey);
                } else {
                    param = new Object[division + 2];
                    addSubMap.put(subKey, param);
                }
                if (budgetSchemeRatioInfo == null || budgetSchemeRatioInfo.isEmpty()) {
                    this.initBudgetSubItemNotExistsRatio(ctx, itemSize, division, param, itemValue, subQueryMap, periodType, importData, tag, itemIndex, subStandingBookSqlMap, budgetCol);
                } else if (HALFYEAR.equals(periodType)) {
                    BigDecimal firstValue = itemValue.multiply(budgetSchemeRatioInfo.getBigDecimal(FIRST_HALFYEAR)).divide(base);
                    BigDecimal lastValue = itemValue.multiply(budgetSchemeRatioInfo.getBigDecimal(LAST_HALFYEAR)).divide(base);
                    param[0] = firstValue;
                    param[1] = lastValue;
                    subQueryKey = importData.getId() + "_" + FIRST_HALFYEAR;
                    this.initQueryAndStandingBookParam(ctx, subQueryMap, importData, itemSize, tag, subStandingBookSqlMap, itemIndex, firstValue, subQueryKey, 0);
                    subQueryKey = importData.getId() + "_" + LAST_HALFYEAR;
                    this.initQueryAndStandingBookParam(ctx, subQueryMap, importData, itemSize, tag, subStandingBookSqlMap, itemIndex, lastValue, subQueryKey, 1);
                } else {
                    for (int i = 0; i < division; ++i) {
                        BigDecimal value = itemValue.multiply(budgetSchemeRatioInfo.getBigDecimal(periodType + (i + 1))).divide(base);
                        param[i] = value;
                        subQueryKey = importData.getId() + "_" + periodType + (i + 1);
                        this.initQueryAndStandingBookParam(ctx, subQueryMap, importData, itemSize, tag, subStandingBookSqlMap, itemIndex, value, subQueryKey, i);
                    }
                }
                param[division] = importData.getId();
                param[division + 1] = itemId;
            }
            this.addSubAndStandingBookSql(batchSQL, standingParam, standingValue, division, subStandingBookSqlMap);
        }
        return batchSQL;
    }

    protected void initQueryAndStandingBookParam(Context ctx, Map<String, Object[]> subQueryMap, BudgetImportData importData, int itemSize, String tag, Map<String, StringBuilder> subStandingBookSqlMap, int itemIndex, BigDecimal value, String subQueryKey, int index) {
        Object[] queryParam;
        if (subQueryMap.containsKey(subQueryKey)) {
            queryParam = subQueryMap.get(subQueryKey);
        } else {
            queryParam = new Object[itemSize + 5];
            subQueryMap.put(subQueryKey, queryParam);
            String queryId = this.initSubQueryOtherParam(importData, queryParam, itemSize, tag, index);
            StringBuilder subStandingParam = new StringBuilder();
            StringBuilder subStandingValue = new StringBuilder();
            this.initSubStandingParam(ctx, importData.getStandingBookId(), queryId, subStandingParam, subStandingValue);
            subStandingBookSqlMap.put(index + "param", subStandingParam);
            subStandingBookSqlMap.put(index + "value", subStandingValue);
        }
        queryParam[itemIndex] = value;
    }

    protected void initBudgetSubItemNotExistsRatio(Context ctx, int itemSize, int division, Object[] param, BigDecimal itemValue, Map<String, Object[]> subQueryMap, String periodType, BudgetImportData importData, String tag, int itemIndex, Map<String, StringBuilder> subStandingBookSqlMap, String column) {
        BigDecimal zero = BigDecimal.ZERO;
        for (int i = 0; i < division - 1; ++i) {
            param[i] = zero;
            String subQueryKey = importData.getId() + "_" + periodType + (i + 1);
            this.initQueryAndStandingBookParam(ctx, subQueryMap, importData, itemSize, tag, subStandingBookSqlMap, itemIndex, zero, subQueryKey, i);
        }
        param[division - 1] = itemValue;
        String subQueryKey = importData.getId() + "_" + periodType + division;
        this.initQueryAndStandingBookParam(ctx, subQueryMap, importData, itemSize, tag, subStandingBookSqlMap, itemIndex, itemValue, subQueryKey, division - 1);
    }

    protected void initBudgetSubItemValueByManual(Context ctx, List<BudgetImportData> param, Map<String, Map<String, Object>> itemInfo, BudgetSchemeRatioInfo budgetSchemeRatioInfo) throws BOSException {
        List<BudgetImportData> newList = param.stream().filter(BudgetImportData::isIdNew).collect(Collectors.toList());
        List<BudgetImportData> updateList = param.stream().filter(e -> !e.isIdNew()).collect(Collectors.toList());
        if (!newList.isEmpty()) {
            HashMap<String, Object[]> addSubMap = new HashMap<String, Object[]>();
            HashMap<String, Object[]> subQueryMap = new HashMap<String, Object[]>();
            List<String> batchSQL = this.buildSubManageItemParamByManual(ctx, itemInfo, budgetSchemeRatioInfo, newList, addSubMap, subQueryMap);
            if (!batchSQL.isEmpty()) {
                CmpSQLUtil.executeBatchSql(ctx, batchSQL.toArray());
            }
            this.buildSubBudgetManageParam(ctx, itemInfo, this.schemeInfo.getBudgetPeriod(), addSubMap, subQueryMap);
        }
        if (!updateList.isEmpty()) {
            Map<String, SubBudgetManageInfo> updateSubMap = this.buildCommonSubManageItemParam(itemInfo, updateList);
            this.updateSubBudgetManage(ctx, this.schemeInfo.getId().toString(), updateSubMap);
        }
    }

    protected List<String> buildSubManageItemParamByManual(Context ctx, Map<String, Map<String, Object>> itemInfo, BudgetSchemeRatioInfo budgetSchemeRatioInfo, List<BudgetImportData> newList, Map<String, Object[]> addSubMap, Map<String, Object[]> subQueryMap) {
        int division = this.periodTypeData.getDivision();
        String periodType = this.periodTypeData.getPeriodType();
        String tag = this.getTagByPeriodType(this.schemeInfo, periodType);
        int itemSize = itemInfo.size();
        BigDecimal zero = BigDecimal.ZERO;
        ArrayList batchSQL = Lists.newArrayList();
        for (BudgetImportData importData : newList) {
            StringBuilder standingParam = new StringBuilder();
            StringBuilder standingValue = new StringBuilder();
            this.initStandingParam(ctx, importData, standingParam, standingValue);
            HashMap<String, StringBuilder> subStandingBookSqlMap = new HashMap<String, StringBuilder>();
            List<ImportItem> importItemList = importData.getImportItemList();
            for (ImportItem importItem : importItemList) {
                Object[] param;
                String column = importItem.getColumn();
                if (!itemInfo.containsKey(column)) continue;
                BigDecimal itemValue = CmpStrUtil.isEmpty(importItem.getValue()) ? BigDecimal.ZERO : new BigDecimal(importItem.getValue());
                Map<String, Object> map = itemInfo.get(column);
                String itemId = (String)map.get("itemId");
                int itemIndex = (Integer)map.get("itemIndex");
                String subKey = importData.getId() + "_" + itemId;
                if (addSubMap.containsKey(subKey)) {
                    param = addSubMap.get(subKey);
                } else {
                    param = new Object[division + 2];
                    addSubMap.put(subKey, param);
                }
                int interruptionPos = 0;
                if (budgetSchemeRatioInfo == null || budgetSchemeRatioInfo.isEmpty()) {
                    this.initBudgetSubItemNotExistsRatio(ctx, itemSize, division, param, itemValue, subQueryMap, periodType, importData, tag, itemIndex, subStandingBookSqlMap, column);
                } else {
                    for (int i = 0; i < division; ++i) {
                        BigDecimal value;
                        String type = this.getSubFieldName(periodType, i);
                        BigDecimal beforeValue = budgetSchemeRatioInfo.getBigDecimal(type);
                        BigDecimal tempValue = itemValue.subtract(beforeValue);
                        if (tempValue.compareTo(zero) > 0) {
                            value = beforeValue;
                        } else if (interruptionPos == 0) {
                            value = itemValue;
                            interruptionPos = i + 1;
                        } else {
                            value = zero;
                        }
                        param[i] = value;
                        String subQueryKey = importData.getId() + "_" + periodType + (i + 1);
                        this.initQueryAndStandingBookParam(ctx, subQueryMap, importData, itemSize, tag, subStandingBookSqlMap, itemIndex, value, subQueryKey, i);
                        itemValue = tempValue;
                    }
                }
                param[division] = importData.getId();
                param[division + 1] = itemId;
            }
            this.addSubAndStandingBookSql(batchSQL, standingParam, standingValue, division, subStandingBookSqlMap);
        }
        return batchSQL;
    }

    protected Map<String, Map<String, Object>> initManageItemInfo(Context ctx, BudgetImportData importData) {
        LinkedHashMap<String, Map<String, Object>> itemInfo = new LinkedHashMap<String, Map<String, Object>>();
        StringBuilder strBuilder = new StringBuilder();
        List<ImportItem> importItemList = importData.getImportItemList();
        for (ImportItem importItem : importItemList) {
            String column = importItem.getColumn();
            strBuilder.append(column.substring(1)).append(",");
        }
        strBuilder.deleteCharAt(strBuilder.length() - 1);
        String sql = "select item.fid, item.fieldSn, item.FDataType, sbtItem.FIsSubBudgetAssign from T_HR_SCmpBudgetItem item left join T_HR_SBudgetTemplateItem sbtItem on sbtItem.FBudgetItemID = item.fid where item.fieldSn in (" + strBuilder + ") and sbtItem.FTemplateID = '" + this.schemeInfo.getTemplate().getId().toString() + "' order by item.fieldSn asc";
        try {
            int index = 0;
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
            while (rs.next()) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("itemId", rs.getString("fid"));
                map.put("dataType", rs.getInt("FDataType"));
                map.put("itemIndex", index);
                map.put("assignType", rs.getInt("FIsSubBudgetAssign"));
                ++index;
                itemInfo.put("T" + rs.getInt("fieldSn"), map);
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return itemInfo;
    }

    protected void buildManageParam(Context ctx, BudgetImportData importData, List<Object[]> manageParam, List<Object[]> manageLogParam, boolean isNew) {
        List<ImportItem> importItemList = importData.getImportItemList();
        int size = importItemList.size();
        Object[] param = isNew ? new Object[size + 15] : new Object[size + 13];
        Object[] logParam = new Object[size + 9];
        for (int i = 0; i < size; ++i) {
            ImportItem importItem = importItemList.get(i);
            String value = CmpStrUtil.isEmpty(importItem.getValue()) ? null : importItem.getValue();
            param[i] = value;
            logParam[i] = value;
        }
        this.buildManageParam(ctx, importData, manageParam, size, param, isNew);
        this.buildManageLogParam(ctx, importData, manageLogParam, size, logParam);
    }

    protected void buildManageLogParam(Context ctx, BudgetImportData importData, List<Object[]> manageLogParam, int size, Object[] logParam) {
        logParam[size] = importData.getAdminId();
        logParam[size + 1] = importData.getCostTypeId();
        logParam[size + 2] = importData.getState();
        logParam[size + 3] = importData.getOperateType();
        logParam[size + 4] = this.schemeInfo.getId().toString();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        logParam[size + 5] = userId;
        logParam[size + 6] = timeStamp;
        logParam[size + 7] = userId;
        logParam[size + 8] = timeStamp;
        manageLogParam.add(logParam);
    }

    protected void buildManageParam(Context ctx, BudgetImportData importData, List<Object[]> manageParam, int size, Object[] param, boolean isNew) {
        param[size] = importData.getAdminId();
        param[size + 1] = importData.getCostTypeId();
        param[size + 2] = importData.getState();
        param[size + 3] = importData.getRemark();
        param[size + 4] = importData.getForwarnContent();
        param[size + 5] = this.schemeInfo.getBudgetYear();
        param[size + 6] = this.schemeInfo.getId().toString();
        param[size + 7] = this.schemeInfo.getCurrency() == null ? "" : this.schemeInfo.getCurrency().getId().toString();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        if (isNew) {
            param[size + 8] = userId;
            param[size + 9] = timeStamp;
            param[size + 10] = userId;
            param[size + 11] = timeStamp;
            param[size + 12] = importData.getId();
            param[size + 13] = importData.getRemark1();
            param[size + 14] = importData.getRemark3();
        } else {
            param[size + 8] = userId;
            param[size + 9] = timeStamp;
            param[size + 10] = importData.getRemark1();
            param[size + 11] = importData.getRemark3();
            param[size + 12] = importData.getId();
        }
        manageParam.add(param);
    }

    @Override
    protected void _updateSubBudgetManage(Context ctx, String schemeId, List param) throws BOSException, EASBizException {
        if (!this.isInnerCalling) {
            this.schemeInfo = this.getBudgetSchemeInfo(ctx, schemeId);
            this.refreshBalanceParam = new DeductionParamUsedAmount();
            this.refreshBalanceParam.setBudgetTemplate(this.schemeInfo.getTemplate());
            this.subStandingBookExpenseList = BudgetUtil.initSubBudgetBookItemSumData(ctx, this.schemeInfo);
        }
        PeriodTypeData periodTypeData = this.getBudgetSubItemPeriodType();
        int division = periodTypeData.getDivision();
        String periodType = periodTypeData.getPeriodType();
        ArrayList<Object[]> updateSubManageParam = new ArrayList<Object[]>();
        HashMap<String, String> subQueryMap = new HashMap<String, String>();
        LinkedHashMap<String, Map<String, Object>> itemInfo = null;
        String tag = this.getTagByPeriodType(this.schemeInfo, periodType);
        HashSet<String> budgetManageIds = new HashSet<String>();
        for (Object object : param) {
            SubBudgetManageInfo info = (SubBudgetManageInfo)object;
            if (itemInfo == null) {
                itemInfo = new LinkedHashMap<String, Map<String, Object>>();
                this.initBudgetItem(ctx, param, schemeId, itemInfo);
            }
            String manageId = info.getBudgetMange().getId().toString();
            budgetManageIds.add(manageId);
            String itemId = info.getCmpBudgetItem().getId().toString();
            Object[] subParam = new Object[division + 2];
            for (int i = 0; i < division; ++i) {
                String querySql;
                int j = i + 1;
                String type = HALFYEAR.equals(periodType) ? (i == 0 ? FIRST_HALFYEAR : LAST_HALFYEAR) : periodType + j;
                Object infoValOfType = info.get(type);
                BigDecimal value = null;
                if (infoValOfType != null && !StringUtils.isEmpty((String)infoValOfType.toString())) {
                    value = info.getBigDecimal(type);
                }
                if ("0E-10".equals(String.valueOf(value)) || value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                    value = BigDecimal.ZERO;
                }
                subParam[i] = value;
                String key = manageId + "_" + (i < 9 ? tag + "0" + j : tag + j);
                Map itemMap = (Map)itemInfo.get(itemId);
                if (subQueryMap.containsKey(key)) {
                    querySql = (String)subQueryMap.get(key);
                    querySql = querySql + "," + itemMap.get("item") + "=" + value;
                } else {
                    querySql = itemMap.get("item") + "=" + value;
                }
                subQueryMap.put(key, querySql);
            }
            subParam[division] = manageId;
            subParam[division + 1] = itemId;
            updateSubManageParam.add(subParam);
        }
        this.saveCommonSubManageItem(ctx, this.schemeInfo.getBudgetPeriod(), null, updateSubManageParam);
        ArrayList<String> updateSubQuerySql = new ArrayList<String>();
        this.buildSubManageCommonParam(ctx, subQueryMap, updateSubQuerySql);
        if (updateSubQuerySql.size() > 0) {
            CmpSQLUtil.executeBatchSql(ctx, updateSubQuerySql.toArray());
        }
        if (!this.isInnerCalling) {
            budgetManageIds.forEach(e -> {
                BudgetManageInfo budgetManageInfo = new BudgetManageInfo();
                budgetManageInfo.setId(BOSUuid.read((String)e));
                this.refreshBalanceParam.getBudgetManageList().add(budgetManageInfo);
            });
            CmpUsedAmountFacadeFactory.getLocalInstance(ctx).refreshBalance(this.refreshBalanceParam);
        }
    }

    protected String getTagByPeriodType(CmpBudgetSchemeInfo budgetSchemeInfo, String periodType) {
        String tag = HALFYEAR.equals(periodType) ? budgetSchemeInfo.getBudgetYear() + "H" : (QUARTER.equals(periodType) ? budgetSchemeInfo.getBudgetYear() + "Q" : budgetSchemeInfo.getBudgetYear() + "M");
        return tag;
    }

    protected void buildSubManageCommonParam(Context ctx, Map<String, String> subMap, List<String> updateSubQuerySql) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String dateStr = "{ts '" + HRCmpReportUtil.dateFmt_yyyy_MM_dd.format(new java.util.Date()) + "'}";
        Iterator<Map.Entry<String, String>> iterator = subMap.entrySet().iterator();
        String updateTable = "update T_HR_SSubBudgetQuery set ";
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String[] arr = entry.getKey().split("_");
            String updateSql = updateTable + entry.getValue() + " ,FLastUpdateUserID = '" + userId + "', FLastUpdateTime = " + dateStr + " where FBudgetManageID = '" + arr[0] + "' and FPeriod = '" + arr[1] + "'";
            updateSubQuerySql.add(updateSql);
        }
    }

    protected void initBudgetItem(Context ctx, List param, String schemeId, Map<String, Map<String, Object>> itemInfo) {
        HashSet<String> itemSet = new HashSet<String>();
        for (Object o : param) {
            SubBudgetManageInfo info = (SubBudgetManageInfo)o;
            itemSet.add(info.getCmpBudgetItem().getId().toString());
        }
        String sql = "select distinct item.fid, item.FieldSn FROM T_HR_SCmpBudgetItem item inner join T_HR_SBudgetTemplateItem rel on rel.FBudgetItemID = item.fid inner join T_HR_SCmpBudgetScheme scheme on scheme.FTemplateID = rel.FTemplateID where scheme.fid = '" + schemeId + "' and item.fid in ('" + CmpStrUtil.join(itemSet, "','", null) + "') order by item.FieldSn asc";
        try {
            int itemIndex = 0;
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
            while (rs.next()) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("item", "T" + rs.getInt("FieldSn"));
                map.put("itemIndex", itemIndex);
                ++itemIndex;
                itemInfo.put(rs.getString("fid"), map);
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
    }
}

