/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.sort;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalFormulaCollection;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.exception.CmpSystemPersonException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CalFormulaSortService {
    private int maxCount = 0;
    private int counter = 0;
    private Map<String, String> itemMap;

    public CalFormulaCollection sortByInset(CalFormulaCollection coll) throws BOSException {
        CalFormulaInfo tempInfo;
        int i;
        ArrayList<CalFormulaInfo> list = new ArrayList<CalFormulaInfo>();
        for (i = 0; i < coll.size(); ++i) {
            list.add(coll.get(i));
        }
        for (i = 1; i < list.size(); ++i) {
            int j;
            tempInfo = (CalFormulaInfo)list.get(i);
            for (j = i - 1; j >= 0 && ((CalFormulaInfo)list.get(j)).getListItem().contains(tempInfo.getCalItem()); --j) {
                list.set(j + 1, (CalFormulaInfo)list.get(j));
            }
            list.set(j + 1, tempInfo);
        }
        coll = new CalFormulaCollection();
        for (i = 0; i < list.size(); ++i) {
            tempInfo = (CalFormulaInfo)list.get(i);
            tempInfo.setSortSn(i + 1);
            coll.add(tempInfo);
        }
        return coll;
    }

    public void resortCalFormula(Context ctx, String calSchemeId) throws BOSException, EASBizException {
        ArrayList<CalFormulaSort> sortList = new ArrayList<CalFormulaSort>();
        this.getAllItem(ctx);
        List<CalFormulaSort> list = this.getResortObject(ctx, calSchemeId);
        list = this.sortByDefault(ctx, calSchemeId, list);
        this.maxCount = list.size();
        this.checkIdDeadCycle(list);
        this.SortByRecursion(list, sortList);
        String sql = "update T_HR_SCalFormula set FSortSn = ? where fid = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < sortList.size(); ++i) {
            Object[] param = new Object[]{i + 1, ((CalFormulaSort)sortList.get(i)).getCalFormulaId()};
            paramsList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    private void getAllItem(Context ctx) throws BOSException {
        this.itemMap = new HashMap<String, String>();
        CmpItemCollection coll = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection("select name, fieldsn");
        for (int i = 0; i < coll.size(); ++i) {
            CmpItemInfo cmpItemInfo = coll.get(i);
            this.itemMap.put("S" + cmpItemInfo.getFieldSn(), cmpItemInfo.getName());
        }
    }

    public List<CalFormulaSort> sortByDefault(Context ctx, String calSchemeId, List<CalFormulaSort> list) throws BOSException, EASBizException {
        List formulaList;
        StringBuilder str = new StringBuilder();
        HashMap map = new HashMap();
        ArrayList<CalFormulaSort> defaultSortList = new ArrayList<CalFormulaSort>();
        HashSet<String> itemSet = new HashSet<String>();
        String sql = "select A01.FieldSn from T_HR_SCmpItem A01 inner join T_HR_SCalSchemeItem A02 on A01.fid = A02.FCmpItemId where A02.FCalSchemeId = '" + calSchemeId + "'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet1.next()) {
                itemSet.add(rowSet1.getString(1));
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < list.size(); ++i) {
            CalFormulaSort calFormulaSort = list.get(i);
            if (itemSet.contains(calFormulaSort.getCalItem().substring(1))) {
                str.append(calFormulaSort.getCalItem().substring(1)).append(",");
                if (map.containsKey(calFormulaSort.getCalItem())) {
                    ((List)map.get(calFormulaSort.getCalItem())).add(calFormulaSort);
                    continue;
                }
                formulaList = new ArrayList<CalFormulaSort>();
                formulaList.add(calFormulaSort);
                map.put(calFormulaSort.getCalItem(), formulaList);
                continue;
            }
            defaultSortList.add(calFormulaSort);
        }
        if (str.length() < 1) {
            return defaultSortList;
        }
        String fieldSns = str.substring(0, str.length() - 1);
        str = new StringBuilder();
        str.append(" select A01.FSortSn sortSn, A02.FieldSn ");
        str.append(" from T_HR_SCalSchemeItem A01 ");
        str.append(" inner join T_HR_SCmpItem A02 on A01.FCmpItemID = A02.fid ");
        str.append(" where A01.FCalSchemeID = '" + calSchemeId + "'");
        str.append(" and A02.FieldSn in (" + fieldSns + ")");
        str.append(" order by A01.FSortSn desc ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                formulaList = (List)map.get("S" + rowSet.getInt(2));
                for (CalFormulaSort calFormulaSort1 : formulaList) {
                    defaultSortList.add(calFormulaSort1);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return defaultSortList;
    }

    public void checkIdDeadCycle(List<CalFormulaSort> list) throws BOSException, EASBizException {
        List sortMapList;
        HashMap map = new HashMap();
        for (CalFormulaSort info : list) {
            if (map.containsKey(info.getCalItem())) {
                ((List)map.get(info.getCalItem())).add(info);
                continue;
            }
            sortMapList = new ArrayList<CalFormulaSort>();
            sortMapList.add(info);
            map.put(info.getCalItem(), sortMapList);
        }
        for (CalFormulaSort info : list) {
            String keyItem = info.getCalItem();
            String calName = info.getCalName();
            for (String relyItem : info.getRelySet()) {
                sortMapList = (List)map.get(relyItem);
                if (null == sortMapList || sortMapList.size() < 1) continue;
                for (int i = 0; i < sortMapList.size(); ++i) {
                    CalFormulaSort compSort = (CalFormulaSort)sortMapList.get(i);
                    Set<String> relySet = compSort.getRelySet();
                    if (calName == null || compSort.getCalName() == null || calName.equals(compSort.getCalName()) || !relySet.contains(keyItem)) continue;
                    throw new CmpSystemPersonException(CmpSystemPersonException.EXCEPTION5, new Object[]{calName, compSort.getCalName()});
                }
            }
        }
    }

    public List<CalFormulaSort> getResortObject(Context ctx, String calSchemeId) throws BOSException, EASBizException {
        String relyItem;
        int j;
        String[] calItemArray;
        String expressVar;
        String express;
        String[] expressArray;
        String calItems;
        CalFormulaInfo info;
        int i;
        ArrayList<CalFormulaSort> list = new ArrayList<CalFormulaSort>();
        HashSet<String> calItemSet = new HashSet<String>();
        HashSet<String> repeatSet = new HashSet<String>();
        CalFormulaCollection coll = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection("where calScheme.id = '" + calSchemeId + "'");
        if (null == coll || coll.size() < 1) {
            throw new CmpSystemPersonException(CmpSystemPersonException.EXCEPTION6);
        }
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            calItems = info.getCalItem();
            if (StringUtils.isEmpty((String)calItems)) {
                calItems = info.getListVar();
                if (StringUtils.isEmpty((String)calItems) || null == (expressArray = (express = info.getExpress()).split("=")) || expressArray.length < 1) continue;
                expressVar = expressArray[0];
                calItemArray = calItems.split(";");
                for (j = 0; j < calItemArray.length; ++j) {
                    relyItem = calItemArray[j].substring(calItemArray[j].lastIndexOf("~") + 1).replace("@", "");
                    if (!expressVar.contains(relyItem)) continue;
                    calItemSet.add("@" + relyItem);
                }
                continue;
            }
            calItemArray = calItems.split(";");
            for (j = 0; j < calItemArray.length; ++j) {
                if (calItemSet.contains(calItemArray[j])) {
                    repeatSet.add(calItemArray[j]);
                }
                calItemSet.add(calItemArray[j]);
            }
        }
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            calItems = info.getCalItem();
            if (!StringUtils.isEmpty((String)calItems)) {
                calItemArray = calItems.split(";");
            } else {
                calItemArray = new String[1];
                calItems = info.getListVar();
                String[] calVarArray = calItems.split(";");
                express = info.getExpress();
                expressArray = express.split("=");
                if (null == expressArray || expressArray.length < 1) continue;
                expressVar = expressArray[0];
                for (int k = 0; k < calVarArray.length; ++k) {
                    calItems = calVarArray[k].substring(calVarArray[k].lastIndexOf("~") + 1).replace("@", "");
                    if (!expressVar.contains(calItems)) continue;
                    calItemArray[0] = "@" + calItems;
                    break;
                }
            }
            for (j = 0; j < calItemArray.length; ++j) {
                String[] relCalItemArray;
                String relyStr;
                int k;
                String[] listItemArray;
                CalFormulaSort sortInfo = new CalFormulaSort(info.getId().toString(), info.getName(), calItemArray[j]);
                String listItem = info.getListItem();
                String listVar = info.getListVar();
                if (null == listItem && null == listVar) continue;
                if (null != listItem) {
                    listItemArray = listItem.split(";");
                    for (k = 0; k < listItemArray.length; ++k) {
                        relyStr = listItemArray[k];
                        if (!relyStr.contains("T_HR_SCmpCalTable") || !calItemSet.contains(relyItem = relyStr.substring(relyStr.lastIndexOf("~") + 1))) continue;
                        sortInfo.addRelyItem(relyItem);
                    }
                }
                if (null != listVar) {
                    listItemArray = listVar.split(";");
                    for (k = 0; k < listItemArray.length; ++k) {
                        relyStr = listItemArray[k];
                        relyItem = relyStr.substring(relyStr.lastIndexOf("~") + 1);
                        if (!calItemSet.contains(relyItem)) continue;
                        sortInfo.addRelyItem(relyItem);
                    }
                }
                if ((relCalItemArray = calItems.split(";")).length > 1) {
                    for (int count = 0; count < relCalItemArray.length; ++count) {
                        sortInfo.getRelySet().remove(relCalItemArray[count]);
                    }
                }
                if (repeatSet.contains(calItemArray[j])) {
                    express = info.getExpress();
                    String[] arr1 = express.split(";");
                    for (int k2 = 0; k2 < arr1.length; ++k2) {
                        String[] arr2 = arr1[k2].split("=");
                        if (arr2.length <= 1 || !arr2[1].contains(calItemArray[j])) continue;
                        sortInfo.addSelfRely(calItemArray[j]);
                    }
                }
                list.add(sortInfo);
            }
        }
        return list;
    }

    public void SortByRecursion(List<CalFormulaSort> list, List<CalFormulaSort> sortList) throws EASBizException {
        CalFormulaSort calFormulaSort;
        HashSet<String> relySet = new HashSet<String>();
        if (list.size() < 1) {
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            calFormulaSort = list.get(i);
            if (calFormulaSort.getRelySet().size() >= 1) continue;
            sortList.add(calFormulaSort);
            relySet.add(calFormulaSort.getCalItem());
            list.remove(i);
        }
        for (CalFormulaSort alFormulaSort : list) {
            alFormulaSort.removeRelyItems(relySet);
        }
        ++this.counter;
        if (this.counter > this.maxCount) {
            StringBuilder str = new StringBuilder();
            for (int i = list.size() - 1; i >= 0; --i) {
                calFormulaSort = list.get(i);
                str.append(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label119", (Locale)new Context().getLocale())).append(calFormulaSort.getCalName()).append(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label120", (Locale)new Context().getLocale()));
                for (String item : calFormulaSort.getRelySet()) {
                    str.append(this.itemMap.get(item)).append(";");
                }
                str.append("<br/>");
            }
            str.append(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label121", (Locale)new Context().getLocale()));
            throw new EASBizException(new NumericExceptionSubItem("001", str.toString()));
        }
        this.SortByRecursion(list, sortList);
    }

    class CalFormulaSort {
        private String calFormulaId;
        private String calName;
        private int index;
        private String calItem;
        private Set<String> relySet;

        public CalFormulaSort(String calFormulaId, String calName, String calItem) {
            this.calFormulaId = calFormulaId;
            this.calItem = calItem;
            this.calName = calName;
        }

        public String getCalFormulaId() {
            return this.calFormulaId;
        }

        public void setCalFormulaId(String calFormulaId) {
            this.calFormulaId = calFormulaId;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getCalItem() {
            return this.calItem;
        }

        public void setCalItem(String calItem) {
            this.calItem = calItem;
        }

        public Set<String> getRelySet() {
            if (null == this.relySet) {
                return new HashSet<String>();
            }
            return this.relySet;
        }

        public void setRelySet(Set<String> relySet) {
            this.relySet = relySet;
        }

        public String getCalName() {
            return this.calName;
        }

        public void setCalName(String calName) {
            this.calName = calName;
        }

        public void addRelyItem(String item) {
            if (null == this.relySet) {
                this.relySet = new HashSet<String>();
            }
            if (!StringUtils.isEmpty((String)this.calItem) && this.calItem.equals(item)) {
                return;
            }
            this.relySet.add(item);
        }

        public void removeRelyItems(Set<String> set) {
            for (String item : set) {
                this.relySet.remove(item);
            }
        }

        public void addSelfRely(String item) {
            if (null == this.relySet) {
                this.relySet = new HashSet<String>();
            }
            this.relySet.add(item);
        }
    }
}

