/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.BasicItemStateEnum;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.compensation.CalFormulaCollection;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CmpItemApply;
import com.kingdee.shr.compensation.CmpItemDataDot;
import com.kingdee.shr.compensation.FormulaTmpTableCollection;
import com.kingdee.shr.compensation.FormulaTmpTableFactory;
import com.kingdee.shr.compensation.FormulaTmpTableInfo;
import com.kingdee.shr.compensation.app.integrate.AbstractCalSubmitItemControllerBean;
import com.kingdee.shr.compensation.app.integrate.CalSchemeItemForF7Info;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.app.integrate.SubmitItemCatalogInfo;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CalSubmitItemControllerBean
extends AbstractCalSubmitItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.integrate.CalSubmitItemControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.saveOrUpdate(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteCalItem(ctx, pk);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void checkIsRefferenced(String billId, Context ctx) throws HRCommonException {
        StringBuilder checkSqlBuf = new StringBuilder();
        checkSqlBuf.append(" SELECT ss.Fname_" + ctx.getLocale().getLanguage() + " as SBNAME ");
        checkSqlBuf.append(" FROM T_HR_SCalSubmitSchemeItem css  ");
        checkSqlBuf.append(" left join T_HR_ScalsubmitScheme ss on ss.Fid=css.FCalSubmitSchemeID  ");
        checkSqlBuf.append(" where css.FCalSubmitItemID= '" + billId + "'");
        StringBuilder submitSchemeBuff = new StringBuilder();
        try {
            IRowSet iRowSet = CmpSQLUtil.executeQuery(ctx, checkSqlBuf.toString());
            String sbname = null;
            for (int limit = 1; iRowSet.next() && limit != 10; ++limit) {
                sbname = iRowSet.getString("SBNAME");
                if (sbname == null || sbname.trim().length() <= 0) continue;
                submitSchemeBuff.append(",");
                submitSchemeBuff.append(sbname);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String names = submitSchemeBuff.toString();
        if (names != null && names.trim().length() > 0) {
            names = names.substring(1);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label0"), names)});
        }
    }

    private void deleteCalItem(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String column = "";
        boolean count = false;
        CalSubmitItemInfo cmpInfo = CalSubmitItemFactory.getLocalInstance(ctx).getCalSubmitItemInfo(pk);
        if (cmpInfo == null) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label26", (Locale)ctx.getLocale())});
        }
        SHRBasicItemInfo shrBasicItem = cmpInfo.getShrBasicItem();
        boolean isPreset = shrBasicItem.isIsPreset();
        BasicItemStateEnum state = shrBasicItem.getState();
        int value = state.getValue();
        if (isPreset) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label124", (Locale)ctx.getLocale())});
        }
        if (value != 0) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label125", (Locale)ctx.getLocale())});
        }
        this.checkIsRefferenced(pk.toString(), ctx);
    }

    protected IObjectPK[] _beforeDeleteOperation(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        SHRBaseItemInfo model = (SHRBaseItemInfo)shrBaseItem;
        if (null == model) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label27", (Locale)ctx.getLocale())});
        }
        IObjectPK[] baseInfoOrgRefPK = null;
        if (BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label28"), model.getNumber())});
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)model.getState())) {
            // empty if block
        }
        return baseInfoOrgRefPK;
    }

    private IObjectPK addNewItemAndColumns(Context ctx, CalSubmitItemInfo item, int fieldSn) throws BOSException, EASBizException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        String name = item.getName();
        String number = item.getNumber();
        int dataLength = item.getDataLength();
        SHRBasicItemInfo shrBasicItemInfo = null;
        shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
        this.checkNameDup(ctx, (DataBaseInfo)item);
        String oql = "select * where number='" + number + "'";
        boolean exists = CalSubmitItemFactory.getLocalInstance(ctx).exists(oql);
        if (exists) {
            throw new EASBizException(new NumericExceptionSubItem("022", MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label30"), number)));
        }
        item.setFieldSn(fieldSn + 1);
        item.setIsSysPreset(false);
        item.setShrBasicItem(shrBasicItemInfo);
        if (item.getCU() == null) {
            item.setCU(this.getCU(ctx, (ObjectBaseInfo)item));
        }
        if (item.getCreator() == null) {
            item.setCreator(userInfo);
        }
        Timestamp createtime = this.getTime();
        if (item.getCreateTime() == null) {
            item.setCreateTime(createtime);
        }
        item.setLastUpdateUser(userInfo);
        item.setLastUpdateTime(createtime);
        item.setState(BaseItemStateEnum.NEW);
        IObjectPK baseInfoChangePK = null;
        IObjectPK idPk = null;
        if (!BaseItemStateEnum.NEW.equals((Object)item.getState())) {
            baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            } else {
                baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
                if (null != baseInfoChangePK) {
                    this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                }
            }
        } else {
            idPk = super.innerAddnew(ctx, (IObjectValue)item);
        }
        if (item.getDataType() == CalSubmitItemDataType.String && dataLength > 1000) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label31", (Locale)ctx.getLocale()));
        }
        item.setId(BOSUuid.read((String)idPk.toString()));
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, idPk));
        return idPk;
    }

    private IObjectPK updateItem(Context ctx, CalSubmitItemInfo item) throws BOSException, EASBizException {
        String name = item.getName();
        String number = item.getNumber();
        String itemid = item.getId().toString();
        String description = item.getDescription();
        CmpItemDataDot dataDot = item.getDataDot();
        int dataLength = item.getDataLength();
        DateTypeEnum dateType = item.getDateType();
        CalSchemeItemForF7Info filterField = item.getFilterField();
        int index = item.getIndex();
        BaseItemStateEnum state = item.getState();
        SubmitItemCatalogInfo submitCatalog = item.getSubmitCatalog();
        CmpItemApply applyScope = item.getApplyScope();
        AdminOrgUnitInfo createAdminOrgUnit = item.getCreateOU();
        UsePolicy usePolicy = item.getUsePolicy();
        HROrgUnitInfo hrOrgUnit = item.getHrOrgUnit();
        boolean isSysPreset = item.isIsSysPreset();
        CalSubmitItemDataType dataType = item.getDataType();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        this.beforeUpdate(ctx, item);
        this.checkNameDup(ctx, (DataBaseInfo)item);
        String oql = "select * where  number = '" + number + "' and id <> '" + itemid + "'";
        boolean exists = CalSubmitItemFactory.getLocalInstance(ctx).exists(oql);
        if (exists) {
            throw new EASBizException(new NumericExceptionSubItem("022", MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label30"), number)));
        }
        SHRBasicItemInfo shrBasicItemInfo = this.getShrBasicItemInfo(ctx);
        CalSubmitItemInfo cmpItemInfo = new CalSubmitItemInfo();
        cmpItemInfo.setId(item.getId());
        cmpItemInfo.setName(item.getName(LocaleUtils.locale_L1), LocaleUtils.locale_L1);
        cmpItemInfo.setName(item.getName(LocaleUtils.locale_L2), LocaleUtils.locale_L2);
        cmpItemInfo.setName(item.getName(LocaleUtils.locale_L3), LocaleUtils.locale_L3);
        cmpItemInfo.setNumber(number);
        cmpItemInfo.setDescription(item.getDescription(LocaleUtils.locale_L1), LocaleUtils.locale_L1);
        cmpItemInfo.setDescription(item.getDescription(LocaleUtils.locale_L2), LocaleUtils.locale_L2);
        cmpItemInfo.setDescription(item.getDescription(LocaleUtils.locale_L3), LocaleUtils.locale_L3);
        cmpItemInfo.setDataDot(dataDot);
        cmpItemInfo.setDataLength(dataLength);
        cmpItemInfo.setDateType(dateType);
        cmpItemInfo.setFilterField(filterField);
        cmpItemInfo.setSubmitCatalog(submitCatalog);
        cmpItemInfo.setHrOrgUnit(hrOrgUnit);
        cmpItemInfo.setUsePolicy(usePolicy);
        cmpItemInfo.setState(state);
        cmpItemInfo.setIndex(index);
        cmpItemInfo.setIsSysPreset(isSysPreset);
        cmpItemInfo.setCreateOU(createAdminOrgUnit);
        cmpItemInfo.setApplyScope(applyScope);
        cmpItemInfo.setLastUpdateUser(userInfo);
        cmpItemInfo.setLastUpdateTime(this.getTime());
        cmpItemInfo.setShrBasicItem(shrBasicItemInfo);
        cmpItemInfo.setDataType(dataType);
        cmpItemInfo.setIsSalaryCal(item.getIsSalaryCal());
        cmpItemInfo.setIsSumCal(item.getIsSumCal());
        if (item.getFieldSn() <= 0) {
            String sql = "select FieldSn from T_HR_SCalSubmitItem where fid='" + item.getId().toString() + "'";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowset.next()) {
                    int fieldSn = rowset.getInt(1);
                    cmpItemInfo.setFieldSn(fieldSn);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            cmpItemInfo.setFieldSn(item.getFieldSn());
        }
        ObjectUuidPK idPk = new ObjectUuidPK(itemid);
        IObjectPK baseInfoChangePK = null;
        baseInfoChangePK = this._beforeSaveOperation(ctx, (IObjectValue)item);
        super.innerUpdate(ctx, (IObjectPK)idPk, (IObjectValue)cmpItemInfo);
        if (null != baseInfoChangePK) {
            this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
        } else {
            baseInfoChangePK = this._afterSaveOperation(ctx, idPk.toString(), (IObjectValue)item);
            if (null != baseInfoChangePK) {
                this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
            }
        }
        this._writeReviseLog(ctx, (IObjectValue)this.getValue(ctx, (IObjectPK)idPk));
        return idPk;
    }

    private void syncCalFOrmula(Context ctx, CalSubmitItemInfo item) throws BOSException {
        String newName;
        String oldName = newName = item.getName();
        boolean isSync = false;
        String fieldSn = "";
        try {
            CalSubmitItemInfo cmpItemInfo = CalSubmitItemFactory.getLocalInstance(ctx).getCalSubmitItemInfo((IObjectPK)new ObjectUuidPK(item.getId().toString()));
            oldName = cmpItemInfo.getName();
            fieldSn = "S" + cmpItemInfo.getFieldSn();
            if (!newName.equals(oldName)) {
                isSync = true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        if (!isSync) {
            return;
        }
        StringBuffer oqlStr = new StringBuffer();
        oqlStr.append("select * ");
        oqlStr.append("where content like '%");
        oqlStr.append(oldName);
        oqlStr.append("%' and calScheme in (");
        oqlStr.append("select FCalSchemeID from T_HR_SCalSchemeItem ");
        oqlStr.append("where FCmpItemID = '");
        oqlStr.append(item.getId().toString());
        oqlStr.append("')");
        CalFormulaCollection calFormulaCollection = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection(oqlStr.toString());
        if (null == calFormulaCollection || calFormulaCollection.size() < 1) {
            return;
        }
        CoreBaseCollection updateCalFormulaCol = new CoreBaseCollection();
        int size = calFormulaCollection.size();
        for (int i = 0; i < size; ++i) {
            boolean isUpdate = false;
            CalFormulaInfo calFormulaInfo = calFormulaCollection.get(i);
            String content = calFormulaInfo.getContent();
            String express = calFormulaInfo.getExpress();
            String name = calFormulaInfo.getName();
            if (content.contains(oldName)) {
                content = content.replaceAll(">" + oldName + "<", ">" + newName + "<");
                content = content.replaceAll("&quot;" + oldName + "&quot;", "&quot;" + newName + "&quot;");
                content = content.replaceAll("]" + oldName + "<", "]" + newName + "<");
                isUpdate = true;
            }
            if (express.contains(oldName)) {
                express = express.replaceAll("\"" + oldName + "\"", "\"" + newName + "\"");
                isUpdate = true;
            }
            if (name.equals(oldName)) {
                name = newName;
                isUpdate = true;
            }
            if (!isUpdate) continue;
            calFormulaInfo.setContent(content);
            calFormulaInfo.setExpress(express);
            calFormulaInfo.setName(name);
            updateCalFormulaCol.add((CoreBaseInfo)calFormulaInfo);
        }
        if (updateCalFormulaCol.size() > 0) {
            try {
                CalFormulaFactory.getLocalInstance(ctx).update(updateCalFormulaCol);
            }
            catch (EASBizException e) {
                logger.error((Object)("updateCalFormula:" + e.getMessage()));
            }
        }
        CoreBaseCollection updateTmpTableCol = new CoreBaseCollection();
        FormulaTmpTableCollection formulaTmpTableCollection = FormulaTmpTableFactory.getLocalInstance(ctx).getFormulaTmpTableCollection("select * where paramDefines like '%" + fieldSn + "%'");
        if (null == formulaTmpTableCollection || formulaTmpTableCollection.size() < 1) {
            return;
        }
        int size2 = formulaTmpTableCollection.size();
        for (int i = 0; i < size2; ++i) {
            FormulaTmpTableInfo formulaTmpTableInfo = formulaTmpTableCollection.get(i);
            String paramNames = formulaTmpTableInfo.getParamNames();
            paramNames = paramNames.replaceAll("\\s", "").replaceAll(oldName, newName);
            formulaTmpTableInfo.setParamNames(paramNames);
            updateTmpTableCol.add((CoreBaseInfo)formulaTmpTableInfo);
        }
        if (updateTmpTableCol.size() > 0) {
            try {
                FormulaTmpTableFactory.getLocalInstance(ctx).update(updateTmpTableCol);
            }
            catch (EASBizException e) {
                logger.error((Object)("updateCalTmpTable:" + e.getMessage()));
            }
        }
    }

    private void beforeUpdate(Context ctx, CalSubmitItemInfo item) throws BOSException {
    }

    private IObjectPK saveOrUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            FunUtils.clearSessionMap();
            CalSubmitItemInfo item = (CalSubmitItemInfo)model;
            String name = item.getName();
            String name_l1 = item.getName(LocaleUtils.locale_L1);
            String name_l2 = item.getName(LocaleUtils.locale_L2);
            String name_l3 = item.getName(LocaleUtils.locale_L3);
            if (!StringUtils.isEmpty((String)name) && (StringUtils.isEmpty((String)name_l1) || StringUtils.isEmpty((String)name_l2) || StringUtils.isEmpty((String)name_l3))) {
                name_l1 = StringUtils.isEmpty((String)name_l1) ? name : name_l1;
                name_l2 = StringUtils.isEmpty((String)name_l2) ? name : name_l2;
                String string = name_l3 = StringUtils.isEmpty((String)name_l3) ? name : name_l3;
            }
            if (StringUtils.isEmpty((String)name_l1) || StringUtils.isEmpty((String)name_l2) || StringUtils.isEmpty((String)name_l3) || StringUtils.isEmpty((String)item.getNumber())) {
                throw new EASBizException(new NumericExceptionSubItem("021", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label32", (Locale)ctx.getLocale())));
            }
            String reg = "^[\u4e00-\u9fa5a-zA-Z_]+[\u4e00-\u9fa5a-zA-Z_0-9\uff08\uff09]*$";
            if (!(name_l1.matches(reg) && name_l2.matches(reg) && name_l3.matches(reg))) {
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label33", (Locale)ctx.getLocale())));
            }
            if (!item.getNumber().matches(reg)) {
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label49", (Locale)ctx.getLocale())));
            }
            String[] arr = new String[]{EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label66", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label67"), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label68", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label69", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label70", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label71", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label72", (Locale)ctx.getLocale())};
            for (int i = 0; i < arr.length; ++i) {
                if (name_l1.indexOf(arr[i]) != -1 || name_l2.indexOf(arr[i]) != -1 || name_l3.indexOf(arr[i]) != -1) {
                    throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label33", (Locale)ctx.getLocale())));
                }
                if (item.getNumber().indexOf(arr[i]) == -1) continue;
                throw new EASBizException(new NumericExceptionSubItem("022", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label33", (Locale)ctx.getLocale())));
            }
            int fieldSn = 60;
            String sql = "select max(FieldSn) from T_HR_SCalSubmitItem";
            IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (list.next()) {
                if (list.getInt(1) <= fieldSn) continue;
                fieldSn = list.getInt(1);
            }
            boolean isNewOp = false;
            int orgFieldSn = item.getFieldSn();
            if (orgFieldSn == -1 || orgFieldSn == 0) {
                isNewOp = true;
            }
            if (item.getId() != null && !StringUtils.isEmpty((String)item.getId().toString())) {
                isNewOp = false;
            }
            if (isNewOp) {
                return this.addNewItemAndColumns(ctx, item, fieldSn);
            }
            return this.updateItem(ctx, item);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private SHRBasicItemInfo getShrBasicItemInfo(Context ctx) throws BOSException, EASBizException {
        String entityName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType()).getFullName();
        ISHRBasicItem shrBasicItem = SHRBasicItemFactory.getLocalInstance((Context)ctx);
        String oql = "where entityName='" + entityName + "'";
        SHRBasicItemInfo basicItemInfo = shrBasicItem.getSHRBasicItemInfo(oql);
        return basicItemInfo;
    }
}

