/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.multiinspire;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.multiinspire.AbstractStandingBookControllerBean;
import com.kingdee.shr.compensation.app.integrate.multiinspire.IStandingBook;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookCollection;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandingBookControllerBean
extends AbstractStandingBookControllerBean {
    private static final long serialVersionUID = 5576479164807992068L;

    @Override
    protected String _desposebillfind(Context ctx, String billid) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _teamBuidingCost(Context ctx, String parameterCollection) throws BOSException, EASBizException {
        IStandingBook iStandingBook = StandingBookFactory.getLocalInstance(ctx);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        JSONObject parameters = JSON.parseObject((String)parameterCollection);
        Object adminOrgUnit = parameters.get("adminOrgUnit");
        Object costType = parameters.get("CostType");
        Integer budgetYear = Integer.parseInt(parameters.get("budgetYear").toString());
        Object teamCost = parameters.get("amount");
        Object operType = parameters.get("operType");
        if (adminOrgUnit == null) {
            resultMap.put("flag", "0");
            resultMap.put("message", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label40", (Locale)ctx.getLocale()));
            return JSONUtils.convertObjectToJson((Context)ctx, resultMap);
        }
        if (costType == null) {
            resultMap.put("flag", "0");
            resultMap.put("message", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label41", (Locale)ctx.getLocale()));
            return JSONUtils.convertObjectToJson((Context)ctx, resultMap);
        }
        if (teamCost == null || !this.isNum(teamCost).booleanValue()) {
            resultMap.put("flag", "0");
            resultMap.put("message", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label42", (Locale)ctx.getLocale()));
            return JSONUtils.convertObjectToJson((Context)ctx, resultMap);
        }
        if (operType == null || !operType.toString().equals("1") && !operType.toString().equals("2")) {
            resultMap.put("flag", "0");
            resultMap.put("message", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label43", (Locale)ctx.getLocale()));
            return JSONUtils.convertObjectToJson((Context)ctx, resultMap);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.adminOrgUnit.id", adminOrgUnit, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.costType.id", costType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.budgetYear", (Object)budgetYear, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.virtualNode", (Object)0, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("LimitManagement.*"));
        viewInfo.setSelector(selector);
        StandingBookCollection standingBookCollection = iStandingBook.getStandingBookCollection(viewInfo);
        if (standingBookCollection.size() == 0) {
            resultMap.put("flag", "0");
            resultMap.put("message", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label44", (Locale)ctx.getLocale()));
            return JSONUtils.convertObjectToJson((Context)ctx, resultMap);
        }
        StandingBookInfo standingBookInfo = standingBookCollection.get(0);
        BigDecimal withHoleBalance = standingBookInfo.getWithHoleBalance();
        BigDecimal realDeductAmount = standingBookInfo.getRealDeductAmount();
        BigDecimal realDeductBalance = standingBookInfo.getRealDeductBalance();
        if (operType.toString().equals("1")) {
            if (withHoleBalance.compareTo(new BigDecimal(teamCost.toString())) < 0) {
                resultMap.put("flag", "0");
                resultMap.put("message", EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label45", (Locale)ctx.getLocale()));
            } else {
                realDeductAmount = realDeductAmount.add(new BigDecimal(teamCost.toString())).setScale(2, 4);
                withHoleBalance = withHoleBalance.subtract(new BigDecimal(teamCost.toString())).setScale(2, 4);
                realDeductBalance = realDeductBalance.subtract(new BigDecimal(teamCost.toString())).setScale(2, 4);
                resultMap.put("flag", "1");
            }
        } else {
            realDeductAmount = realDeductAmount.subtract(new BigDecimal(teamCost.toString())).setScale(2, 4);
            withHoleBalance = withHoleBalance.add(new BigDecimal(teamCost.toString())).setScale(2, 4);
            realDeductBalance = realDeductBalance.add(new BigDecimal(teamCost.toString())).setScale(2, 4);
            resultMap.put("flag", "1");
        }
        if (resultMap.get("flag") == "1") {
            standingBookInfo.setRealDeductBalance(realDeductBalance);
            standingBookInfo.setRealDeductAmount(realDeductAmount);
            standingBookInfo.setWithHoleBalance(withHoleBalance);
            iStandingBook.save((CoreBaseInfo)standingBookInfo);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, resultMap);
    }

    private Boolean isNum(Object obj) {
        if (null == obj) {
            return false;
        }
        if (StringUtils.isEmpty((String)obj.toString().trim())) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\d*.?\\d*");
        Matcher isNum = pattern.matcher(obj.toString().trim());
        if (!isNum.matches()) {
            pattern = Pattern.compile("[0-9]+[.]{0,1}[0-9]*[dD]{0,1}");
            isNum = pattern.matcher(obj.toString());
        }
        return isNum.matches();
    }

    @Override
    protected StandingBookInfo _getStandingBookInfoByBillInfo(Context ctx, BatchSubmitShemeBillInfo billInfo) throws BOSException, EASBizException {
        BOSUuid costBearOrgId = billInfo.getCostBearOrg().getId();
        String costBearOrg = null != costBearOrgId ? costBearOrgId.toString() : null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.adminOrgUnit", (Object)costBearOrg, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.virtualNode", (Object)0, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.CostType", (Object)billInfo.getCostType().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.budgetYear", (Object)Integer.parseInt(billInfo.getBudgetYear()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LimitManagement.state", (Object)1));
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("LimitManagement.*"));
        sic.add(new SelectorItemInfo("WithHoleBalance"));
        evi.setSelector(sic);
        StandingBookCollection standingBookCollection = StandingBookFactory.getLocalInstance(ctx).getStandingBookCollection(evi);
        if (null == standingBookCollection || standingBookCollection.isEmpty()) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label22", (Locale)ctx.getLocale()));
        }
        if (standingBookCollection.size() > 1) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label46", (Locale)ctx.getLocale()));
        }
        return standingBookCollection.get(0);
    }
}

