/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.submitPeriod.helper;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.ISubmitPeriodDetail;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailFactory;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodFactory;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SubmitPeriodHelper {
    private static final String BILL_ID = "billId";
    private static final String MIN_STARTDATE = "minStartDate";
    private static final String MIN_ENDDATE = "minEndDate";
    private static final String yyyy_MM_dd = "yyyy-MM-dd";
    private static final String TOTAL = "total";
    private static final String RECORDS = "records";
    private static final String PERIOD_TYPE = "periodType";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String STATE = "state";
    private static final String IS_APPLY_CALENDAR = "isApplyCalendar";
    private static final String CHANGE_SOURCE = "changeSource";
    private static final String COMMENTS = "comments";
    private static final String ID = "id";
    private static final String PAGE = "page";
    private static final String ROWS = "rows";

    public static Map<String, Pair<Date, Date>> getClostestDatePairMap(Context ctx, List<String> ids) throws SQLException, BOSException {
        String sql = "SELECT FBillID billId, min(FSTARTDATE) minStartDate,min(FENDDATE) minEndDate FROM T_HR_SubmitPeriodDetail WHERE FEndDate >= {ts '" + new SimpleDateFormat(yyyy_MM_dd).format(new Date()) + "'} AND FBillID in ('" + StringUtils.join(ids, (String)"','") + "') GROUP BY FBillID";
        HashMap billAndDatePairMap = Maps.newHashMap();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            billAndDatePairMap.put(rs.getString(BILL_ID), Pair.of((Object)CmpDateUtil.toDate(rs.getDate(MIN_STARTDATE)), (Object)CmpDateUtil.toDate(rs.getDate(MIN_ENDDATE))));
        }
        return billAndDatePairMap;
    }

    public static Map<String, Pair<Date, Date>> getClostestDatePairMap(Context ctx, String id) throws SQLException, BOSException {
        return SubmitPeriodHelper.getClostestDatePairMap(ctx, Arrays.asList((Object[])new String[]{id}));
    }

    public static Map<String, Object> getSubmitPeriodDetailPagingList(Context ctx, EntityViewInfo view, int rows, int page) throws EASBizException, BOSException {
        SubmitPeriodHelper.assembleDefaultSelectorIfNeed(view);
        SubmitPeriodHelper.assembleDefaultSortedByAscIfNeed(view);
        ISubmitPeriodDetail instance = SubmitPeriodDetailFactory.getLocalInstance(ctx);
        int totalCount = instance.getCount(view);
        List<SubmitPeriodDetailInfo> list = SubmitPeriodHelper.getPagingList(instance, view, rows, page, totalCount);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(TOTAL, totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1);
        resultMap.put(PAGE, page);
        resultMap.put(RECORDS, totalCount);
        resultMap.put(ROWS, SubmitPeriodHelper.converInfo2Map(list));
        return resultMap;
    }

    private static void assembleDefaultSelectorIfNeed(EntityViewInfo view) {
        if (!view.getSelector().isEmpty()) {
            return;
        }
        SelectorItemCollection sic = view.getSelector();
        sic.add(PERIOD_TYPE);
        sic.add(START_DATE);
        sic.add(END_DATE);
        sic.add(STATE);
        sic.add(IS_APPLY_CALENDAR);
        sic.add(CHANGE_SOURCE);
        sic.add(COMMENTS);
    }

    private static void assembleDefaultSortedByAscIfNeed(EntityViewInfo view) {
        if (!view.getSorter().isEmpty()) {
            return;
        }
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo(START_DATE);
        sorterItemInfo.setSortType(SortType.ASCEND);
        sortCol.add(sorterItemInfo);
        view.setSorter(sortCol);
    }

    private static List<SubmitPeriodDetailInfo> getPagingList(ISubmitPeriodDetail instance, EntityViewInfo view, int rows, int page, int totalCount) throws BOSException {
        int length = page * rows > totalCount ? totalCount - (page - 1) * rows : rows;
        return instance.getPagingList(view, rows * (page - 1), length < 0 ? 0 : length);
    }

    private static List<Map<String, Object>> converInfo2Map(List<SubmitPeriodDetailInfo> list) {
        ArrayList<Map<String, Object>> rowDataList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            SubmitPeriodDetailInfo detail = list.get(i);
            HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
            rowDataMap.put(ID, detail.getId().toString());
            rowDataMap.put(PERIOD_TYPE, (Object)detail.getPeriodType());
            rowDataMap.put(START_DATE, detail.getStartDate());
            rowDataMap.put(END_DATE, detail.getEndDate());
            rowDataMap.put(STATE, detail.getState());
            rowDataMap.put(IS_APPLY_CALENDAR, detail.isIsApplyCalendar());
            rowDataMap.put(CHANGE_SOURCE, (Object)detail.getChangeSource());
            rowDataMap.put(COMMENTS, detail.getComments());
            rowDataList.add(rowDataMap);
        }
        return rowDataList;
    }

    public static Set<String> getEnableSubmitPeriodIds(Context ctx) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        SubmitPeriodCollection cols = SubmitPeriodFactory.getLocalInstance(ctx).getSubmitPeriodCollection("select id where state = 1");
        for (int i = 0; i < cols.size(); ++i) {
            ids.add(cols.get(i).getId().toString());
        }
        return ids;
    }
}

