/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalTaxDataState;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.IncomeTaxDeclareFacadeFactory;
import com.kingdee.shr.compensation.TbTypeEnum;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryFacadeFactory;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCollection;
import com.kingdee.shr.compensation.app.tax.base.TaxItemInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractTaxCalInitFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDataStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelTypeEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalForJSFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitDetailFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitDetailInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitDetailStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.tax.task.impl.TaxCalService;
import com.kingdee.shr.compensation.taxCal.util.TaxItemUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.CmpTaxUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TaxCalInitFacadeControllerBean
extends AbstractTaxCalInitFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TaxCalInitFacadeControllerBean.class);

    @Override
    protected void _calSum(Context ctx, Date periodBegin, String taxUnitIds, String incomeItemIds, String configIds, String personIds) throws BOSException, EASBizException {
        this.deleteTaxInitSum(ctx, periodBegin, taxUnitIds, incomeItemIds, configIds, personIds);
        this.insertTaxSum(ctx, periodBegin, taxUnitIds, incomeItemIds, configIds, personIds);
        this.deleteTaxConfigDetail(ctx, periodBegin, taxUnitIds, incomeItemIds, configIds, personIds);
        this.deleteTaxResult(ctx, periodBegin, taxUnitIds, incomeItemIds, configIds, personIds);
        StringBuilder str = new StringBuilder();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        str.append(" UPDATE T_HR_STAXCALINITDETAIL DETAIL SET FSTATE = ").append(40);
        str.append(" ,FLASTUPDATEUSERID = '").append(userId).append("'");
        str.append(" ,FLASTUPDATETIME = ").append(CmpDateUtil.toKSqlDate(new java.util.Date()));
        str.append(" WHERE FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND FTAXUNITID IN (").append(taxUnitIds).append(") ");
        str.append(" AND FDATASTATE = ").append(10);
        if (!StringUtils.isEmpty((CharSequence)personIds)) {
            str.append(" AND FPERSONID IN (").append(personIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)incomeItemIds)) {
            str.append(" AND FINCOMEITEMID IN (").append(incomeItemIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)configIds)) {
            str.append(" AND NOT EXISTS(");
            str.append(" SELECT 1 FROM T_HR_STAXCALCONFIGRESULT RESULT ");
            str.append(" WHERE DETAIL.FTAXUNITID = RESULT.FTAXUNITID AND DETAIL.FINCOMEITEMID = RESULT.FINCOMEITEMID ");
            str.append(" AND DETAIL.FPERIODBEGIN = RESULT.FPERIODBEGIN  AND DETAIL.FPERSONID = RESULT.FPERSONID ");
            str.append(" AND RESULT.FID IN (").append(configIds).append(") ");
            str.append(")");
        }
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private void deleteTaxConfigDetail(Context ctx, Date periodBegin, String taxUnitIds, String incomeItemIds, String configIds, String personIds) throws BOSException, EASBizException {
        StringBuilder str = new StringBuilder();
        str.append(" DELETE FROM T_HR_STAXCALCONFIGDETAIL DETAIL ");
        str.append(" WHERE FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND FTAXUNITID IN (").append(taxUnitIds).append(") ");
        if (!StringUtils.isEmpty((CharSequence)personIds)) {
            str.append(" AND FPERSONID IN (").append(personIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)incomeItemIds)) {
            str.append(" AND FINCOMEITEMID IN (").append(incomeItemIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)configIds)) {
            str.append(" AND NOT EXISTS(");
            str.append(" SELECT 1 FROM T_HR_STAXCALCONFIGRESULT RESULT ");
            str.append(" WHERE DETAIL.FTAXUNITID = RESULT.FTAXUNITID AND DETAIL.FINCOMEITEMID = RESULT.FINCOMEITEMID ");
            str.append(" AND DETAIL.FPERIODBEGIN = RESULT.FPERIODBEGIN  AND DETAIL.FPERSONID = RESULT.FPERSONID ");
            str.append(" AND RESULT.FID IN (").append(configIds).append(") ");
            str.append(")");
        }
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private void insertTaxSum(Context ctx, Date periodBegin, String taxUnitIds, String incomeItemIds, String configIds, String personIds) throws BOSException, EASBizException {
        int i;
        Object[] param;
        StringBuilder str = new StringBuilder();
        StringBuilder itemStr = new StringBuilder();
        StringBuilder insertParamVal = new StringBuilder();
        ArrayList<String> numItemList = new ArrayList<String>();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Date createTime = new Date(new java.util.Date().getTime());
        TaxItemCollection itemColl = TaxItemUtil.getAllTaxItem(ctx, true);
        if (null == itemColl || itemColl.size() < 1) {
            return;
        }
        for (int i2 = 0; i2 < itemColl.size(); ++i2) {
            TaxItemInfo itemInfo = itemColl.get(i2);
            if (itemInfo.isIsSum()) {
                str.append("sum(T").append(itemInfo.getFieldSn()).append(") T").append(itemInfo.getFieldSn()).append(",");
            } else {
                str.append("max(T").append(itemInfo.getFieldSn()).append(") T").append(itemInfo.getFieldSn()).append(",");
            }
            itemStr.append("T").append(itemInfo.getFieldSn()).append(",");
            numItemList.add("T" + itemInfo.getFieldSn());
            insertParamVal.append("?,");
        }
        int itemCount = numItemList.size();
        String sumItems = str.substring(0, str.length() - 1);
        String items = itemStr.substring(0, itemStr.length() - 1);
        str = new StringBuilder();
        str.append(" SELECT FPERSONID, FTAXUNITID, FINCOMEITEMID,FPERIODEND, ").append(sumItems);
        str.append(" FROM T_HR_STAXCALINITDETAIL DETAIL ");
        str.append(" WHERE FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND FTAXUNITID IN (").append(taxUnitIds).append(") ");
        str.append(" AND FDATASTATE = ").append(10);
        str.append(" AND FINCOMEITEMID IN (SELECT FID FROM T_HR_STAXINCOMEITEM WHERE FTAXCALMETHOD = 10) ");
        if (!StringUtils.isEmpty((CharSequence)personIds)) {
            str.append(" AND FPERSONID IN (").append(personIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)incomeItemIds)) {
            str.append(" AND FINCOMEITEMID IN (").append(incomeItemIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)configIds)) {
            str.append(" AND NOT EXISTS(");
            str.append(" SELECT 1 FROM T_HR_STAXCALCONFIGRESULT RESULT ");
            str.append(" WHERE DETAIL.FTAXUNITID = RESULT.FTAXUNITID AND DETAIL.FINCOMEITEMID = RESULT.FINCOMEITEMID ");
            str.append(" AND DETAIL.FPERIODBEGIN = RESULT.FPERIODBEGIN  AND DETAIL.FPERSONID = RESULT.FPERSONID ");
            str.append(" AND RESULT.FID IN (").append(configIds).append(") ");
            str.append(")");
        }
        str.append(" GROUP BY FPERSONID, FTAXUNITID, FINCOMEITEMID,FPERIODEND ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                param = new Object[12 + itemCount];
                param[0] = rowSet.getString("FPERSONID");
                param[1] = rowSet.getString("FTAXUNITID");
                param[2] = 10;
                param[3] = periodBegin;
                param[4] = rowSet.getDate("FPERIODEND");
                param[5] = userId;
                param[6] = createTime;
                param[7] = userId;
                param[8] = createTime;
                param[9] = BOSUuid.create((String)"17314C4F").toString();
                param[10] = rowSet.getString("FINCOMEITEMID");
                param[11] = rowSet.getString("FPERSONID");
                for (i = 0; i < numItemList.size(); ++i) {
                    param[12 + i] = rowSet.getBigDecimal((String)numItemList.get(i));
                }
                paramList.add(param);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        str = new StringBuilder();
        str.append(" SELECT FPERSONID, FTAXUNITID, FINCOMEITEMID,FPERIODEND,FCMPCALTABLEID, ").append(items);
        str.append(" FROM T_HR_STAXCALINITDETAIL DETAIL ");
        str.append(" WHERE FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND FTAXUNITID IN (").append(taxUnitIds).append(") ");
        str.append(" and FINCOMEITEMID in (select fid from T_HR_STaxIncomeItem where FTaxCalMethod = 20) ");
        if (!StringUtils.isEmpty((CharSequence)personIds)) {
            str.append(" AND FPERSONID IN (").append(personIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)incomeItemIds)) {
            str.append(" AND FINCOMEITEMID IN (").append(incomeItemIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)configIds)) {
            str.append(" AND NOT EXISTS(");
            str.append(" SELECT 1 FROM T_HR_STAXCALCONFIGRESULT RESULT ");
            str.append(" WHERE DETAIL.FTAXUNITID = RESULT.FTAXUNITID AND DETAIL.FINCOMEITEMID = RESULT.FINCOMEITEMID ");
            str.append(" AND DETAIL.FPERIODBEGIN = RESULT.FPERIODBEGIN  AND DETAIL.FPERSONID = RESULT.FPERSONID ");
            str.append(" AND RESULT.FID IN (").append(configIds).append(") ");
            str.append(")");
        }
        str.append(" and FDataState = ").append(10);
        rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                param = new Object[12 + itemCount];
                param[0] = rowSet.getString("FPERSONID");
                param[1] = rowSet.getString("FTAXUNITID");
                param[2] = 10;
                param[3] = periodBegin;
                param[4] = rowSet.getDate("FPERIODEND");
                param[5] = userId;
                param[6] = createTime;
                param[7] = userId;
                param[8] = createTime;
                param[9] = BOSUuid.create((String)"17314C4F").toString();
                param[10] = rowSet.getString("FINCOMEITEMID");
                param[11] = rowSet.getString("FCMPCALTABLEID");
                for (i = 0; i < numItemList.size(); ++i) {
                    param[12 + i] = rowSet.getBigDecimal((String)numItemList.get(i));
                }
                paramList.add(param);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        str = new StringBuilder();
        str.append(" INSERT INTO T_HR_STAXCALINITSUM(");
        str.append(" FPERSONID, FTAXUNITID, FSTATE, FPERIODBEGIN, FPERIODEND, ");
        str.append(" FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, FID,");
        str.append(" FINCOMEITEMID, FRELATIONID, ");
        str.append(items).append(") ");
        str.append(" VALUES(?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ?, ?, ?,?, ");
        str.append(insertParamVal.substring(0, insertParamVal.length() - 1));
        str.append(") ");
        DbUtil.executeBatch((Context)ctx, (String)str.toString(), paramList);
    }

    private void deleteTaxInitSum(Context ctx, Date periodBegin, String taxUnitIds, String incomeItemIds, String configIds, String personIds) throws BOSException, EASBizException {
        StringBuilder str = new StringBuilder();
        str.append(" DELETE FROM T_HR_STAXCALINITSUM INITSUM ");
        str.append(" WHERE FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND FTAXUNITID IN (").append(taxUnitIds).append(") ");
        if (!StringUtils.isEmpty((CharSequence)personIds)) {
            str.append(" AND FPERSONID IN (").append(personIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)incomeItemIds)) {
            str.append(" AND FINCOMEITEMID IN (").append(incomeItemIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)configIds)) {
            str.append(" AND NOT EXISTS(");
            str.append(" SELECT 1 FROM T_HR_STAXCALCONFIGRESULT RESULT ");
            str.append(" WHERE INITSUM.FTAXUNITID = RESULT.FTAXUNITID AND INITSUM.FINCOMEITEMID = RESULT.FINCOMEITEMID ");
            str.append(" AND INITSUM.FPERIODBEGIN = RESULT.FPERIODBEGIN  AND INITSUM.FPERSONID = RESULT.FPERSONID ");
            str.append(" AND RESULT.FID IN (").append(configIds).append(") ");
            str.append(")");
        }
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private void deleteTaxResult(Context ctx, Date periodBegin, String taxUnitIds, String incomeItemIds, String configIds, String personIds) throws BOSException, EASBizException {
        this.sendMsg2Creator(ctx, periodBegin, taxUnitIds, incomeItemIds, configIds, personIds);
        StringBuilder str = new StringBuilder();
        str.append(" DELETE FROM T_HR_STAXCALCONFIGRESULT RESULT ");
        str.append(" WHERE FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND FTAXUNITID IN (").append(taxUnitIds).append(") ");
        str.append(" AND FSTATE = ").append(10);
        if (!StringUtils.isEmpty((CharSequence)personIds)) {
            str.append(" AND FPERSONID IN (").append(personIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)incomeItemIds)) {
            str.append(" AND FINCOMEITEMID IN (").append(incomeItemIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)configIds)) {
            str.append(" AND fid not in (" + configIds + ")");
        }
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private void sendMsg2Creator(Context ctx, Date periodBegin, String taxUnitIds, String incomeItemIds, String configIds, String personIds) {
        StringBuilder str = new StringBuilder();
        str.append(" SELECT DISTINCT ");
        str.append(" CONFIG.FCREATORID SENDUSERID,  ");
        str.append(" TAXUNIT.FNAME_L2 TAXUNITNAME,  ");
        str.append(" PERSON.FNAME_L2 PERSONNAME, ");
        str.append(" PERSON.FNUMBER PERSONNUMBER, ");
        str.append(" PERSON.FID PERSONID");
        str.append(" FROM T_HR_STAXCALCONFIGRESULT CONFIG ");
        str.append(" INNER JOIN T_HR_TAXUNIT TAXUNIT ON CONFIG.FTAXUNITID = TAXUNIT.FID  ");
        str.append(" INNER JOIN T_BD_PERSON PERSON ON CONFIG.FPERSONID = PERSON.FID ");
        str.append(" WHERE CONFIG.FPERIODBEGIN = ").append(CmpDateUtil.toKSqlDate(periodBegin));
        str.append(" AND CONFIG.FTAXUNITID IN (").append(taxUnitIds).append(") ");
        str.append(" AND CONFIG.FSTATE = ").append(10);
        if (!StringUtils.isEmpty((CharSequence)incomeItemIds)) {
            str.append(" AND CONFIG.FINCOMEITEMID IN (").append(incomeItemIds).append(") ");
        }
        if (!StringUtils.isEmpty((CharSequence)personIds)) {
            str.append(" AND CONFIG.FPERSONID IN (").append(personIds).append(")");
        }
        str.append(" ORDER BY CONFIG.FCREATORID,TAXUNIT.FNAME_L2,PERSON.FNUMBER");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            String personName = "";
            String personNumber = "";
            ArrayList<String> tempList = new ArrayList<String>();
            HashSet<String> dupNameList = new HashSet<String>();
            while (rowSet.next()) {
                personName = rowSet.getString(1);
                if (tempList.contains(personName)) {
                    dupNameList.add(personName);
                    continue;
                }
                tempList.add(personName);
            }
            HashMap<String, Map<String, Map<String, Set<String>>>> sendMsgMap = new HashMap<String, Map<String, Map<String, Set<String>>>>();
            rowSet.beforeFirst();
            String sendUserID = "";
            String taxUnitName = "";
            while (rowSet.next()) {
                sendUserID = rowSet.getString("SENDUSERID");
                Map tempMap = sendMsgMap.containsKey(sendUserID) ? (Map)sendMsgMap.get(sendUserID) : new HashMap();
                Map taxUnitMap = tempMap.containsKey("TAXUNITMAP") ? (Map)tempMap.get("TAXUNITMAP") : new HashMap();
                taxUnitName = rowSet.getString("TAXUNITNAME");
                Set taxUnitPersonSet = taxUnitMap.containsKey(taxUnitName) ? (Set)taxUnitMap.get(taxUnitName) : new HashSet();
                personName = rowSet.getString("PERSONNAME");
                if (dupNameList.contains(personName)) {
                    personNumber = rowSet.getString("PERSONNUMBER");
                    personName = personName + "\uff08" + personNumber + "\uff09";
                }
                taxUnitPersonSet.add(personName);
                taxUnitMap.put(taxUnitName, taxUnitPersonSet);
                tempMap.put("TAXUNITMAP", taxUnitMap);
                sendMsgMap.put(sendUserID, tempMap);
            }
            if (sendMsgMap.size() > 0) {
                this.sendMsg2(ctx, sendMsgMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void sendMsg2(Context ctx, Map<String, Map<String, Map<String, Set<String>>>> sendMsgMap) {
        String title = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label11", (Locale)ctx.getLocale());
        String msg1Template = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label12", (Locale)ctx.getLocale());
        String category = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label13", (Locale)ctx.getLocale());
        String sendUserID = "";
        String taxUnitName2 = "";
        Set<String> keySet = sendMsgMap.keySet();
        Iterator<String> iterator = keySet.iterator();
        MessageUtil.setNeedSending(ctx);
        while (iterator.hasNext()) {
            StringBuffer msg1Buffer = new StringBuffer();
            sendUserID = iterator.next();
            Map<String, Map<String, Set<String>>> tempMap = sendMsgMap.get(sendUserID);
            Map<String, Set<String>> taxUnitMap = tempMap.get("TAXUNITMAP");
            Set<String> keySet2 = taxUnitMap.keySet();
            for (String taxUnitName2 : keySet2) {
                Set<String> personNameSet = taxUnitMap.get(taxUnitName2);
                msg1Buffer.append("\uff1b\r\n").append(MessageFormat.format(msg1Template, taxUnitName2, personNameSet.toString().replace("[", "").replace("]", "").replace(",", "\u3001")));
            }
            MessageUtil.sendMessage(ctx, sendUserID, title, msg1Buffer.toString().replaceFirst("\uff1b\r\n", ""), category);
        }
    }

    @Override
    protected Set<String> _submitCalData(Context ctx, List dataList, List itemList) throws BOSException {
        HashSet<String> calTableSet = new HashSet<String>();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        ArrayList<Object[]> inserParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> delParamList = new ArrayList<Object[]>();
        int itemCount = itemList.size();
        StringBuilder str = new StringBuilder();
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>();
        for (Object stringObjectMap : dataList) {
            Map map = (Map)stringObjectMap;
            str.append(map.get("FCMPCALTABLEID")).append(",");
            Object[] param = new Object[]{map.get("FCMPCALTABLEID"), map.get("FINCOMEITEMID")};
            deleteParams.add(param);
        }
        String calIds = str.substring(0, str.length() - 1);
        String calIdSql = CmpSQLUtil.createInSql(ctx, calIds, "T_HR_STAXITEM", "FID");
        HashMap<String, String> calTableMap = new HashMap<String, String>();
        String sql = "SELECT FCMPCALTABLEID, fIncomeItemId, FLASTUPDATEUSERID FROM T_HR_STAXCALINITDETAIL WHERE FCMPCALTABLEID IN ( " + calIdSql + " ) AND FSTATE in ( " + 40 + "," + 20 + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String key = rowSet.getString("FCMPCALTABLEID") + rowSet.getString("fIncomeItemId");
                calTableMap.put(key, rowSet.getString("FLASTUPDATEUSERID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        String delInitDetailSql = " DELETE FROM T_HR_STAXCALINITDETAIL  WHERE FCMPCALTABLEID = ? and fIncomeItemId = ? ";
        StringBuilder insertParaStr = new StringBuilder();
        StringBuilder insertValStr = new StringBuilder();
        insertParaStr.append(" INSERT INTO T_HR_STAXCALINITDETAIL(");
        insertParaStr.append(" FID, FCMPCALTABLEID, FSTATE, FCALSCHEMEID, FDATASTATE, ");
        insertParaStr.append(" FPERSONID, FTAXUNITID, FPERIODBEGIN, FPERIODEND, FCREATORID, ");
        insertParaStr.append(" FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME,FINCOMEITEMID,FDifference, ");
        insertValStr.append(" values(?, ?, ?, ?, ?, ");
        insertValStr.append(" ?, ?, ?, ?, ?, ");
        insertValStr.append(" ?, ?, ?,?,?, ");
        for (Object col : itemList) {
            String colName = (String)col;
            insertParaStr.append(colName).append(",");
            insertValStr.append("?,");
        }
        String inserSql = insertParaStr.substring(0, insertParaStr.length() - 1) + ")" + insertValStr.substring(0, insertValStr.length() - 1) + ")";
        for (Object map : dataList) {
            Map dataMap = (Map)map;
            String calTableId = dataMap.get("FCMPCALTABLEID").toString();
            String incomeItemId = dataMap.get("FINCOMEITEMID").toString();
            calTableSet.add(calTableId);
            Object[] param = new Object[]{calTableId, incomeItemId};
            delParamList.add(param);
            param = new Object[15 + itemCount];
            param[0] = BOSUuid.create((String)"D7699BCD").toString();
            param[1] = dataMap.get("FCMPCALTABLEID");
            param[2] = 10;
            String key = calTableId + incomeItemId;
            param[2] = calTableMap.containsKey(key) ? Integer.valueOf(20) : Integer.valueOf(10);
            param[3] = dataMap.get("FCALSCHEMEID");
            param[4] = 10;
            param[5] = dataMap.get("FPERSONID");
            param[6] = dataMap.get("FTAXUNITID");
            param[7] = dataMap.get("FPERIODBEGIN");
            param[8] = dataMap.get("FPERIODEND");
            param[9] = userId;
            param[10] = createTime;
            param[11] = calTableMap.containsKey(key) ? calTableMap.get(key) : userId;
            param[12] = createTime;
            param[13] = incomeItemId;
            param[14] = 10;
            for (int k = 0; k < itemList.size(); ++k) {
                param[15 + k] = dataMap.get(itemList.get(k));
            }
            inserParamList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)delInitDetailSql, delParamList);
        DbUtil.executeBatch((Context)ctx, (String)inserSql, inserParamList);
        str = new StringBuilder();
        str.append(" DELETE FROM T_HR_STAXCALCONFIGRESULT A01 ");
        str.append(" WHERE EXISTS(SELECT 1 FROM T_HR_STAXCALINITDETAIL B01 ");
        str.append(" WHERE B01.FCMPCALTABLEID = ? and B01.fIncomeItemId = ? ");
        str.append(" and A01.FTAXUNITID = B01.FTAXUNITID and A01.FINCOMEITEMID = B01.FINCOMEITEMID ");
        str.append(" and A01.FPERSONID = B01.FPERSONID AND A01.FPERIODBEGIN = B01.FPERIODBEGIN)");
        DbUtil.executeBatch((Context)ctx, (String)str.toString(), deleteParams);
        str = new StringBuilder();
        str.append(" DELETE FROM T_HR_STAXCALINITSUM A01 ");
        str.append(" WHERE EXISTS(SELECT 1 FROM T_HR_STAXCALINITDETAIL B01 ");
        str.append(" WHERE B01.FCMPCALTABLEID = ? and B01.fIncomeItemId = ? ");
        str.append(" and A01.FTAXUNITID = B01.FTAXUNITID and A01.FINCOMEITEMID = B01.FINCOMEITEMID ");
        str.append(" and A01.FPERSONID = B01.FPERSONID AND A01.FPERIODBEGIN = B01.FPERIODBEGIN)");
        DbUtil.executeBatch((Context)ctx, (String)str.toString(), deleteParams);
        return calTableSet;
    }

    @Override
    protected void _deleteCalPerson(Context ctx, String calIds, boolean isTaxCalDelete, String userId) throws BOSException {
        StringBuilder str;
        boolean isCal = true;
        try {
            isCal = HRParamUtil.getParamOfHR((Context)ctx, (String)"shr_cmp_026", null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String querySQL = " select fTaxUnitId, fPeriodBegin FROM T_HR_STaxCalInitDetail where fCmpCalTableId IN (" + calIds + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL);
        if (isCal) {
            String updateLast = " update T_HR_STAXCALCONFIGDETAIL set FIsLast = 1 where FCMPCALTABLEID in (select FRelayID from T_HR_STAxCalTaskDetail where FCMPCALTABLEID in (" + calIds + "))";
            DbUtil.execute((Context)ctx, (String)updateLast);
            str = new StringBuilder();
            str.append(" DELETE FROM T_HR_STAXCALINITDETAIL WHERE FCMPCALTABLEID IN (").append(calIds).append(") ");
            if (!isTaxCalDelete) {
                str.append(" AND FSTATE IN (").append(10);
                str.append(" ,").append(50).append(")");
            }
            DbUtil.execute((Context)ctx, (String)str.toString());
            String sql = "DELETE FROM T_HR_STAXCALCONFIGDETAIL WHERE FCMPCALTABLEID IN (" + calIds + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            this.sendMsg2Handler(ctx, calIds);
            str = new StringBuilder();
            str.append(" DELETE FROM T_HR_STAXCALINITDETAIL WHERE FCMPCALTABLEID IN (").append(calIds).append(") ");
            str.append(" AND FSTATE = ").append(10);
            DbUtil.execute((Context)ctx, (String)str.toString());
            str = new StringBuilder();
            str.append(" UPDATE T_HR_STAXCALINITDETAIL SET FDATASTATE = ").append(20);
            str.append(" , FSTATE = ").append(20);
            str.append(" WHERE FCMPCALTABLEID IN (").append(calIds).append(")");
            str.append(" AND FSTATE in (").append(20);
            str.append(" ,").append(40).append(")");
            DbUtil.execute((Context)ctx, (String)str.toString());
            str = new StringBuilder();
            str.append(" DELETE FROM T_HR_STAXCALINITSUM A01 ");
            str.append(" WHERE EXISTS(SELECT 1 FROM T_HR_STAXCALINITDETAIL A02 ");
            str.append(" WHERE A01.FPERSONID = A02.FPERSONID AND A01.FTAXUNITID = A02.FTAXUNITID ");
            str.append(" AND A01.FINCOMEITEMID = A02.FINCOMEITEMID AND A01.FPERIODBEGIN = A02.FPERIODBEGIN");
            str.append(" AND FCMPCALTABLEID IN (").append(calIds).append(") )");
            DbUtil.execute((Context)ctx, (String)str.toString());
            str = new StringBuilder();
            str.append(" DELETE FROM T_HR_STAXCALCONFIGRESULT A01 ");
            str.append(" WHERE EXISTS(SELECT 1 FROM T_HR_STAXCALINITDETAIL A02 ");
            str.append(" WHERE A01.FPERSONID = A02.FPERSONID AND A01.FTAXUNITID = A02.FTAXUNITID ");
            str.append(" AND A01.FINCOMEITEMID = A02.FINCOMEITEMID AND A01.FPERIODBEGIN = A02.FPERIODBEGIN");
            str.append(" AND FCMPCALTABLEID IN (").append(calIds).append(") )");
            DbUtil.execute((Context)ctx, (String)str.toString());
            String sql = "DELETE FROM T_HR_STAXCALCONFIGDETAIL WHERE FCMPCALTABLEID IN (" + calIds + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        try {
            HashMap<String, Date> map = new HashMap<String, Date>();
            while (rs.next()) {
                map.put(rs.getString("fTaxUnitId"), rs.getDate("fPeriodBegin"));
            }
            for (Map.Entry entry : map.entrySet()) {
                ReductionSummaryFacadeFactory.getLocalInstance(ctx).save((String)entry.getKey(), (java.util.Date)entry.getValue(), userId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u51cf\u514d\u4e8b\u9879\u51fa\u9519\uff1a", (Throwable)e);
        }
    }

    private void sendMsg2Handler(Context ctx, String calIds) {
        StringBuilder str = new StringBuilder();
        str.append(" SELECT DISTINCT ");
        str.append(" SENDUSER.FID SENDUSERID, ");
        str.append(" TAXUNIT.FNAME_L2 TAXUNITNAME, ");
        str.append(" PERSON.FNAME_L2 PERSONNAME ");
        str.append(" FROM ");
        str.append(" T_HR_STAXCALINITDETAIL DETAIL ");
        str.append(" INNER JOIN T_PM_USER SENDUSER ON DETAIL.FLASTUPDATEUSERID = SENDUSER.FID ");
        str.append(" INNER JOIN T_BD_PERSON PERSON ON DETAIL.FPERSONID = PERSON.FID ");
        str.append(" INNER JOIN T_HR_TAXUNIT TAXUNIT ON DETAIL.FTAXUNITID = TAXUNIT.FID  ");
        str.append(" WHERE DETAIL.FCMPCALTABLEID IN (").append(calIds).append(") ");
        str.append(" AND DETAIL.FSTATE = ").append(40);
        try {
            HashMap<String, Map<String, Set<String>>> sendMsgMap = new HashMap<String, Map<String, Set<String>>>();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            String sendUserID = "";
            String taxUnitName = "";
            String personName = "";
            while (rowSet.next()) {
                sendUserID = rowSet.getString("SENDUSERID");
                Map taxUnitMap = sendMsgMap.containsKey(sendUserID) ? (Map)sendMsgMap.get(sendUserID) : new HashMap();
                taxUnitName = rowSet.getString("TAXUNITNAME");
                Set personSet = taxUnitMap.containsKey(taxUnitName) ? (Set)taxUnitMap.get(taxUnitName) : new HashSet();
                personName = rowSet.getString("PERSONNAME");
                personSet.add(personName);
                taxUnitMap.put(taxUnitName, personSet);
                sendMsgMap.put(sendUserID, taxUnitMap);
            }
            if (sendMsgMap.size() > 0) {
                this.sendMsg(ctx, sendMsgMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMsg(Context ctx, Map<String, Map<String, Set<String>>> secondSendMsgMap) {
        String title = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label14", (Locale)ctx.getLocale());
        String msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label15", (Locale)ctx.getLocale());
        String category = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label16", (Locale)ctx.getLocale());
        String sendUserID = "";
        String taxUnitName2 = "";
        Set<String> keySet = secondSendMsgMap.keySet();
        Iterator<String> iterator = keySet.iterator();
        MessageUtil.setNeedSending(ctx);
        while (iterator.hasNext()) {
            StringBuffer msgBuffer = new StringBuffer();
            sendUserID = iterator.next();
            Map<String, Set<String>> taxUnitMap = secondSendMsgMap.get(sendUserID);
            Set<String> keySet2 = taxUnitMap.keySet();
            for (String taxUnitName2 : keySet2) {
                Set<String> personNameSet = taxUnitMap.get(taxUnitName2);
                msgBuffer.append("\uff1b\r\n").append(MessageFormat.format(msgTemplate, taxUnitName2, personNameSet.toString().replace("[", "").replace("]", "").replace(",", "\u3001")));
            }
            MessageUtil.sendMessage(ctx, sendUserID, title, msgBuffer.toString().replaceFirst("\uff1b\r\n", ""), category);
        }
    }

    @Override
    protected List<String> _beforeDeleteCalPerson(Context ctx, String calIds) throws BOSException {
        boolean isCal;
        try {
            isCal = HRParamUtil.getParamOfHR((Context)ctx, (String)"shr_cmp_026", null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder str = new StringBuilder();
        if (isCal) {
            str.append(" SELECT distinct tt.PERSONNAME,tt.fnumber");
            str.append(" from (SELECT PERSON.FNAME_L2 PERSONNAME,PERSON.FNUMBER ");
            str.append(" FROM T_HR_STAXCALCONFIGDETAIL CONFIG ");
            str.append(" INNER JOIN T_BD_PERSON PERSON ON CONFIG.FPERSONID = PERSON.FID ");
            str.append(" WHERE CONFIG.FCMPCALTABLEID IN (").append(calIds).append(")");
            str.append(" AND CONFIG.FISLAST = 1");
            str.append(" UNION ALL ");
            str.append(" SELECT distinct PERSON.FNAME_L2 PERSONNAME,PERSON.FNUMBER FROM  ");
            str.append(" T_HR_STAXCALINITDETAIL DETAIL ");
            str.append(" INNER JOIN T_BD_PERSON PERSON ON DETAIL.FPERSONID = PERSON.FID  ");
            str.append(" WHERE DETAIL.FCMPCALTABLEID IN (").append(calIds).append(")");
            str.append(" AND DETAIL.FSTATE = ").append(20);
            str.append(" ) tt");
        } else {
            str.append(" SELECT distinct PERSON.FNAME_L2,PERSON.FNUMBER ");
            str.append(" FROM T_HR_STAXCALINITDETAIL DETAIL ");
            str.append(" INNER JOIN T_BD_PERSON PERSON ON DETAIL.FPERSONID = PERSON.FID ");
            str.append(" WHERE DETAIL.FCMPCALTABLEID IN (").append(calIds).append(")");
            str.append(" AND DETAIL.FSTATE = 40");
        }
        try {
            String personName;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            ArrayList<String> tempList = new ArrayList<String>();
            HashSet<String> dupNameList = new HashSet<String>();
            while (rowSet.next()) {
                personName = rowSet.getString(1);
                if (tempList.contains(personName)) {
                    dupNameList.add(personName);
                    continue;
                }
                tempList.add(personName);
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                personName = rowSet.getString(1);
                if (dupNameList.contains(personName)) {
                    String personNumber = rowSet.getString(2);
                    personName = personName + "\uff08" + personNumber + "\uff09";
                }
                list.add(personName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        return list;
    }

    @Override
    protected Object _deleteTaxCalPerson(Context ctx, String calIds) throws BOSException {
        boolean isCal;
        try {
            isCal = HRParamUtil.getParamOfHR((Context)ctx, (String)"shr_cmp_026", null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        ArrayList<String> initIds = new ArrayList<String>();
        HashSet<String> failedSet = new HashSet<String>();
        ArrayList<String> allIdList = new ArrayList<String>();
        HashSet<String> succList = new HashSet<String>();
        ArrayList<String> failedList = new ArrayList<String>();
        HashMap<String, BatchMessageTipsBody> messageMap = new HashMap<String, BatchMessageTipsBody>();
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        HashSet<String> total = new HashSet<String>();
        HashSet<String> failed = new HashSet<String>();
        StringBuilder str = new StringBuilder();
        str.append(" SELECT DETAIL.FID DETAILID, DETAIL.FSTATE, DETAIL.FPERIODEND,CAL.FID FCMPCALTABLEID, ");
        str.append(" PERSON.FNAME_L2 NAME, PERSON.FNUMBER PERNUMBER, CONFIG.FID CONFIGID, CONFIG.FISLAST, CONFIG.FSTATE CONFIGSTATE, ");
        str.append(" CAL.FCALSTATE, CAL.FISLOCKOTHERSYSDATA ");
        str.append(" FROM T_HR_SCMPCALTABLE CAL INNER JOIN T_BD_PERSON PERSON ON CAL.FPERSONID = PERSON.FID ");
        str.append(" LEFT JOIN T_HR_STAXCALINITDETAIL DETAIL ON DETAIL.FCMPCALTABLEID = CAL.FID AND DETAIL.FDATASTATE = ").append(10);
        str.append(" LEFT JOIN T_HR_STAXCALCONFIGDETAIL CONFIG ON DETAIL.FCMPCALTABLEID = CONFIG.FCMPCALTABLEID and  DETAIL.fIncomeItemId = CONFIG.fIncomeItemId ");
        str.append(" WHERE CAL.FID IN (").append(calIds).append(")");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rowSet.next()) {
                boolean isSuccess = true;
                String msg = "";
                String calId = rowSet.getString("FCMPCALTABLEID");
                total.add(calId);
                String initId = rowSet.getString("DETAILID");
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                body.setId(rowSet.getString("FCMPCALTABLEID"));
                if (rowSet.getInt("FCALSTATE") >= 8 || rowSet.getInt("FISLOCKOTHERSYSDATA") == 1) {
                    isSuccess = false;
                    failedSet.add(calId);
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label17", (Locale)ctx.getLocale());
                } else if (!StringUtils.isEmpty((CharSequence)initId) && 20 == rowSet.getInt("CONFIGSTATE")) {
                    isSuccess = false;
                    failedSet.add(calId);
                    msg = isCal ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label18", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label19", (Locale)ctx.getLocale());
                } else if (!StringUtils.isEmpty((CharSequence)initId) && isCal) {
                    if (30 == rowSet.getInt("FSTATE")) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label20", (Locale)ctx.getLocale());
                        failedSet.add(calId);
                    } else if (20 == rowSet.getInt("FSTATE")) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label21", (Locale)ctx.getLocale());
                        initIds.add(initId + "_" + calId);
                    } else if (!StringUtils.isEmpty((CharSequence)rowSet.getString("CONFIGID")) && !rowSet.getBoolean("FISLAST")) {
                        isSuccess = false;
                        failedSet.add(calId);
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label22", (Locale)ctx.getLocale());
                    } else if (!StringUtils.isEmpty((CharSequence)rowSet.getString("CONFIGID")) && rowSet.getBoolean("FISLAST")) {
                        isSuccess = false;
                        msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label23", (Locale)ctx.getLocale());
                        initIds.add(initId + "_" + calId);
                    }
                }
                if (isSuccess) {
                    msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label24", (Locale)ctx.getLocale());
                    succList.add(calId);
                } else {
                    failedList.add(calId);
                    failed.add(calId);
                }
                body.setMuitTipsState(isSuccess);
                body.setMuitTipsMessage(msg);
                ArrayList<String> messageListExt = new ArrayList<String>();
                messageListExt.add(rowSet.getString("PERNUMBER"));
                messageListExt.add(rowSet.getString("NAME"));
                body.addMessageListExt(messageListExt);
                this.addBody2Header(ctx, header, body, calId, messageMap, isSuccess);
                allIdList.add(calId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        header.setBillId(CmpStrUtil.convertListToString(allIdList));
        header.setFailureCount(failed.size());
        header.setSuccessCount(total.size() - failed.size());
        if (isCal) {
            HashSet<String> initList = new HashSet<String>();
            for (String initId2CalId : initIds) {
                String[] arr = initId2CalId.split("_");
                if (failedSet.contains(arr[1])) continue;
                initList.add(arr[0]);
            }
            if (!initList.isEmpty()) {
                TaxCalForJSFacadeFactory.getLocalInstance(ctx).deleteCalData(CmpStrUtil.convertSetToSqlString(initList), TaxCalDelTypeEnum.DEL_PERSON);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", header);
        if (!failedList.isEmpty()) {
            succList.removeAll(failedList);
        }
        map.put("succList", succList);
        return map;
    }

    private void addBody2Header(Context ctx, BatchMessageTipsHeader header, BatchMessageTipsBody body, String calId, Map<String, BatchMessageTipsBody> messageMap, boolean isSuccess) {
        if (!messageMap.containsKey(calId)) {
            messageMap.put(calId, body);
            header.addResult(body);
            return;
        }
        if (!isSuccess) {
            BatchMessageTipsBody old = messageMap.get(calId);
            messageMap.put(calId, body);
            String message = body.getMuitTipsMessage();
            String suc1 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label23", (Locale)ctx.getLocale());
            String suc2 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label21", (Locale)ctx.getLocale());
            if (!suc1.equals(message) && !suc2.equals(message)) {
                header.getResult().remove(old);
                header.addResult(body);
            }
        }
    }

    @Override
    protected void _updateTaxUnit(Context ctx, String calIds) throws BOSException {
    }

    @Override
    protected Map _beforeUpdateTaxUnit(Context ctx, String calIds) throws BOSException {
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        if (StringUtils.isEmpty((CharSequence)calIds)) {
            return resultMap;
        }
        HashMap cmpCalTableMap = new HashMap();
        HashSet<String> cmpCalTableNoTaxUnitSet = new HashSet<String>();
        HashMap taxCalInitDetailMap = new HashMap();
        HashSet<String> taxCalResultDetailSet = new HashSet<String>();
        String language = ctx.getLocale().getLanguage();
        StringBuilder getCmpCalTableSQLBuffer = new StringBuilder();
        getCmpCalTableSQLBuffer.append(" SELECT CAL.FID CALID,TAXUNIT.FID TAXUNITID,TAXUNIT.FNAME_").append(language).append(" TAXUNITNAME,CAL.FCALTAXDATASTATE, ");
        getCmpCalTableSQLBuffer.append(" PERSON.FID PERSONID,PERSON.FNUMBER PERSONNUMBER,PERSON.FNAME_").append(language).append(" PERSONNAME,CAL.FPERIODYEAR,CAL.FPERIODMONTH ");
        getCmpCalTableSQLBuffer.append(" FROM T_HR_SCMPCALTABLE CAL ");
        getCmpCalTableSQLBuffer.append(" LEFT JOIN T_HR_TAXUNIT TAXUNIT ON CAL.FTAXUNITID = TAXUNIT.FID ");
        getCmpCalTableSQLBuffer.append(" INNER JOIN T_BD_PERSON PERSON ON CAL.FPERSONID = PERSON.FID ");
        getCmpCalTableSQLBuffer.append(" WHERE CAL.FID IN (").append(calIds).append(") ");
        try {
            IRowSet cmpCalTableRs = DbUtil.executeQuery((Context)ctx, (String)getCmpCalTableSQLBuffer.toString());
            if (cmpCalTableRs.size() > 0) {
                String getTaxCalConfigDetailSQLBuffer;
                IRowSet taxCalConfigDetailRs;
                String taxUnitID;
                String getTaxCalInitDetailSQLBuffer = " SELECT  DETAIL.FID DETAILID, CAL.FID CALID, DETAIL.FSTATE,DETAIL.FDATASTATE,DETAIL.FPERIODBEGIN,TAXUNIT.FID TAXUNITID  FROM T_HR_STAXCALINITDETAIL DETAIL  INNER JOIN T_HR_SCMPCALTABLE CAL ON DETAIL.FCMPCALTABLEID = CAL.FID  INNER JOIN T_HR_TAXUNIT TAXUNIT ON DETAIL.FTAXUNITID = TAXUNIT.FID  WHERE DETAIL.FCMPCALTABLEID IN (" + calIds + ") AND DETAIL.FDATASTATE = 10 ";
                IRowSet collectionRs = DbUtil.executeQuery((Context)ctx, (String)getTaxCalInitDetailSQLBuffer);
                if (collectionRs.size() > 0) {
                    while (collectionRs.next()) {
                        HashMap<String, Object> tempMap = new HashMap<String, Object>();
                        String cmpCalTableID = collectionRs.getString("CALID");
                        TaxCalInitDetailStateEnum state = TaxCalInitDetailStateEnum.getEnum(collectionRs.getInt("FSTATE"));
                        TaxCalDataStateEnum dataState = TaxCalDataStateEnum.getEnum(collectionRs.getInt("FDATASTATE"));
                        Date periodBegin = collectionRs.getDate("FPERIODBEGIN");
                        taxUnitID = collectionRs.getString("TAXUNITID");
                        tempMap.put("state", (Object)state);
                        tempMap.put("dataState", (Object)dataState);
                        tempMap.put("periodBegin", periodBegin);
                        tempMap.put("taxUnitID", taxUnitID);
                        taxCalInitDetailMap.put(cmpCalTableID, tempMap);
                    }
                }
                if ((taxCalConfigDetailRs = DbUtil.executeQuery((Context)ctx, (String)(getTaxCalConfigDetailSQLBuffer = " SELECT DETAIL.FID DETAILID, CAL.FID CALID, DETAIL.FSTATE  FROM T_HR_STAXCALCONFIGDETAIL DETAIL  INNER JOIN T_HR_SCMPCALTABLE CAL ON DETAIL.FCMPCALTABLEID = CAL.FID  WHERE DETAIL.FCMPCALTABLEID IN (" + calIds + ") AND DETAIL.FSTATE = 20 "))).size() > 0) {
                    while (taxCalConfigDetailRs.next()) {
                        String cmpCalTableID = taxCalConfigDetailRs.getString("CALID");
                        taxCalResultDetailSet.add(cmpCalTableID);
                    }
                }
                while (cmpCalTableRs.next()) {
                    HashMap<String, Object> tempMap = new HashMap<String, Object>();
                    String cmpCalTableID = cmpCalTableRs.getString("CALID");
                    CalTaxDataState calTaxDataState = CalTaxDataState.getEnum(cmpCalTableRs.getInt("FCALTAXDATASTATE"));
                    taxUnitID = cmpCalTableRs.getString("TAXUNITID");
                    if (taxUnitID == null) {
                        cmpCalTableNoTaxUnitSet.add(cmpCalTableID);
                        continue;
                    }
                    String taxUnitName = cmpCalTableRs.getString("TAXUNITNAME");
                    String personID = cmpCalTableRs.getString("PERSONID");
                    String personNum = cmpCalTableRs.getString("PERSONNUMBER");
                    String personName = cmpCalTableRs.getString("PERSONNAME");
                    tempMap.put("personID", personID);
                    tempMap.put("personNum", personNum);
                    tempMap.put("personName", personName);
                    tempMap.put("taxUnitID", taxUnitID);
                    tempMap.put("taxUnitName", taxUnitName);
                    tempMap.put("calTaxDataState", (Object)calTaxDataState);
                    tempMap.put("id", cmpCalTableID);
                    cmpCalTableMap.put(cmpCalTableID, tempMap);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        resultMap.put("cmpCalTableMap", cmpCalTableMap);
        resultMap.put("cmpCalTableNoTaxUnitSet", cmpCalTableNoTaxUnitSet);
        resultMap.put("taxCalInitDetailMap", taxCalInitDetailMap);
        resultMap.put("taxCalResultDetailSet", taxCalResultDetailSet);
        return resultMap;
    }

    @Override
    protected synchronized BatchMessageTipsHeader _genZeroIncome(Context ctx, String taxUnitId, Date periodBegin, String personIds) throws BOSException {
        ArrayList<String> personList = new ArrayList<String>();
        Collections.addAll(personList, personIds.split(","));
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        this.beforeGenerating(ctx, header, personList, taxUnitId, periodBegin, personIds);
        try {
            this.doGenerating(ctx, personList, taxUnitId, periodBegin);
        }
        catch (SQLException e) {
            logger.error((Object)"_genZeroIncome error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        this.afterGenerating(ctx, header, personList);
        return header;
    }

    protected void afterGenerating(Context ctx, BatchMessageTipsHeader header, List<String> personList) throws BOSException {
        String oql = "select id, name, number where id in (" + CmpStrUtil.convertListToString(personList) + ")";
        PersonCollection persons = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oql);
        for (int i = 0; i < persons.size(); ++i) {
            header.addResult(this.createErrorInfo(persons.get(i), "\u5f15\u5165\u6210\u529f", true));
        }
        header.setSuccessCount(personList.size());
    }

    protected void doGenerating(Context ctx, List<String> personList, String taxUnitId, Date periodBegin) throws BOSException, SQLException {
        if (personList.isEmpty()) {
            return;
        }
        StringBuilder insertSQL = new StringBuilder();
        insertSQL.append("insert into t_hr_sTaxCalInitDetail (fid, fCmpCalTableId, fState, fDataState, fPersonId, fTaxUnitId, fPeriodBegin, fPeriodEnd, fCreatorId, fCreateTime, fLastUpdateUserId, fLastUpdateTime, fIncomeItemId, fIsZeroIncome, FDifference");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fieldSn from t_hr_sTaxItem where fDataType = 0");
        int columnSize = rs.size();
        while (rs.next()) {
            insertSQL.append(", ").append("T").append(rs.getString("fieldSn"));
        }
        insertSQL.append(")").append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        for (int i = 0; i < columnSize; ++i) {
            insertSQL.append(",?");
        }
        insertSQL.append(")");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        TaxCalInitDetailInfo initDetailInfo = new TaxCalInitDetailInfo();
        CmpCalTableInfo calTableInfo = new CmpCalTableInfo();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        for (String personId : personList) {
            Object[] param = new Object[15 + columnSize];
            param[0] = BOSUuid.create((BOSObjectType)initDetailInfo.getBOSType()).toString();
            param[1] = BOSUuid.create((BOSObjectType)calTableInfo.getBOSType()).toString();
            param[2] = 10;
            param[3] = 10;
            param[4] = personId;
            param[5] = taxUnitId;
            param[6] = CmpDateUtil.toSqlDate(periodBegin);
            param[7] = CmpDateUtil.toSqlDate(CmpDateUtil.getEndOfMonth(periodBegin));
            param[8] = userId;
            param[9] = createTime;
            param[10] = userId;
            param[11] = createTime;
            param[12] = "8r0AAABCg2PDiOoP";
            param[13] = 1;
            param[14] = 10;
            for (int j = 15; j < param.length; ++j) {
                param[j] = 0;
            }
            params.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSQL.toString(), params);
    }

    protected void beforeGenerating(Context ctx, BatchMessageTipsHeader header, List<String> personList, String taxUnitId, Date periodBegin, String personIds) throws BOSException {
        String oql = "select state, isZeroIncome, person.id, person.name, person.number where person.id in " + CmpStrUtil.buildInSql(personIds) + " and taxUnit.id = '" + taxUnitId + "' and periodBegin = " + CmpDateUtil.toKSqlDate(periodBegin) + " and incomeItem.incomeCode = '0101'";
        DataBaseCollection collection = TaxCalInitDetailFactory.getLocalInstance(ctx).getDataBaseCollection(oql);
        HashSet<BOSUuid> persons = new HashSet<BOSUuid>();
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                String errorInfo;
                TaxCalInitDetailInfo initDetail = (TaxCalInitDetailInfo)collection.get(i);
                personList.remove(initDetail.getPerson().getId().toString());
                if (persons.contains(initDetail.getPerson().getId())) continue;
                persons.add(initDetail.getPerson().getId());
                if (!initDetail.isIsZeroIncome()) {
                    errorInfo = "\u5f15\u5165\u5931\u8d25\uff0c\u8be5\u5458\u5de5\u5df2\u901a\u8fc7\u6838\u7b97\u5411\u5bfc\u63d0\u4ea4\u521d\u7b97\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u96f6\u5de5\u8d44\uff0c\u82e5\u9700\u63d0\u4ea4\u96f6\u5de5\u8d44\uff0c\u8bf7\u8fdb\u5165\u85aa\u916c\u6838\u7b97\u5411\u5bfc\u5220\u9664\u6838\u7b97\u5458\u5de5";
                    header.addResult(this.createErrorInfo(initDetail.getPerson(), errorInfo, false));
                    continue;
                }
                errorInfo = "\u5f15\u5165\u5931\u8d25\uff0c\u8be5\u5458\u5de5\u5df2\u63d0\u4ea4\u96f6\u5de5\u8d44\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4";
                header.addResult(this.createErrorInfo(initDetail.getPerson(), errorInfo, false));
            }
        }
        header.setFailureCount(persons.size());
    }

    private BatchMessageTipsBody createErrorInfo(PersonInfo person, String errorInfo, boolean state) {
        String personId = person.getId().toString();
        BatchMessageTipsBody body = new BatchMessageTipsBody();
        ArrayList<String> list = new ArrayList<String>();
        body.setMuitTipsMessage(errorInfo);
        body.setMuitTipsState(state);
        body.setId(personId);
        list.add(person.getName());
        list.add(person.getNumber());
        list.add("\u6b63\u5e38\u5de5\u8d44\u85aa\u91d1");
        body.addMessageListExt(list);
        return body;
    }

    private void sendDeclareMsg2Handler(Context ctx, String taskId) {
        String title = "\u4e2a\u7a0e\u7ed3\u679c\u6570\u636e\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u5e76\u786e\u8ba4\uff0c\u5efa\u8bae\u91cd\u65b0\u8fdb\u884c\u4e2a\u7a0e\u7533\u62a5";
        String msgTemplate = "\u4e2a\u7a0e\u7533\u62a5\u3010{0}\u3011\u3010{1}\u3011\u3010{2}\u3011\u4e2d\u5458\u5de5\u3010{3}\u3011\u521d\u7b97\u6570\u636e\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u4e2a\u7a0e\u7533\u62a5\u3002";
        String category = "\u85aa\u916c\u4e2a\u7a0e";
        StringBuilder str = new StringBuilder();
        str.append("select distinct sendUser.fid sendUserId, unit.fname_l2 taxUnitName, declar.fyearmonth, declar.ftbtype, person.fname_l2 personName ");
        str.append("from T_HR_STaxCalTaskDetail detail ");
        str.append("inner join T_PM_USER sendUser ON  sendUser.FID = detail.FLASTUPDATEUSERID ");
        str.append("inner join T_HR_TAXUNIT unit on unit.fid = detail.ftaxunitid ");
        str.append("inner join T_HR_STaxCalConfigDetail config on config.FCmpCalTableID = detail.FCmpCalTableID and config.fIncomeItemId = detail.fIncomeItemId ");
        str.append("inner join T_HR_SIncomeTaxDeclar declar on declar.FBATCHNO  = config.FBatchNo ");
        str.append("inner join t_bd_person person on person.fid = detail.fpersonid ");
        str.append("where detail.fCalTaskID = '").append(taskId).append("'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            String sendUserID = "";
            String taxUnitName = "";
            String yearMonth = "";
            String tbType = "";
            HashSet<String> personSet = new HashSet<String>();
            MessageUtil.setNeedSending(ctx);
            while (rowSet.next()) {
                if (CmpStrUtil.isEmpty(sendUserID)) {
                    sendUserID = rowSet.getString("sendUserId");
                }
                if (CmpStrUtil.isEmpty(taxUnitName)) {
                    taxUnitName = rowSet.getString("taxUnitName");
                }
                if (CmpStrUtil.isEmpty(yearMonth)) {
                    yearMonth = rowSet.getString("fyearmonth");
                }
                if (CmpStrUtil.isEmpty(tbType) && !CmpStrUtil.isEmpty(rowSet.getString("ftbtype"))) {
                    tbType = TbTypeEnum.getEnum(rowSet.getString("ftbtype")).getAlias();
                }
                personSet.add(rowSet.getString("personName"));
            }
            MessageUtil.sendMessage(ctx, sendUserID, title, MessageFormat.format(msgTemplate, taxUnitName, yearMonth, tbType, ((Object)personSet).toString().replace("[", "").replace("]", "").replace(",", "\u3001")), category);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _afterTaxCalDelete(Context ctx, String taskId, TaxCalDelTypeEnum oprType) throws BOSException {
        String strSql = "update T_HR_STaxCalConfigDetail set FIsLast = 1 where FCmpCalTableId in (select d.FRelayID from T_HR_STAxCalTaskDetail d, T_HR_sTaxCalTaskDetail r  where d.fCmpCalTableId = r.fCmpCalTableId and d.fIncomeItemId = r.fIncomeItemId and r.fCalTaskId = '" + taskId + "')";
        DbUtil.execute((Context)ctx, (String)strSql);
        strSql = "DELETE FROM T_HR_STaxCalInitDetail where fid in (select d.fid from T_HR_STaxCalInitDetail d, T_HR_sTaxCalTaskDetail r  where d.fCmpCalTableId = r.fCmpCalTableId and d.fIncomeItemId = r.fIncomeItemId and r.fCalTaskId = '" + taskId + "')";
        DbUtil.execute((Context)ctx, (String)strSql);
        strSql = "DELETE FROM T_HR_STaxCalConfigDetail where fid in (select d.fid from T_HR_STaxCalConfigDetail d, T_HR_sTaxCalTaskDetail r  where d.fCmpCalTableId = r.fCmpCalTableId and d.fIncomeItemId = r.fIncomeItemId and r.fCalTaskId = '" + taskId + "')";
        DbUtil.execute((Context)ctx, (String)strSql);
        String taxUnitId = "";
        String yearMonth = "";
        String creatorId = "";
        try {
            strSql = "select fTaxUnitId, fPeriod, fCreatorId FROM T_HR_STaxCalTask where fid = '" + taskId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql);
            while (rs.next()) {
                taxUnitId = rs.getString("fTaxUnitId");
                yearMonth = rs.getString("fPeriod");
                creatorId = rs.getString("fCreatorId");
            }
            java.util.Date periodDate = CmpDateUtil.parseDate(yearMonth + "-01");
            ReductionSummaryFacadeFactory.getLocalInstance(ctx).save(taxUnitId, periodDate, creatorId);
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u51cf\u514d\u4e8b\u9879\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (TaxCalDelTypeEnum.DEL_UPDATE == oprType) {
            HashMap<String, String> declareMap = new HashMap<String, String>();
            declareMap.put("taxUnitIds", taxUnitId);
            declareMap.put("yearMonth", yearMonth);
            try {
                IncomeTaxDeclareFacadeFactory.getLocalInstance(ctx).generateTaxDeclareData(declareMap);
            }
            catch (EASBizException e) {
                logger.error((Object)"\u66f4\u65b0\u4e2a\u7a0e\u7533\u62a5\u8868\u7684\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            }
            this.sendDeclareMsg2Handler(ctx, taskId);
        } else {
            this.updateCmpCalTableStatus(ctx, taskId);
            TaxCalService service = new TaxCalService();
            TaxCalTaskInfo taskInfo = TaxCalTaskFactory.getLocalInstance(ctx).getTaskById(taskId);
            service.sendMsg2TaskCreator(ctx, taskInfo);
        }
    }

    protected void updateCmpCalTableStatus(Context ctx, String taskId) throws BOSException {
        String inSQL = "select d.fCmpCalTableId from T_HR_sTaxCalTaskDetail d where d.fCalTaskId = '" + taskId + "' and not exists (select 1 from T_HR_STaxCalInitDetail t where t.fCmpCalTableId = d.fCmpCalTableId)";
        String updateSQL = "update t_hr_sCmpCalTable set fCalTaxDataState = 0 where fid in (" + inSQL + ")";
        DbUtil.execute((Context)ctx, (String)updateSQL);
    }

    @Override
    protected void _updateInitAndDeleteConfig(Context ctx, String taskId) throws BOSException {
        String rangeSQL = "SELECT init.fid FROM t_hr_sTaxCalInitDetail init, t_hr_sTaxCalTaskDetail detail  where init.fTaxUnitId = detail.fTaxUnitId and init.fPersonId = detail.fPersonId and init.fIncomeItemId = detail.fIncomeItemId and init.fPeriodBegin = detail.fPeriodBegin and init.fCmpCalTableId != detail.fCmpCalTableId and detail.FCalTaskID = '" + taskId + "' and init.fIncomeItemId in (" + CmpStrUtil.convertListToString(CmpTaxUtil.accIncomeItems) + ")";
        String updateSQL = "update t_hr_sTaxCalInitDetail set fState = 10 where fid in (" + rangeSQL + ") and fState = " + 40;
        DbUtil.execute((Context)ctx, (String)updateSQL);
        rangeSQL = "SELECT config.fid FROM t_hr_sTaxCalConfigDetail config, t_hr_sTaxCalTaskDetail detail  where config.fTaxUnitId = detail.fTaxUnitId and config.fPersonId = detail.fPersonId and config.fIncomeItemId = detail.fIncomeItemId and config.fPeriodBegin = detail.fPeriodBegin and detail.FCalTaskID = '" + taskId + "' and config.fIncomeItemId in (" + CmpStrUtil.convertListToString(CmpTaxUtil.accIncomeItems) + ")";
        String deleteSQL = "delete from t_hr_sTaxCalConfigDetail where fid in (" + rangeSQL + ")";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
    }

    @Override
    protected void _afterRecalcDelete(Context ctx, String taskId) throws BOSException {
        String strSql = "DELETE FROM T_HR_STaxCalConfigDetail where fid in (select d.fid from T_HR_STaxCalConfigDetail d, T_HR_sTaxCalTaskDetail r  where d.fCmpCalTableId = r.fCmpCalTableId and d.fIncomeItemId = r.fIncomeItemId and r.fCalTaskId = '" + taskId + "')";
        DbUtil.execute((Context)ctx, (String)strSql);
    }
}

