/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.threadpool;

import com.kingdee.bos.util.backport.concurrent.BlockingQueue;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutorService;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.bos.util.backport.concurrent.LinkedBlockingQueue;
import com.kingdee.bos.util.backport.concurrent.RejectedExecutionException;
import com.kingdee.bos.util.backport.concurrent.RejectedExecutionHandler;
import com.kingdee.bos.util.backport.concurrent.ThreadFactory;
import com.kingdee.bos.util.backport.concurrent.ThreadPoolExecutor;
import com.kingdee.bos.util.backport.concurrent.TimeUnit;
import com.kingdee.bos.util.backport.concurrent.atomic.AtomicInteger;

public class CalCalculateThreadPool {
    private static final Integer MAX_BLOCKING_QUEUE_SIZE = 1000;
    private static BlockingQueue blockingQueue = new LinkedBlockingQueue(MAX_BLOCKING_QUEUE_SIZE.intValue());
    private static ExecutorService threadPool = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, blockingQueue, (ThreadFactory)new CalCalculateThreadFactory());

    private CalCalculateThreadPool() {
    }

    public static void execute(Runnable runner) {
        threadPool.execute(runner);
    }

    public static Future submit(Callable callable) {
        return threadPool.submit(callable);
    }

    public static Integer getBlockingQueueCount() {
        return blockingQueue.size();
    }

    static class CustomRejectPolicy
    implements RejectedExecutionHandler {
        CustomRejectPolicy() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            throw new RejectedExecutionException();
        }
    }

    static class CalCalculateThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        CalCalculateThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-cmp_calculate-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

