/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.scheme;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.SscTypeEnum;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitSchemeBillDataSource;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.SubBillSource;
import com.kingdee.shr.compensation.app.timepiece.TimepieceException;
import com.kingdee.shr.compensation.app.timepiece.scheme.AbstractTimepieceSchemeFacadeControllerBean;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.AccValType;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.DimensionType;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDataSourceCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDataSourceInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDimensionCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDimensionInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigEntryCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigEntryInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigFactory;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpPopulateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.formula.CalculatorManager2;
import com.kingdee.shr.validaterule.formula.ConcurrentCalculatorProxy2;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.base.vo.ErrRow;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.util.EntityUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TimepieceSchemeFacadeControllerBean
extends AbstractTimepieceSchemeFacadeControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeFacadeControllerBean");
    private static final String SUM_BILL_ENTRY_TABLE = "T_HR_TimepieceSumBillEntry";
    private static final String DAILY_SUM_ID_MAPPING_TABLE = "T_HR_SDailySumIdMapping";

    @Override
    protected Map _genSumItemData(Context ctx, Map param) throws BOSException, EASBizException {
        TimepieceSchemeInfo timepieceSchemeInfo = (TimepieceSchemeInfo)param.get("timepieceSchemeInfo");
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String timepieceSchemeId = timepieceSchemeInfo.getId().toString();
        DailySumDataGenParam dailySumDataGenParam = this.querySumItemConfig(ctx, timepieceSchemeId);
        dailySumDataGenParam.buildOtherParam(timepieceSchemeInfo, startDate, endDate);
        List dailySalaryData = this.queryGroupDailySalaryData(ctx, dailySumDataGenParam);
        if (dailySalaryData == null || dailySalaryData.isEmpty()) {
            throw new TimepieceException(TimepieceException.EXCEPTION9);
        }
        Map<String, List<String>> dailyPerGroupData = this.queryDailySalaryData(ctx, dailySumDataGenParam);
        BatchSubmitShemeBillInfo billInfo = this.generateSubmitBillData(ctx, dailySumDataGenParam);
        CoreBaseCollection dynamicEntityCol = this.generateSubmitEntryData(ctx, dailySalaryData, dailySumDataGenParam, billInfo, dailyPerGroupData);
        this.saveSumItemData(ctx, dailySumDataGenParam, billInfo, dynamicEntityCol);
        return null;
    }

    protected DailySumDataGenParam querySumItemConfig(Context ctx, String timepieceSchemeId) throws BOSException {
        String oql = "select id, index, sumDataSource.timepieceScheme.id, sumDataSource.timepieceScheme.submitScheme.id, sumDimension.dimensionType, sumDimension.dimensionId, entry.sumItem.fieldSn, entry.accSubmitItemVal.fieldSn, entry.accValType where timepieceScheme.id = '" + timepieceSchemeId + "'";
        SumItemConfigCollection sumItemConfigCollection = SumItemConfigFactory.getLocalInstance(ctx).getSumItemConfigCollection(oql);
        DailySumDataGenParam dailySumDataGenParam = new DailySumDataGenParam();
        SumItemConfigInfo sumItemConfigInfo = sumItemConfigCollection.get(0);
        String sumItemConfigId = sumItemConfigInfo.getId().toString();
        dailySumDataGenParam.buildSumItemConfigId(sumItemConfigId);
        ArrayList sumDataSourceList = Lists.newArrayList();
        SumDataSourceCollection sumDataSourceCollection = sumItemConfigInfo.getSumDataSource();
        for (int j = 0; j < sumDataSourceCollection.size(); ++j) {
            SumDataSourceInfo sumDataSourceInfo = sumDataSourceCollection.get(j);
            String sumDataSourceId = sumDataSourceInfo.getTimepieceScheme().getSubmitScheme().getId().toString();
            sumDataSourceList.add(sumDataSourceId);
        }
        dailySumDataGenParam.buildSumDataSource(sumDataSourceList);
        SumDimensionCollection sumDimensionCollection = sumItemConfigInfo.getSumDimension();
        this.queryDimensionColumn(ctx, sumDimensionCollection, dailySumDataGenParam);
        SumItemConfigEntryCollection entry = sumItemConfigInfo.getEntry();
        LinkedHashMap itemMappingMap = Maps.newLinkedHashMap();
        for (int z = 0; z < entry.size(); ++z) {
            SumItemConfigEntryInfo sumItemConfigEntryInfo = entry.get(z);
            String accSubFieldSn = "S" + sumItemConfigEntryInfo.getAccSubmitItemVal().getFieldSn();
            String subFieldSn = "S" + sumItemConfigEntryInfo.getSumItem().getFieldSn();
            int accValType = sumItemConfigEntryInfo.getAccValType().getValue();
            String sumKey = accSubFieldSn + "_" + accValType;
            itemMappingMap.putIfAbsent(sumKey, Lists.newArrayList());
            ((List)itemMappingMap.get(sumKey)).add(subFieldSn);
        }
        dailySumDataGenParam.buildItemMapping(itemMappingMap);
        return dailySumDataGenParam;
    }

    protected void queryDimensionColumn(Context ctx, SumDimensionCollection sumDimensionCollection, DailySumDataGenParam dailySumDataGenParam) throws BOSException {
        ArrayList structList = Lists.newArrayList();
        ArrayList itemList = Lists.newArrayList();
        for (int i = 0; i < sumDimensionCollection.size(); ++i) {
            SumDimensionInfo sumDimensionInfo = sumDimensionCollection.get(i);
            if (DimensionType.STRUCT == sumDimensionInfo.getDimensionType()) {
                structList.add(sumDimensionInfo.getDimensionId());
                continue;
            }
            itemList.add(sumDimensionInfo.getDimensionId());
        }
        ArrayList groupByColumn = Lists.newArrayList();
        ArrayList dimensionItemColumn = Lists.newArrayList();
        try {
            CmpInSql factory = CmpInSqlFactory.getInstance();
            String queryStructSql = "SELECT sc.FNUMBER, s.FClientNumber FROM T_HR_QueryConfigField qc left join T_HR_StructureConfigColumns sc on qc.FFactFieldID = sc.fid left join T_HR_StructureConfig s on sc.FStructureConfigID = s.fid where qc.fid in " + factory.createInSqlBaseOnFId(ctx, structList);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryStructSql);
            while (rs.next()) {
                groupByColumn.add(rs.getString("FClientNumber") + "." + rs.getString("FNUMBER"));
            }
            String queryItemSql = "select FieldSn from T_HR_SCalSubmitItem where fid in " + factory.createInSqlBaseOnFId(ctx, itemList);
            rs = DbUtil.executeQuery((Context)ctx, (String)queryItemSql);
            while (rs.next()) {
                dimensionItemColumn.add("CMP_SMT002.S" + rs.getString("FieldSn"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        dailySumDataGenParam.buildSumDimension(groupByColumn, dimensionItemColumn);
    }

    protected List queryGroupDailySalaryData(Context ctx, DailySumDataGenParam dailySumDataGenParam) throws BOSException, EASBizException {
        String dynamicSql = this.genDynamicGroupSqlByConfig(ctx, dailySumDataGenParam);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, dynamicSql);
        try {
            CmpPopulateUtil util = new CmpPopulateUtil();
            return util.pupolate(ctx, "012", dynamicSql, rowSet);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map<String, List<String>> queryDailySalaryData(Context ctx, DailySumDataGenParam dailySumDataGenParam) throws BOSException, EASBizException {
        String dynamicSql = this.genDynamicSqlByConfig(ctx, dailySumDataGenParam, false, true);
        dynamicSql = dynamicSql.replace("T_HR_SCHEMEBILLENTRY", "T_HR_TimepieceBillEntry");
        dynamicSql = dynamicSql + "order by \"PERSON\".fid";
        logger.info((Object)("33333333333dynamicSql:" + dynamicSql));
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, dynamicSql);
        HashMap detailDailyDataMap = Maps.newHashMap();
        try {
            CmpPopulateUtil util = new CmpPopulateUtil();
            List dailyList = util.pupolate(ctx, "012", dynamicSql, rowSet);
            for (Object data : dailyList) {
                Map dataMap = (Map)data;
                String groupByKey = this.buildGroupByKey(dailySumDataGenParam, dataMap);
                String id = (String)dataMap.get("id");
                detailDailyDataMap.putIfAbsent(groupByKey, Lists.newArrayList());
                List personDetailList = (List)detailDailyDataMap.get(groupByKey);
                personDetailList.add(id);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return detailDailyDataMap;
    }

    protected String buildGroupByKey(DailySumDataGenParam dailySumDataGenParam, Map<String, Object> dataMap) {
        List groupByColumn = dailySumDataGenParam.groupByColumn;
        List dimensionItemColumn = dailySumDataGenParam.dimensionItemColumn;
        String personId = (String)dataMap.get("person.id");
        StringBuilder groupByKey = new StringBuilder(personId);
        for (String col : groupByColumn) {
            String key = dataMap.get(col.toLowerCase()) == null ? null : this.getDataValue(dataMap.get(col.toLowerCase()));
            groupByKey.append(key).append("_");
        }
        for (String col : dimensionItemColumn) {
            String fieldSn = "d" + col.split("\\.")[1].toLowerCase();
            String key = dataMap.get(fieldSn) == null ? null : this.getDataValue(dataMap.get(fieldSn));
            groupByKey.append(key).append("_");
        }
        return groupByKey.toString();
    }

    protected String getDataValue(Object data) {
        if (data instanceof Boolean) {
            return (Boolean)data != false ? "true" : "false";
        }
        if (data instanceof Date) {
            return CmpDateUtil.getDateStr((Date)data);
        }
        return data.toString();
    }

    protected String genDynamicSqlByConfig(Context ctx, DailySumDataGenParam dailySumDataGenParam, boolean needGroupBy, boolean needSelectPk) throws BOSException, EASBizException {
        List sumDataSourceList = dailySumDataGenParam.sumDataSourceList;
        List dimensionItemColumn = dailySumDataGenParam.dimensionItemColumn;
        Map<String, String> selectMapping = this.getDynamicSelector(dailySumDataGenParam);
        if (needSelectPk) {
            selectMapping.put("CMP_SMT002.id", "id");
            for (String key : dimensionItemColumn) {
                String fieldSn = "D" + key.split("\\.")[1];
                selectMapping.put(key, fieldSn);
            }
        }
        FilterInfo customFilter = new FilterInfo();
        customFilter.getFilterItems().add(new FilterItemInfo("CMP_SMT002.effectDate", (Object)dailySumDataGenParam.startDate, CompareType.GREATER_EQUALS));
        customFilter.getFilterItems().add(new FilterItemInfo("CMP_SMT002.leffectDate", (Object)dailySumDataGenParam.endDate, CompareType.LESS_EQUALS));
        customFilter.getFilterItems().add(new FilterItemInfo("CMP_submitscheme.id", (Object)Sets.newHashSet((Iterable)sumDataSourceList), CompareType.INCLUDE));
        customFilter.getFilterItems().add(new FilterItemInfo("CMP_SMT002.entrycalstatus", (Object)"1", CompareType.EQUALS));
        customFilter.getFilterItems().add(new FilterItemInfo("CMP_SMT002.billState", (Object)3, CompareType.EQUALS));
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setScheme("012");
        sqlParam.setHistoryMode(false);
        sqlParam.setNeedGropBy(needGroupBy);
        sqlParam.setFilterInfo(customFilter);
        return FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
    }

    protected String genDynamicGroupSqlByConfig(Context ctx, DailySumDataGenParam dailySumDataGenParam) throws BOSException, EASBizException {
        String originalSql = this.genDynamicSqlByConfig(ctx, dailySumDataGenParam, true, false);
        return this.rebuildDynamicSql(originalSql, dailySumDataGenParam);
    }

    protected Map<String, String> getDynamicSelector(DailySumDataGenParam dailySumDataGenParam) {
        List groupByColumn = dailySumDataGenParam.groupByColumn;
        HashMap<String, String> selectMapping = new HashMap<String, String>(this.getDefaultSelector());
        groupByColumn.forEach(col -> selectMapping.put((String)col, (String)col));
        return selectMapping;
    }

    protected Map<String, String> getDefaultSelector() {
        HashMap defaultSelector = Maps.newHashMap();
        defaultSelector.put("PERSON.id", "PERSON.id");
        return defaultSelector;
    }

    protected String rebuildDynamicSql(String originalSql, DailySumDataGenParam dailySumDataGenParam) {
        Map itemMappingMap = dailySumDataGenParam.itemMappingMap;
        logger.info((Object)("1111111111111originalSql:" + originalSql));
        StringBuilder selectSql = new StringBuilder(originalSql.substring(0, originalSql.indexOf("COUNT")));
        for (Object key : itemMappingMap.keySet()) {
            String[] keyArr = ((String)key).split("_");
            String itemCol = keyArr[0];
            int accType = Integer.parseInt(keyArr[1]);
            if (AccValType.getEnum(accType) == AccValType.GET_SUM) {
                selectSql.append("SUM(\"CMP_SMT002\".").append(itemCol).append(") as ").append(itemCol).append("_").append(20).append(", ");
                continue;
            }
            if (AccValType.getEnum(accType) == AccValType.GET_MAX) {
                selectSql.append("MAX(\"CMP_SMT002\".").append(itemCol).append(") as ").append(itemCol).append("_").append(30).append(", ");
                continue;
            }
            if (AccValType.getEnum(accType) == AccValType.GET_MIN) {
                selectSql.append("MIN(\"CMP_SMT002\".").append(itemCol).append(") as ").append(itemCol).append("_").append(40).append(", ");
                continue;
            }
            if (AccValType.getEnum(accType) != AccValType.GET_AVG) continue;
            selectSql.append("AVG(\"CMP_SMT002\".").append(itemCol).append(") as ").append(itemCol).append("_").append(10).append(", ");
        }
        List dimensionItemColumn = dailySumDataGenParam.dimensionItemColumn;
        for (Object key : dimensionItemColumn) {
            String fieldSn = ((String)key).split("\\.")[1];
            selectSql.append("\"CMP_SMT002\".").append(fieldSn).append(" as ").append("D").append(fieldSn).append(", ");
        }
        selectSql.append("MAX(\"CMP_SMT002\".").append("fleffectDate) as leffectDate");
        StringBuilder fromSql = new StringBuilder(originalSql.substring(originalSql.indexOf(" FROM ")));
        for (String key : dimensionItemColumn) {
            fromSql.append(", ").append(key);
        }
        String rebuildSql = selectSql.append((CharSequence)fromSql).append(" order by \"PERSON.id\"").toString();
        rebuildSql = rebuildSql.replace("T_HR_SCHEMEBILLENTRY", "T_HR_TimepieceBillEntry");
        logger.info((Object)("22222222222222rebuildDynamicSql:" + rebuildSql));
        return rebuildSql;
    }

    protected void saveSumItemData(Context ctx, DailySumDataGenParam dailySumDataGenParam, BatchSubmitShemeBillInfo billIdInfo, CoreBaseCollection dynamicEntityCol) throws BOSException, EASBizException {
        String dynamicEntityName = this.queryDynamicEntityName(ctx, dailySumDataGenParam.timepieceSchemeInfo.getId().toString());
        Map<String, String> structureMap = this.getDimensionStructureConfigAttr(ctx, dailySumDataGenParam.sumItemConfigId);
        Map<String, Map<String, String>> groupByCmpColumValueMap = this.queryDailySumEntryRelData(ctx, structureMap, billIdInfo.getId().toString());
        for (int i = 0; i < dynamicEntityCol.size(); ++i) {
            CoreBaseInfo coreBaseInfo = dynamicEntityCol.get(i);
            CmpEmpORelationInfo cmpEmpORelationInfo = (CmpEmpORelationInfo)coreBaseInfo.get("cmpEmpORel");
            String cmpEmpORelId = cmpEmpORelationInfo.getId().toString();
            Map<String, String> colValueMap = groupByCmpColumValueMap.get(cmpEmpORelId);
            if (colValueMap == null) continue;
            for (Map.Entry<String, String> entry : structureMap.entrySet()) {
                String clientNumber = entry.getKey();
                String id = colValueMap.get(clientNumber);
                if (StringUtils.isEmpty((CharSequence)id)) continue;
                String[] arr = entry.getValue().split("_");
                String entityName = arr[0];
                String metaIndex = "D" + arr[1];
                CoreBaseInfo blankCoreObject = EntityUtil.createBlankCoreObject((Context)ctx, (String)entityName);
                blankCoreObject.setId(BOSUuid.read((String)id));
                coreBaseInfo.put(metaIndex, (Object)blankCoreObject);
            }
            BatchSubmitShemeBillEntryInfo entry = new BatchSubmitShemeBillEntryInfo();
            entry.setId(BOSUuid.read((String)colValueMap.get("entryId")));
            coreBaseInfo.put("relBill", (Object)entry);
        }
        ICoreBase bizInterface = MetaDataUtil.getBizInterface((Context)ctx, (String)("com.kingdee.shr.compensation.app." + dynamicEntityName));
        bizInterface.save(dynamicEntityCol);
    }

    protected BatchSubmitShemeBillInfo generateSubmitBillData(Context ctx, DailySumDataGenParam dailySumDataGenParam) throws BOSException, EASBizException {
        String submitSchemeId = dailySumDataGenParam.timepieceSchemeInfo.getSubmitScheme().getId().toString();
        BatchSubmitShemeBillCollection billCollection = this.querySubmitBill(ctx, dailySumDataGenParam);
        BatchSubmitShemeBillInfo billInfo = billCollection.get(0);
        if (billInfo == null) {
            billInfo = new BatchSubmitShemeBillInfo();
            CalSubmitSchemeInfo calSubmitSchemeInfo = new CalSubmitSchemeInfo();
            calSubmitSchemeInfo.setId(BOSUuid.read((String)submitSchemeId));
            billInfo.setSubmitScheme(calSubmitSchemeInfo);
            billInfo.setApplyDate(CmpDateUtil.toSqlDate(new Date()));
            PersonInfo proposer = new PersonInfo();
            proposer.setId(BOSUuid.read((String)HRFilterUtils.getCurrentPersonId((Context)ctx)));
            billInfo.setProposer(proposer);
            billInfo.setDatasource(BatchSubmitSchemeBillDataSource.TIMEPIECE_SUBMIT);
            billInfo.setBillSource(SubBillSource.Inner_Data);
            AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
            adminOrg.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            billInfo.setAdminOrg(adminOrg);
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            hrOrgUnitInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            billInfo.setHrOrgUnit(hrOrgUnitInfo);
            billInfo.setNumber("SHR_SUB_" + System.currentTimeMillis());
            billInfo.setDescription(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TimepieceResource", (String)"label39", (Locale)ctx.getLocale()));
            billInfo.setIsSsc(SscTypeEnum.NORMAL);
            billInfo.setBillState(HRBillStateEnum.AUDITED);
            billInfo.setBeginDate(CmpDateUtil.toSqlDate(dailySumDataGenParam.startDate));
            billInfo.setEndDate(CmpDateUtil.toSqlDate(dailySumDataGenParam.endDate));
            BatchSubmitShemeBillFactory.getLocalInstance(ctx).addnew(billInfo);
        }
        this.deleteHisSumItemConfigRelData(ctx, billInfo, dailySumDataGenParam);
        return billInfo;
    }

    protected BatchSubmitShemeBillCollection querySubmitBill(Context ctx, DailySumDataGenParam dailySumDataGenParam) throws BOSException {
        String submitSchemeId = dailySumDataGenParam.timepieceSchemeInfo.getSubmitScheme().getId().toString();
        String oql = "select id, hrOrgUnit.id where submitScheme.id = '" + submitSchemeId + "' and beginDate = {ts'" + dailySumDataGenParam.startDate + "'} and endDate = {ts'" + dailySumDataGenParam.endDate + "'}";
        return BatchSubmitShemeBillFactory.getLocalInstance(ctx).getBatchSubmitShemeBillCollection(oql);
    }

    protected void deleteHisSumItemConfigRelData(Context ctx, BatchSubmitShemeBillInfo billInfo, DailySumDataGenParam dailySumDataGenParam) throws BOSException, EASBizException {
        String deleteIdMappingSql = "delete from T_HR_SDailySumIdMapping t1 where exists (select 1 from T_HR_TimepieceSumBillEntry t2 where t2.FBillId = '" + billInfo.getId().toString() + "' and t1.FSumEntryId = t2.FId)";
        DbUtil.execute((Context)ctx, (String)deleteIdMappingSql);
        String deleteSql = "delete from T_HR_TimepieceSumBillEntry where FBillId = '" + billInfo.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        String dynamicEntityName = this.queryDynamicEntityName(ctx, dailySumDataGenParam.timepieceSchemeInfo.getId().toString());
        String timepieceSchemeId = dailySumDataGenParam.timepieceSchemeInfo.getId().toString();
        String oql = "where timeScheme.id = '" + timepieceSchemeId + "' and effectDate = {ts'" + dailySumDataGenParam.startDate + "'} and leffectDate = {ts'" + dailySumDataGenParam.endDate + "'}";
        ICoreBase bizInterface = MetaDataUtil.getBizInterface((Context)ctx, (String)("com.kingdee.shr.compensation.app." + dynamicEntityName));
        bizInterface.delete(oql);
    }

    protected CoreBaseCollection generateSubmitEntryData(Context ctx, List dailySalaryData, DailySumDataGenParam dailySumDataGenParam, BatchSubmitShemeBillInfo billInfo, Map<String, List<String>> dailyPerGroupData) throws BOSException, EASBizException {
        ArrayList entryParams = Lists.newArrayList();
        ArrayList sumIdMappingPram = Lists.newArrayList();
        String dynamicEntityName = this.queryDynamicEntityName(ctx, dailySumDataGenParam.timepieceSchemeInfo.getId().toString());
        Map<String, String> dynamicEntityColMap = this.querySumConfigDbName2FieldSN(ctx, dailySumDataGenParam);
        Map<String, String> permOrgMap = this.queryEntryOrgByUserPerm(ctx, dailySumDataGenParam);
        Map<String, List<DailyEmpORelInfo>> dailyEmpORelInfoMap = this.groupByDailyDataEmpORel(ctx, dailySalaryData, dailySumDataGenParam);
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        java.sql.Date createTime = CmpDateUtil.toSqlDate(new Date());
        CoreBaseCollection dynamicEntityColl = new CoreBaseCollection();
        for (Object data : dailySalaryData) {
            Map dataMap = (Map)data;
            String personId = (String)dataMap.get("person.id");
            Date leffectDate = (Date)dataMap.get("leffectdate");
            List<DailyEmpORelInfo> relInfos = dailyEmpORelInfoMap.get(personId);
            if (relInfos == null || relInfos.isEmpty()) {
                logger.error((Object)("person:" + personId + ", not found match cmpEmpORelation field"));
                continue;
            }
            DailyEmpORelInfo matchData = this.findEmpOrgMathData(relInfos, leffectDate);
            CoreBaseInfo dynamicEntityInfo = this.assembleDynamicEntityInfo(ctx, dailySumDataGenParam, matchData, dynamicEntityName, dynamicEntityColMap, dataMap);
            dynamicEntityColl.add(dynamicEntityInfo);
            List<Object> entryParam = this.assembleEntryFixColParam(billInfo, dailySumDataGenParam, matchData, personId, userId, createTime, permOrgMap);
            List<Object> dynamicEntryParam = this.assembleEntryDynamicColParam(dailySumDataGenParam, dataMap);
            entryParam.addAll(dynamicEntryParam);
            entryParams.add(entryParam.toArray());
            String groupByKey = this.buildGroupByKey(dailySumDataGenParam, dataMap);
            List<String> personDetailList = dailyPerGroupData.get(groupByKey);
            sumIdMappingPram.addAll(this.assembleIdMappingParam(personDetailList, (String)entryParam.get(14)));
        }
        DbUtil.executeBatch((Context)ctx, (String)this.getEntryInsertSQL(dailySumDataGenParam.itemMappingMap), (List)entryParams);
        DbUtil.executeBatch((Context)ctx, (String)this.getIdMappingInsertSQL(), (List)sumIdMappingPram);
        return dynamicEntityColl;
    }

    protected Map<String, String> queryEntryOrgByUserPerm(Context ctx, DailySumDataGenParam dailySumDataGenParam) throws BOSException {
        List sumDataSourceList = dailySumDataGenParam.sumDataSourceList;
        CmpInSql inSql = CmpInSqlFactory.getInstance();
        String sourceIds = inSql.createInSqlBaseOnFId(ctx, sumDataSourceList);
        String dynamicSql = "SELECT CMP_SMT002.FAdminOrgUnitID, CMP_SMT002.FHrOrgUnitID FROM T_HR_TimepieceBillEntry AS CMP_SMT002 LEFT JOIN T_HR_SBATCHSUBMITSHEMEBILL AS CMP_SMT001 ON CMP_SMT001.FID=CMP_SMT002.FBILLID LEFT JOIN  T_HR_SCALSUBMITSCHEME AS CMP_SUBMITSCHEME ON CMP_SUBMITSCHEME.FID=CMP_SMT001.FSUBMITSCHEMEID WHERE CMP_SMT002.FEffectDate>= {ts'" + dailySumDataGenParam.startDate + "'}  AND CMP_SMT002.FLeffectDate<= {ts'" + dailySumDataGenParam.endDate + "'}  AND CMP_SUBMITSCHEME.FID in " + sourceIds + " AND CMP_SMT002.fentrycalstatus= '1' AND CMP_SMT002.FBillState= 3";
        String tempTable = inSql.createTempTableName(ctx);
        DbUtil.execute((Context)ctx, (String)("select t.* into " + tempTable + " from (" + dynamicSql + ") t"));
        String permItemId = "75131728-ccd1-4e38-ac7c-cea0b2b6f772PERMITEM";
        String adminOrgUnitRangeSQL = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgUnitRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String maxAdminQuerySql = "select distinct FAdminOrgUnitID from " + tempTable + " where FAdminOrgUnitID in (" + adminOrgUnitRangeSQL + ")";
        String maxHrOrgQuerySql = "select distinct FHrOrgUnitID from " + tempTable + " where FHrOrgUnitID in (" + hrOrgUnitRangeSQL + ")";
        String adminOrgId = this.queryMaxOrg(ctx, "t_org_admin", maxAdminQuerySql, adminOrgUnitRangeSQL);
        String hrOrgId = this.queryMaxOrg(ctx, "t_org_hro", maxHrOrgQuerySql, hrOrgUnitRangeSQL);
        HashMap<String, String> entryMaxOrgMap = new HashMap<String, String>();
        entryMaxOrgMap.put("adminOrgId", adminOrgId);
        entryMaxOrgMap.put("hrOrgId", hrOrgId);
        inSql.release(ctx);
        return entryMaxOrgMap;
    }

    protected String queryMaxOrg(Context ctx, String tempTable, String condition, String permRangSql) throws BOSException {
        String tempQuerySql = "select fid from {0} where FLongNumber in (select min(FLongNumber) from {1} where fid in ({2}))";
        String sql = MessageFormat.format(tempQuerySql, tempTable, tempTable, condition);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String orgId = null;
        try {
            if (rs.next()) {
                orgId = rs.getString("fid");
            } else {
                sql = MessageFormat.format(tempQuerySql, tempTable, tempTable, permRangSql);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    orgId = rs.getString("fid");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return orgId;
    }

    protected List<Object[]> assembleIdMappingParam(List<String> personDetailList, String sumEntryId) {
        ArrayList sumIdMappingPram = Lists.newArrayList();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(1);
        for (String detailId : personDetailList) {
            sumIdMappingPram.add(new Object[]{sumEntryId, detailId, year});
        }
        return sumIdMappingPram;
    }

    protected String getIdMappingInsertSQL() {
        return "insert into T_HR_SDailySumIdMapping (FSumEntryId, FDailyEntryId, FYear) values (?, ?, ?)";
    }

    protected DailyEmpORelInfo findEmpOrgMathData(List<DailyEmpORelInfo> relInfos, Date leffectDate) {
        Optional<DailyEmpORelInfo> optional = relInfos.stream().filter(relInfo -> ((DailyEmpORelInfo)relInfo).effectDate.compareTo(leffectDate) <= 0 && ((DailyEmpORelInfo)relInfo).leffectDate.compareTo(leffectDate) >= 0).findFirst();
        return optional.orElse(relInfos.get(0));
    }

    protected List<Object> assembleEntryFixColParam(BatchSubmitShemeBillInfo billInfo, DailySumDataGenParam dailySumDataGenParam, DailyEmpORelInfo matchData, String personId, String userId, Date createTime, Map<String, String> permOrgMap) {
        String billId = billInfo.getId().toString();
        ArrayList entryParam = Lists.newArrayList();
        entryParam.add(billId);
        entryParam.add(dailySumDataGenParam.startDate);
        entryParam.add(personId);
        entryParam.add(userId);
        entryParam.add(createTime);
        entryParam.add(matchData.adminOrgId);
        entryParam.add(matchData.positionId);
        entryParam.add(matchData.cmpEmpORelationId);
        entryParam.add("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC");
        entryParam.add(dailySumDataGenParam.endDate);
        entryParam.add(permOrgMap.get("hrOrgId"));
        entryParam.add("02");
        entryParam.add(10);
        entryParam.add(3);
        entryParam.add(BOSUuid.create((String)"7F647776").toString());
        entryParam.add(1);
        entryParam.add("0");
        entryParam.add(1);
        return entryParam;
    }

    protected List<Object> assembleEntryDynamicColParam(DailySumDataGenParam dailySumDataGenParam, Map<String, Object> dataMap) {
        Map itemMappingMap = dailySumDataGenParam.itemMappingMap;
        ArrayList dynamicEntryParam = Lists.newArrayList();
        for (Map.Entry entry : itemMappingMap.entrySet()) {
            String key = (String)entry.getKey();
            Object itemColValue = dataMap.get(key.toLowerCase());
            List sumItemFieldSnList = (List)entry.getValue();
            for (int i = 0; i < sumItemFieldSnList.size(); ++i) {
                dynamicEntryParam.add(itemColValue);
            }
        }
        return dynamicEntryParam;
    }

    protected String getEntryInsertSQL(Map<String, List<String>> itemMappingMap) {
        ArrayList dynamicCol = Lists.newArrayList();
        for (Map.Entry<String, List<String>> entry : itemMappingMap.entrySet()) {
            dynamicCol.addAll((Collection)entry.getValue());
        }
        List<String> entryColumns = this.getEntryInsertColumns();
        entryColumns.addAll(dynamicCol);
        StringBuilder preparedStmt = new StringBuilder();
        for (int i = 0; i < entryColumns.size(); ++i) {
            if (i > 0) {
                preparedStmt.append(",");
            }
            preparedStmt.append("?");
        }
        return "insert into T_HR_TimepieceSumBillEntry(" + StringUtils.join((Object[])entryColumns.toArray(), (String)",") + " ) values (" + preparedStmt + ")";
    }

    protected List<String> getEntryInsertColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("FBillID");
        columns.add("FEffectDate");
        columns.add("FPersonID");
        columns.add("FCreatorID");
        columns.add("FCreateTime");
        columns.add("FAdminOrgUnitID");
        columns.add("FPositionID");
        columns.add("FCmpEmpORelationID");
        columns.add("FCurrencyID");
        columns.add("FLeffectDate");
        columns.add("FHrOrgUnitID");
        columns.add("FCalState");
        columns.add("FIsCal");
        columns.add("FBillState");
        columns.add("FID");
        columns.add("FDealStatus");
        columns.add("fentrycalstatus");
        columns.add("FUseDefault");
        return columns;
    }

    protected Map<String, List<DailyEmpORelInfo>> groupByDailyDataEmpORel(Context ctx, List dailySalaryData, DailySumDataGenParam dailySumDataGenParam) throws BOSException {
        ArrayList personList = Lists.newArrayList();
        for (Object data : dailySalaryData) {
            Map dataMap = (Map)data;
            personList.add((String)dataMap.get("person.id"));
        }
        HashMap dailyEmpORelInfoMap = Maps.newHashMap();
        CmpInSql inSql = CmpInSqlFactory.getInstance();
        String queryEmpOrgSql = "select en.FCmpEmpORelationID, en.FPersonID, en.FEffectDate, en.FLeffectDate, en.FAdminOrgUnitID, en.FPositionID from T_HR_TimepieceBillEntry en where en.FPersonID in " + inSql.createInSqlBaseOnFId(ctx, personList) + " and en.FLEffectDate <= {ts'" + dailySumDataGenParam.endDate + "'} and en.FEffectDate >= {ts'" + dailySumDataGenParam.startDate + "'}  order by en.FPersonID, en.FEffectDate";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryEmpOrgSql);
        try {
            while (rs.next()) {
                DailyEmpORelInfo dailyEmpORelInfo = new DailyEmpORelInfo();
                dailyEmpORelInfo.cmpEmpORelationId = rs.getString("FCmpEmpORelationID");
                dailyEmpORelInfo.personId = rs.getString("FPersonID");
                dailyEmpORelInfo.effectDate = rs.getDate("FEffectDate");
                dailyEmpORelInfo.leffectDate = rs.getDate("FLeffectDate");
                dailyEmpORelInfo.adminOrgId = rs.getString("FAdminOrgUnitID");
                dailyEmpORelInfo.positionId = rs.getString("FPositionID");
                dailyEmpORelInfoMap.putIfAbsent(dailyEmpORelInfo.personId, Lists.newArrayList());
                List relInfos = (List)dailyEmpORelInfoMap.get(dailyEmpORelInfo.personId);
                relInfos.add(dailyEmpORelInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dailyEmpORelInfoMap;
    }

    protected String queryDynamicEntityName(Context ctx, String configId) throws BOSException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select findex from T_HR_SExtDataMetaData where FConfigId = ?", (Object[])new Object[]{configId});
        int entityIndex = 0;
        try {
            while (rowSet.next()) {
                entityIndex = rowSet.getInt("findex");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return "CmpDyCreate" + String.format("%04d", entityIndex);
    }

    protected CoreBaseInfo assembleDynamicEntityInfo(Context ctx, DailySumDataGenParam dailySumDataGenParam, DailyEmpORelInfo matchData, String dynamicEntityName, Map<String, String> dynamicEntityColMap, Map<String, Object> dataMap) throws BOSException {
        DataBaseInfo blankCoreObject = (DataBaseInfo)EntityUtil.createBlankCoreObject((Context)ctx, (String)("com.kingdee.shr.compensation.app." + dynamicEntityName));
        blankCoreObject.put("timeScheme", (Object)dailySumDataGenParam.timepieceSchemeInfo);
        blankCoreObject.put("effectDate", (Object)CmpDateUtil.toSqlDate(dailySumDataGenParam.startDate));
        blankCoreObject.put("leffectDate", (Object)CmpDateUtil.toSqlDate(dailySumDataGenParam.endDate));
        HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
        hrOrgUnitInfo.setId(BOSUuid.read((String)"dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
        blankCoreObject.put("hrOrgUnit", (Object)hrOrgUnitInfo);
        CmpEmpORelationInfo cmpEmpORelationInfo = new CmpEmpORelationInfo();
        cmpEmpORelationInfo.setId(BOSUuid.read((String)matchData.cmpEmpORelationId));
        blankCoreObject.put("cmpEmpORel", (Object)cmpEmpORelationInfo);
        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
        adminOrgUnitInfo.setId(BOSUuid.read((String)matchData.adminOrgId));
        blankCoreObject.put("adminOrgUnit", (Object)adminOrgUnitInfo);
        PositionInfo positionInfo = new PositionInfo();
        positionInfo.setId(BOSUuid.read((String)matchData.positionId));
        blankCoreObject.put("position", (Object)positionInfo);
        UserInfo userInfo = new UserInfo();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        userInfo.setId(BOSUuid.read((String)HRFilterUtils.getCurrentUserId((Context)ctx)));
        blankCoreObject.setCreator(userInfo);
        blankCoreObject.setCreateTime(timestamp);
        blankCoreObject.setLastUpdateUser(userInfo);
        blankCoreObject.setLastUpdateTime(timestamp);
        dynamicEntityColMap.forEach((key, value) -> {
            Object o = key.startsWith("D") ? dataMap.get("d" + value.toLowerCase()) : dataMap.get(value.toLowerCase());
            if (o != null) {
                blankCoreObject.put(key, o);
            }
        });
        return blankCoreObject;
    }

    protected Map<String, String> querySumConfigDbName2FieldSN(Context ctx, DailySumDataGenParam dailySumDataGenParam) throws BOSException {
        String queryFieldSql = " SELECT entry.fdbname, si.FieldSn, null as FAccValTypeID  FROM T_HR_SumDimension entry  inner join T_HR_SCalSubmitItem si on entry.FDimensionID = si.FID  where entry.FSumItemConfig = ? and entry.fdbname is not null  union  select entry2.fdbname, si2.FieldSn, entry2.FAccValTypeID as FAccValTypeID  from T_HR_SumItemConfigEntry entry2  inner join T_HR_SCalSubmitItem si2 on entry2.FAccSubmitItemValID = si2.FID  where entry2.FSumItemConfigid = ? and entry2.fdbname is not null ";
        HashMap dynamicEntityColMap = Maps.newHashMap();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryFieldSql, (Object[])new Object[]{dailySumDataGenParam.sumItemConfigId, dailySumDataGenParam.sumItemConfigId});
            while (rowSet.next()) {
                String dbName = rowSet.getString("fdbname");
                String fieldSn = "S" + rowSet.getInt("FieldSn");
                int valType = rowSet.getInt("FAccValTypeID");
                if (dbName.startsWith("S") && valType > 0) {
                    fieldSn = fieldSn + "_" + valType;
                }
                dynamicEntityColMap.put(dbName, fieldSn);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return dynamicEntityColMap;
    }

    protected Map<String, Map<String, String>> queryDailySumEntryRelData(Context ctx, Map<String, String> structureMap, String billId) throws BOSException, EASBizException {
        HashMap selectMapping = Maps.newHashMap();
        structureMap.forEach((key, value) -> selectMapping.put(key + ".id", key + ".id"));
        selectMapping.put("cmpEmpOrela.id", "cmpEmpOrela.id");
        if (!selectMapping.containsKey("CMP_SMT002.id")) {
            selectMapping.put("CMP_SMT002.id", "CMP_SMT002.id");
        }
        FilterInfo customFilter = new FilterInfo();
        customFilter.getFilterItems().add(new FilterItemInfo("CMP_SMT001.id", (Object)billId, CompareType.INCLUDE));
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSelectMapping((Map)selectMapping);
        sqlParam.setScheme("012");
        sqlParam.setHistoryMode(true);
        sqlParam.setFilterInfo(customFilter);
        String dynamicSql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        dynamicSql = dynamicSql.replace("T_HR_SCHEMEBILLENTRY", SUM_BILL_ENTRY_TABLE);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, dynamicSql);
        HashMap groupByCmpColumValueMap = Maps.newHashMap();
        try {
            CmpPopulateUtil util = new CmpPopulateUtil();
            List submitEntryList = util.pupolate(ctx, "012", dynamicSql, rowSet);
            for (Object o : submitEntryList) {
                Map dataMap = (Map)o;
                String cmpEmpORelId = (String)dataMap.get("cmpemporela.id");
                groupByCmpColumValueMap.putIfAbsent(cmpEmpORelId, Maps.newHashMap());
                Map colValueMap = (Map)groupByCmpColumValueMap.get(cmpEmpORelId);
                colValueMap.put("entryId", (String)dataMap.get("cmp_smt002.id"));
                structureMap.forEach((key, value) -> {
                    String data = (String)dataMap.get(key.toLowerCase() + ".id");
                    colValueMap.put(key, data);
                });
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return groupByCmpColumValueMap;
    }

    protected Map<String, String> getDimensionStructureConfigAttr(Context ctx, String sumItemConfigId) throws BOSException {
        String queryFieldSql = " SELECT sc.FCLIENTNUMBER, sc.FENTITYNAME, med.FIndex  FROM T_HR_SumDimension entry  left join T_HR_SExtDataEntryMetaData med on entry.FID = med.FiledId  left join T_HR_QueryConfigField qcf on entry.FDimensionID = qcf.FID  left join T_HR_StructureConfigColumns scc on qcf.FFactFieldID = scc.FID  left join T_HR_StructureConfig sc on scc.FSTRUCTURECONFIGID = sc.FID  where entry.FSumItemConfig = ? and sc.FCLIENTNUMBER is not null";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryFieldSql, (Object[])new Object[]{sumItemConfigId});
        HashMap structureMap = Maps.newHashMap();
        try {
            while (rowSet.next()) {
                structureMap.put(rowSet.getString("FCLIENTNUMBER"), rowSet.getString("FENTITYNAME") + "_" + rowSet.getInt("FIndex"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return structureMap;
    }

    @Override
    protected Map _calculate(Context ctx, Map param) throws BOSException, EASBizException {
        String calSchemeID = (String)param.get("calSchemeID");
        String condition = (String)param.get("condition");
        String mainTable = (String)param.get("mainTable");
        String oql = " select id where isCal = 1 and businessRelationConfig.businessId = '" + calSchemeID + "'";
        BaseFormulaCollection formulaCollection = BaseFormulaFactory.getLocalInstance((Context)ctx).getBaseFormulaCollection(oql);
        if (formulaCollection.isEmpty()) {
            return Maps.newHashMap();
        }
        Date endDate = new Date();
        Locale originLocale = ctx.getLocale();
        CalSubmitSchemeInfo calSubmitScheme = CalSubmitSchemeFactory.getLocalInstance(ctx).getCalSubmitSchemeInfo((IObjectPK)new ObjectUuidPK(calSchemeID));
        if (calSubmitScheme.getLanType() != null) {
            ctx.setLocale(LocaleUtils.getLocale((String)calSubmitScheme.getLanType().getValue()));
        }
        this.post(ctx, mainTable, calSchemeID, null, condition, endDate);
        ctx.setLocale(originLocale);
        return null;
    }

    protected void post(Context ctx, String mainTable, String calSchemeID, BaseFormulaCollection formulaCollection, String condition, Date endDate) throws EASBizException, BOSException {
        try {
            ConcurrentCalculatorProxy2.Parameters param = ConcurrentCalculatorProxy2.createParamInstance();
            param.setCtx(ctx);
            param.setMainTableName(mainTable);
            param.setMainTableAlias("CMP_SMT002");
            param.setCalCategoryNum("CMP_SUB_002");
            param.setSchemeID(calSchemeID);
            param.setEndDate(endDate);
            param.setMainTableRowFilter(condition);
            ConcurrentCalculatorProxy2 calculator = new ConcurrentCalculatorProxy2(param, new SalaryCalculator2());
            calculator.run();
            String uid = calculator.getUID();
            Future taskFuture = CalculatorManager2.findTaskFuture((String)uid);
            Sheet calResult = taskFuture == null ? null : (Sheet)taskFuture.get();
            CalculatorManager2.removeTask((String)uid, (String)"");
            this.otherOperate(ctx, calResult, condition);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void otherOperate(Context ctx, Sheet calResult, String condition) throws BOSException {
        if (calResult != null && calResult.getChangeDataList().isEmpty()) {
            String udpSql = "update T_HR_TimepiecesumBillEntry set fentrycalstatus = ? where FID in (" + condition + ")";
            if (!calResult.getErrDataList().isEmpty()) {
                ArrayList<String> errRowIdList = new ArrayList<String>();
                for (ErrRow errRow : calResult.getErrDataList()) {
                    errRowIdList.add(errRow.getFID());
                }
                CmpInSql inSql = CmpInSqlFactory.getInstance();
                udpSql = udpSql + " and FID not in " + inSql.createInSqlBaseOnFId(ctx, errRowIdList);
            }
            DbUtil.execute((Context)ctx, (String)udpSql, (Object[])new Object[]{"1"});
        }
    }

    @Override
    protected IObjectPK _generateDayBill(Context ctx, Map param) throws BOSException, EASBizException {
        List baseDataList = (List)param.get("baseDataList");
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)param.get("info");
        String tableName = param.get("tableName").toString();
        IObjectPK objectPK = BatchSubmitShemeBillFactory.getLocalInstance(ctx).addnew(info);
        ArrayList paramList = Lists.newArrayList();
        ArrayList baseEntryParamList = Lists.newArrayList();
        Map firstParam = (Map)baseDataList.get(0);
        String baseEntryTableName = "T_HR_SchemeBillEntry";
        String billId = objectPK.toString();
        String entryBOSType = new BatchSubmitShemeBillEntryInfo().getBOSType().toString();
        for (int i = 0; i < baseDataList.size(); ++i) {
            Map baseData = (Map)baseDataList.get(i);
            String fid = BOSUuid.create((String)entryBOSType).toString();
            paramList.add(this.assembleTimepieceDailyBillEntryParam(tableName, baseData, billId, fid));
            baseEntryParamList.add(this.assembleTimepieceDailyBillEntryParam(baseEntryTableName, baseData, billId, fid));
        }
        if (paramList.size() > 0) {
            CmpSQLUtil.executeBatch(ctx, this.getTimepieceDailyBillEntrySql(tableName, firstParam), paramList);
            CmpSQLUtil.executeBatch(ctx, this.getTimepieceDailyBillEntrySql(baseEntryTableName, firstParam), baseEntryParamList);
        }
        return objectPK;
    }

    protected String getTimepieceDailyBillEntrySql(String tableName, Map<String, Object> firstParam) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append(" insert into ").append(tableName).append("(FID,FBillID");
        StringBuilder insertSqlV = new StringBuilder();
        firstParam.forEach((dbName, value) -> {
            if ("T_HR_SchemeBillEntry".equals(tableName) && ("FYear".equals(dbName) || "FApplyDate".equals(dbName))) {
                return;
            }
            insertSql.append(",").append((String)dbName);
            insertSqlV.append(",?");
        });
        insertSql.append(") values (?").append(",?").append((CharSequence)insertSqlV).append(")");
        return insertSql.toString();
    }

    protected Object[] assembleTimepieceDailyBillEntryParam(String tableName, Map<String, Object> baseData, String billId, String fid) {
        ArrayList batchParam = Lists.newArrayList();
        batchParam.add(fid);
        batchParam.add(billId);
        baseData.forEach((dbName, value) -> {
            if ("T_HR_SchemeBillEntry".equals(tableName) && ("FYear".equals(dbName) || "FApplyDate".equals(dbName))) {
                return;
            }
            batchParam.add(baseData.get(dbName));
        });
        return batchParam.toArray();
    }

    static class DailyEmpORelInfo {
        private String personId;
        private String cmpEmpORelationId;
        private Date effectDate;
        private Date leffectDate;
        private String adminOrgId;
        private String positionId;

        DailyEmpORelInfo() {
        }

        public void setPersonId(String personId) {
            this.personId = personId;
        }

        public void setCmpEmpORelationId(String cmpEmpORelationId) {
            this.cmpEmpORelationId = cmpEmpORelationId;
        }

        public void setEffectDate(Date effectDate) {
            this.effectDate = effectDate;
        }

        public void setLeffectDate(Date leffectDate) {
            this.leffectDate = leffectDate;
        }

        public void setAdminOrgId(String adminOrgId) {
            this.adminOrgId = adminOrgId;
        }

        public void setPositionId(String positionId) {
            this.positionId = positionId;
        }
    }

    static class DailySumDataGenParam {
        private String sumItemConfigId;
        private List<String> sumDataSourceList;
        private List<String> groupByColumn;
        private List<String> dimensionItemColumn;
        private Map<String, List<String>> itemMappingMap;
        private TimepieceSchemeInfo timepieceSchemeInfo;
        private String startDate;
        private String endDate;

        DailySumDataGenParam() {
        }

        public void buildSumItemConfigId(String sumItemConfigId) {
            this.sumItemConfigId = sumItemConfigId;
        }

        public void buildSumDataSource(List<String> sumDataSourceList) {
            this.sumDataSourceList = sumDataSourceList;
        }

        public void buildSumDimension(List<String> groupByColumn, List<String> dimensionItemColumn) {
            this.groupByColumn = groupByColumn;
            this.dimensionItemColumn = dimensionItemColumn;
        }

        public void buildItemMapping(Map<String, List<String>> itemMappingMap) {
            this.itemMappingMap = itemMappingMap;
        }

        public void buildOtherParam(TimepieceSchemeInfo timepieceSchemeInfo, String startDate, String endDate) {
            this.timepieceSchemeInfo = timepieceSchemeInfo;
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }
}

