/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpItemDataDot;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.calculate.CmpCalTypeEnum;
import com.kingdee.shr.compensation.app.calculate.SalaryCalProcessEnum;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.common.CmpDerbyDBUtil;
import com.kingdee.shr.compensation.calculate.cache.SalaryCalProcessCache;
import com.kingdee.shr.compensation.calculate.combine.calData.CmpItemService;
import com.kingdee.shr.compensation.calculate.helper.CalculateTool;
import com.kingdee.shr.compensation.calculate.model.ColumnAttribute;
import com.kingdee.shr.compensation.calculate.model.IRow;
import com.kingdee.shr.compensation.calculate.model.ITable;
import com.kingdee.shr.compensation.calculate.model.StructureAttribute;
import com.kingdee.shr.compensation.calculate.result.analysis.GetClassFromInterface;
import com.kingdee.shr.compensation.calculate.result.handle.ExtendDataInterface;
import com.kingdee.shr.compensation.calculate.thread.CalInitData;
import com.kingdee.shr.compensation.calculate.thread.log.SalaryCalLogThreadPoolManager;
import com.kingdee.shr.compensation.calculate.thread.log.SalaryCalculatorLog;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SalaryCalExecutor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.calculate.model.thread.SalaryCalExecutor");
    private Map<String, CmpItemInfo> itemMap = new HashMap<String, CmpItemInfo>();
    private CalInitData calInitData;
    private SalaryCalFunction calFunctionInstance;
    private ITable dataTable;
    private Map<String, Map<String, Object>> tempTableData;
    private Map<String, Map<String, Object>> editedItems;
    private Set<String> calItemSet;
    private List<Object[]> paramList = new ArrayList<Object[]>();
    private List<Object[]> stateParamList = new ArrayList<Object[]>();
    private Map<String, Object> returnDataMap = new HashMap<String, Object>();
    List<ExtendDataInterface> instanceList;
    private List<Object[]> exceptionList = new ArrayList<Object[]>();
    private Map<Integer, String> dataDotMap = new HashMap<Integer, String>();

    public SalaryCalExecutor(CalInitData calInitData, SalaryCalFunction calFunctionInstance, ITable dataTable, Map<String, Map<String, Object>> tempTableData) {
        this.calInitData = calInitData;
        this.calFunctionInstance = calFunctionInstance;
        this.tempTableData = tempTableData;
        calFunctionInstance.setCalScheme(calInitData.getSchemeInfo());
        calFunctionInstance.setSchemeID(calInitData.getSchemeInfo().getId().toString());
        CalSchemeInfo calScheme = calInitData.getSchemeInfo();
        if (null != calScheme.getCurrency()) {
            Date ruleEffdt = CurrencyUtil.getEffdtByExchangeRule(calScheme.getExchangeRule(), calScheme.getBeginDate(), calScheme.getEndDate());
            ExchangeRateCollection coll = null;
            try {
                coll = CurrencyUtil.getTargetExchangeRate(this.calInitData.getCtx(), calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), ruleEffdt);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            for (int i = 0; i < coll.size(); ++i) {
                ExchangeRateInfo exchangeRateInfo = coll.get(i);
                map.put(exchangeRateInfo.getSourceCurrency().getId().toString(), exchangeRateInfo.getConvertRate());
            }
            calFunctionInstance.setCurrencyMap(map);
            if (null != calScheme.getCurrency()) {
                calFunctionInstance.setCurrency(true);
            }
        }
        this.dataTable = dataTable;
        try {
            this.initSalaryCalData();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initSalaryCalData() throws Exception {
        this.itemMap = CmpItemService.getItemInfoMap(this.calInitData.getCtx(), this.calInitData.getSchemeInfo().getId().toString());
        this.calInitData.setItemMap(this.itemMap);
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, CmpItemInfo> entry : this.itemMap.entrySet()) {
            CmpItemDataDot dataDot;
            Integer dataDotV;
            str.append(entry.getKey()).append(",");
            CmpItemInfo cmpItemInfo = entry.getValue();
            CmpItemDataType dataType = cmpItemInfo.getDataType();
            if (0 != dataType.getValue() || this.dataDotMap.containsKey(dataDotV = Integer.valueOf((dataDot = cmpItemInfo.getDataDot()).getValue()))) continue;
            this.dataDotMap.put(dataDotV, dataDot.toString());
        }
        String itemColumns = str.subSequence(0, str.length() - 1).toString();
        this.editedItems = CmpItemService.initEditedItems(this.calInitData, itemColumns);
        this.calItemSet = CmpItemService.getCalItem(this.calInitData);
        List<Class<?>> classList = GetClassFromInterface.getAllClass(this.calInitData.getCtx(), ExtendDataInterface.class);
        System.out.println("SalaryCalExecutor:classList" + classList.size());
        this.instanceList = new ArrayList<ExtendDataInterface>();
        for (Class<?> c : classList) {
            Constructor<?> constructor = c.getConstructor(CalInitData.class, Object.class);
            this.instanceList.add((ExtendDataInterface)constructor.newInstance(this.calInitData, null));
        }
    }

    protected SalaryCalFunction calFromulaImp() {
        SalaryCalFunction formulaImp = null;
        try {
            formulaImp = (SalaryCalFunction)this.calFunctionInstance.getClass().getDeclaredMethod("getFormulaImp", new Class[0]).invoke((Object)this.calFunctionInstance, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        formulaImp.setTempMap(this.calFunctionInstance.getTempMap());
        formulaImp.setCalScheme(this.calFunctionInstance.getCalScheme());
        formulaImp.setCurrencyMap(this.calFunctionInstance.getCurrencyMap());
        formulaImp.setCurrency(this.calFunctionInstance.isCurrency());
        formulaImp.setCtx(this.calInitData.getCtx());
        formulaImp.setType(this.calFunctionInstance.getType());
        formulaImp.setCalRecordMap(this.calFunctionInstance.getCalRecordMap());
        formulaImp.setSchemeID(this.calFunctionInstance.getSchemeID());
        return formulaImp;
    }

    protected SalaryCalFunction calFunctionImp(SalaryCalFunction formulaImp) {
        SalaryCalFunction funcImp = null;
        try {
            funcImp = (SalaryCalFunction)formulaImp.getClass().getDeclaredMethod("getFuncImp", new Class[0]).invoke((Object)formulaImp, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        funcImp.setTempMap(this.calFunctionInstance.getTempMap());
        funcImp.setCalScheme(this.calFunctionInstance.getCalScheme());
        funcImp.setCtx(this.calInitData.getCtx());
        funcImp.setType(this.calFunctionInstance.getType());
        funcImp.setCalRecordMap(this.calFunctionInstance.getCalRecordMap());
        funcImp.setType(this.calFunctionInstance.getType());
        funcImp.setCurrencyMap(this.calFunctionInstance.getCurrencyMap());
        funcImp.setCurrency(this.calFunctionInstance.isCurrency());
        funcImp.setSchemeID(this.calFunctionInstance.getSchemeID());
        funcImp.setMainTableRowFilter(this.calFunctionInstance.getMainTableRowFilter());
        return funcImp;
    }

    protected void initCalParam(List<ColumnAttribute> columnAttributeList, IRow row, HashMap parasMap) {
        for (int i = 0; i < columnAttributeList.size(); ++i) {
            StructureAttribute structureAttribute = columnAttributeList.get(i).getTable();
            String columnName = structureAttribute.getTableName().equals("T_HR_SCMPCALTABLE") ? structureAttribute.getTableName() + "_" + columnAttributeList.get(i).getName().split("\\.")[1] : structureAttribute.getTableName() + "_" + columnAttributeList.get(i).getName().replace(".", "_");
            parasMap.put(columnName.toUpperCase(), row.getCell(i).getValue());
        }
    }

    protected void initTempTable(HashMap parasMap, String calId) {
        Map<String, Object> map = this.tempTableData.get(calId);
        if (null == map || map.size() < 1) {
            return;
        }
        for (Map.Entry<String, Object> e : map.entrySet()) {
            parasMap.put(e.getKey().toUpperCase(), e.getValue());
        }
    }

    public Map<String, Object> doExecute() {
        String caltableid = null;
        String calSchemeId = this.calInitData.getSchemeInfo().getId().toString();
        HashMap<String, Object> parasMap = new HashMap<String, Object>();
        int size = this.dataTable.size();
        int index = 0;
        int successCount = 0;
        int failCount = 0;
        boolean isException = false;
        Iterator iterator = this.dataTable.iterator();
        List<ColumnAttribute> columnAttributeList = this.dataTable.getCoumns();
        SalaryCalFunction formulaImp = this.calFromulaImp();
        SalaryCalFunction funcImp = this.calFunctionImp(formulaImp);
        if (null == formulaImp || null == funcImp) {
            return this.returnDataMap;
        }
        while (iterator.hasNext()) {
            isException = false;
            if (!this.calInitData.getCalType().equals((Object)CmpCalTypeEnum.SIMULATION) && SalaryCalProcessCache.getProcess(this.calInitData.getCtx(), calSchemeId).getProcessEnum().equals((Object)SalaryCalProcessEnum.STOPPING)) break;
            ++index;
            parasMap.clear();
            IRow row = (IRow)iterator.next();
            this.initCalParam(columnAttributeList, row, parasMap);
            caltableid = parasMap.get("T_HR_SCMPCALTABLE_ID").toString();
            this.initTempTable(parasMap, caltableid);
            this.addEditedItem(caltableid, parasMap);
            try {
                this.calFunctionInstance.setParamMap(parasMap);
                parasMap.put("ThisParamUsedForAnalasysTimeIsLastPerson", index == size);
                parasMap.put("T_HR_SCMPCALTABLE_FPERSONID", parasMap.get("T_BD_PERSON_CMP_PERSON_ID"));
                parasMap.put("T_HR_SCMPCALTABLE_FID", caltableid);
                formulaImp.setParamMap(this.calFunctionInstance.getParamMap());
                funcImp.setParamMap(this.calFunctionInstance.getParamMap());
                this.calFunctionInstance.getClass().getMethod("calculate", HashMap.class).invoke((Object)this.calFunctionInstance, parasMap);
            }
            catch (Exception e) {
                isException = true;
                ++failCount;
                logger.error((Object)e);
                this.handleException(e, parasMap);
            }
            if (!isException) {
                this.isChange(columnAttributeList, row, parasMap);
                for (ExtendDataInterface ins : this.instanceList) {
                    try {
                        ins.handle(parasMap);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                ++successCount;
            }
            if (!this.calInitData.getCalType().equals((Object)CmpCalTypeEnum.SIMULATION)) {
                SalaryCalProcessCache.updateProcess(this.calInitData.getCacheKey(), successCount, failCount);
            }
            if ((successCount <= 0 || successCount % 500 != 0) && (index != size || !this.calFunctionInstance.getCalRecordMap().containsKey("CAL_RECORD_MAP_PROCESS_DATA"))) continue;
            SalaryCalculatorLog calculatorLog = new SalaryCalculatorLog(this.calInitData, this.calFunctionInstance.getCalRecordMap());
            SalaryCalLogThreadPoolManager.addTask(this.calInitData.getCtx(), calculatorLog);
            this.calFunctionInstance.getCalRecordMap().remove("CAL_RECORD_MAP_PROCESS_DATA");
        }
        if (this.calInitData.getCalType().equals((Object)CmpCalTypeEnum.SIMULATION)) {
            this.returnDataMap.put("simulation", parasMap);
            return this.returnDataMap;
        }
        if (SalaryCalProcessCache.getProcess(this.calInitData.getCtx(), calSchemeId).getProcessEnum().equals((Object)SalaryCalProcessEnum.STOPPING)) {
            return null;
        }
        long l1 = System.currentTimeMillis();
        SalaryCalProcessCache.updateProcess(this.calInitData.getCtx(), this.calInitData.getCacheKey(), SalaryCalProcessEnum.SAVING);
        for (ExtendDataInterface ins : this.instanceList) {
            if (!ins.isSynsc()) continue;
            SalaryCalLogThreadPoolManager.addTask(this.calInitData.getCtx(), ins);
        }
        for (ExtendDataInterface ins : this.instanceList) {
            if (ins.isSynsc()) continue;
            try {
                ins.save();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        long l2 = System.currentTimeMillis();
        CalculateTool.resourceStatistics(this.calFunctionInstance.getCalRecordMap(), "CAL_RECORD_MAP_TIME_SAVERESULT", "CAL_RECORD_MAP_TIME_SAVERESULT_OTHER", l2 - l1);
        this.returnDataMap.put("calUpdateSql", this.getUpdateSql(columnAttributeList));
        this.returnDataMap.put("calUpdateSateSql", this.getUpdateStateSql());
        this.returnDataMap.put("calUpdateDataList", this.paramList);
        this.returnDataMap.put("calUpdateStateDataList", this.stateParamList);
        try {
            this.saveExceptionData();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.clearDerbyTable();
        return this.returnDataMap;
    }

    private void clearDerbyTable() {
        HashMap<String, Object> tempMap = this.calFunctionInstance.getTempMap();
        if (null == tempMap) {
            return;
        }
        String pre = (String)tempMap.get("shr_cmp_compensation_cal_save_map_outer");
        if (StringUtils.isEmpty((String)pre)) {
            return;
        }
        try {
            Set<String> tables = CmpDerbyDBUtil.getTables(pre.toUpperCase() + "%");
            tables.forEach(table -> {
                try {
                    CmpDerbyDBUtil.dropTable(table);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleException(Exception e, Map<String, Object> parasMap) {
        String calFormulaName = null == e.getMessage() ? e.getCause().toString() : e.getMessage();
        calFormulaName = calFormulaName.substring(calFormulaName.indexOf("[") + 1, calFormulaName.indexOf("]"));
        String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label3", (Locale)this.calInitData.getCtx().getLocale()) + "\uff1a" + calFormulaName + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label4", (Locale)this.calInitData.getCtx().getLocale());
        Object[] param = new Object[]{BOSUuid.create((String)"4FC94066").toString(), this.calInitData.getCalTaskId(), parasMap.get("T_HR_SCMPCALTABLE_ID").toString(), parasMap.get("T_BD_PERSON_CMP_PERSON_ID").toString(), calFormulaName, errMsg};
        this.exceptionList.add(param);
    }

    private void saveExceptionData() {
        StringBuilder str = new StringBuilder();
        str.append(" insert into T_HR_SCmpCalExcption( ");
        str.append(" fid, FCalTaskID, FCalTableID, FPersonID, Formula, FException)");
        str.append(" values(?, ?, ?, ?, ?, ?)");
        try {
            DbUtil.executeBatch((Context)this.calInitData.getCtx(), (String)str.toString(), this.exceptionList);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void addEditedItem(String caltableid, Map<String, Object> parasMap) {
        if (null == this.editedItems || this.editedItems.size() < 1) {
            return;
        }
        Map<String, Object> editedItem = this.editedItems.get(caltableid);
        if (null == editedItem) {
            return;
        }
        for (String key : editedItem.keySet()) {
            parasMap.put(key, editedItem.get(key));
        }
    }

    public boolean isChange(List<ColumnAttribute> columnAttributeList, IRow row, Map<String, Object> parasMap) {
        Object[] param = new Object[this.calItemSet.size() + 1];
        int paramIndex = 0;
        int calState = 0;
        boolean isChange = false;
        for (int i = 0; i < columnAttributeList.size(); ++i) {
            String calValueStr;
            String oldValueStr;
            ColumnAttribute columnAttribute = columnAttributeList.get(i);
            String oldColumnName = columnAttribute.getName().toUpperCase();
            String columnName = oldColumnName.contains("CMP_CTB.") ? oldColumnName.replace("CMP_CTB.", "") : oldColumnName;
            String paraName = ("T_HR_SCMPCALTABLE_" + columnName).toUpperCase();
            Object oldValue = row.getCell(i).getValue();
            Object calValue = parasMap.get(paraName);
            if (oldColumnName.equalsIgnoreCase("CMP_CTB.CALSTATE")) {
                calState = Integer.valueOf(oldValue.toString());
            }
            if (columnName.contains(".") || !this.calItemSet.contains(columnName)) continue;
            CmpItemInfo cmpItemInfo = this.itemMap.get(columnName);
            CmpItemDataType cmpItemDataType = cmpItemInfo.getDataType();
            if (cmpItemDataType == CmpItemDataType.NUMBER) {
                CmpItemDataDot cmpItemDataDot = cmpItemInfo.getDataDot();
                String dataDotFormat = this.dataDotMap.get(cmpItemDataDot.getValue());
                oldValueStr = CalculateTool.getDoubleByScienNotation(oldValue, dataDotFormat);
                calValueStr = CalculateTool.getDoubleByScienNotation(calValue, dataDotFormat);
            } else {
                oldValueStr = FunUtils.toString(oldValue);
                calValueStr = FunUtils.toString(calValue);
            }
            if (!this.isEqual(oldValueStr, calValueStr)) {
                isChange = true;
            }
            param[paramIndex++] = calValueStr;
        }
        if (isChange) {
            param[paramIndex] = parasMap.get("T_HR_SCMPCALTABLE_ID").toString();
            this.paramList.add(param);
        }
        if (!isChange && calState != 4) {
            this.stateParamList.add(new Object[]{parasMap.get("T_HR_SCMPCALTABLE_ID").toString()});
        }
        return isChange;
    }

    private String getUpdateSql(List<ColumnAttribute> columnAttributeList) {
        StringBuilder str = new StringBuilder();
        str.append(" UPDATE ").append("T_HR_SCMPCALTABLE").append(" SET FCALSTATE = 4,");
        str.append(" FCALTAXDATASTATE = CASE WHEN FCALTAXDATASTATE = 1 THEN 3 WHEN FCALTAXDATASTATE = 2 THEN 3 WHEN FCALTAXDATASTATE IN (3,4) THEN 3 WHEN FCALTAXDATASTATE = 5 THEN 3 ELSE 0 END");
        if (null == columnAttributeList) {
            return null;
        }
        for (int index = 0; index < columnAttributeList.size(); ++index) {
            String key = columnAttributeList.get(index).getName().toUpperCase();
            String string = key = key.contains("CMP_CTB.") ? key.replace("CMP_CTB.", "") : key;
            if (key.contains(".") || !this.calItemSet.contains(key)) continue;
            str.append(",").append(key).append(" = ?");
        }
        str.append(" WHERE FID ").append(" = ?");
        return str.toString();
    }

    private String getUpdateStateSql() {
        StringBuilder str = new StringBuilder();
        str.append(" UPDATE ").append("T_HR_SCMPCALTABLE").append(" SET FCALSTATE = 4,");
        str.append(" FCALTAXDATASTATE = CASE WHEN FCALTAXDATASTATE = 1 THEN 3 WHEN FCALTAXDATASTATE = 2 THEN 3 WHEN FCALTAXDATASTATE IN (3,4) THEN 3 WHEN FCALTAXDATASTATE = 5 THEN 3 ELSE 0 END");
        str.append(" WHERE FID ").append(" = ?");
        return str.toString();
    }

    public boolean isEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if ((a == null || StringUtils.isEmpty((String)a.toString())) && (b == null || StringUtils.isEmpty((String)b.toString()))) {
            return true;
        }
        if (a instanceof String) {
            return a.equals(b);
        }
        if (b instanceof String) {
            return b.equals(a);
        }
        if (a instanceof Double) {
            return a.equals(b);
        }
        if (b instanceof Double) {
            return b.equals(a);
        }
        if (a instanceof Number && b != null && ((Number)a).doubleValue() == ((Number)b).doubleValue()) {
            return true;
        }
        return a == b;
    }
}

