/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.currency.repCurrency.calRef.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CmpExchangeRuleEnum;
import com.kingdee.shr.compensation.app.currencyReport.CalSchemeReportInfo;
import com.kingdee.shr.compensation.app.currencyReport.ReportCurrencySetInfo;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.currency.repCurrency.RepCurrencyUtil;
import com.kingdee.shr.compensation.currency.repCurrency.calRef.ReportDataGenerator;
import com.kingdee.shr.compensation.currency.repCurrency.calRef.ReportDataHelper;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DiffCurGenerator
extends ReportDataGenerator {
    String preQuerySql = null;
    int defaultDataDot = 10;

    public DiffCurGenerator() {
    }

    public DiffCurGenerator(Context ctx, ReportDataGenerator nextGenerator, ReportDataHelper helper) {
        this.setCtx(ctx);
        this.setHelper(helper);
        if (null != nextGenerator) {
            nextGenerator.setHelper(this.getHelper());
            nextGenerator.setCtx(ctx);
        }
        this.setNextGenerator(nextGenerator);
    }

    @Override
    public void dataGenerate(CalSchemeReportInfo calSchemeReportInfo) throws Exception {
        this.excute(calSchemeReportInfo);
    }

    private void excute(CalSchemeReportInfo calSchemeReportInfo) throws BOSException, SQLException {
        BigDecimal convertRate = this.getConvertRate(calSchemeReportInfo);
        List<String> numberItemList = this.getHelper().getNumberItemList();
        List<String> stringItemList = this.getHelper().getStringItemList();
        if (this.excPreSql == null) {
            this.getExcPreSql(calSchemeReportInfo, numberItemList, stringItemList);
        }
        IRowSet rs = this.getQueryRowSet(calSchemeReportInfo, numberItemList, stringItemList);
        BigDecimal value = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] sqlParam = null;
        while (rs.next()) {
            int index = 0;
            sqlParam = new Object[numberItemList.size() + stringItemList.size() + 6];
            for (String s : numberItemList) {
                value = rs.getBigDecimal(s);
                sqlParam[index] = value != null && !value.equals(BigDecimal.ZERO) ? FunctionTools.getRound(this.defaultDataDot, value.multiply(convertRate).doubleValue()) : (value == null ? null : Integer.valueOf(0));
                ++index;
            }
            for (String s : stringItemList) {
                sqlParam[index] = rs.getString(s);
                ++index;
            }
            sqlParam[index++] = rs.getString("fid");
            sqlParam[index++] = calSchemeReportInfo.getId().toString();
            sqlParam[index++] = calSchemeReportInfo.getCalscheme().getId().toString();
            sqlParam[index++] = calSchemeReportInfo.getPeriodYear();
            sqlParam[index++] = calSchemeReportInfo.getPeriodMonth();
            sqlParam[index++] = calSchemeReportInfo.getCalTime();
            paramList.add(sqlParam);
        }
        this.addPreSql(this.excPreSql, paramList);
        this.addUpdateRange(calSchemeReportInfo);
    }

    private void getExcPreSql(CalSchemeReportInfo calSchemeReportInfo, List<String> numberItemList, List<String> stringItemList) {
        String nowDateStr = CmpDateUtil.toKSqlDate(new Date());
        String userId = HRFilterUtils.getCurrentUserId((Context)this.getCtx());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_HR_SCMPCALTABLEREP(");
        sql.append(RepCurrencyUtil.converCollection2StringWithSeparate(numberItemList, ","));
        sql.append(",").append(RepCurrencyUtil.converCollection2StringWithSeparate(stringItemList, ","));
        sql.append(",fcaltableid,fcalschemerepid,fcurrencyid,fcalschemeid,fperiodyear,fperiodmonth,fcaltime,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fid) ");
        sql.append(" values(");
        int size = numberItemList.size() + stringItemList.size();
        for (int i = 0; i < size; ++i) {
            sql.append("?,");
        }
        sql.append("?,?,'").append(calSchemeReportInfo.getRepCurrency().getId().toString());
        sql.append("',?,?,?,?,'").append(userId);
        sql.append("',").append(nowDateStr);
        sql.append(",'").append(userId);
        sql.append("',").append(nowDateStr);
        sql.append(",newbosid('7702FBFE'))");
        this.excPreSql = sql.toString();
    }

    private IRowSet getQueryRowSet(CalSchemeReportInfo calSchemeReportInfo, List<String> numberItemList, List<String> stringItemList) throws BOSException {
        if (this.preQuerySql == null) {
            this.getpreQuerySql(numberItemList, stringItemList);
        }
        Object[] param = new Object[]{calSchemeReportInfo.getPeriodYear(), calSchemeReportInfo.getPeriodMonth(), calSchemeReportInfo.getCalTime(), calSchemeReportInfo.getCalscheme().getId().toString()};
        return DbUtil.executeQuery((Context)this.getCtx(), (String)this.preQuerySql, (Object[])param);
    }

    private void getpreQuerySql(List<String> numberItemList, List<String> stringItemList) {
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(RepCurrencyUtil.converCollection2StringWithSeparate(numberItemList, ","));
        sql.append(",").append(RepCurrencyUtil.converCollection2StringWithSeparate(stringItemList, ","));
        sql.append(",fid from t_hr_scmpcaltable where fperiodYear = ?");
        sql.append(" and fperiodMonth = ?");
        sql.append(" and fcaltime = ?");
        sql.append(" and fcalschemeId = ?");
        this.preQuerySql = sql.toString();
    }

    private BigDecimal getConvertRate(CalSchemeReportInfo calSchemeReportInfo) throws BOSException {
        Map<String, BigDecimal> convertRateMap = this.helper.getConvertRateMap();
        ReportCurrencySetInfo setInfo = this.helper.getReportCurrencySetInfo();
        String tableId = setInfo.getExchangeTable().getId().toString();
        String targetCurrencyId = setInfo.getCurrency().getId().toString();
        String sourceCurrencyId = calSchemeReportInfo.getCalCurrency().getId().toString();
        Date ruleDate = setInfo.getExchangeRule() == CmpExchangeRuleEnum.PERIOD_BEGIN ? calSchemeReportInfo.getBeginDate() : calSchemeReportInfo.getEndDate();
        StringBuffer rateKey = new StringBuffer();
        rateKey.append(tableId).append("_");
        rateKey.append(targetCurrencyId).append("_");
        rateKey.append(sourceCurrencyId).append("_");
        rateKey.append(CmpStrUtil.toString(ruleDate));
        String rateKeyStr = rateKey.toString();
        if (convertRateMap != null && convertRateMap.containsKey(rateKeyStr)) {
            return convertRateMap.get(rateKeyStr);
        }
        BigDecimal convertRate = CurrencyUtil.getConvertRate(this.getCtx(), tableId, targetCurrencyId, sourceCurrencyId, ruleDate);
        if (null == convertRateMap) {
            return null;
        }
        convertRateMap.put(rateKeyStr, convertRate);
        return convertRate;
    }
}

