/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.factory.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeFactory;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.factory.AbstractEmpOrgRelation;
import com.kingdee.shr.compensation.record.factory.AbstractRecord;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.sql.record.CmpRecordSQL;
import com.kingdee.shr.compensation.sql.record.RecordCommonSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CmpEmpOrgRelation
extends AbstractEmpOrgRelation {
    @Override
    public List<String> createEmpOrgRelationsByAssignType(Context ctx, List<RecordDataInfo> empList) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String insertCols = "Fid,FPersonCmpID,FEmpOrgRelationID,FEmpPostExpHisID,FPersonBURelationID,FUseDefault,FEffectDate,FLeffectDate,FPersonId";
        String creRecordSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SCmpEmpORelation", insertCols);
        if (null == empList || empList.size() < 1) {
            return list;
        }
        int size = empList.size();
        for (int i = 0; i < size; ++i) {
            Object[] batchParam = new Object[9];
            String id = BOSUuid.create((String)"CC6BC927").toString();
            RecordDataInfo recordDataInfo = empList.get(i);
            batchParam[0] = id;
            batchParam[1] = recordDataInfo.getRecordId();
            batchParam[2] = recordDataInfo.getEmpOrgRelationId();
            batchParam[3] = recordDataInfo.getEmpPostExpHisId();
            batchParam[4] = recordDataInfo.getPersonBURelId();
            batchParam[5] = recordDataInfo.getUseDefault();
            batchParam[6] = null == recordDataInfo.getEffdt() ? recordDataInfo.getEmpEffdt() : ("1".equals(recordDataInfo.getAssignType()) ? recordDataInfo.getEmpEffdt() : (recordDataInfo.getEffdt().before(recordDataInfo.getEmpEffdt()) ? recordDataInfo.getEmpEffdt() : recordDataInfo.getEffdt()));
            batchParam[7] = recordDataInfo.getEmpFLEffdt();
            batchParam[8] = recordDataInfo.getPersonId();
            paramsList.add(batchParam);
            list.add(id);
        }
        try {
            CmpSQLUtil.executeBatch(ctx, creRecordSql, paramsList);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        String updateSql = CmpRecordSQL.updatePersonRecord(CmpStrUtil.convertListToString(list));
        CmpSQLUtil.execute(ctx, updateSql);
        this.afterCreateEmpOrgRel(ctx, list);
        return list;
    }

    @Override
    public List<String> createEmpOrgRelations(Context ctx, List<RecordDataInfo> empList) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String insertCols = "Fid,FPersonCmpID,FEmpOrgRelationID,FEmpPostExpHisID,FPersonBURelationID,FUseDefault,FEffectDate,FLeffectDate,FPersonId";
        String creRecordSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SCmpEmpORelation", insertCols);
        if (null == empList || empList.size() < 1) {
            return list;
        }
        int size = empList.size();
        for (int i = 0; i < size; ++i) {
            Object[] batchParam = new Object[9];
            String id = BOSUuid.create((String)"CC6BC927").toString();
            RecordDataInfo recordDataInfo = empList.get(i);
            batchParam[0] = id;
            batchParam[1] = recordDataInfo.getRecordId();
            batchParam[2] = recordDataInfo.getEmpOrgRelationId();
            batchParam[3] = recordDataInfo.getEmpPostExpHisId();
            batchParam[4] = recordDataInfo.getPersonBURelId();
            batchParam[5] = recordDataInfo.getUseDefault();
            batchParam[6] = null == recordDataInfo.getEffdt() ? recordDataInfo.getEmpEffdt() : (recordDataInfo.getEffdt().before(recordDataInfo.getEmpEffdt()) ? recordDataInfo.getEmpEffdt() : recordDataInfo.getEffdt());
            batchParam[7] = recordDataInfo.getEmpFLEffdt();
            batchParam[8] = recordDataInfo.getPersonId();
            paramsList.add(batchParam);
            list.add(id);
        }
        try {
            CmpSQLUtil.executeBatch(ctx, creRecordSql, paramsList);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        String updateSql = CmpRecordSQL.updatePersonRecord(CmpStrUtil.convertListToString(list));
        CmpSQLUtil.execute(ctx, updateSql);
        this.afterCreateEmpOrgRel(ctx, list);
        return list;
    }

    protected void afterCreateEmpOrgRel(Context ctx, List<String> list) {
        if (null == list || 0 == list.size()) {
            return;
        }
        try {
            String cmpEmpORelIds = CmpSQLUtil.createInSql(ctx, list, "T_HR_SCmpEmpORelation", "FID");
            GenCmpAdjDataFromEmpFacadeFactory.getLocalInstance((Context)ctx).genCmpData(cmpEmpORelIds);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loseEmpRelations(Context ctx, Map<String, java.util.Date> empMap) throws BOSException, EASBizException {
        Date newDate;
        if (empMap.size() < 1) {
            return;
        }
        HashMap<String, Date> empPosMap = new HashMap<String, Date>();
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, java.util.Date> entry : empMap.entrySet()) {
            str.append("'").append(entry.getKey()).append("',");
        }
        String cmpEmpIds = str.substring(0, str.length() - 1).toString();
        str = new StringBuilder();
        str.append(" select A01.fid, A02.FLEFFDT ");
        str.append(" from T_HR_SCmpEmpORelation A01 ");
        str.append(" inner join T_HR_EmpOrgRelation A02 on A01.FEmpOrgRelationID = A02.fid ");
        str.append(" where A01.fid in (").append(cmpEmpIds).append(") ");
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, str.toString());
        try {
            while (rowSet.next()) {
                empPosMap.put(rowSet.getString(1), rowSet.getDate(2));
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        LinkedList<Object> paramsList = new LinkedList<Object[]>();
        String updateSql = "update T_HR_SCmpEmpORelation set FLeffectDate = ? where fid = ? ";
        for (Map.Entry<String, java.util.Date> entry : empMap.entrySet()) {
            String string = entry.getKey();
            java.util.Date empPosDate = (java.util.Date)empPosMap.get(string);
            newDate = CmpDateUtil.toSqlDate(entry.getValue());
            Date updateDate = null == empPosDate ? newDate : (empPosDate.before(newDate) ? empPosDate : newDate);
            Object[] batchParam = new Object[]{updateDate, string};
            paramsList.add(batchParam);
        }
        try {
            CmpSQLUtil.executeBatch(ctx, updateSql, paramsList);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        paramsList = new LinkedList();
        String costSql = " update T_HR_SCostBearOrg set FLeffectDate = ? where FCmpEmpORelationID = ? and (FLeffectDate >= ? or FLeffectDate is null) ";
        for (Map.Entry<String, java.util.Date> entry : empMap.entrySet()) {
            String cmpEmpId = entry.getKey();
            newDate = CmpDateUtil.toSqlDate(entry.getValue());
            Object[] batchParam = new Object[]{newDate, cmpEmpId, newDate};
            paramsList.add(batchParam);
        }
        try {
            CmpSQLUtil.executeBatch(ctx, costSql, paramsList);
        }
        catch (BOSException bOSException) {
            throw new BOSException((Throwable)bOSException);
        }
        String string = CmpStrUtil.converMapToString(empMap);
        String string2 = "select FPersonBURelationID from T_HR_SCmpEmpORelation where Fid in (" + string + ") ";
        RecordUtil.updatePBUState(ctx, string2, 2, false);
    }

    @Override
    public List<String> disableEmpRelations(Context ctx, List<String> recordList) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String recordIds = CmpStrUtil.convertListToString(recordList);
        String sqlStr = CmpRecordSQL.getDisableERByRecordSql(recordIds);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sqlStr.toString());
        try {
            while (rowSet.next()) {
                Object[] params = new Object[]{rowSet.getDate("FLEFFDT"), rowSet.getString("empFid")};
                paramsList.add(params);
                list.add(rowSet.getString("FPersonBURelationID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (paramsList.size() > 0) {
            String udpateSql = SQLHandleUtil.getUpdateSql("T_HR_SCmpEmpORelation", "FLeffectDate", "fid", null);
            CmpSQLUtil.executeBatch(ctx, udpateSql, paramsList);
        }
        return list;
    }

    @Override
    public void updateEmpOrgRelations(Context ctx, List<RecordDataInfo> empList) throws BOSException, EASBizException {
        StringBuffer str = new StringBuffer();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        if (null == empList || empList.size() < 1) {
            return;
        }
        String updateSql = SQLHandleUtil.getUpdateSql("T_HR_SCmpEmpORelation", "FPersonBURelationID,FUseDefault,FEffectDate", "fid", null);
        int size = empList.size();
        for (int i = 0; i < size; ++i) {
            java.util.Date empEffdt;
            RecordDataInfo recordDataInfo = empList.get(i);
            Object[] batchParam = new Object[4];
            batchParam[0] = recordDataInfo.getPersonBURelId();
            batchParam[1] = recordDataInfo.getUseDefault();
            java.util.Date date = null == recordDataInfo.getEmpEffdt() ? recordDataInfo.getOldFEffDate() : (empEffdt = recordDataInfo.getEmpEffdt().compareTo(recordDataInfo.getOldFEffDate()) >= 0 ? recordDataInfo.getOldFEffDate() : recordDataInfo.getEmpEffdt());
            batchParam[2] = recordDataInfo.getEffdt() == null ? empEffdt : (empEffdt == null ? recordDataInfo.getEffdt() : (empEffdt.after(recordDataInfo.getEffdt()) ? empEffdt : recordDataInfo.getEffdt()));
            batchParam[3] = recordDataInfo.getCmpEmpid();
            paramsList.add(batchParam);
            str.append("'").append(recordDataInfo.getCmpEmpid()).append("',");
        }
        try {
            CmpSQLUtil.executeBatch(ctx, updateSql, paramsList);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        String cmpEmpIds = str.substring(0, str.length() - 1);
        str = new StringBuffer();
        str.append(" update T_HR_SCmpEmpORelation tt set FLeffectDate = (");
        str.append(" select FLEFFDT from T_HR_EmpOrgRelation t1 ");
        str.append(" where tt.FEmpOrgRelationID = t1.fid) ");
        str.append(" where tt.fid in (" + cmpEmpIds + ") ");
        CmpSQLUtil.execute(ctx, str.toString());
        str = new StringBuffer();
        str.append(" update T_HR_SPersonCmp tt set FLeffectDate = {ts '2199-12-31'} ");
        str.append(" where exists (select 1 from T_HR_SCmpEmpORelation t1 where tt.fid = t1.FPersonCmpID ");
        str.append(" and t1.FPersonBURelationID in (" + cmpEmpIds + ")) ");
        str.append(" and FLeffectDate < {ts '2199-12-31'} ");
        CmpSQLUtil.execute(ctx, str.toString());
    }

    @Override
    public void undoRelations(Context ctx, String empId) throws BOSException, EASBizException {
        String sql = CmpRecordSQL.getReocrdInfoByEmpId(empId);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            while (rowSet.next()) {
                String recordId = rowSet.getString("recFid");
                if (!map.containsKey(recordId)) {
                    map.put(recordId, 1);
                    continue;
                }
                map.put(recordId, (Integer)map.get(recordId) + 1);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (!empId.equals(rowSet.getString("empFid"))) continue;
                int assignType = rowSet.getInt("FAssignType");
                String parentId = rowSet.getString("FParentID");
                String recordId = rowSet.getString("recFid");
                if ((Integer)map.get(recordId) <= 1) {
                    AbstractRecord recordImpl = RecordInstanceFactory.getRecordInstance(RecordInstanceFactory.CATEGORY.CMP);
                    recordImpl.deleteRecords(ctx, recordId, true);
                    continue;
                }
                if (0 == assignType) {
                    this.deleteRelations(ctx, empId);
                    continue;
                }
                this.deleteRelations(ctx, empId);
                if (CmpStrUtil.isEmpty(parentId)) continue;
                String recoverPbuId = null;
                String recoverSql = CmpRecordSQL.getRecoverEmpSql(parentId, recordId);
                IRowSet rowSet1 = CmpSQLUtil.executeQuery(ctx, recoverSql);
                try {
                    while (rowSet1.next()) {
                        recoverPbuId = rowSet1.getString("FPersonBURelationID");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (CmpStrUtil.isEmpty(recoverPbuId)) {
                    return;
                }
                CmpSQLUtil.executeUpdate(ctx, CmpRecordSQL.updateRecoverEmpSql(recoverPbuId));
                String recoverPBUSql = RecordCommonSQL.getRecoverPBUSql(recoverPbuId);
                CmpSQLUtil.executeUpdate(ctx, recoverPBUSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteRelations(Context ctx, String empId) throws BOSException, EASBizException {
        CmpSQLUtil.execute(ctx, " delete from T_HR_SCostBearOrg where FCmpEmpORelationID in (select fid from T_HR_SCmpEmpORelation where FEmpOrgRelationID = '" + empId + "') ");
        CmpSQLUtil.execute(ctx, "delete from T_HR_PersonBURelation where Fid in (select FPersonBURelationID from T_HR_SCmpEmpORelation where FEmpOrgRelationID = '" + empId + "')");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCmpEmpORelation where FEmpOrgRelationID = '" + empId + "'");
    }

    @Override
    public void deleteRelations(Context ctx, String empId, String recId) throws BOSException, EASBizException {
        String inSql = "select fid from T_HR_SCmpEmpORelation where FEmpOrgRelationID = '" + empId + "' and FPersonCmpID = '" + recId + "' ";
        String inPbuSql = "select FPersonBURelationID from T_HR_SCmpEmpORelation where FEmpOrgRelationID = '" + empId + "' and FPersonCmpID = '" + recId + "' ";
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCostBearOrg where FCmpEmpORelationID in (" + inSql + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_PersonBURelation where Fid in (" + inPbuSql + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCmpEmpORelation where fid in (" + inSql + ")");
    }
}

