/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpExchangeRuleEnum;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalFunGetItemSumSalaryService
extends SalaryCalFunction {
    private Logger logger = Logger.getLogger(CalFunGetItemSumSalaryService.class);

    public double getItemRelativeSumSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItemsName, double startPeriod, double endPeriod) {
        Context ctx = Tools.getInstance().getCtx();
        Double sumValue = 0.0;
        CmpPeriodTypeEnum cmpPeriodType = calScheme.getCmpPeriodType();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, periodYear);
        calendar.set(2, periodMonth - 1);
        calendar.set(5, 1);
        int startYear = periodYear;
        int startMonth = periodMonth;
        int endYear = periodYear;
        int endMonth = periodMonth;
        Date refDate = calendar.getTime();
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            calendar.add(2, (int)startPeriod);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            calendar.add(2, (int)startPeriod * 3);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            calendar.add(2, (int)startPeriod * 6);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            calendar.add(2, (int)startPeriod * 12);
        }
        startYear = calendar.get(1);
        startMonth = calendar.get(2) + 1;
        calendar.setTime(refDate);
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            calendar.add(2, (int)endPeriod);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            calendar.add(2, (int)endPeriod * 3);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            calendar.add(2, (int)endPeriod * 6);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            calendar.add(2, (int)endPeriod * 12);
        }
        endYear = calendar.get(1);
        endMonth = calendar.get(2) + 1;
        if (endYear < startYear || endYear == startYear && endMonth < startMonth) {
            return 0.0;
        }
        String tempKey = "GetItemSum1_" + cmpItemsName + "_" + startYear + "_" + startMonth + "_" + endYear + "_" + endMonth;
        Map<String, Double> sumMap = null;
        if (tempMap.containsKey(tempKey)) {
            sumMap = (Map<String, Double>)tempMap.get(tempKey);
        } else {
            String l = calScheme.getLanType().getValue();
            String fieldSn = "";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select fieldsn from t_hr_scmpItem where fname_" + l + " = '" + cmpItemsName + "'"));
                if (rowSet.next()) {
                    fieldSn = rowSet.getString("fieldsn");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fieldSn)) {
                return 0.0;
            }
            sumMap = this.getItemSumSalary(ctx, calScheme, fieldSn, startYear, startMonth, endYear, endMonth, mainTableRowFilter);
            tempMap.put(tempKey, sumMap);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        sumValue = (Double)sumMap.get(personId);
        if (sumValue == null) {
            return 0.0;
        }
        return sumValue;
    }

    public double getItemAbsoluteSumSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItemsName, double startPeriodYear, double startPeriodMonth, double endPeriod) {
        Context ctx = Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        Double sumValue = 0.0;
        String fieldSn = null;
        CmpPeriodTypeEnum cmpPeriodType = calScheme.getCmpPeriodType();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, periodYear);
        calendar.set(2, periodMonth - 1);
        calendar.set(5, 1);
        int startYear = periodYear;
        int startMonth = periodMonth;
        int endYear = periodYear;
        int endMonth = periodMonth;
        Date refDate = calendar.getTime();
        calendar.add(1, (int)startPeriodYear);
        startYear = calendar.get(1);
        startMonth = (int)startPeriodMonth;
        calendar.setTime(refDate);
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            calendar.add(2, (int)endPeriod);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            calendar.add(2, (int)endPeriod * 3);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            calendar.add(2, (int)endPeriod * 6);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            calendar.add(2, (int)endPeriod * 12);
        }
        endYear = calendar.get(1);
        endMonth = calendar.get(2) + 1;
        if (endYear < startYear || endYear == startYear && endMonth < startMonth) {
            return 0.0;
        }
        String tempKey = "GetItemSum2_" + cmpItemsName + "_" + startYear + "_" + startMonth + "_" + endYear + "_" + endMonth;
        Map<String, Double> sumMap = null;
        if (tempMap.containsKey(tempKey)) {
            sumMap = (Map<String, Double>)tempMap.get(tempKey);
        } else {
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select fieldsn from t_hr_scmpItem where fname_" + l + " = '" + cmpItemsName + "'"));
                if (rowSet.next()) {
                    fieldSn = rowSet.getString("fieldsn");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty(fieldSn)) {
                return 0.0;
            }
            sumMap = this.getItemSumSalary(ctx, calScheme, fieldSn, startYear, startMonth, endYear, endMonth, mainTableRowFilter);
            tempMap.put(tempKey, sumMap);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        sumValue = (Double)sumMap.get(personId);
        if (sumValue == null) {
            return 0.0;
        }
        return sumValue;
    }

    public double getTaxUnitItemRelSumSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItemsName, double startPeriod, double endPeriod, double isNotCurrTaxUnit) {
        Double sumValue = 0.0;
        CmpPeriodTypeEnum cmpPeriodType = calScheme.getCmpPeriodType();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, periodYear);
        calendar.set(2, periodMonth - 1);
        calendar.set(5, 1);
        int startYear = periodYear;
        int startMonth = periodMonth;
        int endYear = periodYear;
        int endMonth = periodMonth;
        Date refDate = calendar.getTime();
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            calendar.add(2, (int)startPeriod);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            calendar.add(2, (int)startPeriod * 3);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            calendar.add(2, (int)startPeriod * 6);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            calendar.add(2, (int)startPeriod * 12);
        }
        startYear = calendar.get(1);
        startMonth = calendar.get(2) + 1;
        calendar.setTime(refDate);
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            calendar.add(2, (int)endPeriod);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            calendar.add(2, (int)endPeriod * 3);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            calendar.add(2, (int)endPeriod * 6);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            calendar.add(2, (int)endPeriod * 12);
        }
        endYear = calendar.get(1);
        endMonth = calendar.get(2) + 1;
        if (endYear < startYear || endYear == startYear && endMonth < startMonth) {
            return 0.0;
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String fieldSn = "";
        Context ctx = Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select fieldsn from t_hr_scmpItem where fname_" + l + " = '" + cmpItemsName + "'"));
            if (rowSet.next()) {
                fieldSn = rowSet.getString("fieldsn");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fieldSn)) {
            return 0.0;
        }
        Map<String, Double> sumMap = null;
        String tempKey = "GetItemSum3_" + fieldSn + "_" + startYear + "_" + startMonth + "_" + endYear + "_" + endMonth + "_" + isNotCurrTaxUnit;
        if (tempMap.containsKey(tempKey)) {
            sumMap = (Map<String, Double>)tempMap.get(tempKey);
        } else {
            sumMap = this.getTaxItemSumSalary(ctx, fieldSn, startYear, startMonth, endYear, endMonth, isNotCurrTaxUnit, calScheme, mainTableRowFilter);
            tempMap.put(tempKey, sumMap);
        }
        sumValue = (Double)sumMap.get(personId);
        if (sumValue == null) {
            return 0.0;
        }
        return sumValue;
    }

    public double getTaxUnitItemAbsSumSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItemsName, double startPeriodYear, double startPeriodMonth, double endPeriod, double isNotCurrTaxUnit) {
        Context ctx = Tools.getInstance().getCtx();
        String fieldSn = null;
        String l = calScheme.getLanType().getValue();
        Double sumValue = 0.0;
        CmpPeriodTypeEnum cmpPeriodType = calScheme.getCmpPeriodType();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, periodYear);
        calendar.set(2, periodMonth - 1);
        calendar.set(5, 1);
        int startYear = periodYear;
        int startMonth = periodMonth;
        int endYear = periodYear;
        int endMonth = periodMonth;
        Date refDate = calendar.getTime();
        calendar.add(1, (int)startPeriodYear);
        startYear = calendar.get(1);
        startMonth = (int)startPeriodMonth;
        calendar.setTime(refDate);
        if (cmpPeriodType == CmpPeriodTypeEnum.month) {
            calendar.add(2, (int)endPeriod);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.quarter) {
            calendar.add(2, (int)endPeriod * 3);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.half) {
            calendar.add(2, (int)endPeriod * 6);
        } else if (cmpPeriodType == CmpPeriodTypeEnum.yeay) {
            calendar.add(2, (int)endPeriod * 12);
        }
        endYear = calendar.get(1);
        endMonth = calendar.get(2) + 1;
        if (endYear < startYear || endYear == startYear && endMonth < startMonth) {
            return 0.0;
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String tempKey = "GetItemSum4_" + cmpItemsName + "_" + startYear + "_" + startMonth + "_" + endYear + "_" + endMonth + "_" + isNotCurrTaxUnit;
        Map<String, Double> sumMap = null;
        if (tempMap.containsKey(tempKey)) {
            sumMap = (Map<String, Double>)tempMap.get(tempKey);
        } else {
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select fieldsn from t_hr_scmpItem where fname_" + l + " = '" + cmpItemsName + "'"));
                if (rowSet.next()) {
                    fieldSn = rowSet.getString("fieldsn");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty(fieldSn)) {
                return 0.0;
            }
            sumMap = this.getTaxItemSumSalary(ctx, fieldSn, startYear, startMonth, endYear, endMonth, isNotCurrTaxUnit, calScheme, mainTableRowFilter);
            tempMap.put(tempKey, sumMap);
        }
        sumValue = (Double)sumMap.get(personId);
        if (sumValue == null) {
            return 0.0;
        }
        return sumValue;
    }

    private Map<String, Double> getTaxItemSumSalary(Context ctx, String fieldSn, int startYear, int startMonth, int endYear, int endMonth, double isNotCurrTaxUnit, CalSchemeInfo calschemeInfo, String mainTableRowFilter) {
        HashMap<String, Double> sumMap = new HashMap<String, Double>();
        String cfc = isNotCurrTaxUnit == 0.0 ? " = " : " != ";
        String personId = null;
        BigDecimal rate = new BigDecimal(1);
        BigDecimal tempSum = new BigDecimal(0);
        StringBuilder bodyBuf = new StringBuilder();
        bodyBuf.append("from ");
        bodyBuf.append("(select t1.fpersonId fpersonid, t1.S" + fieldSn + " , t1.fperiodyear fperiodyear, t1.fperiodmonth fperiodmonth, t1.fcalstate fcalstate , T1.FCURRENCYID, T1.FEXCHANGETABLEID from t_hr_scmpcaltable t1 ");
        bodyBuf.append("inner join (select fpersonId, ftaxUnitId from t_hr_scmpcaltable where fcalschemeId = '" + calschemeInfo.getId().toString() + "'");
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            bodyBuf.append(" and ").append(mainTableRowFilter);
        }
        bodyBuf.append(" and fperiodYear = " + calschemeInfo.getPeriodYear() + " and fperiodMonth = " + calschemeInfo.getPeriodMonth() + " and fcaltime = " + calschemeInfo.getCalTime() + ") ");
        bodyBuf.append("t2 on t1.fpersonId = t2.fpersonId and t1.ftaxUnitId " + cfc + " t2.ftaxUnitId ) t ");
        bodyBuf.append("where t.fcalstate= 20 and ( ");
        bodyBuf.append(this.getPeriodFilter(startYear, startMonth, endYear, endMonth, "t.fperiodyear", "t.fperiodmonth"));
        bodyBuf.append(")");
        StringBuilder sqlBuf = new StringBuilder();
        if (null != calschemeInfo.getCurrency()) {
            Date effdt = calschemeInfo.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calschemeInfo.getBeginDate() : calschemeInfo.getEndDate();
            String targetCurrencyId = calschemeInfo.getCurrency().getId().toString();
            String exchangeTableId = calschemeInfo.getExchangeTable().getId().toString();
            sqlBuf.append(" SELECT T.FPERSONID PERSONID, T.S").append(fieldSn).append(" MONEY, T.FCURRENCYID, T.FEXCHANGETABLEID ");
            sqlBuf.append((CharSequence)bodyBuf);
            sqlBuf.append(" ORDER BY T.FPERSONID ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
                Map<String, BigDecimal> currencyMap = CurrencyUtil.getTargetExchangeRateMap(ctx, exchangeTableId, targetCurrencyId, effdt);
                while (rowSet.next()) {
                    personId = rowSet.getString("PERSONID");
                    String currencyId = rowSet.getString("FCURRENCYID");
                    rate = null != currencyId ? (null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId)) : new BigDecimal(1);
                    BigDecimal money = rowSet.getBigDecimal("MONEY") == null ? new BigDecimal(0) : rowSet.getBigDecimal("MONEY");
                    tempSum = sumMap.get(personId) == null ? money.multiply(rate) : new BigDecimal((Double)sumMap.get(personId)).add(money.multiply(rate));
                    sumMap.put(personId, tempSum.doubleValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        } else {
            sqlBuf.append(" SELECT T.FPERSONID PERSONID, SUM(T.S").append(fieldSn).append(") SUMVAL ");
            sqlBuf.append((CharSequence)bodyBuf);
            sqlBuf.append(" GROUP BY T.FPERSONID");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
                while (rowSet.next()) {
                    personId = rowSet.getString("PERSONID");
                    sumMap.put(personId, rowSet.getDouble("sumVal"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        }
        return sumMap;
    }

    private Map<String, Double> getItemSumSalary(Context ctx, CalSchemeInfo calScheme, String fieldSn, int startYear, int startMonth, int endYear, int endMonth, String mainTableRowFilter) {
        HashMap<String, Double> sumMap = new HashMap<String, Double>();
        StringBuilder sqlBuf = new StringBuilder();
        String personId = null;
        Object oldPersonId = null;
        String targetCurrencyId = null;
        IRowSet rowSet = null;
        BigDecimal tempSum = new BigDecimal(0);
        BigDecimal rate = new BigDecimal(1);
        boolean i = false;
        if (null != calScheme.getCurrency()) {
            targetCurrencyId = calScheme.getCurrency().getId().toString();
            Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
            sqlBuf.append(" SELECT FPERSONID PERSONID, S" + fieldSn + " MONEY, FCURRENCYID, FEXCHANGETABLEID FROM T_HR_SCMPCALTABLE WHERE FCALSTATE= 20 AND (");
            sqlBuf.append(this.getPeriodFilter(startYear, startMonth, endYear, endMonth, "fperiodyear", "fperiodmonth"));
            sqlBuf.append(") ");
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                String personSql = " select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calScheme.getId().toString() + "' and FcalTime = " + calScheme.getCalTime() + " and FperiodYear = " + calScheme.getPeriodYear() + " and FperiodMonth = " + calScheme.getPeriodMonth() + " and " + mainTableRowFilter;
                sqlBuf.append(" AND FPERSONID in (").append(personSql).append(") ");
            }
            sqlBuf.append(" ORDER BY FPERSONID");
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
            if (null != rowSet && rowSet.size() < 1) {
                return sumMap;
            }
            try {
                String exchangeTableId = calScheme.getExchangeTable().getId().toString();
                Map<String, BigDecimal> currencyMap = CurrencyUtil.getTargetExchangeRateMap(ctx, exchangeTableId, targetCurrencyId, effdt);
                while (rowSet.next()) {
                    personId = rowSet.getString("PERSONID");
                    String currencyId = rowSet.getString("FCURRENCYID");
                    rate = null != currencyId ? (null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId)) : new BigDecimal(1);
                    BigDecimal money = rowSet.getBigDecimal("MONEY") == null ? new BigDecimal(0) : rowSet.getBigDecimal("MONEY");
                    tempSum = sumMap.get(personId) == null ? money.multiply(rate) : new BigDecimal((Double)sumMap.get(personId)).add(money.multiply(rate));
                    sumMap.put(personId, tempSum.doubleValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        } else {
            sqlBuf.append("SELECT FPERSONID PERSONID, SUM(S" + fieldSn + ") SUMVAL FROM T_HR_SCMPCALTABLE WHERE FCALSTATE= 20 AND ( ");
            sqlBuf.append(this.getPeriodFilter(startYear, startMonth, endYear, endMonth, "fperiodyear", "fperiodmonth"));
            sqlBuf.append(" ) GROUP BY FPERSONID");
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
            try {
                while (rowSet.next()) {
                    personId = rowSet.getString("PERSONID");
                    double sumVal = rowSet.getDouble("SUMVAL");
                    sumMap.put(personId, sumVal);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        }
        return sumMap;
    }

    private String getPeriodFilter(int beginYear, int beginMonth, int endYear, int endMonth, String year, String month) {
        StringBuffer res = new StringBuffer();
        res.append("(" + year + " = " + beginYear + " and " + month + ">=" + beginMonth + " and " + month + "<=" + endMonth + " and " + year + " = " + endYear + ")");
        res.append("or(" + year + " = " + beginYear + " and " + month + ">=" + beginMonth + " and " + year + " < " + endYear + ")");
        res.append("or(" + year + " > " + beginYear + " and " + year + "<" + endYear + ")");
        res.append("or(" + year + " = " + endYear + " and " + month + "<=" + endMonth + " and " + year + " > " + beginYear + ")");
        return res.toString();
    }
}

