/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeItemCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeItemFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeItemInfo;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.app.integrate.SubmitElementCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitElementFactory;
import com.kingdee.shr.compensation.app.integrate.SubmitElementInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitSchemeType;
import com.kingdee.shr.compensation.util.integrate.IntegrateFunctionUtil;
import com.kingdee.shr.compensation.util.integrate.SubmitCycleHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalFunctionIntegrateService
extends SalaryCalFunction {
    private static final String DEFAULT_CALSCHEMEID = "YvUYBi3h/Ei6MSRBTt2eXf/N8rE=";
    protected final String split_key = "_";
    protected final String ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY = "ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA";
    protected final String SUBMIT_SCHEME_FORMULA_ITEM_LISt_KEY = "SUBMIT_SCHEME_FORMULA_ITEM_LISt_KEY";
    protected static final Map<String, String> FORMULA_DEFINE_LIST_FUNC_MAPPER = new HashMap<String, String>();

    public Set<String> getCalSchemeUsedSubmitFormulaItems(Context ctx, Map tempMap, CalSchemeInfo calSchemeInfo, String calSubmitSchemeNum, String formulaDefine) throws BOSException, SQLException {
        String calSchemeId;
        Map<String, Set<String>> submitFormulaMap;
        String cacheMapKey = calSubmitSchemeNum + "###" + formulaDefine;
        Map map = submitFormulaMap = tempMap.get("SUBMIT_SCHEME_FORMULA_ITEM_LISt_KEY") == null ? new HashMap() : (Map)tempMap.get("SUBMIT_SCHEME_FORMULA_ITEM_LISt_KEY");
        if (submitFormulaMap.containsKey(cacheMapKey)) {
            return (Set)submitFormulaMap.get(cacheMapKey);
        }
        HashMap submitItemNumFieldMap = (HashMap)tempMap.get("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA");
        if (submitItemNumFieldMap == null) {
            submitItemNumFieldMap = new HashMap();
        }
        if ((calSchemeId = calSchemeInfo.getId().toString()) == null || "".equals(calSchemeId)) {
            return (Set)submitFormulaMap.get(cacheMapKey);
        }
        String funcKey = "~" + FORMULA_DEFINE_LIST_FUNC_MAPPER.get(formulaDefine) + "~" + formulaDefine;
        String querySql = "select FID,FEXPRESS from T_HR_SCalFormula where FISCAL = 1 and FCalSchemeID = '" + calSchemeId + "' and FListFunc like '%" + funcKey + "%'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        Map schemeItemMap = (Map)submitItemNumFieldMap.get(calSubmitSchemeNum);
        while (rowSet.next()) {
            String express = rowSet.getString("FEXPRESS");
            this.getUsedSubmitItemOfFormula(submitFormulaMap, schemeItemMap, express, calSubmitSchemeNum, formulaDefine, cacheMapKey);
        }
        tempMap.put("SUBMIT_SCHEME_FORMULA_ITEM_LISt_KEY", submitFormulaMap);
        return (Set)submitFormulaMap.get(cacheMapKey);
    }

    public boolean getUsedSubmitItemOfFormula(Map<String, Set<String>> result, Map<String, Integer> schemeItemMap, String express, String calSubmitSchemeNum, String formulaDefine, String cacheMapKey) {
        if (express == null || "".equals(express.trim())) {
            return false;
        }
        String formulaDefineReal = formulaDefine + "(";
        int lastIndexOf = express.lastIndexOf(formulaDefineReal);
        if (lastIndexOf < 0) {
            return false;
        }
        String funExpress = express.substring(lastIndexOf + formulaDefineReal.length());
        String tempExpress = express.substring(0, lastIndexOf);
        String[] split = funExpress.split(",");
        String expSchemeNum = split[0].trim().replace("\"", "");
        if (expSchemeNum.equals(calSubmitSchemeNum)) {
            String split1 = split[1].trim();
            if ("FunGetTransferSalaryDataForCycle".equals(formulaDefine) && split1.contains("\")")) {
                int firstIndex = split1.indexOf(")");
                split1 = split1.substring(0, firstIndex);
            }
            String expItemNum = split1.replace("\"", "");
            Set<String> itemSet = result.get(cacheMapKey);
            if (null == itemSet) {
                itemSet = new HashSet<String>();
                result.put(cacheMapKey, itemSet);
            }
            if (schemeItemMap.containsKey(expItemNum)) {
                itemSet.add(expItemNum);
            }
        }
        return this.getUsedSubmitItemOfFormula(result, schemeItemMap, tempExpress, calSubmitSchemeNum, formulaDefine, cacheMapKey);
    }

    public Map<String, Map<String, Integer>> getAllSubmitItemNumFieldSn() throws BOSException {
        Context ctx = Tools.getInstance().getCtx();
        CalSubmitSchemeItemCollection collection = CalSubmitSchemeItemFactory.getLocalInstance(ctx).getCalSubmitSchemeItemCollection("select calSubmitItem.number, calSubmitItem.fieldSn, calSubmitScheme.number");
        HashMap<String, Map<String, Integer>> resultMap = new HashMap<String, Map<String, Integer>>();
        for (int i = 0; i < collection.size(); ++i) {
            CalSubmitSchemeItemInfo info = collection.get(i);
            String schemeNumber = info.getCalSubmitScheme().getNumber();
            Map map = resultMap.computeIfAbsent(schemeNumber, k -> new HashMap());
            map.put(info.getCalSubmitItem().getNumber(), info.getCalSubmitItem().getFieldSn());
        }
        return resultMap;
    }

    public double getTransferSalaryData(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String calSubmitItem, String company, double needSubOrg, String beginDate, String endDate) throws SQLException, BOSException {
        HashMap salaryMap;
        String curCalSchemeId;
        String key = "TransferSalary:" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate;
        String relyKey = "TransferSalary-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate + "-Rely";
        String string = curCalSchemeId = calScheme.getId() == null ? "" : calScheme.getId().toString();
        if (tempMap.get(key) == null) {
            if (tempMap.get("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA") == null) {
                tempMap.put("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA", this.getAllSubmitItemNumFieldSn());
            }
            String personFilter = IntegrateFunctionUtil.getPersonFilterSql(calScheme, company, needSubOrg, beginDate, endDate, mainTableRowFilter);
            HashMap<String, Object> methodParamMap = new HashMap<String, Object>();
            methodParamMap.put("calSubmitScheme", calSubmitScheme);
            methodParamMap.put("calSubmitItem", calSubmitItem);
            methodParamMap.put("personFilter", personFilter);
            methodParamMap.put("key", key);
            methodParamMap.put("relyKey", relyKey);
            methodParamMap.put("isNumber", true);
            methodParamMap.put("isCycleScheme", false);
            methodParamMap.put("formulaDefine", "FunGetTransferSalaryData");
            methodParamMap.put("calSchemeInfo", calScheme);
            this.combineTransSalaryDataNew(tempMap, currencyMap, methodParamMap, curCalSchemeId, SubmitSchemeType.NORMAL_SUBMIT);
        }
        String calItem = (String)paramMap.get("CALITEM");
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        HashMap submitItemSalaryMap = (HashMap)tempMap.get(key);
        if (submitItemSalaryMap == null) {
            submitItemSalaryMap = new HashMap();
        }
        if ((salaryMap = (HashMap)submitItemSalaryMap.get(calSubmitItem)) == null) {
            salaryMap = new HashMap();
        }
        Context ctx = Tools.getInstance().getCtx();
        IntegrateFunctionUtil.putSubmitDataToParamNew(ctx, paramMap, tempMap, calItem, relyKey, calSubmitItem);
        if (salaryMap.containsKey(personId)) {
            return salaryMap.get(personId) == null ? 0.0 : ((BigDecimal)salaryMap.get(personId)).doubleValue();
        }
        return 0.0;
    }

    public void combineTransSalaryDataNew(HashMap tempMap, Map<String, BigDecimal> currencyMap, Map<String, Object> methodParamMap, String curCalSchemeId, SubmitSchemeType submitSchemeType) throws SQLException, BOSException {
        CalSubmitItemInfo isExistsItem;
        Set<String> submitItemNumSetOfFormula;
        String calSubmitScheme = (String)methodParamMap.get("calSubmitScheme");
        String calSubmitItem = (String)methodParamMap.get("calSubmitItem");
        String personFilter = (String)methodParamMap.get("personFilter");
        String key = (String)methodParamMap.get("key");
        String relyKey = (String)methodParamMap.get("relyKey");
        Boolean isNumber = (Boolean)methodParamMap.get("isNumber");
        Boolean isCycleScheme = (Boolean)methodParamMap.get("isCycleScheme");
        Boolean isDate = (Boolean)methodParamMap.get("isDate");
        Boolean dateTypeToDay = (Boolean)methodParamMap.get("dateTypeToDay");
        String formulaDefine = (String)methodParamMap.get("formulaDefine");
        CalSchemeInfo calSchemeInfo = (CalSchemeInfo)methodParamMap.get("calSchemeInfo");
        Context ctx = Tools.getInstance().getCtx();
        String calItem = (String)this.paramMap.get("CALITEM");
        Map<String, Map<String, Integer>> submitItemSnMap = (Map<String, Map<String, Integer>>)tempMap.get("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA");
        if (submitItemSnMap == null) {
            submitItemSnMap = this.getAllSubmitItemNumFieldSn();
            tempMap.put("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA", submitItemSnMap);
        }
        if ((submitItemNumSetOfFormula = this.getCalSchemeUsedSubmitFormulaItems(ctx, tempMap, calSchemeInfo, calSubmitScheme, formulaDefine)) == null || submitItemNumSetOfFormula.isEmpty()) {
            submitItemNumSetOfFormula = new HashSet<String>();
        }
        if (null == (isExistsItem = IntegrateFunctionUtil.initSubmitItem(ctx, tempMap, calSubmitItem))) {
            HashMap salaryMap = new HashMap();
            HashMap submitItemSalaryMap = new HashMap();
            submitItemSalaryMap.put(calSubmitItem, salaryMap);
            tempMap.put(key, submitItemSalaryMap);
            return;
        }
        if (!submitItemNumSetOfFormula.contains(calSubmitItem)) {
            submitItemNumSetOfFormula.add(calSubmitItem);
        }
        String schemeTableName = IntegrateFunctionUtil.initSubmitSchemeTable(ctx, tempMap, calSubmitScheme, submitSchemeType);
        String submitSchemeId = IntegrateFunctionUtil.getSubmitSchemeInfo(ctx, tempMap, calSubmitScheme, submitSchemeType);
        if (null == schemeTableName) {
            HashMap salaryMap = new HashMap();
            HashMap submitItemSalaryMap = new HashMap();
            submitItemSalaryMap.put(calSubmitItem, salaryMap);
            tempMap.put(key, submitItemSalaryMap);
            return;
        }
        StringBuilder sFieldSnBuilder = new StringBuilder();
        ArrayList<String> itemNumList = new ArrayList<String>();
        Iterator<String> iterator = submitItemNumSetOfFormula.iterator();
        Map<String, Integer> schemeItemMap = submitItemSnMap.get(calSubmitScheme);
        while (iterator.hasNext()) {
            String itemNum = iterator.next();
            Integer sn = schemeItemMap.get(itemNum);
            if (sn == null) continue;
            itemNumList.add(itemNum);
            sFieldSnBuilder.append(",S").append(sn);
        }
        String fieldItemSns = sFieldSnBuilder.toString();
        if (fieldItemSns == null || "".equals(fieldItemSns)) {
            HashMap salaryMap = new HashMap();
            HashMap submitItemSalaryMap = new HashMap();
            submitItemSalaryMap.put(calSubmitItem, salaryMap);
            tempMap.put(key, submitItemSalaryMap);
            return;
        }
        fieldItemSns = fieldItemSns.substring(1);
        StringBuilder str = new StringBuilder();
        str.append(" SELECT CASE WHEN FLASTUPDATETIME IS NULL THEN FCREATETIME ELSE FLASTUPDATETIME END AS FLASTUPDATETIME, FPERSONID,FSALARYPERIOD,FID,FCURRENCYID,").append(fieldItemSns);
        str.append(" FROM ").append(schemeTableName);
        str.append(personFilter);
        str.append(" AND (FCALSCHEMEID =  'YvUYBi3h/Ei6MSRBTt2eXf/N8rE=' or FCALSCHEMEID = '").append(curCalSchemeId).append("')");
        if (submitSchemeType == SubmitSchemeType.TIMEPIECESUN) {
            str.append(" AND FBillID in (select FID from T_HR_SBatchSubmitShemeBill where FSubmitSchemeID = '").append(submitSchemeId).append("') ");
        }
        if (isCycleScheme.booleanValue()) {
            str.append(" ORDER BY FTransYear desc,FTransMonth desc, FTransTime desc,FPERSONID, FEFFECTDATE DESC, FCREATETIME DESC, FLASTUPDATETIME DESC  ");
        } else if (!isNumber.booleanValue()) {
            str.append(" ORDER BY FPERSONID, FEFFECTDATE DESC, FCREATETIME DESC, FLASTUPDATETIME DESC ");
        }
        List<Object> rowSets = new ArrayList();
        try {
            rowSets = this.executeQueryPaging(ctx, str.toString());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat yearMonthDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Map<String, BigDecimal>> submitItemSalaryMap = new HashMap<String, Map<String, BigDecimal>>();
        String dbType = ContextUtil.getDbType((Context)ctx);
        HashMap submitItemRelyMap = new HashMap();
        for (int i = 0; i < itemNumList.size(); ++i) {
            Set<String> schemeItemSet;
            calSubmitItem = (String)itemNumList.get(i);
            Map<String, BigDecimal> salaryMap = submitItemSalaryMap.get(calSubmitItem) == null ? new HashMap() : (Map)submitItemSalaryMap.get(calSubmitItem);
            CalSubmitItemInfo itemInfo = IntegrateFunctionUtil.initSubmitItem(ctx, tempMap, calSubmitItem);
            if (null == itemInfo) {
                salaryMap = new HashMap();
                submitItemSalaryMap.put(calSubmitItem, salaryMap);
                continue;
            }
            String itemSn = "S" + itemInfo.getFieldSn();
            String itemDataTypeValue = itemInfo.getDataType().getValue();
            DecimalFormat df = new DecimalFormat(null == itemInfo.getDataDot() ? "0" : itemInfo.getDataDot().toString());
            DateTypeEnum dateTypeEnum = itemInfo.getDateType();
            if (itemDataTypeValue != null && "2".equals(itemDataTypeValue)) {
                isDate = true;
                if (dateTypeEnum != null && 10 == dateTypeEnum.getValue()) {
                    dateTypeToDay = true;
                }
            } else {
                isDate = false;
            }
            if (!(schemeItemSet = IntegrateFunctionUtil.initSchemeItem(ctx, tempMap, calSubmitScheme, submitSchemeType)).contains(itemInfo.getFieldSn() + "")) {
                salaryMap = new HashMap();
                submitItemSalaryMap.put(calSubmitItem, salaryMap);
                continue;
            }
            for (IRowSet iRowSet : rowSets) {
                try {
                    String moneyStr = "";
                    while (iRowSet.next()) {
                        java.util.Date utilDate;
                        BigDecimal rate;
                        BigDecimal money;
                        String currencyId;
                        String personId = iRowSet.getString("FPersonID");
                        HashMap<String, Object> personRelyMap = new HashMap<String, Object>();
                        personRelyMap.put("SUBMITITEMID", null);
                        personRelyMap.put("SUBMITITEMTABLE", null);
                        if (isCycleScheme.booleanValue()) {
                            if (isNumber.booleanValue()) {
                                currencyId = iRowSet.getString("FCURRENCYID");
                                money = iRowSet.getBigDecimal(itemSn) == null ? BigDecimal.ZERO : iRowSet.getBigDecimal(itemSn);
                                personRelyMap.put("SUBMITMONEY", df.format(money.doubleValue()));
                                BigDecimal bigDecimal = rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                                if (salaryMap.containsKey(personId)) continue;
                                salaryMap.put(personId, money.multiply(rate));
                            } else {
                                if (isDate != null && isDate.booleanValue()) {
                                    Date date = iRowSet.getDate(itemSn);
                                    if (date != null) {
                                        utilDate = new java.util.Date(date.getTime());
                                        moneyStr = dateTypeToDay != null && dateTypeToDay.booleanValue() ? yearMonthDateFormat.format(utilDate) : yearMonthFormat.format(utilDate);
                                    } else {
                                        moneyStr = "";
                                    }
                                } else {
                                    String string = moneyStr = null == iRowSet.getString(itemSn) ? "" : iRowSet.getString(itemSn);
                                    if (CalSubmitItemDataType.F7.equals((Object)itemInfo.getDataType())) {
                                        Map map = (Map)tempMap.get("CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_VAL_" + calSubmitItem);
                                        moneyStr = (String)map.get(moneyStr);
                                    }
                                    if ("0".equals(itemDataTypeValue)) {
                                        boolean isSQLServerDB;
                                        money = iRowSet.getBigDecimal(itemSn);
                                        moneyStr = money == null ? "" : ((isSQLServerDB = "MS SQL Server".equalsIgnoreCase(dbType)) ? df.format(money.doubleValue()) : (null == iRowSet.getString(itemSn) ? "" : iRowSet.getString(itemSn)));
                                    }
                                }
                                personRelyMap.put("SUBMITMONEY", moneyStr);
                                if (salaryMap.containsKey(personId)) continue;
                                salaryMap.put(personId, (BigDecimal)((Object)moneyStr));
                            }
                        } else if (isNumber.booleanValue()) {
                            currencyId = iRowSet.getString("FCURRENCYID");
                            money = iRowSet.getBigDecimal(itemSn) == null ? BigDecimal.ZERO : iRowSet.getBigDecimal(itemSn);
                            personRelyMap.put("SUBMITMONEY", df.format(money.doubleValue()));
                            rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                            BigDecimal sum = null == salaryMap.get(personId) ? money.multiply(rate) : ((BigDecimal)salaryMap.get(personId)).add(money.multiply(rate));
                            salaryMap.put(personId, sum);
                        } else {
                            if (isDate != null && isDate.booleanValue()) {
                                Date date = iRowSet.getDate(itemSn);
                                if (date != null) {
                                    utilDate = new java.util.Date(date.getTime());
                                    moneyStr = dateTypeToDay != null && dateTypeToDay.booleanValue() ? yearMonthDateFormat.format(utilDate) : yearMonthFormat.format(utilDate);
                                } else {
                                    moneyStr = "";
                                }
                            } else {
                                String string = moneyStr = null == iRowSet.getString(itemSn) ? "" : iRowSet.getString(itemSn);
                                if (CalSubmitItemDataType.F7.equals((Object)itemInfo.getDataType())) {
                                    Map map = (Map)tempMap.get("CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_VAL_" + calSubmitItem);
                                    moneyStr = (String)map.get(moneyStr);
                                }
                                if ("0".equals(itemDataTypeValue)) {
                                    boolean isSQLServerDB;
                                    money = iRowSet.getBigDecimal(itemSn);
                                    moneyStr = money == null ? "" : ((isSQLServerDB = "MS SQL Server".equalsIgnoreCase(dbType)) ? df.format(money.doubleValue()) : (null == iRowSet.getString(itemSn) ? "" : iRowSet.getString(itemSn)));
                                }
                            }
                            personRelyMap.put("SUBMITMONEY", moneyStr);
                            if (salaryMap.containsKey(personId)) continue;
                            salaryMap.put(personId, (BigDecimal)((Object)moneyStr));
                        }
                        personRelyMap.put("SUBMITTABLE", schemeTableName);
                        personRelyMap.put("SUBMITTABLEID", iRowSet.getString("FID"));
                        personRelyMap.put("CALITEM", calItem);
                        personRelyMap.put("SUBMITNUMBER", calSubmitItem);
                        personRelyMap.put("ISBASIC", 0);
                        HashMap relyMap = (HashMap)submitItemRelyMap.get(calSubmitItem);
                        if (relyMap == null) {
                            relyMap = new HashMap();
                        }
                        List relyList = relyMap.containsKey(personId) ? (List)relyMap.get(personId) : new ArrayList();
                        relyList.add(personRelyMap);
                        relyMap.put(personId, relyList);
                        submitItemRelyMap.put(calSubmitItem, relyMap);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                submitItemSalaryMap.put(calSubmitItem, salaryMap);
                iRowSet.beforeFirst();
            }
        }
        tempMap.put(key, submitItemSalaryMap);
        tempMap.put(relyKey, submitItemRelyMap);
    }

    public String getTransferSalaryDataString(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String calSubmitItem, String company, double needSubOrg, String beginDate, String endDate) throws SQLException, BOSException {
        HashMap salaryMap;
        String curCalSchemeId;
        String key = "TransferSalaryDataString-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate;
        String relyKey = "TransferSalaryDataString-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate + "-Rely";
        String string = curCalSchemeId = calScheme.getId() == null ? "" : calScheme.getId().toString();
        if (tempMap.get(key) == null) {
            if (tempMap.get("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA") == null) {
                tempMap.put("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA", this.getAllSubmitItemNumFieldSn());
            }
            String personFilter = IntegrateFunctionUtil.getPersonFilterSql(calScheme, company, needSubOrg, beginDate, endDate, mainTableRowFilter);
            HashMap<String, Object> methodParamMap = new HashMap<String, Object>();
            methodParamMap.put("calSubmitScheme", calSubmitScheme);
            methodParamMap.put("calSubmitItem", calSubmitItem);
            methodParamMap.put("personFilter", personFilter);
            methodParamMap.put("key", key);
            methodParamMap.put("relyKey", relyKey);
            methodParamMap.put("isNumber", false);
            methodParamMap.put("isCycleScheme", false);
            methodParamMap.put("formulaDefine", "FunGetTransferSalaryDataString");
            methodParamMap.put("calSchemeInfo", calScheme);
            this.combineTransSalaryDataNew(tempMap, this.currencyMap, methodParamMap, curCalSchemeId, SubmitSchemeType.NORMAL_SUBMIT);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String calItem = (String)paramMap.get("CALITEM");
        HashMap submitItemSalaryMap = (HashMap)tempMap.get(key);
        if (submitItemSalaryMap == null) {
            submitItemSalaryMap = new HashMap();
        }
        if ((salaryMap = (HashMap)submitItemSalaryMap.get(calSubmitItem)) == null) {
            salaryMap = new HashMap();
        }
        Context ctx = Tools.getInstance().getCtx();
        IntegrateFunctionUtil.putSubmitDataToParamNew(ctx, paramMap, tempMap, calItem, relyKey, calSubmitItem);
        if (salaryMap.containsKey(personId)) {
            Object salaryObj = salaryMap.get(personId);
            if (salaryObj instanceof BigDecimal) {
                return ((BigDecimal)salaryObj).toString();
            }
            if (salaryObj == null) {
                return "";
            }
            return (String)salaryObj;
        }
        return "";
    }

    public String getTransferSalaryDataForCycle(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String calSubmitItem) {
        String curCalSchemeId = calScheme.getId() == null ? "" : calScheme.getId().toString();
        String key = "TransferSalaryDataForCycle:" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + calSubmitItem;
        String relyKey = "TransferSalaryDataForCycle-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + calSubmitItem + "-Rely";
        String calItem = (String)paramMap.get("CALITEM");
        Context ctx = Tools.getInstance().getCtx();
        CalSubmitItemInfo itemInfo = IntegrateFunctionUtil.initSubmitItem(ctx, tempMap, calSubmitItem);
        if (null == itemInfo) {
            return "";
        }
        CalSubmitItemDataType dataType = itemInfo.getDataType();
        boolean isNumItem = false;
        boolean isDate = false;
        boolean dateTypeToDay = false;
        DateTypeEnum dateTypeEnum = itemInfo.getDateType();
        if (dataType != null && "0".equals(dataType.getValue())) {
            isNumItem = true;
        } else {
            if (dataType != null && "2".equals(dataType.getValue())) {
                isDate = true;
                if (dateTypeEnum != null && 10 == dateTypeEnum.getValue()) {
                    dateTypeToDay = true;
                }
            }
            isNumItem = false;
        }
        if (tempMap.get(key) == null) {
            String schemeTableName = IntegrateFunctionUtil.initSubmitSchemeTable(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (null == schemeTableName) {
                if (isNumItem) {
                    return "0.00";
                }
                return "";
            }
            String personFilter = this.getPersonFilterSqlForCycle(calScheme, mainTableRowFilter);
            HashMap<String, Object> methodParamMap = new HashMap<String, Object>();
            methodParamMap.put("calSubmitScheme", calSubmitScheme);
            methodParamMap.put("calSubmitItem", calSubmitItem);
            methodParamMap.put("personFilter", personFilter);
            methodParamMap.put("key", key);
            methodParamMap.put("relyKey", relyKey);
            methodParamMap.put("isNumber", isNumItem);
            methodParamMap.put("isCycleScheme", true);
            methodParamMap.put("isDate", isDate);
            methodParamMap.put("dateTypeToDay", dateTypeToDay);
            this.combineTransSalaryData(tempMap, currencyMap, methodParamMap, curCalSchemeId);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        Map salaryMap = (Map)tempMap.get(key);
        IntegrateFunctionUtil.putSubmitDataToParam(ctx, paramMap, tempMap, calItem, relyKey);
        if (isNumItem) {
            return salaryMap.get(personId) != null ? "" + ((BigDecimal)salaryMap.get(personId)).doubleValue() : "0.00";
        }
        return salaryMap.get(personId) != null ? salaryMap.get(personId).toString() : "";
    }

    private String getPersonFilterSqlForCycle(CalSchemeInfo calScheme, String mainTableRowFilter) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        java.util.Date endDate = calScheme.getEndDate();
        Calendar endDateCalendar = Calendar.getInstance();
        endDateCalendar.setTime(endDate);
        endDateCalendar.set(11, 23);
        endDateCalendar.set(12, 59);
        endDateCalendar.set(13, 59);
        StringBuilder personRangeSql = new StringBuilder();
        personRangeSql.append(" select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '").append(calschemeid).append("' ");
        personRangeSql.append(" and FperiodYear = ").append(periodYear);
        personRangeSql.append(" and FperiodMonth = ").append(periodMonth);
        personRangeSql.append(" and FcalTime = ").append(calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            personRangeSql.append(" and ").append(mainTableRowFilter);
        }
        return " WHERE  FPERSONID IN ( " + personRangeSql + " ) AND FCALSTATE = '03'  AND EXISTS (SELECT 1 FROM T_HR_SubmitEntryCycleExtend cycleExtend WHERE cycleExtend.FEntryId = entry.FID AND " + this.getTransferSalaryPeriodFilterSql(calScheme) + ")";
    }

    protected String getTransferSalaryPeriodFilterSql(CalSchemeInfo calScheme) {
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String calPeriod = SubmitCycleHelper.getTransferSalaryFormatDateStr(periodYear, periodMonth, calTime);
        return "(cycleExtend.FSalaryStartPeriod <= '" + calPeriod + "' AND (CASE WHEN FSalaryExpirePeriod IS NULL OR FSalaryExpirePeriod='' THEN FSalaryEndPeriod ELSE FSalaryExpirePeriod END) >= '" + calPeriod + "')";
    }

    private void combineTransSalaryData(HashMap tempMap, Map<String, BigDecimal> currencyMap, Map<String, Object> methodParamMap, String curCalSchemeId) {
        Set<String> schemeItemSet;
        String calSubmitScheme = (String)methodParamMap.get("calSubmitScheme");
        String calSubmitItem = (String)methodParamMap.get("calSubmitItem");
        String personFilter = (String)methodParamMap.get("personFilter");
        String key = (String)methodParamMap.get("key");
        String relyKey = (String)methodParamMap.get("relyKey");
        Boolean isNumber = (Boolean)methodParamMap.get("isNumber");
        Boolean isCycleScheme = (Boolean)methodParamMap.get("isCycleScheme");
        Boolean isDate = (Boolean)methodParamMap.get("isDate");
        Boolean dateTypeToDay = (Boolean)methodParamMap.get("dateTypeToDay");
        Context ctx = Tools.getInstance().getCtx();
        HashMap<String, Object> salaryMap = new HashMap<String, Object>();
        HashMap relyMap = new HashMap();
        List relyList = new ArrayList();
        String calItem = (String)this.paramMap.get("CALITEM");
        String schemeTableName = IntegrateFunctionUtil.initSubmitSchemeTable(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
        if (null == schemeTableName) {
            tempMap.put(key, salaryMap);
            return;
        }
        CalSubmitItemInfo itemInfo = IntegrateFunctionUtil.initSubmitItem(ctx, tempMap, calSubmitItem);
        if (null == itemInfo) {
            tempMap.put(key, salaryMap);
            return;
        }
        String itemSn = "S" + itemInfo.getFieldSn();
        String itemDatatTypeValue = itemInfo.getDataType().getValue();
        DecimalFormat df = new DecimalFormat(null == itemInfo.getDataDot() ? "0" : itemInfo.getDataDot().toString());
        DateTypeEnum dateTypeEnum = itemInfo.getDateType();
        if (itemDatatTypeValue != null && "2".equals(itemDatatTypeValue)) {
            isDate = true;
            if (dateTypeEnum != null && 10 == dateTypeEnum.getValue()) {
                dateTypeToDay = true;
            }
        }
        if (!(schemeItemSet = IntegrateFunctionUtil.initSchemeItem(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT)).contains(itemInfo.getFieldSn() + "")) {
            tempMap.put(key, salaryMap);
            return;
        }
        StringBuilder str = new StringBuilder();
        str.append(" SELECT CASE WHEN FLASTUPDATETIME IS NULL THEN FCREATETIME ELSE FLASTUPDATETIME END AS FLASTUPDATETIME, ").append("FPERSONID,FSALARYPERIOD,FID,FCURRENCYID,").append(itemSn).append(" FROM ").append(schemeTableName).append(" entry ").append(personFilter);
        str.append(" AND (FCALSCHEMEID =  'YvUYBi3h/Ei6MSRBTt2eXf/N8rE=' or FCALSCHEMEID = '").append(curCalSchemeId).append("')");
        if (isCycleScheme.booleanValue()) {
            str.append(" ORDER BY FTransYear desc,FTransMonth desc, FTransTime desc,FPERSONID, FEFFECTDATE DESC, FCREATETIME DESC, FLASTUPDATETIME DESC  ");
        } else if (!isNumber.booleanValue()) {
            str.append(" ORDER BY FPERSONID, FEFFECTDATE DESC, FCREATETIME DESC, FLASTUPDATETIME DESC ");
        }
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat yearMonthDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            String moneyStr = "";
            while (rowSet.next()) {
                java.util.Date utilDate;
                BigDecimal rate;
                BigDecimal money;
                String currencyId;
                String personId = rowSet.getString("FPersonID");
                HashMap<String, Object> personRelyMap = new HashMap<String, Object>();
                personRelyMap.put("SUBMITITEMID", null);
                personRelyMap.put("SUBMITITEMTABLE", null);
                if (isCycleScheme.booleanValue()) {
                    if (isNumber.booleanValue()) {
                        currencyId = rowSet.getString("FCURRENCYID");
                        money = rowSet.getBigDecimal(itemSn) == null ? BigDecimal.ZERO : rowSet.getBigDecimal(itemSn);
                        personRelyMap.put("SUBMITMONEY", df.format(money.doubleValue()));
                        BigDecimal bigDecimal = rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                        if (salaryMap.containsKey(personId)) continue;
                        salaryMap.put(personId, money.multiply(rate));
                    } else {
                        if (isDate != null && isDate.booleanValue()) {
                            Date date = rowSet.getDate(itemSn);
                            if (date != null) {
                                utilDate = new java.util.Date(date.getTime());
                                moneyStr = dateTypeToDay != null && dateTypeToDay.booleanValue() ? yearMonthDateFormat.format(utilDate) : yearMonthFormat.format(utilDate);
                            } else {
                                moneyStr = "";
                            }
                        } else {
                            String string = moneyStr = null == rowSet.getString(itemSn) ? "" : rowSet.getString(itemSn);
                            if (CalSubmitItemDataType.F7.equals((Object)itemInfo.getDataType())) {
                                Map map = (Map)tempMap.get("CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_VAL_" + calSubmitItem);
                                moneyStr = (String)map.get(moneyStr);
                            }
                            if ("0".equals(itemDatatTypeValue)) {
                                boolean isSQLServerDB;
                                money = rowSet.getBigDecimal(itemSn);
                                moneyStr = money == null ? "" : ((isSQLServerDB = "MS SQL Server".equalsIgnoreCase(ContextUtil.getDbType((Context)ctx))) ? df.format(money.doubleValue()) : (null == rowSet.getString(itemSn) ? "" : rowSet.getString(itemSn)));
                            }
                        }
                        personRelyMap.put("SUBMITMONEY", moneyStr);
                        if (salaryMap.containsKey(personId)) continue;
                        salaryMap.put(personId, moneyStr);
                    }
                } else if (isNumber.booleanValue()) {
                    currencyId = rowSet.getString("FCURRENCYID");
                    money = rowSet.getBigDecimal(itemSn) == null ? BigDecimal.ZERO : rowSet.getBigDecimal(itemSn);
                    personRelyMap.put("SUBMITMONEY", df.format(money.doubleValue()));
                    rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                    BigDecimal sum = null == salaryMap.get(personId) ? money.multiply(rate) : ((BigDecimal)salaryMap.get(personId)).add(money.multiply(rate));
                    salaryMap.put(personId, sum);
                } else {
                    if (isDate != null && isDate.booleanValue()) {
                        Date date = rowSet.getDate(itemSn);
                        if (date != null) {
                            utilDate = new java.util.Date(date.getTime());
                            moneyStr = dateTypeToDay != null && dateTypeToDay.booleanValue() ? yearMonthDateFormat.format(utilDate) : yearMonthFormat.format(utilDate);
                        } else {
                            moneyStr = "";
                        }
                    } else {
                        String string = moneyStr = null == rowSet.getString(itemSn) ? "" : rowSet.getString(itemSn);
                        if (CalSubmitItemDataType.F7.equals((Object)itemInfo.getDataType())) {
                            Map map = (Map)tempMap.get("CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_VAL_" + calSubmitItem);
                            moneyStr = (String)map.get(moneyStr);
                        }
                        if ("0".equals(itemDatatTypeValue)) {
                            boolean isSQLServerDB;
                            money = rowSet.getBigDecimal(itemSn);
                            moneyStr = money == null ? "" : ((isSQLServerDB = "MS SQL Server".equalsIgnoreCase(ContextUtil.getDbType((Context)ctx))) ? df.format(money.doubleValue()) : (null == rowSet.getString(itemSn) ? "" : rowSet.getString(itemSn)));
                        }
                    }
                    personRelyMap.put("SUBMITMONEY", moneyStr);
                    if (salaryMap.containsKey(personId)) continue;
                    salaryMap.put(personId, moneyStr);
                }
                personRelyMap.put("SUBMITTABLE", schemeTableName);
                personRelyMap.put("SUBMITTABLEID", rowSet.getString("FID"));
                personRelyMap.put("CALITEM", calItem);
                personRelyMap.put("SUBMITNUMBER", calSubmitItem);
                personRelyMap.put("ISBASIC", 0);
                relyList = relyMap.containsKey(personId) ? (List)relyMap.get(personId) : new ArrayList();
                relyList.add(personRelyMap);
                relyMap.put(personId, relyList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tempMap.put(key, salaryMap);
        tempMap.put(relyKey, relyMap);
    }

    public static List<String> getCalShemeTableName(Context ctx, String calSubmitSchemeNum, String calSubmitItemNum) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "Select n.FCalShemeTableName, m.fieldSn  from  T_HR_SCalSubmitScheme e  inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID = e.fid   inner join T_HR_SCalSubmitSchemeItem sm on sm.FCalSubmitSchemeID = e.fid   inner join T_HR_SCalSubmitItem m on m.fid = sm.FCalSubmitItemID  where e.FNumber = '" + calSubmitSchemeNum + "' and m.FNumber =  '" + calSubmitItemNum + "'  ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                list.add(rs.getString("FCalShemeTableName"));
                list.add("S" + rs.getString("fieldSn"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public SubmitElementInfo initElementItem(Context ctx, HashMap tempMap, String elementItemNum) {
        SubmitElementInfo submitElementInfo;
        String key = "INITELEMENTITEM_SERVICE_SUBMITITEM";
        Map<String, SubmitElementInfo> itemMap = new HashMap();
        if (null == tempMap.get(key)) {
            SubmitElementCollection itemColl = null;
            try {
                itemColl = SubmitElementFactory.getLocalInstance(ctx).getSubmitElementCollection("select id, number, name ");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (itemColl != null) {
                for (int i = 0; i < itemColl.size(); ++i) {
                    submitElementInfo = itemColl.get(i);
                    itemMap.put(submitElementInfo.getNumber(), submitElementInfo);
                }
            }
            tempMap.put(key, itemMap);
        } else {
            itemMap = (Map)tempMap.get(key);
        }
        submitElementInfo = (SubmitElementInfo)itemMap.get(elementItemNum);
        if (null == submitElementInfo) {
            return null;
        }
        return (SubmitElementInfo)itemMap.get(elementItemNum);
    }

    public double getFillterSubmitData(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String elementItemNum, String valueItem, String company, double needSubOrg, String beginDate, String endDate) {
        String personId;
        Context ctx = Tools.getInstance().getCtx();
        String curCalSchemeId = calScheme.getId() == null ? "" : calScheme.getId().toString();
        String key = "FillterSubmitData-" + calScheme.getNumber() + "-" + calSubmitScheme + "--" + valueItem + "-" + elementItemNum + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate;
        String relyKey = "FillterSubmitData-" + calScheme.getNumber() + "-" + calSubmitScheme + "--" + valueItem + "-" + elementItemNum + "-" + company + "-" + needSubOrg + "-" + beginDate + "-" + endDate + "-Rely";
        Map<String, BigDecimal> salaryMap = new HashMap();
        HashMap relyMap = new HashMap();
        String calItem = (String)paramMap.get("CALITEM");
        List relyList = new ArrayList();
        if (tempMap.get(key) == null) {
            StringBuilder str = new StringBuilder();
            String entryTableName = IntegrateFunctionUtil.initSubmitSchemeTable(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (null == entryTableName) {
                tempMap.put(key, salaryMap);
                return 0.0;
            }
            SubmitElementInfo elementInfo = this.initElementItem(ctx, tempMap, elementItemNum);
            if (null == elementInfo) {
                tempMap.put(key, salaryMap);
                return 0.0;
            }
            String elementId = elementInfo.getId().toString();
            CalSubmitItemInfo valueItemInfo = IntegrateFunctionUtil.initSubmitItem(ctx, tempMap, valueItem);
            if (null == valueItemInfo) {
                tempMap.put(key, salaryMap);
                return 0.0;
            }
            String valueItemSn = "S" + valueItemInfo.getFieldSn();
            DecimalFormat df = new DecimalFormat(valueItemInfo.getDataDot().toString());
            Set<String> schemeItemSet = IntegrateFunctionUtil.initSchemeItem(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (!schemeItemSet.contains(valueItemInfo.getFieldSn() + "")) {
                tempMap.put(key, salaryMap);
                return 0.0;
            }
            String personFilterSql = IntegrateFunctionUtil.getPersonFilterSql(calScheme, company, needSubOrg, beginDate, endDate, mainTableRowFilter);
            str = new StringBuilder();
            str.append("SELECT FPERSONID,FSALARYPERIOD,FID,FCURRENCYID,").append(valueItemSn);
            str.append(" FROM ").append(entryTableName);
            str.append(personFilterSql);
            str.append(" AND FSubmitElementID ").append(" = '").append(elementId).append("'");
            str.append(" AND (FCALSCHEMEID =  'YvUYBi3h/Ei6MSRBTt2eXf/N8rE=' or FCALSCHEMEID = '").append(curCalSchemeId).append("')");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    personId = rowSet.getString("FPersonID");
                    String currencyId = rowSet.getString("FCURRENCYID");
                    BigDecimal money = rowSet.getBigDecimal(valueItemSn) == null ? BigDecimal.ZERO : rowSet.getBigDecimal(valueItemSn);
                    HashMap<String, Object> personRelyMap = new HashMap<String, Object>();
                    personRelyMap.put("SUBMITITEMID", elementId);
                    personRelyMap.put("SUBMITITEMTABLE", "T_HR_SSubmitElement");
                    personRelyMap.put("SUBMITMONEY", df.format(money.doubleValue()));
                    personRelyMap.put("SUBMITTABLE", entryTableName);
                    personRelyMap.put("SUBMITTABLEID", rowSet.getString("FID"));
                    personRelyMap.put("CALITEM", calItem);
                    personRelyMap.put("ISBASIC", 1);
                    personRelyMap.put("SUBMITNUMBER", valueItem);
                    relyList = relyMap.containsKey(personId) ? (List)relyMap.get(personId) : new ArrayList();
                    relyList.add(personRelyMap);
                    relyMap.put(personId, relyList);
                    BigDecimal rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                    BigDecimal sum = null == salaryMap.get(personId) ? money.multiply(rate) : ((BigDecimal)salaryMap.get(personId)).add(money.multiply(rate));
                    salaryMap.put(personId, sum);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(key, salaryMap);
            tempMap.put(relyKey, relyMap);
        }
        personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        salaryMap = (Map)tempMap.get(key);
        IntegrateFunctionUtil.putSubmitDataToParam(ctx, paramMap, tempMap, calItem, relyKey);
        return salaryMap.containsKey(personId) ? ((BigDecimal)salaryMap.get(personId)).doubleValue() : 0.0;
    }

    public double getFillterSubmitDataForCycle(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String elementItemNum, String valueItem) {
        String personId;
        Context ctx = Tools.getInstance().getCtx();
        String key = "getFillterSubmitDataForCycle-" + calScheme.getNumber() + "-" + calSubmitScheme + "--" + valueItem + "-" + elementItemNum;
        String relyKey = "getFillterSubmitDataForCycle-" + calScheme.getNumber() + "-" + calSubmitScheme + "--" + valueItem + "-" + elementItemNum + "-Rely";
        Map<String, BigDecimal> salaryMap = new HashMap();
        HashMap relyMap = new HashMap();
        String calItem = (String)paramMap.get("CALITEM");
        List relyList = new ArrayList();
        if (tempMap.get(key) == null) {
            StringBuilder str = new StringBuilder();
            String entryTableName = IntegrateFunctionUtil.initSubmitSchemeTable(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (null == entryTableName) {
                tempMap.put(key, salaryMap);
                return 0.0;
            }
            SubmitElementInfo elementInfo = this.initElementItem(ctx, tempMap, elementItemNum);
            if (null == elementInfo) {
                tempMap.put(key, salaryMap);
                return 0.0;
            }
            String elementId = elementInfo.getId().toString();
            CalSubmitItemInfo valueItemInfo = IntegrateFunctionUtil.initSubmitItem(ctx, tempMap, valueItem);
            if (null == valueItemInfo) {
                tempMap.put(key, salaryMap);
                return 0.0;
            }
            String valueItemSn = "S" + valueItemInfo.getFieldSn();
            DecimalFormat df = new DecimalFormat(valueItemInfo.getDataDot().toString());
            Set<String> schemeItemSet = IntegrateFunctionUtil.initSchemeItem(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (!schemeItemSet.contains(valueItemInfo.getFieldSn() + "")) {
                tempMap.put(key, salaryMap);
                return 0.0;
            }
            String personFilterSql = this.getPersonFilterSqlForCycle(calScheme, mainTableRowFilter);
            str = new StringBuilder();
            str.append("SELECT CASE WHEN FLASTUPDATETIME IS NULL THEN FCREATETIME ELSE FLASTUPDATETIME END AS FLASTUPDATETIME,FPERSONID,FSALARYPERIOD,FID,FCURRENCYID,").append(valueItemSn);
            str.append(" FROM ").append(entryTableName);
            str.append(personFilterSql);
            str.append(" AND FSubmitElementID ").append(" = '").append(elementId).append("'");
            str.append(" ORDER BY FTransYear desc,FTransMonth desc, FTransTime desc,FPERSONID, FEFFECTDATE DESC, FCREATETIME DESC,FLASTUPDATETIME DESC ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    personId = rowSet.getString("FPersonID");
                    String currencyId = rowSet.getString("FCURRENCYID");
                    if (salaryMap.containsKey(personId)) continue;
                    BigDecimal money = rowSet.getBigDecimal(valueItemSn) == null ? BigDecimal.ZERO : rowSet.getBigDecimal(valueItemSn);
                    HashMap<String, Object> personRelyMap = new HashMap<String, Object>();
                    personRelyMap.put("SUBMITITEMID", elementId);
                    personRelyMap.put("SUBMITITEMTABLE", "T_HR_SSubmitElement");
                    personRelyMap.put("SUBMITMONEY", df.format(money.doubleValue()));
                    personRelyMap.put("SUBMITTABLE", entryTableName);
                    personRelyMap.put("SUBMITTABLEID", rowSet.getString("FID"));
                    personRelyMap.put("CALITEM", calItem);
                    personRelyMap.put("ISBASIC", 1);
                    personRelyMap.put("SUBMITNUMBER", valueItem);
                    relyList = relyMap.containsKey(personId) ? (List)relyMap.get(personId) : new ArrayList();
                    relyList.add(personRelyMap);
                    relyMap.put(personId, relyList);
                    BigDecimal rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                    BigDecimal sum = money.multiply(rate);
                    salaryMap.put(personId, sum);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(key, salaryMap);
            tempMap.put(relyKey, relyMap);
        }
        personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        salaryMap = (Map)tempMap.get(key);
        IntegrateFunctionUtil.putSubmitDataToParam(ctx, paramMap, tempMap, calItem, relyKey);
        return salaryMap.containsKey(personId) ? ((BigDecimal)salaryMap.get(personId)).doubleValue() : 0.0;
    }

    protected boolean isSubmitItemNumType(CalSubmitItemInfo submitItem) {
        return submitItem != null && "0".equals(submitItem.getDataType().getValue());
    }

    public String getSingleSubmitFillterData(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String elementItemNum, String valueItem, String company, double needSubOrg, String beginDate, String endDate) {
        String personId;
        Context ctx = Tools.getInstance().getCtx();
        String curCalSchemeId = calScheme.getId() == null ? "" : calScheme.getId().toString();
        String key = "CalFunctionIntegrateServicegetSingleSubmitFillterData-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + valueItem + "-" + elementItemNum + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate;
        String relyKey = "CalFunctionIntegrateServicegetSingleSubmitFillterData-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + valueItem + "-" + elementItemNum + "-" + company + "-" + needSubOrg + "-" + beginDate + "-" + endDate + "-Rely";
        Map<String, String> salaryMap = new HashMap();
        HashMap relyMap = new HashMap();
        String calItem = (String)paramMap.get("CALITEM");
        List relyList = new ArrayList();
        CalSubmitItemInfo valueItemInfo = IntegrateFunctionUtil.initSubmitItem(ctx, tempMap, valueItem);
        boolean isNumberType = this.isSubmitItemNumType(valueItemInfo);
        if (tempMap.get(key) == null) {
            StringBuilder str = new StringBuilder();
            if (null == valueItemInfo) {
                tempMap.put(key, salaryMap);
                return "";
            }
            String entryTableName = IntegrateFunctionUtil.initSubmitSchemeTable(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (null == entryTableName) {
                tempMap.put(key, salaryMap);
                if (isNumberType) {
                    return "0.00";
                }
                return "";
            }
            SubmitElementInfo elementInfo = this.initElementItem(ctx, tempMap, elementItemNum);
            if (null == elementInfo) {
                tempMap.put(key, salaryMap);
                if (isNumberType) {
                    return "0.00";
                }
                return "";
            }
            String elementId = elementInfo.getId().toString();
            String valueItemSn = "S" + valueItemInfo.getFieldSn();
            DecimalFormat df = new DecimalFormat(valueItemInfo.getDataDot().toString());
            Set<String> schemeItemSet = IntegrateFunctionUtil.initSchemeItem(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (!schemeItemSet.contains(valueItemInfo.getFieldSn() + "")) {
                tempMap.put(key, salaryMap);
                if (isNumberType) {
                    return "0.00";
                }
                return "";
            }
            String personFilterSql = IntegrateFunctionUtil.getPersonFilterSql(calScheme, company, needSubOrg, beginDate, endDate, mainTableRowFilter);
            str = new StringBuilder();
            str.append("SELECT CASE WHEN FLASTUPDATETIME IS NULL THEN FCREATETIME ELSE FLASTUPDATETIME END AS FLASTUPDATETIME,FPERSONID,FSALARYPERIOD,FID,FCURRENCYID,").append(valueItemSn);
            str.append(" FROM ").append(entryTableName);
            str.append(personFilterSql);
            str.append(" AND FSubmitElementID ").append(" = '").append(elementId).append("'");
            str.append(" AND (FCALSCHEMEID =  'YvUYBi3h/Ei6MSRBTt2eXf/N8rE=' or FCALSCHEMEID = '").append(curCalSchemeId).append("')");
            str.append(" ORDER BY FPERSONID, FEFFECTDATE DESC, FCREATETIME DESC,FLASTUPDATETIME DESC ");
            SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
            SimpleDateFormat yearMonthDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            boolean isDate = false;
            boolean dateTypeToDay = false;
            if (valueItemInfo != null && "2".equals(valueItemInfo.getDataType().getValue())) {
                isDate = true;
                if (valueItemInfo != null && 10 == valueItemInfo.getDateType().getValue()) {
                    dateTypeToDay = true;
                }
            }
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                String moneyStr = "";
                while (rowSet.next()) {
                    personId = rowSet.getString("FPersonID");
                    String currencyId = rowSet.getString("FCURRENCYID");
                    if (isDate) {
                        Date date = rowSet.getDate(valueItemSn);
                        if (date != null) {
                            java.util.Date utilDate = new java.util.Date(date.getTime());
                            moneyStr = dateTypeToDay ? yearMonthDateFormat.format(utilDate) : yearMonthFormat.format(utilDate);
                        } else {
                            moneyStr = "";
                        }
                    } else {
                        String string = moneyStr = null == rowSet.getString(valueItemSn) ? "" : rowSet.getString(valueItemSn);
                        if (CalSubmitItemDataType.F7.equals((Object)valueItemInfo.getDataType())) {
                            Map map = (Map)tempMap.get("CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_VAL_" + valueItem);
                            moneyStr = (String)map.get(moneyStr);
                        }
                        if (isNumberType) {
                            BigDecimal money = rowSet.getBigDecimal(valueItemSn);
                            if (money == null) {
                                moneyStr = "0.00";
                            } else {
                                boolean isSQLServerDB = "MS SQL Server".equalsIgnoreCase(ContextUtil.getDbType((Context)ctx));
                                if (isSQLServerDB) {
                                    moneyStr = df.format(money.doubleValue());
                                } else {
                                    String string2 = moneyStr = null == rowSet.getString(valueItemSn) ? "" : rowSet.getString(valueItemSn);
                                }
                            }
                        }
                    }
                    if (salaryMap.containsKey(personId)) continue;
                    salaryMap.put(personId, moneyStr);
                    HashMap<String, Object> personRelyMap = new HashMap<String, Object>();
                    personRelyMap.put("SUBMITMONEY", moneyStr);
                    personRelyMap.put("SUBMITITEMID", elementId);
                    personRelyMap.put("SUBMITITEMTABLE", "T_HR_SSubmitElement");
                    personRelyMap.put("SUBMITTABLE", entryTableName);
                    personRelyMap.put("SUBMITTABLEID", rowSet.getString("FID"));
                    personRelyMap.put("CALITEM", calItem);
                    personRelyMap.put("ISBASIC", 1);
                    personRelyMap.put("SUBMITNUMBER", valueItem);
                    relyList = relyMap.containsKey(personId) ? (List)relyMap.get(personId) : new ArrayList();
                    relyList.add(personRelyMap);
                    relyMap.put(personId, relyList);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(key, salaryMap);
            tempMap.put(relyKey, relyMap);
        }
        personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        salaryMap = (Map)tempMap.get(key);
        IntegrateFunctionUtil.putSubmitDataToParam(ctx, paramMap, tempMap, calItem, relyKey);
        if (salaryMap.containsKey(personId)) {
            return salaryMap.get(personId).toString();
        }
        if (isNumberType) {
            return "0.00";
        }
        return "";
    }

    public double getTimepieceTransferSalaryData(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String calSubmitItem, String company, double needSubOrg, String beginDate, String endDate) throws SQLException, BOSException {
        HashMap salaryMap;
        String curCalSchemeId;
        String key = "TransferSalary:" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate;
        String relyKey = "TransferSalary-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate + "-Rely";
        String string = curCalSchemeId = calScheme.getId() == null ? "" : calScheme.getId().toString();
        if (tempMap.get(key) == null) {
            if (tempMap.get("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA") == null) {
                tempMap.put("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA", this.getAllSubmitItemNumFieldSn());
            }
            String personFilter = IntegrateFunctionUtil.getPersonFilterSql(calScheme, company, needSubOrg, beginDate, endDate, mainTableRowFilter);
            HashMap<String, Object> methodParamMap = new HashMap<String, Object>();
            methodParamMap.put("calSubmitScheme", calSubmitScheme);
            methodParamMap.put("calSubmitItem", calSubmitItem);
            methodParamMap.put("personFilter", personFilter);
            methodParamMap.put("key", key);
            methodParamMap.put("relyKey", relyKey);
            methodParamMap.put("isNumber", true);
            methodParamMap.put("isCycleScheme", false);
            methodParamMap.put("formulaDefine", "FunGetTimepieceTransferSalaryData");
            methodParamMap.put("calSchemeInfo", calScheme);
            this.combineTransSalaryDataNew(tempMap, currencyMap, methodParamMap, curCalSchemeId, SubmitSchemeType.TIMEPIECESUN);
        }
        String calItem = (String)paramMap.get("CALITEM");
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        HashMap submitItemSalaryMap = (HashMap)tempMap.get(key);
        if (submitItemSalaryMap == null) {
            submitItemSalaryMap = new HashMap();
        }
        if ((salaryMap = (HashMap)submitItemSalaryMap.get(calSubmitItem)) == null) {
            salaryMap = new HashMap();
        }
        Context ctx = Tools.getInstance().getCtx();
        IntegrateFunctionUtil.putSubmitDataToParamNew(ctx, paramMap, tempMap, calItem, relyKey, calSubmitItem);
        if (salaryMap.containsKey(personId)) {
            return salaryMap.get(personId) == null ? 0.0 : ((BigDecimal)salaryMap.get(personId)).doubleValue();
        }
        return 0.0;
    }

    public String getTimepieceTransferSalaryDataString(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String calSubmitItem, String company, double needSubOrg, String beginDate, String endDate) throws SQLException, BOSException {
        HashMap salaryMap;
        String curCalSchemeId;
        String key = "TransferSalaryDataString-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate;
        String relyKey = "TransferSalaryDataString-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate + "-Rely";
        String string = curCalSchemeId = calScheme.getId() == null ? "" : calScheme.getId().toString();
        if (tempMap.get(key) == null) {
            if (tempMap.get("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA") == null) {
                tempMap.put("ALL_SUBMIT_ITEM_NUM_FIELDSN_KEY_FUBMITFORMULA", this.getAllSubmitItemNumFieldSn());
            }
            String personFilter = IntegrateFunctionUtil.getPersonFilterSql(calScheme, company, needSubOrg, beginDate, endDate, mainTableRowFilter);
            HashMap<String, Object> methodParamMap = new HashMap<String, Object>();
            methodParamMap.put("calSubmitScheme", calSubmitScheme);
            methodParamMap.put("calSubmitItem", calSubmitItem);
            methodParamMap.put("personFilter", personFilter);
            methodParamMap.put("key", key);
            methodParamMap.put("relyKey", relyKey);
            methodParamMap.put("isNumber", false);
            methodParamMap.put("isCycleScheme", false);
            methodParamMap.put("formulaDefine", "FunGetTimepieceTransferSalaryDataString");
            methodParamMap.put("calSchemeInfo", calScheme);
            this.combineTransSalaryDataNew(tempMap, this.currencyMap, methodParamMap, curCalSchemeId, SubmitSchemeType.TIMEPIECESUN);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String calItem = (String)paramMap.get("CALITEM");
        HashMap submitItemSalaryMap = (HashMap)tempMap.get(key);
        if (submitItemSalaryMap == null) {
            submitItemSalaryMap = new HashMap();
        }
        if ((salaryMap = (HashMap)submitItemSalaryMap.get(calSubmitItem)) == null) {
            salaryMap = new HashMap();
        }
        Context ctx = Tools.getInstance().getCtx();
        IntegrateFunctionUtil.putSubmitDataToParamNew(ctx, paramMap, tempMap, calItem, relyKey, calSubmitItem);
        if (salaryMap.containsKey(personId)) {
            Object salaryObj = salaryMap.get(personId);
            if (salaryObj instanceof BigDecimal) {
                return ((BigDecimal)salaryObj).toString();
            }
            if (salaryObj == null) {
                return "";
            }
            return (String)salaryObj;
        }
        return "";
    }

    static {
        FORMULA_DEFINE_LIST_FUNC_MAPPER.put("FunGetTransferSalaryData", "gfoAAAAINZAkATlo");
        FORMULA_DEFINE_LIST_FUNC_MAPPER.put("FunGetTransferSalaryDataString", "4i4AAAAFCSQkATlo");
        FORMULA_DEFINE_LIST_FUNC_MAPPER.put("FunGetTransferSalaryDataForCycle", "4i4AAAAjaRYkATlo");
        FORMULA_DEFINE_LIST_FUNC_MAPPER.put("FunGetTimepieceTransferSalaryData", "ZL0WMWwSQAuiJSfa74SWZiQBOWg=");
        FORMULA_DEFINE_LIST_FUNC_MAPPER.put("FunGetTimepieceTransferSalaryDataString", "DBCoY3U1SqOsJIz/J7gi2CQBOWg=");
    }
}

