/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;

public class CmpSqlTransfer {
    public static void transferSql2TempTable2(Context ctx, String sql, String tempTableName) throws SQLException, BOSException {
        String excuteSql;
        int orderIndex = sql.toUpperCase(Locale.ENGLISH).indexOf("ORDER BY");
        if (orderIndex != -1) {
            sql = sql.substring(0, orderIndex);
        }
        String createTablesql = "select t.* from (" + sql + ") t where 1<>1";
        Connection conn = EJBFactory.getConnection((Context)ctx);
        DatabaseMetaData metaData = conn.getMetaData();
        if (metaData != null) {
            String dbName = metaData.getDatabaseProductName();
            int databaseMajorVersion = metaData.getDatabaseMajorVersion();
            excuteSql = dbName != null && "Oracle".equalsIgnoreCase(dbName) && databaseMajorVersion == 11 ? MessageFormat.format("select * into {0} from ( {1} ) TTT where rownum > -1 ", tempTableName, createTablesql) : MessageFormat.format("select * into {0} from ( {1} ) TTT ", tempTableName, createTablesql);
        } else {
            excuteSql = MessageFormat.format("select * into {0} from ( {1} ) TTT ", tempTableName, createTablesql);
        }
        CmpSQLUtil.execute(ctx, excuteSql);
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int colsCount = rsMetaData.getColumnCount();
        String[] colsTypeNameArr = new String[colsCount];
        StringBuffer selectors = new StringBuffer();
        for (int i = 1; i <= colsCount; ++i) {
            String columnTypeName;
            colsTypeNameArr[i - 1] = columnTypeName = rsMetaData.getColumnTypeName(i);
            selectors.append("\"");
            selectors.append(rsMetaData.getColumnName(i)).append("\",");
        }
        StringBuilder insertTempSql = new StringBuilder("insert into ").append(tempTableName).append("(" + selectors.deleteCharAt(selectors.length() - 1) + ")").append(" values(");
        for (int i = 0; i < colsCount; ++i) {
            insertTempSql.append("?,");
        }
        insertTempSql.deleteCharAt(insertTempSql.length() - 1);
        insertTempSql.append(");");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] param = new Object[colsCount];
            for (int i = 1; i <= colsCount; ++i) {
                BigDecimal bigDecimal;
                String value = rs.getString(i);
                if (value == null || StringUtils.isBlank((CharSequence)value)) {
                    param[i - 1] = null;
                    continue;
                }
                String type = colsTypeNameArr[i - 1];
                if ("number".equalsIgnoreCase(type) || "decimal".equalsIgnoreCase(type) || "numeric".equalsIgnoreCase(type) || "DEC".equalsIgnoreCase(type)) {
                    bigDecimal = new BigDecimal(value);
                    param[i - 1] = bigDecimal.doubleValue();
                    continue;
                }
                if ("float".equalsIgnoreCase(type)) {
                    bigDecimal = new BigDecimal(value);
                    param[i - 1] = Float.valueOf(bigDecimal.floatValue());
                    continue;
                }
                if ("int".equalsIgnoreCase(type) || "int4".equalsIgnoreCase(type)) {
                    bigDecimal = new BigDecimal(value);
                    param[i - 1] = bigDecimal.intValue();
                    continue;
                }
                if ("datetime".equalsIgnoreCase(type) || "timestamp".equalsIgnoreCase(type) || "date".equalsIgnoreCase(type)) {
                    Date date = rs.getDate(i);
                    if (date == null) continue;
                    param[i - 1] = new Date(date.getTime());
                    continue;
                }
                param[i - 1] = value;
            }
            paramList.add(param);
        }
        CmpSQLUtil.executeBatch(ctx, insertTempSql.toString(), paramList);
    }
}

