/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.pc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxBasePCService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.tax.pc.TaxBasePCService");

    public BatchMessageTipsHeader auidt(Context ctx, String billIds, int type) throws BOSException, EASBizException {
        Object[] param;
        BatchMessageTipsBody tipBody;
        String typeStr = type == 10 || type == 20 ? "10, 20" : type + "";
        StringBuilder invalidStr = new StringBuilder();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        HashMap<String, String> loseMap = new HashMap<String, String>();
        BatchMessageTipsHeader tipHeader = new BatchMessageTipsHeader();
        int success = 0;
        int failure = 0;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Calendar calendar = Calendar.getInstance();
        String sqlIds = CmpStrUtil.converStringToSqlString(billIds, ",");
        int addMonth = TaxUtil.getEffdtMonth(ctx);
        calendar.add(2, addMonth);
        int auidtYear = calendar.get(1);
        int auidtMonth = calendar.get(2) + 1;
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuilder str = new StringBuilder();
        str.append(" select per.FName_" + l + " name, oldT.FEffdtYear, oldT.FEffdtMonth, newT.Fid id ");
        str.append(" from T_HR_STaxBase oldT ");
        str.append(" inner join T_HR_STaxBase newT on oldT.FPersonid = newT.FPersonId and newT.FType in (").append(typeStr).append(") ");
        str.append(" inner join T_BD_Person per on oldT.FPersonId = per.Fid ");
        str.append(" where newT.Fid in (").append(sqlIds).append(") and newT.FState = ").append(20);
        str.append(" and ((oldT.FEffdtYear = ").append(auidtYear).append(" and oldT.FEffdtMonth > ").append(auidtMonth).append(") ");
        str.append(" or oldT.FEffdtYear > ").append(auidtYear).append(") ");
        str.append(" and oldT.FState = ").append(30);
        str.append(" and oldT.FType in (").append(typeStr).append(") ");
        String exist = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"exist", (Locale)ctx.getLocale());
        String valild = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"valild", (Locale)ctx.getLocale());
        IRowSet r = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (r.next()) {
                ++failure;
                tipBody = new BatchMessageTipsBody();
                tipBody.setMuitTipsState(false);
                tipBody.setMuitTipsMessage("Name\uff1a" + r.getString(1) + "," + exist + r.getInt(2) + "month" + r.getInt(3) + "year" + valild);
                tipHeader.addResult(tipBody);
                invalidStr.append("'").append(r.getString("id")).append("',");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        String invalidIds = invalidStr.length() > 0 ? invalidStr.substring(0, invalidStr.length() - 1) : null;
        str = new StringBuilder();
        paramsList = new ArrayList();
        String updateSql = " update T_HR_STaxBase set FState = ?, FDataState = ?, FLeffdtYear = ?, FLeffdtMonth = ? where fid = ? ";
        str.append(" select oldT.fid, oldT.FPersonId ");
        str.append(" from T_HR_STaxBase oldT ");
        str.append(" inner join T_HR_STaxBase newT on oldT.FPersonid = newT.FPersonid and newT.FType in (").append(typeStr).append(") ");
        str.append(" where oldT.FEffdtYear = " + auidtYear + " and oldT.FEffdtMonth  = " + auidtMonth);
        str.append(" and newT.fid in (").append(sqlIds).append(") and newT.FState = ").append(20);
        str.append(" and oldT.FType in (").append(typeStr).append(") ");
        if (!StringUtils.isEmpty((String)invalidIds)) {
            str.append(" and newT.fid not in (").append(invalidIds).append(") ");
        }
        str.append(" and oldT.FState in (30, 40)");
        IRowSet r1 = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (r1.next()) {
                param = new Object[]{40, 0, auidtYear, auidtMonth, r1.getString("fid")};
                paramsList.add(param);
                updateMap.put(r1.getString("FPersonId"), "");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.add(2, addMonth - 1);
        updateSql = " update T_HR_STaxBase set FState = ?, FLeffdtYear = ?, FLeffdtMonth = ? where fid = ?";
        paramsList = new ArrayList();
        str = new StringBuilder();
        str.append(" select distinct oldT.fid, oldT.FPersonId ");
        str.append(" from T_HR_STaxBase oldT ");
        str.append(" inner join T_HR_STaxBase newT on newT.FPersonId = oldT.FPersonId and newT.FType in (").append(typeStr).append(") ");
        str.append(" where newT.fid in (").append(sqlIds).append(") and newT.FState = ").append(20);
        str.append(" and oldT.FType in (").append(typeStr).append(") ");
        if (!StringUtils.isEmpty((String)invalidIds)) {
            str.append(" and newT.fid not in (").append(invalidIds).append(") ");
        }
        str.append(" and oldT.FState = ").append(30);
        str.append(" and ((oldT.FEffdtYear = ").append(auidtYear).append(" and oldT.FEffdtMonth < ").append(auidtMonth).append(") ");
        str.append(" or oldT.FEffdtYear < ").append(auidtYear).append(") ");
        IRowSet r2 = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (r2.next()) {
                param = new Object[]{40, calendar1.get(1), calendar1.get(2) + 1, r2.getString("fid")};
                paramsList.add(param);
                loseMap.put(r2.getString("FPersonId"), "");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
        paramsList = new ArrayList();
        updateSql = " update T_HR_STaxBase set FState = ?,  FEffdtYear = ?,  FEffdtMonth = ? where fid = ?";
        str = new StringBuilder();
        str.append(" select tb.fid, tb.FPersonId, per.FName_" + l + " name from T_HR_STaxBase tb ");
        str.append(" inner join T_BD_Person per on tb.FPersonId = per.fid ");
        str.append(" where tb.fid in (").append(sqlIds).append(") ");
        str.append(" and tb.FState = ").append(20);
        if (!StringUtils.isEmpty((String)invalidIds)) {
            str.append(" and tb.fid not in (").append(invalidIds).append(") ");
        }
        IRowSet r3 = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        String discard = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"discard", (Locale)ctx.getLocale());
        String succuss = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"succuss", (Locale)ctx.getLocale());
        String invalid = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"invalid", (Locale)ctx.getLocale());
        String msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"msg", (Locale)ctx.getLocale());
        try {
            while (r3.next()) {
                String personId = r3.getString("FPersonId");
                String message = r3.getString("name") + "," + succuss;
                param = new Object[]{30, auidtYear, auidtMonth, r3.getString("fid")};
                paramsList.add(param);
                ++success;
                tipBody = new BatchMessageTipsBody();
                tipBody.setMuitTipsState(true);
                if (updateMap.containsKey(personId)) {
                    message = message + "," + exist + auidtYear + "month" + auidtMonth + discard;
                } else if (loseMap.containsKey(personId)) {
                    message = message + msg + calendar1.get(1) + "year" + (calendar1.get(2) + 1) + invalid;
                }
                tipBody.setMuitTipsMessage(message);
                tipHeader.addResult(tipBody);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
        tipHeader.setSuccessCount(success);
        tipHeader.setFailureCount(failure);
        return tipHeader;
    }
}

