/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCollection;
import com.kingdee.shr.compensation.app.tax.base.TaxItemInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.taxCal.ISumPersonTaxData;
import com.kingdee.shr.compensation.taxCal.util.TaxItemUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SumTaxDataForJS
implements ISumPersonTaxData {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.taxCal.SumTaxDataForJS");
    private Map<String, String> taskMap;
    private List<TaxCalTaskInfo> taskInfoList;
    private Map<String, Map<String, Object>> dataMap;
    private List<String> sumTaxList;
    private List<String> allTaxItemList;
    private List<String> updateCalIdList;
    private static final int FIXED_PARA_COUNT = 14;
    private String userId;

    @Override
    public TaxCalTaskInfo execute(Context ctx, String initIds) throws BOSException {
        this.userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        this.updateAcceptId(ctx, initIds);
        this.getInitTaskMap(ctx, initIds);
        this.getTaxItem(ctx);
        String insertSql = this.getInsertTaskDetailSql();
        List<Object[]> paramsList = this.getParamListData(ctx, initIds);
        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_STAXCALINITDETAIL SET FSTATE = 30 WHERE FID IN (" + initIds + ") and FState = 10 "));
        this.updateTaxCalInitData(ctx);
        return null;
    }

    private void updateAcceptId(Context ctx, String initIds) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" update T_HR_STAXCALINITDETAIL detail set FAcceptId = (");
        str.append(" select FAcceptId from T_HR_STaxPersonRecordEntry entry ");
        str.append(" where detail.FTaxUnitId = entry.FTaxUnitId and detail.FPersonId = entry.FPersonId) ");
        str.append(" where fid in (" + initIds + ") ");
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private void updateTaxCalInitData(Context ctx) throws BOSException {
        ArrayList paramsList = new ArrayList();
        String sql = "update T_HR_STaxCalInitDetail set FState = ? where FCmpCalTableID = ?";
        for (int i = 0; i < this.updateCalIdList.size(); ++i) {
            Object[] param = new Object[]{30, this.updateCalIdList.get(i)};
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    private void getTaxItem(Context ctx) {
        this.allTaxItemList = new ArrayList<String>();
        this.sumTaxList = new ArrayList<String>();
        TaxItemCollection itemColl = TaxItemUtil.getAllTaxItem(ctx, true);
        for (int i = 0; i < itemColl.size(); ++i) {
            TaxItemInfo info = itemColl.get(i);
            this.allTaxItemList.add("T." + info.getFieldSn());
            boolean isSum = info.isIsSum();
            if (!isSum) continue;
            this.sumTaxList.add("T." + info.getFieldSn());
        }
    }

    private void combineRowData(IRowSet rowSet) {
        this.dataMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        String key = null;
        try {
            key = rowSet.getString("FTAXUNITID") + "_" + rowSet.getString("FINCOMEITEMID") + "_" + rowSet.getString("ACCEPTID") + "_" + rowSet.getString("FPERSONID");
            for (int i = 0; i < this.allTaxItemList.size(); ++i) {
                rowMap.put(this.allTaxItemList.get(i), rowSet.getBigDecimal(this.allTaxItemList.get(i)));
            }
            rowMap.put("FCMPCALTABLEID", rowSet.getString("FCMPCALTABLEID"));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dataMap.put(key, rowMap);
    }

    private void getSubmitedData(Context ctx, String initIds) throws BOSException {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.sumTaxList.size(); ++i) {
            str.append("SUM(").append(this.sumTaxList.get(i)).append(") ").append(this.sumTaxList.get(i)).append(",");
        }
        String sumItems = str.substring(0, str.length() - 1);
        str = new StringBuilder();
        str = new StringBuilder();
        str.append(" SELECT FPERSONID, FTAXUNITID, FINCOMEITEMID, ").append(sumItems);
        str.append(" FROM T_HR_STAXCALINITDETAIL DETAIL ");
        str.append(" WHERE DETAIL.FSTATE = ").append(40);
        str.append(" AND DETAIL.FID IN (").append(initIds).append("))");
        str.append(" GROUP BY FPERSONID, FTAXUNITID, FINCOMEITEMID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                this.combineRowData(rowSet);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void getInitTaskMap(Context ctx, String initIds) throws BOSException {
        this.taskMap = new HashMap<String, String>();
        StringBuilder str = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        str.append(" SELECT FTAXUNITID, FINCOMEITEMID, FPERIODBEGIN, FACCEPTID ");
        str.append(" FROM T_HR_STAXCALINITDETAIL ");
        str.append(" WHERE FSTATE IN (10,20,50) ");
        str.append(" AND FID IN (").append(initIds).append(")");
        str.append(" GROUP BY FTAXUNITID, FINCOMEITEMID, FPERIODBEGIN ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                String taskId = BOSUuid.create((String)"EDCB1CD1").toString();
                this.taskMap.put(rowSet.getString("FTAXUNITID") + "_" + rowSet.getString("FINCOMEITEMID") + "_" + rowSet.getString("FACCEPTID"), taskId);
                calendar.setTime(rowSet.getDate("FPERIODBEGIN"));
                TaxCalTaskInfo taskInfo = new TaxCalTaskInfo();
                taskInfo.setId(BOSUuid.read((String)taskId));
                TaxUnitInfo taxUnitInfo = new TaxUnitInfo();
                taxUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FTAXUNITID")));
                taskInfo.setTaxUnit(taxUnitInfo);
                taskInfo.setPeriod(calendar.get(1) + "_" + calendar.get(2));
                this.taskInfoList.add(taskInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String getOncePersonTemp(Context ctx, String initIds) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" SELECT FID FROM T_HR_STAXCALINITDETAIL A01 WHERE EXISTS(");
        str.append(" SELECT 1 ");
        str.append(" FROM T_HR_STAXCALINITDETAIL A02 ");
        str.append(" WHERE A02.FID IN (").append(initIds).append(")");
        str.append(" AND A02.FSTATE IN (10, 50) ");
        str.append(" AND A01.FPERSONID = A02.FPERSONID AND A01.FTAXUNITID = A02.FTAXUNITID AND A01.FINCOMEITEMID = A02.FINCOMEITEMID ");
        str.append(" GROUP BY FPERSONID, FTAXUNITID, FINCOMEITEMID ");
        str.append(" HAVING COUNT(1) <= 1) ");
        str.append(" WHERE A01.FID IN (").append(initIds).append(")");
        str.append(" AND A01.FSTATE IN (10, 50) ");
        String tempName = SQLHandleUtil.getTempTableForName(ctx, str.toString());
        return tempName;
    }

    private List<Object[]> getParamListData(Context ctx, String initIds) throws BOSException {
        Object[] param;
        String taskId;
        String taxKey;
        String acceptId;
        String incomeItemId;
        String taxUnitId;
        this.updateCalIdList = new ArrayList<String>();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String personKey = null;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.allTaxItemList.size(); ++i) {
            str.append(",?");
        }
        String taxItem = str.toString();
        this.getSubmitedData(ctx, initIds);
        String tempName = this.getOncePersonTemp(ctx, initIds);
        str = new StringBuilder();
        str.append(" SELECT FCMPCALTABLEID, FPERSONID, FTAXUNITID, FPERIODBEGIN, FPERIODEND, ");
        str.append(" FINCOMEITEMID, FID, FACCEPTID ").append(taxItem);
        str.append(" FROM T_HR_STAXCALINITDETAIL WHERE FID IN (SELECT FID FROM " + tempName + ") ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                taxUnitId = rowSet.getString("FTAXUNITID");
                incomeItemId = rowSet.getString("FINCOMEITEMID");
                acceptId = rowSet.getString("FACCEPTID");
                taxKey = taxUnitId + "_" + incomeItemId + "_" + acceptId;
                personKey = taxKey + "_" + rowSet.getString("FPERSONID");
                taskId = this.taskMap.get(taxKey);
                param = this.sumLastData(rowSet, personKey, taskId);
                paramsList.add(param);
                this.updateCalIdList.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        HashSet<String> personSet = new HashSet<String>();
        str = new StringBuilder();
        str.append(" SELECT FCMPCALTABLEID, FPERSONID, FTAXUNITID, FPERIODBEGIN, FPERIODEND, ");
        str.append(" FINCOMEITEMID,FID, FACCEPTID ").append(taxItem);
        str.append(" FROM T_HR_STAXCALINITDETAIL WHERE FID NOT IN (SELECT FID FROM " + tempName + ") ");
        str.append(" AND FID IN (").append(initIds).append(")");
        str.append(" AND FSTATE IN (10, 50) ");
        str.append(" ORDER BY FTAXUNITID, FINCOMEITEMID, FPERSONID, FCREATETIME ");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                taxUnitId = rowSet.getString("FTAXUNITID");
                incomeItemId = rowSet.getString("FINCOMEITEMID");
                acceptId = rowSet.getString("FACCEPTID");
                taxKey = taxUnitId + "_" + incomeItemId + "_" + acceptId;
                personKey = taxKey + rowSet.getString("FPERSONID");
                if (personSet.contains(personKey)) continue;
                personSet.add(personKey);
                taskId = this.taskMap.get(taxKey);
                param = this.sumLastData(rowSet, personKey, taskId);
                paramsList.add(param);
                this.updateCalIdList.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        return paramsList;
    }

    private String getInsertTaskDetailSql() {
        StringBuilder str = new StringBuilder();
        StringBuilder itemStr = new StringBuilder();
        for (int i = 0; i < this.allTaxItemList.size(); ++i) {
            str.append(this.allTaxItemList.get(i)).append(",");
            itemStr.append(",?");
        }
        String taxItems = str.substring(0, str.length() - 1);
        str = new StringBuilder();
        str.append(" INSERT INTO T_HR_STAXCALTASKDETAIL(FID, FCALTASKID, FRELAYID, FCMPCALTABLEID, FPERSONID, ");
        str.append(" FTAXUNITID, FPERIODBEGIN, FPERIODEND, FINCOMEITEMID, FACCEPTID, ");
        str.append(" FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, ").append(taxItems);
        str.append(" )");
        str.append(" values(?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ? ");
        str.append((CharSequence)itemStr);
        str.append(")");
        return str.toString();
    }

    private Object[] sumLastData(IRowSet rowSet, String key, String taskId) throws BOSException, SQLException {
        Date createTime = new Date(new java.util.Date().getTime());
        Map<Object, Object> rowMap = new HashMap();
        if (this.dataMap.containsKey(key)) {
            rowMap = this.dataMap.get(key);
            for (int i = 0; i < this.sumTaxList.size(); ++i) {
                rowMap.put(this.sumTaxList.get(i), rowSet.getBigDecimal(this.sumTaxList.get(i)).add((BigDecimal)rowMap.get(this.sumTaxList.get(i))));
            }
            this.dataMap.put(key, rowMap);
        } else {
            this.combineRowData(rowSet);
            rowMap = this.dataMap.get(key);
        }
        Object[] param = new Object[14 + this.allTaxItemList.size()];
        param[0] = BOSUuid.create((String)"01CB8082").toString();
        param[1] = taskId;
        param[2] = rowMap.get("FCMPCALTABLEID");
        param[3] = rowSet.getString("FCMPCALTABLEID");
        param[4] = rowSet.getString("FPERSONID");
        param[5] = rowSet.getString("FTAXUNITID");
        param[6] = rowSet.getString("FPERIODBEGIN");
        param[7] = rowSet.getString("FPERIODEND");
        param[8] = rowSet.getString("FINCOMEITEMID");
        param[9] = rowSet.getString("ACCEPTID");
        param[10] = this.userId;
        param[11] = createTime;
        param[12] = this.userId;
        param[13] = createTime;
        for (int i = 0; i < this.allTaxItemList.size(); ++i) {
            param[14 + i] = rowMap.containsKey(this.allTaxItemList.get(i)) ? rowMap.get(this.allTaxItemList.get(i)) : rowSet.getBigDecimal(this.allTaxItemList.get(i));
        }
        return param;
    }
}

